// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('imcljs.internal.utils');
goog.require('cljs.core');
goog.require('clojure.string');
imcljs.internal.utils.does_not_contain_QMARK_ = cljs.core.complement(cljs.core.contains_QMARK_);
imcljs.internal.utils.one_of_QMARK_ = (function imcljs$internal$utils$one_of_QMARK_(haystack,needle){
return cljs.core.some_QMARK_(cljs.core.some(cljs.core.PersistentHashSet.fromArray([needle], true),haystack));
});
imcljs.internal.utils.missing_http_QMARK__ = (function imcljs$internal$utils$missing_http_QMARK__(val){
return cljs.core.not(cljs.core.re_find(/^https?:\/\//,val));
});
imcljs.internal.utils.missing_service_QMARK__ = (function imcljs$internal$utils$missing_service_QMARK__(val){
return cljs.core.not(cljs.core.re_find(/\/service$/,val));
});
imcljs.internal.utils.append_ = (function imcljs$internal$utils$append_(text,val){
return [cljs.core.str(val),cljs.core.str(text)].join('');
});
imcljs.internal.utils.alphabet = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_set,clojure.string.split.cljs$core$IFn$_invoke$arity$2("ABCDEFGHIJKLMNOPQRSTUVWXYZ",""));
/**
 * Ensures that a url starts with an http protocol and ends with /service
 */
imcljs.internal.utils.scrub_url = (function imcljs$internal$utils$scrub_url(url){
var G__23430 = url;
var G__23430__$1 = (cljs.core.truth_(imcljs.internal.utils.missing_http_QMARK__(url))?[cljs.core.str("http://"),cljs.core.str(G__23430)].join(''):G__23430);
if(cljs.core.truth_(imcljs.internal.utils.missing_service_QMARK__(url))){
return imcljs.internal.utils.append_("/service",G__23430__$1);
} else {
return G__23430__$1;
}
});
