// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('redgenes.components.querybuilder.events');
goog.require('cljs.core');
goog.require('com.rpl.specter');
goog.require('imcljsold.search');
goog.require('clojure.zip');
goog.require('cljs.core.async');
goog.require('imcljsold.filters');
goog.require('clojure.string');
goog.require('redgenes.utils');
goog.require('redgenes.components.querybuilder.core');
goog.require('cljs.spec');
goog.require('re_frame.core');
redgenes.components.querybuilder.events.child_classes = (function redgenes$components$querybuilder$events$child_classes(c){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$referencedType.cljs$core$IFn$_invoke$arity$1(c));
});
redgenes.components.querybuilder.events.nth_child = (function redgenes$components$querybuilder$events$nth_child(z,idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.iterate(clojure.zip.right,z),idx);
});
redgenes.components.querybuilder.events.parse_long = (function redgenes$components$querybuilder$events$parse_long(s){
return Number.parseFloat(s);
});
/**
 * Reset the query to empty
 */
redgenes.components.querybuilder.events.reset_query = (function redgenes$components$querybuilder$events$reset_query(db,p__29619){
var vec__29623 = p__29619;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29623,(0),null);
var count = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29623,(1),null);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$query], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$q_SLASH_select,cljs.core.PersistentHashSet.EMPTY,cljs.core.cst$kw$q_SLASH_where,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$constraint_DASH_paths,cljs.core.PersistentHashSet.EMPTY], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$count], null),null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$used_DASH_codes], null),null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$where_DASH_tree], null),null);
});
/**
 * Updates the Webservice query
 *   from the given Spec query
 */
redgenes.components.querybuilder.events.update_io_query = (function redgenes$components$querybuilder$events$update_io_query(p__29626,_){
var map__29631 = p__29626;
var map__29631__$1 = ((((!((map__29631 == null)))?((((map__29631.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29631.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29631):map__29631);
var db = map__29631__$1;
var map__29632 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29631__$1,cljs.core.cst$kw$query_DASH_builder);
var map__29632__$1 = ((((!((map__29632 == null)))?((((map__29632.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29632.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29632):map__29632);
var query = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29632__$1,cljs.core.cst$kw$query);
if(cljs.core.truth_(cljs.spec.valid_QMARK_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$q_SLASH_query,query))){
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$io_DASH_query], null),redgenes.components.querybuilder.core.build_query(query));
} else {
return db;
}
});
/**
 * Add a where clause
 */
redgenes.components.querybuilder.events.add_constraint = (function redgenes$components$querybuilder$events$add_constraint(db,p__29635){
var vec__29639 = p__29635;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29639,(0),null);
var constraint = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29639,(1),null);
var used_codes = cljs.core.last(cljs.core.sort.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$q_SLASH_code,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$query,cljs.core.cst$kw$q_SLASH_where], null)))));
var next_code = (((used_codes == null))?"A":redgenes.components.querybuilder.core.next_code(used_codes));
return cljs.core.assoc_in(cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$query,cljs.core.cst$kw$constraint_DASH_paths], null),((function (used_codes,next_code,vec__29639,_,constraint){
return (function (cs){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__7219__auto__ = cs;
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})(),cljs.core.cst$kw$q_SLASH_path.cljs$core$IFn$_invoke$arity$1(constraint));
});})(used_codes,next_code,vec__29639,_,constraint))
),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$query,cljs.core.cst$kw$q_SLASH_where], null),((function (used_codes,next_code,vec__29639,_,constraint){
return (function (where){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__7219__auto__ = where;
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([constraint,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$q_SLASH_code,next_code], null)], 0)));
});})(used_codes,next_code,vec__29639,_,constraint))
),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$constraint], null),null);
});
/**
 * Adds a where clause, runs the query
 */
redgenes.components.querybuilder.events.add_constraint_cofx = (function redgenes$components$querybuilder$events$add_constraint_cofx(p__29642,event){
var map__29645 = p__29642;
var map__29645__$1 = ((((!((map__29645 == null)))?((((map__29645.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29645.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29645):map__29645);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29645__$1,cljs.core.cst$kw$db);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,redgenes.components.querybuilder.events.update_io_query(redgenes.components.querybuilder.events.add_constraint(db,event),event),cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder_SLASH_run_DASH_query_BANG_], null)], null);
});
/**
 * Returns the given db with the :q/where constraint value at given index
 *   changed to given value
 */
redgenes.components.querybuilder.events.change_constraint_value = (function redgenes$components$querybuilder$events$change_constraint_value(var_args){
var args29647 = [];
var len__8435__auto___29658 = arguments.length;
var i__8436__auto___29659 = (0);
while(true){
if((i__8436__auto___29659 < len__8435__auto___29658)){
args29647.push((arguments[i__8436__auto___29659]));

var G__29660 = (i__8436__auto___29659 + (1));
i__8436__auto___29659 = G__29660;
continue;
} else {
}
break;
}

var G__29649 = args29647.length;
switch (G__29649) {
case 3:
return redgenes.components.querybuilder.events.change_constraint_value.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return redgenes.components.querybuilder.events.change_constraint_value.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29647.length)].join('')));

}
});

redgenes.components.querybuilder.events.change_constraint_value.cljs$core$IFn$_invoke$arity$3 = (function (_,db,p__29650){
var vec__29651 = p__29650;
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29651,(0),null);
var index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29651,(1),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29651,(2),null);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$explanation,[cljs.core.str("change constraint value to "),cljs.core.str(value)].join(''),cljs.core.cst$kw$count,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$count], null)),cljs.core.cst$kw$dcount,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$dcount], null))], null);
});

redgenes.components.querybuilder.events.change_constraint_value.cljs$core$IFn$_invoke$arity$2 = (function (db,p__29654){
var vec__29655 = p__29654;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29655,(0),null);
var index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29655,(1),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29655,(2),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$query,cljs.core.cst$kw$q_SLASH_where,index,cljs.core.cst$kw$q_SLASH_value], null),value);
});

redgenes.components.querybuilder.events.change_constraint_value.cljs$lang$maxFixedArity = 3;

/**
 * Returns the given db with the :q/where constraint op at given index
 *   changed to given value
 */
redgenes.components.querybuilder.events.change_constraint_op = (function redgenes$components$querybuilder$events$change_constraint_op(var_args){
var args29662 = [];
var len__8435__auto___29673 = arguments.length;
var i__8436__auto___29674 = (0);
while(true){
if((i__8436__auto___29674 < len__8435__auto___29673)){
args29662.push((arguments[i__8436__auto___29674]));

var G__29675 = (i__8436__auto___29674 + (1));
i__8436__auto___29674 = G__29675;
continue;
} else {
}
break;
}

var G__29664 = args29662.length;
switch (G__29664) {
case 3:
return redgenes.components.querybuilder.events.change_constraint_op.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return redgenes.components.querybuilder.events.change_constraint_op.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29662.length)].join('')));

}
});

redgenes.components.querybuilder.events.change_constraint_op.cljs$core$IFn$_invoke$arity$3 = (function (_,db,p__29665){
var vec__29666 = p__29665;
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29666,(0),null);
var index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29666,(1),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29666,(2),null);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$explanation,[cljs.core.str("change constraint op to "),cljs.core.str(op)].join(''),cljs.core.cst$kw$count,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$count], null)),cljs.core.cst$kw$dcount,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$dcount], null))], null);
});

redgenes.components.querybuilder.events.change_constraint_op.cljs$core$IFn$_invoke$arity$2 = (function (db,p__29669){
var vec__29670 = p__29669;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29670,(0),null);
var index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29670,(1),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29670,(2),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$query,cljs.core.cst$kw$q_SLASH_where,index,cljs.core.cst$kw$q_SLASH_op], null),op);
});

redgenes.components.querybuilder.events.change_constraint_op.cljs$lang$maxFixedArity = 3;

/**
 * 
 */
redgenes.components.querybuilder.events.set_where_path = (function redgenes$components$querybuilder$events$set_where_path(db,p__29677){
var vec__29681 = p__29677;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29681,(0),null);
var path = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29681,(1),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$query,cljs.core.cst$kw$path], null),path);
});
/**
 * Adds the count & difference in count (dcount)
 */
redgenes.components.querybuilder.events.handle_count = (function redgenes$components$querybuilder$events$handle_count(db,p__29684){
var vec__29689 = p__29684;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29689,(0),null);
var count = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29689,(1),null);
var count__$1 = (function (){try{return redgenes.components.querybuilder.events.parse_long(count);
}catch (e29692){if((e29692 instanceof Error)){
var e = e29692;
return e;
} else {
throw e29692;

}
}})();
var pcount = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$count], null));
var dc = (((typeof count__$1 === 'number') && (typeof pcount === 'number'))?(count__$1 - pcount):(0));
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$count], null),count__$1),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$dcount], null),dc),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$counting_QMARK_], null),false);
});
/**
 * Returns a cofx for running the query
 */
redgenes.components.querybuilder.events.run_query_cofx = (function redgenes$components$querybuilder$events$run_query_cofx(p__29693){
var map__29696 = p__29693;
var map__29696__$1 = ((((!((map__29696 == null)))?((((map__29696.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29696.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29696):map__29696);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29696__$1,cljs.core.cst$kw$db);
var query_data = cljs.core.cst$kw$query.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$query_DASH_builder.cljs$core$IFn$_invoke$arity$1(db));
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$counting_QMARK_], null),true),cljs.core.cst$kw$query_DASH_builder_SLASH_maybe_DASH_run_DASH_query_BANG_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$query,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$query], null)),cljs.core.cst$kw$query_QMARK_,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$autoupdate_QMARK_], null))], null)], null);
});
/**
 * Returns a cofx for maybe running the query
 */
redgenes.components.querybuilder.events.maybe_run_query_cofx = (function redgenes$components$querybuilder$events$maybe_run_query_cofx(p__29698){
var map__29701 = p__29698;
var map__29701__$1 = ((((!((map__29701 == null)))?((((map__29701.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29701.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29701):map__29701);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29701__$1,cljs.core.cst$kw$db);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,redgenes.components.querybuilder.events.update_io_query(db,(7)),cljs.core.cst$kw$query_DASH_builder_SLASH_maybe_DASH_run_DASH_query_BANG_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$query,redgenes.components.querybuilder.core.build_query(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$query], null))),cljs.core.cst$kw$query_QMARK_,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$autoupdate_QMARK_], null))], null)], null);
});
/**
 * Returns the x for the given y
 */
redgenes.components.querybuilder.events.make_tree = (function redgenes$components$querybuilder$events$make_tree(db){
var model = cljs.core.cst$kw$model.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$assets.cljs$core$IFn$_invoke$arity$1(db));
return db;
});
/**
 * Removes the given path from the select clause
 */
redgenes.components.querybuilder.events.remove_select_cofx = (function redgenes$components$querybuilder$events$remove_select_cofx(p__29703,p__29704){
var map__29710 = p__29703;
var map__29710__$1 = ((((!((map__29710 == null)))?((((map__29710.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29710.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29710):map__29710);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29710__$1,cljs.core.cst$kw$db);
var vec__29711 = p__29704;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29711,(0),null);
var path = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29711,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$query,cljs.core.cst$kw$q_SLASH_select], null),((function (map__29710,map__29710__$1,db,vec__29711,_,path){
return (function (views){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(views,path);
});})(map__29710,map__29710__$1,db,vec__29711,_,path))
),cljs.core.cst$kw$dispatch,cljs.core.cst$kw$query_DASH_builder_SLASH_maybe_DASH_run_DASH_query], null);
});
redgenes.components.querybuilder.events.update_paths = (function redgenes$components$querybuilder$events$update_paths(db){
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$query,cljs.core.cst$kw$constraint_DASH_paths], null),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$q_SLASH_path,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$query,cljs.core.cst$kw$q_SLASH_where], null)))));
});
/**
 * Removes the given path from select, runs the query
 */
redgenes.components.querybuilder.events.remove_constraint_cofx = (function redgenes$components$querybuilder$events$remove_constraint_cofx(p__29716,p__29717){
var map__29723 = p__29716;
var map__29723__$1 = ((((!((map__29723 == null)))?((((map__29723.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29723.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29723):map__29723);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29723__$1,cljs.core.cst$kw$db);
var vec__29724 = p__29717;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29724,(0),null);
var c = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29724,(1),null);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29724,(2),null);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,redgenes.components.querybuilder.events.update_paths(cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$query,cljs.core.cst$kw$q_SLASH_where], null),((function (map__29723,map__29723__$1,db,vec__29724,_,c,i){
return (function (wheres){
return cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (map__29723,map__29723__$1,db,vec__29724,_,c,i){
return (function (p1__29715_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__29715_SHARP_,c);
});})(map__29723,map__29723__$1,db,vec__29724,_,c,i))
,wheres));
});})(map__29723,map__29723__$1,db,vec__29724,_,c,i))
)),cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder_SLASH_maybe_DASH_run_DASH_query], null)], null);
});
/**
 * Returns the x for the given y
 */
redgenes.components.querybuilder.events.add_filter = (function redgenes$components$querybuilder$events$add_filter(db,p__29728){
var vec__29732 = p__29728;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29732,(0),null);
var path = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29732,(1),null);
var typ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29732,(2),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$constraint], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$path,path,cljs.core.cst$kw$typ,typ], null));
});
/**
 * Parse the given logic expression to a list
 */
redgenes.components.querybuilder.events.set_logic = (function redgenes$components$querybuilder$events$set_logic(var_args){
var args29735 = [];
var len__8435__auto___29747 = arguments.length;
var i__8436__auto___29748 = (0);
while(true){
if((i__8436__auto___29748 < len__8435__auto___29747)){
args29735.push((arguments[i__8436__auto___29748]));

var G__29749 = (i__8436__auto___29748 + (1));
i__8436__auto___29748 = G__29749;
continue;
} else {
}
break;
}

var G__29737 = args29735.length;
switch (G__29737) {
case 3:
return redgenes.components.querybuilder.events.set_logic.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return redgenes.components.querybuilder.events.set_logic.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29735.length)].join('')));

}
});

redgenes.components.querybuilder.events.set_logic.cljs$core$IFn$_invoke$arity$3 = (function (_,db,p__29738){
var vec__29739 = p__29738;
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29739,(0),null);
var expression = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29739,(1),null);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$dcount,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$dcount], null)),cljs.core.cst$kw$count,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$count], null)),cljs.core.cst$kw$explanation,"set the logic"], null);
});

redgenes.components.querybuilder.events.set_logic.cljs$core$IFn$_invoke$arity$2 = (function (db,p__29742){
var vec__29743 = p__29742;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29743,(0),null);
var expression = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29743,(1),null);
var x = (function (){try{return redgenes.components.querybuilder.core.simplify.cljs$core$IFn$_invoke$arity$1(redgenes.components.querybuilder.core.infix_prefix(redgenes.components.querybuilder.core.group_ands(redgenes.components.querybuilder.core.to_list([cljs.core.str("("),cljs.core.str(expression),cljs.core.str(")")].join('')))));
}catch (e29746){if((e29746 instanceof Error)){
var e = e29746;
return cljs.core.PersistentVector.EMPTY;
} else {
throw e29746;

}
}})();
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$query,cljs.core.cst$kw$q_SLASH_logic], null),x),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$query,cljs.core.cst$kw$logic_DASH_exp], null),redgenes.components.querybuilder.core.prefix_infix(x)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$query,cljs.core.cst$kw$logic_DASH_str], null),clojure.string.upper_case(expression));
});

redgenes.components.querybuilder.events.set_logic.cljs$lang$maxFixedArity = 3;

/**
 * Returns the x for the given y
 */
redgenes.components.querybuilder.events.set_query = (function redgenes$components$querybuilder$events$set_query(db,p__29751){
var vec__29755 = p__29751;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29755,(0),null);
var query_str = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29755,(1),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$query], null),redgenes.components.querybuilder.core.to_list(query_str));
});
/**
 * Sets the query constraint logic
 */
redgenes.components.querybuilder.events.set_logic_cofx = (function redgenes$components$querybuilder$events$set_logic_cofx(var_args){
var args29758 = [];
var len__8435__auto___29767 = arguments.length;
var i__8436__auto___29768 = (0);
while(true){
if((i__8436__auto___29768 < len__8435__auto___29767)){
args29758.push((arguments[i__8436__auto___29768]));

var G__29769 = (i__8436__auto___29768 + (1));
i__8436__auto___29768 = G__29769;
continue;
} else {
}
break;
}

var G__29760 = args29758.length;
switch (G__29760) {
case 3:
return redgenes.components.querybuilder.events.set_logic_cofx.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return redgenes.components.querybuilder.events.set_logic_cofx.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29758.length)].join('')));

}
});

redgenes.components.querybuilder.events.set_logic_cofx.cljs$core$IFn$_invoke$arity$3 = (function (_,p__29761,event){
var map__29762 = p__29761;
var map__29762__$1 = ((((!((map__29762 == null)))?((((map__29762.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29762.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29762):map__29762);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29762__$1,cljs.core.cst$kw$db);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$count,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$count], null)),cljs.core.cst$kw$explanation,"set logic!"], null);
});

redgenes.components.querybuilder.events.set_logic_cofx.cljs$core$IFn$_invoke$arity$2 = (function (p__29764,event){
var map__29765 = p__29764;
var map__29765__$1 = ((((!((map__29765 == null)))?((((map__29765.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29765.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29765):map__29765);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29765__$1,cljs.core.cst$kw$db);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,(function (){var db__$1 = redgenes.components.querybuilder.events.set_logic.cljs$core$IFn$_invoke$arity$2(db,event);

if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$autoupdate_QMARK_], null)))){
return redgenes.components.querybuilder.events.update_io_query(db__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$query], null))], null));
} else {
return db__$1;
}
})(),cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder_SLASH_maybe_DASH_run_DASH_query], null)], null);
});

redgenes.components.querybuilder.events.set_logic_cofx.cljs$lang$maxFixedArity = 3;

/**
 * Toggles the given path in the querie's select
 */
redgenes.components.querybuilder.events.toggle_view = (function redgenes$components$querybuilder$events$toggle_view(p__29771,p__29772){
var map__29778 = p__29771;
var map__29778__$1 = ((((!((map__29778 == null)))?((((map__29778.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29778.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29778):map__29778);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29778__$1,cljs.core.cst$kw$db);
var vec__29779 = p__29772;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29779,(0),null);
var path_vec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29779,(1),null);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$query,cljs.core.cst$kw$q_SLASH_select], null),((function (map__29778,map__29778__$1,db,vec__29779,_,path_vec){
return (function (views){
var views__$1 = (function (){var or__7219__auto__ = views;
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
if(cljs.core.truth_((views__$1.cljs$core$IFn$_invoke$arity$1 ? views__$1.cljs$core$IFn$_invoke$arity$1(path_vec) : views__$1.call(null,path_vec)))){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(views__$1,path_vec);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(views__$1,path_vec);
}
});})(map__29778,map__29778__$1,db,vec__29779,_,path_vec))
);
});
/**
 * Toggles a select clause, runs the query
 */
redgenes.components.querybuilder.events.toggle_view_cofx = (function redgenes$components$querybuilder$events$toggle_view_cofx(state,event){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,redgenes.components.querybuilder.events.toggle_view(state,event),cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder_SLASH_run_DASH_query_BANG_], null)], null);
});
/**
 * Runs the given query, returns a channel
 */
redgenes.components.querybuilder.events.run_query_BANG_ = (function redgenes$components$querybuilder$events$run_query_BANG_(query){
var c__14702__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14702__auto__){
return (function (){
var f__14703__auto__ = (function (){var switch__14623__auto__ = ((function (c__14702__auto__){
return (function (state_29835){
var state_val_29836 = (state_29835[(1)]);
if((state_val_29836 === (1))){
var inst_29814 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29815 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29816 = [cljs.core.cst$kw$current_DASH_mine];
var inst_29817 = (new cljs.core.PersistentVector(null,1,(5),inst_29815,inst_29816,null));
var inst_29818 = (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(inst_29817) : re_frame.core.subscribe.call(null,inst_29817));
var inst_29819 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inst_29818) : cljs.core.deref.call(null,inst_29818));
var inst_29820 = cljs.core.cst$kw$service.cljs$core$IFn$_invoke$arity$1(inst_29819);
var inst_29821 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29822 = [cljs.core.cst$kw$root];
var inst_29823 = (new cljs.core.PersistentVector(null,1,(5),inst_29821,inst_29822,null));
var inst_29824 = cljs.core.select_keys(inst_29820,inst_29823);
var inst_29825 = [cljs.core.cst$kw$format];
var inst_29826 = ["count"];
var inst_29827 = cljs.core.PersistentHashMap.fromArrays(inst_29825,inst_29826);
var inst_29828 = imcljsold.search.raw_query_rows.cljs$core$IFn$_invoke$arity$variadic(inst_29824,query,cljs.core.array_seq([inst_29827], 0));
var state_29835__$1 = (function (){var statearr_29837 = state_29835;
(statearr_29837[(7)] = inst_29814);

return statearr_29837;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29835__$1,(2),inst_29828);
} else {
if((state_val_29836 === (2))){
var inst_29814 = (state_29835[(7)]);
var inst_29830 = (state_29835[(2)]);
var inst_29831 = [cljs.core.cst$kw$query_DASH_builder_SLASH_handle_DASH_count,inst_29830];
var inst_29832 = (new cljs.core.PersistentVector(null,2,(5),inst_29814,inst_29831,null));
var inst_29833 = (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(inst_29832) : re_frame.core.dispatch.call(null,inst_29832));
var state_29835__$1 = state_29835;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29835__$1,inst_29833);
} else {
return null;
}
}
});})(c__14702__auto__))
;
return ((function (switch__14623__auto__,c__14702__auto__){
return (function() {
var redgenes$components$querybuilder$events$run_query_BANG__$_state_machine__14624__auto__ = null;
var redgenes$components$querybuilder$events$run_query_BANG__$_state_machine__14624__auto____0 = (function (){
var statearr_29841 = [null,null,null,null,null,null,null,null];
(statearr_29841[(0)] = redgenes$components$querybuilder$events$run_query_BANG__$_state_machine__14624__auto__);

(statearr_29841[(1)] = (1));

return statearr_29841;
});
var redgenes$components$querybuilder$events$run_query_BANG__$_state_machine__14624__auto____1 = (function (state_29835){
while(true){
var ret_value__14625__auto__ = (function (){try{while(true){
var result__14626__auto__ = switch__14623__auto__(state_29835);
if(cljs.core.keyword_identical_QMARK_(result__14626__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14626__auto__;
}
break;
}
}catch (e29842){if((e29842 instanceof Object)){
var ex__14627__auto__ = e29842;
var statearr_29843_29845 = state_29835;
(statearr_29843_29845[(5)] = ex__14627__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29835);

return cljs.core.cst$kw$recur;
} else {
throw e29842;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14625__auto__,cljs.core.cst$kw$recur)){
var G__29846 = state_29835;
state_29835 = G__29846;
continue;
} else {
return ret_value__14625__auto__;
}
break;
}
});
redgenes$components$querybuilder$events$run_query_BANG__$_state_machine__14624__auto__ = function(state_29835){
switch(arguments.length){
case 0:
return redgenes$components$querybuilder$events$run_query_BANG__$_state_machine__14624__auto____0.call(this);
case 1:
return redgenes$components$querybuilder$events$run_query_BANG__$_state_machine__14624__auto____1.call(this,state_29835);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
redgenes$components$querybuilder$events$run_query_BANG__$_state_machine__14624__auto__.cljs$core$IFn$_invoke$arity$0 = redgenes$components$querybuilder$events$run_query_BANG__$_state_machine__14624__auto____0;
redgenes$components$querybuilder$events$run_query_BANG__$_state_machine__14624__auto__.cljs$core$IFn$_invoke$arity$1 = redgenes$components$querybuilder$events$run_query_BANG__$_state_machine__14624__auto____1;
return redgenes$components$querybuilder$events$run_query_BANG__$_state_machine__14624__auto__;
})()
;})(switch__14623__auto__,c__14702__auto__))
})();
var state__14704__auto__ = (function (){var statearr_29844 = (f__14703__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14703__auto__.cljs$core$IFn$_invoke$arity$0() : f__14703__auto__.call(null));
(statearr_29844[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14702__auto__);

return statearr_29844;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14704__auto__);
});})(c__14702__auto__))
);

return c__14702__auto__;
});
/**
 * Maybe runs the given query, if it
 * conforms to the exacting requirements of spec
 */
redgenes.components.querybuilder.events.maybe_run_query_BANG_ = (function redgenes$components$querybuilder$events$maybe_run_query_BANG_(p__29847){
var map__29850 = p__29847;
var map__29850__$1 = ((((!((map__29850 == null)))?((((map__29850.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29850.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29850):map__29850);
var query = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29850__$1,cljs.core.cst$kw$query);
var query_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29850__$1,cljs.core.cst$kw$query_QMARK_);
if(cljs.core.truth_(cljs.spec.valid_QMARK_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$q_SLASH_query,query))){
return redgenes.components.querybuilder.events.run_query_BANG_(redgenes.components.querybuilder.core.build_query(query));
} else {
return null;
}
});
redgenes.components.querybuilder.events.my_events = new cljs.core.PersistentVector(null, 19, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Var(function(){return redgenes.components.querybuilder.events.reset_query;},cljs.core.cst$sym$redgenes$components$querybuilder$events_SLASH_reset_DASH_query,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$reframe_DASH_kind,cljs.core.cst$kw$reframe_DASH_key,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$undoable_QMARK_,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$kw$event,cljs.core.cst$kw$query_DASH_builder_SLASH_reset_DASH_query,cljs.core.cst$sym$redgenes$components$querybuilder$events,cljs.core.cst$sym$reset_DASH_query,"/home/FILESERVER5/micklem/yy406/projects/redgenes/src/cljs/redgenes/components/querybuilder/events.cljc",18,true,1,72,72,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$count], null)], null)),"Reset the query to empty",(cljs.core.truth_(redgenes.components.querybuilder.events.reset_query)?redgenes.components.querybuilder.events.reset_query.cljs$lang$test:null)])),new cljs.core.Var(function(){return redgenes.components.querybuilder.events.add_constraint_cofx;},cljs.core.cst$sym$redgenes$components$querybuilder$events_SLASH_add_DASH_constraint_DASH_cofx,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$reframe_DASH_kind,cljs.core.cst$kw$reframe_DASH_key,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$undoable_QMARK_,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$undo_DASH_exp,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$kw$cofx,cljs.core.cst$kw$query_DASH_builder_SLASH_add_DASH_constraint_BANG_,cljs.core.cst$sym$redgenes$components$querybuilder$events,cljs.core.cst$sym$add_DASH_constraint_DASH_cofx,"/home/FILESERVER5/micklem/yy406/projects/redgenes/src/cljs/redgenes/components/querybuilder/events.cljc",26,true,1,125,125,"add constraint",cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$db,cljs.core.cst$kw$db], null),cljs.core.cst$sym$event], null)),"Adds a where clause, runs the query",(cljs.core.truth_(redgenes.components.querybuilder.events.add_constraint_cofx)?redgenes.components.querybuilder.events.add_constraint_cofx.cljs$lang$test:null)])),new cljs.core.Var(function(){return redgenes.components.querybuilder.events.change_constraint_value;},cljs.core.cst$sym$redgenes$components$querybuilder$events_SLASH_change_DASH_constraint_DASH_value,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$reframe_DASH_kind,cljs.core.cst$kw$reframe_DASH_key,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$undoable_QMARK_,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$undo_DASH_exp,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$kw$event,cljs.core.cst$kw$query_DASH_builder_SLASH_change_DASH_constraint_DASH_value,cljs.core.cst$sym$redgenes$components$querybuilder$events,cljs.core.cst$sym$change_DASH_constraint_DASH_value,"/home/FILESERVER5/micklem/yy406/projects/redgenes/src/cljs/redgenes/components/querybuilder/events.cljc",30,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$variadic,false,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$index,cljs.core.cst$sym$value], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$index,cljs.core.cst$sym$value], null)], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$index,cljs.core.cst$sym$value], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$index,cljs.core.cst$sym$value], null)], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),true,1,136,136,cljs.core.cst$kw$use_DASH_this_DASH_fn_DASH_due_DASH_to_DASH_static_DASH_metadata_DASH_in_DASH_cljs,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$index,cljs.core.cst$sym$value], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$index,cljs.core.cst$sym$value], null)], null)),"Returns the given db with the :q/where constraint value at given index\n  changed to given value",(cljs.core.truth_(redgenes.components.querybuilder.events.change_constraint_value)?redgenes.components.querybuilder.events.change_constraint_value.cljs$lang$test:null)])),new cljs.core.Var(function(){return redgenes.components.querybuilder.events.change_constraint_op;},cljs.core.cst$sym$redgenes$components$querybuilder$events_SLASH_change_DASH_constraint_DASH_op,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$reframe_DASH_kind,cljs.core.cst$kw$reframe_DASH_key,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$undoable_QMARK_,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$undo_DASH_exp,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$kw$event,cljs.core.cst$kw$query_DASH_builder_SLASH_change_DASH_constraint_DASH_op,cljs.core.cst$sym$redgenes$components$querybuilder$events,cljs.core.cst$sym$change_DASH_constraint_DASH_op,"/home/FILESERVER5/micklem/yy406/projects/redgenes/src/cljs/redgenes/components/querybuilder/events.cljc",27,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$variadic,false,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$index,cljs.core.cst$sym$op], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$index,cljs.core.cst$sym$op], null)], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$index,cljs.core.cst$sym$op], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$index,cljs.core.cst$sym$op], null)], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),true,1,151,151,cljs.core.cst$kw$use_DASH_this_DASH_fn_DASH_due_DASH_to_DASH_static_DASH_metadata_DASH_in_DASH_cljs,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$index,cljs.core.cst$sym$op], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$index,cljs.core.cst$sym$op], null)], null)),"Returns the given db with the :q/where constraint op at given index\n  changed to given value",(cljs.core.truth_(redgenes.components.querybuilder.events.change_constraint_op)?redgenes.components.querybuilder.events.change_constraint_op.cljs$lang$test:null)])),new cljs.core.Var(function(){return redgenes.components.querybuilder.events.handle_count;},cljs.core.cst$sym$redgenes$components$querybuilder$events_SLASH_handle_DASH_count,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$reframe_DASH_kind,cljs.core.cst$kw$reframe_DASH_key,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$kw$event,cljs.core.cst$kw$query_DASH_builder_SLASH_handle_DASH_count,cljs.core.cst$sym$redgenes$components$querybuilder$events,cljs.core.cst$sym$handle_DASH_count,"/home/FILESERVER5/micklem/yy406/projects/redgenes/src/cljs/redgenes/components/querybuilder/events.cljc",19,1,174,174,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$count], null)], null)),"Adds the count & difference in count (dcount)",(cljs.core.truth_(redgenes.components.querybuilder.events.handle_count)?redgenes.components.querybuilder.events.handle_count.cljs$lang$test:null)])),new cljs.core.Var(function(){return redgenes.components.querybuilder.events.run_query_cofx;},cljs.core.cst$sym$redgenes$components$querybuilder$events_SLASH_run_DASH_query_DASH_cofx,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$reframe_DASH_kind,cljs.core.cst$kw$reframe_DASH_key,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$kw$cofx,cljs.core.cst$kw$query_DASH_builder_SLASH_run_DASH_query_BANG_,cljs.core.cst$sym$redgenes$components$querybuilder$events,cljs.core.cst$sym$run_DASH_query_DASH_cofx,"/home/FILESERVER5/micklem/yy406/projects/redgenes/src/cljs/redgenes/components/querybuilder/events.cljc",21,1,188,188,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$db,cljs.core.cst$kw$db], null)], null)),"Returns a cofx for running the query",(cljs.core.truth_(redgenes.components.querybuilder.events.run_query_cofx)?redgenes.components.querybuilder.events.run_query_cofx.cljs$lang$test:null)])),new cljs.core.Var(function(){return redgenes.components.querybuilder.events.make_tree;},cljs.core.cst$sym$redgenes$components$querybuilder$events_SLASH_make_DASH_tree,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$reframe_DASH_kind,cljs.core.cst$kw$reframe_DASH_key,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$kw$event,cljs.core.cst$kw$query_DASH_builder_SLASH_make_DASH_tree,cljs.core.cst$sym$redgenes$components$querybuilder$events,cljs.core.cst$sym$make_DASH_tree,"/home/FILESERVER5/micklem/yy406/projects/redgenes/src/cljs/redgenes/components/querybuilder/events.cljc",16,1,207,207,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$db], null)),"Returns the x for the given y",(cljs.core.truth_(redgenes.components.querybuilder.events.make_tree)?redgenes.components.querybuilder.events.make_tree.cljs$lang$test:null)])),new cljs.core.Var(function(){return redgenes.components.querybuilder.events.remove_select_cofx;},cljs.core.cst$sym$redgenes$components$querybuilder$events_SLASH_remove_DASH_select_DASH_cofx,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$reframe_DASH_kind,cljs.core.cst$kw$reframe_DASH_key,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$kw$cofx,cljs.core.cst$kw$query_DASH_builder_SLASH_remove_DASH_select,cljs.core.cst$sym$redgenes$components$querybuilder$events,cljs.core.cst$sym$remove_DASH_select_DASH_cofx,"/home/FILESERVER5/micklem/yy406/projects/redgenes/src/cljs/redgenes/components/querybuilder/events.cljc",25,1,213,213,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$db,cljs.core.cst$kw$db], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$path], null)], null)),"Removes the given path from the select clause",(cljs.core.truth_(redgenes.components.querybuilder.events.remove_select_cofx)?redgenes.components.querybuilder.events.remove_select_cofx.cljs$lang$test:null)])),new cljs.core.Var(function(){return redgenes.components.querybuilder.events.remove_constraint_cofx;},cljs.core.cst$sym$redgenes$components$querybuilder$events_SLASH_remove_DASH_constraint_DASH_cofx,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$reframe_DASH_kind,cljs.core.cst$kw$reframe_DASH_key,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$undoable_QMARK_,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$undo_DASH_exp,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$kw$cofx,cljs.core.cst$kw$query_DASH_builder_SLASH_remove_DASH_constraint,cljs.core.cst$sym$redgenes$components$querybuilder$events,cljs.core.cst$sym$remove_DASH_constraint_DASH_cofx,"/home/FILESERVER5/micklem/yy406/projects/redgenes/src/cljs/redgenes/components/querybuilder/events.cljc",29,true,1,228,228,"remove constraint",cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$db,cljs.core.cst$kw$db], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$c,cljs.core.cst$sym$i], null)], null)),"Removes the given path from select, runs the query",(cljs.core.truth_(redgenes.components.querybuilder.events.remove_constraint_cofx)?redgenes.components.querybuilder.events.remove_constraint_cofx.cljs$lang$test:null)])),new cljs.core.Var(function(){return redgenes.components.querybuilder.events.add_filter;},cljs.core.cst$sym$redgenes$components$querybuilder$events_SLASH_add_DASH_filter,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$reframe_DASH_kind,cljs.core.cst$kw$reframe_DASH_key,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$undoable_QMARK_,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$kw$event,cljs.core.cst$kw$query_DASH_builder_SLASH_add_DASH_filter,cljs.core.cst$sym$redgenes$components$querybuilder$events,cljs.core.cst$sym$add_DASH_filter,"/home/FILESERVER5/micklem/yy406/projects/redgenes/src/cljs/redgenes/components/querybuilder/events.cljc",17,true,1,242,242,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$path,cljs.core.cst$sym$typ], null)], null)),"Returns the x for the given y",(cljs.core.truth_(redgenes.components.querybuilder.events.add_filter)?redgenes.components.querybuilder.events.add_filter.cljs$lang$test:null)])),new cljs.core.Var(function(){return redgenes.components.querybuilder.events.set_logic;},cljs.core.cst$sym$redgenes$components$querybuilder$events_SLASH_set_DASH_logic,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$reframe_DASH_kind,cljs.core.cst$kw$reframe_DASH_key,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$undoable_QMARK_,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$undo_DASH_exp,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$kw$event,cljs.core.cst$kw$query_DASH_builder_SLASH_set_DASH_logic,cljs.core.cst$sym$redgenes$components$querybuilder$events,cljs.core.cst$sym$set_DASH_logic,"/home/FILESERVER5/micklem/yy406/projects/redgenes/src/cljs/redgenes/components/querybuilder/events.cljc",16,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$variadic,false,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$expression], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$expression], null)], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$expression], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$expression], null)], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),true,1,250,250,cljs.core.cst$kw$qwe,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$expression], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$expression], null)], null)),"Parse the given logic expression to a list",(cljs.core.truth_(redgenes.components.querybuilder.events.set_logic)?redgenes.components.querybuilder.events.set_logic.cljs$lang$test:null)])),new cljs.core.Var(function(){return redgenes.components.querybuilder.events.set_logic_cofx;},cljs.core.cst$sym$redgenes$components$querybuilder$events_SLASH_set_DASH_logic_DASH_cofx,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$reframe_DASH_kind,cljs.core.cst$kw$reframe_DASH_key,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$undoable_QMARK_,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$undo_DASH_exp,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$kw$cofx,cljs.core.cst$kw$query_DASH_builder_SLASH_set_DASH_logic_BANG_,cljs.core.cst$sym$redgenes$components$querybuilder$events,cljs.core.cst$sym$set_DASH_logic_DASH_cofx,"/home/FILESERVER5/micklem/yy406/projects/redgenes/src/cljs/redgenes/components/querybuilder/events.cljc",21,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$variadic,false,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$db,cljs.core.cst$kw$db], null),cljs.core.cst$sym$event], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$db,cljs.core.cst$kw$db], null),cljs.core.cst$sym$event], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$db,cljs.core.cst$kw$db], null),cljs.core.cst$sym$event], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$db,cljs.core.cst$kw$db], null),cljs.core.cst$sym$event], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),true,1,281,281,cljs.core.cst$kw$see_DASH_also,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$db,cljs.core.cst$kw$db], null),cljs.core.cst$sym$event], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$db,cljs.core.cst$kw$db], null),cljs.core.cst$sym$event], null)),"Sets the query constraint logic",(cljs.core.truth_(redgenes.components.querybuilder.events.set_logic_cofx)?redgenes.components.querybuilder.events.set_logic_cofx.cljs$lang$test:null)])),new cljs.core.Var(function(){return redgenes.components.querybuilder.events.set_query;},cljs.core.cst$sym$redgenes$components$querybuilder$events_SLASH_set_DASH_query,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$reframe_DASH_kind,cljs.core.cst$kw$reframe_DASH_key,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$kw$event,cljs.core.cst$kw$query_DASH_builder_SLASH_set_DASH_query,cljs.core.cst$sym$redgenes$components$querybuilder$events,cljs.core.cst$sym$set_DASH_query,"/home/FILESERVER5/micklem/yy406/projects/redgenes/src/cljs/redgenes/components/querybuilder/events.cljc",16,1,272,272,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$query_DASH_str], null)], null)),"Returns the x for the given y",(cljs.core.truth_(redgenes.components.querybuilder.events.set_query)?redgenes.components.querybuilder.events.set_query.cljs$lang$test:null)])),new cljs.core.Var(function(){return redgenes.components.querybuilder.events.update_io_query;},cljs.core.cst$sym$redgenes$components$querybuilder$events_SLASH_update_DASH_io_DASH_query,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$reframe_DASH_kind,cljs.core.cst$kw$reframe_DASH_key,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$kw$event,cljs.core.cst$kw$query_DASH_builder_SLASH_update_DASH_io_DASH_query,cljs.core.cst$sym$redgenes$components$querybuilder$events,cljs.core.cst$sym$update_DASH_io_DASH_query,"/home/FILESERVER5/micklem/yy406/projects/redgenes/src/cljs/redgenes/components/querybuilder/events.cljc",22,1,88,88,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentArrayMap.fromArray([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$query,cljs.core.cst$kw$query], null),cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$as,cljs.core.cst$sym$db], true, false),cljs.core.cst$sym$_], null)),"Updates the Webservice query\n  from the given Spec query",(cljs.core.truth_(redgenes.components.querybuilder.events.update_io_query)?redgenes.components.querybuilder.events.update_io_query.cljs$lang$test:null)])),new cljs.core.Var(function(){return redgenes.components.querybuilder.events.toggle_view_cofx;},cljs.core.cst$sym$redgenes$components$querybuilder$events_SLASH_toggle_DASH_view_DASH_cofx,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$reframe_DASH_kind,cljs.core.cst$kw$reframe_DASH_key,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$undoable_QMARK_,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$kw$cofx,cljs.core.cst$kw$query_DASH_builder_SLASH_toggle_DASH_view_BANG_,cljs.core.cst$sym$redgenes$components$querybuilder$events,cljs.core.cst$sym$toggle_DASH_view_DASH_cofx,"/home/FILESERVER5/micklem/yy406/projects/redgenes/src/cljs/redgenes/components/querybuilder/events.cljc",23,true,1,312,312,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$state,cljs.core.cst$sym$event], null)),"Toggles a select clause, runs the query",(cljs.core.truth_(redgenes.components.querybuilder.events.toggle_view_cofx)?redgenes.components.querybuilder.events.toggle_view_cofx.cljs$lang$test:null)])),new cljs.core.Var(function(){return redgenes.components.querybuilder.events.maybe_run_query_cofx;},cljs.core.cst$sym$redgenes$components$querybuilder$events_SLASH_maybe_DASH_run_DASH_query_DASH_cofx,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$reframe_DASH_kind,cljs.core.cst$kw$reframe_DASH_key,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$kw$cofx,cljs.core.cst$kw$query_DASH_builder_SLASH_maybe_DASH_run_DASH_query,cljs.core.cst$sym$redgenes$components$querybuilder$events,cljs.core.cst$sym$maybe_DASH_run_DASH_query_DASH_cofx,"/home/FILESERVER5/micklem/yy406/projects/redgenes/src/cljs/redgenes/components/querybuilder/events.cljc",27,1,198,198,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$db,cljs.core.cst$kw$db], null)], null)),"Returns a cofx for maybe running the query",(cljs.core.truth_(redgenes.components.querybuilder.events.maybe_run_query_cofx)?redgenes.components.querybuilder.events.maybe_run_query_cofx.cljs$lang$test:null)])),new cljs.core.Var(function(){return redgenes.components.querybuilder.events.set_where_path;},cljs.core.cst$sym$redgenes$components$querybuilder$events_SLASH_set_DASH_where_DASH_path,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$reframe_DASH_kind,cljs.core.cst$kw$reframe_DASH_key,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$kw$event,cljs.core.cst$kw$query_DASH_builder_SLASH_set_DASH_where_DASH_path,cljs.core.cst$sym$redgenes$components$querybuilder$events,cljs.core.cst$sym$set_DASH_where_DASH_path,"/home/FILESERVER5/micklem/yy406/projects/redgenes/src/cljs/redgenes/components/querybuilder/events.cljc",21,1,166,166,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$path], null)], null)),"",(cljs.core.truth_(redgenes.components.querybuilder.events.set_where_path)?redgenes.components.querybuilder.events.set_where_path.cljs$lang$test:null)])),new cljs.core.Var(function(){return redgenes.components.querybuilder.events.run_query_BANG_;},cljs.core.cst$sym$redgenes$components$querybuilder$events_SLASH_run_DASH_query_BANG_,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$reframe_DASH_kind,cljs.core.cst$kw$reframe_DASH_key,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$kw$fx,cljs.core.cst$kw$query_DASH_builder_SLASH_run_DASH_query_BANG_,cljs.core.cst$sym$redgenes$components$querybuilder$events,cljs.core.cst$sym$run_DASH_query_BANG_,"/home/FILESERVER5/micklem/yy406/projects/redgenes/src/cljs/redgenes/components/querybuilder/events.cljc",17,1,322,322,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$query], null)),"Runs the given query, returns a channel",(cljs.core.truth_(redgenes.components.querybuilder.events.run_query_BANG_)?redgenes.components.querybuilder.events.run_query_BANG_.cljs$lang$test:null)])),new cljs.core.Var(function(){return redgenes.components.querybuilder.events.maybe_run_query_BANG_;},cljs.core.cst$sym$redgenes$components$querybuilder$events_SLASH_maybe_DASH_run_DASH_query_BANG_,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$reframe_DASH_kind,cljs.core.cst$kw$reframe_DASH_key,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$kw$fx,cljs.core.cst$kw$query_DASH_builder_SLASH_maybe_DASH_run_DASH_query_BANG_,cljs.core.cst$sym$redgenes$components$querybuilder$events,cljs.core.cst$sym$maybe_DASH_run_DASH_query_BANG_,"/home/FILESERVER5/micklem/yy406/projects/redgenes/src/cljs/redgenes/components/querybuilder/events.cljc",23,1,338,338,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$query,cljs.core.cst$kw$query,cljs.core.cst$sym$query_QMARK_,cljs.core.cst$kw$query_QMARK_], null)], null)),"Maybe runs the given query, if it\n   conforms to the exacting requirements of spec",(cljs.core.truth_(redgenes.components.querybuilder.events.maybe_run_query_BANG_)?redgenes.components.querybuilder.events.maybe_run_query_BANG_.cljs$lang$test:null)]))], null);
redgenes.utils.register_all_BANG_(redgenes.components.querybuilder.events.my_events);
