// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('redgenes.components.search.typeahead');
goog.require('cljs.core');
goog.require('reagent.core');
goog.require('re_frame.core');
goog.require('accountant.core');
goog.require('dommy.core');
/**
 * Navigate to the report page for the given item and reset the UI
 */
redgenes.components.search.typeahead.navigate_to_report = (function redgenes$components$search$typeahead$navigate_to_report(item){
var current_mine = (function (){var G__18192 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$current_DASH_mine], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__18192) : re_frame.core.subscribe.call(null,G__18192));
})();
var G__18193_18194 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search_SLASH_reset_DASH_selection], null);
(re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__18193_18194) : re_frame.core.dispatch.call(null,G__18193_18194));

return accountant.core.navigate_BANG_.cljs$core$IFn$_invoke$arity$1([cljs.core.str("/reportpage/"),cljs.core.str(cljs.core.name(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(current_mine) : cljs.core.deref.call(null,current_mine))))),cljs.core.str("/"),cljs.core.str(cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(item)),cljs.core.str("/"),cljs.core.str(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(item))].join(''));
});
/**
 * Navigate to the full results page. duh.
 */
redgenes.components.search.typeahead.navigate_to_full_results = (function redgenes$components$search$typeahead$navigate_to_full_results(){
accountant.core.navigate_BANG_.cljs$core$IFn$_invoke$arity$1("/search");

if(cljs.core.some_QMARK_((function (){var G__18198 = (function (){var G__18199 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search_DASH_term], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__18199) : re_frame.core.subscribe.call(null,G__18199));
})();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18198) : cljs.core.deref.call(null,G__18198));
})())){
var G__18200 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search_SLASH_full_DASH_search], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__18200) : re_frame.core.dispatch.call(null,G__18200));
} else {
return null;
}
});
/**
 * The UI element and behaviour for a single suggestion in the dropdown
 */
redgenes.components.search.typeahead.suggestion = (function redgenes$components$search$typeahead$suggestion(){
var search_term = (function (){var G__18202 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search_DASH_term], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__18202) : re_frame.core.subscribe.call(null,G__18202));
})();
return ((function (search_term){
return (function (item,is_active_QMARK_){
var info = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(", ",cljs.core.vals(cljs.core.cst$kw$fields.cljs$core$IFn$_invoke$arity$1(item))));
var parsed = clojure.string.split.cljs$core$IFn$_invoke$arity$2(info,cljs.core.re_pattern([cljs.core.str("(?i)"),cljs.core.str((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(search_term) : cljs.core.deref.call(null,search_term)))].join('')));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$list_DASH_group_DASH_item$quicksearch_DASH_result,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_mouse_DASH_down,((function (info,parsed,search_term){
return (function (e){
var clicked_button = e.button;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(clicked_button,(0))){
return redgenes.components.search.typeahead.navigate_to_report(item);
} else {
return null;
}
});})(info,parsed,search_term))
,cljs.core.cst$kw$class,(cljs.core.truth_(is_active_QMARK_)?"active ":null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$row_DASH_content,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,[cljs.core.str("type type-"),cljs.core.str(cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(item))].join('')], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4$list_DASH_group_DASH_item_DASH_heading,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(item)], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$list_DASH_group_DASH_item_DASH_text], null),cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$highlight,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(search_term) : cljs.core.deref.call(null,search_term))], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (info,parsed,search_term){
return (function (part){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,part], null);
});})(info,parsed,search_term))
,parsed)))], null)], null);
});
;})(search_term))
});
redgenes.components.search.typeahead.monitor_enter_key = (function redgenes$components$search$typeahead$monitor_enter_key(e){
var keycode = e.charCode;
var active_selection = (function (){var G__18205 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$quicksearch_DASH_selected_DASH_index], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__18205) : re_frame.core.subscribe.call(null,G__18205));
})();
var results = (function (){var G__18206 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$suggestion_DASH_results], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__18206) : re_frame.core.subscribe.call(null,G__18206));
})();
var selected_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(results) : cljs.core.deref.call(null,results)),(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(active_selection) : cljs.core.deref.call(null,active_selection)),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(keycode,(13))){
if(cljs.core.truth_(selected_result)){
redgenes.components.search.typeahead.navigate_to_report(selected_result);
} else {
redgenes.components.search.typeahead.navigate_to_full_results();
}

return e.target.blur();
} else {
return null;
}
});
/**
 * Navigate the dropdown suggestions if the user presses up or down
 */
redgenes.components.search.typeahead.monitor_arrow_keys = (function redgenes$components$search$typeahead$monitor_arrow_keys(e){
var keycode = e.key;
var input = e.target.value;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(keycode,"ArrowUp")){
var G__18209 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search_SLASH_move_DASH_selection,cljs.core.cst$kw$prev], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__18209) : re_frame.core.dispatch.call(null,G__18209));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(keycode,"ArrowDown")){
var G__18210 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search_SLASH_move_DASH_selection,cljs.core.cst$kw$next], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__18210) : re_frame.core.dispatch.call(null,G__18210));
} else {
return null;
}
}
});
/**
 * UI element within the dropdown to show all results.
 */
redgenes.components.search.typeahead.show_all_results = (function redgenes$components$search$typeahead$show_all_results(){
var active_selection = (function (){var G__18212 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$quicksearch_DASH_selected_DASH_index], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__18212) : re_frame.core.subscribe.call(null,G__18212));
})();
var is_active_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(active_selection) : cljs.core.deref.call(null,active_selection)));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$show_DASH_all$list_DASH_group,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_mouse_DASH_down,((function (active_selection,is_active_QMARK_){
return (function (e){
var clicked_button = e.button;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(clicked_button,(0))){
return redgenes.components.search.typeahead.navigate_to_full_results();
} else {
return null;
}
});})(active_selection,is_active_QMARK_))
], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$list_DASH_group_DASH_item,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,((is_active_QMARK_)?"active":null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4,"Show all results"], null)], null)], null);
});
redgenes.components.search.typeahead.main = (function redgenes$components$search$typeahead$main(){
return reagent.core.create_class((function (){var results = (function (){var G__18218 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$suggestion_DASH_results], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__18218) : re_frame.core.subscribe.call(null,G__18218));
})();
var search_term = (function (){var G__18219 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search_DASH_term], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__18219) : re_frame.core.subscribe.call(null,G__18219));
})();
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$component_DASH_did_DASH_mount,((function (results,search_term){
return (function (e){
var node = reagent.core.dom_node(e);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic((dommy.utils.__GT_Array(node.getElementsByTagName("input"))[(0)]),cljs.core.array_seq([cljs.core.cst$kw$focus,((function (node,results,search_term){
return (function (){
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(node,cljs.core.cst$kw$open);
});})(node,results,search_term))
], 0)),cljs.core.array_seq([cljs.core.cst$kw$blur,((function (node,results,search_term){
return (function (){
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(node,cljs.core.cst$kw$open);
});})(node,results,search_term))
], 0));
});})(results,search_term))
,cljs.core.cst$kw$reagent_DASH_render,((function (results,search_term){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$dropdown,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$form_DASH_control$input_DASH_lg$square,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$type,"text",cljs.core.cst$kw$value,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(search_term) : cljs.core.deref.call(null,search_term)),cljs.core.cst$kw$placeholder,"Search",cljs.core.cst$kw$on_DASH_change,((function (results,search_term){
return (function (p1__18213_SHARP_){
var G__18220 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$bounce_DASH_search,p1__18213_SHARP_.target.value], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__18220) : re_frame.core.dispatch.call(null,G__18220));
});})(results,search_term))
,cljs.core.cst$kw$on_DASH_key_DASH_press,((function (results,search_term){
return (function (e){
return redgenes.components.search.typeahead.monitor_enter_key(e);
});})(results,search_term))
,cljs.core.cst$kw$on_DASH_key_DASH_up,((function (results,search_term){
return (function (e){
return redgenes.components.search.typeahead.monitor_arrow_keys(e);
});})(results,search_term))
], null)], null),(((cljs.core.count((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(results) : cljs.core.deref.call(null,results))) > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$dropdown_DASH_menu$quicksearch,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.search.typeahead.show_all_results], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$list_DASH_group], null),cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (results,search_term){
return (function (index,result){
var active_selection = (function (){var G__18221 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$quicksearch_DASH_selected_DASH_index], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__18221) : re_frame.core.subscribe.call(null,G__18221));
})();
var is_active_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(index,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(active_selection) : cljs.core.deref.call(null,active_selection)));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.search.typeahead.suggestion,result,is_active_QMARK_], null);
});})(results,search_term))
,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(results) : cljs.core.deref.call(null,results))))], null):null)], null);
});})(results,search_term))
], null);
})());
});
