// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('redgenes.persistence');
goog.require('cljs.core');
goog.require('dommy.core');
goog.require('cognitect.transit');
redgenes.persistence.merge_state = (function redgenes$persistence$merge_state(state,other_state,except_paths){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([state,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (r,p){
return cljs.core.assoc_in(r,p,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(state,p));
}),other_state,except_paths)], 0));
});
redgenes.persistence.to_transit = (function redgenes$persistence$to_transit(state){
return cognitect.transit.write(cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$json_DASH_verbose),state);
});
redgenes.persistence.persist_BANG_ = (function redgenes$persistence$persist_BANG_(state){
var G__18937_18939 = "redgenes/state";
var G__18938_18940 = redgenes.persistence.to_transit(state);
localStorage.setItem(G__18937_18939,G__18938_18940);

return state;
});
redgenes.persistence.destroy_BANG_ = (function redgenes$persistence$destroy_BANG_(){
localStorage.removeItem("redgenes/state");

return true;
});
/**
 * Returns the merging of the given state
 *   with the one in localstorage, except the given paths
 */
redgenes.persistence.get_state_BANG_ = (function redgenes$persistence$get_state_BANG_(var_args){
var args18941 = [];
var len__8435__auto___18944 = arguments.length;
var i__8436__auto___18945 = (0);
while(true){
if((i__8436__auto___18945 < len__8435__auto___18944)){
args18941.push((arguments[i__8436__auto___18945]));

var G__18946 = (i__8436__auto___18945 + (1));
i__8436__auto___18945 = G__18946;
continue;
} else {
}
break;
}

var G__18943 = args18941.length;
switch (G__18943) {
case 0:
return redgenes.persistence.get_state_BANG_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return redgenes.persistence.get_state_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return redgenes.persistence.get_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18941.length)].join('')));

}
});

redgenes.persistence.get_state_BANG_.cljs$core$IFn$_invoke$arity$0 = (function (){
return redgenes.persistence.get_state_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentVector.EMPTY);
});

redgenes.persistence.get_state_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (state){
return redgenes.persistence.get_state_BANG_.cljs$core$IFn$_invoke$arity$2(state,cljs.core.PersistentVector.EMPTY);
});

redgenes.persistence.get_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (state,paths){
return redgenes.persistence.merge_state(state,cognitect.transit.read(cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$json),localStorage.getItem("redgenes/state")),paths);
});

redgenes.persistence.get_state_BANG_.cljs$lang$maxFixedArity = 2;

redgenes.persistence.merge_state_from_file = (function redgenes$persistence$merge_state_from_file(state,file){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([state,cognitect.transit.read(cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$json),file)], 0));
});
/**
 * Contrive to 'download' the given contents
 *   as a file locally to be saved on the user's
 *   magnetic disk-drive storage medium
 */
redgenes.persistence.download_BANG_ = (function redgenes$persistence$download_BANG_(tipe,naym,contents){
var a = document.createElement("a");
var f = (new Blob(cljs.core.clj__GT_js(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [contents], null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$type,cljs.core.name(tipe)], null)));
a.href = URL.createObjectURL(f);

a.download = [cljs.core.str(naym),cljs.core.str("."),cljs.core.str(cljs.core.name(tipe))].join('');

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["<a>",a], 0));

return a.dispatchEvent((new MouseEvent("click")));
});
redgenes.persistence.make_filename = (function redgenes$persistence$make_filename(s){
return [cljs.core.str(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(s,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$msas,cljs.core.cst$kw$selected_DASH_msa.cljs$core$IFn$_invoke$arity$1(s),cljs.core.cst$kw$name], null))),cljs.core.str("-"),cljs.core.str(cljs.core.cst$kw$selected_DASH_msa.cljs$core$IFn$_invoke$arity$1(s)),cljs.core.str(".dg")].join('');
});
redgenes.persistence.load_BANG_ = (function redgenes$persistence$load_BANG_(s){
document.getElementById("file_button").click();

return s;
});
redgenes.persistence.save_BANG_ = (function redgenes$persistence$save_BANG_(s){
redgenes.persistence.download_BANG_("JSON",redgenes.persistence.make_filename(s),redgenes.persistence.to_transit(s));

return s;
});
