// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('redgenes.sections.regions.views');
goog.require('cljs.core');
goog.require('reagent.core');
goog.require('redgenes.sections.regions.graphs');
goog.require('redgenes.components.imcontrols.views');
goog.require('redgenes.sections.regions.subs');
goog.require('redgenes.components.table');
goog.require('oops.core');
goog.require('redgenes.sections.regions.results');
goog.require('redgenes.components.loader');
goog.require('accountant.core');
goog.require('redgenes.sections.regions.events');
goog.require('redgenes.components.bootstrap');
goog.require('clojure.string');
goog.require('re_frame.core');
redgenes.sections.regions.views.css_transition_group = reagent.core.adapt_react_class(React.addons.CSSTransitionGroup);
/**
 * Generate example region search input based on pre-configured per-mine settings
 */
redgenes.sections.regions.views.ex = (function redgenes$sections$regions$views$ex(){
var active_mine = (function (){var G__30496 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$current_DASH_mine], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__30496) : re_frame.core.subscribe.call(null,G__30496));
})();
var example_text = cljs.core.cst$kw$regionsearch_DASH_example.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(active_mine) : cljs.core.deref.call(null,active_mine)));
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("\n",example_text);
});
redgenes.sections.regions.views.region_help_content_popover = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,"Genome regions in the following formats are accepted:",new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,"chromosome:start..end, e.g. 2L:11334..12296"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,"chromosome:start-end, e.g. 2R:5866746-5868284 or chrII:14646344-14667746"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,"tab delimited"], null)], null)], null)], null);
/**
 * Recursively building a tree of user-selectable features as checkboxes
 */
redgenes.sections.regions.views.feature_branch = (function redgenes$sections$regions$views$feature_branch(){
var settings = (function (){var G__30507 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions_SLASH_settings], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__30507) : re_frame.core.subscribe.call(null,G__30507));
})();
return ((function (settings){
return (function (p__30508){
var vec__30509 = p__30508;
var class_kw = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30509,(0),null);
var map__30512 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30509,(1),null);
var map__30512__$1 = ((((!((map__30512 == null)))?((((map__30512.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30512.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30512):map__30512);
var n = map__30512__$1;
var displayName = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30512__$1,cljs.core.cst$kw$displayName);
var descendants = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30512__$1,cljs.core.cst$kw$descendants);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$class,(cljs.core.truth_((function (){var G__30514 = cljs.core.cst$kw$feature_DASH_types.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(settings) : cljs.core.deref.call(null,settings)));
return (class_kw.cljs$core$IFn$_invoke$arity$1 ? class_kw.cljs$core$IFn$_invoke$arity$1(G__30514) : class_kw.call(null,G__30514));
})())?"selected":null),cljs.core.cst$kw$on_DASH_click,((function (vec__30509,class_kw,map__30512,map__30512__$1,n,displayName,descendants,settings){
return (function (e){
e.stopPropagation();

var G__30515 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions_SLASH_toggle_DASH_feature_DASH_type,n], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__30515) : re_frame.core.dispatch.call(null,G__30515));
});})(vec__30509,class_kw,map__30512,map__30512__$1,n,displayName,descendants,settings))
], null),(cljs.core.truth_((function (){var G__30516 = cljs.core.cst$kw$feature_DASH_types.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(settings) : cljs.core.deref.call(null,settings)));
return (class_kw.cljs$core$IFn$_invoke$arity$1 ? class_kw.cljs$core$IFn$_invoke$arity$1(G__30516) : class_kw.call(null,G__30516));
})())?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_fw$fa_DASH_check_DASH_square_DASH_o], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_fw$fa_DASH_square_DASH_o], null)),displayName,((!(cljs.core.empty_QMARK_(descendants)))?cljs.core.into.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul$features_DASH_tree], null),cljs.core.map.cljs$core$IFn$_invoke$arity$1(((function (vec__30509,class_kw,map__30512,map__30512__$1,n,displayName,descendants,settings){
return (function (d){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.sections.regions.views.feature_branch,d], null);
});})(vec__30509,class_kw,map__30512,map__30512__$1,n,displayName,descendants,settings))
),cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$displayName,cljs.core.second),descendants)):null)], null);
});
;})(settings))
});
redgenes.sections.regions.views.feature_types_tree = (function redgenes$sections$regions$views$feature_types_tree(){

var known_feature_types = (function (){var G__30519 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions_SLASH_sequence_DASH_feature_DASH_types], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__30519) : re_frame.core.subscribe.call(null,G__30519));
})();
var settings = (function (){var G__30520 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions_SLASH_settings], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__30520) : re_frame.core.subscribe.call(null,G__30520));
})();
return ((function (known_feature_types,settings){
return (function (){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul$features_DASH_tree], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (known_feature_types,settings){
return (function (f){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.sections.regions.views.feature_branch,f], null);
});})(known_feature_types,settings))
,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$displayName,cljs.core.second),(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(known_feature_types) : cljs.core.deref.call(null,known_feature_types)))));
});
;})(known_feature_types,settings))
});
/**
 * UI component allowing user to choose which organisms to search. Defaults to all.
 */
redgenes.sections.regions.views.organism_selection = (function redgenes$sections$regions$views$organism_selection(){
var settings = (function (){var G__30523 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions_SLASH_settings], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__30523) : re_frame.core.subscribe.call(null,G__30523));
})();
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,"Organism"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.imcontrols.views.organism_dropdown,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$selected_DASH_value,(function (){var temp__6751__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(settings) : cljs.core.deref.call(null,settings)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$organism,cljs.core.cst$kw$shortName], null));
if(cljs.core.truth_(temp__6751__auto__)){
var sn = temp__6751__auto__;
return sn;
} else {
return "All Organisms";
}
})(),cljs.core.cst$kw$on_DASH_change,((function (settings){
return (function (organism){
var G__30524 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions_SLASH_set_DASH_selected_DASH_organism,organism], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__30524) : re_frame.core.dispatch.call(null,G__30524));
});})(settings))
], null)], null)], null);
});
/**
 * UI component allowing user to type in the regions they wish to search for
 */
redgenes.sections.regions.views.region_input_box = (function redgenes$sections$regions$views$region_input_box(){
return reagent.core.create_class((function (){var to_search = (function (){var G__30531 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions_SLASH_to_DASH_search], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__30531) : re_frame.core.subscribe.call(null,G__30531));
})();
var results = (function (){var G__30532 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions_SLASH_results], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__30532) : re_frame.core.subscribe.call(null,G__30532));
})();
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$reagent_DASH_render,((function (to_search,results){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$textarea$form_DASH_control,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$rows,(cljs.core.truth_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(results) : cljs.core.deref.call(null,results)))?(3):(6)),cljs.core.cst$kw$placeholder,[cljs.core.str("Type chromosome coords here, or click [Show me an example] above.")].join(''),cljs.core.cst$kw$value,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(to_search) : cljs.core.deref.call(null,to_search)),cljs.core.cst$kw$on_DASH_change,((function (to_search,results){
return (function (e){
var G__30533 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions_SLASH_set_DASH_to_DASH_search,(function (){var target_obj_30534 = e;
var next_obj_30535 = (target_obj_30534["target"]);
var next_obj_30536 = (next_obj_30535["value"]);
return next_obj_30536;
})()], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__30533) : re_frame.core.dispatch.call(null,G__30533));
});})(to_search,results))
], null)], null);
});})(to_search,results))
,cljs.core.cst$kw$component_DASH_did_DASH_mount,((function (to_search,results){
return (function (this$){
return reagent.core.dom_node(this$).focus();
});})(to_search,results))
], null);
})());
});
redgenes.sections.regions.views.clear_textbox = (function redgenes$sections$regions$views$clear_textbox(){

var to_search = (function (){var G__30539 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions_SLASH_to_DASH_search], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__30539) : re_frame.core.subscribe.call(null,G__30539));
})();
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.sections.regions.views.css_transition_group,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$transition_DASH_name,"fade",cljs.core.cst$kw$transition_DASH_enter_DASH_timeout,(2000),cljs.core.cst$kw$transition_DASH_leave_DASH_timeout,(2000),cljs.core.cst$kw$component,"div"], null),(cljs.core.truth_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(to_search) : cljs.core.deref.call(null,to_search)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$clear_DASH_textbox,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,((function (to_search){
return (function (){
var G__30540 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions_SLASH_set_DASH_to_DASH_search,null], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__30540) : re_frame.core.dispatch.call(null,G__30540));
});})(to_search))
,cljs.core.cst$kw$title,"Clear this textbox"], null),"\u2716"], null):null)], null);
});
redgenes.sections.regions.views.region_input = (function redgenes$sections$regions$views$region_input(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$region_DASH_input,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,"Regions to search ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.bootstrap.popover,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_question_DASH_circle,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_DASH_content,redgenes.sections.regions.views.region_help_content_popover,cljs.core.cst$kw$data_DASH_trigger,"hover",cljs.core.cst$kw$data_DASH_placement,"bottom"], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$region_DASH_text,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.sections.regions.views.clear_textbox], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.sections.regions.views.region_input_box], null)], null)], null);
});
/**
 * UI component ot allow user to select which types of overlapping features to find
 */
redgenes.sections.regions.views.checkboxes = (function redgenes$sections$regions$views$checkboxes(to_search,settings){
var all_selected_QMARK_ = (function (){var G__30545 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions_SLASH_sequence_DASH_feature_DASH_type_DASH_all_DASH_selected_QMARK_], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__30545) : re_frame.core.subscribe.call(null,G__30545));
})();
var results = (function (){var G__30546 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions_SLASH_results], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__30546) : re_frame.core.subscribe.call(null,G__30546));
})();
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$checkboxes,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_fw,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$class,(cljs.core.truth_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(all_selected_QMARK_) : cljs.core.deref.call(null,all_selected_QMARK_)))?"fa-check-square-o":"fa-square-o"),cljs.core.cst$kw$title,(cljs.core.truth_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(all_selected_QMARK_) : cljs.core.deref.call(null,all_selected_QMARK_)))?"Deselect all":"Select all"),cljs.core.cst$kw$on_DASH_click,(cljs.core.truth_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(all_selected_QMARK_) : cljs.core.deref.call(null,all_selected_QMARK_)))?((function (all_selected_QMARK_,results){
return (function (){
var G__30547 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions_SLASH_deselect_DASH_all_DASH_feature_DASH_types], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__30547) : re_frame.core.dispatch.call(null,G__30547));
});})(all_selected_QMARK_,results))
:((function (all_selected_QMARK_,results){
return (function (){
var G__30548 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions_SLASH_select_DASH_all_DASH_feature_DASH_types], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__30548) : re_frame.core.dispatch.call(null,G__30548));
});})(all_selected_QMARK_,results))
)], null)], null),"Features to include"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$feature_DASH_tree_DASH_container,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,(cljs.core.truth_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(results) : cljs.core.deref.call(null,results)))?"shrinkified":null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.sections.regions.views.feature_types_tree], null)], null)], null);
});
/**
 * Entire UI input section / top half of the region search
 */
redgenes.sections.regions.views.input_section = (function redgenes$sections$regions$views$input_section(){
var settings = (function (){var G__30566 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions_SLASH_settings], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__30566) : re_frame.core.subscribe.call(null,G__30566));
})();
var to_search = (function (){var G__30567 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions_SLASH_to_DASH_search], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__30567) : re_frame.core.subscribe.call(null,G__30567));
})();
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$row$input_DASH_section,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$organism_DASH_and_DASH_regions,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.sections.regions.views.region_input], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.sections.regions.views.organism_selection], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_primary$btn_DASH_raised$fattysubmitbutton,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$disabled,(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(to_search) : cljs.core.deref.call(null,to_search)))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(to_search) : cljs.core.deref.call(null,to_search)))) || (cljs.core.empty_QMARK_(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (settings,to_search){
return (function (p__30572){
var vec__30573 = p__30572;
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30573,(0),null);
var enabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30573,(1),null);
return enabled_QMARK_;
});})(settings,to_search))
,cljs.core.cst$kw$feature_DASH_types.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(settings) : cljs.core.deref.call(null,settings)))))),cljs.core.cst$kw$on_DASH_click,((function (settings,to_search){
return (function (e){
var G__30576_30583 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions_SLASH_run_DASH_query], null);
(re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__30576_30583) : re_frame.core.dispatch.call(null,G__30576_30583));

var target_obj_30577 = (function (){var target_obj_30581 = e;
var next_obj_30582 = (target_obj_30581["target"]);
return next_obj_30582;
})();
var call_info_30579 = [target_obj_30577,(function (){var next_obj_30580 = (target_obj_30577["blur"]);
return next_obj_30580;
})()];
var fn_30578 = (call_info_30579[(1)]);
if(!((fn_30578 == null))){
return fn_30578.call((call_info_30579[(0)]));
} else {
return null;
}
});})(settings,to_search))
,cljs.core.cst$kw$title,"Enter something into the 'Regions to search' box or click on [Show me an example], then click here! :)"], null),"Search"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.sections.regions.views.checkboxes,to_search,settings], null)], null);
});
redgenes.sections.regions.views.main = (function redgenes$sections$regions$views$main(){
return reagent.core.create_class(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$component_DASH_did_DASH_mount,(function (){
var G__30586 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions_SLASH_select_DASH_all_DASH_feature_DASH_types], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__30586) : re_frame.core.dispatch.call(null,G__30586));
}),cljs.core.cst$kw$reagent_DASH_render,(function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$container$regionsearch,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$headerwithguidance,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h1,"Region Search"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$guidance,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_click,(function (){
var G__30587 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions_SLASH_set_DASH_to_DASH_search,redgenes.sections.regions.views.ex()], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__30587) : re_frame.core.dispatch.call(null,G__30587));
})], null),"[Show me an example]"], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.sections.regions.views.input_section], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.sections.regions.results.results_section], null)], null);
})], null));
});
