// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('redgenes.sections.saveddata.events');
goog.require('cljs.core');
goog.require('cljs_uuid_utils.core');
goog.require('cljs_time.core');
goog.require('imcljsold.filters');
goog.require('imcljsold.search');
goog.require('cljs.spec');
goog.require('imcljsold.operations');
goog.require('cljs.core.async');
goog.require('redgenes.interceptors');
goog.require('clojure.set');
goog.require('accountant.core');
goog.require('re_frame.core');
redgenes.sections.saveddata.events.event_namespace = cljs.core.cst$kw$saved_DASH_data;
/**
 * Creates a fully qualified keyword for events
 */
redgenes.sections.saveddata.events.ekw = (function redgenes$sections$saveddata$events$ekw(kw){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(cljs.core.name(redgenes.sections.saveddata.events.event_namespace),cljs.core.name(kw));
});
/**
 * Sugar function for assoc'ing a value somewhere in app db
 *   (reg-event-db :store-results (put-at [:assoc-in-here :then-here])
 */
redgenes.sections.saveddata.events.put_at = (function redgenes$sections$saveddata$events$put_at(where){
return (function (db,p__32350){
var vec__32351 = p__32350;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32351,(0),null);
var results = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32351,(1),null);
return cljs.core.assoc_in(db,where,results);
});
});
/**
 * Sugar function for updating a value somewhere in app db
 *   (reg-event-db :update-results (run-at [:assoc-in-here :then-here] not)
 */
redgenes.sections.saveddata.events.update_at = (function redgenes$sections$saveddata$events$update_at(where,f){
return (function (db){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(db,where,f);
});
});
/**
 * Returns the index of a map in a collection.
 *   Accepts optional argument for only matching on certain keys
 */
redgenes.sections.saveddata.events.index_of_map = (function redgenes$sections$saveddata$events$index_of_map(var_args){
var args__8442__auto__ = [];
var len__8435__auto___32363 = arguments.length;
var i__8436__auto___32364 = (0);
while(true){
if((i__8436__auto___32364 < len__8435__auto___32363)){
args__8442__auto__.push((arguments[i__8436__auto___32364]));

var G__32365 = (i__8436__auto___32364 + (1));
i__8436__auto___32364 = G__32365;
continue;
} else {
}
break;
}

var argseq__8443__auto__ = ((((2) < args__8442__auto__.length))?(new cljs.core.IndexedSeq(args__8442__auto__.slice((2)),(0),null)):null);
return redgenes.sections.saveddata.events.index_of_map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8443__auto__);
});

redgenes.sections.saveddata.events.index_of_map.cljs$core$IFn$_invoke$arity$variadic = (function (e,coll,p__32359){
var vec__32360 = p__32359;
var keys_to_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32360,(0),null);
return cljs.core.first(cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2(((function (vec__32360,keys_to_match){
return (function (p1__32355_SHARP_,p2__32354_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((cljs.core.truth_(keys_to_match)?cljs.core.select_keys(e,keys_to_match):e),(cljs.core.truth_(keys_to_match)?cljs.core.select_keys(p2__32354_SHARP_,keys_to_match):p2__32354_SHARP_))){
return p1__32355_SHARP_;
} else {
return null;
}
});})(vec__32360,keys_to_match))
,coll));
});

redgenes.sections.saveddata.events.index_of_map.cljs$lang$maxFixedArity = (2);

redgenes.sections.saveddata.events.index_of_map.cljs$lang$applyTo = (function (seq32356){
var G__32357 = cljs.core.first(seq32356);
var seq32356__$1 = cljs.core.next(seq32356);
var G__32358 = cljs.core.first(seq32356__$1);
var seq32356__$2 = cljs.core.next(seq32356__$1);
return redgenes.sections.saveddata.events.index_of_map.cljs$core$IFn$_invoke$arity$variadic(G__32357,G__32358,seq32356__$2);
});

redgenes.sections.saveddata.events.when_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$1(re_frame.core.reg_event_db);
/**
 * Get all of the different parts of an intermine query and group them by type
 */
redgenes.sections.saveddata.events.get_parts = (function redgenes$sections$saveddata$events$get_parts(model,query){
return cljs.core.group_by(cljs.core.cst$kw$type,cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (path){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$type,imcljsold.filters.im_type(model,path),cljs.core.array_seq([cljs.core.cst$kw$path,[cljs.core.str(imcljsold.filters.trim_path_to_class(model,path)),cljs.core.str(".id")].join('')], 0));
}),cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(query))));
});
/**
 * If data does not validate to a spec then throw the reason
 */
redgenes.sections.saveddata.events.validate_spec_and_throw = (function redgenes$sections$saveddata$events$validate_spec_and_throw(spec,data){
if(cljs.core.not(cljs.spec.valid_QMARK_.cljs$core$IFn$_invoke$arity$2(spec,data))){
throw cljs.spec.explain_str(spec,data);
} else {
return null;
}
});
var G__32366_32368 = cljs.core.cst$kw$open_DASH_saved_DASH_data_DASH_tooltip;
var G__32367_32369 = redgenes.sections.saveddata.events.put_at(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tooltip,cljs.core.cst$kw$saved_DASH_data], null));
(redgenes.sections.saveddata.events.when_event.cljs$core$IFn$_invoke$arity$2 ? redgenes.sections.saveddata.events.when_event.cljs$core$IFn$_invoke$arity$2(G__32366_32368,G__32367_32369) : redgenes.sections.saveddata.events.when_event.call(null,G__32366_32368,G__32367_32369));
var G__32370_32372 = redgenes.sections.saveddata.events.ekw(cljs.core.cst$kw$toggle_DASH_edit_DASH_mode);
var G__32371_32373 = redgenes.sections.saveddata.events.update_at(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data,cljs.core.cst$kw$list_DASH_operations_DASH_enabled], null),cljs.core.not);
(redgenes.sections.saveddata.events.when_event.cljs$core$IFn$_invoke$arity$2 ? redgenes.sections.saveddata.events.when_event.cljs$core$IFn$_invoke$arity$2(G__32370_32372,G__32371_32373) : redgenes.sections.saveddata.events.when_event.call(null,G__32370_32372,G__32371_32373));
var G__32374_32376 = redgenes.sections.saveddata.events.ekw(cljs.core.cst$kw$save_DASH_operation_DASH_results);
var G__32375_32377 = redgenes.sections.saveddata.events.put_at(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data,cljs.core.cst$kw$editor,cljs.core.cst$kw$results], null));
(redgenes.sections.saveddata.events.when_event.cljs$core$IFn$_invoke$arity$2 ? redgenes.sections.saveddata.events.when_event.cljs$core$IFn$_invoke$arity$2(G__32374_32376,G__32375_32377) : redgenes.sections.saveddata.events.when_event.call(null,G__32374_32376,G__32375_32377));
var G__32378_32380 = redgenes.sections.saveddata.events.ekw(cljs.core.cst$kw$editor_DASH_is_DASH_editing);
var G__32379_32381 = redgenes.sections.saveddata.events.put_at(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data,cljs.core.cst$kw$editor,cljs.core.cst$kw$editing_QMARK_], null));
(redgenes.sections.saveddata.events.when_event.cljs$core$IFn$_invoke$arity$2 ? redgenes.sections.saveddata.events.when_event.cljs$core$IFn$_invoke$arity$2(G__32378_32380,G__32379_32381) : redgenes.sections.saveddata.events.when_event.call(null,G__32378_32380,G__32379_32381));
redgenes.sections.saveddata.events.one_of_QMARK_ = (function redgenes$sections$saveddata$events$one_of_QMARK_(haystack,needle){
return cljs.core.some_QMARK_(cljs.core.some(cljs.core.PersistentHashSet.fromArray([needle], true),haystack));
});
cljs.spec.def_impl(cljs.core.cst$kw$sd_SLASH_type,cljs.core.list(cljs.core.cst$sym$cljs$spec_SLASH_and,cljs.core.cst$sym$cljs$core_SLASH_keyword_QMARK_,cljs.core.list(cljs.core.cst$sym$cljs$core_SLASH_partial,cljs.core.cst$sym$redgenes$sections$saveddata$events_SLASH_one_DASH_of_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$list,cljs.core.cst$kw$query], null))),cljs.spec.and_spec_impl(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cljs$core_SLASH_keyword_QMARK_,cljs.core.list(cljs.core.cst$sym$cljs$core_SLASH_partial,cljs.core.cst$sym$redgenes$sections$saveddata$events_SLASH_one_DASH_of_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$list,cljs.core.cst$kw$query], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword_QMARK_,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(redgenes.sections.saveddata.events.one_of_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$list,cljs.core.cst$kw$query], null))], null),null));
cljs.spec.def_impl(cljs.core.cst$kw$sd_SLASH_service,cljs.core.cst$sym$cljs$core_SLASH_keyword_QMARK_,cljs.core.keyword_QMARK_);
redgenes.sections.saveddata.events.saved_data_spec = cljs.spec.map_spec_impl(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$req_DASH_un,cljs.core.cst$kw$opt_DASH_un,cljs.core.cst$kw$gfn,cljs.core.cst$kw$pred_DASH_exprs,cljs.core.cst$kw$opt_DASH_keys,cljs.core.cst$kw$req_DASH_specs,cljs.core.cst$kw$req,cljs.core.cst$kw$req_DASH_keys,cljs.core.cst$kw$opt_DASH_specs,cljs.core.cst$kw$pred_DASH_forms,cljs.core.cst$kw$opt],[null,null,null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.map_QMARK_,(function (p1__25019__25020__auto__){
return cljs.core.contains_QMARK_(p1__25019__25020__auto__,cljs.core.cst$kw$sd_SLASH_type);
}),(function (p1__25019__25020__auto__){
return cljs.core.contains_QMARK_(p1__25019__25020__auto__,cljs.core.cst$kw$sd_SLASH_value);
}),(function (p1__25019__25020__auto__){
return cljs.core.contains_QMARK_(p1__25019__25020__auto__,cljs.core.cst$kw$sd_SLASH_service);
})], null),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$sd_SLASH_type,cljs.core.cst$kw$sd_SLASH_value,cljs.core.cst$kw$sd_SLASH_service], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$sd_SLASH_type,cljs.core.cst$kw$sd_SLASH_value,cljs.core.cst$kw$sd_SLASH_service], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$sd_SLASH_type,cljs.core.cst$kw$sd_SLASH_value,cljs.core.cst$kw$sd_SLASH_service], null),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cljs$core_SLASH_map_QMARK_,cljs.core.list(cljs.core.cst$sym$cljs$core_SLASH_fn,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_PERCENT_], null),cljs.core.list(cljs.core.cst$sym$cljs$core_SLASH_contains_QMARK_,cljs.core.cst$sym$_PERCENT_,cljs.core.cst$kw$sd_SLASH_type)),cljs.core.list(cljs.core.cst$sym$cljs$core_SLASH_fn,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_PERCENT_], null),cljs.core.list(cljs.core.cst$sym$cljs$core_SLASH_contains_QMARK_,cljs.core.cst$sym$_PERCENT_,cljs.core.cst$kw$sd_SLASH_value)),cljs.core.list(cljs.core.cst$sym$cljs$core_SLASH_fn,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_PERCENT_], null),cljs.core.list(cljs.core.cst$sym$cljs$core_SLASH_contains_QMARK_,cljs.core.cst$sym$_PERCENT_,cljs.core.cst$kw$sd_SLASH_service))], null),null]));
redgenes.sections.saveddata.events.save_data_fn = (function redgenes$sections$saveddata$events$save_data_fn(p__32382,p__32383){
var map__32390 = p__32382;
var map__32390__$1 = ((((!((map__32390 == null)))?((((map__32390.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32390.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32390):map__32390);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32390__$1,cljs.core.cst$kw$db);
var vec__32391 = p__32383;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32391,(0),null);
var data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32391,(1),null);
var new_id = [cljs.core.str(cljs_uuid_utils.core.make_random_uuid())].join('');
var model = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets,cljs.core.cst$kw$model], null));
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data,cljs.core.cst$kw$items,new_id], null),(function (){var G__32395 = data;
var G__32395__$1 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([G__32395,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$sd_SLASH_created,cljs_time.core.now(),cljs.core.cst$kw$sd_SLASH_updated,cljs_time.core.now(),cljs.core.cst$kw$sd_SLASH_id,new_id], null)], 0))
;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$query,cljs.core.cst$kw$sd_SLASH_type.cljs$core$IFn$_invoke$arity$1(data))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__32395__$1,cljs.core.cst$kw$sd_SLASH_parts,redgenes.sections.saveddata.events.get_parts(model,cljs.core.cst$kw$sd_SLASH_value.cljs$core$IFn$_invoke$arity$1(data)));
} else {
return G__32395__$1;
}
})()),cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$open_DASH_saved_DASH_data_DASH_tooltip,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$label,cljs.core.cst$kw$label.cljs$core$IFn$_invoke$arity$1(data),cljs.core.cst$kw$id,new_id], null)], null)], null);
});
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$save_DASH_data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.interceptors.abort_spec(redgenes.sections.saveddata.events.saved_data_spec)], null),redgenes.sections.saveddata.events.save_data_fn);
redgenes.sections.saveddata.events.list__GT_sd = (function redgenes$sections$saveddata$events$list__GT_sd(list){
return cljs.core.PersistentArrayMap.fromArray([cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(list),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$sd_SLASH_created,cljs_time.core.now(),cljs.core.cst$kw$sd_SLASH_updated,cljs_time.core.now(),cljs.core.cst$kw$sd_SLASH_count,cljs.core.cst$kw$size.cljs$core$IFn$_invoke$arity$1(list),cljs.core.cst$kw$sd_SLASH_id,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(list),cljs.core.cst$kw$sd_SLASH_type,cljs.core.cst$kw$list,cljs.core.cst$kw$sd_SLASH_label,cljs.core.cst$kw$title.cljs$core$IFn$_invoke$arity$1(list),cljs.core.cst$kw$sd_SLASH_value,list], null)], true, false);
});
redgenes.sections.saveddata.events.create_query_from_list = (function redgenes$sections$saveddata$events$create_query_from_list(db,value){
var summary_fields = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets,cljs.core.cst$kw$summary_DASH_fields,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(value))], null));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$from,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(value),cljs.core.cst$kw$select,summary_fields,cljs.core.cst$kw$where,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$path,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(value),cljs.core.cst$kw$op,"IN",cljs.core.cst$kw$value,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(value)], null)], null)], null);
});
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$saved_DASH_data_SLASH_view_DASH_query,(function (p__32396,p__32397){
var map__32398 = p__32396;
var map__32398__$1 = ((((!((map__32398 == null)))?((((map__32398.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32398.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32398):map__32398);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32398__$1,cljs.core.cst$kw$db);
var vec__32399 = p__32397;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32399,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32399,(1),null);
var saved_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data,cljs.core.cst$kw$items,id], null));
var query = (function (){var G__32403 = (((cljs.core.cst$kw$sd_SLASH_type.cljs$core$IFn$_invoke$arity$1(saved_data) instanceof cljs.core.Keyword))?cljs.core.cst$kw$sd_SLASH_type.cljs$core$IFn$_invoke$arity$1(saved_data).fqn:null);
switch (G__32403) {
case "query":
return cljs.core.cst$kw$sd_SLASH_value.cljs$core$IFn$_invoke$arity$1(saved_data);

break;
case "list":
return redgenes.sections.saveddata.events.create_query_from_list(db,cljs.core.cst$kw$sd_SLASH_value.cljs$core$IFn$_invoke$arity$1(saved_data));

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(cljs.core.cst$kw$sd_SLASH_type.cljs$core$IFn$_invoke$arity$1(saved_data))].join('')));

}
})();
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results_SLASH_set_DASH_query,query], null),cljs.core.cst$kw$navigate,"results"], null);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$saved_DASH_data_SLASH_load_DASH_lists,(function (db){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data,cljs.core.cst$kw$items], null),cljs.core.merge,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(redgenes.sections.saveddata.events.list__GT_sd,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets,cljs.core.cst$kw$lists], null)))));
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$save_DASH_saved_DASH_data_DASH_tooltip,(function (db,p__32405){
var vec__32406 = p__32405;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32406,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32406,(1),null);
var label = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32406,(2),null);
return cljs.core.assoc_in(cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data,cljs.core.cst$kw$items,id,cljs.core.cst$kw$label], null),label),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tooltip,cljs.core.cst$kw$saved_DASH_data], null),null);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$saved_DASH_data_SLASH_set_DASH_type_DASH_filter,(function (db,p__32409){
var vec__32410 = p__32409;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32410,(0),null);
var kw = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32410,(1),null);
var clear_QMARK_ = ((1) > cljs.core.count(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data,cljs.core.cst$kw$editor,cljs.core.cst$kw$selected_DASH_items], null)))));
if(clear_QMARK_){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data,cljs.core.cst$kw$editor], null),cljs.core.dissoc,cljs.core.cst$kw$filter);
} else {
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data,cljs.core.cst$kw$editor,cljs.core.cst$kw$filter], null),kw);
}
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$saved_DASH_data_SLASH_toggle_DASH_editable_DASH_item,(function (db,p__32413){
var vec__32414 = p__32413;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32414,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32414,(1),null);
var path_info = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32414,(2),null);
var loc = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data,cljs.core.cst$kw$editor,cljs.core.cst$kw$selected_DASH_items], null);
var keys_to_match = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$path,cljs.core.cst$kw$type], null);
var datum_description = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null),path_info], 0));
var temp__6751__auto__ = redgenes.sections.saveddata.events.index_of_map.cljs$core$IFn$_invoke$arity$variadic(datum_description,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,loc),cljs.core.array_seq([keys_to_match], 0));
if(cljs.core.truth_(temp__6751__auto__)){
var idx = temp__6751__auto__;
return cljs.core.assoc_in(db,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(loc,idx),null);
} else {
var temp__6751__auto____$1 = redgenes.sections.saveddata.events.index_of_map(null,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,loc));
if(cljs.core.truth_(temp__6751__auto____$1)){
var first_nil = temp__6751__auto____$1;
return cljs.core.assoc_in(db,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(loc,first_nil),datum_description);
} else {
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(db,loc,cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),datum_description);
}
}
}));
redgenes.sections.saveddata.events.determine_op = (function redgenes$sections$saveddata$events$determine_op(item_1,item_2){
var keep_1 = cljs.core.cst$kw$keep.cljs$core$IFn$_invoke$arity$1(item_1);
var keep_2 = cljs.core.cst$kw$keep.cljs$core$IFn$_invoke$arity$1(item_2);
if(cljs.core.truth_((function (){var and__7207__auto__ = cljs.core.cst$kw$self.cljs$core$IFn$_invoke$arity$1(keep_1);
if(cljs.core.truth_(and__7207__auto__)){
var and__7207__auto____$1 = cljs.core.cst$kw$self.cljs$core$IFn$_invoke$arity$1(keep_2);
if(cljs.core.truth_(and__7207__auto____$1)){
var and__7207__auto____$2 = cljs.core.cst$kw$intersection.cljs$core$IFn$_invoke$arity$1(keep_1);
if(cljs.core.truth_(and__7207__auto____$2)){
return cljs.core.cst$kw$intersection.cljs$core$IFn$_invoke$arity$1(keep_2);
} else {
return and__7207__auto____$2;
}
} else {
return and__7207__auto____$1;
}
} else {
return and__7207__auto__;
}
})())){
return cljs.core.cst$kw$union;
} else {
if(cljs.core.truth_((function (){var and__7207__auto__ = (cljs.core.not(cljs.core.cst$kw$self.cljs$core$IFn$_invoke$arity$1(keep_1))) && (cljs.core.not(cljs.core.cst$kw$self.cljs$core$IFn$_invoke$arity$1(keep_2)));
if(and__7207__auto__){
var and__7207__auto____$1 = cljs.core.cst$kw$intersection.cljs$core$IFn$_invoke$arity$1(keep_1);
if(cljs.core.truth_(and__7207__auto____$1)){
return cljs.core.cst$kw$intersection.cljs$core$IFn$_invoke$arity$1(keep_2);
} else {
return and__7207__auto____$1;
}
} else {
return and__7207__auto__;
}
})())){
return cljs.core.cst$kw$intersection;
} else {
if(cljs.core.truth_((function (){var and__7207__auto__ = (function (){var and__7207__auto__ = cljs.core.cst$kw$self.cljs$core$IFn$_invoke$arity$1(keep_1);
if(cljs.core.truth_(and__7207__auto__)){
return cljs.core.not(cljs.core.cst$kw$self.cljs$core$IFn$_invoke$arity$1(keep_2));
} else {
return and__7207__auto__;
}
})();
if(cljs.core.truth_(and__7207__auto__)){
return (cljs.core.not(cljs.core.cst$kw$intersection.cljs$core$IFn$_invoke$arity$1(keep_1))) && (cljs.core.not(cljs.core.cst$kw$intersection.cljs$core$IFn$_invoke$arity$1(keep_2)));
} else {
return and__7207__auto__;
}
})())){
return cljs.core.cst$kw$left_DASH_difference;
} else {
if(cljs.core.truth_((function (){var and__7207__auto__ = (function (){var and__7207__auto__ = cljs.core.not(cljs.core.cst$kw$self.cljs$core$IFn$_invoke$arity$1(keep_1));
if(and__7207__auto__){
return cljs.core.cst$kw$self.cljs$core$IFn$_invoke$arity$1(keep_2);
} else {
return and__7207__auto__;
}
})();
if(cljs.core.truth_(and__7207__auto__)){
return (cljs.core.not(cljs.core.cst$kw$intersection.cljs$core$IFn$_invoke$arity$1(keep_1))) && (cljs.core.not(cljs.core.cst$kw$intersection.cljs$core$IFn$_invoke$arity$1(keep_2)));
} else {
return and__7207__auto__;
}
})())){
return cljs.core.cst$kw$right_DASH_difference;
} else {
if(cljs.core.truth_((function (){var and__7207__auto__ = (function (){var and__7207__auto__ = cljs.core.cst$kw$self.cljs$core$IFn$_invoke$arity$1(keep_1);
if(cljs.core.truth_(and__7207__auto__)){
return cljs.core.cst$kw$self.cljs$core$IFn$_invoke$arity$1(keep_2);
} else {
return and__7207__auto__;
}
})();
if(cljs.core.truth_(and__7207__auto__)){
return (cljs.core.not(cljs.core.cst$kw$intersection.cljs$core$IFn$_invoke$arity$1(keep_1))) && (cljs.core.not(cljs.core.cst$kw$intersection.cljs$core$IFn$_invoke$arity$1(keep_2)));
} else {
return and__7207__auto__;
}
})())){
return cljs.core.cst$kw$subtract;
} else {
return cljs.core.cst$kw$notfound;

}
}
}
}
}
});
var G__32417_32503 = cljs.core.cst$kw$perform_DASH_op;
var G__32418_32504 = ((function (G__32417_32503){
return (function (p__32419){
var vec__32420 = p__32419;
var mine_url = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32420,(0),null);
var q1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32420,(1),null);
var q2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32420,(2),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32420,(3),null);
var c__14702__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14702__auto__,vec__32420,mine_url,q1,q2,op,G__32417_32503){
return (function (){
var f__14703__auto__ = (function (){var switch__14623__auto__ = ((function (c__14702__auto__,vec__32420,mine_url,q1,q2,op,G__32417_32503){
return (function (state_32479){
var state_val_32480 = (state_32479[(1)]);
if((state_val_32480 === (1))){
var inst_32426 = [cljs.core.cst$kw$root];
var inst_32427 = [mine_url];
var inst_32428 = cljs.core.PersistentHashMap.fromArrays(inst_32426,inst_32427);
var inst_32429 = imcljsold.operations.operation(inst_32428,q1,q2);
var state_32479__$1 = state_32479;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32479__$1,(2),inst_32429);
} else {
if((state_val_32480 === (2))){
var inst_32431 = (state_32479[(2)]);
var inst_32432 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32431,(0),null);
var inst_32433 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32431,(1),null);
var state_32479__$1 = (function (){var statearr_32481 = state_32479;
(statearr_32481[(7)] = inst_32433);

(statearr_32481[(8)] = inst_32432);

return statearr_32481;
})();
var G__32482_32505 = (((op instanceof cljs.core.Keyword))?op.fqn:null);
switch (G__32482_32505) {
case "union":
var statearr_32483_32507 = state_32479__$1;
(statearr_32483_32507[(1)] = (4));


break;
case "intersection":
var statearr_32484_32508 = state_32479__$1;
(statearr_32484_32508[(1)] = (5));


break;
case "left-difference":
var statearr_32485_32509 = state_32479__$1;
(statearr_32485_32509[(1)] = (6));


break;
case "right-difference":
var statearr_32486_32510 = state_32479__$1;
(statearr_32486_32510[(1)] = (7));


break;
case "subtract":
var statearr_32487_32511 = state_32479__$1;
(statearr_32487_32511[(1)] = (8));


break;
default:
var statearr_32488_32512 = state_32479__$1;
(statearr_32488_32512[(1)] = (9));



}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32480 === (3))){
var inst_32448 = (state_32479[(2)]);
var inst_32449 = [cljs.core.cst$kw$from,cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_32450 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32451 = ["Gene.id"];
var inst_32452 = (new cljs.core.PersistentVector(null,1,(5),inst_32450,inst_32451,null));
var inst_32453 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32454 = [cljs.core.cst$kw$path,cljs.core.cst$kw$op,cljs.core.cst$kw$values];
var inst_32455 = cljs.core.PersistentVector.EMPTY;
var inst_32456 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_32455,inst_32448);
var inst_32457 = ["id","ONE OF",inst_32456];
var inst_32458 = cljs.core.PersistentHashMap.fromArrays(inst_32454,inst_32457);
var inst_32459 = [inst_32458];
var inst_32460 = (new cljs.core.PersistentVector(null,1,(5),inst_32453,inst_32459,null));
var inst_32461 = ["Gene",inst_32452,inst_32460];
var inst_32462 = cljs.core.PersistentHashMap.fromArrays(inst_32449,inst_32461);
var inst_32463 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32464 = [cljs.core.cst$kw$saved_DASH_data_SLASH_save_DASH_operation_DASH_results,inst_32462];
var inst_32465 = (new cljs.core.PersistentVector(null,2,(5),inst_32463,inst_32464,null));
var inst_32466 = (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(inst_32465) : re_frame.core.dispatch.call(null,inst_32465));
var inst_32467 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32468 = [cljs.core.cst$kw$value,cljs.core.cst$kw$type,cljs.core.cst$kw$label];
var inst_32469 = [inst_32462,cljs.core.cst$kw$query,"New Datum"];
var inst_32470 = cljs.core.PersistentHashMap.fromArrays(inst_32468,inst_32469);
var inst_32471 = [cljs.core.cst$kw$save_DASH_data,inst_32470];
var inst_32472 = (new cljs.core.PersistentVector(null,2,(5),inst_32467,inst_32471,null));
var inst_32473 = (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(inst_32472) : re_frame.core.dispatch.call(null,inst_32472));
var inst_32474 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32475 = [cljs.core.cst$kw$saved_DASH_data_SLASH_editor_DASH_is_DASH_editing,false];
var inst_32476 = (new cljs.core.PersistentVector(null,2,(5),inst_32474,inst_32475,null));
var inst_32477 = (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(inst_32476) : re_frame.core.dispatch.call(null,inst_32476));
var state_32479__$1 = (function (){var statearr_32489 = state_32479;
(statearr_32489[(9)] = inst_32473);

(statearr_32489[(10)] = inst_32466);

return statearr_32489;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_32479__$1,inst_32477);
} else {
if((state_val_32480 === (4))){
var inst_32433 = (state_32479[(7)]);
var inst_32432 = (state_32479[(8)]);
var inst_32434 = clojure.set.union.cljs$core$IFn$_invoke$arity$2(inst_32432,inst_32433);
var state_32479__$1 = state_32479;
var statearr_32490_32513 = state_32479__$1;
(statearr_32490_32513[(2)] = inst_32434);

(statearr_32490_32513[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32480 === (5))){
var inst_32433 = (state_32479[(7)]);
var inst_32432 = (state_32479[(8)]);
var inst_32436 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_32432,inst_32433);
var state_32479__$1 = state_32479;
var statearr_32491_32514 = state_32479__$1;
(statearr_32491_32514[(2)] = inst_32436);

(statearr_32491_32514[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32480 === (6))){
var inst_32433 = (state_32479[(7)]);
var inst_32432 = (state_32479[(8)]);
var inst_32438 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_32432,inst_32433);
var state_32479__$1 = state_32479;
var statearr_32492_32515 = state_32479__$1;
(statearr_32492_32515[(2)] = inst_32438);

(statearr_32492_32515[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32480 === (7))){
var inst_32433 = (state_32479[(7)]);
var inst_32432 = (state_32479[(8)]);
var inst_32440 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_32433,inst_32432);
var state_32479__$1 = state_32479;
var statearr_32493_32516 = state_32479__$1;
(statearr_32493_32516[(2)] = inst_32440);

(statearr_32493_32516[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32480 === (8))){
var inst_32433 = (state_32479[(7)]);
var inst_32432 = (state_32479[(8)]);
var inst_32442 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_32432,inst_32433);
var inst_32443 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_32433,inst_32432);
var inst_32444 = clojure.set.union.cljs$core$IFn$_invoke$arity$2(inst_32442,inst_32443);
var state_32479__$1 = state_32479;
var statearr_32494_32517 = state_32479__$1;
(statearr_32494_32517[(2)] = inst_32444);

(statearr_32494_32517[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32480 === (9))){
var state_32479__$1 = state_32479;
var statearr_32495_32518 = state_32479__$1;
(statearr_32495_32518[(2)] = null);

(statearr_32495_32518[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__14702__auto__,vec__32420,mine_url,q1,q2,op,G__32417_32503))
;
return ((function (switch__14623__auto__,c__14702__auto__,vec__32420,mine_url,q1,q2,op,G__32417_32503){
return (function() {
var redgenes$sections$saveddata$events$state_machine__14624__auto__ = null;
var redgenes$sections$saveddata$events$state_machine__14624__auto____0 = (function (){
var statearr_32499 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32499[(0)] = redgenes$sections$saveddata$events$state_machine__14624__auto__);

(statearr_32499[(1)] = (1));

return statearr_32499;
});
var redgenes$sections$saveddata$events$state_machine__14624__auto____1 = (function (state_32479){
while(true){
var ret_value__14625__auto__ = (function (){try{while(true){
var result__14626__auto__ = switch__14623__auto__(state_32479);
if(cljs.core.keyword_identical_QMARK_(result__14626__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14626__auto__;
}
break;
}
}catch (e32500){if((e32500 instanceof Object)){
var ex__14627__auto__ = e32500;
var statearr_32501_32519 = state_32479;
(statearr_32501_32519[(5)] = ex__14627__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32479);

return cljs.core.cst$kw$recur;
} else {
throw e32500;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14625__auto__,cljs.core.cst$kw$recur)){
var G__32520 = state_32479;
state_32479 = G__32520;
continue;
} else {
return ret_value__14625__auto__;
}
break;
}
});
redgenes$sections$saveddata$events$state_machine__14624__auto__ = function(state_32479){
switch(arguments.length){
case 0:
return redgenes$sections$saveddata$events$state_machine__14624__auto____0.call(this);
case 1:
return redgenes$sections$saveddata$events$state_machine__14624__auto____1.call(this,state_32479);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
redgenes$sections$saveddata$events$state_machine__14624__auto__.cljs$core$IFn$_invoke$arity$0 = redgenes$sections$saveddata$events$state_machine__14624__auto____0;
redgenes$sections$saveddata$events$state_machine__14624__auto__.cljs$core$IFn$_invoke$arity$1 = redgenes$sections$saveddata$events$state_machine__14624__auto____1;
return redgenes$sections$saveddata$events$state_machine__14624__auto__;
})()
;})(switch__14623__auto__,c__14702__auto__,vec__32420,mine_url,q1,q2,op,G__32417_32503))
})();
var state__14704__auto__ = (function (){var statearr_32502 = (f__14703__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14703__auto__.cljs$core$IFn$_invoke$arity$0() : f__14703__auto__.call(null));
(statearr_32502[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14702__auto__);

return statearr_32502;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14704__auto__);
});})(c__14702__auto__,vec__32420,mine_url,q1,q2,op,G__32417_32503))
);

return c__14702__auto__;
});})(G__32417_32503))
;
(re_frame.core.reg_fx.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.reg_fx.cljs$core$IFn$_invoke$arity$2(G__32417_32503,G__32418_32504) : re_frame.core.reg_fx.call(null,G__32417_32503,G__32418_32504));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$saved_DASH_data_SLASH_perform_DASH_operation,(function (p__32521){
var map__32522 = p__32521;
var map__32522__$1 = ((((!((map__32522 == null)))?((((map__32522.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32522.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32522):map__32522);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32522__$1,cljs.core.cst$kw$db);
var vec__32524 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((2),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data,cljs.core.cst$kw$editor,cljs.core.cst$kw$selected_DASH_items], null)));
var item_1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32524,(0),null);
var item_2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32524,(1),null);
var op = redgenes.sections.saveddata.events.determine_op(item_1,item_2);
var mine_url = cljs.core.cst$kw$mine_DASH_url.cljs$core$IFn$_invoke$arity$1(db);
var q1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data,cljs.core.cst$kw$items,cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(item_1),cljs.core.cst$kw$value], null)),cljs.core.cst$kw$select,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$path.cljs$core$IFn$_invoke$arity$1(item_1)], null),cljs.core.array_seq([cljs.core.cst$kw$orderBy,null], 0));
var q2 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data,cljs.core.cst$kw$items,cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(item_2),cljs.core.cst$kw$value], null)),cljs.core.cst$kw$select,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$path.cljs$core$IFn$_invoke$arity$1(item_2)], null),cljs.core.array_seq([cljs.core.cst$kw$orderBy,null], 0));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$db,cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data,cljs.core.cst$kw$editor,cljs.core.cst$kw$editing_QMARK_], null),true),cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data_SLASH_editor_DASH_is_DASH_editing,true], null),cljs.core.cst$kw$perform_DASH_op,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [mine_url,q1,q2,op], null)], null);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$save_DASH_datum_DASH_count,(function (db,p__32527){
var vec__32528 = p__32527;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32528,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32528,(1),null);
var c = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32528,(2),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data,cljs.core.cst$kw$items,id,cljs.core.cst$kw$sd_SLASH_count], null),c);
}));
var G__32531_32561 = cljs.core.cst$kw$count_DASH_me;
var G__32532_32562 = ((function (G__32531_32561){
return (function (p__32533){
var vec__32534 = p__32533;
var service = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32534,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32534,(1),null);
var query = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32534,(2),null);
var c__14702__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14702__auto__,vec__32534,service,id,query,G__32531_32561){
return (function (){
var f__14703__auto__ = (function (){var switch__14623__auto__ = ((function (c__14702__auto__,vec__32534,service,id,query,G__32531_32561){
return (function (state_32551){
var state_val_32552 = (state_32551[(1)]);
if((state_val_32552 === (1))){
var inst_32537 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32538 = [cljs.core.cst$kw$root];
var inst_32539 = [service];
var inst_32540 = cljs.core.PersistentHashMap.fromArrays(inst_32538,inst_32539);
var inst_32541 = [cljs.core.cst$kw$format];
var inst_32542 = ["count"];
var inst_32543 = cljs.core.PersistentHashMap.fromArrays(inst_32541,inst_32542);
var inst_32544 = imcljsold.search.raw_query_rows.cljs$core$IFn$_invoke$arity$variadic(inst_32540,query,cljs.core.array_seq([inst_32543], 0));
var state_32551__$1 = (function (){var statearr_32553 = state_32551;
(statearr_32553[(7)] = inst_32537);

return statearr_32553;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32551__$1,(2),inst_32544);
} else {
if((state_val_32552 === (2))){
var inst_32537 = (state_32551[(7)]);
var inst_32546 = (state_32551[(2)]);
var inst_32547 = [cljs.core.cst$kw$save_DASH_datum_DASH_count,id,inst_32546];
var inst_32548 = (new cljs.core.PersistentVector(null,3,(5),inst_32537,inst_32547,null));
var inst_32549 = (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(inst_32548) : re_frame.core.dispatch.call(null,inst_32548));
var state_32551__$1 = state_32551;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32551__$1,inst_32549);
} else {
return null;
}
}
});})(c__14702__auto__,vec__32534,service,id,query,G__32531_32561))
;
return ((function (switch__14623__auto__,c__14702__auto__,vec__32534,service,id,query,G__32531_32561){
return (function() {
var redgenes$sections$saveddata$events$state_machine__14624__auto__ = null;
var redgenes$sections$saveddata$events$state_machine__14624__auto____0 = (function (){
var statearr_32557 = [null,null,null,null,null,null,null,null];
(statearr_32557[(0)] = redgenes$sections$saveddata$events$state_machine__14624__auto__);

(statearr_32557[(1)] = (1));

return statearr_32557;
});
var redgenes$sections$saveddata$events$state_machine__14624__auto____1 = (function (state_32551){
while(true){
var ret_value__14625__auto__ = (function (){try{while(true){
var result__14626__auto__ = switch__14623__auto__(state_32551);
if(cljs.core.keyword_identical_QMARK_(result__14626__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14626__auto__;
}
break;
}
}catch (e32558){if((e32558 instanceof Object)){
var ex__14627__auto__ = e32558;
var statearr_32559_32563 = state_32551;
(statearr_32559_32563[(5)] = ex__14627__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32551);

return cljs.core.cst$kw$recur;
} else {
throw e32558;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14625__auto__,cljs.core.cst$kw$recur)){
var G__32564 = state_32551;
state_32551 = G__32564;
continue;
} else {
return ret_value__14625__auto__;
}
break;
}
});
redgenes$sections$saveddata$events$state_machine__14624__auto__ = function(state_32551){
switch(arguments.length){
case 0:
return redgenes$sections$saveddata$events$state_machine__14624__auto____0.call(this);
case 1:
return redgenes$sections$saveddata$events$state_machine__14624__auto____1.call(this,state_32551);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
redgenes$sections$saveddata$events$state_machine__14624__auto__.cljs$core$IFn$_invoke$arity$0 = redgenes$sections$saveddata$events$state_machine__14624__auto____0;
redgenes$sections$saveddata$events$state_machine__14624__auto__.cljs$core$IFn$_invoke$arity$1 = redgenes$sections$saveddata$events$state_machine__14624__auto____1;
return redgenes$sections$saveddata$events$state_machine__14624__auto__;
})()
;})(switch__14623__auto__,c__14702__auto__,vec__32534,service,id,query,G__32531_32561))
})();
var state__14704__auto__ = (function (){var statearr_32560 = (f__14703__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14703__auto__.cljs$core$IFn$_invoke$arity$0() : f__14703__auto__.call(null));
(statearr_32560[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14702__auto__);

return statearr_32560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14704__auto__);
});})(c__14702__auto__,vec__32534,service,id,query,G__32531_32561))
);

return c__14702__auto__;
});})(G__32531_32561))
;
(re_frame.core.reg_fx.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.reg_fx.cljs$core$IFn$_invoke$arity$2(G__32531_32561,G__32532_32562) : re_frame.core.reg_fx.call(null,G__32531_32561,G__32532_32562));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$saved_DASH_data_SLASH_run_DASH_query_DASH_count,(function (p__32565,p__32566){
var map__32567 = p__32565;
var map__32567__$1 = ((((!((map__32567 == null)))?((((map__32567.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32567.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32567):map__32567);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32567__$1,cljs.core.cst$kw$db);
var vec__32568 = p__32566;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32568,(0),null);
var vec__32571 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32568,(1),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32571,(0),null);
var map__32574 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32571,(1),null);
var map__32574__$1 = ((((!((map__32574 == null)))?((((map__32574.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32574.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32574):map__32574);
var query = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32574__$1,cljs.core.cst$kw$sd_SLASH_value);
var mine_url = cljs.core.cst$kw$mine_DASH_url.cljs$core$IFn$_invoke$arity$1(db);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$count_DASH_me,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [mine_url,id,query], null)], null);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$saved_DASH_data_SLASH_count_DASH_all,(function (p__32577){
var map__32578 = p__32577;
var map__32578__$1 = ((((!((map__32578 == null)))?((((map__32578.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32578.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32578):map__32578);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32578__$1,cljs.core.cst$kw$db);
var make_event = ((function (map__32578,map__32578__$1,db){
return (function redgenes$sections$saveddata$events$make_event(datum){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data_SLASH_run_DASH_query_DASH_count,datum], null);
});})(map__32578,map__32578__$1,db))
;
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$dispatch_DASH_many,cljs.core.map.cljs$core$IFn$_invoke$arity$2(make_event,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data,cljs.core.cst$kw$items], null)))], null);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$saved_DASH_data_SLASH_set_DASH_text_DASH_filter,(function (db,p__32580){
var vec__32581 = p__32580;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32581,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32581,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,"")){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data,cljs.core.cst$kw$editor], null),cljs.core.dissoc,cljs.core.cst$kw$text_DASH_filter);
} else {
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data,cljs.core.cst$kw$editor,cljs.core.cst$kw$text_DASH_filter], null),value);
}
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$saved_DASH_data_SLASH_toggle_DASH_keep,(function (db,p__32584){
var vec__32585 = p__32584;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32585,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32585,(1),null);
var loc = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data,cljs.core.cst$kw$editor,cljs.core.cst$kw$selected_DASH_items], null);
if(cljs.core.truth_(id)){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(db,loc,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.mapv,((function (loc,vec__32585,_,id){
return (function (item){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(item))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(item,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$keep,cljs.core.cst$kw$self], null),cljs.core.not);
} else {
return item;
}
});})(loc,vec__32585,_,id))
));
} else {
return db;
}
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$saved_DASH_data_SLASH_toggle_DASH_keep_DASH_intersections,(function (db){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data,cljs.core.cst$kw$editor,cljs.core.cst$kw$selected_DASH_items], null),cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.map,(function (item){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(item,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$keep,cljs.core.cst$kw$intersection], null),cljs.core.not);
})));
}));
