// Compiled by ClojureScript 1.9.89 {}
goog.provide('redgenes.components.search.typeahead');
goog.require('cljs.core');
goog.require('reagent.core');
goog.require('re_frame.core');
goog.require('accountant.core');
goog.require('redgenes.components.search.views');
goog.require('dommy.core');
/**
 * Navigate to the report page for the given item and reset the UI
 */
redgenes.components.search.typeahead.navigate_to_report = (function redgenes$components$search$typeahead$navigate_to_report(item){
re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("search","reset-selection","search/reset-selection",-1394717115)], null));

return accountant.core.navigate_BANG_.call(null,[cljs.core.str("#/objects/"),cljs.core.str(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(item)),cljs.core.str("/"),cljs.core.str(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(item))].join(''));
});
/**
 * Navigate to the full results page. duh.
 */
redgenes.components.search.typeahead.navigate_to_full_results = (function redgenes$components$search$typeahead$navigate_to_full_results(){
accountant.core.navigate_BANG_.call(null,"#/search");

return redgenes.components.search.views.search.call(null);
});
/**
 * The UI element and behaviour for a single suggestion in the dropdown
 */
redgenes.components.search.typeahead.suggestion = (function redgenes$components$search$typeahead$suggestion(){
var search_term = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"search-term","search-term",356193544)], null));
return ((function (search_term){
return (function (item,is_active_QMARK_){
var info = clojure.string.join.call(null," ",cljs.core.interpose.call(null,", ",cljs.core.vals.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(item))));
var parsed = clojure.string.split.call(null,info,cljs.core.re_pattern.call(null,[cljs.core.str("(?i)"),cljs.core.str(cljs.core.deref.call(null,search_term))].join('')));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.list-group-item","div.list-group-item",983333490),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),((function (info,parsed,search_term){
return (function (e){
var clicked_button = e.button;
if(cljs.core._EQ_.call(null,clicked_button,(0))){
return redgenes.components.search.typeahead.navigate_to_report.call(null,item);
} else {
return null;
}
});})(info,parsed,search_term))
,new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(is_active_QMARK_)?"active":null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.row-content","div.row-content",545270136),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h4.list-group-item-heading","h4.list-group-item-heading",-1606423518),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(item)], null),cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.list-group-item-text","div.list-group-item-text",763964224)], null),cljs.core.interpose.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.highlight","span.highlight",-1499625131),cljs.core.deref.call(null,search_term)], null),cljs.core.map.call(null,((function (info,parsed,search_term){
return (function (part){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),part], null);
});})(info,parsed,search_term))
,parsed)))], null)], null);
});
;})(search_term))
});
redgenes.components.search.typeahead.monitor_enter_key = (function redgenes$components$search$typeahead$monitor_enter_key(e){
var keycode = e.charCode;
var active_selection = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"quicksearch-selected-index","quicksearch-selected-index",532673579)], null));
var results = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"suggestion-results","suggestion-results",-2056023907)], null));
var selected_result = cljs.core.nth.call(null,cljs.core.deref.call(null,results),cljs.core.deref.call(null,active_selection),null);
if(cljs.core._EQ_.call(null,keycode,(13))){
if(cljs.core.truth_(selected_result)){
redgenes.components.search.typeahead.navigate_to_report.call(null,selected_result);
} else {
redgenes.components.search.typeahead.navigate_to_full_results.call(null);
}

return e.target.blur();
} else {
return null;
}
});
/**
 * Navigate the dropdown suggestions if the user presses up or down
 */
redgenes.components.search.typeahead.monitor_arrow_keys = (function redgenes$components$search$typeahead$monitor_arrow_keys(e){
var keycode = e.key;
var input = e.target.value;
if(cljs.core._EQ_.call(null,keycode,"ArrowUp")){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("search","move-selection","search/move-selection",434892888),new cljs.core.Keyword(null,"prev","prev",-1597069226)], null));
} else {
if(cljs.core._EQ_.call(null,keycode,"ArrowDown")){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("search","move-selection","search/move-selection",434892888),new cljs.core.Keyword(null,"next","next",-117701485)], null));
} else {
return null;
}
}
});
/**
 * UI element within the dropdown to show all results.
 */
redgenes.components.search.typeahead.show_all_results = (function redgenes$components$search$typeahead$show_all_results(){
var active_selection = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"quicksearch-selected-index","quicksearch-selected-index",532673579)], null));
var is_active_QMARK_ = cljs.core._EQ_.call(null,(-1),cljs.core.deref.call(null,active_selection));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.show-all.list-group","div.show-all.list-group",1980920743),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),((function (active_selection,is_active_QMARK_){
return (function (e){
var clicked_button = e.button;
if(cljs.core._EQ_.call(null,clicked_button,(0))){
return redgenes.components.search.typeahead.navigate_to_full_results.call(null);
} else {
return null;
}
});})(active_selection,is_active_QMARK_))
], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.list-group-item","div.list-group-item",983333490),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),((is_active_QMARK_)?"active":null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h4","h4",2004862993),"Show all results"], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.list-group-separator","div.list-group-separator",-1974491488)], null)], null);
});
redgenes.components.search.typeahead.main = (function redgenes$components$search$typeahead$main(){
return reagent.core.create_class.call(null,(function (){var results = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"suggestion-results","suggestion-results",-2056023907)], null));
var search_term = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"search-term","search-term",356193544)], null));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),((function (results,search_term){
return (function (e){
var node = reagent.core.dom_node.call(null,e);
return dommy.core.listen_BANG_.call(null,dommy.core.listen_BANG_.call(null,(dommy.utils.__GT_Array.call(null,node.getElementsByTagName("input"))[(0)]),new cljs.core.Keyword(null,"focus","focus",234677911),((function (node,results,search_term){
return (function (){
return dommy.core.add_class_BANG_.call(null,node,new cljs.core.Keyword(null,"open","open",-1763596448));
});})(node,results,search_term))
),new cljs.core.Keyword(null,"blur","blur",-453500461),((function (node,results,search_term){
return (function (){
return dommy.core.remove_class_BANG_.call(null,node,new cljs.core.Keyword(null,"open","open",-1763596448));
});})(node,results,search_term))
);
});})(results,search_term))
,new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),((function (results,search_term){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.dropdown","div.dropdown",1029783296),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input.form-control.input-lg.square","input.form-control.input-lg.square",-855549573),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"type","type",1174270348),"text",new cljs.core.Keyword(null,"value","value",305978217),cljs.core.deref.call(null,search_term),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),"Search",new cljs.core.Keyword(null,"on-change","on-change",-732046149),((function (results,search_term){
return (function (p1__27468_SHARP_){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"bounce-search","bounce-search",-363251705),p1__27468_SHARP_.target.value], null));
});})(results,search_term))
,new cljs.core.Keyword(null,"on-key-press","on-key-press",-399563677),((function (results,search_term){
return (function (e){
return redgenes.components.search.typeahead.monitor_enter_key.call(null,e);
});})(results,search_term))
,new cljs.core.Keyword(null,"on-key-up","on-key-up",884441808),((function (results,search_term){
return (function (e){
return redgenes.components.search.typeahead.monitor_arrow_keys.call(null,e);
});})(results,search_term))
], null)], null),(((cljs.core.count.call(null,cljs.core.deref.call(null,results)) > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.dropdown-menu","div.dropdown-menu",-1884774306),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.search.typeahead.show_all_results], null),cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.list-group","div.list-group",1215632197)], null),cljs.core.interpose.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.list-group-separator","div.list-group-separator",-1974491488)], null),cljs.core.map_indexed.call(null,((function (results,search_term){
return (function (index,result){
var active_selection = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"quicksearch-selected-index","quicksearch-selected-index",532673579)], null));
var is_active_QMARK_ = cljs.core._EQ_.call(null,index,cljs.core.deref.call(null,active_selection));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.search.typeahead.suggestion,result,is_active_QMARK_], null);
});})(results,search_term))
,cljs.core.deref.call(null,results))))], null):null)], null);
});})(results,search_term))
], null);
})());
});

//# sourceMappingURL=typeahead.js.map?rel=1473935461474