(ns im-tables.core
  (:require [reagent.core :as reagent]
            [re-frame.core :as re-frame]
            [im-tables.events]
            [im-tables.subs]
            [im-tables.db :as db]
            [im-tables.views :as views]
            [im-tables.config :as config]
            [imcljs.query :as query]
            [re-frisk.core :refer [enable-re-frisk!]]
            [cljsjs.react-transition-group]
            [cljsjs.highlight]
            [cljsjs.highlight.langs.javascript]
            [cljsjs.highlight.langs.perl]
            [cljsjs.highlight.langs.python]
            [cljsjs.highlight.langs.ruby]
            [cljsjs.highlight.langs.java]))


(defn dev-setup []
  (when config/debug?
    (enable-console-print!)
    (enable-re-frisk!)
    (println "dev mode")))

(defn mount-root []
  (reagent/render [views/main-panel]
                  (.getElementById js/document "app")))

(defn ^:export init []
  #_(re-frame/dispatch-sync [:initialize-db
                           [:test :location]
                           {
                            :service {:root "www.flymine.org/query"}
                            ;:service {:root "yeastmine.yeastgenome.org/yeastmine"}
                            :query (query/sterilize-query db/outer-join-query)}])

  (dev-setup)
  (mount-root))