// Compiled by ClojureScript 1.9.671 {}
goog.provide('imcljs.internal.utils');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
imcljs.internal.utils.does_not_contain_QMARK_ = cljs.core.complement.call(null,cljs.core.contains_QMARK_);
imcljs.internal.utils.one_of_QMARK_ = (function imcljs$internal$utils$one_of_QMARK_(haystack,needle){
return !((cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([needle]),haystack) == null));
});
imcljs.internal.utils.missing_http_QMARK__ = (function imcljs$internal$utils$missing_http_QMARK__(val){
return cljs.core.not.call(null,cljs.core.re_find.call(null,/^https?:\/\//,val));
});
imcljs.internal.utils.missing_service_QMARK__ = (function imcljs$internal$utils$missing_service_QMARK__(val){
return cljs.core.not.call(null,cljs.core.re_find.call(null,/\/service$/,val));
});
imcljs.internal.utils.append_ = (function imcljs$internal$utils$append_(text,val){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(val),cljs.core.str.cljs$core$IFn$_invoke$arity$1(text)].join('');
});
imcljs.internal.utils.alphabet = cljs.core.apply.call(null,cljs.core.sorted_set,clojure.string.split.call(null,"ABCDEFGHIJKLMNOPQRSTUVWXYZ",(new RegExp(""))));
/**
 * Ensures that a url starts with an http protocol and ends with /service
 */
imcljs.internal.utils.scrub_url = (function imcljs$internal$utils$scrub_url(url){
var G__33629 = url;
var G__33629__$1 = (cljs.core.truth_(imcljs.internal.utils.missing_http_QMARK__.call(null,url))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1("http://"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__33629)].join(''):G__33629);
if(cljs.core.truth_(imcljs.internal.utils.missing_service_QMARK__.call(null,url))){
return imcljs.internal.utils.append_.call(null,"/service",G__33629__$1);
} else {
return G__33629__$1;
}
});
imcljs.internal.utils.copy_list_query = (function imcljs$internal$utils$copy_list_query(p__33630){
var map__33631 = p__33630;
var map__33631__$1 = ((((!((map__33631 == null)))?((((map__33631.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33631.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33631):map__33631);
var old_list_details = map__33631__$1;
var old_list_name = cljs.core.get.call(null,map__33631__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var old_list_type = cljs.core.get.call(null,map__33631__$1,new cljs.core.Keyword(null,"type","type",1174270348));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"from","from",1815293044),old_list_type,new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str.cljs$core$IFn$_invoke$arity$1(old_list_type),cljs.core.str.cljs$core$IFn$_invoke$arity$1(".id")].join('')], null),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"path","path",-188191168),old_list_type,new cljs.core.Keyword(null,"op","op",-1882987955),"IN",new cljs.core.Keyword(null,"value","value",305978217),old_list_name], null)], null)], null);
});
/**
 * Given a collection of channels, returns a collection containing
 *   the first result of each channel (similiar to JS Promise.all)
 */
imcljs.internal.utils._LT__LT__BANG_ = (function imcljs$internal$utils$_LT__LT__BANG_(chans){
var c__31675__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31675__auto__){
return (function (){
var f__31676__auto__ = (function (){var switch__31585__auto__ = ((function (c__31675__auto__){
return (function (state_33651){
var state_val_33652 = (state_33651[(1)]);
if((state_val_33652 === (1))){
var inst_33633 = cljs.core.List.EMPTY;
var inst_33634 = inst_33633;
var inst_33635 = chans;
var state_33651__$1 = (function (){var statearr_33653 = state_33651;
(statearr_33653[(7)] = inst_33635);

(statearr_33653[(8)] = inst_33634);

return statearr_33653;
})();
var statearr_33654_33665 = state_33651__$1;
(statearr_33654_33665[(2)] = null);

(statearr_33654_33665[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33652 === (2))){
var inst_33635 = (state_33651[(7)]);
var inst_33637 = cljs.core.seq.call(null,inst_33635);
var state_33651__$1 = state_33651;
if(inst_33637){
var statearr_33655_33666 = state_33651__$1;
(statearr_33655_33666[(1)] = (4));

} else {
var statearr_33656_33667 = state_33651__$1;
(statearr_33656_33667[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33652 === (3))){
var inst_33649 = (state_33651[(2)]);
var state_33651__$1 = state_33651;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33651__$1,inst_33649);
} else {
if((state_val_33652 === (4))){
var inst_33635 = (state_33651[(7)]);
var inst_33639 = cljs.core.first.call(null,inst_33635);
var state_33651__$1 = state_33651;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33651__$1,(7),inst_33639);
} else {
if((state_val_33652 === (5))){
var inst_33634 = (state_33651[(8)]);
var state_33651__$1 = state_33651;
var statearr_33657_33668 = state_33651__$1;
(statearr_33657_33668[(2)] = inst_33634);

(statearr_33657_33668[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33652 === (6))){
var inst_33647 = (state_33651[(2)]);
var state_33651__$1 = state_33651;
var statearr_33658_33669 = state_33651__$1;
(statearr_33658_33669[(2)] = inst_33647);

(statearr_33658_33669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33652 === (7))){
var inst_33635 = (state_33651[(7)]);
var inst_33634 = (state_33651[(8)]);
var inst_33641 = (state_33651[(2)]);
var inst_33642 = cljs.core.conj.call(null,inst_33634,inst_33641);
var inst_33643 = cljs.core.rest.call(null,inst_33635);
var inst_33634__$1 = inst_33642;
var inst_33635__$1 = inst_33643;
var state_33651__$1 = (function (){var statearr_33659 = state_33651;
(statearr_33659[(7)] = inst_33635__$1);

(statearr_33659[(8)] = inst_33634__$1);

return statearr_33659;
})();
var statearr_33660_33670 = state_33651__$1;
(statearr_33660_33670[(2)] = null);

(statearr_33660_33670[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__31675__auto__))
;
return ((function (switch__31585__auto__,c__31675__auto__){
return (function() {
var imcljs$internal$utils$_LT__LT__BANG__$_state_machine__31586__auto__ = null;
var imcljs$internal$utils$_LT__LT__BANG__$_state_machine__31586__auto____0 = (function (){
var statearr_33661 = [null,null,null,null,null,null,null,null,null];
(statearr_33661[(0)] = imcljs$internal$utils$_LT__LT__BANG__$_state_machine__31586__auto__);

(statearr_33661[(1)] = (1));

return statearr_33661;
});
var imcljs$internal$utils$_LT__LT__BANG__$_state_machine__31586__auto____1 = (function (state_33651){
while(true){
var ret_value__31587__auto__ = (function (){try{while(true){
var result__31588__auto__ = switch__31585__auto__.call(null,state_33651);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31588__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31588__auto__;
}
break;
}
}catch (e33662){if((e33662 instanceof Object)){
var ex__31589__auto__ = e33662;
var statearr_33663_33671 = state_33651;
(statearr_33663_33671[(5)] = ex__31589__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33651);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33662;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31587__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33672 = state_33651;
state_33651 = G__33672;
continue;
} else {
return ret_value__31587__auto__;
}
break;
}
});
imcljs$internal$utils$_LT__LT__BANG__$_state_machine__31586__auto__ = function(state_33651){
switch(arguments.length){
case 0:
return imcljs$internal$utils$_LT__LT__BANG__$_state_machine__31586__auto____0.call(this);
case 1:
return imcljs$internal$utils$_LT__LT__BANG__$_state_machine__31586__auto____1.call(this,state_33651);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
imcljs$internal$utils$_LT__LT__BANG__$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$internal$utils$_LT__LT__BANG__$_state_machine__31586__auto____0;
imcljs$internal$utils$_LT__LT__BANG__$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$internal$utils$_LT__LT__BANG__$_state_machine__31586__auto____1;
return imcljs$internal$utils$_LT__LT__BANG__$_state_machine__31586__auto__;
})()
;})(switch__31585__auto__,c__31675__auto__))
})();
var state__31677__auto__ = (function (){var statearr_33664 = f__31676__auto__.call(null);
(statearr_33664[(6)] = c__31675__auto__);

return statearr_33664;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31677__auto__);
});})(c__31675__auto__))
);

return c__31675__auto__;
});

//# sourceMappingURL=utils.js.map