// Compiled by ClojureScript 1.9.671 {}
goog.provide('imcljs.path');
goog.require('cljs.core');
goog.require('imcljs.internal.utils');
goog.require('clojure.string');
/**
 * Split a string path into a vector of keywords.
 *   (split-path `Gene.organism.shortName`)
 *   => [:Gene :organism :shortName]
 */
imcljs.path.split_path = (function imcljs$path$split_path(path_str){
return cljs.core.map.call(null,cljs.core.keyword,clojure.string.split.call(null,path_str,/\./));
});
/**
 * Join a vector path of keywords to a string.
 *   (join-path [:Gene :organism :shortName])
 *   => Gene.organism.shortName
 */
imcljs.path.join_path = (function imcljs$path$join_path(path_str){
return clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.core.name,path_str));
});
/**
 * Given a model and a class, return its attributes, references and collections.
 */
imcljs.path.properties = (function imcljs$path$properties(model,class_kw){
return cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),class_kw], null)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attributes","attributes",-74013604),new cljs.core.Keyword(null,"references","references",882562509),new cljs.core.Keyword(null,"collections","collections",-2114643505)], null)));
});
/**
 * Given a model, a class, and a collection or reference, return the class of the collection or reference.
 *   (referenced-class im-model :Gene :homologues)
 *   => :Gene
 */
imcljs.path.referenced_type = (function imcljs$path$referenced_type(model,field_kw,class_kw){
return cljs.core.keyword.call(null,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030).cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,imcljs.path.properties.call(null,model,class_kw),field_kw)));
});
/**
 * Given a model, a reference/collection, and a class,
 *   return the superclass of the reference/collection.
 *   In the example :tissue is an attribute of the subclass :FlyAtlasResult
 *   (referenced-class im-model :MicroArrayResult :tissue)
 *   => :Tissue
 */
imcljs.path.referenced_class = (function imcljs$path$referenced_class(model,field_kw,class_kw){
return cljs.core.first.call(null,cljs.core.filter.call(null,cljs.core.identity,cljs.core.map.call(null,cljs.core.partial.call(null,imcljs.path.referenced_type,model,field_kw),cljs.core.cons.call(null,class_kw,cljs.core.map.call(null,cljs.core.first,cljs.core.filter.call(null,(function (p__35670){
var vec__35671 = p__35670;
var _ = cljs.core.nth.call(null,vec__35671,(0),null);
var map__35674 = cljs.core.nth.call(null,vec__35671,(1),null);
var map__35674__$1 = ((((!((map__35674 == null)))?((((map__35674.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35674.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35674):map__35674);
var extends$ = cljs.core.get.call(null,map__35674__$1,new cljs.core.Keyword(null,"extends","extends",-954903259));
return cljs.core.some.call(null,cljs.core.partial.call(null,cljs.core._EQ_,class_kw),cljs.core.map.call(null,cljs.core.keyword,extends$));
}),new cljs.core.Keyword(null,"classes","classes",2037804510).cljs$core$IFn$_invoke$arity$1(model)))))));
});
/**
 * Given a model, a class, and a collection or reference, return the class of the collection or reference.
 *   (referenced-class im-model :Gene :homologues)
 *   => :Gene
 */
imcljs.path.referenced_values = (function imcljs$path$referenced_values(model,field_kw,class_kw){
return cljs.core.get.call(null,imcljs.path.properties.call(null,model,class_kw),field_kw);
});
/**
 * Given a model and a field, return that field from the data model.
 *   A field can be a reference, a collection, or an attribute
 *   In the example :tissue is an attribute of the subclass :FlyAtlasResult
 *   (referenced-class im-model :MicroArrayResult :tissue)
 *   => :Tissue
 */
imcljs.path.class_value = (function imcljs$path$class_value(model,class_kw,field_kw){
return cljs.core.first.call(null,cljs.core.filter.call(null,cljs.core.identity,cljs.core.map.call(null,cljs.core.partial.call(null,imcljs.path.referenced_values,model,field_kw),cljs.core.cons.call(null,class_kw,cljs.core.map.call(null,cljs.core.first,cljs.core.filter.call(null,(function (p__35676){
var vec__35677 = p__35676;
var _ = cljs.core.nth.call(null,vec__35677,(0),null);
var map__35680 = cljs.core.nth.call(null,vec__35677,(1),null);
var map__35680__$1 = ((((!((map__35680 == null)))?((((map__35680.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35680.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35680):map__35680);
var extends$ = cljs.core.get.call(null,map__35680__$1,new cljs.core.Keyword(null,"extends","extends",-954903259));
return cljs.core.some.call(null,cljs.core.partial.call(null,cljs.core._EQ_,class_kw),cljs.core.map.call(null,cljs.core.keyword,extends$));
}),new cljs.core.Keyword(null,"classes","classes",2037804510).cljs$core$IFn$_invoke$arity$1(model)))))));
});
/**
 * Return a vector representing each part of path.
 *   If any part of the path is unresolvable then a nil is returned.
 *   (walk im-model `Gene.organism.shortName`)
 *   => [{:name `Gene`, :collections {...}, :attributes {...}}
 *    {:name `Organism`, :collections {...} :attributes {...}
 *    {:name `shortName`, :type `java.lang.String`}]
 */
imcljs.path.walk = (function imcljs$path$walk(var_args){
var G__35683 = arguments.length;
switch (G__35683) {
case 2:
return imcljs.path.walk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return imcljs.path.walk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

imcljs.path.walk.cljs$core$IFn$_invoke$arity$2 = (function (model,path){
var p = ((typeof path === 'string')?imcljs.path.split_path.call(null,path):path);
if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,p))){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),cljs.core.first.call(null,p)], null))], null);
} else {
return imcljs.path.walk.call(null,model,p,cljs.core.PersistentVector.EMPTY);
}
});

imcljs.path.walk.cljs$core$IFn$_invoke$arity$3 = (function (model,p__35684,trail){
while(true){
var vec__35685 = p__35684;
var seq__35686 = cljs.core.seq.call(null,vec__35685);
var first__35687 = cljs.core.first.call(null,seq__35686);
var seq__35686__$1 = cljs.core.next.call(null,seq__35686);
var class_kw = first__35687;
var vec__35688 = seq__35686__$1;
var seq__35689 = cljs.core.seq.call(null,vec__35688);
var first__35690 = cljs.core.first.call(null,seq__35689);
var seq__35689__$1 = cljs.core.next.call(null,seq__35689);
var path = first__35690;
var remaining = seq__35689__$1;
var cv = imcljs.path.class_value.call(null,model,class_kw,path);
if(remaining){
if(cljs.core.contains_QMARK_.call(null,cv,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030))){
var G__35692 = model;
var G__35693 = cljs.core.cons.call(null,cljs.core.keyword.call(null,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030).cljs$core$IFn$_invoke$arity$1(cv)),remaining);
var G__35694 = cljs.core.conj.call(null,trail,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),class_kw], null)));
model = G__35692;
p__35684 = G__35693;
trail = G__35694;
continue;
} else {
return null;
}
} else {
return cljs.core.conj.call(null,trail,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),class_kw], null)),((cljs.core.contains_QMARK_.call(null,cv,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030)))?cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),cljs.core.keyword.call(null,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030).cljs$core$IFn$_invoke$arity$1(cv))], null)):cv));
}
break;
}
});

imcljs.path.walk.cljs$lang$maxFixedArity = 3;

/**
 * Return the java type of a path representing an attribute.
 *   (attribute-type im-model `Gene.organism.shortName`)
 *   => java.lang.String
 */
imcljs.path.data_type = (function imcljs$path$data_type(model,path){
return new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,imcljs.path.walk.call(null,model,path)));
});
/**
 * Returns the class represented by the path.
 *   (class im-model `Gene.homologues.homologue.symbol`)
 *   => :Gene
 */
imcljs.path.class$ = (function imcljs$path$class(model,path){
var l = cljs.core.last.call(null,cljs.core.take_while.call(null,(function (p1__35695_SHARP_){
return imcljs.internal.utils.does_not_contain_QMARK_.call(null,p1__35695_SHARP_,new cljs.core.Keyword(null,"type","type",1174270348));
}),imcljs.path.walk.call(null,model,path)));
return cljs.core.keyword.call(null,(function (){var or__28633__auto__ = new cljs.core.Keyword(null,"referencedType","referencedType",-303824030).cljs$core$IFn$_invoke$arity$1(l);
if(cljs.core.truth_(or__28633__auto__)){
return or__28633__auto__;
} else {
return cljs.core.keyword.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(l));
}
})());
});
/**
 * Returns all relationships (references and collections) for a given string path.
 */
imcljs.path.relationships = (function imcljs$path$relationships(model,path){
return cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),imcljs.path.class$.call(null,model,path)], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"references","references",882562509),new cljs.core.Keyword(null,"collections","collections",-2114643505)], null)));
});
imcljs.path.mapify = (function imcljs$path$mapify(coll){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,coll);
});
imcljs.path.un_camel_case = (function imcljs$path$un_camel_case(s){
var G__35697 = s;
var G__35697__$1 = (((G__35697 == null))?null:clojure.string.replace.call(null,G__35697,/([a-z])([A-Z])/,"$1 $2"));
var G__35697__$2 = (((G__35697__$1 == null))?null:clojure.string.replace.call(null,G__35697__$1,/([A-Z])([a-z])/," $1$2"));
var G__35697__$3 = (((G__35697__$2 == null))?null:clojure.string.replace.call(null,G__35697__$2,/\ +/," "));
if((G__35697__$3 == null)){
return null;
} else {
return clojure.string.replace.call(null,G__35697__$3,/^./,((function (G__35697,G__35697__$1,G__35697__$2,G__35697__$3){
return (function (p1__35696_SHARP_){
return clojure.string.upper_case.call(null,p1__35696_SHARP_);
});})(G__35697,G__35697__$1,G__35697__$2,G__35697__$3))
);
}
});
/**
 * Returns a vector of friendly names representing the path
 *   ; TODO make this work with subclasses
 */
imcljs.path.display_name = (function imcljs$path$display_name(var_args){
var G__35699 = arguments.length;
switch (G__35699) {
case 2:
return imcljs.path.display_name.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return imcljs.path.display_name.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

imcljs.path.display_name.cljs$core$IFn$_invoke$arity$2 = (function (model,path){
var p = ((typeof path === 'string')?imcljs.path.split_path.call(null,path):path);
return imcljs.path.display_name.call(null,model,p,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),cljs.core.first.call(null,p),new cljs.core.Keyword(null,"displayName","displayName",-809144601)], null))], null));
});

imcljs.path.display_name.cljs$core$IFn$_invoke$arity$3 = (function (model,p__35700,collected){
while(true){
var vec__35701 = p__35700;
var seq__35702 = cljs.core.seq.call(null,vec__35701);
var first__35703 = cljs.core.first.call(null,seq__35702);
var seq__35702__$1 = cljs.core.next.call(null,seq__35702);
var head = first__35703;
var first__35703__$1 = cljs.core.first.call(null,seq__35702__$1);
var seq__35702__$2 = cljs.core.next.call(null,seq__35702__$1);
var next = first__35703__$1;
var tail = seq__35702__$2;
if(cljs.core.truth_(next)){
var props = imcljs.path.mapify.call(null,cljs.core.vals.call(null,cljs.core.select_keys.call(null,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),head], null)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attributes","attributes",-74013604),new cljs.core.Keyword(null,"references","references",882562509),new cljs.core.Keyword(null,"collections","collections",-2114643505)], null))));
var collected_PLUS_ = cljs.core.conj.call(null,collected,(function (){var or__28633__auto__ = cljs.core.get_in.call(null,props,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [next,new cljs.core.Keyword(null,"displayName","displayName",-809144601)], null));
if(cljs.core.truth_(or__28633__auto__)){
return or__28633__auto__;
} else {
return imcljs.path.un_camel_case.call(null,cljs.core.get_in.call(null,props,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [next,new cljs.core.Keyword(null,"name","name",1843675177)], null)));
}
})());
if(cljs.core.truth_(cljs.core.not_empty.call(null,tail))){
var G__35705 = model;
var G__35706 = cljs.core.conj.call(null,tail,cljs.core.keyword.call(null,cljs.core.get_in.call(null,props,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [next,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030)], null))));
var G__35707 = collected_PLUS_;
model = G__35705;
p__35700 = G__35706;
collected = G__35707;
continue;
} else {
return collected_PLUS_;
}
} else {
return null;
}
break;
}
});

imcljs.path.display_name.cljs$lang$maxFixedArity = 3;

/**
 * Returns all attributes for a given string path.
 */
imcljs.path.attributes = (function imcljs$path$attributes(model,path){
return cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),imcljs.path.class$.call(null,model,path)], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attributes","attributes",-74013604)], null)));
});
/**
 * Returns true if path is a class.
 *   (class im-model `Gene.diseases`)
 *   => true
 *   (class im-model `Gene.diseases.name`)
 *   => false
 */
imcljs.path.class_QMARK_ = (function imcljs$path$class_QMARK_(model,path){
var walked = imcljs.path.walk.call(null,model,path);
return !(cljs.core.contains_QMARK_.call(null,cljs.core.last.call(null,walked),new cljs.core.Keyword(null,"type","type",1174270348)));
});
/**
 * Returns a path string trimmed to the last class
 *   (trim-to-last-class im-model `Gene.homologues.homologue.symbol`)
 *   => Gene.homologues.homologue
 */
imcljs.path.trim_to_last_class = (function imcljs$path$trim_to_last_class(model,path){
var done = cljs.core.take_while.call(null,(function (p1__35708_SHARP_){
return imcljs.internal.utils.does_not_contain_QMARK_.call(null,p1__35708_SHARP_,new cljs.core.Keyword(null,"type","type",1174270348));
}),imcljs.path.walk.call(null,model,path));
return imcljs.path.join_path.call(null,cljs.core.take.call(null,cljs.core.count.call(null,done),imcljs.path.split_path.call(null,path)));
});
/**
 * Returns a path adjusted to its last class
 *   (adjust-path-to-last-class im-model `Gene.organism.name`)
 *   => Organism.name
 */
imcljs.path.adjust_path_to_last_class = (function imcljs$path$adjust_path_to_last_class(model,path){
var attribute_QMARK_ = cljs.core.not.call(null,imcljs.path.class_QMARK_.call(null,model,path));
var walked = cljs.core.reverse.call(null,imcljs.path.walk.call(null,model,path));
if(attribute_QMARK_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.nth.call(null,walked,(1)))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("."),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.nth.call(null,walked,(0))))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.nth.call(null,walked,(0))))].join('');
}
});
/**
 * Returns a path as a strong
 */
imcljs.path.friendly = (function imcljs$path$friendly(var_args){
var args__29873__auto__ = [];
var len__29866__auto___35716 = arguments.length;
var i__29867__auto___35717 = (0);
while(true){
if((i__29867__auto___35717 < len__29866__auto___35716)){
args__29873__auto__.push((arguments[i__29867__auto___35717]));

var G__35718 = (i__29867__auto___35717 + (1));
i__29867__auto___35717 = G__35718;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((2) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((2)),(0),null)):null);
return imcljs.path.friendly.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29874__auto__);
});

imcljs.path.friendly.cljs$core$IFn$_invoke$arity$variadic = (function (model,path,p__35712){
var vec__35713 = p__35712;
var exclude_root_QMARK_ = cljs.core.nth.call(null,vec__35713,(0),null);
return cljs.core.reduce.call(null,((function (vec__35713,exclude_root_QMARK_){
return (function (total,next){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(total),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(total)?" > ":null)),cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__28633__auto__ = new cljs.core.Keyword(null,"displayName","displayName",-809144601).cljs$core$IFn$_invoke$arity$1(next);
if(cljs.core.truth_(or__28633__auto__)){
return or__28633__auto__;
} else {
return new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(next);
}
})())].join('');
});})(vec__35713,exclude_root_QMARK_))
,null,(cljs.core.truth_(exclude_root_QMARK_)?cljs.core.rest.call(null,imcljs.path.walk.call(null,model,path)):imcljs.path.walk.call(null,model,path)));
});

imcljs.path.friendly.cljs$lang$maxFixedArity = (2);

imcljs.path.friendly.cljs$lang$applyTo = (function (seq35709){
var G__35710 = cljs.core.first.call(null,seq35709);
var seq35709__$1 = cljs.core.next.call(null,seq35709);
var G__35711 = cljs.core.first.call(null,seq35709__$1);
var seq35709__$2 = cljs.core.next.call(null,seq35709__$1);
return imcljs.path.friendly.cljs$core$IFn$_invoke$arity$variadic(G__35710,G__35711,seq35709__$2);
});

imcljs.path.one_of_QMARK_ = (function imcljs$path$one_of_QMARK_(col,value){
return !((cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([value]),col) == null));
});
/**
 * Returns subclasses of the class
 */
imcljs.path.subclasses = (function imcljs$path$subclasses(model,path){
var path_class = imcljs.path.class$.call(null,model,path);
return cljs.core.not_empty.call(null,cljs.core.map.call(null,cljs.core.first,cljs.core.filter.call(null,((function (path_class){
return (function (p__35719){
var vec__35720 = p__35719;
var _ = cljs.core.nth.call(null,vec__35720,(0),null);
var properties = cljs.core.nth.call(null,vec__35720,(1),null);
return imcljs.path.one_of_QMARK_.call(null,new cljs.core.Keyword(null,"extends","extends",-954903259).cljs$core$IFn$_invoke$arity$1(properties),cljs.core.name.call(null,path_class));
});})(path_class))
,new cljs.core.Keyword(null,"classes","classes",2037804510).cljs$core$IFn$_invoke$arity$1(model))));
});

//# sourceMappingURL=path.js.map