// Compiled by ClojureScript 1.10.520 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__8127 = arguments.length;
switch (G__8127) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async8128 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8128 = (function (f,blockable,meta8129){
this.f = f;
this.blockable = blockable;
this.meta8129 = meta8129;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async8128.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_8130,meta8129__$1){
var self__ = this;
var _8130__$1 = this;
return (new cljs.core.async.t_cljs$core$async8128(self__.f,self__.blockable,meta8129__$1));
});

cljs.core.async.t_cljs$core$async8128.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_8130){
var self__ = this;
var _8130__$1 = this;
return self__.meta8129;
});

cljs.core.async.t_cljs$core$async8128.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async8128.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async8128.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async8128.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async8128.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta8129","meta8129",1962750300,null)], null);
});

cljs.core.async.t_cljs$core$async8128.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async8128.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8128";

cljs.core.async.t_cljs$core$async8128.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async8128");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async8128.
 */
cljs.core.async.__GT_t_cljs$core$async8128 = (function cljs$core$async$__GT_t_cljs$core$async8128(f__$1,blockable__$1,meta8129){
return (new cljs.core.async.t_cljs$core$async8128(f__$1,blockable__$1,meta8129));
});

}

return (new cljs.core.async.t_cljs$core$async8128(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__8134 = arguments.length;
switch (G__8134) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__8137 = arguments.length;
switch (G__8137) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__8140 = arguments.length;
switch (G__8140) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_8142 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_8142);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_8142,ret){
return (function (){
return fn1.call(null,val_8142);
});})(val_8142,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__8144 = arguments.length;
switch (G__8144) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5733__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5733__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4607__auto___8146 = n;
var x_8147 = (0);
while(true){
if((x_8147 < n__4607__auto___8146)){
(a[x_8147] = x_8147);

var G__8148 = (x_8147 + (1));
x_8147 = G__8148;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async8149 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8149 = (function (flag,meta8150){
this.flag = flag;
this.meta8150 = meta8150;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async8149.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_8151,meta8150__$1){
var self__ = this;
var _8151__$1 = this;
return (new cljs.core.async.t_cljs$core$async8149(self__.flag,meta8150__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async8149.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_8151){
var self__ = this;
var _8151__$1 = this;
return self__.meta8150;
});})(flag))
;

cljs.core.async.t_cljs$core$async8149.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async8149.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async8149.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async8149.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async8149.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta8150","meta8150",413089061,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async8149.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async8149.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8149";

cljs.core.async.t_cljs$core$async8149.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async8149");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async8149.
 */
cljs.core.async.__GT_t_cljs$core$async8149 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async8149(flag__$1,meta8150){
return (new cljs.core.async.t_cljs$core$async8149(flag__$1,meta8150));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async8149(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async8152 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8152 = (function (flag,cb,meta8153){
this.flag = flag;
this.cb = cb;
this.meta8153 = meta8153;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async8152.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_8154,meta8153__$1){
var self__ = this;
var _8154__$1 = this;
return (new cljs.core.async.t_cljs$core$async8152(self__.flag,self__.cb,meta8153__$1));
});

cljs.core.async.t_cljs$core$async8152.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_8154){
var self__ = this;
var _8154__$1 = this;
return self__.meta8153;
});

cljs.core.async.t_cljs$core$async8152.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async8152.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async8152.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async8152.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async8152.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta8153","meta8153",-1656075603,null)], null);
});

cljs.core.async.t_cljs$core$async8152.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async8152.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8152";

cljs.core.async.t_cljs$core$async8152.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async8152");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async8152.
 */
cljs.core.async.__GT_t_cljs$core$async8152 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async8152(flag__$1,cb__$1,meta8153){
return (new cljs.core.async.t_cljs$core$async8152(flag__$1,cb__$1,meta8153));
});

}

return (new cljs.core.async.t_cljs$core$async8152(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count.call(null,ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__8155_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__8155_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__8156_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__8156_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4131__auto__ = wport;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return port;
}
})()], null));
} else {
var G__8157 = (i + (1));
i = G__8157;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4131__auto__ = ret;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4120__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8163 = arguments.length;
var i__4731__auto___8164 = (0);
while(true){
if((i__4731__auto___8164 < len__4730__auto___8163)){
args__4736__auto__.push((arguments[i__4731__auto___8164]));

var G__8165 = (i__4731__auto___8164 + (1));
i__4731__auto___8164 = G__8165;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__8160){
var map__8161 = p__8160;
var map__8161__$1 = (((((!((map__8161 == null))))?(((((map__8161.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8161.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8161):map__8161);
var opts = map__8161__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq8158){
var G__8159 = cljs.core.first.call(null,seq8158);
var seq8158__$1 = cljs.core.next.call(null,seq8158);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8159,seq8158__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__8167 = arguments.length;
switch (G__8167) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__6204__auto___8213 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6204__auto___8213){
return (function (){
var f__6205__auto__ = (function (){var switch__6037__auto__ = ((function (c__6204__auto___8213){
return (function (state_8191){
var state_val_8192 = (state_8191[(1)]);
if((state_val_8192 === (7))){
var inst_8187 = (state_8191[(2)]);
var state_8191__$1 = state_8191;
var statearr_8193_8214 = state_8191__$1;
(statearr_8193_8214[(2)] = inst_8187);

(statearr_8193_8214[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8192 === (1))){
var state_8191__$1 = state_8191;
var statearr_8194_8215 = state_8191__$1;
(statearr_8194_8215[(2)] = null);

(statearr_8194_8215[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8192 === (4))){
var inst_8170 = (state_8191[(7)]);
var inst_8170__$1 = (state_8191[(2)]);
var inst_8171 = (inst_8170__$1 == null);
var state_8191__$1 = (function (){var statearr_8195 = state_8191;
(statearr_8195[(7)] = inst_8170__$1);

return statearr_8195;
})();
if(cljs.core.truth_(inst_8171)){
var statearr_8196_8216 = state_8191__$1;
(statearr_8196_8216[(1)] = (5));

} else {
var statearr_8197_8217 = state_8191__$1;
(statearr_8197_8217[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8192 === (13))){
var state_8191__$1 = state_8191;
var statearr_8198_8218 = state_8191__$1;
(statearr_8198_8218[(2)] = null);

(statearr_8198_8218[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8192 === (6))){
var inst_8170 = (state_8191[(7)]);
var state_8191__$1 = state_8191;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8191__$1,(11),to,inst_8170);
} else {
if((state_val_8192 === (3))){
var inst_8189 = (state_8191[(2)]);
var state_8191__$1 = state_8191;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8191__$1,inst_8189);
} else {
if((state_val_8192 === (12))){
var state_8191__$1 = state_8191;
var statearr_8199_8219 = state_8191__$1;
(statearr_8199_8219[(2)] = null);

(statearr_8199_8219[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8192 === (2))){
var state_8191__$1 = state_8191;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8191__$1,(4),from);
} else {
if((state_val_8192 === (11))){
var inst_8180 = (state_8191[(2)]);
var state_8191__$1 = state_8191;
if(cljs.core.truth_(inst_8180)){
var statearr_8200_8220 = state_8191__$1;
(statearr_8200_8220[(1)] = (12));

} else {
var statearr_8201_8221 = state_8191__$1;
(statearr_8201_8221[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8192 === (9))){
var state_8191__$1 = state_8191;
var statearr_8202_8222 = state_8191__$1;
(statearr_8202_8222[(2)] = null);

(statearr_8202_8222[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8192 === (5))){
var state_8191__$1 = state_8191;
if(cljs.core.truth_(close_QMARK_)){
var statearr_8203_8223 = state_8191__$1;
(statearr_8203_8223[(1)] = (8));

} else {
var statearr_8204_8224 = state_8191__$1;
(statearr_8204_8224[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8192 === (14))){
var inst_8185 = (state_8191[(2)]);
var state_8191__$1 = state_8191;
var statearr_8205_8225 = state_8191__$1;
(statearr_8205_8225[(2)] = inst_8185);

(statearr_8205_8225[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8192 === (10))){
var inst_8177 = (state_8191[(2)]);
var state_8191__$1 = state_8191;
var statearr_8206_8226 = state_8191__$1;
(statearr_8206_8226[(2)] = inst_8177);

(statearr_8206_8226[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8192 === (8))){
var inst_8174 = cljs.core.async.close_BANG_.call(null,to);
var state_8191__$1 = state_8191;
var statearr_8207_8227 = state_8191__$1;
(statearr_8207_8227[(2)] = inst_8174);

(statearr_8207_8227[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6204__auto___8213))
;
return ((function (switch__6037__auto__,c__6204__auto___8213){
return (function() {
var cljs$core$async$state_machine__6038__auto__ = null;
var cljs$core$async$state_machine__6038__auto____0 = (function (){
var statearr_8208 = [null,null,null,null,null,null,null,null];
(statearr_8208[(0)] = cljs$core$async$state_machine__6038__auto__);

(statearr_8208[(1)] = (1));

return statearr_8208;
});
var cljs$core$async$state_machine__6038__auto____1 = (function (state_8191){
while(true){
var ret_value__6039__auto__ = (function (){try{while(true){
var result__6040__auto__ = switch__6037__auto__.call(null,state_8191);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6040__auto__;
}
break;
}
}catch (e8209){if((e8209 instanceof Object)){
var ex__6041__auto__ = e8209;
var statearr_8210_8228 = state_8191;
(statearr_8210_8228[(5)] = ex__6041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8191);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8209;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8229 = state_8191;
state_8191 = G__8229;
continue;
} else {
return ret_value__6039__auto__;
}
break;
}
});
cljs$core$async$state_machine__6038__auto__ = function(state_8191){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6038__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6038__auto____1.call(this,state_8191);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6038__auto____0;
cljs$core$async$state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6038__auto____1;
return cljs$core$async$state_machine__6038__auto__;
})()
;})(switch__6037__auto__,c__6204__auto___8213))
})();
var state__6206__auto__ = (function (){var statearr_8211 = f__6205__auto__.call(null);
(statearr_8211[(6)] = c__6204__auto___8213);

return statearr_8211;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6206__auto__);
});})(c__6204__auto___8213))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__8230){
var vec__8231 = p__8230;
var v = cljs.core.nth.call(null,vec__8231,(0),null);
var p = cljs.core.nth.call(null,vec__8231,(1),null);
var job = vec__8231;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__6204__auto___8402 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6204__auto___8402,res,vec__8231,v,p,job,jobs,results){
return (function (){
var f__6205__auto__ = (function (){var switch__6037__auto__ = ((function (c__6204__auto___8402,res,vec__8231,v,p,job,jobs,results){
return (function (state_8238){
var state_val_8239 = (state_8238[(1)]);
if((state_val_8239 === (1))){
var state_8238__$1 = state_8238;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8238__$1,(2),res,v);
} else {
if((state_val_8239 === (2))){
var inst_8235 = (state_8238[(2)]);
var inst_8236 = cljs.core.async.close_BANG_.call(null,res);
var state_8238__$1 = (function (){var statearr_8240 = state_8238;
(statearr_8240[(7)] = inst_8235);

return statearr_8240;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8238__$1,inst_8236);
} else {
return null;
}
}
});})(c__6204__auto___8402,res,vec__8231,v,p,job,jobs,results))
;
return ((function (switch__6037__auto__,c__6204__auto___8402,res,vec__8231,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____0 = (function (){
var statearr_8241 = [null,null,null,null,null,null,null,null];
(statearr_8241[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__);

(statearr_8241[(1)] = (1));

return statearr_8241;
});
var cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____1 = (function (state_8238){
while(true){
var ret_value__6039__auto__ = (function (){try{while(true){
var result__6040__auto__ = switch__6037__auto__.call(null,state_8238);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6040__auto__;
}
break;
}
}catch (e8242){if((e8242 instanceof Object)){
var ex__6041__auto__ = e8242;
var statearr_8243_8403 = state_8238;
(statearr_8243_8403[(5)] = ex__6041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8238);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8242;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8404 = state_8238;
state_8238 = G__8404;
continue;
} else {
return ret_value__6039__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__ = function(state_8238){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____1.call(this,state_8238);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__;
})()
;})(switch__6037__auto__,c__6204__auto___8402,res,vec__8231,v,p,job,jobs,results))
})();
var state__6206__auto__ = (function (){var statearr_8244 = f__6205__auto__.call(null);
(statearr_8244[(6)] = c__6204__auto___8402);

return statearr_8244;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6206__auto__);
});})(c__6204__auto___8402,res,vec__8231,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__8245){
var vec__8246 = p__8245;
var v = cljs.core.nth.call(null,vec__8246,(0),null);
var p = cljs.core.nth.call(null,vec__8246,(1),null);
var job = vec__8246;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__4607__auto___8405 = n;
var __8406 = (0);
while(true){
if((__8406 < n__4607__auto___8405)){
var G__8249_8407 = type;
var G__8249_8408__$1 = (((G__8249_8407 instanceof cljs.core.Keyword))?G__8249_8407.fqn:null);
switch (G__8249_8408__$1) {
case "compute":
var c__6204__auto___8410 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__8406,c__6204__auto___8410,G__8249_8407,G__8249_8408__$1,n__4607__auto___8405,jobs,results,process,async){
return (function (){
var f__6205__auto__ = (function (){var switch__6037__auto__ = ((function (__8406,c__6204__auto___8410,G__8249_8407,G__8249_8408__$1,n__4607__auto___8405,jobs,results,process,async){
return (function (state_8262){
var state_val_8263 = (state_8262[(1)]);
if((state_val_8263 === (1))){
var state_8262__$1 = state_8262;
var statearr_8264_8411 = state_8262__$1;
(statearr_8264_8411[(2)] = null);

(statearr_8264_8411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8263 === (2))){
var state_8262__$1 = state_8262;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8262__$1,(4),jobs);
} else {
if((state_val_8263 === (3))){
var inst_8260 = (state_8262[(2)]);
var state_8262__$1 = state_8262;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8262__$1,inst_8260);
} else {
if((state_val_8263 === (4))){
var inst_8252 = (state_8262[(2)]);
var inst_8253 = process.call(null,inst_8252);
var state_8262__$1 = state_8262;
if(cljs.core.truth_(inst_8253)){
var statearr_8265_8412 = state_8262__$1;
(statearr_8265_8412[(1)] = (5));

} else {
var statearr_8266_8413 = state_8262__$1;
(statearr_8266_8413[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8263 === (5))){
var state_8262__$1 = state_8262;
var statearr_8267_8414 = state_8262__$1;
(statearr_8267_8414[(2)] = null);

(statearr_8267_8414[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8263 === (6))){
var state_8262__$1 = state_8262;
var statearr_8268_8415 = state_8262__$1;
(statearr_8268_8415[(2)] = null);

(statearr_8268_8415[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8263 === (7))){
var inst_8258 = (state_8262[(2)]);
var state_8262__$1 = state_8262;
var statearr_8269_8416 = state_8262__$1;
(statearr_8269_8416[(2)] = inst_8258);

(statearr_8269_8416[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__8406,c__6204__auto___8410,G__8249_8407,G__8249_8408__$1,n__4607__auto___8405,jobs,results,process,async))
;
return ((function (__8406,switch__6037__auto__,c__6204__auto___8410,G__8249_8407,G__8249_8408__$1,n__4607__auto___8405,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____0 = (function (){
var statearr_8270 = [null,null,null,null,null,null,null];
(statearr_8270[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__);

(statearr_8270[(1)] = (1));

return statearr_8270;
});
var cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____1 = (function (state_8262){
while(true){
var ret_value__6039__auto__ = (function (){try{while(true){
var result__6040__auto__ = switch__6037__auto__.call(null,state_8262);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6040__auto__;
}
break;
}
}catch (e8271){if((e8271 instanceof Object)){
var ex__6041__auto__ = e8271;
var statearr_8272_8417 = state_8262;
(statearr_8272_8417[(5)] = ex__6041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8262);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8271;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8418 = state_8262;
state_8262 = G__8418;
continue;
} else {
return ret_value__6039__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__ = function(state_8262){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____1.call(this,state_8262);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__;
})()
;})(__8406,switch__6037__auto__,c__6204__auto___8410,G__8249_8407,G__8249_8408__$1,n__4607__auto___8405,jobs,results,process,async))
})();
var state__6206__auto__ = (function (){var statearr_8273 = f__6205__auto__.call(null);
(statearr_8273[(6)] = c__6204__auto___8410);

return statearr_8273;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6206__auto__);
});})(__8406,c__6204__auto___8410,G__8249_8407,G__8249_8408__$1,n__4607__auto___8405,jobs,results,process,async))
);


break;
case "async":
var c__6204__auto___8419 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__8406,c__6204__auto___8419,G__8249_8407,G__8249_8408__$1,n__4607__auto___8405,jobs,results,process,async){
return (function (){
var f__6205__auto__ = (function (){var switch__6037__auto__ = ((function (__8406,c__6204__auto___8419,G__8249_8407,G__8249_8408__$1,n__4607__auto___8405,jobs,results,process,async){
return (function (state_8286){
var state_val_8287 = (state_8286[(1)]);
if((state_val_8287 === (1))){
var state_8286__$1 = state_8286;
var statearr_8288_8420 = state_8286__$1;
(statearr_8288_8420[(2)] = null);

(statearr_8288_8420[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8287 === (2))){
var state_8286__$1 = state_8286;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8286__$1,(4),jobs);
} else {
if((state_val_8287 === (3))){
var inst_8284 = (state_8286[(2)]);
var state_8286__$1 = state_8286;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8286__$1,inst_8284);
} else {
if((state_val_8287 === (4))){
var inst_8276 = (state_8286[(2)]);
var inst_8277 = async.call(null,inst_8276);
var state_8286__$1 = state_8286;
if(cljs.core.truth_(inst_8277)){
var statearr_8289_8421 = state_8286__$1;
(statearr_8289_8421[(1)] = (5));

} else {
var statearr_8290_8422 = state_8286__$1;
(statearr_8290_8422[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8287 === (5))){
var state_8286__$1 = state_8286;
var statearr_8291_8423 = state_8286__$1;
(statearr_8291_8423[(2)] = null);

(statearr_8291_8423[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8287 === (6))){
var state_8286__$1 = state_8286;
var statearr_8292_8424 = state_8286__$1;
(statearr_8292_8424[(2)] = null);

(statearr_8292_8424[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8287 === (7))){
var inst_8282 = (state_8286[(2)]);
var state_8286__$1 = state_8286;
var statearr_8293_8425 = state_8286__$1;
(statearr_8293_8425[(2)] = inst_8282);

(statearr_8293_8425[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__8406,c__6204__auto___8419,G__8249_8407,G__8249_8408__$1,n__4607__auto___8405,jobs,results,process,async))
;
return ((function (__8406,switch__6037__auto__,c__6204__auto___8419,G__8249_8407,G__8249_8408__$1,n__4607__auto___8405,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____0 = (function (){
var statearr_8294 = [null,null,null,null,null,null,null];
(statearr_8294[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__);

(statearr_8294[(1)] = (1));

return statearr_8294;
});
var cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____1 = (function (state_8286){
while(true){
var ret_value__6039__auto__ = (function (){try{while(true){
var result__6040__auto__ = switch__6037__auto__.call(null,state_8286);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6040__auto__;
}
break;
}
}catch (e8295){if((e8295 instanceof Object)){
var ex__6041__auto__ = e8295;
var statearr_8296_8426 = state_8286;
(statearr_8296_8426[(5)] = ex__6041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8286);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8295;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8427 = state_8286;
state_8286 = G__8427;
continue;
} else {
return ret_value__6039__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__ = function(state_8286){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____1.call(this,state_8286);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__;
})()
;})(__8406,switch__6037__auto__,c__6204__auto___8419,G__8249_8407,G__8249_8408__$1,n__4607__auto___8405,jobs,results,process,async))
})();
var state__6206__auto__ = (function (){var statearr_8297 = f__6205__auto__.call(null);
(statearr_8297[(6)] = c__6204__auto___8419);

return statearr_8297;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6206__auto__);
});})(__8406,c__6204__auto___8419,G__8249_8407,G__8249_8408__$1,n__4607__auto___8405,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__8249_8408__$1)].join('')));

}

var G__8428 = (__8406 + (1));
__8406 = G__8428;
continue;
} else {
}
break;
}

var c__6204__auto___8429 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6204__auto___8429,jobs,results,process,async){
return (function (){
var f__6205__auto__ = (function (){var switch__6037__auto__ = ((function (c__6204__auto___8429,jobs,results,process,async){
return (function (state_8319){
var state_val_8320 = (state_8319[(1)]);
if((state_val_8320 === (7))){
var inst_8315 = (state_8319[(2)]);
var state_8319__$1 = state_8319;
var statearr_8321_8430 = state_8319__$1;
(statearr_8321_8430[(2)] = inst_8315);

(statearr_8321_8430[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8320 === (1))){
var state_8319__$1 = state_8319;
var statearr_8322_8431 = state_8319__$1;
(statearr_8322_8431[(2)] = null);

(statearr_8322_8431[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8320 === (4))){
var inst_8300 = (state_8319[(7)]);
var inst_8300__$1 = (state_8319[(2)]);
var inst_8301 = (inst_8300__$1 == null);
var state_8319__$1 = (function (){var statearr_8323 = state_8319;
(statearr_8323[(7)] = inst_8300__$1);

return statearr_8323;
})();
if(cljs.core.truth_(inst_8301)){
var statearr_8324_8432 = state_8319__$1;
(statearr_8324_8432[(1)] = (5));

} else {
var statearr_8325_8433 = state_8319__$1;
(statearr_8325_8433[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8320 === (6))){
var inst_8300 = (state_8319[(7)]);
var inst_8305 = (state_8319[(8)]);
var inst_8305__$1 = cljs.core.async.chan.call(null,(1));
var inst_8306 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_8307 = [inst_8300,inst_8305__$1];
var inst_8308 = (new cljs.core.PersistentVector(null,2,(5),inst_8306,inst_8307,null));
var state_8319__$1 = (function (){var statearr_8326 = state_8319;
(statearr_8326[(8)] = inst_8305__$1);

return statearr_8326;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8319__$1,(8),jobs,inst_8308);
} else {
if((state_val_8320 === (3))){
var inst_8317 = (state_8319[(2)]);
var state_8319__$1 = state_8319;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8319__$1,inst_8317);
} else {
if((state_val_8320 === (2))){
var state_8319__$1 = state_8319;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8319__$1,(4),from);
} else {
if((state_val_8320 === (9))){
var inst_8312 = (state_8319[(2)]);
var state_8319__$1 = (function (){var statearr_8327 = state_8319;
(statearr_8327[(9)] = inst_8312);

return statearr_8327;
})();
var statearr_8328_8434 = state_8319__$1;
(statearr_8328_8434[(2)] = null);

(statearr_8328_8434[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8320 === (5))){
var inst_8303 = cljs.core.async.close_BANG_.call(null,jobs);
var state_8319__$1 = state_8319;
var statearr_8329_8435 = state_8319__$1;
(statearr_8329_8435[(2)] = inst_8303);

(statearr_8329_8435[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8320 === (8))){
var inst_8305 = (state_8319[(8)]);
var inst_8310 = (state_8319[(2)]);
var state_8319__$1 = (function (){var statearr_8330 = state_8319;
(statearr_8330[(10)] = inst_8310);

return statearr_8330;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8319__$1,(9),results,inst_8305);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__6204__auto___8429,jobs,results,process,async))
;
return ((function (switch__6037__auto__,c__6204__auto___8429,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____0 = (function (){
var statearr_8331 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_8331[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__);

(statearr_8331[(1)] = (1));

return statearr_8331;
});
var cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____1 = (function (state_8319){
while(true){
var ret_value__6039__auto__ = (function (){try{while(true){
var result__6040__auto__ = switch__6037__auto__.call(null,state_8319);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6040__auto__;
}
break;
}
}catch (e8332){if((e8332 instanceof Object)){
var ex__6041__auto__ = e8332;
var statearr_8333_8436 = state_8319;
(statearr_8333_8436[(5)] = ex__6041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8319);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8332;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8437 = state_8319;
state_8319 = G__8437;
continue;
} else {
return ret_value__6039__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__ = function(state_8319){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____1.call(this,state_8319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__;
})()
;})(switch__6037__auto__,c__6204__auto___8429,jobs,results,process,async))
})();
var state__6206__auto__ = (function (){var statearr_8334 = f__6205__auto__.call(null);
(statearr_8334[(6)] = c__6204__auto___8429);

return statearr_8334;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6206__auto__);
});})(c__6204__auto___8429,jobs,results,process,async))
);


var c__6204__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6204__auto__,jobs,results,process,async){
return (function (){
var f__6205__auto__ = (function (){var switch__6037__auto__ = ((function (c__6204__auto__,jobs,results,process,async){
return (function (state_8372){
var state_val_8373 = (state_8372[(1)]);
if((state_val_8373 === (7))){
var inst_8368 = (state_8372[(2)]);
var state_8372__$1 = state_8372;
var statearr_8374_8438 = state_8372__$1;
(statearr_8374_8438[(2)] = inst_8368);

(statearr_8374_8438[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8373 === (20))){
var state_8372__$1 = state_8372;
var statearr_8375_8439 = state_8372__$1;
(statearr_8375_8439[(2)] = null);

(statearr_8375_8439[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8373 === (1))){
var state_8372__$1 = state_8372;
var statearr_8376_8440 = state_8372__$1;
(statearr_8376_8440[(2)] = null);

(statearr_8376_8440[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8373 === (4))){
var inst_8337 = (state_8372[(7)]);
var inst_8337__$1 = (state_8372[(2)]);
var inst_8338 = (inst_8337__$1 == null);
var state_8372__$1 = (function (){var statearr_8377 = state_8372;
(statearr_8377[(7)] = inst_8337__$1);

return statearr_8377;
})();
if(cljs.core.truth_(inst_8338)){
var statearr_8378_8441 = state_8372__$1;
(statearr_8378_8441[(1)] = (5));

} else {
var statearr_8379_8442 = state_8372__$1;
(statearr_8379_8442[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8373 === (15))){
var inst_8350 = (state_8372[(8)]);
var state_8372__$1 = state_8372;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8372__$1,(18),to,inst_8350);
} else {
if((state_val_8373 === (21))){
var inst_8363 = (state_8372[(2)]);
var state_8372__$1 = state_8372;
var statearr_8380_8443 = state_8372__$1;
(statearr_8380_8443[(2)] = inst_8363);

(statearr_8380_8443[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8373 === (13))){
var inst_8365 = (state_8372[(2)]);
var state_8372__$1 = (function (){var statearr_8381 = state_8372;
(statearr_8381[(9)] = inst_8365);

return statearr_8381;
})();
var statearr_8382_8444 = state_8372__$1;
(statearr_8382_8444[(2)] = null);

(statearr_8382_8444[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8373 === (6))){
var inst_8337 = (state_8372[(7)]);
var state_8372__$1 = state_8372;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8372__$1,(11),inst_8337);
} else {
if((state_val_8373 === (17))){
var inst_8358 = (state_8372[(2)]);
var state_8372__$1 = state_8372;
if(cljs.core.truth_(inst_8358)){
var statearr_8383_8445 = state_8372__$1;
(statearr_8383_8445[(1)] = (19));

} else {
var statearr_8384_8446 = state_8372__$1;
(statearr_8384_8446[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8373 === (3))){
var inst_8370 = (state_8372[(2)]);
var state_8372__$1 = state_8372;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8372__$1,inst_8370);
} else {
if((state_val_8373 === (12))){
var inst_8347 = (state_8372[(10)]);
var state_8372__$1 = state_8372;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8372__$1,(14),inst_8347);
} else {
if((state_val_8373 === (2))){
var state_8372__$1 = state_8372;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8372__$1,(4),results);
} else {
if((state_val_8373 === (19))){
var state_8372__$1 = state_8372;
var statearr_8385_8447 = state_8372__$1;
(statearr_8385_8447[(2)] = null);

(statearr_8385_8447[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8373 === (11))){
var inst_8347 = (state_8372[(2)]);
var state_8372__$1 = (function (){var statearr_8386 = state_8372;
(statearr_8386[(10)] = inst_8347);

return statearr_8386;
})();
var statearr_8387_8448 = state_8372__$1;
(statearr_8387_8448[(2)] = null);

(statearr_8387_8448[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8373 === (9))){
var state_8372__$1 = state_8372;
var statearr_8388_8449 = state_8372__$1;
(statearr_8388_8449[(2)] = null);

(statearr_8388_8449[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8373 === (5))){
var state_8372__$1 = state_8372;
if(cljs.core.truth_(close_QMARK_)){
var statearr_8389_8450 = state_8372__$1;
(statearr_8389_8450[(1)] = (8));

} else {
var statearr_8390_8451 = state_8372__$1;
(statearr_8390_8451[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8373 === (14))){
var inst_8352 = (state_8372[(11)]);
var inst_8350 = (state_8372[(8)]);
var inst_8350__$1 = (state_8372[(2)]);
var inst_8351 = (inst_8350__$1 == null);
var inst_8352__$1 = cljs.core.not.call(null,inst_8351);
var state_8372__$1 = (function (){var statearr_8391 = state_8372;
(statearr_8391[(11)] = inst_8352__$1);

(statearr_8391[(8)] = inst_8350__$1);

return statearr_8391;
})();
if(inst_8352__$1){
var statearr_8392_8452 = state_8372__$1;
(statearr_8392_8452[(1)] = (15));

} else {
var statearr_8393_8453 = state_8372__$1;
(statearr_8393_8453[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8373 === (16))){
var inst_8352 = (state_8372[(11)]);
var state_8372__$1 = state_8372;
var statearr_8394_8454 = state_8372__$1;
(statearr_8394_8454[(2)] = inst_8352);

(statearr_8394_8454[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8373 === (10))){
var inst_8344 = (state_8372[(2)]);
var state_8372__$1 = state_8372;
var statearr_8395_8455 = state_8372__$1;
(statearr_8395_8455[(2)] = inst_8344);

(statearr_8395_8455[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8373 === (18))){
var inst_8355 = (state_8372[(2)]);
var state_8372__$1 = state_8372;
var statearr_8396_8456 = state_8372__$1;
(statearr_8396_8456[(2)] = inst_8355);

(statearr_8396_8456[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8373 === (8))){
var inst_8341 = cljs.core.async.close_BANG_.call(null,to);
var state_8372__$1 = state_8372;
var statearr_8397_8457 = state_8372__$1;
(statearr_8397_8457[(2)] = inst_8341);

(statearr_8397_8457[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6204__auto__,jobs,results,process,async))
;
return ((function (switch__6037__auto__,c__6204__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____0 = (function (){
var statearr_8398 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_8398[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__);

(statearr_8398[(1)] = (1));

return statearr_8398;
});
var cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____1 = (function (state_8372){
while(true){
var ret_value__6039__auto__ = (function (){try{while(true){
var result__6040__auto__ = switch__6037__auto__.call(null,state_8372);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6040__auto__;
}
break;
}
}catch (e8399){if((e8399 instanceof Object)){
var ex__6041__auto__ = e8399;
var statearr_8400_8458 = state_8372;
(statearr_8400_8458[(5)] = ex__6041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8372);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8399;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8459 = state_8372;
state_8372 = G__8459;
continue;
} else {
return ret_value__6039__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__ = function(state_8372){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____1.call(this,state_8372);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__6038__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__6038__auto__;
})()
;})(switch__6037__auto__,c__6204__auto__,jobs,results,process,async))
})();
var state__6206__auto__ = (function (){var statearr_8401 = f__6205__auto__.call(null);
(statearr_8401[(6)] = c__6204__auto__);

return statearr_8401;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6206__auto__);
});})(c__6204__auto__,jobs,results,process,async))
);

return c__6204__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__8461 = arguments.length;
switch (G__8461) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__8464 = arguments.length;
switch (G__8464) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__8467 = arguments.length;
switch (G__8467) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__6204__auto___8516 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6204__auto___8516,tc,fc){
return (function (){
var f__6205__auto__ = (function (){var switch__6037__auto__ = ((function (c__6204__auto___8516,tc,fc){
return (function (state_8493){
var state_val_8494 = (state_8493[(1)]);
if((state_val_8494 === (7))){
var inst_8489 = (state_8493[(2)]);
var state_8493__$1 = state_8493;
var statearr_8495_8517 = state_8493__$1;
(statearr_8495_8517[(2)] = inst_8489);

(statearr_8495_8517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8494 === (1))){
var state_8493__$1 = state_8493;
var statearr_8496_8518 = state_8493__$1;
(statearr_8496_8518[(2)] = null);

(statearr_8496_8518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8494 === (4))){
var inst_8470 = (state_8493[(7)]);
var inst_8470__$1 = (state_8493[(2)]);
var inst_8471 = (inst_8470__$1 == null);
var state_8493__$1 = (function (){var statearr_8497 = state_8493;
(statearr_8497[(7)] = inst_8470__$1);

return statearr_8497;
})();
if(cljs.core.truth_(inst_8471)){
var statearr_8498_8519 = state_8493__$1;
(statearr_8498_8519[(1)] = (5));

} else {
var statearr_8499_8520 = state_8493__$1;
(statearr_8499_8520[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8494 === (13))){
var state_8493__$1 = state_8493;
var statearr_8500_8521 = state_8493__$1;
(statearr_8500_8521[(2)] = null);

(statearr_8500_8521[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8494 === (6))){
var inst_8470 = (state_8493[(7)]);
var inst_8476 = p.call(null,inst_8470);
var state_8493__$1 = state_8493;
if(cljs.core.truth_(inst_8476)){
var statearr_8501_8522 = state_8493__$1;
(statearr_8501_8522[(1)] = (9));

} else {
var statearr_8502_8523 = state_8493__$1;
(statearr_8502_8523[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8494 === (3))){
var inst_8491 = (state_8493[(2)]);
var state_8493__$1 = state_8493;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8493__$1,inst_8491);
} else {
if((state_val_8494 === (12))){
var state_8493__$1 = state_8493;
var statearr_8503_8524 = state_8493__$1;
(statearr_8503_8524[(2)] = null);

(statearr_8503_8524[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8494 === (2))){
var state_8493__$1 = state_8493;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8493__$1,(4),ch);
} else {
if((state_val_8494 === (11))){
var inst_8470 = (state_8493[(7)]);
var inst_8480 = (state_8493[(2)]);
var state_8493__$1 = state_8493;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8493__$1,(8),inst_8480,inst_8470);
} else {
if((state_val_8494 === (9))){
var state_8493__$1 = state_8493;
var statearr_8504_8525 = state_8493__$1;
(statearr_8504_8525[(2)] = tc);

(statearr_8504_8525[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8494 === (5))){
var inst_8473 = cljs.core.async.close_BANG_.call(null,tc);
var inst_8474 = cljs.core.async.close_BANG_.call(null,fc);
var state_8493__$1 = (function (){var statearr_8505 = state_8493;
(statearr_8505[(8)] = inst_8473);

return statearr_8505;
})();
var statearr_8506_8526 = state_8493__$1;
(statearr_8506_8526[(2)] = inst_8474);

(statearr_8506_8526[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8494 === (14))){
var inst_8487 = (state_8493[(2)]);
var state_8493__$1 = state_8493;
var statearr_8507_8527 = state_8493__$1;
(statearr_8507_8527[(2)] = inst_8487);

(statearr_8507_8527[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8494 === (10))){
var state_8493__$1 = state_8493;
var statearr_8508_8528 = state_8493__$1;
(statearr_8508_8528[(2)] = fc);

(statearr_8508_8528[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8494 === (8))){
var inst_8482 = (state_8493[(2)]);
var state_8493__$1 = state_8493;
if(cljs.core.truth_(inst_8482)){
var statearr_8509_8529 = state_8493__$1;
(statearr_8509_8529[(1)] = (12));

} else {
var statearr_8510_8530 = state_8493__$1;
(statearr_8510_8530[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6204__auto___8516,tc,fc))
;
return ((function (switch__6037__auto__,c__6204__auto___8516,tc,fc){
return (function() {
var cljs$core$async$state_machine__6038__auto__ = null;
var cljs$core$async$state_machine__6038__auto____0 = (function (){
var statearr_8511 = [null,null,null,null,null,null,null,null,null];
(statearr_8511[(0)] = cljs$core$async$state_machine__6038__auto__);

(statearr_8511[(1)] = (1));

return statearr_8511;
});
var cljs$core$async$state_machine__6038__auto____1 = (function (state_8493){
while(true){
var ret_value__6039__auto__ = (function (){try{while(true){
var result__6040__auto__ = switch__6037__auto__.call(null,state_8493);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6040__auto__;
}
break;
}
}catch (e8512){if((e8512 instanceof Object)){
var ex__6041__auto__ = e8512;
var statearr_8513_8531 = state_8493;
(statearr_8513_8531[(5)] = ex__6041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8493);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8512;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8532 = state_8493;
state_8493 = G__8532;
continue;
} else {
return ret_value__6039__auto__;
}
break;
}
});
cljs$core$async$state_machine__6038__auto__ = function(state_8493){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6038__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6038__auto____1.call(this,state_8493);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6038__auto____0;
cljs$core$async$state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6038__auto____1;
return cljs$core$async$state_machine__6038__auto__;
})()
;})(switch__6037__auto__,c__6204__auto___8516,tc,fc))
})();
var state__6206__auto__ = (function (){var statearr_8514 = f__6205__auto__.call(null);
(statearr_8514[(6)] = c__6204__auto___8516);

return statearr_8514;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6206__auto__);
});})(c__6204__auto___8516,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__6204__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6204__auto__){
return (function (){
var f__6205__auto__ = (function (){var switch__6037__auto__ = ((function (c__6204__auto__){
return (function (state_8553){
var state_val_8554 = (state_8553[(1)]);
if((state_val_8554 === (7))){
var inst_8549 = (state_8553[(2)]);
var state_8553__$1 = state_8553;
var statearr_8555_8573 = state_8553__$1;
(statearr_8555_8573[(2)] = inst_8549);

(statearr_8555_8573[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8554 === (1))){
var inst_8533 = init;
var state_8553__$1 = (function (){var statearr_8556 = state_8553;
(statearr_8556[(7)] = inst_8533);

return statearr_8556;
})();
var statearr_8557_8574 = state_8553__$1;
(statearr_8557_8574[(2)] = null);

(statearr_8557_8574[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8554 === (4))){
var inst_8536 = (state_8553[(8)]);
var inst_8536__$1 = (state_8553[(2)]);
var inst_8537 = (inst_8536__$1 == null);
var state_8553__$1 = (function (){var statearr_8558 = state_8553;
(statearr_8558[(8)] = inst_8536__$1);

return statearr_8558;
})();
if(cljs.core.truth_(inst_8537)){
var statearr_8559_8575 = state_8553__$1;
(statearr_8559_8575[(1)] = (5));

} else {
var statearr_8560_8576 = state_8553__$1;
(statearr_8560_8576[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8554 === (6))){
var inst_8540 = (state_8553[(9)]);
var inst_8533 = (state_8553[(7)]);
var inst_8536 = (state_8553[(8)]);
var inst_8540__$1 = f.call(null,inst_8533,inst_8536);
var inst_8541 = cljs.core.reduced_QMARK_.call(null,inst_8540__$1);
var state_8553__$1 = (function (){var statearr_8561 = state_8553;
(statearr_8561[(9)] = inst_8540__$1);

return statearr_8561;
})();
if(inst_8541){
var statearr_8562_8577 = state_8553__$1;
(statearr_8562_8577[(1)] = (8));

} else {
var statearr_8563_8578 = state_8553__$1;
(statearr_8563_8578[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8554 === (3))){
var inst_8551 = (state_8553[(2)]);
var state_8553__$1 = state_8553;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8553__$1,inst_8551);
} else {
if((state_val_8554 === (2))){
var state_8553__$1 = state_8553;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8553__$1,(4),ch);
} else {
if((state_val_8554 === (9))){
var inst_8540 = (state_8553[(9)]);
var inst_8533 = inst_8540;
var state_8553__$1 = (function (){var statearr_8564 = state_8553;
(statearr_8564[(7)] = inst_8533);

return statearr_8564;
})();
var statearr_8565_8579 = state_8553__$1;
(statearr_8565_8579[(2)] = null);

(statearr_8565_8579[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8554 === (5))){
var inst_8533 = (state_8553[(7)]);
var state_8553__$1 = state_8553;
var statearr_8566_8580 = state_8553__$1;
(statearr_8566_8580[(2)] = inst_8533);

(statearr_8566_8580[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8554 === (10))){
var inst_8547 = (state_8553[(2)]);
var state_8553__$1 = state_8553;
var statearr_8567_8581 = state_8553__$1;
(statearr_8567_8581[(2)] = inst_8547);

(statearr_8567_8581[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8554 === (8))){
var inst_8540 = (state_8553[(9)]);
var inst_8543 = cljs.core.deref.call(null,inst_8540);
var state_8553__$1 = state_8553;
var statearr_8568_8582 = state_8553__$1;
(statearr_8568_8582[(2)] = inst_8543);

(statearr_8568_8582[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__6204__auto__))
;
return ((function (switch__6037__auto__,c__6204__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__6038__auto__ = null;
var cljs$core$async$reduce_$_state_machine__6038__auto____0 = (function (){
var statearr_8569 = [null,null,null,null,null,null,null,null,null,null];
(statearr_8569[(0)] = cljs$core$async$reduce_$_state_machine__6038__auto__);

(statearr_8569[(1)] = (1));

return statearr_8569;
});
var cljs$core$async$reduce_$_state_machine__6038__auto____1 = (function (state_8553){
while(true){
var ret_value__6039__auto__ = (function (){try{while(true){
var result__6040__auto__ = switch__6037__auto__.call(null,state_8553);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6040__auto__;
}
break;
}
}catch (e8570){if((e8570 instanceof Object)){
var ex__6041__auto__ = e8570;
var statearr_8571_8583 = state_8553;
(statearr_8571_8583[(5)] = ex__6041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8553);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8570;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8584 = state_8553;
state_8553 = G__8584;
continue;
} else {
return ret_value__6039__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__6038__auto__ = function(state_8553){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__6038__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__6038__auto____1.call(this,state_8553);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__6038__auto____0;
cljs$core$async$reduce_$_state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__6038__auto____1;
return cljs$core$async$reduce_$_state_machine__6038__auto__;
})()
;})(switch__6037__auto__,c__6204__auto__))
})();
var state__6206__auto__ = (function (){var statearr_8572 = f__6205__auto__.call(null);
(statearr_8572[(6)] = c__6204__auto__);

return statearr_8572;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6206__auto__);
});})(c__6204__auto__))
);

return c__6204__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__6204__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6204__auto__,f__$1){
return (function (){
var f__6205__auto__ = (function (){var switch__6037__auto__ = ((function (c__6204__auto__,f__$1){
return (function (state_8590){
var state_val_8591 = (state_8590[(1)]);
if((state_val_8591 === (1))){
var inst_8585 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_8590__$1 = state_8590;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8590__$1,(2),inst_8585);
} else {
if((state_val_8591 === (2))){
var inst_8587 = (state_8590[(2)]);
var inst_8588 = f__$1.call(null,inst_8587);
var state_8590__$1 = state_8590;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8590__$1,inst_8588);
} else {
return null;
}
}
});})(c__6204__auto__,f__$1))
;
return ((function (switch__6037__auto__,c__6204__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__6038__auto__ = null;
var cljs$core$async$transduce_$_state_machine__6038__auto____0 = (function (){
var statearr_8592 = [null,null,null,null,null,null,null];
(statearr_8592[(0)] = cljs$core$async$transduce_$_state_machine__6038__auto__);

(statearr_8592[(1)] = (1));

return statearr_8592;
});
var cljs$core$async$transduce_$_state_machine__6038__auto____1 = (function (state_8590){
while(true){
var ret_value__6039__auto__ = (function (){try{while(true){
var result__6040__auto__ = switch__6037__auto__.call(null,state_8590);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6040__auto__;
}
break;
}
}catch (e8593){if((e8593 instanceof Object)){
var ex__6041__auto__ = e8593;
var statearr_8594_8596 = state_8590;
(statearr_8594_8596[(5)] = ex__6041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8590);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8593;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8597 = state_8590;
state_8590 = G__8597;
continue;
} else {
return ret_value__6039__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__6038__auto__ = function(state_8590){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__6038__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__6038__auto____1.call(this,state_8590);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__6038__auto____0;
cljs$core$async$transduce_$_state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__6038__auto____1;
return cljs$core$async$transduce_$_state_machine__6038__auto__;
})()
;})(switch__6037__auto__,c__6204__auto__,f__$1))
})();
var state__6206__auto__ = (function (){var statearr_8595 = f__6205__auto__.call(null);
(statearr_8595[(6)] = c__6204__auto__);

return statearr_8595;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6206__auto__);
});})(c__6204__auto__,f__$1))
);

return c__6204__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__8599 = arguments.length;
switch (G__8599) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__6204__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6204__auto__){
return (function (){
var f__6205__auto__ = (function (){var switch__6037__auto__ = ((function (c__6204__auto__){
return (function (state_8624){
var state_val_8625 = (state_8624[(1)]);
if((state_val_8625 === (7))){
var inst_8606 = (state_8624[(2)]);
var state_8624__$1 = state_8624;
var statearr_8626_8647 = state_8624__$1;
(statearr_8626_8647[(2)] = inst_8606);

(statearr_8626_8647[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8625 === (1))){
var inst_8600 = cljs.core.seq.call(null,coll);
var inst_8601 = inst_8600;
var state_8624__$1 = (function (){var statearr_8627 = state_8624;
(statearr_8627[(7)] = inst_8601);

return statearr_8627;
})();
var statearr_8628_8648 = state_8624__$1;
(statearr_8628_8648[(2)] = null);

(statearr_8628_8648[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8625 === (4))){
var inst_8601 = (state_8624[(7)]);
var inst_8604 = cljs.core.first.call(null,inst_8601);
var state_8624__$1 = state_8624;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8624__$1,(7),ch,inst_8604);
} else {
if((state_val_8625 === (13))){
var inst_8618 = (state_8624[(2)]);
var state_8624__$1 = state_8624;
var statearr_8629_8649 = state_8624__$1;
(statearr_8629_8649[(2)] = inst_8618);

(statearr_8629_8649[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8625 === (6))){
var inst_8609 = (state_8624[(2)]);
var state_8624__$1 = state_8624;
if(cljs.core.truth_(inst_8609)){
var statearr_8630_8650 = state_8624__$1;
(statearr_8630_8650[(1)] = (8));

} else {
var statearr_8631_8651 = state_8624__$1;
(statearr_8631_8651[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8625 === (3))){
var inst_8622 = (state_8624[(2)]);
var state_8624__$1 = state_8624;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8624__$1,inst_8622);
} else {
if((state_val_8625 === (12))){
var state_8624__$1 = state_8624;
var statearr_8632_8652 = state_8624__$1;
(statearr_8632_8652[(2)] = null);

(statearr_8632_8652[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8625 === (2))){
var inst_8601 = (state_8624[(7)]);
var state_8624__$1 = state_8624;
if(cljs.core.truth_(inst_8601)){
var statearr_8633_8653 = state_8624__$1;
(statearr_8633_8653[(1)] = (4));

} else {
var statearr_8634_8654 = state_8624__$1;
(statearr_8634_8654[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8625 === (11))){
var inst_8615 = cljs.core.async.close_BANG_.call(null,ch);
var state_8624__$1 = state_8624;
var statearr_8635_8655 = state_8624__$1;
(statearr_8635_8655[(2)] = inst_8615);

(statearr_8635_8655[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8625 === (9))){
var state_8624__$1 = state_8624;
if(cljs.core.truth_(close_QMARK_)){
var statearr_8636_8656 = state_8624__$1;
(statearr_8636_8656[(1)] = (11));

} else {
var statearr_8637_8657 = state_8624__$1;
(statearr_8637_8657[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8625 === (5))){
var inst_8601 = (state_8624[(7)]);
var state_8624__$1 = state_8624;
var statearr_8638_8658 = state_8624__$1;
(statearr_8638_8658[(2)] = inst_8601);

(statearr_8638_8658[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8625 === (10))){
var inst_8620 = (state_8624[(2)]);
var state_8624__$1 = state_8624;
var statearr_8639_8659 = state_8624__$1;
(statearr_8639_8659[(2)] = inst_8620);

(statearr_8639_8659[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8625 === (8))){
var inst_8601 = (state_8624[(7)]);
var inst_8611 = cljs.core.next.call(null,inst_8601);
var inst_8601__$1 = inst_8611;
var state_8624__$1 = (function (){var statearr_8640 = state_8624;
(statearr_8640[(7)] = inst_8601__$1);

return statearr_8640;
})();
var statearr_8641_8660 = state_8624__$1;
(statearr_8641_8660[(2)] = null);

(statearr_8641_8660[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6204__auto__))
;
return ((function (switch__6037__auto__,c__6204__auto__){
return (function() {
var cljs$core$async$state_machine__6038__auto__ = null;
var cljs$core$async$state_machine__6038__auto____0 = (function (){
var statearr_8642 = [null,null,null,null,null,null,null,null];
(statearr_8642[(0)] = cljs$core$async$state_machine__6038__auto__);

(statearr_8642[(1)] = (1));

return statearr_8642;
});
var cljs$core$async$state_machine__6038__auto____1 = (function (state_8624){
while(true){
var ret_value__6039__auto__ = (function (){try{while(true){
var result__6040__auto__ = switch__6037__auto__.call(null,state_8624);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6040__auto__;
}
break;
}
}catch (e8643){if((e8643 instanceof Object)){
var ex__6041__auto__ = e8643;
var statearr_8644_8661 = state_8624;
(statearr_8644_8661[(5)] = ex__6041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8624);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8643;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8662 = state_8624;
state_8624 = G__8662;
continue;
} else {
return ret_value__6039__auto__;
}
break;
}
});
cljs$core$async$state_machine__6038__auto__ = function(state_8624){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6038__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6038__auto____1.call(this,state_8624);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6038__auto____0;
cljs$core$async$state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6038__auto____1;
return cljs$core$async$state_machine__6038__auto__;
})()
;})(switch__6037__auto__,c__6204__auto__))
})();
var state__6206__auto__ = (function (){var statearr_8645 = f__6205__auto__.call(null);
(statearr_8645[(6)] = c__6204__auto__);

return statearr_8645;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6206__auto__);
});})(c__6204__auto__))
);

return c__6204__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4433__auto__ = (((_ == null))?null:_);
var m__4434__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,_);
} else {
var m__4431__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4431__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m);
} else {
var m__4431__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async8663 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8663 = (function (ch,cs,meta8664){
this.ch = ch;
this.cs = cs;
this.meta8664 = meta8664;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async8663.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_8665,meta8664__$1){
var self__ = this;
var _8665__$1 = this;
return (new cljs.core.async.t_cljs$core$async8663(self__.ch,self__.cs,meta8664__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async8663.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_8665){
var self__ = this;
var _8665__$1 = this;
return self__.meta8664;
});})(cs))
;

cljs.core.async.t_cljs$core$async8663.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async8663.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async8663.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async8663.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async8663.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async8663.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async8663.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta8664","meta8664",-371509098,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async8663.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async8663.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8663";

cljs.core.async.t_cljs$core$async8663.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async8663");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async8663.
 */
cljs.core.async.__GT_t_cljs$core$async8663 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async8663(ch__$1,cs__$1,meta8664){
return (new cljs.core.async.t_cljs$core$async8663(ch__$1,cs__$1,meta8664));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async8663(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__6204__auto___8885 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6204__auto___8885,cs,m,dchan,dctr,done){
return (function (){
var f__6205__auto__ = (function (){var switch__6037__auto__ = ((function (c__6204__auto___8885,cs,m,dchan,dctr,done){
return (function (state_8800){
var state_val_8801 = (state_8800[(1)]);
if((state_val_8801 === (7))){
var inst_8796 = (state_8800[(2)]);
var state_8800__$1 = state_8800;
var statearr_8802_8886 = state_8800__$1;
(statearr_8802_8886[(2)] = inst_8796);

(statearr_8802_8886[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (20))){
var inst_8699 = (state_8800[(7)]);
var inst_8711 = cljs.core.first.call(null,inst_8699);
var inst_8712 = cljs.core.nth.call(null,inst_8711,(0),null);
var inst_8713 = cljs.core.nth.call(null,inst_8711,(1),null);
var state_8800__$1 = (function (){var statearr_8803 = state_8800;
(statearr_8803[(8)] = inst_8712);

return statearr_8803;
})();
if(cljs.core.truth_(inst_8713)){
var statearr_8804_8887 = state_8800__$1;
(statearr_8804_8887[(1)] = (22));

} else {
var statearr_8805_8888 = state_8800__$1;
(statearr_8805_8888[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (27))){
var inst_8748 = (state_8800[(9)]);
var inst_8741 = (state_8800[(10)]);
var inst_8743 = (state_8800[(11)]);
var inst_8668 = (state_8800[(12)]);
var inst_8748__$1 = cljs.core._nth.call(null,inst_8741,inst_8743);
var inst_8749 = cljs.core.async.put_BANG_.call(null,inst_8748__$1,inst_8668,done);
var state_8800__$1 = (function (){var statearr_8806 = state_8800;
(statearr_8806[(9)] = inst_8748__$1);

return statearr_8806;
})();
if(cljs.core.truth_(inst_8749)){
var statearr_8807_8889 = state_8800__$1;
(statearr_8807_8889[(1)] = (30));

} else {
var statearr_8808_8890 = state_8800__$1;
(statearr_8808_8890[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (1))){
var state_8800__$1 = state_8800;
var statearr_8809_8891 = state_8800__$1;
(statearr_8809_8891[(2)] = null);

(statearr_8809_8891[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (24))){
var inst_8699 = (state_8800[(7)]);
var inst_8718 = (state_8800[(2)]);
var inst_8719 = cljs.core.next.call(null,inst_8699);
var inst_8677 = inst_8719;
var inst_8678 = null;
var inst_8679 = (0);
var inst_8680 = (0);
var state_8800__$1 = (function (){var statearr_8810 = state_8800;
(statearr_8810[(13)] = inst_8680);

(statearr_8810[(14)] = inst_8678);

(statearr_8810[(15)] = inst_8677);

(statearr_8810[(16)] = inst_8679);

(statearr_8810[(17)] = inst_8718);

return statearr_8810;
})();
var statearr_8811_8892 = state_8800__$1;
(statearr_8811_8892[(2)] = null);

(statearr_8811_8892[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (39))){
var state_8800__$1 = state_8800;
var statearr_8815_8893 = state_8800__$1;
(statearr_8815_8893[(2)] = null);

(statearr_8815_8893[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (4))){
var inst_8668 = (state_8800[(12)]);
var inst_8668__$1 = (state_8800[(2)]);
var inst_8669 = (inst_8668__$1 == null);
var state_8800__$1 = (function (){var statearr_8816 = state_8800;
(statearr_8816[(12)] = inst_8668__$1);

return statearr_8816;
})();
if(cljs.core.truth_(inst_8669)){
var statearr_8817_8894 = state_8800__$1;
(statearr_8817_8894[(1)] = (5));

} else {
var statearr_8818_8895 = state_8800__$1;
(statearr_8818_8895[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (15))){
var inst_8680 = (state_8800[(13)]);
var inst_8678 = (state_8800[(14)]);
var inst_8677 = (state_8800[(15)]);
var inst_8679 = (state_8800[(16)]);
var inst_8695 = (state_8800[(2)]);
var inst_8696 = (inst_8680 + (1));
var tmp8812 = inst_8678;
var tmp8813 = inst_8677;
var tmp8814 = inst_8679;
var inst_8677__$1 = tmp8813;
var inst_8678__$1 = tmp8812;
var inst_8679__$1 = tmp8814;
var inst_8680__$1 = inst_8696;
var state_8800__$1 = (function (){var statearr_8819 = state_8800;
(statearr_8819[(13)] = inst_8680__$1);

(statearr_8819[(18)] = inst_8695);

(statearr_8819[(14)] = inst_8678__$1);

(statearr_8819[(15)] = inst_8677__$1);

(statearr_8819[(16)] = inst_8679__$1);

return statearr_8819;
})();
var statearr_8820_8896 = state_8800__$1;
(statearr_8820_8896[(2)] = null);

(statearr_8820_8896[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (21))){
var inst_8722 = (state_8800[(2)]);
var state_8800__$1 = state_8800;
var statearr_8824_8897 = state_8800__$1;
(statearr_8824_8897[(2)] = inst_8722);

(statearr_8824_8897[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (31))){
var inst_8748 = (state_8800[(9)]);
var inst_8752 = done.call(null,null);
var inst_8753 = cljs.core.async.untap_STAR_.call(null,m,inst_8748);
var state_8800__$1 = (function (){var statearr_8825 = state_8800;
(statearr_8825[(19)] = inst_8752);

return statearr_8825;
})();
var statearr_8826_8898 = state_8800__$1;
(statearr_8826_8898[(2)] = inst_8753);

(statearr_8826_8898[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (32))){
var inst_8741 = (state_8800[(10)]);
var inst_8740 = (state_8800[(20)]);
var inst_8742 = (state_8800[(21)]);
var inst_8743 = (state_8800[(11)]);
var inst_8755 = (state_8800[(2)]);
var inst_8756 = (inst_8743 + (1));
var tmp8821 = inst_8741;
var tmp8822 = inst_8740;
var tmp8823 = inst_8742;
var inst_8740__$1 = tmp8822;
var inst_8741__$1 = tmp8821;
var inst_8742__$1 = tmp8823;
var inst_8743__$1 = inst_8756;
var state_8800__$1 = (function (){var statearr_8827 = state_8800;
(statearr_8827[(10)] = inst_8741__$1);

(statearr_8827[(22)] = inst_8755);

(statearr_8827[(20)] = inst_8740__$1);

(statearr_8827[(21)] = inst_8742__$1);

(statearr_8827[(11)] = inst_8743__$1);

return statearr_8827;
})();
var statearr_8828_8899 = state_8800__$1;
(statearr_8828_8899[(2)] = null);

(statearr_8828_8899[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (40))){
var inst_8768 = (state_8800[(23)]);
var inst_8772 = done.call(null,null);
var inst_8773 = cljs.core.async.untap_STAR_.call(null,m,inst_8768);
var state_8800__$1 = (function (){var statearr_8829 = state_8800;
(statearr_8829[(24)] = inst_8772);

return statearr_8829;
})();
var statearr_8830_8900 = state_8800__$1;
(statearr_8830_8900[(2)] = inst_8773);

(statearr_8830_8900[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (33))){
var inst_8759 = (state_8800[(25)]);
var inst_8761 = cljs.core.chunked_seq_QMARK_.call(null,inst_8759);
var state_8800__$1 = state_8800;
if(inst_8761){
var statearr_8831_8901 = state_8800__$1;
(statearr_8831_8901[(1)] = (36));

} else {
var statearr_8832_8902 = state_8800__$1;
(statearr_8832_8902[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (13))){
var inst_8689 = (state_8800[(26)]);
var inst_8692 = cljs.core.async.close_BANG_.call(null,inst_8689);
var state_8800__$1 = state_8800;
var statearr_8833_8903 = state_8800__$1;
(statearr_8833_8903[(2)] = inst_8692);

(statearr_8833_8903[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (22))){
var inst_8712 = (state_8800[(8)]);
var inst_8715 = cljs.core.async.close_BANG_.call(null,inst_8712);
var state_8800__$1 = state_8800;
var statearr_8834_8904 = state_8800__$1;
(statearr_8834_8904[(2)] = inst_8715);

(statearr_8834_8904[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (36))){
var inst_8759 = (state_8800[(25)]);
var inst_8763 = cljs.core.chunk_first.call(null,inst_8759);
var inst_8764 = cljs.core.chunk_rest.call(null,inst_8759);
var inst_8765 = cljs.core.count.call(null,inst_8763);
var inst_8740 = inst_8764;
var inst_8741 = inst_8763;
var inst_8742 = inst_8765;
var inst_8743 = (0);
var state_8800__$1 = (function (){var statearr_8835 = state_8800;
(statearr_8835[(10)] = inst_8741);

(statearr_8835[(20)] = inst_8740);

(statearr_8835[(21)] = inst_8742);

(statearr_8835[(11)] = inst_8743);

return statearr_8835;
})();
var statearr_8836_8905 = state_8800__$1;
(statearr_8836_8905[(2)] = null);

(statearr_8836_8905[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (41))){
var inst_8759 = (state_8800[(25)]);
var inst_8775 = (state_8800[(2)]);
var inst_8776 = cljs.core.next.call(null,inst_8759);
var inst_8740 = inst_8776;
var inst_8741 = null;
var inst_8742 = (0);
var inst_8743 = (0);
var state_8800__$1 = (function (){var statearr_8837 = state_8800;
(statearr_8837[(10)] = inst_8741);

(statearr_8837[(27)] = inst_8775);

(statearr_8837[(20)] = inst_8740);

(statearr_8837[(21)] = inst_8742);

(statearr_8837[(11)] = inst_8743);

return statearr_8837;
})();
var statearr_8838_8906 = state_8800__$1;
(statearr_8838_8906[(2)] = null);

(statearr_8838_8906[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (43))){
var state_8800__$1 = state_8800;
var statearr_8839_8907 = state_8800__$1;
(statearr_8839_8907[(2)] = null);

(statearr_8839_8907[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (29))){
var inst_8784 = (state_8800[(2)]);
var state_8800__$1 = state_8800;
var statearr_8840_8908 = state_8800__$1;
(statearr_8840_8908[(2)] = inst_8784);

(statearr_8840_8908[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (44))){
var inst_8793 = (state_8800[(2)]);
var state_8800__$1 = (function (){var statearr_8841 = state_8800;
(statearr_8841[(28)] = inst_8793);

return statearr_8841;
})();
var statearr_8842_8909 = state_8800__$1;
(statearr_8842_8909[(2)] = null);

(statearr_8842_8909[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (6))){
var inst_8732 = (state_8800[(29)]);
var inst_8731 = cljs.core.deref.call(null,cs);
var inst_8732__$1 = cljs.core.keys.call(null,inst_8731);
var inst_8733 = cljs.core.count.call(null,inst_8732__$1);
var inst_8734 = cljs.core.reset_BANG_.call(null,dctr,inst_8733);
var inst_8739 = cljs.core.seq.call(null,inst_8732__$1);
var inst_8740 = inst_8739;
var inst_8741 = null;
var inst_8742 = (0);
var inst_8743 = (0);
var state_8800__$1 = (function (){var statearr_8843 = state_8800;
(statearr_8843[(30)] = inst_8734);

(statearr_8843[(10)] = inst_8741);

(statearr_8843[(29)] = inst_8732__$1);

(statearr_8843[(20)] = inst_8740);

(statearr_8843[(21)] = inst_8742);

(statearr_8843[(11)] = inst_8743);

return statearr_8843;
})();
var statearr_8844_8910 = state_8800__$1;
(statearr_8844_8910[(2)] = null);

(statearr_8844_8910[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (28))){
var inst_8740 = (state_8800[(20)]);
var inst_8759 = (state_8800[(25)]);
var inst_8759__$1 = cljs.core.seq.call(null,inst_8740);
var state_8800__$1 = (function (){var statearr_8845 = state_8800;
(statearr_8845[(25)] = inst_8759__$1);

return statearr_8845;
})();
if(inst_8759__$1){
var statearr_8846_8911 = state_8800__$1;
(statearr_8846_8911[(1)] = (33));

} else {
var statearr_8847_8912 = state_8800__$1;
(statearr_8847_8912[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (25))){
var inst_8742 = (state_8800[(21)]);
var inst_8743 = (state_8800[(11)]);
var inst_8745 = (inst_8743 < inst_8742);
var inst_8746 = inst_8745;
var state_8800__$1 = state_8800;
if(cljs.core.truth_(inst_8746)){
var statearr_8848_8913 = state_8800__$1;
(statearr_8848_8913[(1)] = (27));

} else {
var statearr_8849_8914 = state_8800__$1;
(statearr_8849_8914[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (34))){
var state_8800__$1 = state_8800;
var statearr_8850_8915 = state_8800__$1;
(statearr_8850_8915[(2)] = null);

(statearr_8850_8915[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (17))){
var state_8800__$1 = state_8800;
var statearr_8851_8916 = state_8800__$1;
(statearr_8851_8916[(2)] = null);

(statearr_8851_8916[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (3))){
var inst_8798 = (state_8800[(2)]);
var state_8800__$1 = state_8800;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8800__$1,inst_8798);
} else {
if((state_val_8801 === (12))){
var inst_8727 = (state_8800[(2)]);
var state_8800__$1 = state_8800;
var statearr_8852_8917 = state_8800__$1;
(statearr_8852_8917[(2)] = inst_8727);

(statearr_8852_8917[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (2))){
var state_8800__$1 = state_8800;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8800__$1,(4),ch);
} else {
if((state_val_8801 === (23))){
var state_8800__$1 = state_8800;
var statearr_8853_8918 = state_8800__$1;
(statearr_8853_8918[(2)] = null);

(statearr_8853_8918[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (35))){
var inst_8782 = (state_8800[(2)]);
var state_8800__$1 = state_8800;
var statearr_8854_8919 = state_8800__$1;
(statearr_8854_8919[(2)] = inst_8782);

(statearr_8854_8919[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (19))){
var inst_8699 = (state_8800[(7)]);
var inst_8703 = cljs.core.chunk_first.call(null,inst_8699);
var inst_8704 = cljs.core.chunk_rest.call(null,inst_8699);
var inst_8705 = cljs.core.count.call(null,inst_8703);
var inst_8677 = inst_8704;
var inst_8678 = inst_8703;
var inst_8679 = inst_8705;
var inst_8680 = (0);
var state_8800__$1 = (function (){var statearr_8855 = state_8800;
(statearr_8855[(13)] = inst_8680);

(statearr_8855[(14)] = inst_8678);

(statearr_8855[(15)] = inst_8677);

(statearr_8855[(16)] = inst_8679);

return statearr_8855;
})();
var statearr_8856_8920 = state_8800__$1;
(statearr_8856_8920[(2)] = null);

(statearr_8856_8920[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (11))){
var inst_8699 = (state_8800[(7)]);
var inst_8677 = (state_8800[(15)]);
var inst_8699__$1 = cljs.core.seq.call(null,inst_8677);
var state_8800__$1 = (function (){var statearr_8857 = state_8800;
(statearr_8857[(7)] = inst_8699__$1);

return statearr_8857;
})();
if(inst_8699__$1){
var statearr_8858_8921 = state_8800__$1;
(statearr_8858_8921[(1)] = (16));

} else {
var statearr_8859_8922 = state_8800__$1;
(statearr_8859_8922[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (9))){
var inst_8729 = (state_8800[(2)]);
var state_8800__$1 = state_8800;
var statearr_8860_8923 = state_8800__$1;
(statearr_8860_8923[(2)] = inst_8729);

(statearr_8860_8923[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (5))){
var inst_8675 = cljs.core.deref.call(null,cs);
var inst_8676 = cljs.core.seq.call(null,inst_8675);
var inst_8677 = inst_8676;
var inst_8678 = null;
var inst_8679 = (0);
var inst_8680 = (0);
var state_8800__$1 = (function (){var statearr_8861 = state_8800;
(statearr_8861[(13)] = inst_8680);

(statearr_8861[(14)] = inst_8678);

(statearr_8861[(15)] = inst_8677);

(statearr_8861[(16)] = inst_8679);

return statearr_8861;
})();
var statearr_8862_8924 = state_8800__$1;
(statearr_8862_8924[(2)] = null);

(statearr_8862_8924[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (14))){
var state_8800__$1 = state_8800;
var statearr_8863_8925 = state_8800__$1;
(statearr_8863_8925[(2)] = null);

(statearr_8863_8925[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (45))){
var inst_8790 = (state_8800[(2)]);
var state_8800__$1 = state_8800;
var statearr_8864_8926 = state_8800__$1;
(statearr_8864_8926[(2)] = inst_8790);

(statearr_8864_8926[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (26))){
var inst_8732 = (state_8800[(29)]);
var inst_8786 = (state_8800[(2)]);
var inst_8787 = cljs.core.seq.call(null,inst_8732);
var state_8800__$1 = (function (){var statearr_8865 = state_8800;
(statearr_8865[(31)] = inst_8786);

return statearr_8865;
})();
if(inst_8787){
var statearr_8866_8927 = state_8800__$1;
(statearr_8866_8927[(1)] = (42));

} else {
var statearr_8867_8928 = state_8800__$1;
(statearr_8867_8928[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (16))){
var inst_8699 = (state_8800[(7)]);
var inst_8701 = cljs.core.chunked_seq_QMARK_.call(null,inst_8699);
var state_8800__$1 = state_8800;
if(inst_8701){
var statearr_8868_8929 = state_8800__$1;
(statearr_8868_8929[(1)] = (19));

} else {
var statearr_8869_8930 = state_8800__$1;
(statearr_8869_8930[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (38))){
var inst_8779 = (state_8800[(2)]);
var state_8800__$1 = state_8800;
var statearr_8870_8931 = state_8800__$1;
(statearr_8870_8931[(2)] = inst_8779);

(statearr_8870_8931[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (30))){
var state_8800__$1 = state_8800;
var statearr_8871_8932 = state_8800__$1;
(statearr_8871_8932[(2)] = null);

(statearr_8871_8932[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (10))){
var inst_8680 = (state_8800[(13)]);
var inst_8678 = (state_8800[(14)]);
var inst_8688 = cljs.core._nth.call(null,inst_8678,inst_8680);
var inst_8689 = cljs.core.nth.call(null,inst_8688,(0),null);
var inst_8690 = cljs.core.nth.call(null,inst_8688,(1),null);
var state_8800__$1 = (function (){var statearr_8872 = state_8800;
(statearr_8872[(26)] = inst_8689);

return statearr_8872;
})();
if(cljs.core.truth_(inst_8690)){
var statearr_8873_8933 = state_8800__$1;
(statearr_8873_8933[(1)] = (13));

} else {
var statearr_8874_8934 = state_8800__$1;
(statearr_8874_8934[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (18))){
var inst_8725 = (state_8800[(2)]);
var state_8800__$1 = state_8800;
var statearr_8875_8935 = state_8800__$1;
(statearr_8875_8935[(2)] = inst_8725);

(statearr_8875_8935[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (42))){
var state_8800__$1 = state_8800;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8800__$1,(45),dchan);
} else {
if((state_val_8801 === (37))){
var inst_8768 = (state_8800[(23)]);
var inst_8759 = (state_8800[(25)]);
var inst_8668 = (state_8800[(12)]);
var inst_8768__$1 = cljs.core.first.call(null,inst_8759);
var inst_8769 = cljs.core.async.put_BANG_.call(null,inst_8768__$1,inst_8668,done);
var state_8800__$1 = (function (){var statearr_8876 = state_8800;
(statearr_8876[(23)] = inst_8768__$1);

return statearr_8876;
})();
if(cljs.core.truth_(inst_8769)){
var statearr_8877_8936 = state_8800__$1;
(statearr_8877_8936[(1)] = (39));

} else {
var statearr_8878_8937 = state_8800__$1;
(statearr_8878_8937[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8801 === (8))){
var inst_8680 = (state_8800[(13)]);
var inst_8679 = (state_8800[(16)]);
var inst_8682 = (inst_8680 < inst_8679);
var inst_8683 = inst_8682;
var state_8800__$1 = state_8800;
if(cljs.core.truth_(inst_8683)){
var statearr_8879_8938 = state_8800__$1;
(statearr_8879_8938[(1)] = (10));

} else {
var statearr_8880_8939 = state_8800__$1;
(statearr_8880_8939[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6204__auto___8885,cs,m,dchan,dctr,done))
;
return ((function (switch__6037__auto__,c__6204__auto___8885,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__6038__auto__ = null;
var cljs$core$async$mult_$_state_machine__6038__auto____0 = (function (){
var statearr_8881 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_8881[(0)] = cljs$core$async$mult_$_state_machine__6038__auto__);

(statearr_8881[(1)] = (1));

return statearr_8881;
});
var cljs$core$async$mult_$_state_machine__6038__auto____1 = (function (state_8800){
while(true){
var ret_value__6039__auto__ = (function (){try{while(true){
var result__6040__auto__ = switch__6037__auto__.call(null,state_8800);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6040__auto__;
}
break;
}
}catch (e8882){if((e8882 instanceof Object)){
var ex__6041__auto__ = e8882;
var statearr_8883_8940 = state_8800;
(statearr_8883_8940[(5)] = ex__6041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8800);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8882;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8941 = state_8800;
state_8800 = G__8941;
continue;
} else {
return ret_value__6039__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__6038__auto__ = function(state_8800){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__6038__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__6038__auto____1.call(this,state_8800);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__6038__auto____0;
cljs$core$async$mult_$_state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__6038__auto____1;
return cljs$core$async$mult_$_state_machine__6038__auto__;
})()
;})(switch__6037__auto__,c__6204__auto___8885,cs,m,dchan,dctr,done))
})();
var state__6206__auto__ = (function (){var statearr_8884 = f__6205__auto__.call(null);
(statearr_8884[(6)] = c__6204__auto___8885);

return statearr_8884;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6206__auto__);
});})(c__6204__auto___8885,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__8943 = arguments.length;
switch (G__8943) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m);
} else {
var m__4431__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,state_map);
} else {
var m__4431__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,mode);
} else {
var m__4431__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8955 = arguments.length;
var i__4731__auto___8956 = (0);
while(true){
if((i__4731__auto___8956 < len__4730__auto___8955)){
args__4736__auto__.push((arguments[i__4731__auto___8956]));

var G__8957 = (i__4731__auto___8956 + (1));
i__4731__auto___8956 = G__8957;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__8949){
var map__8950 = p__8949;
var map__8950__$1 = (((((!((map__8950 == null))))?(((((map__8950.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8950.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8950):map__8950);
var opts = map__8950__$1;
var statearr_8952_8958 = state;
(statearr_8952_8958[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts.call(null,((function (map__8950,map__8950__$1,opts){
return (function (val){
var statearr_8953_8959 = state;
(statearr_8953_8959[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__8950,map__8950__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_8954_8960 = state;
(statearr_8954_8960[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq8945){
var G__8946 = cljs.core.first.call(null,seq8945);
var seq8945__$1 = cljs.core.next.call(null,seq8945);
var G__8947 = cljs.core.first.call(null,seq8945__$1);
var seq8945__$2 = cljs.core.next.call(null,seq8945__$1);
var G__8948 = cljs.core.first.call(null,seq8945__$2);
var seq8945__$3 = cljs.core.next.call(null,seq8945__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8946,G__8947,G__8948,seq8945__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async8961 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8961 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta8962){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta8962 = meta8962;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async8961.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_8963,meta8962__$1){
var self__ = this;
var _8963__$1 = this;
return (new cljs.core.async.t_cljs$core$async8961(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta8962__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async8961.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_8963){
var self__ = this;
var _8963__$1 = this;
return self__.meta8962;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async8961.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async8961.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async8961.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async8961.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async8961.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async8961.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async8961.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async8961.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async8961.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta8962","meta8962",1802989008,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async8961.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async8961.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8961";

cljs.core.async.t_cljs$core$async8961.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async8961");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async8961.
 */
cljs.core.async.__GT_t_cljs$core$async8961 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async8961(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta8962){
return (new cljs.core.async.t_cljs$core$async8961(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta8962));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async8961(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__6204__auto___9125 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6204__auto___9125,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__6205__auto__ = (function (){var switch__6037__auto__ = ((function (c__6204__auto___9125,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_9065){
var state_val_9066 = (state_9065[(1)]);
if((state_val_9066 === (7))){
var inst_8980 = (state_9065[(2)]);
var state_9065__$1 = state_9065;
var statearr_9067_9126 = state_9065__$1;
(statearr_9067_9126[(2)] = inst_8980);

(statearr_9067_9126[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (20))){
var inst_8992 = (state_9065[(7)]);
var state_9065__$1 = state_9065;
var statearr_9068_9127 = state_9065__$1;
(statearr_9068_9127[(2)] = inst_8992);

(statearr_9068_9127[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (27))){
var state_9065__$1 = state_9065;
var statearr_9069_9128 = state_9065__$1;
(statearr_9069_9128[(2)] = null);

(statearr_9069_9128[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (1))){
var inst_8967 = (state_9065[(8)]);
var inst_8967__$1 = calc_state.call(null);
var inst_8969 = (inst_8967__$1 == null);
var inst_8970 = cljs.core.not.call(null,inst_8969);
var state_9065__$1 = (function (){var statearr_9070 = state_9065;
(statearr_9070[(8)] = inst_8967__$1);

return statearr_9070;
})();
if(inst_8970){
var statearr_9071_9129 = state_9065__$1;
(statearr_9071_9129[(1)] = (2));

} else {
var statearr_9072_9130 = state_9065__$1;
(statearr_9072_9130[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (24))){
var inst_9025 = (state_9065[(9)]);
var inst_9016 = (state_9065[(10)]);
var inst_9039 = (state_9065[(11)]);
var inst_9039__$1 = inst_9016.call(null,inst_9025);
var state_9065__$1 = (function (){var statearr_9073 = state_9065;
(statearr_9073[(11)] = inst_9039__$1);

return statearr_9073;
})();
if(cljs.core.truth_(inst_9039__$1)){
var statearr_9074_9131 = state_9065__$1;
(statearr_9074_9131[(1)] = (29));

} else {
var statearr_9075_9132 = state_9065__$1;
(statearr_9075_9132[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (4))){
var inst_8983 = (state_9065[(2)]);
var state_9065__$1 = state_9065;
if(cljs.core.truth_(inst_8983)){
var statearr_9076_9133 = state_9065__$1;
(statearr_9076_9133[(1)] = (8));

} else {
var statearr_9077_9134 = state_9065__$1;
(statearr_9077_9134[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (15))){
var inst_9010 = (state_9065[(2)]);
var state_9065__$1 = state_9065;
if(cljs.core.truth_(inst_9010)){
var statearr_9078_9135 = state_9065__$1;
(statearr_9078_9135[(1)] = (19));

} else {
var statearr_9079_9136 = state_9065__$1;
(statearr_9079_9136[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (21))){
var inst_9015 = (state_9065[(12)]);
var inst_9015__$1 = (state_9065[(2)]);
var inst_9016 = cljs.core.get.call(null,inst_9015__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_9017 = cljs.core.get.call(null,inst_9015__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_9018 = cljs.core.get.call(null,inst_9015__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_9065__$1 = (function (){var statearr_9080 = state_9065;
(statearr_9080[(13)] = inst_9017);

(statearr_9080[(12)] = inst_9015__$1);

(statearr_9080[(10)] = inst_9016);

return statearr_9080;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_9065__$1,(22),inst_9018);
} else {
if((state_val_9066 === (31))){
var inst_9047 = (state_9065[(2)]);
var state_9065__$1 = state_9065;
if(cljs.core.truth_(inst_9047)){
var statearr_9081_9137 = state_9065__$1;
(statearr_9081_9137[(1)] = (32));

} else {
var statearr_9082_9138 = state_9065__$1;
(statearr_9082_9138[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (32))){
var inst_9024 = (state_9065[(14)]);
var state_9065__$1 = state_9065;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9065__$1,(35),out,inst_9024);
} else {
if((state_val_9066 === (33))){
var inst_9015 = (state_9065[(12)]);
var inst_8992 = inst_9015;
var state_9065__$1 = (function (){var statearr_9083 = state_9065;
(statearr_9083[(7)] = inst_8992);

return statearr_9083;
})();
var statearr_9084_9139 = state_9065__$1;
(statearr_9084_9139[(2)] = null);

(statearr_9084_9139[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (13))){
var inst_8992 = (state_9065[(7)]);
var inst_8999 = inst_8992.cljs$lang$protocol_mask$partition0$;
var inst_9000 = (inst_8999 & (64));
var inst_9001 = inst_8992.cljs$core$ISeq$;
var inst_9002 = (cljs.core.PROTOCOL_SENTINEL === inst_9001);
var inst_9003 = ((inst_9000) || (inst_9002));
var state_9065__$1 = state_9065;
if(cljs.core.truth_(inst_9003)){
var statearr_9085_9140 = state_9065__$1;
(statearr_9085_9140[(1)] = (16));

} else {
var statearr_9086_9141 = state_9065__$1;
(statearr_9086_9141[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (22))){
var inst_9024 = (state_9065[(14)]);
var inst_9025 = (state_9065[(9)]);
var inst_9023 = (state_9065[(2)]);
var inst_9024__$1 = cljs.core.nth.call(null,inst_9023,(0),null);
var inst_9025__$1 = cljs.core.nth.call(null,inst_9023,(1),null);
var inst_9026 = (inst_9024__$1 == null);
var inst_9027 = cljs.core._EQ_.call(null,inst_9025__$1,change);
var inst_9028 = ((inst_9026) || (inst_9027));
var state_9065__$1 = (function (){var statearr_9087 = state_9065;
(statearr_9087[(14)] = inst_9024__$1);

(statearr_9087[(9)] = inst_9025__$1);

return statearr_9087;
})();
if(cljs.core.truth_(inst_9028)){
var statearr_9088_9142 = state_9065__$1;
(statearr_9088_9142[(1)] = (23));

} else {
var statearr_9089_9143 = state_9065__$1;
(statearr_9089_9143[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (36))){
var inst_9015 = (state_9065[(12)]);
var inst_8992 = inst_9015;
var state_9065__$1 = (function (){var statearr_9090 = state_9065;
(statearr_9090[(7)] = inst_8992);

return statearr_9090;
})();
var statearr_9091_9144 = state_9065__$1;
(statearr_9091_9144[(2)] = null);

(statearr_9091_9144[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (29))){
var inst_9039 = (state_9065[(11)]);
var state_9065__$1 = state_9065;
var statearr_9092_9145 = state_9065__$1;
(statearr_9092_9145[(2)] = inst_9039);

(statearr_9092_9145[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (6))){
var state_9065__$1 = state_9065;
var statearr_9093_9146 = state_9065__$1;
(statearr_9093_9146[(2)] = false);

(statearr_9093_9146[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (28))){
var inst_9035 = (state_9065[(2)]);
var inst_9036 = calc_state.call(null);
var inst_8992 = inst_9036;
var state_9065__$1 = (function (){var statearr_9094 = state_9065;
(statearr_9094[(15)] = inst_9035);

(statearr_9094[(7)] = inst_8992);

return statearr_9094;
})();
var statearr_9095_9147 = state_9065__$1;
(statearr_9095_9147[(2)] = null);

(statearr_9095_9147[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (25))){
var inst_9061 = (state_9065[(2)]);
var state_9065__$1 = state_9065;
var statearr_9096_9148 = state_9065__$1;
(statearr_9096_9148[(2)] = inst_9061);

(statearr_9096_9148[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (34))){
var inst_9059 = (state_9065[(2)]);
var state_9065__$1 = state_9065;
var statearr_9097_9149 = state_9065__$1;
(statearr_9097_9149[(2)] = inst_9059);

(statearr_9097_9149[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (17))){
var state_9065__$1 = state_9065;
var statearr_9098_9150 = state_9065__$1;
(statearr_9098_9150[(2)] = false);

(statearr_9098_9150[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (3))){
var state_9065__$1 = state_9065;
var statearr_9099_9151 = state_9065__$1;
(statearr_9099_9151[(2)] = false);

(statearr_9099_9151[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (12))){
var inst_9063 = (state_9065[(2)]);
var state_9065__$1 = state_9065;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9065__$1,inst_9063);
} else {
if((state_val_9066 === (2))){
var inst_8967 = (state_9065[(8)]);
var inst_8972 = inst_8967.cljs$lang$protocol_mask$partition0$;
var inst_8973 = (inst_8972 & (64));
var inst_8974 = inst_8967.cljs$core$ISeq$;
var inst_8975 = (cljs.core.PROTOCOL_SENTINEL === inst_8974);
var inst_8976 = ((inst_8973) || (inst_8975));
var state_9065__$1 = state_9065;
if(cljs.core.truth_(inst_8976)){
var statearr_9100_9152 = state_9065__$1;
(statearr_9100_9152[(1)] = (5));

} else {
var statearr_9101_9153 = state_9065__$1;
(statearr_9101_9153[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (23))){
var inst_9024 = (state_9065[(14)]);
var inst_9030 = (inst_9024 == null);
var state_9065__$1 = state_9065;
if(cljs.core.truth_(inst_9030)){
var statearr_9102_9154 = state_9065__$1;
(statearr_9102_9154[(1)] = (26));

} else {
var statearr_9103_9155 = state_9065__$1;
(statearr_9103_9155[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (35))){
var inst_9050 = (state_9065[(2)]);
var state_9065__$1 = state_9065;
if(cljs.core.truth_(inst_9050)){
var statearr_9104_9156 = state_9065__$1;
(statearr_9104_9156[(1)] = (36));

} else {
var statearr_9105_9157 = state_9065__$1;
(statearr_9105_9157[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (19))){
var inst_8992 = (state_9065[(7)]);
var inst_9012 = cljs.core.apply.call(null,cljs.core.hash_map,inst_8992);
var state_9065__$1 = state_9065;
var statearr_9106_9158 = state_9065__$1;
(statearr_9106_9158[(2)] = inst_9012);

(statearr_9106_9158[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (11))){
var inst_8992 = (state_9065[(7)]);
var inst_8996 = (inst_8992 == null);
var inst_8997 = cljs.core.not.call(null,inst_8996);
var state_9065__$1 = state_9065;
if(inst_8997){
var statearr_9107_9159 = state_9065__$1;
(statearr_9107_9159[(1)] = (13));

} else {
var statearr_9108_9160 = state_9065__$1;
(statearr_9108_9160[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (9))){
var inst_8967 = (state_9065[(8)]);
var state_9065__$1 = state_9065;
var statearr_9109_9161 = state_9065__$1;
(statearr_9109_9161[(2)] = inst_8967);

(statearr_9109_9161[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (5))){
var state_9065__$1 = state_9065;
var statearr_9110_9162 = state_9065__$1;
(statearr_9110_9162[(2)] = true);

(statearr_9110_9162[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (14))){
var state_9065__$1 = state_9065;
var statearr_9111_9163 = state_9065__$1;
(statearr_9111_9163[(2)] = false);

(statearr_9111_9163[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (26))){
var inst_9025 = (state_9065[(9)]);
var inst_9032 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_9025);
var state_9065__$1 = state_9065;
var statearr_9112_9164 = state_9065__$1;
(statearr_9112_9164[(2)] = inst_9032);

(statearr_9112_9164[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (16))){
var state_9065__$1 = state_9065;
var statearr_9113_9165 = state_9065__$1;
(statearr_9113_9165[(2)] = true);

(statearr_9113_9165[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (38))){
var inst_9055 = (state_9065[(2)]);
var state_9065__$1 = state_9065;
var statearr_9114_9166 = state_9065__$1;
(statearr_9114_9166[(2)] = inst_9055);

(statearr_9114_9166[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (30))){
var inst_9017 = (state_9065[(13)]);
var inst_9025 = (state_9065[(9)]);
var inst_9016 = (state_9065[(10)]);
var inst_9042 = cljs.core.empty_QMARK_.call(null,inst_9016);
var inst_9043 = inst_9017.call(null,inst_9025);
var inst_9044 = cljs.core.not.call(null,inst_9043);
var inst_9045 = ((inst_9042) && (inst_9044));
var state_9065__$1 = state_9065;
var statearr_9115_9167 = state_9065__$1;
(statearr_9115_9167[(2)] = inst_9045);

(statearr_9115_9167[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (10))){
var inst_8967 = (state_9065[(8)]);
var inst_8988 = (state_9065[(2)]);
var inst_8989 = cljs.core.get.call(null,inst_8988,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_8990 = cljs.core.get.call(null,inst_8988,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_8991 = cljs.core.get.call(null,inst_8988,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_8992 = inst_8967;
var state_9065__$1 = (function (){var statearr_9116 = state_9065;
(statearr_9116[(16)] = inst_8990);

(statearr_9116[(17)] = inst_8989);

(statearr_9116[(18)] = inst_8991);

(statearr_9116[(7)] = inst_8992);

return statearr_9116;
})();
var statearr_9117_9168 = state_9065__$1;
(statearr_9117_9168[(2)] = null);

(statearr_9117_9168[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (18))){
var inst_9007 = (state_9065[(2)]);
var state_9065__$1 = state_9065;
var statearr_9118_9169 = state_9065__$1;
(statearr_9118_9169[(2)] = inst_9007);

(statearr_9118_9169[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (37))){
var state_9065__$1 = state_9065;
var statearr_9119_9170 = state_9065__$1;
(statearr_9119_9170[(2)] = null);

(statearr_9119_9170[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9066 === (8))){
var inst_8967 = (state_9065[(8)]);
var inst_8985 = cljs.core.apply.call(null,cljs.core.hash_map,inst_8967);
var state_9065__$1 = state_9065;
var statearr_9120_9171 = state_9065__$1;
(statearr_9120_9171[(2)] = inst_8985);

(statearr_9120_9171[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6204__auto___9125,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__6037__auto__,c__6204__auto___9125,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__6038__auto__ = null;
var cljs$core$async$mix_$_state_machine__6038__auto____0 = (function (){
var statearr_9121 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_9121[(0)] = cljs$core$async$mix_$_state_machine__6038__auto__);

(statearr_9121[(1)] = (1));

return statearr_9121;
});
var cljs$core$async$mix_$_state_machine__6038__auto____1 = (function (state_9065){
while(true){
var ret_value__6039__auto__ = (function (){try{while(true){
var result__6040__auto__ = switch__6037__auto__.call(null,state_9065);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6040__auto__;
}
break;
}
}catch (e9122){if((e9122 instanceof Object)){
var ex__6041__auto__ = e9122;
var statearr_9123_9172 = state_9065;
(statearr_9123_9172[(5)] = ex__6041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9065);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9122;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9173 = state_9065;
state_9065 = G__9173;
continue;
} else {
return ret_value__6039__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__6038__auto__ = function(state_9065){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__6038__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__6038__auto____1.call(this,state_9065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__6038__auto____0;
cljs$core$async$mix_$_state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__6038__auto____1;
return cljs$core$async$mix_$_state_machine__6038__auto__;
})()
;})(switch__6037__auto__,c__6204__auto___9125,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__6206__auto__ = (function (){var statearr_9124 = f__6205__auto__.call(null);
(statearr_9124[(6)] = c__6204__auto___9125);

return statearr_9124;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6206__auto__);
});})(c__6204__auto___9125,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4431__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v,ch);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__9175 = arguments.length;
switch (G__9175) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__9179 = arguments.length;
switch (G__9179) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4131__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4131__auto__,mults){
return (function (p1__9177_SHARP_){
if(cljs.core.truth_(p1__9177_SHARP_.call(null,topic))){
return p1__9177_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__9177_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4131__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async9180 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async9180 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta9181){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta9181 = meta9181;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async9180.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_9182,meta9181__$1){
var self__ = this;
var _9182__$1 = this;
return (new cljs.core.async.t_cljs$core$async9180(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta9181__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async9180.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_9182){
var self__ = this;
var _9182__$1 = this;
return self__.meta9181;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async9180.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async9180.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async9180.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async9180.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async9180.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async9180.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async9180.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async9180.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta9181","meta9181",1237140513,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async9180.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async9180.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async9180";

cljs.core.async.t_cljs$core$async9180.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async9180");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async9180.
 */
cljs.core.async.__GT_t_cljs$core$async9180 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async9180(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta9181){
return (new cljs.core.async.t_cljs$core$async9180(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta9181));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async9180(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__6204__auto___9300 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6204__auto___9300,mults,ensure_mult,p){
return (function (){
var f__6205__auto__ = (function (){var switch__6037__auto__ = ((function (c__6204__auto___9300,mults,ensure_mult,p){
return (function (state_9254){
var state_val_9255 = (state_9254[(1)]);
if((state_val_9255 === (7))){
var inst_9250 = (state_9254[(2)]);
var state_9254__$1 = state_9254;
var statearr_9256_9301 = state_9254__$1;
(statearr_9256_9301[(2)] = inst_9250);

(statearr_9256_9301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9255 === (20))){
var state_9254__$1 = state_9254;
var statearr_9257_9302 = state_9254__$1;
(statearr_9257_9302[(2)] = null);

(statearr_9257_9302[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9255 === (1))){
var state_9254__$1 = state_9254;
var statearr_9258_9303 = state_9254__$1;
(statearr_9258_9303[(2)] = null);

(statearr_9258_9303[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9255 === (24))){
var inst_9233 = (state_9254[(7)]);
var inst_9242 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_9233);
var state_9254__$1 = state_9254;
var statearr_9259_9304 = state_9254__$1;
(statearr_9259_9304[(2)] = inst_9242);

(statearr_9259_9304[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9255 === (4))){
var inst_9185 = (state_9254[(8)]);
var inst_9185__$1 = (state_9254[(2)]);
var inst_9186 = (inst_9185__$1 == null);
var state_9254__$1 = (function (){var statearr_9260 = state_9254;
(statearr_9260[(8)] = inst_9185__$1);

return statearr_9260;
})();
if(cljs.core.truth_(inst_9186)){
var statearr_9261_9305 = state_9254__$1;
(statearr_9261_9305[(1)] = (5));

} else {
var statearr_9262_9306 = state_9254__$1;
(statearr_9262_9306[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9255 === (15))){
var inst_9227 = (state_9254[(2)]);
var state_9254__$1 = state_9254;
var statearr_9263_9307 = state_9254__$1;
(statearr_9263_9307[(2)] = inst_9227);

(statearr_9263_9307[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9255 === (21))){
var inst_9247 = (state_9254[(2)]);
var state_9254__$1 = (function (){var statearr_9264 = state_9254;
(statearr_9264[(9)] = inst_9247);

return statearr_9264;
})();
var statearr_9265_9308 = state_9254__$1;
(statearr_9265_9308[(2)] = null);

(statearr_9265_9308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9255 === (13))){
var inst_9209 = (state_9254[(10)]);
var inst_9211 = cljs.core.chunked_seq_QMARK_.call(null,inst_9209);
var state_9254__$1 = state_9254;
if(inst_9211){
var statearr_9266_9309 = state_9254__$1;
(statearr_9266_9309[(1)] = (16));

} else {
var statearr_9267_9310 = state_9254__$1;
(statearr_9267_9310[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9255 === (22))){
var inst_9239 = (state_9254[(2)]);
var state_9254__$1 = state_9254;
if(cljs.core.truth_(inst_9239)){
var statearr_9268_9311 = state_9254__$1;
(statearr_9268_9311[(1)] = (23));

} else {
var statearr_9269_9312 = state_9254__$1;
(statearr_9269_9312[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9255 === (6))){
var inst_9235 = (state_9254[(11)]);
var inst_9185 = (state_9254[(8)]);
var inst_9233 = (state_9254[(7)]);
var inst_9233__$1 = topic_fn.call(null,inst_9185);
var inst_9234 = cljs.core.deref.call(null,mults);
var inst_9235__$1 = cljs.core.get.call(null,inst_9234,inst_9233__$1);
var state_9254__$1 = (function (){var statearr_9270 = state_9254;
(statearr_9270[(11)] = inst_9235__$1);

(statearr_9270[(7)] = inst_9233__$1);

return statearr_9270;
})();
if(cljs.core.truth_(inst_9235__$1)){
var statearr_9271_9313 = state_9254__$1;
(statearr_9271_9313[(1)] = (19));

} else {
var statearr_9272_9314 = state_9254__$1;
(statearr_9272_9314[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9255 === (25))){
var inst_9244 = (state_9254[(2)]);
var state_9254__$1 = state_9254;
var statearr_9273_9315 = state_9254__$1;
(statearr_9273_9315[(2)] = inst_9244);

(statearr_9273_9315[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9255 === (17))){
var inst_9209 = (state_9254[(10)]);
var inst_9218 = cljs.core.first.call(null,inst_9209);
var inst_9219 = cljs.core.async.muxch_STAR_.call(null,inst_9218);
var inst_9220 = cljs.core.async.close_BANG_.call(null,inst_9219);
var inst_9221 = cljs.core.next.call(null,inst_9209);
var inst_9195 = inst_9221;
var inst_9196 = null;
var inst_9197 = (0);
var inst_9198 = (0);
var state_9254__$1 = (function (){var statearr_9274 = state_9254;
(statearr_9274[(12)] = inst_9195);

(statearr_9274[(13)] = inst_9198);

(statearr_9274[(14)] = inst_9196);

(statearr_9274[(15)] = inst_9220);

(statearr_9274[(16)] = inst_9197);

return statearr_9274;
})();
var statearr_9275_9316 = state_9254__$1;
(statearr_9275_9316[(2)] = null);

(statearr_9275_9316[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9255 === (3))){
var inst_9252 = (state_9254[(2)]);
var state_9254__$1 = state_9254;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9254__$1,inst_9252);
} else {
if((state_val_9255 === (12))){
var inst_9229 = (state_9254[(2)]);
var state_9254__$1 = state_9254;
var statearr_9276_9317 = state_9254__$1;
(statearr_9276_9317[(2)] = inst_9229);

(statearr_9276_9317[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9255 === (2))){
var state_9254__$1 = state_9254;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9254__$1,(4),ch);
} else {
if((state_val_9255 === (23))){
var state_9254__$1 = state_9254;
var statearr_9277_9318 = state_9254__$1;
(statearr_9277_9318[(2)] = null);

(statearr_9277_9318[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9255 === (19))){
var inst_9235 = (state_9254[(11)]);
var inst_9185 = (state_9254[(8)]);
var inst_9237 = cljs.core.async.muxch_STAR_.call(null,inst_9235);
var state_9254__$1 = state_9254;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9254__$1,(22),inst_9237,inst_9185);
} else {
if((state_val_9255 === (11))){
var inst_9195 = (state_9254[(12)]);
var inst_9209 = (state_9254[(10)]);
var inst_9209__$1 = cljs.core.seq.call(null,inst_9195);
var state_9254__$1 = (function (){var statearr_9278 = state_9254;
(statearr_9278[(10)] = inst_9209__$1);

return statearr_9278;
})();
if(inst_9209__$1){
var statearr_9279_9319 = state_9254__$1;
(statearr_9279_9319[(1)] = (13));

} else {
var statearr_9280_9320 = state_9254__$1;
(statearr_9280_9320[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9255 === (9))){
var inst_9231 = (state_9254[(2)]);
var state_9254__$1 = state_9254;
var statearr_9281_9321 = state_9254__$1;
(statearr_9281_9321[(2)] = inst_9231);

(statearr_9281_9321[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9255 === (5))){
var inst_9192 = cljs.core.deref.call(null,mults);
var inst_9193 = cljs.core.vals.call(null,inst_9192);
var inst_9194 = cljs.core.seq.call(null,inst_9193);
var inst_9195 = inst_9194;
var inst_9196 = null;
var inst_9197 = (0);
var inst_9198 = (0);
var state_9254__$1 = (function (){var statearr_9282 = state_9254;
(statearr_9282[(12)] = inst_9195);

(statearr_9282[(13)] = inst_9198);

(statearr_9282[(14)] = inst_9196);

(statearr_9282[(16)] = inst_9197);

return statearr_9282;
})();
var statearr_9283_9322 = state_9254__$1;
(statearr_9283_9322[(2)] = null);

(statearr_9283_9322[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9255 === (14))){
var state_9254__$1 = state_9254;
var statearr_9287_9323 = state_9254__$1;
(statearr_9287_9323[(2)] = null);

(statearr_9287_9323[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9255 === (16))){
var inst_9209 = (state_9254[(10)]);
var inst_9213 = cljs.core.chunk_first.call(null,inst_9209);
var inst_9214 = cljs.core.chunk_rest.call(null,inst_9209);
var inst_9215 = cljs.core.count.call(null,inst_9213);
var inst_9195 = inst_9214;
var inst_9196 = inst_9213;
var inst_9197 = inst_9215;
var inst_9198 = (0);
var state_9254__$1 = (function (){var statearr_9288 = state_9254;
(statearr_9288[(12)] = inst_9195);

(statearr_9288[(13)] = inst_9198);

(statearr_9288[(14)] = inst_9196);

(statearr_9288[(16)] = inst_9197);

return statearr_9288;
})();
var statearr_9289_9324 = state_9254__$1;
(statearr_9289_9324[(2)] = null);

(statearr_9289_9324[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9255 === (10))){
var inst_9195 = (state_9254[(12)]);
var inst_9198 = (state_9254[(13)]);
var inst_9196 = (state_9254[(14)]);
var inst_9197 = (state_9254[(16)]);
var inst_9203 = cljs.core._nth.call(null,inst_9196,inst_9198);
var inst_9204 = cljs.core.async.muxch_STAR_.call(null,inst_9203);
var inst_9205 = cljs.core.async.close_BANG_.call(null,inst_9204);
var inst_9206 = (inst_9198 + (1));
var tmp9284 = inst_9195;
var tmp9285 = inst_9196;
var tmp9286 = inst_9197;
var inst_9195__$1 = tmp9284;
var inst_9196__$1 = tmp9285;
var inst_9197__$1 = tmp9286;
var inst_9198__$1 = inst_9206;
var state_9254__$1 = (function (){var statearr_9290 = state_9254;
(statearr_9290[(17)] = inst_9205);

(statearr_9290[(12)] = inst_9195__$1);

(statearr_9290[(13)] = inst_9198__$1);

(statearr_9290[(14)] = inst_9196__$1);

(statearr_9290[(16)] = inst_9197__$1);

return statearr_9290;
})();
var statearr_9291_9325 = state_9254__$1;
(statearr_9291_9325[(2)] = null);

(statearr_9291_9325[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9255 === (18))){
var inst_9224 = (state_9254[(2)]);
var state_9254__$1 = state_9254;
var statearr_9292_9326 = state_9254__$1;
(statearr_9292_9326[(2)] = inst_9224);

(statearr_9292_9326[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9255 === (8))){
var inst_9198 = (state_9254[(13)]);
var inst_9197 = (state_9254[(16)]);
var inst_9200 = (inst_9198 < inst_9197);
var inst_9201 = inst_9200;
var state_9254__$1 = state_9254;
if(cljs.core.truth_(inst_9201)){
var statearr_9293_9327 = state_9254__$1;
(statearr_9293_9327[(1)] = (10));

} else {
var statearr_9294_9328 = state_9254__$1;
(statearr_9294_9328[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6204__auto___9300,mults,ensure_mult,p))
;
return ((function (switch__6037__auto__,c__6204__auto___9300,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__6038__auto__ = null;
var cljs$core$async$state_machine__6038__auto____0 = (function (){
var statearr_9295 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_9295[(0)] = cljs$core$async$state_machine__6038__auto__);

(statearr_9295[(1)] = (1));

return statearr_9295;
});
var cljs$core$async$state_machine__6038__auto____1 = (function (state_9254){
while(true){
var ret_value__6039__auto__ = (function (){try{while(true){
var result__6040__auto__ = switch__6037__auto__.call(null,state_9254);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6040__auto__;
}
break;
}
}catch (e9296){if((e9296 instanceof Object)){
var ex__6041__auto__ = e9296;
var statearr_9297_9329 = state_9254;
(statearr_9297_9329[(5)] = ex__6041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9254);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9296;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9330 = state_9254;
state_9254 = G__9330;
continue;
} else {
return ret_value__6039__auto__;
}
break;
}
});
cljs$core$async$state_machine__6038__auto__ = function(state_9254){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6038__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6038__auto____1.call(this,state_9254);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6038__auto____0;
cljs$core$async$state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6038__auto____1;
return cljs$core$async$state_machine__6038__auto__;
})()
;})(switch__6037__auto__,c__6204__auto___9300,mults,ensure_mult,p))
})();
var state__6206__auto__ = (function (){var statearr_9298 = f__6205__auto__.call(null);
(statearr_9298[(6)] = c__6204__auto___9300);

return statearr_9298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6206__auto__);
});})(c__6204__auto___9300,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__9332 = arguments.length;
switch (G__9332) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__9335 = arguments.length;
switch (G__9335) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__9338 = arguments.length;
switch (G__9338) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__6204__auto___9405 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6204__auto___9405,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__6205__auto__ = (function (){var switch__6037__auto__ = ((function (c__6204__auto___9405,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_9377){
var state_val_9378 = (state_9377[(1)]);
if((state_val_9378 === (7))){
var state_9377__$1 = state_9377;
var statearr_9379_9406 = state_9377__$1;
(statearr_9379_9406[(2)] = null);

(statearr_9379_9406[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9378 === (1))){
var state_9377__$1 = state_9377;
var statearr_9380_9407 = state_9377__$1;
(statearr_9380_9407[(2)] = null);

(statearr_9380_9407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9378 === (4))){
var inst_9341 = (state_9377[(7)]);
var inst_9343 = (inst_9341 < cnt);
var state_9377__$1 = state_9377;
if(cljs.core.truth_(inst_9343)){
var statearr_9381_9408 = state_9377__$1;
(statearr_9381_9408[(1)] = (6));

} else {
var statearr_9382_9409 = state_9377__$1;
(statearr_9382_9409[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9378 === (15))){
var inst_9373 = (state_9377[(2)]);
var state_9377__$1 = state_9377;
var statearr_9383_9410 = state_9377__$1;
(statearr_9383_9410[(2)] = inst_9373);

(statearr_9383_9410[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9378 === (13))){
var inst_9366 = cljs.core.async.close_BANG_.call(null,out);
var state_9377__$1 = state_9377;
var statearr_9384_9411 = state_9377__$1;
(statearr_9384_9411[(2)] = inst_9366);

(statearr_9384_9411[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9378 === (6))){
var state_9377__$1 = state_9377;
var statearr_9385_9412 = state_9377__$1;
(statearr_9385_9412[(2)] = null);

(statearr_9385_9412[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9378 === (3))){
var inst_9375 = (state_9377[(2)]);
var state_9377__$1 = state_9377;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9377__$1,inst_9375);
} else {
if((state_val_9378 === (12))){
var inst_9363 = (state_9377[(8)]);
var inst_9363__$1 = (state_9377[(2)]);
var inst_9364 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_9363__$1);
var state_9377__$1 = (function (){var statearr_9386 = state_9377;
(statearr_9386[(8)] = inst_9363__$1);

return statearr_9386;
})();
if(cljs.core.truth_(inst_9364)){
var statearr_9387_9413 = state_9377__$1;
(statearr_9387_9413[(1)] = (13));

} else {
var statearr_9388_9414 = state_9377__$1;
(statearr_9388_9414[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9378 === (2))){
var inst_9340 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_9341 = (0);
var state_9377__$1 = (function (){var statearr_9389 = state_9377;
(statearr_9389[(9)] = inst_9340);

(statearr_9389[(7)] = inst_9341);

return statearr_9389;
})();
var statearr_9390_9415 = state_9377__$1;
(statearr_9390_9415[(2)] = null);

(statearr_9390_9415[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9378 === (11))){
var inst_9341 = (state_9377[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_9377,(10),Object,null,(9));
var inst_9350 = chs__$1.call(null,inst_9341);
var inst_9351 = done.call(null,inst_9341);
var inst_9352 = cljs.core.async.take_BANG_.call(null,inst_9350,inst_9351);
var state_9377__$1 = state_9377;
var statearr_9391_9416 = state_9377__$1;
(statearr_9391_9416[(2)] = inst_9352);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9377__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9378 === (9))){
var inst_9341 = (state_9377[(7)]);
var inst_9354 = (state_9377[(2)]);
var inst_9355 = (inst_9341 + (1));
var inst_9341__$1 = inst_9355;
var state_9377__$1 = (function (){var statearr_9392 = state_9377;
(statearr_9392[(7)] = inst_9341__$1);

(statearr_9392[(10)] = inst_9354);

return statearr_9392;
})();
var statearr_9393_9417 = state_9377__$1;
(statearr_9393_9417[(2)] = null);

(statearr_9393_9417[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9378 === (5))){
var inst_9361 = (state_9377[(2)]);
var state_9377__$1 = (function (){var statearr_9394 = state_9377;
(statearr_9394[(11)] = inst_9361);

return statearr_9394;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9377__$1,(12),dchan);
} else {
if((state_val_9378 === (14))){
var inst_9363 = (state_9377[(8)]);
var inst_9368 = cljs.core.apply.call(null,f,inst_9363);
var state_9377__$1 = state_9377;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9377__$1,(16),out,inst_9368);
} else {
if((state_val_9378 === (16))){
var inst_9370 = (state_9377[(2)]);
var state_9377__$1 = (function (){var statearr_9395 = state_9377;
(statearr_9395[(12)] = inst_9370);

return statearr_9395;
})();
var statearr_9396_9418 = state_9377__$1;
(statearr_9396_9418[(2)] = null);

(statearr_9396_9418[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9378 === (10))){
var inst_9345 = (state_9377[(2)]);
var inst_9346 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_9377__$1 = (function (){var statearr_9397 = state_9377;
(statearr_9397[(13)] = inst_9345);

return statearr_9397;
})();
var statearr_9398_9419 = state_9377__$1;
(statearr_9398_9419[(2)] = inst_9346);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9377__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9378 === (8))){
var inst_9359 = (state_9377[(2)]);
var state_9377__$1 = state_9377;
var statearr_9399_9420 = state_9377__$1;
(statearr_9399_9420[(2)] = inst_9359);

(statearr_9399_9420[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6204__auto___9405,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__6037__auto__,c__6204__auto___9405,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__6038__auto__ = null;
var cljs$core$async$state_machine__6038__auto____0 = (function (){
var statearr_9400 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_9400[(0)] = cljs$core$async$state_machine__6038__auto__);

(statearr_9400[(1)] = (1));

return statearr_9400;
});
var cljs$core$async$state_machine__6038__auto____1 = (function (state_9377){
while(true){
var ret_value__6039__auto__ = (function (){try{while(true){
var result__6040__auto__ = switch__6037__auto__.call(null,state_9377);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6040__auto__;
}
break;
}
}catch (e9401){if((e9401 instanceof Object)){
var ex__6041__auto__ = e9401;
var statearr_9402_9421 = state_9377;
(statearr_9402_9421[(5)] = ex__6041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9377);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9401;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9422 = state_9377;
state_9377 = G__9422;
continue;
} else {
return ret_value__6039__auto__;
}
break;
}
});
cljs$core$async$state_machine__6038__auto__ = function(state_9377){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6038__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6038__auto____1.call(this,state_9377);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6038__auto____0;
cljs$core$async$state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6038__auto____1;
return cljs$core$async$state_machine__6038__auto__;
})()
;})(switch__6037__auto__,c__6204__auto___9405,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__6206__auto__ = (function (){var statearr_9403 = f__6205__auto__.call(null);
(statearr_9403[(6)] = c__6204__auto___9405);

return statearr_9403;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6206__auto__);
});})(c__6204__auto___9405,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__9425 = arguments.length;
switch (G__9425) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__6204__auto___9479 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6204__auto___9479,out){
return (function (){
var f__6205__auto__ = (function (){var switch__6037__auto__ = ((function (c__6204__auto___9479,out){
return (function (state_9457){
var state_val_9458 = (state_9457[(1)]);
if((state_val_9458 === (7))){
var inst_9436 = (state_9457[(7)]);
var inst_9437 = (state_9457[(8)]);
var inst_9436__$1 = (state_9457[(2)]);
var inst_9437__$1 = cljs.core.nth.call(null,inst_9436__$1,(0),null);
var inst_9438 = cljs.core.nth.call(null,inst_9436__$1,(1),null);
var inst_9439 = (inst_9437__$1 == null);
var state_9457__$1 = (function (){var statearr_9459 = state_9457;
(statearr_9459[(9)] = inst_9438);

(statearr_9459[(7)] = inst_9436__$1);

(statearr_9459[(8)] = inst_9437__$1);

return statearr_9459;
})();
if(cljs.core.truth_(inst_9439)){
var statearr_9460_9480 = state_9457__$1;
(statearr_9460_9480[(1)] = (8));

} else {
var statearr_9461_9481 = state_9457__$1;
(statearr_9461_9481[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9458 === (1))){
var inst_9426 = cljs.core.vec.call(null,chs);
var inst_9427 = inst_9426;
var state_9457__$1 = (function (){var statearr_9462 = state_9457;
(statearr_9462[(10)] = inst_9427);

return statearr_9462;
})();
var statearr_9463_9482 = state_9457__$1;
(statearr_9463_9482[(2)] = null);

(statearr_9463_9482[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9458 === (4))){
var inst_9427 = (state_9457[(10)]);
var state_9457__$1 = state_9457;
return cljs.core.async.ioc_alts_BANG_.call(null,state_9457__$1,(7),inst_9427);
} else {
if((state_val_9458 === (6))){
var inst_9453 = (state_9457[(2)]);
var state_9457__$1 = state_9457;
var statearr_9464_9483 = state_9457__$1;
(statearr_9464_9483[(2)] = inst_9453);

(statearr_9464_9483[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9458 === (3))){
var inst_9455 = (state_9457[(2)]);
var state_9457__$1 = state_9457;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9457__$1,inst_9455);
} else {
if((state_val_9458 === (2))){
var inst_9427 = (state_9457[(10)]);
var inst_9429 = cljs.core.count.call(null,inst_9427);
var inst_9430 = (inst_9429 > (0));
var state_9457__$1 = state_9457;
if(cljs.core.truth_(inst_9430)){
var statearr_9466_9484 = state_9457__$1;
(statearr_9466_9484[(1)] = (4));

} else {
var statearr_9467_9485 = state_9457__$1;
(statearr_9467_9485[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9458 === (11))){
var inst_9427 = (state_9457[(10)]);
var inst_9446 = (state_9457[(2)]);
var tmp9465 = inst_9427;
var inst_9427__$1 = tmp9465;
var state_9457__$1 = (function (){var statearr_9468 = state_9457;
(statearr_9468[(11)] = inst_9446);

(statearr_9468[(10)] = inst_9427__$1);

return statearr_9468;
})();
var statearr_9469_9486 = state_9457__$1;
(statearr_9469_9486[(2)] = null);

(statearr_9469_9486[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9458 === (9))){
var inst_9437 = (state_9457[(8)]);
var state_9457__$1 = state_9457;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9457__$1,(11),out,inst_9437);
} else {
if((state_val_9458 === (5))){
var inst_9451 = cljs.core.async.close_BANG_.call(null,out);
var state_9457__$1 = state_9457;
var statearr_9470_9487 = state_9457__$1;
(statearr_9470_9487[(2)] = inst_9451);

(statearr_9470_9487[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9458 === (10))){
var inst_9449 = (state_9457[(2)]);
var state_9457__$1 = state_9457;
var statearr_9471_9488 = state_9457__$1;
(statearr_9471_9488[(2)] = inst_9449);

(statearr_9471_9488[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9458 === (8))){
var inst_9438 = (state_9457[(9)]);
var inst_9436 = (state_9457[(7)]);
var inst_9437 = (state_9457[(8)]);
var inst_9427 = (state_9457[(10)]);
var inst_9441 = (function (){var cs = inst_9427;
var vec__9432 = inst_9436;
var v = inst_9437;
var c = inst_9438;
return ((function (cs,vec__9432,v,c,inst_9438,inst_9436,inst_9437,inst_9427,state_val_9458,c__6204__auto___9479,out){
return (function (p1__9423_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__9423_SHARP_);
});
;})(cs,vec__9432,v,c,inst_9438,inst_9436,inst_9437,inst_9427,state_val_9458,c__6204__auto___9479,out))
})();
var inst_9442 = cljs.core.filterv.call(null,inst_9441,inst_9427);
var inst_9427__$1 = inst_9442;
var state_9457__$1 = (function (){var statearr_9472 = state_9457;
(statearr_9472[(10)] = inst_9427__$1);

return statearr_9472;
})();
var statearr_9473_9489 = state_9457__$1;
(statearr_9473_9489[(2)] = null);

(statearr_9473_9489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__6204__auto___9479,out))
;
return ((function (switch__6037__auto__,c__6204__auto___9479,out){
return (function() {
var cljs$core$async$state_machine__6038__auto__ = null;
var cljs$core$async$state_machine__6038__auto____0 = (function (){
var statearr_9474 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_9474[(0)] = cljs$core$async$state_machine__6038__auto__);

(statearr_9474[(1)] = (1));

return statearr_9474;
});
var cljs$core$async$state_machine__6038__auto____1 = (function (state_9457){
while(true){
var ret_value__6039__auto__ = (function (){try{while(true){
var result__6040__auto__ = switch__6037__auto__.call(null,state_9457);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6040__auto__;
}
break;
}
}catch (e9475){if((e9475 instanceof Object)){
var ex__6041__auto__ = e9475;
var statearr_9476_9490 = state_9457;
(statearr_9476_9490[(5)] = ex__6041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9457);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9475;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9491 = state_9457;
state_9457 = G__9491;
continue;
} else {
return ret_value__6039__auto__;
}
break;
}
});
cljs$core$async$state_machine__6038__auto__ = function(state_9457){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6038__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6038__auto____1.call(this,state_9457);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6038__auto____0;
cljs$core$async$state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6038__auto____1;
return cljs$core$async$state_machine__6038__auto__;
})()
;})(switch__6037__auto__,c__6204__auto___9479,out))
})();
var state__6206__auto__ = (function (){var statearr_9477 = f__6205__auto__.call(null);
(statearr_9477[(6)] = c__6204__auto___9479);

return statearr_9477;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6206__auto__);
});})(c__6204__auto___9479,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__9493 = arguments.length;
switch (G__9493) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__6204__auto___9538 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6204__auto___9538,out){
return (function (){
var f__6205__auto__ = (function (){var switch__6037__auto__ = ((function (c__6204__auto___9538,out){
return (function (state_9517){
var state_val_9518 = (state_9517[(1)]);
if((state_val_9518 === (7))){
var inst_9499 = (state_9517[(7)]);
var inst_9499__$1 = (state_9517[(2)]);
var inst_9500 = (inst_9499__$1 == null);
var inst_9501 = cljs.core.not.call(null,inst_9500);
var state_9517__$1 = (function (){var statearr_9519 = state_9517;
(statearr_9519[(7)] = inst_9499__$1);

return statearr_9519;
})();
if(inst_9501){
var statearr_9520_9539 = state_9517__$1;
(statearr_9520_9539[(1)] = (8));

} else {
var statearr_9521_9540 = state_9517__$1;
(statearr_9521_9540[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9518 === (1))){
var inst_9494 = (0);
var state_9517__$1 = (function (){var statearr_9522 = state_9517;
(statearr_9522[(8)] = inst_9494);

return statearr_9522;
})();
var statearr_9523_9541 = state_9517__$1;
(statearr_9523_9541[(2)] = null);

(statearr_9523_9541[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9518 === (4))){
var state_9517__$1 = state_9517;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9517__$1,(7),ch);
} else {
if((state_val_9518 === (6))){
var inst_9512 = (state_9517[(2)]);
var state_9517__$1 = state_9517;
var statearr_9524_9542 = state_9517__$1;
(statearr_9524_9542[(2)] = inst_9512);

(statearr_9524_9542[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9518 === (3))){
var inst_9514 = (state_9517[(2)]);
var inst_9515 = cljs.core.async.close_BANG_.call(null,out);
var state_9517__$1 = (function (){var statearr_9525 = state_9517;
(statearr_9525[(9)] = inst_9514);

return statearr_9525;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9517__$1,inst_9515);
} else {
if((state_val_9518 === (2))){
var inst_9494 = (state_9517[(8)]);
var inst_9496 = (inst_9494 < n);
var state_9517__$1 = state_9517;
if(cljs.core.truth_(inst_9496)){
var statearr_9526_9543 = state_9517__$1;
(statearr_9526_9543[(1)] = (4));

} else {
var statearr_9527_9544 = state_9517__$1;
(statearr_9527_9544[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9518 === (11))){
var inst_9494 = (state_9517[(8)]);
var inst_9504 = (state_9517[(2)]);
var inst_9505 = (inst_9494 + (1));
var inst_9494__$1 = inst_9505;
var state_9517__$1 = (function (){var statearr_9528 = state_9517;
(statearr_9528[(10)] = inst_9504);

(statearr_9528[(8)] = inst_9494__$1);

return statearr_9528;
})();
var statearr_9529_9545 = state_9517__$1;
(statearr_9529_9545[(2)] = null);

(statearr_9529_9545[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9518 === (9))){
var state_9517__$1 = state_9517;
var statearr_9530_9546 = state_9517__$1;
(statearr_9530_9546[(2)] = null);

(statearr_9530_9546[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9518 === (5))){
var state_9517__$1 = state_9517;
var statearr_9531_9547 = state_9517__$1;
(statearr_9531_9547[(2)] = null);

(statearr_9531_9547[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9518 === (10))){
var inst_9509 = (state_9517[(2)]);
var state_9517__$1 = state_9517;
var statearr_9532_9548 = state_9517__$1;
(statearr_9532_9548[(2)] = inst_9509);

(statearr_9532_9548[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9518 === (8))){
var inst_9499 = (state_9517[(7)]);
var state_9517__$1 = state_9517;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9517__$1,(11),out,inst_9499);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__6204__auto___9538,out))
;
return ((function (switch__6037__auto__,c__6204__auto___9538,out){
return (function() {
var cljs$core$async$state_machine__6038__auto__ = null;
var cljs$core$async$state_machine__6038__auto____0 = (function (){
var statearr_9533 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_9533[(0)] = cljs$core$async$state_machine__6038__auto__);

(statearr_9533[(1)] = (1));

return statearr_9533;
});
var cljs$core$async$state_machine__6038__auto____1 = (function (state_9517){
while(true){
var ret_value__6039__auto__ = (function (){try{while(true){
var result__6040__auto__ = switch__6037__auto__.call(null,state_9517);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6040__auto__;
}
break;
}
}catch (e9534){if((e9534 instanceof Object)){
var ex__6041__auto__ = e9534;
var statearr_9535_9549 = state_9517;
(statearr_9535_9549[(5)] = ex__6041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9517);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9534;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9550 = state_9517;
state_9517 = G__9550;
continue;
} else {
return ret_value__6039__auto__;
}
break;
}
});
cljs$core$async$state_machine__6038__auto__ = function(state_9517){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6038__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6038__auto____1.call(this,state_9517);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6038__auto____0;
cljs$core$async$state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6038__auto____1;
return cljs$core$async$state_machine__6038__auto__;
})()
;})(switch__6037__auto__,c__6204__auto___9538,out))
})();
var state__6206__auto__ = (function (){var statearr_9536 = f__6205__auto__.call(null);
(statearr_9536[(6)] = c__6204__auto___9538);

return statearr_9536;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6206__auto__);
});})(c__6204__auto___9538,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async9552 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async9552 = (function (f,ch,meta9553){
this.f = f;
this.ch = ch;
this.meta9553 = meta9553;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async9552.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_9554,meta9553__$1){
var self__ = this;
var _9554__$1 = this;
return (new cljs.core.async.t_cljs$core$async9552(self__.f,self__.ch,meta9553__$1));
});

cljs.core.async.t_cljs$core$async9552.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_9554){
var self__ = this;
var _9554__$1 = this;
return self__.meta9553;
});

cljs.core.async.t_cljs$core$async9552.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async9552.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async9552.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async9552.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async9552.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async9555 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async9555 = (function (f,ch,meta9553,_,fn1,meta9556){
this.f = f;
this.ch = ch;
this.meta9553 = meta9553;
this._ = _;
this.fn1 = fn1;
this.meta9556 = meta9556;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async9555.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_9557,meta9556__$1){
var self__ = this;
var _9557__$1 = this;
return (new cljs.core.async.t_cljs$core$async9555(self__.f,self__.ch,self__.meta9553,self__._,self__.fn1,meta9556__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async9555.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_9557){
var self__ = this;
var _9557__$1 = this;
return self__.meta9556;
});})(___$1))
;

cljs.core.async.t_cljs$core$async9555.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async9555.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async9555.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async9555.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__9551_SHARP_){
return f1.call(null,(((p1__9551_SHARP_ == null))?null:self__.f.call(null,p1__9551_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async9555.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta9553","meta9553",-1287736441,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async9552","cljs.core.async/t_cljs$core$async9552",1583335120,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta9556","meta9556",-869112730,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async9555.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async9555.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async9555";

cljs.core.async.t_cljs$core$async9555.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async9555");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async9555.
 */
cljs.core.async.__GT_t_cljs$core$async9555 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async9555(f__$1,ch__$1,meta9553__$1,___$2,fn1__$1,meta9556){
return (new cljs.core.async.t_cljs$core$async9555(f__$1,ch__$1,meta9553__$1,___$2,fn1__$1,meta9556));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async9555(self__.f,self__.ch,self__.meta9553,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4120__auto__ = ret;
if(cljs.core.truth_(and__4120__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4120__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async9552.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async9552.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async9552.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta9553","meta9553",-1287736441,null)], null);
});

cljs.core.async.t_cljs$core$async9552.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async9552.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async9552";

cljs.core.async.t_cljs$core$async9552.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async9552");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async9552.
 */
cljs.core.async.__GT_t_cljs$core$async9552 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async9552(f__$1,ch__$1,meta9553){
return (new cljs.core.async.t_cljs$core$async9552(f__$1,ch__$1,meta9553));
});

}

return (new cljs.core.async.t_cljs$core$async9552(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async9558 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async9558 = (function (f,ch,meta9559){
this.f = f;
this.ch = ch;
this.meta9559 = meta9559;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async9558.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_9560,meta9559__$1){
var self__ = this;
var _9560__$1 = this;
return (new cljs.core.async.t_cljs$core$async9558(self__.f,self__.ch,meta9559__$1));
});

cljs.core.async.t_cljs$core$async9558.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_9560){
var self__ = this;
var _9560__$1 = this;
return self__.meta9559;
});

cljs.core.async.t_cljs$core$async9558.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async9558.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async9558.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async9558.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async9558.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async9558.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async9558.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta9559","meta9559",-592075039,null)], null);
});

cljs.core.async.t_cljs$core$async9558.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async9558.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async9558";

cljs.core.async.t_cljs$core$async9558.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async9558");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async9558.
 */
cljs.core.async.__GT_t_cljs$core$async9558 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async9558(f__$1,ch__$1,meta9559){
return (new cljs.core.async.t_cljs$core$async9558(f__$1,ch__$1,meta9559));
});

}

return (new cljs.core.async.t_cljs$core$async9558(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async9561 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async9561 = (function (p,ch,meta9562){
this.p = p;
this.ch = ch;
this.meta9562 = meta9562;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async9561.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_9563,meta9562__$1){
var self__ = this;
var _9563__$1 = this;
return (new cljs.core.async.t_cljs$core$async9561(self__.p,self__.ch,meta9562__$1));
});

cljs.core.async.t_cljs$core$async9561.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_9563){
var self__ = this;
var _9563__$1 = this;
return self__.meta9562;
});

cljs.core.async.t_cljs$core$async9561.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async9561.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async9561.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async9561.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async9561.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async9561.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async9561.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async9561.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta9562","meta9562",490767698,null)], null);
});

cljs.core.async.t_cljs$core$async9561.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async9561.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async9561";

cljs.core.async.t_cljs$core$async9561.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async9561");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async9561.
 */
cljs.core.async.__GT_t_cljs$core$async9561 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async9561(p__$1,ch__$1,meta9562){
return (new cljs.core.async.t_cljs$core$async9561(p__$1,ch__$1,meta9562));
});

}

return (new cljs.core.async.t_cljs$core$async9561(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__9565 = arguments.length;
switch (G__9565) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__6204__auto___9605 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6204__auto___9605,out){
return (function (){
var f__6205__auto__ = (function (){var switch__6037__auto__ = ((function (c__6204__auto___9605,out){
return (function (state_9586){
var state_val_9587 = (state_9586[(1)]);
if((state_val_9587 === (7))){
var inst_9582 = (state_9586[(2)]);
var state_9586__$1 = state_9586;
var statearr_9588_9606 = state_9586__$1;
(statearr_9588_9606[(2)] = inst_9582);

(statearr_9588_9606[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9587 === (1))){
var state_9586__$1 = state_9586;
var statearr_9589_9607 = state_9586__$1;
(statearr_9589_9607[(2)] = null);

(statearr_9589_9607[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9587 === (4))){
var inst_9568 = (state_9586[(7)]);
var inst_9568__$1 = (state_9586[(2)]);
var inst_9569 = (inst_9568__$1 == null);
var state_9586__$1 = (function (){var statearr_9590 = state_9586;
(statearr_9590[(7)] = inst_9568__$1);

return statearr_9590;
})();
if(cljs.core.truth_(inst_9569)){
var statearr_9591_9608 = state_9586__$1;
(statearr_9591_9608[(1)] = (5));

} else {
var statearr_9592_9609 = state_9586__$1;
(statearr_9592_9609[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9587 === (6))){
var inst_9568 = (state_9586[(7)]);
var inst_9573 = p.call(null,inst_9568);
var state_9586__$1 = state_9586;
if(cljs.core.truth_(inst_9573)){
var statearr_9593_9610 = state_9586__$1;
(statearr_9593_9610[(1)] = (8));

} else {
var statearr_9594_9611 = state_9586__$1;
(statearr_9594_9611[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9587 === (3))){
var inst_9584 = (state_9586[(2)]);
var state_9586__$1 = state_9586;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9586__$1,inst_9584);
} else {
if((state_val_9587 === (2))){
var state_9586__$1 = state_9586;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9586__$1,(4),ch);
} else {
if((state_val_9587 === (11))){
var inst_9576 = (state_9586[(2)]);
var state_9586__$1 = state_9586;
var statearr_9595_9612 = state_9586__$1;
(statearr_9595_9612[(2)] = inst_9576);

(statearr_9595_9612[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9587 === (9))){
var state_9586__$1 = state_9586;
var statearr_9596_9613 = state_9586__$1;
(statearr_9596_9613[(2)] = null);

(statearr_9596_9613[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9587 === (5))){
var inst_9571 = cljs.core.async.close_BANG_.call(null,out);
var state_9586__$1 = state_9586;
var statearr_9597_9614 = state_9586__$1;
(statearr_9597_9614[(2)] = inst_9571);

(statearr_9597_9614[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9587 === (10))){
var inst_9579 = (state_9586[(2)]);
var state_9586__$1 = (function (){var statearr_9598 = state_9586;
(statearr_9598[(8)] = inst_9579);

return statearr_9598;
})();
var statearr_9599_9615 = state_9586__$1;
(statearr_9599_9615[(2)] = null);

(statearr_9599_9615[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9587 === (8))){
var inst_9568 = (state_9586[(7)]);
var state_9586__$1 = state_9586;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9586__$1,(11),out,inst_9568);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__6204__auto___9605,out))
;
return ((function (switch__6037__auto__,c__6204__auto___9605,out){
return (function() {
var cljs$core$async$state_machine__6038__auto__ = null;
var cljs$core$async$state_machine__6038__auto____0 = (function (){
var statearr_9600 = [null,null,null,null,null,null,null,null,null];
(statearr_9600[(0)] = cljs$core$async$state_machine__6038__auto__);

(statearr_9600[(1)] = (1));

return statearr_9600;
});
var cljs$core$async$state_machine__6038__auto____1 = (function (state_9586){
while(true){
var ret_value__6039__auto__ = (function (){try{while(true){
var result__6040__auto__ = switch__6037__auto__.call(null,state_9586);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6040__auto__;
}
break;
}
}catch (e9601){if((e9601 instanceof Object)){
var ex__6041__auto__ = e9601;
var statearr_9602_9616 = state_9586;
(statearr_9602_9616[(5)] = ex__6041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9586);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9601;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9617 = state_9586;
state_9586 = G__9617;
continue;
} else {
return ret_value__6039__auto__;
}
break;
}
});
cljs$core$async$state_machine__6038__auto__ = function(state_9586){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6038__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6038__auto____1.call(this,state_9586);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6038__auto____0;
cljs$core$async$state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6038__auto____1;
return cljs$core$async$state_machine__6038__auto__;
})()
;})(switch__6037__auto__,c__6204__auto___9605,out))
})();
var state__6206__auto__ = (function (){var statearr_9603 = f__6205__auto__.call(null);
(statearr_9603[(6)] = c__6204__auto___9605);

return statearr_9603;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6206__auto__);
});})(c__6204__auto___9605,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__9619 = arguments.length;
switch (G__9619) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__6204__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6204__auto__){
return (function (){
var f__6205__auto__ = (function (){var switch__6037__auto__ = ((function (c__6204__auto__){
return (function (state_9682){
var state_val_9683 = (state_9682[(1)]);
if((state_val_9683 === (7))){
var inst_9678 = (state_9682[(2)]);
var state_9682__$1 = state_9682;
var statearr_9684_9722 = state_9682__$1;
(statearr_9684_9722[(2)] = inst_9678);

(statearr_9684_9722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9683 === (20))){
var inst_9648 = (state_9682[(7)]);
var inst_9659 = (state_9682[(2)]);
var inst_9660 = cljs.core.next.call(null,inst_9648);
var inst_9634 = inst_9660;
var inst_9635 = null;
var inst_9636 = (0);
var inst_9637 = (0);
var state_9682__$1 = (function (){var statearr_9685 = state_9682;
(statearr_9685[(8)] = inst_9637);

(statearr_9685[(9)] = inst_9635);

(statearr_9685[(10)] = inst_9636);

(statearr_9685[(11)] = inst_9634);

(statearr_9685[(12)] = inst_9659);

return statearr_9685;
})();
var statearr_9686_9723 = state_9682__$1;
(statearr_9686_9723[(2)] = null);

(statearr_9686_9723[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9683 === (1))){
var state_9682__$1 = state_9682;
var statearr_9687_9724 = state_9682__$1;
(statearr_9687_9724[(2)] = null);

(statearr_9687_9724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9683 === (4))){
var inst_9623 = (state_9682[(13)]);
var inst_9623__$1 = (state_9682[(2)]);
var inst_9624 = (inst_9623__$1 == null);
var state_9682__$1 = (function (){var statearr_9688 = state_9682;
(statearr_9688[(13)] = inst_9623__$1);

return statearr_9688;
})();
if(cljs.core.truth_(inst_9624)){
var statearr_9689_9725 = state_9682__$1;
(statearr_9689_9725[(1)] = (5));

} else {
var statearr_9690_9726 = state_9682__$1;
(statearr_9690_9726[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9683 === (15))){
var state_9682__$1 = state_9682;
var statearr_9694_9727 = state_9682__$1;
(statearr_9694_9727[(2)] = null);

(statearr_9694_9727[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9683 === (21))){
var state_9682__$1 = state_9682;
var statearr_9695_9728 = state_9682__$1;
(statearr_9695_9728[(2)] = null);

(statearr_9695_9728[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9683 === (13))){
var inst_9637 = (state_9682[(8)]);
var inst_9635 = (state_9682[(9)]);
var inst_9636 = (state_9682[(10)]);
var inst_9634 = (state_9682[(11)]);
var inst_9644 = (state_9682[(2)]);
var inst_9645 = (inst_9637 + (1));
var tmp9691 = inst_9635;
var tmp9692 = inst_9636;
var tmp9693 = inst_9634;
var inst_9634__$1 = tmp9693;
var inst_9635__$1 = tmp9691;
var inst_9636__$1 = tmp9692;
var inst_9637__$1 = inst_9645;
var state_9682__$1 = (function (){var statearr_9696 = state_9682;
(statearr_9696[(8)] = inst_9637__$1);

(statearr_9696[(14)] = inst_9644);

(statearr_9696[(9)] = inst_9635__$1);

(statearr_9696[(10)] = inst_9636__$1);

(statearr_9696[(11)] = inst_9634__$1);

return statearr_9696;
})();
var statearr_9697_9729 = state_9682__$1;
(statearr_9697_9729[(2)] = null);

(statearr_9697_9729[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9683 === (22))){
var state_9682__$1 = state_9682;
var statearr_9698_9730 = state_9682__$1;
(statearr_9698_9730[(2)] = null);

(statearr_9698_9730[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9683 === (6))){
var inst_9623 = (state_9682[(13)]);
var inst_9632 = f.call(null,inst_9623);
var inst_9633 = cljs.core.seq.call(null,inst_9632);
var inst_9634 = inst_9633;
var inst_9635 = null;
var inst_9636 = (0);
var inst_9637 = (0);
var state_9682__$1 = (function (){var statearr_9699 = state_9682;
(statearr_9699[(8)] = inst_9637);

(statearr_9699[(9)] = inst_9635);

(statearr_9699[(10)] = inst_9636);

(statearr_9699[(11)] = inst_9634);

return statearr_9699;
})();
var statearr_9700_9731 = state_9682__$1;
(statearr_9700_9731[(2)] = null);

(statearr_9700_9731[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9683 === (17))){
var inst_9648 = (state_9682[(7)]);
var inst_9652 = cljs.core.chunk_first.call(null,inst_9648);
var inst_9653 = cljs.core.chunk_rest.call(null,inst_9648);
var inst_9654 = cljs.core.count.call(null,inst_9652);
var inst_9634 = inst_9653;
var inst_9635 = inst_9652;
var inst_9636 = inst_9654;
var inst_9637 = (0);
var state_9682__$1 = (function (){var statearr_9701 = state_9682;
(statearr_9701[(8)] = inst_9637);

(statearr_9701[(9)] = inst_9635);

(statearr_9701[(10)] = inst_9636);

(statearr_9701[(11)] = inst_9634);

return statearr_9701;
})();
var statearr_9702_9732 = state_9682__$1;
(statearr_9702_9732[(2)] = null);

(statearr_9702_9732[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9683 === (3))){
var inst_9680 = (state_9682[(2)]);
var state_9682__$1 = state_9682;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9682__$1,inst_9680);
} else {
if((state_val_9683 === (12))){
var inst_9668 = (state_9682[(2)]);
var state_9682__$1 = state_9682;
var statearr_9703_9733 = state_9682__$1;
(statearr_9703_9733[(2)] = inst_9668);

(statearr_9703_9733[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9683 === (2))){
var state_9682__$1 = state_9682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9682__$1,(4),in$);
} else {
if((state_val_9683 === (23))){
var inst_9676 = (state_9682[(2)]);
var state_9682__$1 = state_9682;
var statearr_9704_9734 = state_9682__$1;
(statearr_9704_9734[(2)] = inst_9676);

(statearr_9704_9734[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9683 === (19))){
var inst_9663 = (state_9682[(2)]);
var state_9682__$1 = state_9682;
var statearr_9705_9735 = state_9682__$1;
(statearr_9705_9735[(2)] = inst_9663);

(statearr_9705_9735[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9683 === (11))){
var inst_9648 = (state_9682[(7)]);
var inst_9634 = (state_9682[(11)]);
var inst_9648__$1 = cljs.core.seq.call(null,inst_9634);
var state_9682__$1 = (function (){var statearr_9706 = state_9682;
(statearr_9706[(7)] = inst_9648__$1);

return statearr_9706;
})();
if(inst_9648__$1){
var statearr_9707_9736 = state_9682__$1;
(statearr_9707_9736[(1)] = (14));

} else {
var statearr_9708_9737 = state_9682__$1;
(statearr_9708_9737[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9683 === (9))){
var inst_9670 = (state_9682[(2)]);
var inst_9671 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_9682__$1 = (function (){var statearr_9709 = state_9682;
(statearr_9709[(15)] = inst_9670);

return statearr_9709;
})();
if(cljs.core.truth_(inst_9671)){
var statearr_9710_9738 = state_9682__$1;
(statearr_9710_9738[(1)] = (21));

} else {
var statearr_9711_9739 = state_9682__$1;
(statearr_9711_9739[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9683 === (5))){
var inst_9626 = cljs.core.async.close_BANG_.call(null,out);
var state_9682__$1 = state_9682;
var statearr_9712_9740 = state_9682__$1;
(statearr_9712_9740[(2)] = inst_9626);

(statearr_9712_9740[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9683 === (14))){
var inst_9648 = (state_9682[(7)]);
var inst_9650 = cljs.core.chunked_seq_QMARK_.call(null,inst_9648);
var state_9682__$1 = state_9682;
if(inst_9650){
var statearr_9713_9741 = state_9682__$1;
(statearr_9713_9741[(1)] = (17));

} else {
var statearr_9714_9742 = state_9682__$1;
(statearr_9714_9742[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9683 === (16))){
var inst_9666 = (state_9682[(2)]);
var state_9682__$1 = state_9682;
var statearr_9715_9743 = state_9682__$1;
(statearr_9715_9743[(2)] = inst_9666);

(statearr_9715_9743[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9683 === (10))){
var inst_9637 = (state_9682[(8)]);
var inst_9635 = (state_9682[(9)]);
var inst_9642 = cljs.core._nth.call(null,inst_9635,inst_9637);
var state_9682__$1 = state_9682;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9682__$1,(13),out,inst_9642);
} else {
if((state_val_9683 === (18))){
var inst_9648 = (state_9682[(7)]);
var inst_9657 = cljs.core.first.call(null,inst_9648);
var state_9682__$1 = state_9682;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9682__$1,(20),out,inst_9657);
} else {
if((state_val_9683 === (8))){
var inst_9637 = (state_9682[(8)]);
var inst_9636 = (state_9682[(10)]);
var inst_9639 = (inst_9637 < inst_9636);
var inst_9640 = inst_9639;
var state_9682__$1 = state_9682;
if(cljs.core.truth_(inst_9640)){
var statearr_9716_9744 = state_9682__$1;
(statearr_9716_9744[(1)] = (10));

} else {
var statearr_9717_9745 = state_9682__$1;
(statearr_9717_9745[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6204__auto__))
;
return ((function (switch__6037__auto__,c__6204__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__6038__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__6038__auto____0 = (function (){
var statearr_9718 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_9718[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__6038__auto__);

(statearr_9718[(1)] = (1));

return statearr_9718;
});
var cljs$core$async$mapcat_STAR__$_state_machine__6038__auto____1 = (function (state_9682){
while(true){
var ret_value__6039__auto__ = (function (){try{while(true){
var result__6040__auto__ = switch__6037__auto__.call(null,state_9682);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6040__auto__;
}
break;
}
}catch (e9719){if((e9719 instanceof Object)){
var ex__6041__auto__ = e9719;
var statearr_9720_9746 = state_9682;
(statearr_9720_9746[(5)] = ex__6041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9682);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9719;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9747 = state_9682;
state_9682 = G__9747;
continue;
} else {
return ret_value__6039__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__6038__auto__ = function(state_9682){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__6038__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__6038__auto____1.call(this,state_9682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__6038__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__6038__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__6038__auto__;
})()
;})(switch__6037__auto__,c__6204__auto__))
})();
var state__6206__auto__ = (function (){var statearr_9721 = f__6205__auto__.call(null);
(statearr_9721[(6)] = c__6204__auto__);

return statearr_9721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6206__auto__);
});})(c__6204__auto__))
);

return c__6204__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__9749 = arguments.length;
switch (G__9749) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__9752 = arguments.length;
switch (G__9752) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__9755 = arguments.length;
switch (G__9755) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__6204__auto___9802 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6204__auto___9802,out){
return (function (){
var f__6205__auto__ = (function (){var switch__6037__auto__ = ((function (c__6204__auto___9802,out){
return (function (state_9779){
var state_val_9780 = (state_9779[(1)]);
if((state_val_9780 === (7))){
var inst_9774 = (state_9779[(2)]);
var state_9779__$1 = state_9779;
var statearr_9781_9803 = state_9779__$1;
(statearr_9781_9803[(2)] = inst_9774);

(statearr_9781_9803[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9780 === (1))){
var inst_9756 = null;
var state_9779__$1 = (function (){var statearr_9782 = state_9779;
(statearr_9782[(7)] = inst_9756);

return statearr_9782;
})();
var statearr_9783_9804 = state_9779__$1;
(statearr_9783_9804[(2)] = null);

(statearr_9783_9804[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9780 === (4))){
var inst_9759 = (state_9779[(8)]);
var inst_9759__$1 = (state_9779[(2)]);
var inst_9760 = (inst_9759__$1 == null);
var inst_9761 = cljs.core.not.call(null,inst_9760);
var state_9779__$1 = (function (){var statearr_9784 = state_9779;
(statearr_9784[(8)] = inst_9759__$1);

return statearr_9784;
})();
if(inst_9761){
var statearr_9785_9805 = state_9779__$1;
(statearr_9785_9805[(1)] = (5));

} else {
var statearr_9786_9806 = state_9779__$1;
(statearr_9786_9806[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9780 === (6))){
var state_9779__$1 = state_9779;
var statearr_9787_9807 = state_9779__$1;
(statearr_9787_9807[(2)] = null);

(statearr_9787_9807[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9780 === (3))){
var inst_9776 = (state_9779[(2)]);
var inst_9777 = cljs.core.async.close_BANG_.call(null,out);
var state_9779__$1 = (function (){var statearr_9788 = state_9779;
(statearr_9788[(9)] = inst_9776);

return statearr_9788;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9779__$1,inst_9777);
} else {
if((state_val_9780 === (2))){
var state_9779__$1 = state_9779;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9779__$1,(4),ch);
} else {
if((state_val_9780 === (11))){
var inst_9759 = (state_9779[(8)]);
var inst_9768 = (state_9779[(2)]);
var inst_9756 = inst_9759;
var state_9779__$1 = (function (){var statearr_9789 = state_9779;
(statearr_9789[(7)] = inst_9756);

(statearr_9789[(10)] = inst_9768);

return statearr_9789;
})();
var statearr_9790_9808 = state_9779__$1;
(statearr_9790_9808[(2)] = null);

(statearr_9790_9808[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9780 === (9))){
var inst_9759 = (state_9779[(8)]);
var state_9779__$1 = state_9779;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9779__$1,(11),out,inst_9759);
} else {
if((state_val_9780 === (5))){
var inst_9759 = (state_9779[(8)]);
var inst_9756 = (state_9779[(7)]);
var inst_9763 = cljs.core._EQ_.call(null,inst_9759,inst_9756);
var state_9779__$1 = state_9779;
if(inst_9763){
var statearr_9792_9809 = state_9779__$1;
(statearr_9792_9809[(1)] = (8));

} else {
var statearr_9793_9810 = state_9779__$1;
(statearr_9793_9810[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9780 === (10))){
var inst_9771 = (state_9779[(2)]);
var state_9779__$1 = state_9779;
var statearr_9794_9811 = state_9779__$1;
(statearr_9794_9811[(2)] = inst_9771);

(statearr_9794_9811[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9780 === (8))){
var inst_9756 = (state_9779[(7)]);
var tmp9791 = inst_9756;
var inst_9756__$1 = tmp9791;
var state_9779__$1 = (function (){var statearr_9795 = state_9779;
(statearr_9795[(7)] = inst_9756__$1);

return statearr_9795;
})();
var statearr_9796_9812 = state_9779__$1;
(statearr_9796_9812[(2)] = null);

(statearr_9796_9812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__6204__auto___9802,out))
;
return ((function (switch__6037__auto__,c__6204__auto___9802,out){
return (function() {
var cljs$core$async$state_machine__6038__auto__ = null;
var cljs$core$async$state_machine__6038__auto____0 = (function (){
var statearr_9797 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_9797[(0)] = cljs$core$async$state_machine__6038__auto__);

(statearr_9797[(1)] = (1));

return statearr_9797;
});
var cljs$core$async$state_machine__6038__auto____1 = (function (state_9779){
while(true){
var ret_value__6039__auto__ = (function (){try{while(true){
var result__6040__auto__ = switch__6037__auto__.call(null,state_9779);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6040__auto__;
}
break;
}
}catch (e9798){if((e9798 instanceof Object)){
var ex__6041__auto__ = e9798;
var statearr_9799_9813 = state_9779;
(statearr_9799_9813[(5)] = ex__6041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9779);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9798;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9814 = state_9779;
state_9779 = G__9814;
continue;
} else {
return ret_value__6039__auto__;
}
break;
}
});
cljs$core$async$state_machine__6038__auto__ = function(state_9779){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6038__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6038__auto____1.call(this,state_9779);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6038__auto____0;
cljs$core$async$state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6038__auto____1;
return cljs$core$async$state_machine__6038__auto__;
})()
;})(switch__6037__auto__,c__6204__auto___9802,out))
})();
var state__6206__auto__ = (function (){var statearr_9800 = f__6205__auto__.call(null);
(statearr_9800[(6)] = c__6204__auto___9802);

return statearr_9800;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6206__auto__);
});})(c__6204__auto___9802,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__9816 = arguments.length;
switch (G__9816) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__6204__auto___9882 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6204__auto___9882,out){
return (function (){
var f__6205__auto__ = (function (){var switch__6037__auto__ = ((function (c__6204__auto___9882,out){
return (function (state_9854){
var state_val_9855 = (state_9854[(1)]);
if((state_val_9855 === (7))){
var inst_9850 = (state_9854[(2)]);
var state_9854__$1 = state_9854;
var statearr_9856_9883 = state_9854__$1;
(statearr_9856_9883[(2)] = inst_9850);

(statearr_9856_9883[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9855 === (1))){
var inst_9817 = (new Array(n));
var inst_9818 = inst_9817;
var inst_9819 = (0);
var state_9854__$1 = (function (){var statearr_9857 = state_9854;
(statearr_9857[(7)] = inst_9819);

(statearr_9857[(8)] = inst_9818);

return statearr_9857;
})();
var statearr_9858_9884 = state_9854__$1;
(statearr_9858_9884[(2)] = null);

(statearr_9858_9884[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9855 === (4))){
var inst_9822 = (state_9854[(9)]);
var inst_9822__$1 = (state_9854[(2)]);
var inst_9823 = (inst_9822__$1 == null);
var inst_9824 = cljs.core.not.call(null,inst_9823);
var state_9854__$1 = (function (){var statearr_9859 = state_9854;
(statearr_9859[(9)] = inst_9822__$1);

return statearr_9859;
})();
if(inst_9824){
var statearr_9860_9885 = state_9854__$1;
(statearr_9860_9885[(1)] = (5));

} else {
var statearr_9861_9886 = state_9854__$1;
(statearr_9861_9886[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9855 === (15))){
var inst_9844 = (state_9854[(2)]);
var state_9854__$1 = state_9854;
var statearr_9862_9887 = state_9854__$1;
(statearr_9862_9887[(2)] = inst_9844);

(statearr_9862_9887[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9855 === (13))){
var state_9854__$1 = state_9854;
var statearr_9863_9888 = state_9854__$1;
(statearr_9863_9888[(2)] = null);

(statearr_9863_9888[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9855 === (6))){
var inst_9819 = (state_9854[(7)]);
var inst_9840 = (inst_9819 > (0));
var state_9854__$1 = state_9854;
if(cljs.core.truth_(inst_9840)){
var statearr_9864_9889 = state_9854__$1;
(statearr_9864_9889[(1)] = (12));

} else {
var statearr_9865_9890 = state_9854__$1;
(statearr_9865_9890[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9855 === (3))){
var inst_9852 = (state_9854[(2)]);
var state_9854__$1 = state_9854;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9854__$1,inst_9852);
} else {
if((state_val_9855 === (12))){
var inst_9818 = (state_9854[(8)]);
var inst_9842 = cljs.core.vec.call(null,inst_9818);
var state_9854__$1 = state_9854;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9854__$1,(15),out,inst_9842);
} else {
if((state_val_9855 === (2))){
var state_9854__$1 = state_9854;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9854__$1,(4),ch);
} else {
if((state_val_9855 === (11))){
var inst_9834 = (state_9854[(2)]);
var inst_9835 = (new Array(n));
var inst_9818 = inst_9835;
var inst_9819 = (0);
var state_9854__$1 = (function (){var statearr_9866 = state_9854;
(statearr_9866[(10)] = inst_9834);

(statearr_9866[(7)] = inst_9819);

(statearr_9866[(8)] = inst_9818);

return statearr_9866;
})();
var statearr_9867_9891 = state_9854__$1;
(statearr_9867_9891[(2)] = null);

(statearr_9867_9891[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9855 === (9))){
var inst_9818 = (state_9854[(8)]);
var inst_9832 = cljs.core.vec.call(null,inst_9818);
var state_9854__$1 = state_9854;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9854__$1,(11),out,inst_9832);
} else {
if((state_val_9855 === (5))){
var inst_9827 = (state_9854[(11)]);
var inst_9819 = (state_9854[(7)]);
var inst_9818 = (state_9854[(8)]);
var inst_9822 = (state_9854[(9)]);
var inst_9826 = (inst_9818[inst_9819] = inst_9822);
var inst_9827__$1 = (inst_9819 + (1));
var inst_9828 = (inst_9827__$1 < n);
var state_9854__$1 = (function (){var statearr_9868 = state_9854;
(statearr_9868[(11)] = inst_9827__$1);

(statearr_9868[(12)] = inst_9826);

return statearr_9868;
})();
if(cljs.core.truth_(inst_9828)){
var statearr_9869_9892 = state_9854__$1;
(statearr_9869_9892[(1)] = (8));

} else {
var statearr_9870_9893 = state_9854__$1;
(statearr_9870_9893[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9855 === (14))){
var inst_9847 = (state_9854[(2)]);
var inst_9848 = cljs.core.async.close_BANG_.call(null,out);
var state_9854__$1 = (function (){var statearr_9872 = state_9854;
(statearr_9872[(13)] = inst_9847);

return statearr_9872;
})();
var statearr_9873_9894 = state_9854__$1;
(statearr_9873_9894[(2)] = inst_9848);

(statearr_9873_9894[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9855 === (10))){
var inst_9838 = (state_9854[(2)]);
var state_9854__$1 = state_9854;
var statearr_9874_9895 = state_9854__$1;
(statearr_9874_9895[(2)] = inst_9838);

(statearr_9874_9895[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9855 === (8))){
var inst_9827 = (state_9854[(11)]);
var inst_9818 = (state_9854[(8)]);
var tmp9871 = inst_9818;
var inst_9818__$1 = tmp9871;
var inst_9819 = inst_9827;
var state_9854__$1 = (function (){var statearr_9875 = state_9854;
(statearr_9875[(7)] = inst_9819);

(statearr_9875[(8)] = inst_9818__$1);

return statearr_9875;
})();
var statearr_9876_9896 = state_9854__$1;
(statearr_9876_9896[(2)] = null);

(statearr_9876_9896[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6204__auto___9882,out))
;
return ((function (switch__6037__auto__,c__6204__auto___9882,out){
return (function() {
var cljs$core$async$state_machine__6038__auto__ = null;
var cljs$core$async$state_machine__6038__auto____0 = (function (){
var statearr_9877 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_9877[(0)] = cljs$core$async$state_machine__6038__auto__);

(statearr_9877[(1)] = (1));

return statearr_9877;
});
var cljs$core$async$state_machine__6038__auto____1 = (function (state_9854){
while(true){
var ret_value__6039__auto__ = (function (){try{while(true){
var result__6040__auto__ = switch__6037__auto__.call(null,state_9854);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6040__auto__;
}
break;
}
}catch (e9878){if((e9878 instanceof Object)){
var ex__6041__auto__ = e9878;
var statearr_9879_9897 = state_9854;
(statearr_9879_9897[(5)] = ex__6041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9854);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9878;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9898 = state_9854;
state_9854 = G__9898;
continue;
} else {
return ret_value__6039__auto__;
}
break;
}
});
cljs$core$async$state_machine__6038__auto__ = function(state_9854){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6038__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6038__auto____1.call(this,state_9854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6038__auto____0;
cljs$core$async$state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6038__auto____1;
return cljs$core$async$state_machine__6038__auto__;
})()
;})(switch__6037__auto__,c__6204__auto___9882,out))
})();
var state__6206__auto__ = (function (){var statearr_9880 = f__6205__auto__.call(null);
(statearr_9880[(6)] = c__6204__auto___9882);

return statearr_9880;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6206__auto__);
});})(c__6204__auto___9882,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__9900 = arguments.length;
switch (G__9900) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__6204__auto___9970 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6204__auto___9970,out){
return (function (){
var f__6205__auto__ = (function (){var switch__6037__auto__ = ((function (c__6204__auto___9970,out){
return (function (state_9942){
var state_val_9943 = (state_9942[(1)]);
if((state_val_9943 === (7))){
var inst_9938 = (state_9942[(2)]);
var state_9942__$1 = state_9942;
var statearr_9944_9971 = state_9942__$1;
(statearr_9944_9971[(2)] = inst_9938);

(statearr_9944_9971[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9943 === (1))){
var inst_9901 = [];
var inst_9902 = inst_9901;
var inst_9903 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_9942__$1 = (function (){var statearr_9945 = state_9942;
(statearr_9945[(7)] = inst_9902);

(statearr_9945[(8)] = inst_9903);

return statearr_9945;
})();
var statearr_9946_9972 = state_9942__$1;
(statearr_9946_9972[(2)] = null);

(statearr_9946_9972[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9943 === (4))){
var inst_9906 = (state_9942[(9)]);
var inst_9906__$1 = (state_9942[(2)]);
var inst_9907 = (inst_9906__$1 == null);
var inst_9908 = cljs.core.not.call(null,inst_9907);
var state_9942__$1 = (function (){var statearr_9947 = state_9942;
(statearr_9947[(9)] = inst_9906__$1);

return statearr_9947;
})();
if(inst_9908){
var statearr_9948_9973 = state_9942__$1;
(statearr_9948_9973[(1)] = (5));

} else {
var statearr_9949_9974 = state_9942__$1;
(statearr_9949_9974[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9943 === (15))){
var inst_9932 = (state_9942[(2)]);
var state_9942__$1 = state_9942;
var statearr_9950_9975 = state_9942__$1;
(statearr_9950_9975[(2)] = inst_9932);

(statearr_9950_9975[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9943 === (13))){
var state_9942__$1 = state_9942;
var statearr_9951_9976 = state_9942__$1;
(statearr_9951_9976[(2)] = null);

(statearr_9951_9976[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9943 === (6))){
var inst_9902 = (state_9942[(7)]);
var inst_9927 = inst_9902.length;
var inst_9928 = (inst_9927 > (0));
var state_9942__$1 = state_9942;
if(cljs.core.truth_(inst_9928)){
var statearr_9952_9977 = state_9942__$1;
(statearr_9952_9977[(1)] = (12));

} else {
var statearr_9953_9978 = state_9942__$1;
(statearr_9953_9978[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9943 === (3))){
var inst_9940 = (state_9942[(2)]);
var state_9942__$1 = state_9942;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9942__$1,inst_9940);
} else {
if((state_val_9943 === (12))){
var inst_9902 = (state_9942[(7)]);
var inst_9930 = cljs.core.vec.call(null,inst_9902);
var state_9942__$1 = state_9942;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9942__$1,(15),out,inst_9930);
} else {
if((state_val_9943 === (2))){
var state_9942__$1 = state_9942;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9942__$1,(4),ch);
} else {
if((state_val_9943 === (11))){
var inst_9906 = (state_9942[(9)]);
var inst_9910 = (state_9942[(10)]);
var inst_9920 = (state_9942[(2)]);
var inst_9921 = [];
var inst_9922 = inst_9921.push(inst_9906);
var inst_9902 = inst_9921;
var inst_9903 = inst_9910;
var state_9942__$1 = (function (){var statearr_9954 = state_9942;
(statearr_9954[(7)] = inst_9902);

(statearr_9954[(11)] = inst_9920);

(statearr_9954[(12)] = inst_9922);

(statearr_9954[(8)] = inst_9903);

return statearr_9954;
})();
var statearr_9955_9979 = state_9942__$1;
(statearr_9955_9979[(2)] = null);

(statearr_9955_9979[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9943 === (9))){
var inst_9902 = (state_9942[(7)]);
var inst_9918 = cljs.core.vec.call(null,inst_9902);
var state_9942__$1 = state_9942;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9942__$1,(11),out,inst_9918);
} else {
if((state_val_9943 === (5))){
var inst_9906 = (state_9942[(9)]);
var inst_9910 = (state_9942[(10)]);
var inst_9903 = (state_9942[(8)]);
var inst_9910__$1 = f.call(null,inst_9906);
var inst_9911 = cljs.core._EQ_.call(null,inst_9910__$1,inst_9903);
var inst_9912 = cljs.core.keyword_identical_QMARK_.call(null,inst_9903,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_9913 = ((inst_9911) || (inst_9912));
var state_9942__$1 = (function (){var statearr_9956 = state_9942;
(statearr_9956[(10)] = inst_9910__$1);

return statearr_9956;
})();
if(cljs.core.truth_(inst_9913)){
var statearr_9957_9980 = state_9942__$1;
(statearr_9957_9980[(1)] = (8));

} else {
var statearr_9958_9981 = state_9942__$1;
(statearr_9958_9981[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9943 === (14))){
var inst_9935 = (state_9942[(2)]);
var inst_9936 = cljs.core.async.close_BANG_.call(null,out);
var state_9942__$1 = (function (){var statearr_9960 = state_9942;
(statearr_9960[(13)] = inst_9935);

return statearr_9960;
})();
var statearr_9961_9982 = state_9942__$1;
(statearr_9961_9982[(2)] = inst_9936);

(statearr_9961_9982[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9943 === (10))){
var inst_9925 = (state_9942[(2)]);
var state_9942__$1 = state_9942;
var statearr_9962_9983 = state_9942__$1;
(statearr_9962_9983[(2)] = inst_9925);

(statearr_9962_9983[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9943 === (8))){
var inst_9902 = (state_9942[(7)]);
var inst_9906 = (state_9942[(9)]);
var inst_9910 = (state_9942[(10)]);
var inst_9915 = inst_9902.push(inst_9906);
var tmp9959 = inst_9902;
var inst_9902__$1 = tmp9959;
var inst_9903 = inst_9910;
var state_9942__$1 = (function (){var statearr_9963 = state_9942;
(statearr_9963[(7)] = inst_9902__$1);

(statearr_9963[(14)] = inst_9915);

(statearr_9963[(8)] = inst_9903);

return statearr_9963;
})();
var statearr_9964_9984 = state_9942__$1;
(statearr_9964_9984[(2)] = null);

(statearr_9964_9984[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6204__auto___9970,out))
;
return ((function (switch__6037__auto__,c__6204__auto___9970,out){
return (function() {
var cljs$core$async$state_machine__6038__auto__ = null;
var cljs$core$async$state_machine__6038__auto____0 = (function (){
var statearr_9965 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_9965[(0)] = cljs$core$async$state_machine__6038__auto__);

(statearr_9965[(1)] = (1));

return statearr_9965;
});
var cljs$core$async$state_machine__6038__auto____1 = (function (state_9942){
while(true){
var ret_value__6039__auto__ = (function (){try{while(true){
var result__6040__auto__ = switch__6037__auto__.call(null,state_9942);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6040__auto__;
}
break;
}
}catch (e9966){if((e9966 instanceof Object)){
var ex__6041__auto__ = e9966;
var statearr_9967_9985 = state_9942;
(statearr_9967_9985[(5)] = ex__6041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9942);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9966;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9986 = state_9942;
state_9942 = G__9986;
continue;
} else {
return ret_value__6039__auto__;
}
break;
}
});
cljs$core$async$state_machine__6038__auto__ = function(state_9942){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6038__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6038__auto____1.call(this,state_9942);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6038__auto____0;
cljs$core$async$state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6038__auto____1;
return cljs$core$async$state_machine__6038__auto__;
})()
;})(switch__6037__auto__,c__6204__auto___9970,out))
})();
var state__6206__auto__ = (function (){var statearr_9968 = f__6205__auto__.call(null);
(statearr_9968[(6)] = c__6204__auto___9970);

return statearr_9968;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6206__auto__);
});})(c__6204__auto___9970,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map
