// Compiled by ClojureScript 1.10.520 {}
goog.provide('imcljs.fetch');
goog.require('cljs.core');
goog.require('imcljs.internal.io');
goog.require('imcljs.query');
goog.require('cljs.core.async');
/**
 * Returns quicksearch results.
 */
imcljs.fetch.quicksearch = (function imcljs$fetch$quicksearch(var_args){
var args__4736__auto__ = [];
var len__4730__auto___11974 = arguments.length;
var i__4731__auto___11975 = (0);
while(true){
if((i__4731__auto___11975 < len__4730__auto___11974)){
args__4736__auto__.push((arguments[i__4731__auto___11975]));

var G__11976 = (i__4731__auto___11975 + (1));
i__4731__auto___11975 = G__11976;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.quicksearch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.quicksearch.cljs$core$IFn$_invoke$arity$variadic = (function (service,search_term,p__11970){
var vec__11971 = p__11970;
var options = cljs.core.nth.call(null,vec__11971,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/search",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"q","q",689001697),search_term], null),options));
});

imcljs.fetch.quicksearch.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.quicksearch.cljs$lang$applyTo = (function (seq11967){
var G__11968 = cljs.core.first.call(null,seq11967);
var seq11967__$1 = cljs.core.next.call(null,seq11967);
var G__11969 = cljs.core.first.call(null,seq11967__$1);
var seq11967__$2 = cljs.core.next.call(null,seq11967__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11968,G__11969,seq11967__$2);
});

imcljs.fetch.table_rows = (function imcljs$fetch$table_rows(var_args){
var args__4736__auto__ = [];
var len__4730__auto___11984 = arguments.length;
var i__4731__auto___11985 = (0);
while(true){
if((i__4731__auto___11985 < len__4730__auto___11984)){
args__4736__auto__.push((arguments[i__4731__auto___11985]));

var G__11986 = (i__4731__auto___11985 + (1));
i__4731__auto___11985 = G__11986;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.table_rows.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.table_rows.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__11980){
var vec__11981 = p__11980;
var options = cljs.core.nth.call(null,vec__11981,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results/tablerows",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query","query",-1288509510),query], null),options));
});

imcljs.fetch.table_rows.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.table_rows.cljs$lang$applyTo = (function (seq11977){
var G__11978 = cljs.core.first.call(null,seq11977);
var seq11977__$1 = cljs.core.next.call(null,seq11977);
var G__11979 = cljs.core.first.call(null,seq11977__$1);
var seq11977__$2 = cljs.core.next.call(null,seq11977__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11978,G__11979,seq11977__$2);
});

imcljs.fetch.fasta = (function imcljs$fetch$fasta(var_args){
var args__4736__auto__ = [];
var len__4730__auto___11994 = arguments.length;
var i__4731__auto___11995 = (0);
while(true){
if((i__4731__auto___11995 < len__4730__auto___11994)){
args__4736__auto__.push((arguments[i__4731__auto___11995]));

var G__11996 = (i__4731__auto___11995 + (1));
i__4731__auto___11995 = G__11996;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.fasta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.fasta.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__11990){
var vec__11991 = p__11990;
var options = cljs.core.nth.call(null,vec__11991,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results/fasta",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query","query",-1288509510),query], null),options));
});

imcljs.fetch.fasta.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.fasta.cljs$lang$applyTo = (function (seq11987){
var G__11988 = cljs.core.first.call(null,seq11987);
var seq11987__$1 = cljs.core.next.call(null,seq11987);
var G__11989 = cljs.core.first.call(null,seq11987__$1);
var seq11987__$2 = cljs.core.next.call(null,seq11987__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11988,G__11989,seq11987__$2);
});

imcljs.fetch.fetch_custom_format = (function imcljs$fetch$fetch_custom_format(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12004 = arguments.length;
var i__4731__auto___12005 = (0);
while(true){
if((i__4731__auto___12005 < len__4730__auto___12004)){
args__4736__auto__.push((arguments[i__4731__auto___12005]));

var G__12006 = (i__4731__auto___12005 + (1));
i__4731__auto___12005 = G__12006;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.fetch_custom_format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.fetch_custom_format.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__12000){
var vec__12001 = p__12000;
var options = cljs.core.nth.call(null,vec__12001,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query","query",-1288509510),query], null),options));
});

imcljs.fetch.fetch_custom_format.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.fetch_custom_format.cljs$lang$applyTo = (function (seq11997){
var G__11998 = cljs.core.first.call(null,seq11997);
var seq11997__$1 = cljs.core.next.call(null,seq11997);
var G__11999 = cljs.core.first.call(null,seq11997__$1);
var seq11997__$2 = cljs.core.next.call(null,seq11997__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11998,G__11999,seq11997__$2);
});

imcljs.fetch.records = (function imcljs$fetch$records(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12014 = arguments.length;
var i__4731__auto___12015 = (0);
while(true){
if((i__4731__auto___12015 < len__4730__auto___12014)){
args__4736__auto__.push((arguments[i__4731__auto___12015]));

var G__12016 = (i__4731__auto___12015 + (1));
i__4731__auto___12015 = G__12016;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.records.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.records.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__12010){
var vec__12011 = p__12010;
var options = cljs.core.nth.call(null,vec__12011,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"jsonobjects"], null),options));
});

imcljs.fetch.records.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.records.cljs$lang$applyTo = (function (seq12007){
var G__12008 = cljs.core.first.call(null,seq12007);
var seq12007__$1 = cljs.core.next.call(null,seq12007);
var G__12009 = cljs.core.first.call(null,seq12007__$1);
var seq12007__$2 = cljs.core.next.call(null,seq12007__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12008,G__12009,seq12007__$2);
});

imcljs.fetch.rows = (function imcljs$fetch$rows(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12024 = arguments.length;
var i__4731__auto___12025 = (0);
while(true){
if((i__4731__auto___12025 < len__4730__auto___12024)){
args__4736__auto__.push((arguments[i__4731__auto___12025]));

var G__12026 = (i__4731__auto___12025 + (1));
i__4731__auto___12025 = G__12026;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.rows.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.rows.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__12020){
var vec__12021 = p__12020;
var options = cljs.core.nth.call(null,vec__12021,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.fetch.rows.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.rows.cljs$lang$applyTo = (function (seq12017){
var G__12018 = cljs.core.first.call(null,seq12017);
var seq12017__$1 = cljs.core.next.call(null,seq12017);
var G__12019 = cljs.core.first.call(null,seq12017__$1);
var seq12017__$2 = cljs.core.next.call(null,seq12017__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12018,G__12019,seq12017__$2);
});

imcljs.fetch.row_count = (function imcljs$fetch$row_count(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12034 = arguments.length;
var i__4731__auto___12035 = (0);
while(true){
if((i__4731__auto___12035 < len__4730__auto___12034)){
args__4736__auto__.push((arguments[i__4731__auto___12035]));

var G__12036 = (i__4731__auto___12035 + (1));
i__4731__auto___12035 = G__12036;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.row_count.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.row_count.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__12030){
var vec__12031 = p__12030;
var options = cljs.core.nth.call(null,vec__12031,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"count"], null),options));
});

imcljs.fetch.row_count.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.row_count.cljs$lang$applyTo = (function (seq12027){
var G__12028 = cljs.core.first.call(null,seq12027);
var seq12027__$1 = cljs.core.next.call(null,seq12027);
var G__12029 = cljs.core.first.call(null,seq12027__$1);
var seq12027__$2 = cljs.core.next.call(null,seq12027__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12028,G__12029,seq12027__$2);
});

imcljs.fetch.possible_values = (function imcljs$fetch$possible_values(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12044 = arguments.length;
var i__4731__auto___12045 = (0);
while(true){
if((i__4731__auto___12045 < len__4730__auto___12044)){
args__4736__auto__.push((arguments[i__4731__auto___12045]));

var G__12046 = (i__4731__auto___12045 + (1));
i__4731__auto___12045 = G__12046;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.possible_values.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.possible_values.cljs$core$IFn$_invoke$arity$variadic = (function (service,path,p__12040){
var vec__12041 = p__12040;
var options = cljs.core.nth.call(null,vec__12041,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/path/values",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),path,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.fetch.possible_values.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.possible_values.cljs$lang$applyTo = (function (seq12037){
var G__12038 = cljs.core.first.call(null,seq12037);
var seq12037__$1 = cljs.core.next.call(null,seq12037);
var G__12039 = cljs.core.first.call(null,seq12037__$1);
var seq12037__$2 = cljs.core.next.call(null,seq12037__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12038,G__12039,seq12037__$2);
});

/**
 * Fetches unique values for a path within a query. Providing a limit shortcircuits the request
 *   and returns false if the unique values exceed the limit. This is primarily for the column
 *   summary in im-tables-3, where we don't want to summarize columns with more than limit=1000
 *   values, so we avoid sending the massive request here instead.
 */
imcljs.fetch.unique_values = (function imcljs$fetch$unique_values(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12140 = arguments.length;
var i__4731__auto___12141 = (0);
while(true){
if((i__4731__auto___12141 < len__4730__auto___12140)){
args__4736__auto__.push((arguments[i__4731__auto___12141]));

var G__12142 = (i__4731__auto___12141 + (1));
i__4731__auto___12141 = G__12142;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.fetch.unique_values.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.fetch.unique_values.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,path,p__12052){
var vec__12053 = p__12052;
var limit = cljs.core.nth.call(null,vec__12053,(0),null);
var return_chan = cljs.core.async.chan.call(null);
var rows_size = ((function (return_chan,vec__12053,limit){
return (function (p1__12047_SHARP_){
return imcljs.fetch.rows.call(null,service,query,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"summaryPath","summaryPath",599411983),path,new cljs.core.Keyword(null,"size","size",1098693007),p1__12047_SHARP_,new cljs.core.Keyword(null,"format","format",-1306924766),"jsonrows"], null));
});})(return_chan,vec__12053,limit))
;
var c__6204__auto___12143 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6204__auto___12143,return_chan,rows_size,vec__12053,limit){
return (function (){
var f__6205__auto__ = (function (){var switch__6037__auto__ = ((function (c__6204__auto___12143,return_chan,rows_size,vec__12053,limit){
return (function (state_12108){
var state_val_12109 = (state_12108[(1)]);
if((state_val_12109 === (7))){
var state_12108__$1 = state_12108;
var statearr_12110_12144 = state_12108__$1;
(statearr_12110_12144[(2)] = false);

(statearr_12110_12144[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12109 === (20))){
var inst_12093 = (state_12108[(2)]);
var state_12108__$1 = state_12108;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12108__$1,(19),return_chan,inst_12093);
} else {
if((state_val_12109 === (1))){
var inst_12057 = rows_size.call(null,(1));
var state_12108__$1 = state_12108;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12108__$1,(2),inst_12057);
} else {
if((state_val_12109 === (24))){
var inst_12099 = (state_12108[(2)]);
var state_12108__$1 = state_12108;
var statearr_12111_12145 = state_12108__$1;
(statearr_12111_12145[(2)] = inst_12099);

(statearr_12111_12145[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12109 === (4))){
var state_12108__$1 = state_12108;
var statearr_12112_12146 = state_12108__$1;
(statearr_12112_12146[(2)] = false);

(statearr_12112_12146[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12109 === (15))){
var inst_12085 = (state_12108[(2)]);
var state_12108__$1 = state_12108;
var statearr_12113_12147 = state_12108__$1;
(statearr_12113_12147[(2)] = inst_12085);

(statearr_12113_12147[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12109 === (21))){
var state_12108__$1 = state_12108;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12108__$1,(24),return_chan,false);
} else {
if((state_val_12109 === (13))){
var inst_12081 = (state_12108[(7)]);
var inst_12087 = cljs.core.not.call(null,limit);
var inst_12088 = (inst_12081 <= limit);
var inst_12089 = ((inst_12087) || (inst_12088));
var state_12108__$1 = state_12108;
if(cljs.core.truth_(inst_12089)){
var statearr_12114_12148 = state_12108__$1;
(statearr_12114_12148[(1)] = (16));

} else {
var statearr_12115_12149 = state_12108__$1;
(statearr_12115_12149[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12109 === (22))){
var state_12108__$1 = state_12108;
var statearr_12116_12150 = state_12108__$1;
(statearr_12116_12150[(2)] = null);

(statearr_12116_12150[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12109 === (6))){
var state_12108__$1 = state_12108;
var statearr_12117_12151 = state_12108__$1;
(statearr_12117_12151[(2)] = true);

(statearr_12117_12151[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12109 === (17))){
var state_12108__$1 = state_12108;
var statearr_12118_12152 = state_12108__$1;
(statearr_12118_12152[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12109 === (3))){
var inst_12059 = (state_12108[(8)]);
var inst_12064 = inst_12059.cljs$lang$protocol_mask$partition0$;
var inst_12065 = (inst_12064 & (64));
var inst_12066 = inst_12059.cljs$core$ISeq$;
var inst_12067 = (cljs.core.PROTOCOL_SENTINEL === inst_12066);
var inst_12068 = ((inst_12065) || (inst_12067));
var state_12108__$1 = state_12108;
if(cljs.core.truth_(inst_12068)){
var statearr_12120_12153 = state_12108__$1;
(statearr_12120_12153[(1)] = (6));

} else {
var statearr_12121_12154 = state_12108__$1;
(statearr_12121_12154[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12109 === (12))){
var inst_12080 = (state_12108[(9)]);
var state_12108__$1 = state_12108;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12108__$1,(15),return_chan,inst_12080);
} else {
if((state_val_12109 === (2))){
var inst_12059 = (state_12108[(8)]);
var inst_12059__$1 = (state_12108[(2)]);
var inst_12061 = (inst_12059__$1 == null);
var inst_12062 = cljs.core.not.call(null,inst_12061);
var state_12108__$1 = (function (){var statearr_12122 = state_12108;
(statearr_12122[(8)] = inst_12059__$1);

return statearr_12122;
})();
if(inst_12062){
var statearr_12123_12155 = state_12108__$1;
(statearr_12123_12155[(1)] = (3));

} else {
var statearr_12124_12156 = state_12108__$1;
(statearr_12124_12156[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12109 === (23))){
var inst_12102 = (state_12108[(2)]);
var state_12108__$1 = state_12108;
var statearr_12125_12157 = state_12108__$1;
(statearr_12125_12157[(2)] = inst_12102);

(statearr_12125_12157[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12109 === (19))){
var inst_12095 = (state_12108[(2)]);
var state_12108__$1 = state_12108;
var statearr_12126_12158 = state_12108__$1;
(statearr_12126_12158[(2)] = inst_12095);

(statearr_12126_12158[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12109 === (11))){
var inst_12081 = (state_12108[(7)]);
var inst_12080 = (state_12108[(9)]);
var inst_12080__$1 = (state_12108[(2)]);
var inst_12081__$1 = cljs.core.get.call(null,inst_12080__$1,new cljs.core.Keyword(null,"uniqueValues","uniqueValues",1661070646));
var inst_12082 = cljs.core._EQ_.call(null,inst_12081__$1,(1));
var state_12108__$1 = (function (){var statearr_12127 = state_12108;
(statearr_12127[(7)] = inst_12081__$1);

(statearr_12127[(9)] = inst_12080__$1);

return statearr_12127;
})();
if(inst_12082){
var statearr_12128_12159 = state_12108__$1;
(statearr_12128_12159[(1)] = (12));

} else {
var statearr_12129_12160 = state_12108__$1;
(statearr_12129_12160[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12109 === (9))){
var inst_12059 = (state_12108[(8)]);
var inst_12077 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12059);
var state_12108__$1 = state_12108;
var statearr_12130_12161 = state_12108__$1;
(statearr_12130_12161[(2)] = inst_12077);

(statearr_12130_12161[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12109 === (5))){
var inst_12075 = (state_12108[(2)]);
var state_12108__$1 = state_12108;
if(cljs.core.truth_(inst_12075)){
var statearr_12131_12162 = state_12108__$1;
(statearr_12131_12162[(1)] = (9));

} else {
var statearr_12132_12163 = state_12108__$1;
(statearr_12132_12163[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12109 === (14))){
var inst_12106 = (state_12108[(2)]);
var state_12108__$1 = state_12108;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12108__$1,inst_12106);
} else {
if((state_val_12109 === (16))){
var inst_12091 = rows_size.call(null,limit);
var state_12108__$1 = state_12108;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12108__$1,(20),inst_12091);
} else {
if((state_val_12109 === (10))){
var inst_12059 = (state_12108[(8)]);
var state_12108__$1 = state_12108;
var statearr_12133_12164 = state_12108__$1;
(statearr_12133_12164[(2)] = inst_12059);

(statearr_12133_12164[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12109 === (18))){
var inst_12104 = (state_12108[(2)]);
var state_12108__$1 = state_12108;
var statearr_12134_12165 = state_12108__$1;
(statearr_12134_12165[(2)] = inst_12104);

(statearr_12134_12165[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12109 === (8))){
var inst_12072 = (state_12108[(2)]);
var state_12108__$1 = state_12108;
var statearr_12135_12166 = state_12108__$1;
(statearr_12135_12166[(2)] = inst_12072);

(statearr_12135_12166[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6204__auto___12143,return_chan,rows_size,vec__12053,limit))
;
return ((function (switch__6037__auto__,c__6204__auto___12143,return_chan,rows_size,vec__12053,limit){
return (function() {
var imcljs$fetch$state_machine__6038__auto__ = null;
var imcljs$fetch$state_machine__6038__auto____0 = (function (){
var statearr_12136 = [null,null,null,null,null,null,null,null,null,null];
(statearr_12136[(0)] = imcljs$fetch$state_machine__6038__auto__);

(statearr_12136[(1)] = (1));

return statearr_12136;
});
var imcljs$fetch$state_machine__6038__auto____1 = (function (state_12108){
while(true){
var ret_value__6039__auto__ = (function (){try{while(true){
var result__6040__auto__ = switch__6037__auto__.call(null,state_12108);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6040__auto__;
}
break;
}
}catch (e12137){if((e12137 instanceof Object)){
var ex__6041__auto__ = e12137;
var statearr_12138_12167 = state_12108;
(statearr_12138_12167[(5)] = ex__6041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12108);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12137;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12168 = state_12108;
state_12108 = G__12168;
continue;
} else {
return ret_value__6039__auto__;
}
break;
}
});
imcljs$fetch$state_machine__6038__auto__ = function(state_12108){
switch(arguments.length){
case 0:
return imcljs$fetch$state_machine__6038__auto____0.call(this);
case 1:
return imcljs$fetch$state_machine__6038__auto____1.call(this,state_12108);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
imcljs$fetch$state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$fetch$state_machine__6038__auto____0;
imcljs$fetch$state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$fetch$state_machine__6038__auto____1;
return imcljs$fetch$state_machine__6038__auto__;
})()
;})(switch__6037__auto__,c__6204__auto___12143,return_chan,rows_size,vec__12053,limit))
})();
var state__6206__auto__ = (function (){var statearr_12139 = f__6205__auto__.call(null);
(statearr_12139[(6)] = c__6204__auto___12143);

return statearr_12139;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6206__auto__);
});})(c__6204__auto___12143,return_chan,rows_size,vec__12053,limit))
);


return return_chan;
});

imcljs.fetch.unique_values.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.fetch.unique_values.cljs$lang$applyTo = (function (seq12048){
var G__12049 = cljs.core.first.call(null,seq12048);
var seq12048__$1 = cljs.core.next.call(null,seq12048);
var G__12050 = cljs.core.first.call(null,seq12048__$1);
var seq12048__$2 = cljs.core.next.call(null,seq12048__$1);
var G__12051 = cljs.core.first.call(null,seq12048__$2);
var seq12048__$3 = cljs.core.next.call(null,seq12048__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12049,G__12050,G__12051,seq12048__$3);
});

imcljs.fetch.lists = (function imcljs$fetch$lists(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12175 = arguments.length;
var i__4731__auto___12176 = (0);
while(true){
if((i__4731__auto___12176 < len__4730__auto___12175)){
args__4736__auto__.push((arguments[i__4731__auto___12176]));

var G__12177 = (i__4731__auto___12176 + (1));
i__4731__auto___12176 = G__12177;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.lists.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.lists.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__12171){
var vec__12172 = p__12171;
var options = cljs.core.nth.call(null,vec__12172,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/lists",service,options,new cljs.core.Keyword(null,"lists","lists",-884730684));
});

imcljs.fetch.lists.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.lists.cljs$lang$applyTo = (function (seq12169){
var G__12170 = cljs.core.first.call(null,seq12169);
var seq12169__$1 = cljs.core.next.call(null,seq12169);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12170,seq12169__$1);
});

imcljs.fetch.one_list = (function imcljs$fetch$one_list(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12185 = arguments.length;
var i__4731__auto___12186 = (0);
while(true){
if((i__4731__auto___12186 < len__4730__auto___12185)){
args__4736__auto__.push((arguments[i__4731__auto___12186]));

var G__12187 = (i__4731__auto___12186 + (1));
i__4731__auto___12186 = G__12187;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.one_list.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.one_list.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,p__12181){
var vec__12182 = p__12181;
var options = cljs.core.nth.call(null,vec__12182,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/lists",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),name], null),options),cljs.core.comp.call(null,cljs.core.first,new cljs.core.Keyword(null,"lists","lists",-884730684)));
});

imcljs.fetch.one_list.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.one_list.cljs$lang$applyTo = (function (seq12178){
var G__12179 = cljs.core.first.call(null,seq12178);
var seq12178__$1 = cljs.core.next.call(null,seq12178);
var G__12180 = cljs.core.first.call(null,seq12178__$1);
var seq12178__$2 = cljs.core.next.call(null,seq12178__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12179,G__12180,seq12178__$2);
});

imcljs.fetch.model = (function imcljs$fetch$model(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12194 = arguments.length;
var i__4731__auto___12195 = (0);
while(true){
if((i__4731__auto___12195 < len__4730__auto___12194)){
args__4736__auto__.push((arguments[i__4731__auto___12195]));

var G__12196 = (i__4731__auto___12195 + (1));
i__4731__auto___12195 = G__12196;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.model.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.model.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__12190){
var vec__12191 = p__12190;
var options = cljs.core.nth.call(null,vec__12191,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/model",service,options,new cljs.core.Keyword(null,"model","model",331153215));
});

imcljs.fetch.model.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.model.cljs$lang$applyTo = (function (seq12188){
var G__12189 = cljs.core.first.call(null,seq12188);
var seq12188__$1 = cljs.core.next.call(null,seq12188);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12189,seq12188__$1);
});

imcljs.fetch.class_keys = (function imcljs$fetch$class_keys(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12203 = arguments.length;
var i__4731__auto___12204 = (0);
while(true){
if((i__4731__auto___12204 < len__4730__auto___12203)){
args__4736__auto__.push((arguments[i__4731__auto___12204]));

var G__12205 = (i__4731__auto___12204 + (1));
i__4731__auto___12204 = G__12205;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.class_keys.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.class_keys.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__12199){
var vec__12200 = p__12199;
var options = cljs.core.nth.call(null,vec__12200,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/classkeys",service,options,new cljs.core.Keyword(null,"classes","classes",2037804510));
});

imcljs.fetch.class_keys.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.class_keys.cljs$lang$applyTo = (function (seq12197){
var G__12198 = cljs.core.first.call(null,seq12197);
var seq12197__$1 = cljs.core.next.call(null,seq12197);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12198,seq12197__$1);
});

imcljs.fetch.summary_fields = (function imcljs$fetch$summary_fields(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12212 = arguments.length;
var i__4731__auto___12213 = (0);
while(true){
if((i__4731__auto___12213 < len__4730__auto___12212)){
args__4736__auto__.push((arguments[i__4731__auto___12213]));

var G__12214 = (i__4731__auto___12213 + (1));
i__4731__auto___12213 = G__12214;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.summary_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.summary_fields.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__12208){
var vec__12209 = p__12208;
var options = cljs.core.nth.call(null,vec__12209,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/summaryfields",service,options,new cljs.core.Keyword(null,"classes","classes",2037804510));
});

imcljs.fetch.summary_fields.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.summary_fields.cljs$lang$applyTo = (function (seq12206){
var G__12207 = cljs.core.first.call(null,seq12206);
var seq12206__$1 = cljs.core.next.call(null,seq12206);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12207,seq12206__$1);
});

imcljs.fetch.templates = (function imcljs$fetch$templates(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12221 = arguments.length;
var i__4731__auto___12222 = (0);
while(true){
if((i__4731__auto___12222 < len__4730__auto___12221)){
args__4736__auto__.push((arguments[i__4731__auto___12222]));

var G__12223 = (i__4731__auto___12222 + (1));
i__4731__auto___12222 = G__12223;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.templates.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.templates.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__12217){
var vec__12218 = p__12217;
var options = cljs.core.nth.call(null,vec__12218,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/templates",service,options,new cljs.core.Keyword(null,"templates","templates",-1237401733));
});

imcljs.fetch.templates.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.templates.cljs$lang$applyTo = (function (seq12215){
var G__12216 = cljs.core.first.call(null,seq12215);
var seq12215__$1 = cljs.core.next.call(null,seq12215);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12216,seq12215__$1);
});

/**
 * Returns a temporary API token.
 */
imcljs.fetch.session = (function imcljs$fetch$session(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12230 = arguments.length;
var i__4731__auto___12231 = (0);
while(true){
if((i__4731__auto___12231 < len__4730__auto___12230)){
args__4736__auto__.push((arguments[i__4731__auto___12231]));

var G__12232 = (i__4731__auto___12231 + (1));
i__4731__auto___12231 = G__12232;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.session.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.session.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__12226){
var vec__12227 = p__12226;
var options = cljs.core.nth.call(null,vec__12227,(0),null);
var token_free_service = cljs.core.dissoc.call(null,service,new cljs.core.Keyword(null,"token","token",-1211463215));
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/session",token_free_service,options,new cljs.core.Keyword(null,"token","token",-1211463215));
});

imcljs.fetch.session.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.session.cljs$lang$applyTo = (function (seq12224){
var G__12225 = cljs.core.first.call(null,seq12224);
var seq12224__$1 = cljs.core.next.call(null,seq12224);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12225,seq12224__$1);
});

/**
 * Returns list of widgets available for a given mine
 */
imcljs.fetch.widgets = (function imcljs$fetch$widgets(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12239 = arguments.length;
var i__4731__auto___12240 = (0);
while(true){
if((i__4731__auto___12240 < len__4730__auto___12239)){
args__4736__auto__.push((arguments[i__4731__auto___12240]));

var G__12241 = (i__4731__auto___12240 + (1));
i__4731__auto___12240 = G__12241;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.widgets.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.widgets.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__12235){
var vec__12236 = p__12235;
var options = cljs.core.nth.call(null,vec__12236,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/widgets",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),new cljs.core.Keyword(null,"widgets","widgets",-159098978));
});

imcljs.fetch.widgets.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.widgets.cljs$lang$applyTo = (function (seq12233){
var G__12234 = cljs.core.first.call(null,seq12233);
var seq12233__$1 = cljs.core.next.call(null,seq12233);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12234,seq12233__$1);
});

/**
 * Returns enrichment results
 */
imcljs.fetch.enrichment = (function imcljs$fetch$enrichment(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12248 = arguments.length;
var i__4731__auto___12249 = (0);
while(true){
if((i__4731__auto___12249 < len__4730__auto___12248)){
args__4736__auto__.push((arguments[i__4731__auto___12249]));

var G__12250 = (i__4731__auto___12249 + (1));
i__4731__auto___12249 = G__12250;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.enrichment.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.enrichment.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__12244){
var vec__12245 = p__12244;
var options = cljs.core.nth.call(null,vec__12245,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/list/enrichment",service,cljs.core.merge.call(null,imcljs.internal.defaults.default_enrichment,options));
});

imcljs.fetch.enrichment.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.enrichment.cljs$lang$applyTo = (function (seq12242){
var G__12243 = cljs.core.first.call(null,seq12242);
var seq12242__$1 = cljs.core.next.call(null,seq12242);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12243,seq12242__$1);
});

/**
 * Returns the version of the InterMine WebService being run, e.g. '27'
 */
imcljs.fetch.version_web_service = (function imcljs$fetch$version_web_service(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/version",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"text"], null));
});
imcljs.fetch.version_release = (function imcljs$fetch$version_release(service){

return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/version/release",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"text"], null));
});
/**
 * Returns the version of InterMine being run, e.g. '1.6.6'
 */
imcljs.fetch.version_intermine = (function imcljs$fetch$version_intermine(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/version/intermine",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"text"], null));
});
/**
 * Returns the default configs for a given mine. These are important as they're
 * used to initialise most bluegenes page sections! 
 */
imcljs.fetch.web_properties = (function imcljs$fetch$web_properties(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/web-properties",service,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"web-properties","web-properties",-1421911737));
});
/**
 * Fetches the results of an id resolution job
 */
imcljs.fetch.fetch_id_resolution_job_results = (function imcljs$fetch$fetch_id_resolution_job_results(service,uid){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),["/ids/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(uid),"/results"].join(''),service,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"results","results",-1134170113));
});
/**
 * Fetches the status of an id resolution job
 */
imcljs.fetch.fetch_id_resolution_job_status = (function imcljs$fetch$fetch_id_resolution_job_status(service,uid){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),["/ids/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(uid),"/status"].join(''),service,cljs.core.PersistentArrayMap.EMPTY);
});
/**
 * Starts an id resolution job
 */
imcljs.fetch.fetch_id_resolution_job = (function imcljs$fetch$fetch_id_resolution_job(service,p__12251){
var map__12252 = p__12251;
var map__12252__$1 = (((((!((map__12252 == null))))?(((((map__12252.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12252.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12252):map__12252);
var options = map__12252__$1;
var identifiers = cljs.core.get.call(null,map__12252__$1,new cljs.core.Keyword(null,"identifiers","identifiers",-2057597722));
var type = cljs.core.get.call(null,map__12252__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var case_sensitive = cljs.core.get.call(null,map__12252__$1,new cljs.core.Keyword(null,"case-sensitive","case-sensitive",-1005239404));
var wild_cards = cljs.core.get.call(null,map__12252__$1,new cljs.core.Keyword(null,"wild-cards","wild-cards",681119344));
var extra = cljs.core.get.call(null,map__12252__$1,new cljs.core.Keyword(null,"extra","extra",1612569067));
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post-body","post-body",-1481559189),"/ids",service,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"body","body",-2049205669),(function (){var G__12254 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"identifiers","identifiers",-2057597722),identifiers], null);
var G__12254__$1 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__12254,new cljs.core.Keyword(null,"type","type",1174270348),type):G__12254);
var G__12254__$2 = (cljs.core.truth_(case_sensitive)?cljs.core.assoc.call(null,G__12254__$1,new cljs.core.Keyword(null,"caseSensitive","caseSensitive",-586669673),true):G__12254__$1);
var G__12254__$3 = (cljs.core.truth_(wild_cards)?cljs.core.assoc.call(null,G__12254__$2,new cljs.core.Keyword(null,"wildCards","wildCards",-2054689560),true):G__12254__$2);
if(cljs.core.truth_(extra)){
return cljs.core.assoc.call(null,G__12254__$3,new cljs.core.Keyword(null,"extra","extra",1612569067),extra);
} else {
return G__12254__$3;
}
})(),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null)], null));
});
/**
 * Resolves identifiers. Automatically handles polling
 */
imcljs.fetch.resolve_identifiers = (function imcljs$fetch$resolve_identifiers(service,p__12255){
var map__12256 = p__12255;
var map__12256__$1 = (((((!((map__12256 == null))))?(((((map__12256.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12256.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12256):map__12256);
var options = map__12256__$1;
var timeout_ms = cljs.core.get.call(null,map__12256__$1,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406));
var return_chan = cljs.core.async.chan.call(null,(1));
var c__6204__auto___12409 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6204__auto___12409,return_chan,map__12256,map__12256__$1,options,timeout_ms){
return (function (){
var f__6205__auto__ = (function (){var switch__6037__auto__ = ((function (c__6204__auto___12409,return_chan,map__12256,map__12256__$1,options,timeout_ms){
return (function (state_12351){
var state_val_12352 = (state_12351[(1)]);
if((state_val_12352 === (7))){
var state_12351__$1 = state_12351;
var statearr_12353_12410 = state_12351__$1;
(statearr_12353_12410[(2)] = false);

(statearr_12353_12410[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (20))){
var inst_12308 = (state_12351[(2)]);
var state_12351__$1 = state_12351;
if(cljs.core.truth_(inst_12308)){
var statearr_12354_12411 = state_12351__$1;
(statearr_12354_12411[(1)] = (24));

} else {
var statearr_12355_12412 = state_12351__$1;
(statearr_12355_12412[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (27))){
var inst_12342 = (state_12351[(2)]);
var state_12351__$1 = state_12351;
var statearr_12356_12413 = state_12351__$1;
(statearr_12356_12413[(2)] = inst_12342);

(statearr_12356_12413[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (1))){
var inst_12259 = imcljs.fetch.fetch_id_resolution_job.call(null,service,options);
var state_12351__$1 = state_12351;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12351__$1,(2),inst_12259);
} else {
if((state_val_12352 === (24))){
var inst_12292 = (state_12351[(7)]);
var inst_12310 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12292);
var state_12351__$1 = state_12351;
var statearr_12357_12414 = state_12351__$1;
(statearr_12357_12414[(2)] = inst_12310);

(statearr_12357_12414[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (39))){
var inst_12313 = (state_12351[(8)]);
var state_12351__$1 = state_12351;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12351__$1,(40),return_chan,inst_12313);
} else {
if((state_val_12352 === (4))){
var state_12351__$1 = state_12351;
var statearr_12358_12415 = state_12351__$1;
(statearr_12358_12415[(2)] = false);

(statearr_12358_12415[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (15))){
var inst_12283 = (state_12351[(9)]);
var inst_12290 = imcljs.fetch.fetch_id_resolution_job_status.call(null,service,inst_12283);
var state_12351__$1 = state_12351;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12351__$1,(17),inst_12290);
} else {
if((state_val_12352 === (21))){
var state_12351__$1 = state_12351;
var statearr_12359_12416 = state_12351__$1;
(statearr_12359_12416[(2)] = true);

(statearr_12359_12416[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (31))){
var inst_12286 = (state_12351[(10)]);
var inst_12321 = cljs.core.async.timeout.call(null,inst_12286);
var state_12351__$1 = state_12351;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12351__$1,(32),inst_12321);
} else {
if((state_val_12352 === (32))){
var inst_12323 = (state_12351[(2)]);
var state_12351__$1 = (function (){var statearr_12360 = state_12351;
(statearr_12360[(11)] = inst_12323);

return statearr_12360;
})();
if(cljs.core.truth_(timeout_ms)){
var statearr_12361_12417 = state_12351__$1;
(statearr_12361_12417[(1)] = (33));

} else {
var statearr_12362_12418 = state_12351__$1;
(statearr_12362_12418[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (40))){
var inst_12339 = (state_12351[(2)]);
var state_12351__$1 = state_12351;
var statearr_12363_12419 = state_12351__$1;
(statearr_12363_12419[(2)] = inst_12339);

(statearr_12363_12419[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (33))){
var state_12351__$1 = state_12351;
var statearr_12364_12420 = state_12351__$1;
(statearr_12364_12420[(2)] = timeout_ms);

(statearr_12364_12420[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (13))){
var inst_12282 = (state_12351[(12)]);
var state_12351__$1 = state_12351;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12351__$1,(41),return_chan,inst_12282);
} else {
if((state_val_12352 === (22))){
var state_12351__$1 = state_12351;
var statearr_12365_12421 = state_12351__$1;
(statearr_12365_12421[(2)] = false);

(statearr_12365_12421[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (36))){
var inst_12286 = (state_12351[(10)]);
var inst_12287 = (state_12351[(13)]);
var inst_12330 = (inst_12286 * 1.5);
var inst_12331 = (((1000) < inst_12330) ? (1000) : inst_12330);
var inst_12332 = (inst_12287 + inst_12286);
var inst_12286__$1 = inst_12331;
var inst_12287__$1 = inst_12332;
var state_12351__$1 = (function (){var statearr_12366 = state_12351;
(statearr_12366[(10)] = inst_12286__$1);

(statearr_12366[(13)] = inst_12287__$1);

return statearr_12366;
})();
var statearr_12367_12422 = state_12351__$1;
(statearr_12367_12422[(2)] = null);

(statearr_12367_12422[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (41))){
var inst_12347 = (state_12351[(2)]);
var state_12351__$1 = state_12351;
var statearr_12368_12423 = state_12351__$1;
(statearr_12368_12423[(2)] = inst_12347);

(statearr_12368_12423[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (29))){
var inst_12317 = (state_12351[(2)]);
var state_12351__$1 = state_12351;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12351__$1,(30),return_chan,inst_12317);
} else {
if((state_val_12352 === (6))){
var state_12351__$1 = state_12351;
var statearr_12369_12424 = state_12351__$1;
(statearr_12369_12424[(2)] = true);

(statearr_12369_12424[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (28))){
var inst_12283 = (state_12351[(9)]);
var inst_12315 = imcljs.fetch.fetch_id_resolution_job_results.call(null,service,inst_12283);
var state_12351__$1 = state_12351;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12351__$1,(29),inst_12315);
} else {
if((state_val_12352 === (25))){
var inst_12292 = (state_12351[(7)]);
var state_12351__$1 = state_12351;
var statearr_12370_12425 = state_12351__$1;
(statearr_12370_12425[(2)] = inst_12292);

(statearr_12370_12425[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (34))){
var state_12351__$1 = state_12351;
var statearr_12371_12426 = state_12351__$1;
(statearr_12371_12426[(2)] = (30000));

(statearr_12371_12426[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (17))){
var inst_12292 = (state_12351[(7)]);
var inst_12292__$1 = (state_12351[(2)]);
var inst_12294 = (inst_12292__$1 == null);
var inst_12295 = cljs.core.not.call(null,inst_12294);
var state_12351__$1 = (function (){var statearr_12372 = state_12351;
(statearr_12372[(7)] = inst_12292__$1);

return statearr_12372;
})();
if(inst_12295){
var statearr_12373_12427 = state_12351__$1;
(statearr_12373_12427[(1)] = (18));

} else {
var statearr_12374_12428 = state_12351__$1;
(statearr_12374_12428[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (3))){
var inst_12261 = (state_12351[(14)]);
var inst_12266 = inst_12261.cljs$lang$protocol_mask$partition0$;
var inst_12267 = (inst_12266 & (64));
var inst_12268 = inst_12261.cljs$core$ISeq$;
var inst_12269 = (cljs.core.PROTOCOL_SENTINEL === inst_12268);
var inst_12270 = ((inst_12267) || (inst_12269));
var state_12351__$1 = state_12351;
if(cljs.core.truth_(inst_12270)){
var statearr_12375_12429 = state_12351__$1;
(statearr_12375_12429[(1)] = (6));

} else {
var statearr_12376_12430 = state_12351__$1;
(statearr_12376_12430[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (12))){
var inst_12286 = (100);
var inst_12287 = (0);
var state_12351__$1 = (function (){var statearr_12377 = state_12351;
(statearr_12377[(10)] = inst_12286);

(statearr_12377[(13)] = inst_12287);

return statearr_12377;
})();
var statearr_12378_12431 = state_12351__$1;
(statearr_12378_12431[(2)] = null);

(statearr_12378_12431[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (2))){
var inst_12261 = (state_12351[(14)]);
var inst_12261__$1 = (state_12351[(2)]);
var inst_12263 = (inst_12261__$1 == null);
var inst_12264 = cljs.core.not.call(null,inst_12263);
var state_12351__$1 = (function (){var statearr_12379 = state_12351;
(statearr_12379[(14)] = inst_12261__$1);

return statearr_12379;
})();
if(inst_12264){
var statearr_12380_12432 = state_12351__$1;
(statearr_12380_12432[(1)] = (3));

} else {
var statearr_12381_12433 = state_12351__$1;
(statearr_12381_12433[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (23))){
var inst_12305 = (state_12351[(2)]);
var state_12351__$1 = state_12351;
var statearr_12382_12434 = state_12351__$1;
(statearr_12382_12434[(2)] = inst_12305);

(statearr_12382_12434[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (35))){
var inst_12287 = (state_12351[(13)]);
var inst_12327 = (state_12351[(2)]);
var inst_12328 = (inst_12287 < inst_12327);
var state_12351__$1 = state_12351;
if(cljs.core.truth_(inst_12328)){
var statearr_12383_12435 = state_12351__$1;
(statearr_12383_12435[(1)] = (36));

} else {
var statearr_12384_12436 = state_12351__$1;
(statearr_12384_12436[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (19))){
var state_12351__$1 = state_12351;
var statearr_12385_12437 = state_12351__$1;
(statearr_12385_12437[(2)] = false);

(statearr_12385_12437[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (11))){
var inst_12282 = (state_12351[(12)]);
var inst_12283 = (state_12351[(9)]);
var inst_12282__$1 = (state_12351[(2)]);
var inst_12283__$1 = cljs.core.get.call(null,inst_12282__$1,new cljs.core.Keyword(null,"uid","uid",-1447769400));
var inst_12284 = cljs.core.not_empty.call(null,inst_12283__$1);
var state_12351__$1 = (function (){var statearr_12386 = state_12351;
(statearr_12386[(12)] = inst_12282__$1);

(statearr_12386[(9)] = inst_12283__$1);

return statearr_12386;
})();
if(cljs.core.truth_(inst_12284)){
var statearr_12387_12438 = state_12351__$1;
(statearr_12387_12438[(1)] = (12));

} else {
var statearr_12388_12439 = state_12351__$1;
(statearr_12388_12439[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (9))){
var inst_12261 = (state_12351[(14)]);
var inst_12279 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12261);
var state_12351__$1 = state_12351;
var statearr_12389_12440 = state_12351__$1;
(statearr_12389_12440[(2)] = inst_12279);

(statearr_12389_12440[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (5))){
var inst_12277 = (state_12351[(2)]);
var state_12351__$1 = state_12351;
if(cljs.core.truth_(inst_12277)){
var statearr_12390_12441 = state_12351__$1;
(statearr_12390_12441[(1)] = (9));

} else {
var statearr_12391_12442 = state_12351__$1;
(statearr_12391_12442[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (14))){
var inst_12349 = (state_12351[(2)]);
var state_12351__$1 = state_12351;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12351__$1,inst_12349);
} else {
if((state_val_12352 === (26))){
var inst_12313 = (state_12351[(8)]);
var inst_12313__$1 = (state_12351[(2)]);
var inst_12314 = cljs.core.get.call(null,inst_12313__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var state_12351__$1 = (function (){var statearr_12392 = state_12351;
(statearr_12392[(8)] = inst_12313__$1);

return statearr_12392;
})();
var G__12393_12443 = inst_12314;
switch (G__12393_12443) {
case "SUCCESS":
var statearr_12394_12445 = state_12351__$1;
(statearr_12394_12445[(1)] = (28));


break;
case "RUNNING":
var statearr_12395_12446 = state_12351__$1;
(statearr_12395_12446[(1)] = (31));


break;
default:
var statearr_12396_12447 = state_12351__$1;
(statearr_12396_12447[(1)] = (39));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (16))){
var inst_12344 = (state_12351[(2)]);
var state_12351__$1 = state_12351;
var statearr_12397_12448 = state_12351__$1;
(statearr_12397_12448[(2)] = inst_12344);

(statearr_12397_12448[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (38))){
var inst_12336 = (state_12351[(2)]);
var state_12351__$1 = state_12351;
var statearr_12398_12449 = state_12351__$1;
(statearr_12398_12449[(2)] = inst_12336);

(statearr_12398_12449[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (30))){
var inst_12319 = (state_12351[(2)]);
var state_12351__$1 = state_12351;
var statearr_12399_12450 = state_12351__$1;
(statearr_12399_12450[(2)] = inst_12319);

(statearr_12399_12450[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (10))){
var inst_12261 = (state_12351[(14)]);
var state_12351__$1 = state_12351;
var statearr_12400_12451 = state_12351__$1;
(statearr_12400_12451[(2)] = inst_12261);

(statearr_12400_12451[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (18))){
var inst_12292 = (state_12351[(7)]);
var inst_12297 = inst_12292.cljs$lang$protocol_mask$partition0$;
var inst_12298 = (inst_12297 & (64));
var inst_12299 = inst_12292.cljs$core$ISeq$;
var inst_12300 = (cljs.core.PROTOCOL_SENTINEL === inst_12299);
var inst_12301 = ((inst_12298) || (inst_12300));
var state_12351__$1 = state_12351;
if(cljs.core.truth_(inst_12301)){
var statearr_12401_12452 = state_12351__$1;
(statearr_12401_12452[(1)] = (21));

} else {
var statearr_12402_12453 = state_12351__$1;
(statearr_12402_12453[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (37))){
var state_12351__$1 = state_12351;
var statearr_12403_12454 = state_12351__$1;
(statearr_12403_12454[(2)] = null);

(statearr_12403_12454[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (8))){
var inst_12274 = (state_12351[(2)]);
var state_12351__$1 = state_12351;
var statearr_12404_12455 = state_12351__$1;
(statearr_12404_12455[(2)] = inst_12274);

(statearr_12404_12455[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6204__auto___12409,return_chan,map__12256,map__12256__$1,options,timeout_ms))
;
return ((function (switch__6037__auto__,c__6204__auto___12409,return_chan,map__12256,map__12256__$1,options,timeout_ms){
return (function() {
var imcljs$fetch$resolve_identifiers_$_state_machine__6038__auto__ = null;
var imcljs$fetch$resolve_identifiers_$_state_machine__6038__auto____0 = (function (){
var statearr_12405 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12405[(0)] = imcljs$fetch$resolve_identifiers_$_state_machine__6038__auto__);

(statearr_12405[(1)] = (1));

return statearr_12405;
});
var imcljs$fetch$resolve_identifiers_$_state_machine__6038__auto____1 = (function (state_12351){
while(true){
var ret_value__6039__auto__ = (function (){try{while(true){
var result__6040__auto__ = switch__6037__auto__.call(null,state_12351);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6040__auto__;
}
break;
}
}catch (e12406){if((e12406 instanceof Object)){
var ex__6041__auto__ = e12406;
var statearr_12407_12456 = state_12351;
(statearr_12407_12456[(5)] = ex__6041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12351);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12406;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12457 = state_12351;
state_12351 = G__12457;
continue;
} else {
return ret_value__6039__auto__;
}
break;
}
});
imcljs$fetch$resolve_identifiers_$_state_machine__6038__auto__ = function(state_12351){
switch(arguments.length){
case 0:
return imcljs$fetch$resolve_identifiers_$_state_machine__6038__auto____0.call(this);
case 1:
return imcljs$fetch$resolve_identifiers_$_state_machine__6038__auto____1.call(this,state_12351);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
imcljs$fetch$resolve_identifiers_$_state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$fetch$resolve_identifiers_$_state_machine__6038__auto____0;
imcljs$fetch$resolve_identifiers_$_state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$fetch$resolve_identifiers_$_state_machine__6038__auto____1;
return imcljs$fetch$resolve_identifiers_$_state_machine__6038__auto__;
})()
;})(switch__6037__auto__,c__6204__auto___12409,return_chan,map__12256,map__12256__$1,options,timeout_ms))
})();
var state__6206__auto__ = (function (){var statearr_12408 = f__6205__auto__.call(null);
(statearr_12408[(6)] = c__6204__auto___12409);

return statearr_12408;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6206__auto__);
});})(c__6204__auto___12409,return_chan,map__12256,map__12256__$1,options,timeout_ms))
);


return return_chan;
});
/**
 * Returns generated code to run the query in a given language
 */
imcljs.fetch.code = (function imcljs$fetch$code(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12467 = arguments.length;
var i__4731__auto___12468 = (0);
while(true){
if((i__4731__auto___12468 < len__4730__auto___12467)){
args__4736__auto__.push((arguments[i__4731__auto___12468]));

var G__12469 = (i__4731__auto___12468 + (1));
i__4731__auto___12468 = G__12469;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.code.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.code.cljs$core$IFn$_invoke$arity$variadic = (function (service,model,p__12461){
var vec__12462 = p__12461;
var map__12465 = cljs.core.nth.call(null,vec__12462,(0),null);
var map__12465__$1 = (((((!((map__12465 == null))))?(((((map__12465.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12465.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12465):map__12465);
var options = map__12465__$1;
var lang = cljs.core.get.call(null,map__12465__$1,new cljs.core.Keyword(null,"lang","lang",-1819677104));
var query = cljs.core.get.call(null,map__12465__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/query/code",service,cljs.core.update.call(null,cljs.core.merge.call(null,options,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null)),new cljs.core.Keyword(null,"query","query",-1288509510),cljs.core.partial.call(null,imcljs.query.__GT_xml,model)),new cljs.core.Keyword(null,"code","code",1586293142));
});

imcljs.fetch.code.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.code.cljs$lang$applyTo = (function (seq12458){
var G__12459 = cljs.core.first.call(null,seq12458);
var seq12458__$1 = cljs.core.next.call(null,seq12458);
var G__12460 = cljs.core.first.call(null,seq12458__$1);
var seq12458__$2 = cljs.core.next.call(null,seq12458__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12459,G__12460,seq12458__$2);
});

/**
 * Returns list of InterMines from the InterMine registry. dev-mines? needs to
 * be set to true if you want to return non-prod mines, or otherwise set to false
 */
imcljs.fetch.registry = (function imcljs$fetch$registry(dev_mines_QMARK_){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"raw","raw",1604651272),new cljs.core.Keyword(null,"get","get",1683182755),"/instances",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"root","root",-448657453),"https://registry.intermine.org/service"], null),(cljs.core.truth_(dev_mines_QMARK_)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query-params","query-params",900640534),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mines","mines",-1960796490),"all"], null)], null):null),new cljs.core.Keyword(null,"instances","instances",-335364781));
});

//# sourceMappingURL=fetch.js.map
