// Compiled by ClojureScript 1.10.520 {}
goog.provide('imcljs.internal.utils');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
imcljs.internal.utils.does_not_contain_QMARK_ = cljs.core.complement.call(null,cljs.core.contains_QMARK_);
imcljs.internal.utils.one_of_QMARK_ = (function imcljs$internal$utils$one_of_QMARK_(haystack,needle){
return (!((cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([needle]),haystack) == null)));
});
imcljs.internal.utils.missing_http_QMARK__ = (function imcljs$internal$utils$missing_http_QMARK__(val){
return cljs.core.not.call(null,cljs.core.re_find.call(null,/^https?:\/\//,val));
});
imcljs.internal.utils.missing_service_QMARK__ = (function imcljs$internal$utils$missing_service_QMARK__(val){
return cljs.core.not.call(null,cljs.core.re_find.call(null,/\/service$/,val));
});
imcljs.internal.utils.append_ = (function imcljs$internal$utils$append_(text,val){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(val),cljs.core.str.cljs$core$IFn$_invoke$arity$1(text)].join('');
});
imcljs.internal.utils.alphabet = cljs.core.apply.call(null,cljs.core.sorted_set,clojure.string.split.call(null,"ABCDEFGHIJKLMNOPQRSTUVWXYZ",(new RegExp(""))));
/**
 * Ensures that a url starts with an http protocol and ends with /service
 */
imcljs.internal.utils.scrub_url = (function imcljs$internal$utils$scrub_url(url){
var G__10008 = url;
var G__10008__$1 = ((imcljs.internal.utils.missing_http_QMARK__.call(null,url))?["https://",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__10008)].join(''):G__10008);
if(imcljs.internal.utils.missing_service_QMARK__.call(null,url)){
return imcljs.internal.utils.append_.call(null,"/service",G__10008__$1);
} else {
return G__10008__$1;
}
});
imcljs.internal.utils.copy_list_query = (function imcljs$internal$utils$copy_list_query(p__10009){
var map__10010 = p__10009;
var map__10010__$1 = (((((!((map__10010 == null))))?(((((map__10010.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10010.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10010):map__10010);
var old_list_details = map__10010__$1;
var old_list_name = cljs.core.get.call(null,map__10010__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var old_list_type = cljs.core.get.call(null,map__10010__$1,new cljs.core.Keyword(null,"type","type",1174270348));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"from","from",1815293044),old_list_type,new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str.cljs$core$IFn$_invoke$arity$1(old_list_type),".id"].join('')], null),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"path","path",-188191168),old_list_type,new cljs.core.Keyword(null,"op","op",-1882987955),"IN",new cljs.core.Keyword(null,"value","value",305978217),old_list_name], null)], null)], null);
});
/**
 * Given a collection of channels, returns a collection containing
 *   the first result of each channel (similiar to JS Promise.all)
 */
imcljs.internal.utils._LT__LT__BANG_ = (function imcljs$internal$utils$_LT__LT__BANG_(chans){
var c__6204__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6204__auto__){
return (function (){
var f__6205__auto__ = (function (){var switch__6037__auto__ = ((function (c__6204__auto__){
return (function (state_10030){
var state_val_10031 = (state_10030[(1)]);
if((state_val_10031 === (1))){
var inst_10012 = cljs.core.List.EMPTY;
var inst_10013 = inst_10012;
var inst_10014 = chans;
var state_10030__$1 = (function (){var statearr_10032 = state_10030;
(statearr_10032[(7)] = inst_10013);

(statearr_10032[(8)] = inst_10014);

return statearr_10032;
})();
var statearr_10033_10044 = state_10030__$1;
(statearr_10033_10044[(2)] = null);

(statearr_10033_10044[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10031 === (2))){
var inst_10014 = (state_10030[(8)]);
var inst_10016 = cljs.core.seq.call(null,inst_10014);
var state_10030__$1 = state_10030;
if(inst_10016){
var statearr_10034_10045 = state_10030__$1;
(statearr_10034_10045[(1)] = (4));

} else {
var statearr_10035_10046 = state_10030__$1;
(statearr_10035_10046[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10031 === (3))){
var inst_10028 = (state_10030[(2)]);
var state_10030__$1 = state_10030;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10030__$1,inst_10028);
} else {
if((state_val_10031 === (4))){
var inst_10014 = (state_10030[(8)]);
var inst_10018 = cljs.core.first.call(null,inst_10014);
var state_10030__$1 = state_10030;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10030__$1,(7),inst_10018);
} else {
if((state_val_10031 === (5))){
var inst_10013 = (state_10030[(7)]);
var state_10030__$1 = state_10030;
var statearr_10036_10047 = state_10030__$1;
(statearr_10036_10047[(2)] = inst_10013);

(statearr_10036_10047[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10031 === (6))){
var inst_10026 = (state_10030[(2)]);
var state_10030__$1 = state_10030;
var statearr_10037_10048 = state_10030__$1;
(statearr_10037_10048[(2)] = inst_10026);

(statearr_10037_10048[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10031 === (7))){
var inst_10013 = (state_10030[(7)]);
var inst_10014 = (state_10030[(8)]);
var inst_10020 = (state_10030[(2)]);
var inst_10021 = cljs.core.conj.call(null,inst_10013,inst_10020);
var inst_10022 = cljs.core.rest.call(null,inst_10014);
var inst_10013__$1 = inst_10021;
var inst_10014__$1 = inst_10022;
var state_10030__$1 = (function (){var statearr_10038 = state_10030;
(statearr_10038[(7)] = inst_10013__$1);

(statearr_10038[(8)] = inst_10014__$1);

return statearr_10038;
})();
var statearr_10039_10049 = state_10030__$1;
(statearr_10039_10049[(2)] = null);

(statearr_10039_10049[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__6204__auto__))
;
return ((function (switch__6037__auto__,c__6204__auto__){
return (function() {
var imcljs$internal$utils$_LT__LT__BANG__$_state_machine__6038__auto__ = null;
var imcljs$internal$utils$_LT__LT__BANG__$_state_machine__6038__auto____0 = (function (){
var statearr_10040 = [null,null,null,null,null,null,null,null,null];
(statearr_10040[(0)] = imcljs$internal$utils$_LT__LT__BANG__$_state_machine__6038__auto__);

(statearr_10040[(1)] = (1));

return statearr_10040;
});
var imcljs$internal$utils$_LT__LT__BANG__$_state_machine__6038__auto____1 = (function (state_10030){
while(true){
var ret_value__6039__auto__ = (function (){try{while(true){
var result__6040__auto__ = switch__6037__auto__.call(null,state_10030);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6040__auto__;
}
break;
}
}catch (e10041){if((e10041 instanceof Object)){
var ex__6041__auto__ = e10041;
var statearr_10042_10050 = state_10030;
(statearr_10042_10050[(5)] = ex__6041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10030);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10041;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10051 = state_10030;
state_10030 = G__10051;
continue;
} else {
return ret_value__6039__auto__;
}
break;
}
});
imcljs$internal$utils$_LT__LT__BANG__$_state_machine__6038__auto__ = function(state_10030){
switch(arguments.length){
case 0:
return imcljs$internal$utils$_LT__LT__BANG__$_state_machine__6038__auto____0.call(this);
case 1:
return imcljs$internal$utils$_LT__LT__BANG__$_state_machine__6038__auto____1.call(this,state_10030);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
imcljs$internal$utils$_LT__LT__BANG__$_state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$internal$utils$_LT__LT__BANG__$_state_machine__6038__auto____0;
imcljs$internal$utils$_LT__LT__BANG__$_state_machine__6038__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$internal$utils$_LT__LT__BANG__$_state_machine__6038__auto____1;
return imcljs$internal$utils$_LT__LT__BANG__$_state_machine__6038__auto__;
})()
;})(switch__6037__auto__,c__6204__auto__))
})();
var state__6206__auto__ = (function (){var statearr_10043 = f__6205__auto__.call(null);
(statearr_10043[(6)] = c__6204__auto__);

return statearr_10043;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6206__auto__);
});})(c__6204__auto__))
);

return c__6204__auto__;
});
imcljs.internal.utils.assert_args = (function imcljs$internal$utils$assert_args(var_args){
var args__4736__auto__ = [];
var len__4730__auto___10061 = arguments.length;
var i__4731__auto___10062 = (0);
while(true){
if((i__4731__auto___10062 < len__4730__auto___10061)){
args__4736__auto__.push((arguments[i__4731__auto___10062]));

var G__10063 = (i__4731__auto___10062 + (1));
i__4731__auto___10062 = G__10063;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.internal.utils.assert_args.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.internal.utils.assert_args.cljs$core$IFn$_invoke$arity$variadic = (function (method,args){
var vec__10054 = (function (){var G__10060 = args;
if(cljs.core._EQ_.call(null,method,new cljs.core.Keyword(null,"raw","raw",1604651272))){
return cljs.core.drop.call(null,(1),G__10060);
} else {
return G__10060;
}
})();
var seq__10055 = cljs.core.seq.call(null,vec__10054);
var first__10056 = cljs.core.first.call(null,seq__10055);
var seq__10055__$1 = cljs.core.next.call(null,seq__10055);
var path = first__10056;
var first__10056__$1 = cljs.core.first.call(null,seq__10055__$1);
var seq__10055__$2 = cljs.core.next.call(null,seq__10055__$1);
var service = first__10056__$1;
var first__10056__$2 = cljs.core.first.call(null,seq__10055__$2);
var seq__10055__$3 = cljs.core.next.call(null,seq__10055__$2);
var options = first__10056__$2;
var vec__10057 = seq__10055__$3;
var xform = cljs.core.nth.call(null,vec__10057,(0),null);
if(cljs.core.truth_(cljs.core.every_pred.call(null,cljs.core.string_QMARK_,cljs.core.not_empty).call(null,path))){
} else {
throw (new Error(["Assert failed: ","path should be a non-empty string.","\n","((every-pred string? not-empty) path)"].join('')));
}

if(cljs.core.truth_(cljs.core.every_pred.call(null,cljs.core.string_QMARK_,cljs.core.not_empty).call(null,new cljs.core.Keyword(null,"root","root",-448657453).cljs$core$IFn$_invoke$arity$1(service)))){
} else {
throw (new Error(["Assert failed: ","service should always have a root URL.","\n","((every-pred string? not-empty) (:root service))"].join('')));
}

if(cljs.core.truth_(cljs.core.some_fn.call(null,cljs.core.map_QMARK_,cljs.core.nil_QMARK_).call(null,options))){
} else {
throw (new Error(["Assert failed: ","options should be a map if non-nil.","\n","((some-fn map? nil?) options)"].join('')));
}

if(cljs.core.truth_(cljs.core.some_fn.call(null,cljs.core.ifn_QMARK_,cljs.core.nil_QMARK_).call(null,xform))){
return null;
} else {
throw (new Error(["Assert failed: ","xform should be a callable function if non-nil.","\n","((some-fn ifn? nil?) xform)"].join('')));
}
});

imcljs.internal.utils.assert_args.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.internal.utils.assert_args.cljs$lang$applyTo = (function (seq10052){
var G__10053 = cljs.core.first.call(null,seq10052);
var seq10052__$1 = cljs.core.next.call(null,seq10052);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__10053,seq10052__$1);
});


//# sourceMappingURL=utils.js.map
