// Compiled by ClojureScript 1.10.520 {}
goog.provide('imcljs.save');
goog.require('cljs.core');
goog.require('imcljs.internal.io');
goog.require('imcljs.fetch');
goog.require('imcljs.internal.utils');
goog.require('cljs.core.async');
/**
 * Creates a list using a plain text string of identifiers
 */
imcljs.save.im_list = (function imcljs$save$im_list(var_args){
var args__4736__auto__ = [];
var len__4730__auto___7463 = arguments.length;
var i__4731__auto___7464 = (0);
while(true){
if((i__4731__auto___7464 < len__4730__auto___7463)){
args__4736__auto__.push((arguments[i__4731__auto___7464]));

var G__7465 = (i__4731__auto___7464 + (1));
i__4731__auto___7464 = G__7465;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((4) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((4)),(0),null)):null);
return imcljs.save.im_list.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4737__auto__);
});

imcljs.save.im_list.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,type,identifiers,p__7459){
var vec__7460 = p__7459;
var options = cljs.core.nth.call(null,vec__7460,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post-body","post-body",-1481559189),["/lists?name=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"&type=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join(''),service,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"body","body",-2049205669),identifiers,new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","text/plain"], null)], null));
});

imcljs.save.im_list.cljs$lang$maxFixedArity = (4);

/** @this {Function} */
imcljs.save.im_list.cljs$lang$applyTo = (function (seq7454){
var G__7455 = cljs.core.first.call(null,seq7454);
var seq7454__$1 = cljs.core.next.call(null,seq7454);
var G__7456 = cljs.core.first.call(null,seq7454__$1);
var seq7454__$2 = cljs.core.next.call(null,seq7454__$1);
var G__7457 = cljs.core.first.call(null,seq7454__$2);
var seq7454__$3 = cljs.core.next.call(null,seq7454__$2);
var G__7458 = cljs.core.first.call(null,seq7454__$3);
var seq7454__$4 = cljs.core.next.call(null,seq7454__$3);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7455,G__7456,G__7457,G__7458,seq7454__$4);
});

/**
 * Update an existing list. Currently, only updating the description by specifying
 *   `:newDescription` in the `options` map is supported.
 */
imcljs.save.im_list_update = (function imcljs$save$im_list_update(var_args){
var args__4736__auto__ = [];
var len__4730__auto___7473 = arguments.length;
var i__4731__auto___7474 = (0);
while(true){
if((i__4731__auto___7474 < len__4730__auto___7473)){
args__4736__auto__.push((arguments[i__4731__auto___7474]));

var G__7475 = (i__4731__auto___7474 + (1));
i__4731__auto___7474 = G__7475;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.im_list_update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.im_list_update.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,p__7469){
var vec__7470 = p__7469;
var options = cljs.core.nth.call(null,vec__7470,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"put","put",1299772570),"/lists",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_update.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.im_list_update.cljs$lang$applyTo = (function (seq7466){
var G__7467 = cljs.core.first.call(null,seq7466);
var seq7466__$1 = cljs.core.next.call(null,seq7466);
var G__7468 = cljs.core.first.call(null,seq7466__$1);
var seq7466__$2 = cljs.core.next.call(null,seq7466__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7467,G__7468,seq7466__$2);
});

/**
 * Delete one or name lists.
 */
imcljs.save.im_list_delete = (function imcljs$save$im_list_delete(var_args){
var args__4736__auto__ = [];
var len__4730__auto___7483 = arguments.length;
var i__4731__auto___7484 = (0);
while(true){
if((i__4731__auto___7484 < len__4730__auto___7483)){
args__4736__auto__.push((arguments[i__4731__auto___7484]));

var G__7485 = (i__4731__auto___7484 + (1));
i__4731__auto___7484 = G__7485;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.im_list_delete.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.im_list_delete.cljs$core$IFn$_invoke$arity$variadic = (function (service,names,p__7479){
var vec__7480 = p__7479;
var options = cljs.core.nth.call(null,vec__7480,(0),null);
if(cljs.core.coll_QMARK_.call(null,names)){
return imcljs.internal.utils._LT__LT__BANG_.call(null,cljs.core.map.call(null,((function (vec__7480,options){
return (function (name){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/lists",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});})(vec__7480,options))
,names));
} else {
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/lists",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),names,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
}
});

imcljs.save.im_list_delete.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.im_list_delete.cljs$lang$applyTo = (function (seq7476){
var G__7477 = cljs.core.first.call(null,seq7476);
var seq7476__$1 = cljs.core.next.call(null,seq7476);
var G__7478 = cljs.core.first.call(null,seq7476__$1);
var seq7476__$2 = cljs.core.next.call(null,seq7476__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7477,G__7478,seq7476__$2);
});

imcljs.save.im_list_rename = (function imcljs$save$im_list_rename(var_args){
var args__4736__auto__ = [];
var len__4730__auto___7494 = arguments.length;
var i__4731__auto___7495 = (0);
while(true){
if((i__4731__auto___7495 < len__4730__auto___7494)){
args__4736__auto__.push((arguments[i__4731__auto___7495]));

var G__7496 = (i__4731__auto___7495 + (1));
i__4731__auto___7495 = G__7496;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_rename.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_rename.cljs$core$IFn$_invoke$arity$variadic = (function (service,old_name,new_name,p__7490){
var vec__7491 = p__7490;
var options = cljs.core.nth.call(null,vec__7491,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/lists/rename",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"oldname","oldname",-234488026),old_name,new cljs.core.Keyword(null,"newname","newname",389205813),new_name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_rename.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_rename.cljs$lang$applyTo = (function (seq7486){
var G__7487 = cljs.core.first.call(null,seq7486);
var seq7486__$1 = cljs.core.next.call(null,seq7486);
var G__7488 = cljs.core.first.call(null,seq7486__$1);
var seq7486__$2 = cljs.core.next.call(null,seq7486__$1);
var G__7489 = cljs.core.first.call(null,seq7486__$2);
var seq7486__$3 = cljs.core.next.call(null,seq7486__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7487,G__7488,G__7489,seq7486__$3);
});

imcljs.save.im_list_union = (function imcljs$save$im_list_union(var_args){
var args__4736__auto__ = [];
var len__4730__auto___7505 = arguments.length;
var i__4731__auto___7506 = (0);
while(true){
if((i__4731__auto___7506 < len__4730__auto___7505)){
args__4736__auto__.push((arguments[i__4731__auto___7506]));

var G__7507 = (i__4731__auto___7506 + (1));
i__4731__auto___7506 = G__7507;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_union.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_union.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,lists,p__7501){
var vec__7502 = p__7501;
var options = cljs.core.nth.call(null,vec__7502,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/lists/union",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"lists","lists",-884730684),lists,new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_union.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_union.cljs$lang$applyTo = (function (seq7497){
var G__7498 = cljs.core.first.call(null,seq7497);
var seq7497__$1 = cljs.core.next.call(null,seq7497);
var G__7499 = cljs.core.first.call(null,seq7497__$1);
var seq7497__$2 = cljs.core.next.call(null,seq7497__$1);
var G__7500 = cljs.core.first.call(null,seq7497__$2);
var seq7497__$3 = cljs.core.next.call(null,seq7497__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7498,G__7499,G__7500,seq7497__$3);
});

imcljs.save.im_list_intersect = (function imcljs$save$im_list_intersect(var_args){
var args__4736__auto__ = [];
var len__4730__auto___7516 = arguments.length;
var i__4731__auto___7517 = (0);
while(true){
if((i__4731__auto___7517 < len__4730__auto___7516)){
args__4736__auto__.push((arguments[i__4731__auto___7517]));

var G__7518 = (i__4731__auto___7517 + (1));
i__4731__auto___7517 = G__7518;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_intersect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_intersect.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,lists,p__7512){
var vec__7513 = p__7512;
var options = cljs.core.nth.call(null,vec__7513,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/lists/intersect",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"lists","lists",-884730684),lists,new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_intersect.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_intersect.cljs$lang$applyTo = (function (seq7508){
var G__7509 = cljs.core.first.call(null,seq7508);
var seq7508__$1 = cljs.core.next.call(null,seq7508);
var G__7510 = cljs.core.first.call(null,seq7508__$1);
var seq7508__$2 = cljs.core.next.call(null,seq7508__$1);
var G__7511 = cljs.core.first.call(null,seq7508__$2);
var seq7508__$3 = cljs.core.next.call(null,seq7508__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7509,G__7510,G__7511,seq7508__$3);
});

imcljs.save.im_list_difference = (function imcljs$save$im_list_difference(var_args){
var args__4736__auto__ = [];
var len__4730__auto___7527 = arguments.length;
var i__4731__auto___7528 = (0);
while(true){
if((i__4731__auto___7528 < len__4730__auto___7527)){
args__4736__auto__.push((arguments[i__4731__auto___7528]));

var G__7529 = (i__4731__auto___7528 + (1));
i__4731__auto___7528 = G__7529;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_difference.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_difference.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,lists,p__7523){
var vec__7524 = p__7523;
var options = cljs.core.nth.call(null,vec__7524,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/lists/diff",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"lists","lists",-884730684),lists,new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_difference.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_difference.cljs$lang$applyTo = (function (seq7519){
var G__7520 = cljs.core.first.call(null,seq7519);
var seq7519__$1 = cljs.core.next.call(null,seq7519);
var G__7521 = cljs.core.first.call(null,seq7519__$1);
var seq7519__$2 = cljs.core.next.call(null,seq7519__$1);
var G__7522 = cljs.core.first.call(null,seq7519__$2);
var seq7519__$3 = cljs.core.next.call(null,seq7519__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7520,G__7521,G__7522,seq7519__$3);
});

imcljs.save.im_list_subtraction = (function imcljs$save$im_list_subtraction(var_args){
var args__4736__auto__ = [];
var len__4730__auto___7539 = arguments.length;
var i__4731__auto___7540 = (0);
while(true){
if((i__4731__auto___7540 < len__4730__auto___7539)){
args__4736__auto__.push((arguments[i__4731__auto___7540]));

var G__7541 = (i__4731__auto___7540 + (1));
i__4731__auto___7540 = G__7541;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((4) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((4)),(0),null)):null);
return imcljs.save.im_list_subtraction.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4737__auto__);
});

imcljs.save.im_list_subtraction.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,source_lists,subtract_lists,p__7535){
var vec__7536 = p__7535;
var options = cljs.core.nth.call(null,vec__7536,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/lists/subtract",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"references","references",882562509),source_lists,new cljs.core.Keyword(null,"subtract","subtract",2136988635),subtract_lists,new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_subtraction.cljs$lang$maxFixedArity = (4);

/** @this {Function} */
imcljs.save.im_list_subtraction.cljs$lang$applyTo = (function (seq7530){
var G__7531 = cljs.core.first.call(null,seq7530);
var seq7530__$1 = cljs.core.next.call(null,seq7530);
var G__7532 = cljs.core.first.call(null,seq7530__$1);
var seq7530__$2 = cljs.core.next.call(null,seq7530__$1);
var G__7533 = cljs.core.first.call(null,seq7530__$2);
var seq7530__$3 = cljs.core.next.call(null,seq7530__$2);
var G__7534 = cljs.core.first.call(null,seq7530__$3);
var seq7530__$4 = cljs.core.next.call(null,seq7530__$3);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7531,G__7532,G__7533,G__7534,seq7530__$4);
});

imcljs.save.im_list_from_query = (function imcljs$save$im_list_from_query(var_args){
var args__4736__auto__ = [];
var len__4730__auto___7550 = arguments.length;
var i__4731__auto___7551 = (0);
while(true){
if((i__4731__auto___7551 < len__4730__auto___7550)){
args__4736__auto__.push((arguments[i__4731__auto___7551]));

var G__7552 = (i__4731__auto___7551 + (1));
i__4731__auto___7551 = G__7552;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_from_query.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_from_query.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,query,p__7546){
var vec__7547 = p__7546;
var options = cljs.core.nth.call(null,vec__7547,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/tolist",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_from_query.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_from_query.cljs$lang$applyTo = (function (seq7542){
var G__7543 = cljs.core.first.call(null,seq7542);
var seq7542__$1 = cljs.core.next.call(null,seq7542);
var G__7544 = cljs.core.first.call(null,seq7542__$1);
var seq7542__$2 = cljs.core.next.call(null,seq7542__$1);
var G__7545 = cljs.core.first.call(null,seq7542__$2);
var seq7542__$3 = cljs.core.next.call(null,seq7542__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7543,G__7544,G__7545,seq7542__$3);
});

imcljs.save.im_list_add_tag = (function imcljs$save$im_list_add_tag(var_args){
var args__4736__auto__ = [];
var len__4730__auto___7561 = arguments.length;
var i__4731__auto___7562 = (0);
while(true){
if((i__4731__auto___7562 < len__4730__auto___7561)){
args__4736__auto__.push((arguments[i__4731__auto___7562]));

var G__7563 = (i__4731__auto___7562 + (1));
i__4731__auto___7562 = G__7563;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_add_tag.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_add_tag.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,tags,p__7557){
var vec__7558 = p__7557;
var options = cljs.core.nth.call(null,vec__7558,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/list/tags",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"tags","tags",1771418977),((cljs.core.coll_QMARK_.call(null,tags))?cljs.core.interpose.call(null,";",tags):tags),new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_add_tag.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_add_tag.cljs$lang$applyTo = (function (seq7553){
var G__7554 = cljs.core.first.call(null,seq7553);
var seq7553__$1 = cljs.core.next.call(null,seq7553);
var G__7555 = cljs.core.first.call(null,seq7553__$1);
var seq7553__$2 = cljs.core.next.call(null,seq7553__$1);
var G__7556 = cljs.core.first.call(null,seq7553__$2);
var seq7553__$3 = cljs.core.next.call(null,seq7553__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7554,G__7555,G__7556,seq7553__$3);
});

imcljs.save.im_list_remove_tag = (function imcljs$save$im_list_remove_tag(var_args){
var args__4736__auto__ = [];
var len__4730__auto___7572 = arguments.length;
var i__4731__auto___7573 = (0);
while(true){
if((i__4731__auto___7573 < len__4730__auto___7572)){
args__4736__auto__.push((arguments[i__4731__auto___7573]));

var G__7574 = (i__4731__auto___7573 + (1));
i__4731__auto___7573 = G__7574;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_remove_tag.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_remove_tag.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,tags,p__7568){
var vec__7569 = p__7568;
var options = cljs.core.nth.call(null,vec__7569,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/list/tags",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"tags","tags",1771418977),((cljs.core.coll_QMARK_.call(null,tags))?cljs.core.interpose.call(null,";",tags):tags),new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_remove_tag.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_remove_tag.cljs$lang$applyTo = (function (seq7564){
var G__7565 = cljs.core.first.call(null,seq7564);
var seq7564__$1 = cljs.core.next.call(null,seq7564);
var G__7566 = cljs.core.first.call(null,seq7564__$1);
var seq7564__$2 = cljs.core.next.call(null,seq7564__$1);
var G__7567 = cljs.core.first.call(null,seq7564__$2);
var seq7564__$3 = cljs.core.next.call(null,seq7564__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7565,G__7566,G__7567,seq7564__$3);
});

/**
 * Copy a list by name
 */
imcljs.save.im_list_copy = (function imcljs$save$im_list_copy(var_args){
var args__4736__auto__ = [];
var len__4730__auto___7597 = arguments.length;
var i__4731__auto___7598 = (0);
while(true){
if((i__4731__auto___7598 < len__4730__auto___7597)){
args__4736__auto__.push((arguments[i__4731__auto___7598]));

var G__7599 = (i__4731__auto___7598 + (1));
i__4731__auto___7598 = G__7599;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_copy.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_copy.cljs$core$IFn$_invoke$arity$variadic = (function (service,old_name,new_name,p__7579){
var vec__7580 = p__7579;
var options = cljs.core.nth.call(null,vec__7580,(0),null);
var c__2324__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2324__auto__,vec__7580,options){
return (function (){
var f__2325__auto__ = (function (){var switch__2301__auto__ = ((function (c__2324__auto__,vec__7580,options){
return (function (state_7591){
var state_val_7592 = (state_7591[(1)]);
if((state_val_7592 === (1))){
var inst_7583 = imcljs.fetch.one_list.call(null,service,old_name);
var state_7591__$1 = state_7591;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_7591__$1,(2),inst_7583);
} else {
if((state_val_7592 === (2))){
var inst_7585 = (state_7591[(2)]);
var inst_7586 = imcljs.internal.utils.copy_list_query.call(null,inst_7585);
var inst_7587 = imcljs.save.im_list_from_query.call(null,service,new_name,inst_7586);
var state_7591__$1 = state_7591;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_7591__$1,(3),inst_7587);
} else {
if((state_val_7592 === (3))){
var inst_7589 = (state_7591[(2)]);
var state_7591__$1 = state_7591;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_7591__$1,inst_7589);
} else {
return null;
}
}
}
});})(c__2324__auto__,vec__7580,options))
;
return ((function (switch__2301__auto__,c__2324__auto__,vec__7580,options){
return (function() {
var imcljs$save$state_machine__2302__auto__ = null;
var imcljs$save$state_machine__2302__auto____0 = (function (){
var statearr_7593 = [null,null,null,null,null,null,null];
(statearr_7593[(0)] = imcljs$save$state_machine__2302__auto__);

(statearr_7593[(1)] = (1));

return statearr_7593;
});
var imcljs$save$state_machine__2302__auto____1 = (function (state_7591){
while(true){
var ret_value__2303__auto__ = (function (){try{while(true){
var result__2304__auto__ = switch__2301__auto__.call(null,state_7591);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2304__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2304__auto__;
}
break;
}
}catch (e7594){if((e7594 instanceof Object)){
var ex__2305__auto__ = e7594;
var statearr_7595_7600 = state_7591;
(statearr_7595_7600[(5)] = ex__2305__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_7591);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e7594;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2303__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__7601 = state_7591;
state_7591 = G__7601;
continue;
} else {
return ret_value__2303__auto__;
}
break;
}
});
imcljs$save$state_machine__2302__auto__ = function(state_7591){
switch(arguments.length){
case 0:
return imcljs$save$state_machine__2302__auto____0.call(this);
case 1:
return imcljs$save$state_machine__2302__auto____1.call(this,state_7591);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
imcljs$save$state_machine__2302__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$save$state_machine__2302__auto____0;
imcljs$save$state_machine__2302__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$save$state_machine__2302__auto____1;
return imcljs$save$state_machine__2302__auto__;
})()
;})(switch__2301__auto__,c__2324__auto__,vec__7580,options))
})();
var state__2326__auto__ = (function (){var statearr_7596 = f__2325__auto__.call(null);
(statearr_7596[(6)] = c__2324__auto__);

return statearr_7596;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2326__auto__);
});})(c__2324__auto__,vec__7580,options))
);

return c__2324__auto__;
});

imcljs.save.im_list_copy.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_copy.cljs$lang$applyTo = (function (seq7575){
var G__7576 = cljs.core.first.call(null,seq7575);
var seq7575__$1 = cljs.core.next.call(null,seq7575);
var G__7577 = cljs.core.first.call(null,seq7575__$1);
var seq7575__$2 = cljs.core.next.call(null,seq7575__$1);
var G__7578 = cljs.core.first.call(null,seq7575__$2);
var seq7575__$3 = cljs.core.next.call(null,seq7575__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7576,G__7577,G__7578,seq7575__$3);
});

/**
 * Set the preferences for the authenticated user by passing a map.
 *   Note that none of the values can be an empty string. For that you'll have to
 *   use `delete-preference` instead.
 */
imcljs.save.preferences = (function imcljs$save$preferences(var_args){
var args__4736__auto__ = [];
var len__4730__auto___7609 = arguments.length;
var i__4731__auto___7610 = (0);
while(true){
if((i__4731__auto___7610 < len__4730__auto___7609)){
args__4736__auto__.push((arguments[i__4731__auto___7610]));

var G__7611 = (i__4731__auto___7610 + (1));
i__4731__auto___7610 = G__7611;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.preferences.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.preferences.cljs$core$IFn$_invoke$arity$variadic = (function (service,preferences,p__7605){
var vec__7606 = p__7605;
var options = cljs.core.nth.call(null,vec__7606,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/user/preferences",service,cljs.core.merge.call(null,preferences,options),new cljs.core.Keyword(null,"preferences","preferences",-484312211));
});

imcljs.save.preferences.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.preferences.cljs$lang$applyTo = (function (seq7602){
var G__7603 = cljs.core.first.call(null,seq7602);
var seq7602__$1 = cljs.core.next.call(null,seq7602);
var G__7604 = cljs.core.first.call(null,seq7602__$1);
var seq7602__$2 = cljs.core.next.call(null,seq7602__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7603,G__7604,seq7602__$2);
});

/**
 * Delete a single stored preference by key for the authenticated user.
 */
imcljs.save.delete_preference = (function imcljs$save$delete_preference(var_args){
var args__4736__auto__ = [];
var len__4730__auto___7619 = arguments.length;
var i__4731__auto___7620 = (0);
while(true){
if((i__4731__auto___7620 < len__4730__auto___7619)){
args__4736__auto__.push((arguments[i__4731__auto___7620]));

var G__7621 = (i__4731__auto___7620 + (1));
i__4731__auto___7620 = G__7621;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.delete_preference.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.delete_preference.cljs$core$IFn$_invoke$arity$variadic = (function (service,preference,p__7615){
var vec__7616 = p__7615;
var options = cljs.core.nth.call(null,vec__7616,(0),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),preference], null),options);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/user/preferences",service,params,new cljs.core.Keyword(null,"preferences","preferences",-484312211));
});

imcljs.save.delete_preference.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.delete_preference.cljs$lang$applyTo = (function (seq7612){
var G__7613 = cljs.core.first.call(null,seq7612);
var seq7612__$1 = cljs.core.next.call(null,seq7612);
var G__7614 = cljs.core.first.call(null,seq7612__$1);
var seq7612__$2 = cljs.core.next.call(null,seq7612__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7613,G__7614,seq7612__$2);
});

/**
 * Upload a query to be saved into the user's profile.
 *   As of InterMine 4.1.2, the webservice returns an invalid JSON response, hence
 *   why we use `:format 'text'` and no xform.
 */
imcljs.save.query = (function imcljs$save$query(var_args){
var args__4736__auto__ = [];
var len__4730__auto___7629 = arguments.length;
var i__4731__auto___7630 = (0);
while(true){
if((i__4731__auto___7630 < len__4730__auto___7629)){
args__4736__auto__.push((arguments[i__4731__auto___7630]));

var G__7631 = (i__4731__auto___7630 + (1));
i__4731__auto___7630 = G__7631;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.query.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.query.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__7625){
var vec__7626 = p__7625;
var options = cljs.core.nth.call(null,vec__7626,(0),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"text"], null),options);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/user/queries",service,params);
});

imcljs.save.query.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.query.cljs$lang$applyTo = (function (seq7622){
var G__7623 = cljs.core.first.call(null,seq7622);
var seq7622__$1 = cljs.core.next.call(null,seq7622);
var G__7624 = cljs.core.first.call(null,seq7622__$1);
var seq7622__$2 = cljs.core.next.call(null,seq7622__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7623,G__7624,seq7622__$2);
});

/**
 * Delete a query that has previously been saved into the user's profile.
 */
imcljs.save.delete_query = (function imcljs$save$delete_query(var_args){
var args__4736__auto__ = [];
var len__4730__auto___7639 = arguments.length;
var i__4731__auto___7640 = (0);
while(true){
if((i__4731__auto___7640 < len__4730__auto___7639)){
args__4736__auto__.push((arguments[i__4731__auto___7640]));

var G__7641 = (i__4731__auto___7640 + (1));
i__4731__auto___7640 = G__7641;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.delete_query.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.delete_query.cljs$core$IFn$_invoke$arity$variadic = (function (service,title,p__7635){
var vec__7636 = p__7635;
var options = cljs.core.nth.call(null,vec__7636,(0),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),title], null),options);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/user/queries",service,params);
});

imcljs.save.delete_query.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.delete_query.cljs$lang$applyTo = (function (seq7632){
var G__7633 = cljs.core.first.call(null,seq7632);
var seq7632__$1 = cljs.core.next.call(null,seq7632);
var G__7634 = cljs.core.first.call(null,seq7632__$1);
var seq7632__$2 = cljs.core.next.call(null,seq7632__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7633,G__7634,seq7632__$2);
});


//# sourceMappingURL=save.js.map
