// Compiled by ClojureScript 1.10.520 {}
goog.provide('imcljs.internal.utils');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
imcljs.internal.utils.does_not_contain_QMARK_ = cljs.core.complement.call(null,cljs.core.contains_QMARK_);
imcljs.internal.utils.one_of_QMARK_ = (function imcljs$internal$utils$one_of_QMARK_(haystack,needle){
return (!((cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([needle]),haystack) == null)));
});
imcljs.internal.utils.missing_http_QMARK__ = (function imcljs$internal$utils$missing_http_QMARK__(val){
return cljs.core.not.call(null,cljs.core.re_find.call(null,/^https?:\/\//,val));
});
imcljs.internal.utils.missing_service_QMARK__ = (function imcljs$internal$utils$missing_service_QMARK__(val){
return cljs.core.not.call(null,cljs.core.re_find.call(null,/\/service$/,val));
});
imcljs.internal.utils.append_ = (function imcljs$internal$utils$append_(text,val){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(val),cljs.core.str.cljs$core$IFn$_invoke$arity$1(text)].join('');
});
imcljs.internal.utils.alphabet = cljs.core.apply.call(null,cljs.core.sorted_set,clojure.string.split.call(null,"ABCDEFGHIJKLMNOPQRSTUVWXYZ",(new RegExp(""))));
/**
 * Ensures that a url starts with an http protocol and ends with /service
 */
imcljs.internal.utils.scrub_url = (function imcljs$internal$utils$scrub_url(url){
var G__6750 = url;
var G__6750__$1 = ((imcljs.internal.utils.missing_http_QMARK__.call(null,url))?["https://",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__6750)].join(''):G__6750);
if(imcljs.internal.utils.missing_service_QMARK__.call(null,url)){
return imcljs.internal.utils.append_.call(null,"/service",G__6750__$1);
} else {
return G__6750__$1;
}
});
imcljs.internal.utils.copy_list_query = (function imcljs$internal$utils$copy_list_query(p__6751){
var map__6752 = p__6751;
var map__6752__$1 = (((((!((map__6752 == null))))?(((((map__6752.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6752.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6752):map__6752);
var old_list_details = map__6752__$1;
var old_list_name = cljs.core.get.call(null,map__6752__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var old_list_type = cljs.core.get.call(null,map__6752__$1,new cljs.core.Keyword(null,"type","type",1174270348));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"from","from",1815293044),old_list_type,new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str.cljs$core$IFn$_invoke$arity$1(old_list_type),".id"].join('')], null),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"path","path",-188191168),old_list_type,new cljs.core.Keyword(null,"op","op",-1882987955),"IN",new cljs.core.Keyword(null,"value","value",305978217),old_list_name], null)], null)], null);
});
/**
 * Given a collection of channels, returns a collection containing
 *   the first result of each channel (similiar to JS Promise.all)
 */
imcljs.internal.utils._LT__LT__BANG_ = (function imcljs$internal$utils$_LT__LT__BANG_(chans){
var c__4809__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__4809__auto__){
return (function (){
var f__4810__auto__ = (function (){var switch__4714__auto__ = ((function (c__4809__auto__){
return (function (state_6772){
var state_val_6773 = (state_6772[(1)]);
if((state_val_6773 === (1))){
var inst_6754 = cljs.core.List.EMPTY;
var inst_6755 = inst_6754;
var inst_6756 = chans;
var state_6772__$1 = (function (){var statearr_6774 = state_6772;
(statearr_6774[(7)] = inst_6755);

(statearr_6774[(8)] = inst_6756);

return statearr_6774;
})();
var statearr_6775_6786 = state_6772__$1;
(statearr_6775_6786[(2)] = null);

(statearr_6775_6786[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6773 === (2))){
var inst_6756 = (state_6772[(8)]);
var inst_6758 = cljs.core.seq.call(null,inst_6756);
var state_6772__$1 = state_6772;
if(inst_6758){
var statearr_6776_6787 = state_6772__$1;
(statearr_6776_6787[(1)] = (4));

} else {
var statearr_6777_6788 = state_6772__$1;
(statearr_6777_6788[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6773 === (3))){
var inst_6770 = (state_6772[(2)]);
var state_6772__$1 = state_6772;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_6772__$1,inst_6770);
} else {
if((state_val_6773 === (4))){
var inst_6756 = (state_6772[(8)]);
var inst_6760 = cljs.core.first.call(null,inst_6756);
var state_6772__$1 = state_6772;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_6772__$1,(7),inst_6760);
} else {
if((state_val_6773 === (5))){
var inst_6755 = (state_6772[(7)]);
var state_6772__$1 = state_6772;
var statearr_6778_6789 = state_6772__$1;
(statearr_6778_6789[(2)] = inst_6755);

(statearr_6778_6789[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6773 === (6))){
var inst_6768 = (state_6772[(2)]);
var state_6772__$1 = state_6772;
var statearr_6779_6790 = state_6772__$1;
(statearr_6779_6790[(2)] = inst_6768);

(statearr_6779_6790[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6773 === (7))){
var inst_6755 = (state_6772[(7)]);
var inst_6756 = (state_6772[(8)]);
var inst_6762 = (state_6772[(2)]);
var inst_6763 = cljs.core.conj.call(null,inst_6755,inst_6762);
var inst_6764 = cljs.core.rest.call(null,inst_6756);
var inst_6755__$1 = inst_6763;
var inst_6756__$1 = inst_6764;
var state_6772__$1 = (function (){var statearr_6780 = state_6772;
(statearr_6780[(7)] = inst_6755__$1);

(statearr_6780[(8)] = inst_6756__$1);

return statearr_6780;
})();
var statearr_6781_6791 = state_6772__$1;
(statearr_6781_6791[(2)] = null);

(statearr_6781_6791[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__4809__auto__))
;
return ((function (switch__4714__auto__,c__4809__auto__){
return (function() {
var imcljs$internal$utils$_LT__LT__BANG__$_state_machine__4715__auto__ = null;
var imcljs$internal$utils$_LT__LT__BANG__$_state_machine__4715__auto____0 = (function (){
var statearr_6782 = [null,null,null,null,null,null,null,null,null];
(statearr_6782[(0)] = imcljs$internal$utils$_LT__LT__BANG__$_state_machine__4715__auto__);

(statearr_6782[(1)] = (1));

return statearr_6782;
});
var imcljs$internal$utils$_LT__LT__BANG__$_state_machine__4715__auto____1 = (function (state_6772){
while(true){
var ret_value__4716__auto__ = (function (){try{while(true){
var result__4717__auto__ = switch__4714__auto__.call(null,state_6772);
if(cljs.core.keyword_identical_QMARK_.call(null,result__4717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__4717__auto__;
}
break;
}
}catch (e6783){if((e6783 instanceof Object)){
var ex__4718__auto__ = e6783;
var statearr_6784_6792 = state_6772;
(statearr_6784_6792[(5)] = ex__4718__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_6772);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e6783;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__4716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__6793 = state_6772;
state_6772 = G__6793;
continue;
} else {
return ret_value__4716__auto__;
}
break;
}
});
imcljs$internal$utils$_LT__LT__BANG__$_state_machine__4715__auto__ = function(state_6772){
switch(arguments.length){
case 0:
return imcljs$internal$utils$_LT__LT__BANG__$_state_machine__4715__auto____0.call(this);
case 1:
return imcljs$internal$utils$_LT__LT__BANG__$_state_machine__4715__auto____1.call(this,state_6772);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
imcljs$internal$utils$_LT__LT__BANG__$_state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$internal$utils$_LT__LT__BANG__$_state_machine__4715__auto____0;
imcljs$internal$utils$_LT__LT__BANG__$_state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$internal$utils$_LT__LT__BANG__$_state_machine__4715__auto____1;
return imcljs$internal$utils$_LT__LT__BANG__$_state_machine__4715__auto__;
})()
;})(switch__4714__auto__,c__4809__auto__))
})();
var state__4811__auto__ = (function (){var statearr_6785 = f__4810__auto__.call(null);
(statearr_6785[(6)] = c__4809__auto__);

return statearr_6785;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__4811__auto__);
});})(c__4809__auto__))
);

return c__4809__auto__;
});
imcljs.internal.utils.assert_args = (function imcljs$internal$utils$assert_args(var_args){
var args__4736__auto__ = [];
var len__4730__auto___6803 = arguments.length;
var i__4731__auto___6804 = (0);
while(true){
if((i__4731__auto___6804 < len__4730__auto___6803)){
args__4736__auto__.push((arguments[i__4731__auto___6804]));

var G__6805 = (i__4731__auto___6804 + (1));
i__4731__auto___6804 = G__6805;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.internal.utils.assert_args.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.internal.utils.assert_args.cljs$core$IFn$_invoke$arity$variadic = (function (method,args){
var vec__6796 = (function (){var G__6802 = args;
if(cljs.core._EQ_.call(null,method,new cljs.core.Keyword(null,"raw","raw",1604651272))){
return cljs.core.drop.call(null,(1),G__6802);
} else {
return G__6802;
}
})();
var seq__6797 = cljs.core.seq.call(null,vec__6796);
var first__6798 = cljs.core.first.call(null,seq__6797);
var seq__6797__$1 = cljs.core.next.call(null,seq__6797);
var path = first__6798;
var first__6798__$1 = cljs.core.first.call(null,seq__6797__$1);
var seq__6797__$2 = cljs.core.next.call(null,seq__6797__$1);
var service = first__6798__$1;
var first__6798__$2 = cljs.core.first.call(null,seq__6797__$2);
var seq__6797__$3 = cljs.core.next.call(null,seq__6797__$2);
var options = first__6798__$2;
var vec__6799 = seq__6797__$3;
var xform = cljs.core.nth.call(null,vec__6799,(0),null);
if(cljs.core.truth_(cljs.core.every_pred.call(null,cljs.core.string_QMARK_,cljs.core.not_empty).call(null,path))){
} else {
throw (new Error(["Assert failed: ","path should be a non-empty string.","\n","((every-pred string? not-empty) path)"].join('')));
}

if(cljs.core.truth_(cljs.core.every_pred.call(null,cljs.core.string_QMARK_,cljs.core.not_empty).call(null,new cljs.core.Keyword(null,"root","root",-448657453).cljs$core$IFn$_invoke$arity$1(service)))){
} else {
throw (new Error(["Assert failed: ","service should always have a root URL.","\n","((every-pred string? not-empty) (:root service))"].join('')));
}

if(cljs.core.truth_(cljs.core.some_fn.call(null,cljs.core.map_QMARK_,cljs.core.nil_QMARK_).call(null,options))){
} else {
throw (new Error(["Assert failed: ","options should be a map if non-nil.","\n","((some-fn map? nil?) options)"].join('')));
}

if(cljs.core.truth_(cljs.core.some_fn.call(null,cljs.core.ifn_QMARK_,cljs.core.nil_QMARK_).call(null,xform))){
return null;
} else {
throw (new Error(["Assert failed: ","xform should be a callable function if non-nil.","\n","((some-fn ifn? nil?) xform)"].join('')));
}
});

imcljs.internal.utils.assert_args.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.internal.utils.assert_args.cljs$lang$applyTo = (function (seq6794){
var G__6795 = cljs.core.first.call(null,seq6794);
var seq6794__$1 = cljs.core.next.call(null,seq6794);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6795,seq6794__$1);
});


//# sourceMappingURL=utils.js.map
