// Compiled by ClojureScript 1.10.520 {}
goog.provide('imcljs.save');
goog.require('cljs.core');
goog.require('imcljs.internal.io');
goog.require('imcljs.fetch');
goog.require('imcljs.internal.utils');
goog.require('cljs.core.async');
/**
 * Creates a list using a plain text string of identifiers
 */
imcljs.save.im_list = (function imcljs$save$im_list(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12643 = arguments.length;
var i__4731__auto___12644 = (0);
while(true){
if((i__4731__auto___12644 < len__4730__auto___12643)){
args__4736__auto__.push((arguments[i__4731__auto___12644]));

var G__12645 = (i__4731__auto___12644 + (1));
i__4731__auto___12644 = G__12645;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((4) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((4)),(0),null)):null);
return imcljs.save.im_list.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4737__auto__);
});

imcljs.save.im_list.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,type,identifiers,p__12639){
var vec__12640 = p__12639;
var options = cljs.core.nth.call(null,vec__12640,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post-body","post-body",-1481559189),["/lists?name=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"&type=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join(''),service,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"body","body",-2049205669),identifiers,new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","text/plain"], null)], null));
});

imcljs.save.im_list.cljs$lang$maxFixedArity = (4);

/** @this {Function} */
imcljs.save.im_list.cljs$lang$applyTo = (function (seq12634){
var G__12635 = cljs.core.first.call(null,seq12634);
var seq12634__$1 = cljs.core.next.call(null,seq12634);
var G__12636 = cljs.core.first.call(null,seq12634__$1);
var seq12634__$2 = cljs.core.next.call(null,seq12634__$1);
var G__12637 = cljs.core.first.call(null,seq12634__$2);
var seq12634__$3 = cljs.core.next.call(null,seq12634__$2);
var G__12638 = cljs.core.first.call(null,seq12634__$3);
var seq12634__$4 = cljs.core.next.call(null,seq12634__$3);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12635,G__12636,G__12637,G__12638,seq12634__$4);
});

/**
 * Update an existing list. Currently, only updating the description by specifying
 *   `:newDescription` in the `options` map is supported.
 */
imcljs.save.im_list_update = (function imcljs$save$im_list_update(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12653 = arguments.length;
var i__4731__auto___12654 = (0);
while(true){
if((i__4731__auto___12654 < len__4730__auto___12653)){
args__4736__auto__.push((arguments[i__4731__auto___12654]));

var G__12655 = (i__4731__auto___12654 + (1));
i__4731__auto___12654 = G__12655;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.im_list_update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.im_list_update.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,p__12649){
var vec__12650 = p__12649;
var options = cljs.core.nth.call(null,vec__12650,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"put","put",1299772570),"/lists",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_update.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.im_list_update.cljs$lang$applyTo = (function (seq12646){
var G__12647 = cljs.core.first.call(null,seq12646);
var seq12646__$1 = cljs.core.next.call(null,seq12646);
var G__12648 = cljs.core.first.call(null,seq12646__$1);
var seq12646__$2 = cljs.core.next.call(null,seq12646__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12647,G__12648,seq12646__$2);
});

/**
 * Delete one or name lists.
 */
imcljs.save.im_list_delete = (function imcljs$save$im_list_delete(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12663 = arguments.length;
var i__4731__auto___12664 = (0);
while(true){
if((i__4731__auto___12664 < len__4730__auto___12663)){
args__4736__auto__.push((arguments[i__4731__auto___12664]));

var G__12665 = (i__4731__auto___12664 + (1));
i__4731__auto___12664 = G__12665;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.im_list_delete.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.im_list_delete.cljs$core$IFn$_invoke$arity$variadic = (function (service,names,p__12659){
var vec__12660 = p__12659;
var options = cljs.core.nth.call(null,vec__12660,(0),null);
if(cljs.core.coll_QMARK_.call(null,names)){
return imcljs.internal.utils._LT__LT__BANG_.call(null,cljs.core.map.call(null,((function (vec__12660,options){
return (function (name){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/lists",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});})(vec__12660,options))
,names));
} else {
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/lists",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),names,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
}
});

imcljs.save.im_list_delete.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.im_list_delete.cljs$lang$applyTo = (function (seq12656){
var G__12657 = cljs.core.first.call(null,seq12656);
var seq12656__$1 = cljs.core.next.call(null,seq12656);
var G__12658 = cljs.core.first.call(null,seq12656__$1);
var seq12656__$2 = cljs.core.next.call(null,seq12656__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12657,G__12658,seq12656__$2);
});

imcljs.save.im_list_rename = (function imcljs$save$im_list_rename(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12674 = arguments.length;
var i__4731__auto___12675 = (0);
while(true){
if((i__4731__auto___12675 < len__4730__auto___12674)){
args__4736__auto__.push((arguments[i__4731__auto___12675]));

var G__12676 = (i__4731__auto___12675 + (1));
i__4731__auto___12675 = G__12676;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_rename.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_rename.cljs$core$IFn$_invoke$arity$variadic = (function (service,old_name,new_name,p__12670){
var vec__12671 = p__12670;
var options = cljs.core.nth.call(null,vec__12671,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/lists/rename",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"oldname","oldname",-234488026),old_name,new cljs.core.Keyword(null,"newname","newname",389205813),new_name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_rename.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_rename.cljs$lang$applyTo = (function (seq12666){
var G__12667 = cljs.core.first.call(null,seq12666);
var seq12666__$1 = cljs.core.next.call(null,seq12666);
var G__12668 = cljs.core.first.call(null,seq12666__$1);
var seq12666__$2 = cljs.core.next.call(null,seq12666__$1);
var G__12669 = cljs.core.first.call(null,seq12666__$2);
var seq12666__$3 = cljs.core.next.call(null,seq12666__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12667,G__12668,G__12669,seq12666__$3);
});

imcljs.save.im_list_union = (function imcljs$save$im_list_union(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12685 = arguments.length;
var i__4731__auto___12686 = (0);
while(true){
if((i__4731__auto___12686 < len__4730__auto___12685)){
args__4736__auto__.push((arguments[i__4731__auto___12686]));

var G__12687 = (i__4731__auto___12686 + (1));
i__4731__auto___12686 = G__12687;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_union.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_union.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,lists,p__12681){
var vec__12682 = p__12681;
var options = cljs.core.nth.call(null,vec__12682,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/lists/union",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"lists","lists",-884730684),lists,new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_union.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_union.cljs$lang$applyTo = (function (seq12677){
var G__12678 = cljs.core.first.call(null,seq12677);
var seq12677__$1 = cljs.core.next.call(null,seq12677);
var G__12679 = cljs.core.first.call(null,seq12677__$1);
var seq12677__$2 = cljs.core.next.call(null,seq12677__$1);
var G__12680 = cljs.core.first.call(null,seq12677__$2);
var seq12677__$3 = cljs.core.next.call(null,seq12677__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12678,G__12679,G__12680,seq12677__$3);
});

imcljs.save.im_list_intersect = (function imcljs$save$im_list_intersect(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12696 = arguments.length;
var i__4731__auto___12697 = (0);
while(true){
if((i__4731__auto___12697 < len__4730__auto___12696)){
args__4736__auto__.push((arguments[i__4731__auto___12697]));

var G__12698 = (i__4731__auto___12697 + (1));
i__4731__auto___12697 = G__12698;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_intersect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_intersect.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,lists,p__12692){
var vec__12693 = p__12692;
var options = cljs.core.nth.call(null,vec__12693,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/lists/intersect",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"lists","lists",-884730684),lists,new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_intersect.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_intersect.cljs$lang$applyTo = (function (seq12688){
var G__12689 = cljs.core.first.call(null,seq12688);
var seq12688__$1 = cljs.core.next.call(null,seq12688);
var G__12690 = cljs.core.first.call(null,seq12688__$1);
var seq12688__$2 = cljs.core.next.call(null,seq12688__$1);
var G__12691 = cljs.core.first.call(null,seq12688__$2);
var seq12688__$3 = cljs.core.next.call(null,seq12688__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12689,G__12690,G__12691,seq12688__$3);
});

imcljs.save.im_list_difference = (function imcljs$save$im_list_difference(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12707 = arguments.length;
var i__4731__auto___12708 = (0);
while(true){
if((i__4731__auto___12708 < len__4730__auto___12707)){
args__4736__auto__.push((arguments[i__4731__auto___12708]));

var G__12709 = (i__4731__auto___12708 + (1));
i__4731__auto___12708 = G__12709;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_difference.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_difference.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,lists,p__12703){
var vec__12704 = p__12703;
var options = cljs.core.nth.call(null,vec__12704,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/lists/diff",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"lists","lists",-884730684),lists,new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_difference.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_difference.cljs$lang$applyTo = (function (seq12699){
var G__12700 = cljs.core.first.call(null,seq12699);
var seq12699__$1 = cljs.core.next.call(null,seq12699);
var G__12701 = cljs.core.first.call(null,seq12699__$1);
var seq12699__$2 = cljs.core.next.call(null,seq12699__$1);
var G__12702 = cljs.core.first.call(null,seq12699__$2);
var seq12699__$3 = cljs.core.next.call(null,seq12699__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12700,G__12701,G__12702,seq12699__$3);
});

imcljs.save.im_list_subtraction = (function imcljs$save$im_list_subtraction(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12719 = arguments.length;
var i__4731__auto___12720 = (0);
while(true){
if((i__4731__auto___12720 < len__4730__auto___12719)){
args__4736__auto__.push((arguments[i__4731__auto___12720]));

var G__12721 = (i__4731__auto___12720 + (1));
i__4731__auto___12720 = G__12721;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((4) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((4)),(0),null)):null);
return imcljs.save.im_list_subtraction.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4737__auto__);
});

imcljs.save.im_list_subtraction.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,source_lists,subtract_lists,p__12715){
var vec__12716 = p__12715;
var options = cljs.core.nth.call(null,vec__12716,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/lists/subtract",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"references","references",882562509),source_lists,new cljs.core.Keyword(null,"subtract","subtract",2136988635),subtract_lists,new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_subtraction.cljs$lang$maxFixedArity = (4);

/** @this {Function} */
imcljs.save.im_list_subtraction.cljs$lang$applyTo = (function (seq12710){
var G__12711 = cljs.core.first.call(null,seq12710);
var seq12710__$1 = cljs.core.next.call(null,seq12710);
var G__12712 = cljs.core.first.call(null,seq12710__$1);
var seq12710__$2 = cljs.core.next.call(null,seq12710__$1);
var G__12713 = cljs.core.first.call(null,seq12710__$2);
var seq12710__$3 = cljs.core.next.call(null,seq12710__$2);
var G__12714 = cljs.core.first.call(null,seq12710__$3);
var seq12710__$4 = cljs.core.next.call(null,seq12710__$3);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12711,G__12712,G__12713,G__12714,seq12710__$4);
});

imcljs.save.im_list_from_query = (function imcljs$save$im_list_from_query(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12730 = arguments.length;
var i__4731__auto___12731 = (0);
while(true){
if((i__4731__auto___12731 < len__4730__auto___12730)){
args__4736__auto__.push((arguments[i__4731__auto___12731]));

var G__12732 = (i__4731__auto___12731 + (1));
i__4731__auto___12731 = G__12732;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_from_query.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_from_query.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,query,p__12726){
var vec__12727 = p__12726;
var options = cljs.core.nth.call(null,vec__12727,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/tolist",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_from_query.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_from_query.cljs$lang$applyTo = (function (seq12722){
var G__12723 = cljs.core.first.call(null,seq12722);
var seq12722__$1 = cljs.core.next.call(null,seq12722);
var G__12724 = cljs.core.first.call(null,seq12722__$1);
var seq12722__$2 = cljs.core.next.call(null,seq12722__$1);
var G__12725 = cljs.core.first.call(null,seq12722__$2);
var seq12722__$3 = cljs.core.next.call(null,seq12722__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12723,G__12724,G__12725,seq12722__$3);
});

imcljs.save.im_list_add_tag = (function imcljs$save$im_list_add_tag(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12741 = arguments.length;
var i__4731__auto___12742 = (0);
while(true){
if((i__4731__auto___12742 < len__4730__auto___12741)){
args__4736__auto__.push((arguments[i__4731__auto___12742]));

var G__12743 = (i__4731__auto___12742 + (1));
i__4731__auto___12742 = G__12743;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_add_tag.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_add_tag.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,tags,p__12737){
var vec__12738 = p__12737;
var options = cljs.core.nth.call(null,vec__12738,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/list/tags",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"tags","tags",1771418977),((cljs.core.coll_QMARK_.call(null,tags))?cljs.core.interpose.call(null,";",tags):tags),new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_add_tag.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_add_tag.cljs$lang$applyTo = (function (seq12733){
var G__12734 = cljs.core.first.call(null,seq12733);
var seq12733__$1 = cljs.core.next.call(null,seq12733);
var G__12735 = cljs.core.first.call(null,seq12733__$1);
var seq12733__$2 = cljs.core.next.call(null,seq12733__$1);
var G__12736 = cljs.core.first.call(null,seq12733__$2);
var seq12733__$3 = cljs.core.next.call(null,seq12733__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12734,G__12735,G__12736,seq12733__$3);
});

imcljs.save.im_list_remove_tag = (function imcljs$save$im_list_remove_tag(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12752 = arguments.length;
var i__4731__auto___12753 = (0);
while(true){
if((i__4731__auto___12753 < len__4730__auto___12752)){
args__4736__auto__.push((arguments[i__4731__auto___12753]));

var G__12754 = (i__4731__auto___12753 + (1));
i__4731__auto___12753 = G__12754;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_remove_tag.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_remove_tag.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,tags,p__12748){
var vec__12749 = p__12748;
var options = cljs.core.nth.call(null,vec__12749,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/list/tags",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"tags","tags",1771418977),((cljs.core.coll_QMARK_.call(null,tags))?cljs.core.interpose.call(null,";",tags):tags),new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_remove_tag.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_remove_tag.cljs$lang$applyTo = (function (seq12744){
var G__12745 = cljs.core.first.call(null,seq12744);
var seq12744__$1 = cljs.core.next.call(null,seq12744);
var G__12746 = cljs.core.first.call(null,seq12744__$1);
var seq12744__$2 = cljs.core.next.call(null,seq12744__$1);
var G__12747 = cljs.core.first.call(null,seq12744__$2);
var seq12744__$3 = cljs.core.next.call(null,seq12744__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12745,G__12746,G__12747,seq12744__$3);
});

/**
 * Copy a list by name
 */
imcljs.save.im_list_copy = (function imcljs$save$im_list_copy(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12777 = arguments.length;
var i__4731__auto___12778 = (0);
while(true){
if((i__4731__auto___12778 < len__4730__auto___12777)){
args__4736__auto__.push((arguments[i__4731__auto___12778]));

var G__12779 = (i__4731__auto___12778 + (1));
i__4731__auto___12778 = G__12779;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_copy.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_copy.cljs$core$IFn$_invoke$arity$variadic = (function (service,old_name,new_name,p__12759){
var vec__12760 = p__12759;
var options = cljs.core.nth.call(null,vec__12760,(0),null);
var c__4809__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__4809__auto__,vec__12760,options){
return (function (){
var f__4810__auto__ = (function (){var switch__4714__auto__ = ((function (c__4809__auto__,vec__12760,options){
return (function (state_12771){
var state_val_12772 = (state_12771[(1)]);
if((state_val_12772 === (1))){
var inst_12763 = imcljs.fetch.one_list.call(null,service,old_name);
var state_12771__$1 = state_12771;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12771__$1,(2),inst_12763);
} else {
if((state_val_12772 === (2))){
var inst_12765 = (state_12771[(2)]);
var inst_12766 = imcljs.internal.utils.copy_list_query.call(null,inst_12765);
var inst_12767 = imcljs.save.im_list_from_query.call(null,service,new_name,inst_12766);
var state_12771__$1 = state_12771;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12771__$1,(3),inst_12767);
} else {
if((state_val_12772 === (3))){
var inst_12769 = (state_12771[(2)]);
var state_12771__$1 = state_12771;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12771__$1,inst_12769);
} else {
return null;
}
}
}
});})(c__4809__auto__,vec__12760,options))
;
return ((function (switch__4714__auto__,c__4809__auto__,vec__12760,options){
return (function() {
var imcljs$save$state_machine__4715__auto__ = null;
var imcljs$save$state_machine__4715__auto____0 = (function (){
var statearr_12773 = [null,null,null,null,null,null,null];
(statearr_12773[(0)] = imcljs$save$state_machine__4715__auto__);

(statearr_12773[(1)] = (1));

return statearr_12773;
});
var imcljs$save$state_machine__4715__auto____1 = (function (state_12771){
while(true){
var ret_value__4716__auto__ = (function (){try{while(true){
var result__4717__auto__ = switch__4714__auto__.call(null,state_12771);
if(cljs.core.keyword_identical_QMARK_.call(null,result__4717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__4717__auto__;
}
break;
}
}catch (e12774){if((e12774 instanceof Object)){
var ex__4718__auto__ = e12774;
var statearr_12775_12780 = state_12771;
(statearr_12775_12780[(5)] = ex__4718__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12771);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12774;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__4716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12781 = state_12771;
state_12771 = G__12781;
continue;
} else {
return ret_value__4716__auto__;
}
break;
}
});
imcljs$save$state_machine__4715__auto__ = function(state_12771){
switch(arguments.length){
case 0:
return imcljs$save$state_machine__4715__auto____0.call(this);
case 1:
return imcljs$save$state_machine__4715__auto____1.call(this,state_12771);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
imcljs$save$state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$save$state_machine__4715__auto____0;
imcljs$save$state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$save$state_machine__4715__auto____1;
return imcljs$save$state_machine__4715__auto__;
})()
;})(switch__4714__auto__,c__4809__auto__,vec__12760,options))
})();
var state__4811__auto__ = (function (){var statearr_12776 = f__4810__auto__.call(null);
(statearr_12776[(6)] = c__4809__auto__);

return statearr_12776;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__4811__auto__);
});})(c__4809__auto__,vec__12760,options))
);

return c__4809__auto__;
});

imcljs.save.im_list_copy.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_copy.cljs$lang$applyTo = (function (seq12755){
var G__12756 = cljs.core.first.call(null,seq12755);
var seq12755__$1 = cljs.core.next.call(null,seq12755);
var G__12757 = cljs.core.first.call(null,seq12755__$1);
var seq12755__$2 = cljs.core.next.call(null,seq12755__$1);
var G__12758 = cljs.core.first.call(null,seq12755__$2);
var seq12755__$3 = cljs.core.next.call(null,seq12755__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12756,G__12757,G__12758,seq12755__$3);
});

/**
 * Set the preferences for the authenticated user by passing a map.
 *   Note that none of the values can be an empty string. For that you'll have to
 *   use `delete-preference` instead.
 */
imcljs.save.preferences = (function imcljs$save$preferences(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12789 = arguments.length;
var i__4731__auto___12790 = (0);
while(true){
if((i__4731__auto___12790 < len__4730__auto___12789)){
args__4736__auto__.push((arguments[i__4731__auto___12790]));

var G__12791 = (i__4731__auto___12790 + (1));
i__4731__auto___12790 = G__12791;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.preferences.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.preferences.cljs$core$IFn$_invoke$arity$variadic = (function (service,preferences,p__12785){
var vec__12786 = p__12785;
var options = cljs.core.nth.call(null,vec__12786,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/user/preferences",service,cljs.core.merge.call(null,preferences,options),new cljs.core.Keyword(null,"preferences","preferences",-484312211));
});

imcljs.save.preferences.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.preferences.cljs$lang$applyTo = (function (seq12782){
var G__12783 = cljs.core.first.call(null,seq12782);
var seq12782__$1 = cljs.core.next.call(null,seq12782);
var G__12784 = cljs.core.first.call(null,seq12782__$1);
var seq12782__$2 = cljs.core.next.call(null,seq12782__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12783,G__12784,seq12782__$2);
});

/**
 * Delete a single stored preference by key for the authenticated user.
 */
imcljs.save.delete_preference = (function imcljs$save$delete_preference(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12799 = arguments.length;
var i__4731__auto___12800 = (0);
while(true){
if((i__4731__auto___12800 < len__4730__auto___12799)){
args__4736__auto__.push((arguments[i__4731__auto___12800]));

var G__12801 = (i__4731__auto___12800 + (1));
i__4731__auto___12800 = G__12801;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.delete_preference.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.delete_preference.cljs$core$IFn$_invoke$arity$variadic = (function (service,preference,p__12795){
var vec__12796 = p__12795;
var options = cljs.core.nth.call(null,vec__12796,(0),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),preference], null),options);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/user/preferences",service,params,new cljs.core.Keyword(null,"preferences","preferences",-484312211));
});

imcljs.save.delete_preference.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.delete_preference.cljs$lang$applyTo = (function (seq12792){
var G__12793 = cljs.core.first.call(null,seq12792);
var seq12792__$1 = cljs.core.next.call(null,seq12792);
var G__12794 = cljs.core.first.call(null,seq12792__$1);
var seq12792__$2 = cljs.core.next.call(null,seq12792__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12793,G__12794,seq12792__$2);
});

/**
 * Upload a query to be saved into the user's profile.
 *   As of InterMine 4.1.2, the webservice returns an invalid JSON response, hence
 *   why we use `:format 'text'` and no xform.
 */
imcljs.save.query = (function imcljs$save$query(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12809 = arguments.length;
var i__4731__auto___12810 = (0);
while(true){
if((i__4731__auto___12810 < len__4730__auto___12809)){
args__4736__auto__.push((arguments[i__4731__auto___12810]));

var G__12811 = (i__4731__auto___12810 + (1));
i__4731__auto___12810 = G__12811;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.query.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.query.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__12805){
var vec__12806 = p__12805;
var options = cljs.core.nth.call(null,vec__12806,(0),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"text"], null),options);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/user/queries",service,params);
});

imcljs.save.query.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.query.cljs$lang$applyTo = (function (seq12802){
var G__12803 = cljs.core.first.call(null,seq12802);
var seq12802__$1 = cljs.core.next.call(null,seq12802);
var G__12804 = cljs.core.first.call(null,seq12802__$1);
var seq12802__$2 = cljs.core.next.call(null,seq12802__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12803,G__12804,seq12802__$2);
});

/**
 * Delete a query that has previously been saved into the user's profile.
 */
imcljs.save.delete_query = (function imcljs$save$delete_query(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12819 = arguments.length;
var i__4731__auto___12820 = (0);
while(true){
if((i__4731__auto___12820 < len__4730__auto___12819)){
args__4736__auto__.push((arguments[i__4731__auto___12820]));

var G__12821 = (i__4731__auto___12820 + (1));
i__4731__auto___12820 = G__12821;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.delete_query.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.delete_query.cljs$core$IFn$_invoke$arity$variadic = (function (service,title,p__12815){
var vec__12816 = p__12815;
var options = cljs.core.nth.call(null,vec__12816,(0),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),title], null),options);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/user/queries",service,params);
});

imcljs.save.delete_query.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.delete_query.cljs$lang$applyTo = (function (seq12812){
var G__12813 = cljs.core.first.call(null,seq12812);
var seq12812__$1 = cljs.core.next.call(null,seq12812);
var G__12814 = cljs.core.first.call(null,seq12812__$1);
var seq12812__$2 = cljs.core.next.call(null,seq12812__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12813,G__12814,seq12812__$2);
});


//# sourceMappingURL=save.js.map
