// Compiled by ClojureScript 1.10.520 {}
goog.provide('imcljs.internal.utils');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
imcljs.internal.utils.does_not_contain_QMARK_ = cljs.core.complement.call(null,cljs.core.contains_QMARK_);
imcljs.internal.utils.one_of_QMARK_ = (function imcljs$internal$utils$one_of_QMARK_(haystack,needle){
return (!((cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([needle]),haystack) == null)));
});
imcljs.internal.utils.missing_http_QMARK__ = (function imcljs$internal$utils$missing_http_QMARK__(val){
return cljs.core.not.call(null,cljs.core.re_find.call(null,/^https?:\/\//,val));
});
imcljs.internal.utils.missing_service_QMARK__ = (function imcljs$internal$utils$missing_service_QMARK__(val){
return cljs.core.not.call(null,cljs.core.re_find.call(null,/\/service$/,val));
});
imcljs.internal.utils.append_ = (function imcljs$internal$utils$append_(text,val){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(val),cljs.core.str.cljs$core$IFn$_invoke$arity$1(text)].join('');
});
imcljs.internal.utils.alphabet = cljs.core.apply.call(null,cljs.core.sorted_set,clojure.string.split.call(null,"ABCDEFGHIJKLMNOPQRSTUVWXYZ",(new RegExp(""))));
/**
 * Ensures that a url starts with an http protocol and ends with /service
 */
imcljs.internal.utils.scrub_url = (function imcljs$internal$utils$scrub_url(url){
var G__10595 = url;
var G__10595__$1 = ((imcljs.internal.utils.missing_http_QMARK__.call(null,url))?["https://",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__10595)].join(''):G__10595);
if(imcljs.internal.utils.missing_service_QMARK__.call(null,url)){
return imcljs.internal.utils.append_.call(null,"/service",G__10595__$1);
} else {
return G__10595__$1;
}
});
imcljs.internal.utils.copy_list_query = (function imcljs$internal$utils$copy_list_query(p__10596){
var map__10597 = p__10596;
var map__10597__$1 = (((((!((map__10597 == null))))?(((((map__10597.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10597.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10597):map__10597);
var old_list_details = map__10597__$1;
var old_list_name = cljs.core.get.call(null,map__10597__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var old_list_type = cljs.core.get.call(null,map__10597__$1,new cljs.core.Keyword(null,"type","type",1174270348));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"from","from",1815293044),old_list_type,new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str.cljs$core$IFn$_invoke$arity$1(old_list_type),".id"].join('')], null),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"path","path",-188191168),old_list_type,new cljs.core.Keyword(null,"op","op",-1882987955),"IN",new cljs.core.Keyword(null,"value","value",305978217),old_list_name], null)], null)], null);
});
/**
 * Given a collection of channels, returns a collection containing
 *   the first result of each channel (similiar to JS Promise.all)
 */
imcljs.internal.utils._LT__LT__BANG_ = (function imcljs$internal$utils$_LT__LT__BANG_(chans){
var c__6791__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6791__auto__){
return (function (){
var f__6792__auto__ = (function (){var switch__6624__auto__ = ((function (c__6791__auto__){
return (function (state_10617){
var state_val_10618 = (state_10617[(1)]);
if((state_val_10618 === (1))){
var inst_10599 = cljs.core.List.EMPTY;
var inst_10600 = inst_10599;
var inst_10601 = chans;
var state_10617__$1 = (function (){var statearr_10619 = state_10617;
(statearr_10619[(7)] = inst_10601);

(statearr_10619[(8)] = inst_10600);

return statearr_10619;
})();
var statearr_10620_10631 = state_10617__$1;
(statearr_10620_10631[(2)] = null);

(statearr_10620_10631[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10618 === (2))){
var inst_10601 = (state_10617[(7)]);
var inst_10603 = cljs.core.seq.call(null,inst_10601);
var state_10617__$1 = state_10617;
if(inst_10603){
var statearr_10621_10632 = state_10617__$1;
(statearr_10621_10632[(1)] = (4));

} else {
var statearr_10622_10633 = state_10617__$1;
(statearr_10622_10633[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10618 === (3))){
var inst_10615 = (state_10617[(2)]);
var state_10617__$1 = state_10617;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10617__$1,inst_10615);
} else {
if((state_val_10618 === (4))){
var inst_10601 = (state_10617[(7)]);
var inst_10605 = cljs.core.first.call(null,inst_10601);
var state_10617__$1 = state_10617;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10617__$1,(7),inst_10605);
} else {
if((state_val_10618 === (5))){
var inst_10600 = (state_10617[(8)]);
var state_10617__$1 = state_10617;
var statearr_10623_10634 = state_10617__$1;
(statearr_10623_10634[(2)] = inst_10600);

(statearr_10623_10634[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10618 === (6))){
var inst_10613 = (state_10617[(2)]);
var state_10617__$1 = state_10617;
var statearr_10624_10635 = state_10617__$1;
(statearr_10624_10635[(2)] = inst_10613);

(statearr_10624_10635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10618 === (7))){
var inst_10601 = (state_10617[(7)]);
var inst_10600 = (state_10617[(8)]);
var inst_10607 = (state_10617[(2)]);
var inst_10608 = cljs.core.conj.call(null,inst_10600,inst_10607);
var inst_10609 = cljs.core.rest.call(null,inst_10601);
var inst_10600__$1 = inst_10608;
var inst_10601__$1 = inst_10609;
var state_10617__$1 = (function (){var statearr_10625 = state_10617;
(statearr_10625[(7)] = inst_10601__$1);

(statearr_10625[(8)] = inst_10600__$1);

return statearr_10625;
})();
var statearr_10626_10636 = state_10617__$1;
(statearr_10626_10636[(2)] = null);

(statearr_10626_10636[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__6791__auto__))
;
return ((function (switch__6624__auto__,c__6791__auto__){
return (function() {
var imcljs$internal$utils$_LT__LT__BANG__$_state_machine__6625__auto__ = null;
var imcljs$internal$utils$_LT__LT__BANG__$_state_machine__6625__auto____0 = (function (){
var statearr_10627 = [null,null,null,null,null,null,null,null,null];
(statearr_10627[(0)] = imcljs$internal$utils$_LT__LT__BANG__$_state_machine__6625__auto__);

(statearr_10627[(1)] = (1));

return statearr_10627;
});
var imcljs$internal$utils$_LT__LT__BANG__$_state_machine__6625__auto____1 = (function (state_10617){
while(true){
var ret_value__6626__auto__ = (function (){try{while(true){
var result__6627__auto__ = switch__6624__auto__.call(null,state_10617);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6627__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6627__auto__;
}
break;
}
}catch (e10628){if((e10628 instanceof Object)){
var ex__6628__auto__ = e10628;
var statearr_10629_10637 = state_10617;
(statearr_10629_10637[(5)] = ex__6628__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10617);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10628;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6626__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10638 = state_10617;
state_10617 = G__10638;
continue;
} else {
return ret_value__6626__auto__;
}
break;
}
});
imcljs$internal$utils$_LT__LT__BANG__$_state_machine__6625__auto__ = function(state_10617){
switch(arguments.length){
case 0:
return imcljs$internal$utils$_LT__LT__BANG__$_state_machine__6625__auto____0.call(this);
case 1:
return imcljs$internal$utils$_LT__LT__BANG__$_state_machine__6625__auto____1.call(this,state_10617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
imcljs$internal$utils$_LT__LT__BANG__$_state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$internal$utils$_LT__LT__BANG__$_state_machine__6625__auto____0;
imcljs$internal$utils$_LT__LT__BANG__$_state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$internal$utils$_LT__LT__BANG__$_state_machine__6625__auto____1;
return imcljs$internal$utils$_LT__LT__BANG__$_state_machine__6625__auto__;
})()
;})(switch__6624__auto__,c__6791__auto__))
})();
var state__6793__auto__ = (function (){var statearr_10630 = f__6792__auto__.call(null);
(statearr_10630[(6)] = c__6791__auto__);

return statearr_10630;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6793__auto__);
});})(c__6791__auto__))
);

return c__6791__auto__;
});
imcljs.internal.utils.assert_args = (function imcljs$internal$utils$assert_args(var_args){
var args__4736__auto__ = [];
var len__4730__auto___10648 = arguments.length;
var i__4731__auto___10649 = (0);
while(true){
if((i__4731__auto___10649 < len__4730__auto___10648)){
args__4736__auto__.push((arguments[i__4731__auto___10649]));

var G__10650 = (i__4731__auto___10649 + (1));
i__4731__auto___10649 = G__10650;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.internal.utils.assert_args.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.internal.utils.assert_args.cljs$core$IFn$_invoke$arity$variadic = (function (method,args){
var vec__10641 = (function (){var G__10647 = args;
if(cljs.core._EQ_.call(null,method,new cljs.core.Keyword(null,"raw","raw",1604651272))){
return cljs.core.drop.call(null,(1),G__10647);
} else {
return G__10647;
}
})();
var seq__10642 = cljs.core.seq.call(null,vec__10641);
var first__10643 = cljs.core.first.call(null,seq__10642);
var seq__10642__$1 = cljs.core.next.call(null,seq__10642);
var path = first__10643;
var first__10643__$1 = cljs.core.first.call(null,seq__10642__$1);
var seq__10642__$2 = cljs.core.next.call(null,seq__10642__$1);
var service = first__10643__$1;
var first__10643__$2 = cljs.core.first.call(null,seq__10642__$2);
var seq__10642__$3 = cljs.core.next.call(null,seq__10642__$2);
var options = first__10643__$2;
var vec__10644 = seq__10642__$3;
var xform = cljs.core.nth.call(null,vec__10644,(0),null);
if(cljs.core.truth_(cljs.core.every_pred.call(null,cljs.core.string_QMARK_,cljs.core.not_empty).call(null,path))){
} else {
throw (new Error(["Assert failed: ","path should be a non-empty string.","\n","((every-pred string? not-empty) path)"].join('')));
}

if(cljs.core.truth_(cljs.core.every_pred.call(null,cljs.core.string_QMARK_,cljs.core.not_empty).call(null,new cljs.core.Keyword(null,"root","root",-448657453).cljs$core$IFn$_invoke$arity$1(service)))){
} else {
throw (new Error(["Assert failed: ","service should always have a root URL.","\n","((every-pred string? not-empty) (:root service))"].join('')));
}

if(cljs.core.truth_(cljs.core.some_fn.call(null,cljs.core.map_QMARK_,cljs.core.nil_QMARK_).call(null,options))){
} else {
throw (new Error(["Assert failed: ","options should be a map if non-nil.","\n","((some-fn map? nil?) options)"].join('')));
}

if(cljs.core.truth_(cljs.core.some_fn.call(null,cljs.core.ifn_QMARK_,cljs.core.nil_QMARK_).call(null,xform))){
return null;
} else {
throw (new Error(["Assert failed: ","xform should be a callable function if non-nil.","\n","((some-fn ifn? nil?) xform)"].join('')));
}
});

imcljs.internal.utils.assert_args.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.internal.utils.assert_args.cljs$lang$applyTo = (function (seq10639){
var G__10640 = cljs.core.first.call(null,seq10639);
var seq10639__$1 = cljs.core.next.call(null,seq10639);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__10640,seq10639__$1);
});


//# sourceMappingURL=utils.js.map
