// Compiled by ClojureScript 1.10.520 {}
goog.provide('imcljs.auth');
goog.require('cljs.core');
goog.require('imcljs.internal.io');
goog.require('cljs.core.async');
/**
 * Given a username and a password return an API token
 */
imcljs.auth.basic_auth = (function imcljs$auth$basic_auth(service,username,password){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"raw","raw",1604651272),new cljs.core.Keyword(null,"get","get",1683182755),"/user/tokens?type=api",service,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222),false,new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"password","password",417022471),password], null)], null),cljs.core.comp.call(null,new cljs.core.Keyword(null,"token","token",-1211463215),cljs.core.first,new cljs.core.Keyword(null,"tokens","tokens",-818939304)));
});
/**
 * Login the user using their username and password. Returns their new API token.
 *   If :token is present in `service`, it will get added to the Authorization header
 *   so that the anonymously saved lists gets merged into the users account.
 */
imcljs.auth.login = (function imcljs$auth$login(service,username,password){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/login",service,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"password","password",417022471),password], null));
});
/**
 * Logout the authenticated user, invalidating the token provided in their
 *   Authorization header.
 */
imcljs.auth.logout = (function imcljs$auth$logout(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/logout",service,cljs.core.PersistentArrayMap.EMPTY);
});
/**
 * Given a token return user information
 */
imcljs.auth.who_am_i_QMARK_ = (function imcljs$auth$who_am_i_QMARK_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___7978 = arguments.length;
var i__4731__auto___7979 = (0);
while(true){
if((i__4731__auto___7979 < len__4730__auto___7978)){
args__4736__auto__.push((arguments[i__4731__auto___7979]));

var G__7980 = (i__4731__auto___7979 + (1));
i__4731__auto___7979 = G__7980;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.auth.who_am_i_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.auth.who_am_i_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (service,token,p__7974){
var vec__7975 = p__7974;
var options = cljs.core.nth.call(null,vec__7975,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/user/whoami",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"token","token",-1211463215),token], null),options),new cljs.core.Keyword(null,"user","user",1532431356));
});

imcljs.auth.who_am_i_QMARK_.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.auth.who_am_i_QMARK_.cljs$lang$applyTo = (function (seq7971){
var G__7972 = cljs.core.first.call(null,seq7971);
var seq7971__$1 = cljs.core.next.call(null,seq7971);
var G__7973 = cljs.core.first.call(null,seq7971__$1);
var seq7971__$2 = cljs.core.next.call(null,seq7971__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7972,G__7973,seq7971__$2);
});

/**
 * Changes the password of an authenticated user.
 */
imcljs.auth.change_password = (function imcljs$auth$change_password(service,old_password,new_password){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/user",service,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"oldPassword","oldPassword",1953853561),old_password,new cljs.core.Keyword(null,"newPassword","newPassword",98419003),new_password], null));
});
/**
 * Register a new user account.
 */
imcljs.auth.register = (function imcljs$auth$register(var_args){
var args__4736__auto__ = [];
var len__4730__auto___7989 = arguments.length;
var i__4731__auto___7990 = (0);
while(true){
if((i__4731__auto___7990 < len__4730__auto___7989)){
args__4736__auto__.push((arguments[i__4731__auto___7990]));

var G__7991 = (i__4731__auto___7990 + (1));
i__4731__auto___7990 = G__7991;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.auth.register.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.auth.register.cljs$core$IFn$_invoke$arity$variadic = (function (service,username,password,p__7985){
var vec__7986 = p__7985;
var options = cljs.core.nth.call(null,vec__7986,(0),null);
var params = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),username,new cljs.core.Keyword(null,"password","password",417022471),password], null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/users",service,cljs.core.merge.call(null,params,options),new cljs.core.Keyword(null,"user","user",1532431356));
});

imcljs.auth.register.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.auth.register.cljs$lang$applyTo = (function (seq7981){
var G__7982 = cljs.core.first.call(null,seq7981);
var seq7981__$1 = cljs.core.next.call(null,seq7981);
var G__7983 = cljs.core.first.call(null,seq7981__$1);
var seq7981__$2 = cljs.core.next.call(null,seq7981__$1);
var G__7984 = cljs.core.first.call(null,seq7981__$2);
var seq7981__$3 = cljs.core.next.call(null,seq7981__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7982,G__7983,G__7984,seq7981__$3);
});

/**
 * Creates a deregistration token which is to be passed to `delete-account`.
 */
imcljs.auth.deregistration = (function imcljs$auth$deregistration(var_args){
var args__4736__auto__ = [];
var len__4730__auto___7998 = arguments.length;
var i__4731__auto___7999 = (0);
while(true){
if((i__4731__auto___7999 < len__4730__auto___7998)){
args__4736__auto__.push((arguments[i__4731__auto___7999]));

var G__8000 = (i__4731__auto___7999 + (1));
i__4731__auto___7999 = G__8000;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.auth.deregistration.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.auth.deregistration.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__7994){
var vec__7995 = p__7994;
var options = cljs.core.nth.call(null,vec__7995,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/user/deregistration",service,options,new cljs.core.Keyword(null,"token","token",-1211463215));
});

imcljs.auth.deregistration.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.auth.deregistration.cljs$lang$applyTo = (function (seq7992){
var G__7993 = cljs.core.first.call(null,seq7992);
var seq7992__$1 = cljs.core.next.call(null,seq7992);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7993,seq7992__$1);
});

/**
 * Takes a `deregistration` token to delete the authenticated user.
 */
imcljs.auth.delete_account = (function imcljs$auth$delete_account(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8008 = arguments.length;
var i__4731__auto___8009 = (0);
while(true){
if((i__4731__auto___8009 < len__4730__auto___8008)){
args__4736__auto__.push((arguments[i__4731__auto___8009]));

var G__8010 = (i__4731__auto___8009 + (1));
i__4731__auto___8009 = G__8010;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.auth.delete_account.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.auth.delete_account.cljs$core$IFn$_invoke$arity$variadic = (function (service,deregistration_token,p__8004){
var vec__8005 = p__8004;
var options = cljs.core.nth.call(null,vec__8005,(0),null);
var params = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"deregistrationToken","deregistrationToken",987569265),deregistration_token], null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/user",service,cljs.core.merge.call(null,params,options));
});

imcljs.auth.delete_account.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.auth.delete_account.cljs$lang$applyTo = (function (seq8001){
var G__8002 = cljs.core.first.call(null,seq8001);
var seq8001__$1 = cljs.core.next.call(null,seq8001);
var G__8003 = cljs.core.first.call(null,seq8001__$1);
var seq8001__$2 = cljs.core.next.call(null,seq8001__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8002,G__8003,seq8001__$2);
});


//# sourceMappingURL=auth.js.map
