// Compiled by ClojureScript 1.10.520 {}
goog.provide('imcljs.auth');
goog.require('cljs.core');
goog.require('imcljs.internal.io');
goog.require('cljs.core.async');
/**
 * Given a username and a password return an API token
 */
imcljs.auth.basic_auth = (function imcljs$auth$basic_auth(service,username,password){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"raw","raw",1604651272),new cljs.core.Keyword(null,"get","get",1683182755),"/user/tokens?type=api",service,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222),false,new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"password","password",417022471),password], null)], null),cljs.core.comp.call(null,new cljs.core.Keyword(null,"token","token",-1211463215),cljs.core.first,new cljs.core.Keyword(null,"tokens","tokens",-818939304)));
});
/**
 * Login the user using their username and password. Returns their new API token.
 *   If :token is present in `service`, it will get added to the Authorization header
 *   so that the anonymously saved lists gets merged into the users account.
 */
imcljs.auth.login = (function imcljs$auth$login(service,username,password){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/login",service,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"password","password",417022471),password], null));
});
/**
 * Logout the authenticated user, invalidating the token provided in their
 *   Authorization header.
 */
imcljs.auth.logout = (function imcljs$auth$logout(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/logout",service,cljs.core.PersistentArrayMap.EMPTY);
});
/**
 * Given a token return user information
 */
imcljs.auth.who_am_i_QMARK_ = (function imcljs$auth$who_am_i_QMARK_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___13963 = arguments.length;
var i__4731__auto___13964 = (0);
while(true){
if((i__4731__auto___13964 < len__4730__auto___13963)){
args__4736__auto__.push((arguments[i__4731__auto___13964]));

var G__13965 = (i__4731__auto___13964 + (1));
i__4731__auto___13964 = G__13965;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.auth.who_am_i_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.auth.who_am_i_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (service,token,p__13959){
var vec__13960 = p__13959;
var options = cljs.core.nth.call(null,vec__13960,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/user/whoami",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"token","token",-1211463215),token], null),options),new cljs.core.Keyword(null,"user","user",1532431356));
});

imcljs.auth.who_am_i_QMARK_.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.auth.who_am_i_QMARK_.cljs$lang$applyTo = (function (seq13956){
var G__13957 = cljs.core.first.call(null,seq13956);
var seq13956__$1 = cljs.core.next.call(null,seq13956);
var G__13958 = cljs.core.first.call(null,seq13956__$1);
var seq13956__$2 = cljs.core.next.call(null,seq13956__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__13957,G__13958,seq13956__$2);
});

/**
 * Changes the password of an authenticated user.
 */
imcljs.auth.change_password = (function imcljs$auth$change_password(service,old_password,new_password){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/user",service,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"oldPassword","oldPassword",1953853561),old_password,new cljs.core.Keyword(null,"newPassword","newPassword",98419003),new_password], null));
});
/**
 * Register a new user account.
 */
imcljs.auth.register = (function imcljs$auth$register(var_args){
var args__4736__auto__ = [];
var len__4730__auto___13974 = arguments.length;
var i__4731__auto___13975 = (0);
while(true){
if((i__4731__auto___13975 < len__4730__auto___13974)){
args__4736__auto__.push((arguments[i__4731__auto___13975]));

var G__13976 = (i__4731__auto___13975 + (1));
i__4731__auto___13975 = G__13976;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.auth.register.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.auth.register.cljs$core$IFn$_invoke$arity$variadic = (function (service,username,password,p__13970){
var vec__13971 = p__13970;
var options = cljs.core.nth.call(null,vec__13971,(0),null);
var params = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),username,new cljs.core.Keyword(null,"password","password",417022471),password], null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/users",service,cljs.core.merge.call(null,params,options),new cljs.core.Keyword(null,"user","user",1532431356));
});

imcljs.auth.register.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.auth.register.cljs$lang$applyTo = (function (seq13966){
var G__13967 = cljs.core.first.call(null,seq13966);
var seq13966__$1 = cljs.core.next.call(null,seq13966);
var G__13968 = cljs.core.first.call(null,seq13966__$1);
var seq13966__$2 = cljs.core.next.call(null,seq13966__$1);
var G__13969 = cljs.core.first.call(null,seq13966__$2);
var seq13966__$3 = cljs.core.next.call(null,seq13966__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__13967,G__13968,G__13969,seq13966__$3);
});

/**
 * Creates a deregistration token which is to be passed to `delete-account`.
 */
imcljs.auth.deregistration = (function imcljs$auth$deregistration(var_args){
var args__4736__auto__ = [];
var len__4730__auto___13983 = arguments.length;
var i__4731__auto___13984 = (0);
while(true){
if((i__4731__auto___13984 < len__4730__auto___13983)){
args__4736__auto__.push((arguments[i__4731__auto___13984]));

var G__13985 = (i__4731__auto___13984 + (1));
i__4731__auto___13984 = G__13985;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.auth.deregistration.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.auth.deregistration.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__13979){
var vec__13980 = p__13979;
var options = cljs.core.nth.call(null,vec__13980,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/user/deregistration",service,options,new cljs.core.Keyword(null,"token","token",-1211463215));
});

imcljs.auth.deregistration.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.auth.deregistration.cljs$lang$applyTo = (function (seq13977){
var G__13978 = cljs.core.first.call(null,seq13977);
var seq13977__$1 = cljs.core.next.call(null,seq13977);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__13978,seq13977__$1);
});

/**
 * Takes a `deregistration` token to delete the authenticated user.
 */
imcljs.auth.delete_account = (function imcljs$auth$delete_account(var_args){
var args__4736__auto__ = [];
var len__4730__auto___13993 = arguments.length;
var i__4731__auto___13994 = (0);
while(true){
if((i__4731__auto___13994 < len__4730__auto___13993)){
args__4736__auto__.push((arguments[i__4731__auto___13994]));

var G__13995 = (i__4731__auto___13994 + (1));
i__4731__auto___13994 = G__13995;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.auth.delete_account.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.auth.delete_account.cljs$core$IFn$_invoke$arity$variadic = (function (service,deregistration_token,p__13989){
var vec__13990 = p__13989;
var options = cljs.core.nth.call(null,vec__13990,(0),null);
var params = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"deregistrationToken","deregistrationToken",987569265),deregistration_token], null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/user",service,cljs.core.merge.call(null,params,options));
});

imcljs.auth.delete_account.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.auth.delete_account.cljs$lang$applyTo = (function (seq13986){
var G__13987 = cljs.core.first.call(null,seq13986);
var seq13986__$1 = cljs.core.next.call(null,seq13986);
var G__13988 = cljs.core.first.call(null,seq13986__$1);
var seq13986__$2 = cljs.core.next.call(null,seq13986__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__13987,G__13988,seq13986__$2);
});

/**
 * Commence authentication for logging in using OAuth 2.0 with specified
 *   provider.  Will return a URL to redirect to the external login page.
 *   Remember to append a `redirect_uri` parameter to the URL before redirecting.
 *   This should be an endpoint which will be redirected to after signing in at
 *   the third-party, passing parameters required for the `oauth2callback`.
 *   Note that the redirect URL might be checked against a whitelist.
 */
imcljs.auth.oauth2authenticator = (function imcljs$auth$oauth2authenticator(var_args){
var args__4736__auto__ = [];
var len__4730__auto___14003 = arguments.length;
var i__4731__auto___14004 = (0);
while(true){
if((i__4731__auto___14004 < len__4730__auto___14003)){
args__4736__auto__.push((arguments[i__4731__auto___14004]));

var G__14005 = (i__4731__auto___14004 + (1));
i__4731__auto___14004 = G__14005;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.auth.oauth2authenticator.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.auth.oauth2authenticator.cljs$core$IFn$_invoke$arity$variadic = (function (service,provider,p__13999){
var vec__14000 = p__13999;
var options = cljs.core.nth.call(null,vec__14000,(0),null);
var params = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"provider","provider",-302056900),provider], null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/oauth2authenticator",service,cljs.core.merge.call(null,params,options),new cljs.core.Keyword(null,"link","link",-1769163468));
});

imcljs.auth.oauth2authenticator.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.auth.oauth2authenticator.cljs$lang$applyTo = (function (seq13996){
var G__13997 = cljs.core.first.call(null,seq13996);
var seq13996__$1 = cljs.core.next.call(null,seq13996);
var G__13998 = cljs.core.first.call(null,seq13996__$1);
var seq13996__$2 = cljs.core.next.call(null,seq13996__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__13997,G__13998,seq13996__$2);
});

/**
 * Complete authentication for logging in using OAuth 2.0. Requires parameters
 *   state and code, which are received when redirecting back from the external
 *   login service in `oauth2authenticator`, in addition to provider which should
 *   be identical to the one passed to `oauth2authenticator`.
 */
imcljs.auth.oauth2callback = (function imcljs$auth$oauth2callback(var_args){
var args__4736__auto__ = [];
var len__4730__auto___14012 = arguments.length;
var i__4731__auto___14013 = (0);
while(true){
if((i__4731__auto___14013 < len__4730__auto___14012)){
args__4736__auto__.push((arguments[i__4731__auto___14013]));

var G__14014 = (i__4731__auto___14013 + (1));
i__4731__auto___14013 = G__14014;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.auth.oauth2callback.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.auth.oauth2callback.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__14008){
var vec__14009 = p__14008;
var options = cljs.core.nth.call(null,vec__14009,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/oauth2callback",service,options);
});

imcljs.auth.oauth2callback.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.auth.oauth2callback.cljs$lang$applyTo = (function (seq14006){
var G__14007 = cljs.core.first.call(null,seq14006);
var seq14006__$1 = cljs.core.next.call(null,seq14006);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14007,seq14006__$1);
});


//# sourceMappingURL=auth.js.map
