// Compiled by ClojureScript 1.10.520 {}
goog.provide('imcljs.fetch');
goog.require('cljs.core');
goog.require('imcljs.internal.io');
goog.require('imcljs.query');
goog.require('cljs.core.async');
/**
 * Returns quicksearch results.
 */
imcljs.fetch.quicksearch = (function imcljs$fetch$quicksearch(var_args){
var args__4736__auto__ = [];
var len__4730__auto___14043 = arguments.length;
var i__4731__auto___14044 = (0);
while(true){
if((i__4731__auto___14044 < len__4730__auto___14043)){
args__4736__auto__.push((arguments[i__4731__auto___14044]));

var G__14045 = (i__4731__auto___14044 + (1));
i__4731__auto___14044 = G__14045;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.quicksearch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.quicksearch.cljs$core$IFn$_invoke$arity$variadic = (function (service,search_term,p__14039){
var vec__14040 = p__14039;
var options = cljs.core.nth.call(null,vec__14040,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/search",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"q","q",689001697),search_term], null),options));
});

imcljs.fetch.quicksearch.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.quicksearch.cljs$lang$applyTo = (function (seq14036){
var G__14037 = cljs.core.first.call(null,seq14036);
var seq14036__$1 = cljs.core.next.call(null,seq14036);
var G__14038 = cljs.core.first.call(null,seq14036__$1);
var seq14036__$2 = cljs.core.next.call(null,seq14036__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14037,G__14038,seq14036__$2);
});

imcljs.fetch.table_rows = (function imcljs$fetch$table_rows(var_args){
var args__4736__auto__ = [];
var len__4730__auto___14053 = arguments.length;
var i__4731__auto___14054 = (0);
while(true){
if((i__4731__auto___14054 < len__4730__auto___14053)){
args__4736__auto__.push((arguments[i__4731__auto___14054]));

var G__14055 = (i__4731__auto___14054 + (1));
i__4731__auto___14054 = G__14055;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.table_rows.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.table_rows.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__14049){
var vec__14050 = p__14049;
var options = cljs.core.nth.call(null,vec__14050,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results/tablerows",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query","query",-1288509510),query], null),options));
});

imcljs.fetch.table_rows.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.table_rows.cljs$lang$applyTo = (function (seq14046){
var G__14047 = cljs.core.first.call(null,seq14046);
var seq14046__$1 = cljs.core.next.call(null,seq14046);
var G__14048 = cljs.core.first.call(null,seq14046__$1);
var seq14046__$2 = cljs.core.next.call(null,seq14046__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14047,G__14048,seq14046__$2);
});

imcljs.fetch.fasta = (function imcljs$fetch$fasta(var_args){
var args__4736__auto__ = [];
var len__4730__auto___14063 = arguments.length;
var i__4731__auto___14064 = (0);
while(true){
if((i__4731__auto___14064 < len__4730__auto___14063)){
args__4736__auto__.push((arguments[i__4731__auto___14064]));

var G__14065 = (i__4731__auto___14064 + (1));
i__4731__auto___14064 = G__14065;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.fasta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.fasta.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__14059){
var vec__14060 = p__14059;
var options = cljs.core.nth.call(null,vec__14060,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results/fasta",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query","query",-1288509510),query], null),options));
});

imcljs.fetch.fasta.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.fasta.cljs$lang$applyTo = (function (seq14056){
var G__14057 = cljs.core.first.call(null,seq14056);
var seq14056__$1 = cljs.core.next.call(null,seq14056);
var G__14058 = cljs.core.first.call(null,seq14056__$1);
var seq14056__$2 = cljs.core.next.call(null,seq14056__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14057,G__14058,seq14056__$2);
});

imcljs.fetch.fetch_custom_format = (function imcljs$fetch$fetch_custom_format(var_args){
var args__4736__auto__ = [];
var len__4730__auto___14073 = arguments.length;
var i__4731__auto___14074 = (0);
while(true){
if((i__4731__auto___14074 < len__4730__auto___14073)){
args__4736__auto__.push((arguments[i__4731__auto___14074]));

var G__14075 = (i__4731__auto___14074 + (1));
i__4731__auto___14074 = G__14075;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.fetch_custom_format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.fetch_custom_format.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__14069){
var vec__14070 = p__14069;
var options = cljs.core.nth.call(null,vec__14070,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query","query",-1288509510),query], null),options));
});

imcljs.fetch.fetch_custom_format.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.fetch_custom_format.cljs$lang$applyTo = (function (seq14066){
var G__14067 = cljs.core.first.call(null,seq14066);
var seq14066__$1 = cljs.core.next.call(null,seq14066);
var G__14068 = cljs.core.first.call(null,seq14066__$1);
var seq14066__$2 = cljs.core.next.call(null,seq14066__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14067,G__14068,seq14066__$2);
});

imcljs.fetch.records = (function imcljs$fetch$records(var_args){
var args__4736__auto__ = [];
var len__4730__auto___14083 = arguments.length;
var i__4731__auto___14084 = (0);
while(true){
if((i__4731__auto___14084 < len__4730__auto___14083)){
args__4736__auto__.push((arguments[i__4731__auto___14084]));

var G__14085 = (i__4731__auto___14084 + (1));
i__4731__auto___14084 = G__14085;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.records.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.records.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__14079){
var vec__14080 = p__14079;
var options = cljs.core.nth.call(null,vec__14080,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"jsonobjects"], null),options));
});

imcljs.fetch.records.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.records.cljs$lang$applyTo = (function (seq14076){
var G__14077 = cljs.core.first.call(null,seq14076);
var seq14076__$1 = cljs.core.next.call(null,seq14076);
var G__14078 = cljs.core.first.call(null,seq14076__$1);
var seq14076__$2 = cljs.core.next.call(null,seq14076__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14077,G__14078,seq14076__$2);
});

imcljs.fetch.rows = (function imcljs$fetch$rows(var_args){
var args__4736__auto__ = [];
var len__4730__auto___14093 = arguments.length;
var i__4731__auto___14094 = (0);
while(true){
if((i__4731__auto___14094 < len__4730__auto___14093)){
args__4736__auto__.push((arguments[i__4731__auto___14094]));

var G__14095 = (i__4731__auto___14094 + (1));
i__4731__auto___14094 = G__14095;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.rows.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.rows.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__14089){
var vec__14090 = p__14089;
var options = cljs.core.nth.call(null,vec__14090,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.fetch.rows.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.rows.cljs$lang$applyTo = (function (seq14086){
var G__14087 = cljs.core.first.call(null,seq14086);
var seq14086__$1 = cljs.core.next.call(null,seq14086);
var G__14088 = cljs.core.first.call(null,seq14086__$1);
var seq14086__$2 = cljs.core.next.call(null,seq14086__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14087,G__14088,seq14086__$2);
});

imcljs.fetch.row_count = (function imcljs$fetch$row_count(var_args){
var args__4736__auto__ = [];
var len__4730__auto___14103 = arguments.length;
var i__4731__auto___14104 = (0);
while(true){
if((i__4731__auto___14104 < len__4730__auto___14103)){
args__4736__auto__.push((arguments[i__4731__auto___14104]));

var G__14105 = (i__4731__auto___14104 + (1));
i__4731__auto___14104 = G__14105;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.row_count.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.row_count.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__14099){
var vec__14100 = p__14099;
var options = cljs.core.nth.call(null,vec__14100,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"count"], null),options));
});

imcljs.fetch.row_count.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.row_count.cljs$lang$applyTo = (function (seq14096){
var G__14097 = cljs.core.first.call(null,seq14096);
var seq14096__$1 = cljs.core.next.call(null,seq14096);
var G__14098 = cljs.core.first.call(null,seq14096__$1);
var seq14096__$2 = cljs.core.next.call(null,seq14096__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14097,G__14098,seq14096__$2);
});

imcljs.fetch.possible_values = (function imcljs$fetch$possible_values(var_args){
var args__4736__auto__ = [];
var len__4730__auto___14113 = arguments.length;
var i__4731__auto___14114 = (0);
while(true){
if((i__4731__auto___14114 < len__4730__auto___14113)){
args__4736__auto__.push((arguments[i__4731__auto___14114]));

var G__14115 = (i__4731__auto___14114 + (1));
i__4731__auto___14114 = G__14115;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.possible_values.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.possible_values.cljs$core$IFn$_invoke$arity$variadic = (function (service,path,p__14109){
var vec__14110 = p__14109;
var options = cljs.core.nth.call(null,vec__14110,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/path/values",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),path,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.fetch.possible_values.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.possible_values.cljs$lang$applyTo = (function (seq14106){
var G__14107 = cljs.core.first.call(null,seq14106);
var seq14106__$1 = cljs.core.next.call(null,seq14106);
var G__14108 = cljs.core.first.call(null,seq14106__$1);
var seq14106__$2 = cljs.core.next.call(null,seq14106__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14107,G__14108,seq14106__$2);
});

/**
 * Fetches unique values for a path within a query. Providing a limit shortcircuits the request
 *   and returns false if the unique values exceed the limit. This is primarily for the column
 *   summary in im-tables-3, where we don't want to summarize columns with more than limit=1000
 *   values, so we avoid sending the massive request here instead.
 */
imcljs.fetch.unique_values = (function imcljs$fetch$unique_values(var_args){
var args__4736__auto__ = [];
var len__4730__auto___14209 = arguments.length;
var i__4731__auto___14210 = (0);
while(true){
if((i__4731__auto___14210 < len__4730__auto___14209)){
args__4736__auto__.push((arguments[i__4731__auto___14210]));

var G__14211 = (i__4731__auto___14210 + (1));
i__4731__auto___14210 = G__14211;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.fetch.unique_values.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.fetch.unique_values.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,path,p__14121){
var vec__14122 = p__14121;
var limit = cljs.core.nth.call(null,vec__14122,(0),null);
var return_chan = cljs.core.async.chan.call(null);
var rows_size = ((function (return_chan,vec__14122,limit){
return (function (p1__14116_SHARP_){
return imcljs.fetch.rows.call(null,service,query,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"summaryPath","summaryPath",599411983),path,new cljs.core.Keyword(null,"size","size",1098693007),p1__14116_SHARP_,new cljs.core.Keyword(null,"format","format",-1306924766),"jsonrows"], null));
});})(return_chan,vec__14122,limit))
;
var c__2324__auto___14212 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2324__auto___14212,return_chan,rows_size,vec__14122,limit){
return (function (){
var f__2325__auto__ = (function (){var switch__2301__auto__ = ((function (c__2324__auto___14212,return_chan,rows_size,vec__14122,limit){
return (function (state_14177){
var state_val_14178 = (state_14177[(1)]);
if((state_val_14178 === (7))){
var state_14177__$1 = state_14177;
var statearr_14179_14213 = state_14177__$1;
(statearr_14179_14213[(2)] = false);

(statearr_14179_14213[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14178 === (20))){
var inst_14162 = (state_14177[(2)]);
var state_14177__$1 = state_14177;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14177__$1,(19),return_chan,inst_14162);
} else {
if((state_val_14178 === (1))){
var inst_14126 = rows_size.call(null,(1));
var state_14177__$1 = state_14177;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14177__$1,(2),inst_14126);
} else {
if((state_val_14178 === (24))){
var inst_14168 = (state_14177[(2)]);
var state_14177__$1 = state_14177;
var statearr_14180_14214 = state_14177__$1;
(statearr_14180_14214[(2)] = inst_14168);

(statearr_14180_14214[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14178 === (4))){
var state_14177__$1 = state_14177;
var statearr_14181_14215 = state_14177__$1;
(statearr_14181_14215[(2)] = false);

(statearr_14181_14215[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14178 === (15))){
var inst_14154 = (state_14177[(2)]);
var state_14177__$1 = state_14177;
var statearr_14182_14216 = state_14177__$1;
(statearr_14182_14216[(2)] = inst_14154);

(statearr_14182_14216[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14178 === (21))){
var state_14177__$1 = state_14177;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14177__$1,(24),return_chan,false);
} else {
if((state_val_14178 === (13))){
var inst_14150 = (state_14177[(7)]);
var inst_14156 = cljs.core.not.call(null,limit);
var inst_14157 = (inst_14150 <= limit);
var inst_14158 = ((inst_14156) || (inst_14157));
var state_14177__$1 = state_14177;
if(cljs.core.truth_(inst_14158)){
var statearr_14183_14217 = state_14177__$1;
(statearr_14183_14217[(1)] = (16));

} else {
var statearr_14184_14218 = state_14177__$1;
(statearr_14184_14218[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14178 === (22))){
var state_14177__$1 = state_14177;
var statearr_14185_14219 = state_14177__$1;
(statearr_14185_14219[(2)] = null);

(statearr_14185_14219[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14178 === (6))){
var state_14177__$1 = state_14177;
var statearr_14186_14220 = state_14177__$1;
(statearr_14186_14220[(2)] = true);

(statearr_14186_14220[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14178 === (17))){
var state_14177__$1 = state_14177;
var statearr_14187_14221 = state_14177__$1;
(statearr_14187_14221[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14178 === (3))){
var inst_14128 = (state_14177[(8)]);
var inst_14133 = inst_14128.cljs$lang$protocol_mask$partition0$;
var inst_14134 = (inst_14133 & (64));
var inst_14135 = inst_14128.cljs$core$ISeq$;
var inst_14136 = (cljs.core.PROTOCOL_SENTINEL === inst_14135);
var inst_14137 = ((inst_14134) || (inst_14136));
var state_14177__$1 = state_14177;
if(cljs.core.truth_(inst_14137)){
var statearr_14189_14222 = state_14177__$1;
(statearr_14189_14222[(1)] = (6));

} else {
var statearr_14190_14223 = state_14177__$1;
(statearr_14190_14223[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14178 === (12))){
var inst_14149 = (state_14177[(9)]);
var state_14177__$1 = state_14177;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14177__$1,(15),return_chan,inst_14149);
} else {
if((state_val_14178 === (2))){
var inst_14128 = (state_14177[(8)]);
var inst_14128__$1 = (state_14177[(2)]);
var inst_14130 = (inst_14128__$1 == null);
var inst_14131 = cljs.core.not.call(null,inst_14130);
var state_14177__$1 = (function (){var statearr_14191 = state_14177;
(statearr_14191[(8)] = inst_14128__$1);

return statearr_14191;
})();
if(inst_14131){
var statearr_14192_14224 = state_14177__$1;
(statearr_14192_14224[(1)] = (3));

} else {
var statearr_14193_14225 = state_14177__$1;
(statearr_14193_14225[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14178 === (23))){
var inst_14171 = (state_14177[(2)]);
var state_14177__$1 = state_14177;
var statearr_14194_14226 = state_14177__$1;
(statearr_14194_14226[(2)] = inst_14171);

(statearr_14194_14226[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14178 === (19))){
var inst_14164 = (state_14177[(2)]);
var state_14177__$1 = state_14177;
var statearr_14195_14227 = state_14177__$1;
(statearr_14195_14227[(2)] = inst_14164);

(statearr_14195_14227[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14178 === (11))){
var inst_14149 = (state_14177[(9)]);
var inst_14150 = (state_14177[(7)]);
var inst_14149__$1 = (state_14177[(2)]);
var inst_14150__$1 = cljs.core.get.call(null,inst_14149__$1,new cljs.core.Keyword(null,"uniqueValues","uniqueValues",1661070646));
var inst_14151 = cljs.core._EQ_.call(null,inst_14150__$1,(1));
var state_14177__$1 = (function (){var statearr_14196 = state_14177;
(statearr_14196[(9)] = inst_14149__$1);

(statearr_14196[(7)] = inst_14150__$1);

return statearr_14196;
})();
if(inst_14151){
var statearr_14197_14228 = state_14177__$1;
(statearr_14197_14228[(1)] = (12));

} else {
var statearr_14198_14229 = state_14177__$1;
(statearr_14198_14229[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14178 === (9))){
var inst_14128 = (state_14177[(8)]);
var inst_14146 = cljs.core.apply.call(null,cljs.core.hash_map,inst_14128);
var state_14177__$1 = state_14177;
var statearr_14199_14230 = state_14177__$1;
(statearr_14199_14230[(2)] = inst_14146);

(statearr_14199_14230[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14178 === (5))){
var inst_14144 = (state_14177[(2)]);
var state_14177__$1 = state_14177;
if(cljs.core.truth_(inst_14144)){
var statearr_14200_14231 = state_14177__$1;
(statearr_14200_14231[(1)] = (9));

} else {
var statearr_14201_14232 = state_14177__$1;
(statearr_14201_14232[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14178 === (14))){
var inst_14175 = (state_14177[(2)]);
var state_14177__$1 = state_14177;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14177__$1,inst_14175);
} else {
if((state_val_14178 === (16))){
var inst_14160 = rows_size.call(null,limit);
var state_14177__$1 = state_14177;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14177__$1,(20),inst_14160);
} else {
if((state_val_14178 === (10))){
var inst_14128 = (state_14177[(8)]);
var state_14177__$1 = state_14177;
var statearr_14202_14233 = state_14177__$1;
(statearr_14202_14233[(2)] = inst_14128);

(statearr_14202_14233[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14178 === (18))){
var inst_14173 = (state_14177[(2)]);
var state_14177__$1 = state_14177;
var statearr_14203_14234 = state_14177__$1;
(statearr_14203_14234[(2)] = inst_14173);

(statearr_14203_14234[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14178 === (8))){
var inst_14141 = (state_14177[(2)]);
var state_14177__$1 = state_14177;
var statearr_14204_14235 = state_14177__$1;
(statearr_14204_14235[(2)] = inst_14141);

(statearr_14204_14235[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2324__auto___14212,return_chan,rows_size,vec__14122,limit))
;
return ((function (switch__2301__auto__,c__2324__auto___14212,return_chan,rows_size,vec__14122,limit){
return (function() {
var imcljs$fetch$state_machine__2302__auto__ = null;
var imcljs$fetch$state_machine__2302__auto____0 = (function (){
var statearr_14205 = [null,null,null,null,null,null,null,null,null,null];
(statearr_14205[(0)] = imcljs$fetch$state_machine__2302__auto__);

(statearr_14205[(1)] = (1));

return statearr_14205;
});
var imcljs$fetch$state_machine__2302__auto____1 = (function (state_14177){
while(true){
var ret_value__2303__auto__ = (function (){try{while(true){
var result__2304__auto__ = switch__2301__auto__.call(null,state_14177);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2304__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2304__auto__;
}
break;
}
}catch (e14206){if((e14206 instanceof Object)){
var ex__2305__auto__ = e14206;
var statearr_14207_14236 = state_14177;
(statearr_14207_14236[(5)] = ex__2305__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14177);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14206;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2303__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14237 = state_14177;
state_14177 = G__14237;
continue;
} else {
return ret_value__2303__auto__;
}
break;
}
});
imcljs$fetch$state_machine__2302__auto__ = function(state_14177){
switch(arguments.length){
case 0:
return imcljs$fetch$state_machine__2302__auto____0.call(this);
case 1:
return imcljs$fetch$state_machine__2302__auto____1.call(this,state_14177);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
imcljs$fetch$state_machine__2302__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$fetch$state_machine__2302__auto____0;
imcljs$fetch$state_machine__2302__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$fetch$state_machine__2302__auto____1;
return imcljs$fetch$state_machine__2302__auto__;
})()
;})(switch__2301__auto__,c__2324__auto___14212,return_chan,rows_size,vec__14122,limit))
})();
var state__2326__auto__ = (function (){var statearr_14208 = f__2325__auto__.call(null);
(statearr_14208[(6)] = c__2324__auto___14212);

return statearr_14208;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2326__auto__);
});})(c__2324__auto___14212,return_chan,rows_size,vec__14122,limit))
);


return return_chan;
});

imcljs.fetch.unique_values.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.fetch.unique_values.cljs$lang$applyTo = (function (seq14117){
var G__14118 = cljs.core.first.call(null,seq14117);
var seq14117__$1 = cljs.core.next.call(null,seq14117);
var G__14119 = cljs.core.first.call(null,seq14117__$1);
var seq14117__$2 = cljs.core.next.call(null,seq14117__$1);
var G__14120 = cljs.core.first.call(null,seq14117__$2);
var seq14117__$3 = cljs.core.next.call(null,seq14117__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14118,G__14119,G__14120,seq14117__$3);
});

/**
 * Fetches queries saved under the user. Use the `:filter` option to only
 *   return queries with the specified title, with optional `*` wildcards.
 */
imcljs.fetch.saved_queries = (function imcljs$fetch$saved_queries(var_args){
var args__4736__auto__ = [];
var len__4730__auto___14244 = arguments.length;
var i__4731__auto___14245 = (0);
while(true){
if((i__4731__auto___14245 < len__4730__auto___14244)){
args__4736__auto__.push((arguments[i__4731__auto___14245]));

var G__14246 = (i__4731__auto___14245 + (1));
i__4731__auto___14245 = G__14246;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.saved_queries.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.saved_queries.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__14240){
var vec__14241 = p__14240;
var options = cljs.core.nth.call(null,vec__14241,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/user/queries",service,options,new cljs.core.Keyword(null,"queries","queries",1446291995));
});

imcljs.fetch.saved_queries.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.saved_queries.cljs$lang$applyTo = (function (seq14238){
var G__14239 = cljs.core.first.call(null,seq14238);
var seq14238__$1 = cljs.core.next.call(null,seq14238);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14239,seq14238__$1);
});

imcljs.fetch.lists = (function imcljs$fetch$lists(var_args){
var args__4736__auto__ = [];
var len__4730__auto___14253 = arguments.length;
var i__4731__auto___14254 = (0);
while(true){
if((i__4731__auto___14254 < len__4730__auto___14253)){
args__4736__auto__.push((arguments[i__4731__auto___14254]));

var G__14255 = (i__4731__auto___14254 + (1));
i__4731__auto___14254 = G__14255;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.lists.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.lists.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__14249){
var vec__14250 = p__14249;
var options = cljs.core.nth.call(null,vec__14250,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/lists",service,options,new cljs.core.Keyword(null,"lists","lists",-884730684));
});

imcljs.fetch.lists.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.lists.cljs$lang$applyTo = (function (seq14247){
var G__14248 = cljs.core.first.call(null,seq14247);
var seq14247__$1 = cljs.core.next.call(null,seq14247);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14248,seq14247__$1);
});

imcljs.fetch.one_list = (function imcljs$fetch$one_list(var_args){
var args__4736__auto__ = [];
var len__4730__auto___14263 = arguments.length;
var i__4731__auto___14264 = (0);
while(true){
if((i__4731__auto___14264 < len__4730__auto___14263)){
args__4736__auto__.push((arguments[i__4731__auto___14264]));

var G__14265 = (i__4731__auto___14264 + (1));
i__4731__auto___14264 = G__14265;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.one_list.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.one_list.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,p__14259){
var vec__14260 = p__14259;
var options = cljs.core.nth.call(null,vec__14260,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/lists",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),name], null),options),cljs.core.comp.call(null,cljs.core.first,new cljs.core.Keyword(null,"lists","lists",-884730684)));
});

imcljs.fetch.one_list.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.one_list.cljs$lang$applyTo = (function (seq14256){
var G__14257 = cljs.core.first.call(null,seq14256);
var seq14256__$1 = cljs.core.next.call(null,seq14256);
var G__14258 = cljs.core.first.call(null,seq14256__$1);
var seq14256__$2 = cljs.core.next.call(null,seq14256__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14257,G__14258,seq14256__$2);
});

/**
 * Find lists on the server containing an object.
 *   As a minimum, specify either :id or both of :publicId and :type.
 */
imcljs.fetch.lists_containing = (function imcljs$fetch$lists_containing(var_args){
var args__4736__auto__ = [];
var len__4730__auto___14272 = arguments.length;
var i__4731__auto___14273 = (0);
while(true){
if((i__4731__auto___14273 < len__4730__auto___14272)){
args__4736__auto__.push((arguments[i__4731__auto___14273]));

var G__14274 = (i__4731__auto___14273 + (1));
i__4731__auto___14273 = G__14274;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.lists_containing.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.lists_containing.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__14268){
var vec__14269 = p__14268;
var options = cljs.core.nth.call(null,vec__14269,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/listswithobject",service,options,new cljs.core.Keyword(null,"lists","lists",-884730684));
});

imcljs.fetch.lists_containing.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.lists_containing.cljs$lang$applyTo = (function (seq14266){
var G__14267 = cljs.core.first.call(null,seq14266);
var seq14266__$1 = cljs.core.next.call(null,seq14266);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14267,seq14266__$1);
});

imcljs.fetch.model = (function imcljs$fetch$model(var_args){
var args__4736__auto__ = [];
var len__4730__auto___14281 = arguments.length;
var i__4731__auto___14282 = (0);
while(true){
if((i__4731__auto___14282 < len__4730__auto___14281)){
args__4736__auto__.push((arguments[i__4731__auto___14282]));

var G__14283 = (i__4731__auto___14282 + (1));
i__4731__auto___14282 = G__14283;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.model.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.model.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__14277){
var vec__14278 = p__14277;
var options = cljs.core.nth.call(null,vec__14278,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/model",service,options,new cljs.core.Keyword(null,"model","model",331153215));
});

imcljs.fetch.model.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.model.cljs$lang$applyTo = (function (seq14275){
var G__14276 = cljs.core.first.call(null,seq14275);
var seq14275__$1 = cljs.core.next.call(null,seq14275);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14276,seq14275__$1);
});

imcljs.fetch.class_keys = (function imcljs$fetch$class_keys(var_args){
var args__4736__auto__ = [];
var len__4730__auto___14290 = arguments.length;
var i__4731__auto___14291 = (0);
while(true){
if((i__4731__auto___14291 < len__4730__auto___14290)){
args__4736__auto__.push((arguments[i__4731__auto___14291]));

var G__14292 = (i__4731__auto___14291 + (1));
i__4731__auto___14291 = G__14292;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.class_keys.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.class_keys.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__14286){
var vec__14287 = p__14286;
var options = cljs.core.nth.call(null,vec__14287,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/classkeys",service,options,new cljs.core.Keyword(null,"classes","classes",2037804510));
});

imcljs.fetch.class_keys.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.class_keys.cljs$lang$applyTo = (function (seq14284){
var G__14285 = cljs.core.first.call(null,seq14284);
var seq14284__$1 = cljs.core.next.call(null,seq14284);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14285,seq14284__$1);
});

imcljs.fetch.summary_fields = (function imcljs$fetch$summary_fields(var_args){
var args__4736__auto__ = [];
var len__4730__auto___14299 = arguments.length;
var i__4731__auto___14300 = (0);
while(true){
if((i__4731__auto___14300 < len__4730__auto___14299)){
args__4736__auto__.push((arguments[i__4731__auto___14300]));

var G__14301 = (i__4731__auto___14300 + (1));
i__4731__auto___14300 = G__14301;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.summary_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.summary_fields.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__14295){
var vec__14296 = p__14295;
var options = cljs.core.nth.call(null,vec__14296,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/summaryfields",service,options,new cljs.core.Keyword(null,"classes","classes",2037804510));
});

imcljs.fetch.summary_fields.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.summary_fields.cljs$lang$applyTo = (function (seq14293){
var G__14294 = cljs.core.first.call(null,seq14293);
var seq14293__$1 = cljs.core.next.call(null,seq14293);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14294,seq14293__$1);
});

imcljs.fetch.templates = (function imcljs$fetch$templates(var_args){
var args__4736__auto__ = [];
var len__4730__auto___14308 = arguments.length;
var i__4731__auto___14309 = (0);
while(true){
if((i__4731__auto___14309 < len__4730__auto___14308)){
args__4736__auto__.push((arguments[i__4731__auto___14309]));

var G__14310 = (i__4731__auto___14309 + (1));
i__4731__auto___14309 = G__14310;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.templates.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.templates.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__14304){
var vec__14305 = p__14304;
var options = cljs.core.nth.call(null,vec__14305,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/templates",service,options,new cljs.core.Keyword(null,"templates","templates",-1237401733));
});

imcljs.fetch.templates.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.templates.cljs$lang$applyTo = (function (seq14302){
var G__14303 = cljs.core.first.call(null,seq14302);
var seq14302__$1 = cljs.core.next.call(null,seq14302);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14303,seq14302__$1);
});

/**
 * Returns a temporary API token.
 */
imcljs.fetch.session = (function imcljs$fetch$session(var_args){
var args__4736__auto__ = [];
var len__4730__auto___14317 = arguments.length;
var i__4731__auto___14318 = (0);
while(true){
if((i__4731__auto___14318 < len__4730__auto___14317)){
args__4736__auto__.push((arguments[i__4731__auto___14318]));

var G__14319 = (i__4731__auto___14318 + (1));
i__4731__auto___14318 = G__14319;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.session.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.session.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__14313){
var vec__14314 = p__14313;
var options = cljs.core.nth.call(null,vec__14314,(0),null);
var token_free_service = cljs.core.dissoc.call(null,service,new cljs.core.Keyword(null,"token","token",-1211463215));
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/session",token_free_service,options,new cljs.core.Keyword(null,"token","token",-1211463215));
});

imcljs.fetch.session.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.session.cljs$lang$applyTo = (function (seq14311){
var G__14312 = cljs.core.first.call(null,seq14311);
var seq14311__$1 = cljs.core.next.call(null,seq14311);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14312,seq14311__$1);
});

/**
 * Returns list of widgets available for a given mine
 */
imcljs.fetch.widgets = (function imcljs$fetch$widgets(var_args){
var args__4736__auto__ = [];
var len__4730__auto___14326 = arguments.length;
var i__4731__auto___14327 = (0);
while(true){
if((i__4731__auto___14327 < len__4730__auto___14326)){
args__4736__auto__.push((arguments[i__4731__auto___14327]));

var G__14328 = (i__4731__auto___14327 + (1));
i__4731__auto___14327 = G__14328;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.widgets.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.widgets.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__14322){
var vec__14323 = p__14322;
var options = cljs.core.nth.call(null,vec__14323,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/widgets",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),new cljs.core.Keyword(null,"widgets","widgets",-159098978));
});

imcljs.fetch.widgets.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.widgets.cljs$lang$applyTo = (function (seq14320){
var G__14321 = cljs.core.first.call(null,seq14320);
var seq14320__$1 = cljs.core.next.call(null,seq14320);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14321,seq14320__$1);
});

/**
 * Returns enrichment results
 */
imcljs.fetch.enrichment = (function imcljs$fetch$enrichment(var_args){
var args__4736__auto__ = [];
var len__4730__auto___14335 = arguments.length;
var i__4731__auto___14336 = (0);
while(true){
if((i__4731__auto___14336 < len__4730__auto___14335)){
args__4736__auto__.push((arguments[i__4731__auto___14336]));

var G__14337 = (i__4731__auto___14336 + (1));
i__4731__auto___14336 = G__14337;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.enrichment.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.enrichment.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__14331){
var vec__14332 = p__14331;
var options = cljs.core.nth.call(null,vec__14332,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/list/enrichment",service,cljs.core.merge.call(null,imcljs.internal.defaults.default_enrichment,options));
});

imcljs.fetch.enrichment.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.enrichment.cljs$lang$applyTo = (function (seq14329){
var G__14330 = cljs.core.first.call(null,seq14329);
var seq14329__$1 = cljs.core.next.call(null,seq14329);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14330,seq14329__$1);
});

/**
 * Returns the version of the InterMine WebService being run, e.g. '27'
 */
imcljs.fetch.version_web_service = (function imcljs$fetch$version_web_service(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/version",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"text"], null));
});
imcljs.fetch.version_release = (function imcljs$fetch$version_release(service){

return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/version/release",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"text"], null));
});
/**
 * Returns the version of InterMine being run, e.g. '1.6.6'
 */
imcljs.fetch.version_intermine = (function imcljs$fetch$version_intermine(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/version/intermine",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"text"], null));
});
/**
 * Returns the default configs for a given mine. These are important as they're
 * used to initialise most bluegenes page sections! 
 */
imcljs.fetch.web_properties = (function imcljs$fetch$web_properties(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/web-properties",service,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"web-properties","web-properties",-1421911737));
});
/**
 * Returns the branding details for a given mine.
 *   Used to make things more personal!
 */
imcljs.fetch.branding = (function imcljs$fetch$branding(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/branding",service,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"properties","properties",685819552));
});
/**
 * Returns the BlueGenes-specific configs for a given mine. These are created
 *   and maintained by BlueGenes, similarly to a key-value store.
 */
imcljs.fetch.bluegenes_properties = (function imcljs$fetch$bluegenes_properties(var_args){
var args__4736__auto__ = [];
var len__4730__auto___14344 = arguments.length;
var i__4731__auto___14345 = (0);
while(true){
if((i__4731__auto___14345 < len__4730__auto___14344)){
args__4736__auto__.push((arguments[i__4731__auto___14345]));

var G__14346 = (i__4731__auto___14345 + (1));
i__4731__auto___14345 = G__14346;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.bluegenes_properties.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.bluegenes_properties.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__14340){
var vec__14341 = p__14340;
var options = cljs.core.nth.call(null,vec__14341,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/bluegenes-properties",service,options,new cljs.core.Keyword(null,"bluegenes-properties","bluegenes-properties",-1287321694));
});

imcljs.fetch.bluegenes_properties.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.bluegenes_properties.cljs$lang$applyTo = (function (seq14338){
var G__14339 = cljs.core.first.call(null,seq14338);
var seq14338__$1 = cljs.core.next.call(null,seq14338);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14339,seq14338__$1);
});

/**
 * Fetches the results of an id resolution job
 */
imcljs.fetch.fetch_id_resolution_job_results = (function imcljs$fetch$fetch_id_resolution_job_results(service,uid){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),["/ids/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(uid),"/results"].join(''),service,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"results","results",-1134170113));
});
/**
 * Fetches the status of an id resolution job
 */
imcljs.fetch.fetch_id_resolution_job_status = (function imcljs$fetch$fetch_id_resolution_job_status(service,uid){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),["/ids/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(uid),"/status"].join(''),service,cljs.core.PersistentArrayMap.EMPTY);
});
/**
 * Starts an id resolution job
 */
imcljs.fetch.fetch_id_resolution_job = (function imcljs$fetch$fetch_id_resolution_job(service,p__14347){
var map__14348 = p__14347;
var map__14348__$1 = (((((!((map__14348 == null))))?(((((map__14348.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14348.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14348):map__14348);
var options = map__14348__$1;
var identifiers = cljs.core.get.call(null,map__14348__$1,new cljs.core.Keyword(null,"identifiers","identifiers",-2057597722));
var type = cljs.core.get.call(null,map__14348__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var case_sensitive = cljs.core.get.call(null,map__14348__$1,new cljs.core.Keyword(null,"case-sensitive","case-sensitive",-1005239404));
var wild_cards = cljs.core.get.call(null,map__14348__$1,new cljs.core.Keyword(null,"wild-cards","wild-cards",681119344));
var extra = cljs.core.get.call(null,map__14348__$1,new cljs.core.Keyword(null,"extra","extra",1612569067));
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post-body","post-body",-1481559189),"/ids",service,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"body","body",-2049205669),(function (){var G__14350 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"identifiers","identifiers",-2057597722),identifiers], null);
var G__14350__$1 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__14350,new cljs.core.Keyword(null,"type","type",1174270348),type):G__14350);
var G__14350__$2 = (cljs.core.truth_(case_sensitive)?cljs.core.assoc.call(null,G__14350__$1,new cljs.core.Keyword(null,"caseSensitive","caseSensitive",-586669673),true):G__14350__$1);
var G__14350__$3 = (cljs.core.truth_(wild_cards)?cljs.core.assoc.call(null,G__14350__$2,new cljs.core.Keyword(null,"wildCards","wildCards",-2054689560),true):G__14350__$2);
if(cljs.core.truth_(extra)){
return cljs.core.assoc.call(null,G__14350__$3,new cljs.core.Keyword(null,"extra","extra",1612569067),extra);
} else {
return G__14350__$3;
}
})(),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null)], null));
});
/**
 * Resolves identifiers. Automatically handles polling
 */
imcljs.fetch.resolve_identifiers = (function imcljs$fetch$resolve_identifiers(service,p__14351){
var map__14352 = p__14351;
var map__14352__$1 = (((((!((map__14352 == null))))?(((((map__14352.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14352.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14352):map__14352);
var options = map__14352__$1;
var timeout_ms = cljs.core.get.call(null,map__14352__$1,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406));
var return_chan = cljs.core.async.chan.call(null,(1));
var c__2324__auto___14505 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2324__auto___14505,return_chan,map__14352,map__14352__$1,options,timeout_ms){
return (function (){
var f__2325__auto__ = (function (){var switch__2301__auto__ = ((function (c__2324__auto___14505,return_chan,map__14352,map__14352__$1,options,timeout_ms){
return (function (state_14447){
var state_val_14448 = (state_14447[(1)]);
if((state_val_14448 === (7))){
var state_14447__$1 = state_14447;
var statearr_14449_14506 = state_14447__$1;
(statearr_14449_14506[(2)] = false);

(statearr_14449_14506[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (20))){
var inst_14404 = (state_14447[(2)]);
var state_14447__$1 = state_14447;
if(cljs.core.truth_(inst_14404)){
var statearr_14450_14507 = state_14447__$1;
(statearr_14450_14507[(1)] = (24));

} else {
var statearr_14451_14508 = state_14447__$1;
(statearr_14451_14508[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (27))){
var inst_14438 = (state_14447[(2)]);
var state_14447__$1 = state_14447;
var statearr_14452_14509 = state_14447__$1;
(statearr_14452_14509[(2)] = inst_14438);

(statearr_14452_14509[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (1))){
var inst_14355 = imcljs.fetch.fetch_id_resolution_job.call(null,service,options);
var state_14447__$1 = state_14447;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14447__$1,(2),inst_14355);
} else {
if((state_val_14448 === (24))){
var inst_14388 = (state_14447[(7)]);
var inst_14406 = cljs.core.apply.call(null,cljs.core.hash_map,inst_14388);
var state_14447__$1 = state_14447;
var statearr_14453_14510 = state_14447__$1;
(statearr_14453_14510[(2)] = inst_14406);

(statearr_14453_14510[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (39))){
var inst_14409 = (state_14447[(8)]);
var state_14447__$1 = state_14447;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14447__$1,(40),return_chan,inst_14409);
} else {
if((state_val_14448 === (4))){
var state_14447__$1 = state_14447;
var statearr_14454_14511 = state_14447__$1;
(statearr_14454_14511[(2)] = false);

(statearr_14454_14511[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (15))){
var inst_14379 = (state_14447[(9)]);
var inst_14386 = imcljs.fetch.fetch_id_resolution_job_status.call(null,service,inst_14379);
var state_14447__$1 = state_14447;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14447__$1,(17),inst_14386);
} else {
if((state_val_14448 === (21))){
var state_14447__$1 = state_14447;
var statearr_14455_14512 = state_14447__$1;
(statearr_14455_14512[(2)] = true);

(statearr_14455_14512[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (31))){
var inst_14382 = (state_14447[(10)]);
var inst_14417 = cljs.core.async.timeout.call(null,inst_14382);
var state_14447__$1 = state_14447;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14447__$1,(32),inst_14417);
} else {
if((state_val_14448 === (32))){
var inst_14419 = (state_14447[(2)]);
var state_14447__$1 = (function (){var statearr_14456 = state_14447;
(statearr_14456[(11)] = inst_14419);

return statearr_14456;
})();
if(cljs.core.truth_(timeout_ms)){
var statearr_14457_14513 = state_14447__$1;
(statearr_14457_14513[(1)] = (33));

} else {
var statearr_14458_14514 = state_14447__$1;
(statearr_14458_14514[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (40))){
var inst_14435 = (state_14447[(2)]);
var state_14447__$1 = state_14447;
var statearr_14459_14515 = state_14447__$1;
(statearr_14459_14515[(2)] = inst_14435);

(statearr_14459_14515[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (33))){
var state_14447__$1 = state_14447;
var statearr_14460_14516 = state_14447__$1;
(statearr_14460_14516[(2)] = timeout_ms);

(statearr_14460_14516[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (13))){
var inst_14378 = (state_14447[(12)]);
var state_14447__$1 = state_14447;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14447__$1,(41),return_chan,inst_14378);
} else {
if((state_val_14448 === (22))){
var state_14447__$1 = state_14447;
var statearr_14461_14517 = state_14447__$1;
(statearr_14461_14517[(2)] = false);

(statearr_14461_14517[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (36))){
var inst_14382 = (state_14447[(10)]);
var inst_14383 = (state_14447[(13)]);
var inst_14426 = (inst_14382 * 1.5);
var inst_14427 = (((1000) < inst_14426) ? (1000) : inst_14426);
var inst_14428 = (inst_14383 + inst_14382);
var inst_14382__$1 = inst_14427;
var inst_14383__$1 = inst_14428;
var state_14447__$1 = (function (){var statearr_14462 = state_14447;
(statearr_14462[(10)] = inst_14382__$1);

(statearr_14462[(13)] = inst_14383__$1);

return statearr_14462;
})();
var statearr_14463_14518 = state_14447__$1;
(statearr_14463_14518[(2)] = null);

(statearr_14463_14518[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (41))){
var inst_14443 = (state_14447[(2)]);
var state_14447__$1 = state_14447;
var statearr_14464_14519 = state_14447__$1;
(statearr_14464_14519[(2)] = inst_14443);

(statearr_14464_14519[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (29))){
var inst_14413 = (state_14447[(2)]);
var state_14447__$1 = state_14447;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14447__$1,(30),return_chan,inst_14413);
} else {
if((state_val_14448 === (6))){
var state_14447__$1 = state_14447;
var statearr_14465_14520 = state_14447__$1;
(statearr_14465_14520[(2)] = true);

(statearr_14465_14520[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (28))){
var inst_14379 = (state_14447[(9)]);
var inst_14411 = imcljs.fetch.fetch_id_resolution_job_results.call(null,service,inst_14379);
var state_14447__$1 = state_14447;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14447__$1,(29),inst_14411);
} else {
if((state_val_14448 === (25))){
var inst_14388 = (state_14447[(7)]);
var state_14447__$1 = state_14447;
var statearr_14466_14521 = state_14447__$1;
(statearr_14466_14521[(2)] = inst_14388);

(statearr_14466_14521[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (34))){
var state_14447__$1 = state_14447;
var statearr_14467_14522 = state_14447__$1;
(statearr_14467_14522[(2)] = (30000));

(statearr_14467_14522[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (17))){
var inst_14388 = (state_14447[(7)]);
var inst_14388__$1 = (state_14447[(2)]);
var inst_14390 = (inst_14388__$1 == null);
var inst_14391 = cljs.core.not.call(null,inst_14390);
var state_14447__$1 = (function (){var statearr_14468 = state_14447;
(statearr_14468[(7)] = inst_14388__$1);

return statearr_14468;
})();
if(inst_14391){
var statearr_14469_14523 = state_14447__$1;
(statearr_14469_14523[(1)] = (18));

} else {
var statearr_14470_14524 = state_14447__$1;
(statearr_14470_14524[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (3))){
var inst_14357 = (state_14447[(14)]);
var inst_14362 = inst_14357.cljs$lang$protocol_mask$partition0$;
var inst_14363 = (inst_14362 & (64));
var inst_14364 = inst_14357.cljs$core$ISeq$;
var inst_14365 = (cljs.core.PROTOCOL_SENTINEL === inst_14364);
var inst_14366 = ((inst_14363) || (inst_14365));
var state_14447__$1 = state_14447;
if(cljs.core.truth_(inst_14366)){
var statearr_14471_14525 = state_14447__$1;
(statearr_14471_14525[(1)] = (6));

} else {
var statearr_14472_14526 = state_14447__$1;
(statearr_14472_14526[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (12))){
var inst_14382 = (100);
var inst_14383 = (0);
var state_14447__$1 = (function (){var statearr_14473 = state_14447;
(statearr_14473[(10)] = inst_14382);

(statearr_14473[(13)] = inst_14383);

return statearr_14473;
})();
var statearr_14474_14527 = state_14447__$1;
(statearr_14474_14527[(2)] = null);

(statearr_14474_14527[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (2))){
var inst_14357 = (state_14447[(14)]);
var inst_14357__$1 = (state_14447[(2)]);
var inst_14359 = (inst_14357__$1 == null);
var inst_14360 = cljs.core.not.call(null,inst_14359);
var state_14447__$1 = (function (){var statearr_14475 = state_14447;
(statearr_14475[(14)] = inst_14357__$1);

return statearr_14475;
})();
if(inst_14360){
var statearr_14476_14528 = state_14447__$1;
(statearr_14476_14528[(1)] = (3));

} else {
var statearr_14477_14529 = state_14447__$1;
(statearr_14477_14529[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (23))){
var inst_14401 = (state_14447[(2)]);
var state_14447__$1 = state_14447;
var statearr_14478_14530 = state_14447__$1;
(statearr_14478_14530[(2)] = inst_14401);

(statearr_14478_14530[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (35))){
var inst_14383 = (state_14447[(13)]);
var inst_14423 = (state_14447[(2)]);
var inst_14424 = (inst_14383 < inst_14423);
var state_14447__$1 = state_14447;
if(cljs.core.truth_(inst_14424)){
var statearr_14479_14531 = state_14447__$1;
(statearr_14479_14531[(1)] = (36));

} else {
var statearr_14480_14532 = state_14447__$1;
(statearr_14480_14532[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (19))){
var state_14447__$1 = state_14447;
var statearr_14481_14533 = state_14447__$1;
(statearr_14481_14533[(2)] = false);

(statearr_14481_14533[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (11))){
var inst_14378 = (state_14447[(12)]);
var inst_14379 = (state_14447[(9)]);
var inst_14378__$1 = (state_14447[(2)]);
var inst_14379__$1 = cljs.core.get.call(null,inst_14378__$1,new cljs.core.Keyword(null,"uid","uid",-1447769400));
var inst_14380 = cljs.core.not_empty.call(null,inst_14379__$1);
var state_14447__$1 = (function (){var statearr_14482 = state_14447;
(statearr_14482[(12)] = inst_14378__$1);

(statearr_14482[(9)] = inst_14379__$1);

return statearr_14482;
})();
if(cljs.core.truth_(inst_14380)){
var statearr_14483_14534 = state_14447__$1;
(statearr_14483_14534[(1)] = (12));

} else {
var statearr_14484_14535 = state_14447__$1;
(statearr_14484_14535[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (9))){
var inst_14357 = (state_14447[(14)]);
var inst_14375 = cljs.core.apply.call(null,cljs.core.hash_map,inst_14357);
var state_14447__$1 = state_14447;
var statearr_14485_14536 = state_14447__$1;
(statearr_14485_14536[(2)] = inst_14375);

(statearr_14485_14536[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (5))){
var inst_14373 = (state_14447[(2)]);
var state_14447__$1 = state_14447;
if(cljs.core.truth_(inst_14373)){
var statearr_14486_14537 = state_14447__$1;
(statearr_14486_14537[(1)] = (9));

} else {
var statearr_14487_14538 = state_14447__$1;
(statearr_14487_14538[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (14))){
var inst_14445 = (state_14447[(2)]);
var state_14447__$1 = state_14447;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14447__$1,inst_14445);
} else {
if((state_val_14448 === (26))){
var inst_14409 = (state_14447[(8)]);
var inst_14409__$1 = (state_14447[(2)]);
var inst_14410 = cljs.core.get.call(null,inst_14409__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var state_14447__$1 = (function (){var statearr_14488 = state_14447;
(statearr_14488[(8)] = inst_14409__$1);

return statearr_14488;
})();
var G__14489_14539 = inst_14410;
switch (G__14489_14539) {
case "SUCCESS":
var statearr_14490_14541 = state_14447__$1;
(statearr_14490_14541[(1)] = (28));


break;
case "RUNNING":
var statearr_14491_14542 = state_14447__$1;
(statearr_14491_14542[(1)] = (31));


break;
default:
var statearr_14492_14543 = state_14447__$1;
(statearr_14492_14543[(1)] = (39));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (16))){
var inst_14440 = (state_14447[(2)]);
var state_14447__$1 = state_14447;
var statearr_14493_14544 = state_14447__$1;
(statearr_14493_14544[(2)] = inst_14440);

(statearr_14493_14544[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (38))){
var inst_14432 = (state_14447[(2)]);
var state_14447__$1 = state_14447;
var statearr_14494_14545 = state_14447__$1;
(statearr_14494_14545[(2)] = inst_14432);

(statearr_14494_14545[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (30))){
var inst_14415 = (state_14447[(2)]);
var state_14447__$1 = state_14447;
var statearr_14495_14546 = state_14447__$1;
(statearr_14495_14546[(2)] = inst_14415);

(statearr_14495_14546[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (10))){
var inst_14357 = (state_14447[(14)]);
var state_14447__$1 = state_14447;
var statearr_14496_14547 = state_14447__$1;
(statearr_14496_14547[(2)] = inst_14357);

(statearr_14496_14547[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (18))){
var inst_14388 = (state_14447[(7)]);
var inst_14393 = inst_14388.cljs$lang$protocol_mask$partition0$;
var inst_14394 = (inst_14393 & (64));
var inst_14395 = inst_14388.cljs$core$ISeq$;
var inst_14396 = (cljs.core.PROTOCOL_SENTINEL === inst_14395);
var inst_14397 = ((inst_14394) || (inst_14396));
var state_14447__$1 = state_14447;
if(cljs.core.truth_(inst_14397)){
var statearr_14497_14548 = state_14447__$1;
(statearr_14497_14548[(1)] = (21));

} else {
var statearr_14498_14549 = state_14447__$1;
(statearr_14498_14549[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (37))){
var state_14447__$1 = state_14447;
var statearr_14499_14550 = state_14447__$1;
(statearr_14499_14550[(2)] = null);

(statearr_14499_14550[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14448 === (8))){
var inst_14370 = (state_14447[(2)]);
var state_14447__$1 = state_14447;
var statearr_14500_14551 = state_14447__$1;
(statearr_14500_14551[(2)] = inst_14370);

(statearr_14500_14551[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2324__auto___14505,return_chan,map__14352,map__14352__$1,options,timeout_ms))
;
return ((function (switch__2301__auto__,c__2324__auto___14505,return_chan,map__14352,map__14352__$1,options,timeout_ms){
return (function() {
var imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto__ = null;
var imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto____0 = (function (){
var statearr_14501 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14501[(0)] = imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto__);

(statearr_14501[(1)] = (1));

return statearr_14501;
});
var imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto____1 = (function (state_14447){
while(true){
var ret_value__2303__auto__ = (function (){try{while(true){
var result__2304__auto__ = switch__2301__auto__.call(null,state_14447);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2304__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2304__auto__;
}
break;
}
}catch (e14502){if((e14502 instanceof Object)){
var ex__2305__auto__ = e14502;
var statearr_14503_14552 = state_14447;
(statearr_14503_14552[(5)] = ex__2305__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14447);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14502;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2303__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14553 = state_14447;
state_14447 = G__14553;
continue;
} else {
return ret_value__2303__auto__;
}
break;
}
});
imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto__ = function(state_14447){
switch(arguments.length){
case 0:
return imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto____0.call(this);
case 1:
return imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto____1.call(this,state_14447);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto____0;
imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto____1;
return imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto__;
})()
;})(switch__2301__auto__,c__2324__auto___14505,return_chan,map__14352,map__14352__$1,options,timeout_ms))
})();
var state__2326__auto__ = (function (){var statearr_14504 = f__2325__auto__.call(null);
(statearr_14504[(6)] = c__2324__auto___14505);

return statearr_14504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2326__auto__);
});})(c__2324__auto___14505,return_chan,map__14352,map__14352__$1,options,timeout_ms))
);


return return_chan;
});
/**
 * Returns generated code to run the query in a given language
 */
imcljs.fetch.code = (function imcljs$fetch$code(var_args){
var args__4736__auto__ = [];
var len__4730__auto___14563 = arguments.length;
var i__4731__auto___14564 = (0);
while(true){
if((i__4731__auto___14564 < len__4730__auto___14563)){
args__4736__auto__.push((arguments[i__4731__auto___14564]));

var G__14565 = (i__4731__auto___14564 + (1));
i__4731__auto___14564 = G__14565;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.code.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.code.cljs$core$IFn$_invoke$arity$variadic = (function (service,model,p__14557){
var vec__14558 = p__14557;
var map__14561 = cljs.core.nth.call(null,vec__14558,(0),null);
var map__14561__$1 = (((((!((map__14561 == null))))?(((((map__14561.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14561.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14561):map__14561);
var options = map__14561__$1;
var lang = cljs.core.get.call(null,map__14561__$1,new cljs.core.Keyword(null,"lang","lang",-1819677104));
var query = cljs.core.get.call(null,map__14561__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/query/code",service,cljs.core.update.call(null,cljs.core.merge.call(null,options,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null)),new cljs.core.Keyword(null,"query","query",-1288509510),cljs.core.partial.call(null,imcljs.query.__GT_xml,model)),new cljs.core.Keyword(null,"code","code",1586293142));
});

imcljs.fetch.code.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.code.cljs$lang$applyTo = (function (seq14554){
var G__14555 = cljs.core.first.call(null,seq14554);
var seq14554__$1 = cljs.core.next.call(null,seq14554);
var G__14556 = cljs.core.first.call(null,seq14554__$1);
var seq14554__$2 = cljs.core.next.call(null,seq14554__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14555,G__14556,seq14554__$2);
});

/**
 * Returns list of InterMines from the InterMine registry. dev-mines? needs to
 * be set to true if you want to return non-prod mines, or otherwise set to false
 */
imcljs.fetch.registry = (function imcljs$fetch$registry(dev_mines_QMARK_){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"raw","raw",1604651272),new cljs.core.Keyword(null,"get","get",1683182755),"/instances",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"root","root",-448657453),"https://registry.intermine.org/service"], null),(cljs.core.truth_(dev_mines_QMARK_)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query-params","query-params",900640534),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mines","mines",-1960796490),"all"], null)], null):null),new cljs.core.Keyword(null,"instances","instances",-335364781));
});
/**
 * Returns a map of preferences set for the authenticated user.
 */
imcljs.fetch.preferences = (function imcljs$fetch$preferences(var_args){
var args__4736__auto__ = [];
var len__4730__auto___14572 = arguments.length;
var i__4731__auto___14573 = (0);
while(true){
if((i__4731__auto___14573 < len__4730__auto___14572)){
args__4736__auto__.push((arguments[i__4731__auto___14573]));

var G__14574 = (i__4731__auto___14573 + (1));
i__4731__auto___14573 = G__14574;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.preferences.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.preferences.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__14568){
var vec__14569 = p__14568;
var options = cljs.core.nth.call(null,vec__14569,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/user/preferences",service,options,new cljs.core.Keyword(null,"preferences","preferences",-484312211));
});

imcljs.fetch.preferences.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.preferences.cljs$lang$applyTo = (function (seq14566){
var G__14567 = cljs.core.first.call(null,seq14566);
var seq14566__$1 = cljs.core.next.call(null,seq14566);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14567,seq14566__$1);
});


//# sourceMappingURL=fetch.js.map
