// Compiled by ClojureScript 1.10.520 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__8714 = arguments.length;
switch (G__8714) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async8715 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8715 = (function (f,blockable,meta8716){
this.f = f;
this.blockable = blockable;
this.meta8716 = meta8716;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async8715.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_8717,meta8716__$1){
var self__ = this;
var _8717__$1 = this;
return (new cljs.core.async.t_cljs$core$async8715(self__.f,self__.blockable,meta8716__$1));
});

cljs.core.async.t_cljs$core$async8715.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_8717){
var self__ = this;
var _8717__$1 = this;
return self__.meta8716;
});

cljs.core.async.t_cljs$core$async8715.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async8715.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async8715.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async8715.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async8715.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta8716","meta8716",1102777712,null)], null);
});

cljs.core.async.t_cljs$core$async8715.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async8715.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8715";

cljs.core.async.t_cljs$core$async8715.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async8715");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async8715.
 */
cljs.core.async.__GT_t_cljs$core$async8715 = (function cljs$core$async$__GT_t_cljs$core$async8715(f__$1,blockable__$1,meta8716){
return (new cljs.core.async.t_cljs$core$async8715(f__$1,blockable__$1,meta8716));
});

}

return (new cljs.core.async.t_cljs$core$async8715(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__8721 = arguments.length;
switch (G__8721) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__8724 = arguments.length;
switch (G__8724) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__8727 = arguments.length;
switch (G__8727) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_8729 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_8729);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_8729,ret){
return (function (){
return fn1.call(null,val_8729);
});})(val_8729,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__8731 = arguments.length;
switch (G__8731) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5733__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5733__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4607__auto___8733 = n;
var x_8734 = (0);
while(true){
if((x_8734 < n__4607__auto___8733)){
(a[x_8734] = x_8734);

var G__8735 = (x_8734 + (1));
x_8734 = G__8735;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async8736 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8736 = (function (flag,meta8737){
this.flag = flag;
this.meta8737 = meta8737;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async8736.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_8738,meta8737__$1){
var self__ = this;
var _8738__$1 = this;
return (new cljs.core.async.t_cljs$core$async8736(self__.flag,meta8737__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async8736.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_8738){
var self__ = this;
var _8738__$1 = this;
return self__.meta8737;
});})(flag))
;

cljs.core.async.t_cljs$core$async8736.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async8736.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async8736.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async8736.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async8736.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta8737","meta8737",-1435385911,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async8736.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async8736.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8736";

cljs.core.async.t_cljs$core$async8736.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async8736");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async8736.
 */
cljs.core.async.__GT_t_cljs$core$async8736 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async8736(flag__$1,meta8737){
return (new cljs.core.async.t_cljs$core$async8736(flag__$1,meta8737));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async8736(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async8739 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8739 = (function (flag,cb,meta8740){
this.flag = flag;
this.cb = cb;
this.meta8740 = meta8740;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async8739.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_8741,meta8740__$1){
var self__ = this;
var _8741__$1 = this;
return (new cljs.core.async.t_cljs$core$async8739(self__.flag,self__.cb,meta8740__$1));
});

cljs.core.async.t_cljs$core$async8739.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_8741){
var self__ = this;
var _8741__$1 = this;
return self__.meta8740;
});

cljs.core.async.t_cljs$core$async8739.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async8739.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async8739.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async8739.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async8739.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta8740","meta8740",-1543359150,null)], null);
});

cljs.core.async.t_cljs$core$async8739.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async8739.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8739";

cljs.core.async.t_cljs$core$async8739.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async8739");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async8739.
 */
cljs.core.async.__GT_t_cljs$core$async8739 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async8739(flag__$1,cb__$1,meta8740){
return (new cljs.core.async.t_cljs$core$async8739(flag__$1,cb__$1,meta8740));
});

}

return (new cljs.core.async.t_cljs$core$async8739(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count.call(null,ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__8742_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__8742_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__8743_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__8743_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4131__auto__ = wport;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return port;
}
})()], null));
} else {
var G__8744 = (i + (1));
i = G__8744;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4131__auto__ = ret;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4120__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8750 = arguments.length;
var i__4731__auto___8751 = (0);
while(true){
if((i__4731__auto___8751 < len__4730__auto___8750)){
args__4736__auto__.push((arguments[i__4731__auto___8751]));

var G__8752 = (i__4731__auto___8751 + (1));
i__4731__auto___8751 = G__8752;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__8747){
var map__8748 = p__8747;
var map__8748__$1 = (((((!((map__8748 == null))))?(((((map__8748.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8748.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8748):map__8748);
var opts = map__8748__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq8745){
var G__8746 = cljs.core.first.call(null,seq8745);
var seq8745__$1 = cljs.core.next.call(null,seq8745);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8746,seq8745__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__8754 = arguments.length;
switch (G__8754) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__6791__auto___8800 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6791__auto___8800){
return (function (){
var f__6792__auto__ = (function (){var switch__6624__auto__ = ((function (c__6791__auto___8800){
return (function (state_8778){
var state_val_8779 = (state_8778[(1)]);
if((state_val_8779 === (7))){
var inst_8774 = (state_8778[(2)]);
var state_8778__$1 = state_8778;
var statearr_8780_8801 = state_8778__$1;
(statearr_8780_8801[(2)] = inst_8774);

(statearr_8780_8801[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8779 === (1))){
var state_8778__$1 = state_8778;
var statearr_8781_8802 = state_8778__$1;
(statearr_8781_8802[(2)] = null);

(statearr_8781_8802[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8779 === (4))){
var inst_8757 = (state_8778[(7)]);
var inst_8757__$1 = (state_8778[(2)]);
var inst_8758 = (inst_8757__$1 == null);
var state_8778__$1 = (function (){var statearr_8782 = state_8778;
(statearr_8782[(7)] = inst_8757__$1);

return statearr_8782;
})();
if(cljs.core.truth_(inst_8758)){
var statearr_8783_8803 = state_8778__$1;
(statearr_8783_8803[(1)] = (5));

} else {
var statearr_8784_8804 = state_8778__$1;
(statearr_8784_8804[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8779 === (13))){
var state_8778__$1 = state_8778;
var statearr_8785_8805 = state_8778__$1;
(statearr_8785_8805[(2)] = null);

(statearr_8785_8805[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8779 === (6))){
var inst_8757 = (state_8778[(7)]);
var state_8778__$1 = state_8778;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8778__$1,(11),to,inst_8757);
} else {
if((state_val_8779 === (3))){
var inst_8776 = (state_8778[(2)]);
var state_8778__$1 = state_8778;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8778__$1,inst_8776);
} else {
if((state_val_8779 === (12))){
var state_8778__$1 = state_8778;
var statearr_8786_8806 = state_8778__$1;
(statearr_8786_8806[(2)] = null);

(statearr_8786_8806[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8779 === (2))){
var state_8778__$1 = state_8778;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8778__$1,(4),from);
} else {
if((state_val_8779 === (11))){
var inst_8767 = (state_8778[(2)]);
var state_8778__$1 = state_8778;
if(cljs.core.truth_(inst_8767)){
var statearr_8787_8807 = state_8778__$1;
(statearr_8787_8807[(1)] = (12));

} else {
var statearr_8788_8808 = state_8778__$1;
(statearr_8788_8808[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8779 === (9))){
var state_8778__$1 = state_8778;
var statearr_8789_8809 = state_8778__$1;
(statearr_8789_8809[(2)] = null);

(statearr_8789_8809[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8779 === (5))){
var state_8778__$1 = state_8778;
if(cljs.core.truth_(close_QMARK_)){
var statearr_8790_8810 = state_8778__$1;
(statearr_8790_8810[(1)] = (8));

} else {
var statearr_8791_8811 = state_8778__$1;
(statearr_8791_8811[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8779 === (14))){
var inst_8772 = (state_8778[(2)]);
var state_8778__$1 = state_8778;
var statearr_8792_8812 = state_8778__$1;
(statearr_8792_8812[(2)] = inst_8772);

(statearr_8792_8812[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8779 === (10))){
var inst_8764 = (state_8778[(2)]);
var state_8778__$1 = state_8778;
var statearr_8793_8813 = state_8778__$1;
(statearr_8793_8813[(2)] = inst_8764);

(statearr_8793_8813[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8779 === (8))){
var inst_8761 = cljs.core.async.close_BANG_.call(null,to);
var state_8778__$1 = state_8778;
var statearr_8794_8814 = state_8778__$1;
(statearr_8794_8814[(2)] = inst_8761);

(statearr_8794_8814[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6791__auto___8800))
;
return ((function (switch__6624__auto__,c__6791__auto___8800){
return (function() {
var cljs$core$async$state_machine__6625__auto__ = null;
var cljs$core$async$state_machine__6625__auto____0 = (function (){
var statearr_8795 = [null,null,null,null,null,null,null,null];
(statearr_8795[(0)] = cljs$core$async$state_machine__6625__auto__);

(statearr_8795[(1)] = (1));

return statearr_8795;
});
var cljs$core$async$state_machine__6625__auto____1 = (function (state_8778){
while(true){
var ret_value__6626__auto__ = (function (){try{while(true){
var result__6627__auto__ = switch__6624__auto__.call(null,state_8778);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6627__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6627__auto__;
}
break;
}
}catch (e8796){if((e8796 instanceof Object)){
var ex__6628__auto__ = e8796;
var statearr_8797_8815 = state_8778;
(statearr_8797_8815[(5)] = ex__6628__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8778);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8796;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6626__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8816 = state_8778;
state_8778 = G__8816;
continue;
} else {
return ret_value__6626__auto__;
}
break;
}
});
cljs$core$async$state_machine__6625__auto__ = function(state_8778){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6625__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6625__auto____1.call(this,state_8778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6625__auto____0;
cljs$core$async$state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6625__auto____1;
return cljs$core$async$state_machine__6625__auto__;
})()
;})(switch__6624__auto__,c__6791__auto___8800))
})();
var state__6793__auto__ = (function (){var statearr_8798 = f__6792__auto__.call(null);
(statearr_8798[(6)] = c__6791__auto___8800);

return statearr_8798;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6793__auto__);
});})(c__6791__auto___8800))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__8817){
var vec__8818 = p__8817;
var v = cljs.core.nth.call(null,vec__8818,(0),null);
var p = cljs.core.nth.call(null,vec__8818,(1),null);
var job = vec__8818;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__6791__auto___8989 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6791__auto___8989,res,vec__8818,v,p,job,jobs,results){
return (function (){
var f__6792__auto__ = (function (){var switch__6624__auto__ = ((function (c__6791__auto___8989,res,vec__8818,v,p,job,jobs,results){
return (function (state_8825){
var state_val_8826 = (state_8825[(1)]);
if((state_val_8826 === (1))){
var state_8825__$1 = state_8825;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8825__$1,(2),res,v);
} else {
if((state_val_8826 === (2))){
var inst_8822 = (state_8825[(2)]);
var inst_8823 = cljs.core.async.close_BANG_.call(null,res);
var state_8825__$1 = (function (){var statearr_8827 = state_8825;
(statearr_8827[(7)] = inst_8822);

return statearr_8827;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8825__$1,inst_8823);
} else {
return null;
}
}
});})(c__6791__auto___8989,res,vec__8818,v,p,job,jobs,results))
;
return ((function (switch__6624__auto__,c__6791__auto___8989,res,vec__8818,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____0 = (function (){
var statearr_8828 = [null,null,null,null,null,null,null,null];
(statearr_8828[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__);

(statearr_8828[(1)] = (1));

return statearr_8828;
});
var cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____1 = (function (state_8825){
while(true){
var ret_value__6626__auto__ = (function (){try{while(true){
var result__6627__auto__ = switch__6624__auto__.call(null,state_8825);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6627__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6627__auto__;
}
break;
}
}catch (e8829){if((e8829 instanceof Object)){
var ex__6628__auto__ = e8829;
var statearr_8830_8990 = state_8825;
(statearr_8830_8990[(5)] = ex__6628__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8825);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8829;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6626__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8991 = state_8825;
state_8825 = G__8991;
continue;
} else {
return ret_value__6626__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__ = function(state_8825){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____1.call(this,state_8825);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__;
})()
;})(switch__6624__auto__,c__6791__auto___8989,res,vec__8818,v,p,job,jobs,results))
})();
var state__6793__auto__ = (function (){var statearr_8831 = f__6792__auto__.call(null);
(statearr_8831[(6)] = c__6791__auto___8989);

return statearr_8831;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6793__auto__);
});})(c__6791__auto___8989,res,vec__8818,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__8832){
var vec__8833 = p__8832;
var v = cljs.core.nth.call(null,vec__8833,(0),null);
var p = cljs.core.nth.call(null,vec__8833,(1),null);
var job = vec__8833;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__4607__auto___8992 = n;
var __8993 = (0);
while(true){
if((__8993 < n__4607__auto___8992)){
var G__8836_8994 = type;
var G__8836_8995__$1 = (((G__8836_8994 instanceof cljs.core.Keyword))?G__8836_8994.fqn:null);
switch (G__8836_8995__$1) {
case "compute":
var c__6791__auto___8997 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__8993,c__6791__auto___8997,G__8836_8994,G__8836_8995__$1,n__4607__auto___8992,jobs,results,process,async){
return (function (){
var f__6792__auto__ = (function (){var switch__6624__auto__ = ((function (__8993,c__6791__auto___8997,G__8836_8994,G__8836_8995__$1,n__4607__auto___8992,jobs,results,process,async){
return (function (state_8849){
var state_val_8850 = (state_8849[(1)]);
if((state_val_8850 === (1))){
var state_8849__$1 = state_8849;
var statearr_8851_8998 = state_8849__$1;
(statearr_8851_8998[(2)] = null);

(statearr_8851_8998[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8850 === (2))){
var state_8849__$1 = state_8849;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8849__$1,(4),jobs);
} else {
if((state_val_8850 === (3))){
var inst_8847 = (state_8849[(2)]);
var state_8849__$1 = state_8849;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8849__$1,inst_8847);
} else {
if((state_val_8850 === (4))){
var inst_8839 = (state_8849[(2)]);
var inst_8840 = process.call(null,inst_8839);
var state_8849__$1 = state_8849;
if(cljs.core.truth_(inst_8840)){
var statearr_8852_8999 = state_8849__$1;
(statearr_8852_8999[(1)] = (5));

} else {
var statearr_8853_9000 = state_8849__$1;
(statearr_8853_9000[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8850 === (5))){
var state_8849__$1 = state_8849;
var statearr_8854_9001 = state_8849__$1;
(statearr_8854_9001[(2)] = null);

(statearr_8854_9001[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8850 === (6))){
var state_8849__$1 = state_8849;
var statearr_8855_9002 = state_8849__$1;
(statearr_8855_9002[(2)] = null);

(statearr_8855_9002[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8850 === (7))){
var inst_8845 = (state_8849[(2)]);
var state_8849__$1 = state_8849;
var statearr_8856_9003 = state_8849__$1;
(statearr_8856_9003[(2)] = inst_8845);

(statearr_8856_9003[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__8993,c__6791__auto___8997,G__8836_8994,G__8836_8995__$1,n__4607__auto___8992,jobs,results,process,async))
;
return ((function (__8993,switch__6624__auto__,c__6791__auto___8997,G__8836_8994,G__8836_8995__$1,n__4607__auto___8992,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____0 = (function (){
var statearr_8857 = [null,null,null,null,null,null,null];
(statearr_8857[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__);

(statearr_8857[(1)] = (1));

return statearr_8857;
});
var cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____1 = (function (state_8849){
while(true){
var ret_value__6626__auto__ = (function (){try{while(true){
var result__6627__auto__ = switch__6624__auto__.call(null,state_8849);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6627__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6627__auto__;
}
break;
}
}catch (e8858){if((e8858 instanceof Object)){
var ex__6628__auto__ = e8858;
var statearr_8859_9004 = state_8849;
(statearr_8859_9004[(5)] = ex__6628__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8849);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8858;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6626__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9005 = state_8849;
state_8849 = G__9005;
continue;
} else {
return ret_value__6626__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__ = function(state_8849){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____1.call(this,state_8849);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__;
})()
;})(__8993,switch__6624__auto__,c__6791__auto___8997,G__8836_8994,G__8836_8995__$1,n__4607__auto___8992,jobs,results,process,async))
})();
var state__6793__auto__ = (function (){var statearr_8860 = f__6792__auto__.call(null);
(statearr_8860[(6)] = c__6791__auto___8997);

return statearr_8860;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6793__auto__);
});})(__8993,c__6791__auto___8997,G__8836_8994,G__8836_8995__$1,n__4607__auto___8992,jobs,results,process,async))
);


break;
case "async":
var c__6791__auto___9006 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__8993,c__6791__auto___9006,G__8836_8994,G__8836_8995__$1,n__4607__auto___8992,jobs,results,process,async){
return (function (){
var f__6792__auto__ = (function (){var switch__6624__auto__ = ((function (__8993,c__6791__auto___9006,G__8836_8994,G__8836_8995__$1,n__4607__auto___8992,jobs,results,process,async){
return (function (state_8873){
var state_val_8874 = (state_8873[(1)]);
if((state_val_8874 === (1))){
var state_8873__$1 = state_8873;
var statearr_8875_9007 = state_8873__$1;
(statearr_8875_9007[(2)] = null);

(statearr_8875_9007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8874 === (2))){
var state_8873__$1 = state_8873;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8873__$1,(4),jobs);
} else {
if((state_val_8874 === (3))){
var inst_8871 = (state_8873[(2)]);
var state_8873__$1 = state_8873;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8873__$1,inst_8871);
} else {
if((state_val_8874 === (4))){
var inst_8863 = (state_8873[(2)]);
var inst_8864 = async.call(null,inst_8863);
var state_8873__$1 = state_8873;
if(cljs.core.truth_(inst_8864)){
var statearr_8876_9008 = state_8873__$1;
(statearr_8876_9008[(1)] = (5));

} else {
var statearr_8877_9009 = state_8873__$1;
(statearr_8877_9009[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8874 === (5))){
var state_8873__$1 = state_8873;
var statearr_8878_9010 = state_8873__$1;
(statearr_8878_9010[(2)] = null);

(statearr_8878_9010[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8874 === (6))){
var state_8873__$1 = state_8873;
var statearr_8879_9011 = state_8873__$1;
(statearr_8879_9011[(2)] = null);

(statearr_8879_9011[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8874 === (7))){
var inst_8869 = (state_8873[(2)]);
var state_8873__$1 = state_8873;
var statearr_8880_9012 = state_8873__$1;
(statearr_8880_9012[(2)] = inst_8869);

(statearr_8880_9012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__8993,c__6791__auto___9006,G__8836_8994,G__8836_8995__$1,n__4607__auto___8992,jobs,results,process,async))
;
return ((function (__8993,switch__6624__auto__,c__6791__auto___9006,G__8836_8994,G__8836_8995__$1,n__4607__auto___8992,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____0 = (function (){
var statearr_8881 = [null,null,null,null,null,null,null];
(statearr_8881[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__);

(statearr_8881[(1)] = (1));

return statearr_8881;
});
var cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____1 = (function (state_8873){
while(true){
var ret_value__6626__auto__ = (function (){try{while(true){
var result__6627__auto__ = switch__6624__auto__.call(null,state_8873);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6627__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6627__auto__;
}
break;
}
}catch (e8882){if((e8882 instanceof Object)){
var ex__6628__auto__ = e8882;
var statearr_8883_9013 = state_8873;
(statearr_8883_9013[(5)] = ex__6628__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8873);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8882;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6626__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9014 = state_8873;
state_8873 = G__9014;
continue;
} else {
return ret_value__6626__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__ = function(state_8873){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____1.call(this,state_8873);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__;
})()
;})(__8993,switch__6624__auto__,c__6791__auto___9006,G__8836_8994,G__8836_8995__$1,n__4607__auto___8992,jobs,results,process,async))
})();
var state__6793__auto__ = (function (){var statearr_8884 = f__6792__auto__.call(null);
(statearr_8884[(6)] = c__6791__auto___9006);

return statearr_8884;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6793__auto__);
});})(__8993,c__6791__auto___9006,G__8836_8994,G__8836_8995__$1,n__4607__auto___8992,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__8836_8995__$1)].join('')));

}

var G__9015 = (__8993 + (1));
__8993 = G__9015;
continue;
} else {
}
break;
}

var c__6791__auto___9016 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6791__auto___9016,jobs,results,process,async){
return (function (){
var f__6792__auto__ = (function (){var switch__6624__auto__ = ((function (c__6791__auto___9016,jobs,results,process,async){
return (function (state_8906){
var state_val_8907 = (state_8906[(1)]);
if((state_val_8907 === (7))){
var inst_8902 = (state_8906[(2)]);
var state_8906__$1 = state_8906;
var statearr_8908_9017 = state_8906__$1;
(statearr_8908_9017[(2)] = inst_8902);

(statearr_8908_9017[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8907 === (1))){
var state_8906__$1 = state_8906;
var statearr_8909_9018 = state_8906__$1;
(statearr_8909_9018[(2)] = null);

(statearr_8909_9018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8907 === (4))){
var inst_8887 = (state_8906[(7)]);
var inst_8887__$1 = (state_8906[(2)]);
var inst_8888 = (inst_8887__$1 == null);
var state_8906__$1 = (function (){var statearr_8910 = state_8906;
(statearr_8910[(7)] = inst_8887__$1);

return statearr_8910;
})();
if(cljs.core.truth_(inst_8888)){
var statearr_8911_9019 = state_8906__$1;
(statearr_8911_9019[(1)] = (5));

} else {
var statearr_8912_9020 = state_8906__$1;
(statearr_8912_9020[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8907 === (6))){
var inst_8892 = (state_8906[(8)]);
var inst_8887 = (state_8906[(7)]);
var inst_8892__$1 = cljs.core.async.chan.call(null,(1));
var inst_8893 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_8894 = [inst_8887,inst_8892__$1];
var inst_8895 = (new cljs.core.PersistentVector(null,2,(5),inst_8893,inst_8894,null));
var state_8906__$1 = (function (){var statearr_8913 = state_8906;
(statearr_8913[(8)] = inst_8892__$1);

return statearr_8913;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8906__$1,(8),jobs,inst_8895);
} else {
if((state_val_8907 === (3))){
var inst_8904 = (state_8906[(2)]);
var state_8906__$1 = state_8906;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8906__$1,inst_8904);
} else {
if((state_val_8907 === (2))){
var state_8906__$1 = state_8906;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8906__$1,(4),from);
} else {
if((state_val_8907 === (9))){
var inst_8899 = (state_8906[(2)]);
var state_8906__$1 = (function (){var statearr_8914 = state_8906;
(statearr_8914[(9)] = inst_8899);

return statearr_8914;
})();
var statearr_8915_9021 = state_8906__$1;
(statearr_8915_9021[(2)] = null);

(statearr_8915_9021[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8907 === (5))){
var inst_8890 = cljs.core.async.close_BANG_.call(null,jobs);
var state_8906__$1 = state_8906;
var statearr_8916_9022 = state_8906__$1;
(statearr_8916_9022[(2)] = inst_8890);

(statearr_8916_9022[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8907 === (8))){
var inst_8892 = (state_8906[(8)]);
var inst_8897 = (state_8906[(2)]);
var state_8906__$1 = (function (){var statearr_8917 = state_8906;
(statearr_8917[(10)] = inst_8897);

return statearr_8917;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8906__$1,(9),results,inst_8892);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__6791__auto___9016,jobs,results,process,async))
;
return ((function (switch__6624__auto__,c__6791__auto___9016,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____0 = (function (){
var statearr_8918 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_8918[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__);

(statearr_8918[(1)] = (1));

return statearr_8918;
});
var cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____1 = (function (state_8906){
while(true){
var ret_value__6626__auto__ = (function (){try{while(true){
var result__6627__auto__ = switch__6624__auto__.call(null,state_8906);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6627__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6627__auto__;
}
break;
}
}catch (e8919){if((e8919 instanceof Object)){
var ex__6628__auto__ = e8919;
var statearr_8920_9023 = state_8906;
(statearr_8920_9023[(5)] = ex__6628__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8906);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8919;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6626__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9024 = state_8906;
state_8906 = G__9024;
continue;
} else {
return ret_value__6626__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__ = function(state_8906){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____1.call(this,state_8906);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__;
})()
;})(switch__6624__auto__,c__6791__auto___9016,jobs,results,process,async))
})();
var state__6793__auto__ = (function (){var statearr_8921 = f__6792__auto__.call(null);
(statearr_8921[(6)] = c__6791__auto___9016);

return statearr_8921;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6793__auto__);
});})(c__6791__auto___9016,jobs,results,process,async))
);


var c__6791__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6791__auto__,jobs,results,process,async){
return (function (){
var f__6792__auto__ = (function (){var switch__6624__auto__ = ((function (c__6791__auto__,jobs,results,process,async){
return (function (state_8959){
var state_val_8960 = (state_8959[(1)]);
if((state_val_8960 === (7))){
var inst_8955 = (state_8959[(2)]);
var state_8959__$1 = state_8959;
var statearr_8961_9025 = state_8959__$1;
(statearr_8961_9025[(2)] = inst_8955);

(statearr_8961_9025[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8960 === (20))){
var state_8959__$1 = state_8959;
var statearr_8962_9026 = state_8959__$1;
(statearr_8962_9026[(2)] = null);

(statearr_8962_9026[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8960 === (1))){
var state_8959__$1 = state_8959;
var statearr_8963_9027 = state_8959__$1;
(statearr_8963_9027[(2)] = null);

(statearr_8963_9027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8960 === (4))){
var inst_8924 = (state_8959[(7)]);
var inst_8924__$1 = (state_8959[(2)]);
var inst_8925 = (inst_8924__$1 == null);
var state_8959__$1 = (function (){var statearr_8964 = state_8959;
(statearr_8964[(7)] = inst_8924__$1);

return statearr_8964;
})();
if(cljs.core.truth_(inst_8925)){
var statearr_8965_9028 = state_8959__$1;
(statearr_8965_9028[(1)] = (5));

} else {
var statearr_8966_9029 = state_8959__$1;
(statearr_8966_9029[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8960 === (15))){
var inst_8937 = (state_8959[(8)]);
var state_8959__$1 = state_8959;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8959__$1,(18),to,inst_8937);
} else {
if((state_val_8960 === (21))){
var inst_8950 = (state_8959[(2)]);
var state_8959__$1 = state_8959;
var statearr_8967_9030 = state_8959__$1;
(statearr_8967_9030[(2)] = inst_8950);

(statearr_8967_9030[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8960 === (13))){
var inst_8952 = (state_8959[(2)]);
var state_8959__$1 = (function (){var statearr_8968 = state_8959;
(statearr_8968[(9)] = inst_8952);

return statearr_8968;
})();
var statearr_8969_9031 = state_8959__$1;
(statearr_8969_9031[(2)] = null);

(statearr_8969_9031[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8960 === (6))){
var inst_8924 = (state_8959[(7)]);
var state_8959__$1 = state_8959;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8959__$1,(11),inst_8924);
} else {
if((state_val_8960 === (17))){
var inst_8945 = (state_8959[(2)]);
var state_8959__$1 = state_8959;
if(cljs.core.truth_(inst_8945)){
var statearr_8970_9032 = state_8959__$1;
(statearr_8970_9032[(1)] = (19));

} else {
var statearr_8971_9033 = state_8959__$1;
(statearr_8971_9033[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8960 === (3))){
var inst_8957 = (state_8959[(2)]);
var state_8959__$1 = state_8959;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8959__$1,inst_8957);
} else {
if((state_val_8960 === (12))){
var inst_8934 = (state_8959[(10)]);
var state_8959__$1 = state_8959;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8959__$1,(14),inst_8934);
} else {
if((state_val_8960 === (2))){
var state_8959__$1 = state_8959;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8959__$1,(4),results);
} else {
if((state_val_8960 === (19))){
var state_8959__$1 = state_8959;
var statearr_8972_9034 = state_8959__$1;
(statearr_8972_9034[(2)] = null);

(statearr_8972_9034[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8960 === (11))){
var inst_8934 = (state_8959[(2)]);
var state_8959__$1 = (function (){var statearr_8973 = state_8959;
(statearr_8973[(10)] = inst_8934);

return statearr_8973;
})();
var statearr_8974_9035 = state_8959__$1;
(statearr_8974_9035[(2)] = null);

(statearr_8974_9035[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8960 === (9))){
var state_8959__$1 = state_8959;
var statearr_8975_9036 = state_8959__$1;
(statearr_8975_9036[(2)] = null);

(statearr_8975_9036[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8960 === (5))){
var state_8959__$1 = state_8959;
if(cljs.core.truth_(close_QMARK_)){
var statearr_8976_9037 = state_8959__$1;
(statearr_8976_9037[(1)] = (8));

} else {
var statearr_8977_9038 = state_8959__$1;
(statearr_8977_9038[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8960 === (14))){
var inst_8937 = (state_8959[(8)]);
var inst_8939 = (state_8959[(11)]);
var inst_8937__$1 = (state_8959[(2)]);
var inst_8938 = (inst_8937__$1 == null);
var inst_8939__$1 = cljs.core.not.call(null,inst_8938);
var state_8959__$1 = (function (){var statearr_8978 = state_8959;
(statearr_8978[(8)] = inst_8937__$1);

(statearr_8978[(11)] = inst_8939__$1);

return statearr_8978;
})();
if(inst_8939__$1){
var statearr_8979_9039 = state_8959__$1;
(statearr_8979_9039[(1)] = (15));

} else {
var statearr_8980_9040 = state_8959__$1;
(statearr_8980_9040[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8960 === (16))){
var inst_8939 = (state_8959[(11)]);
var state_8959__$1 = state_8959;
var statearr_8981_9041 = state_8959__$1;
(statearr_8981_9041[(2)] = inst_8939);

(statearr_8981_9041[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8960 === (10))){
var inst_8931 = (state_8959[(2)]);
var state_8959__$1 = state_8959;
var statearr_8982_9042 = state_8959__$1;
(statearr_8982_9042[(2)] = inst_8931);

(statearr_8982_9042[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8960 === (18))){
var inst_8942 = (state_8959[(2)]);
var state_8959__$1 = state_8959;
var statearr_8983_9043 = state_8959__$1;
(statearr_8983_9043[(2)] = inst_8942);

(statearr_8983_9043[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8960 === (8))){
var inst_8928 = cljs.core.async.close_BANG_.call(null,to);
var state_8959__$1 = state_8959;
var statearr_8984_9044 = state_8959__$1;
(statearr_8984_9044[(2)] = inst_8928);

(statearr_8984_9044[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6791__auto__,jobs,results,process,async))
;
return ((function (switch__6624__auto__,c__6791__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____0 = (function (){
var statearr_8985 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_8985[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__);

(statearr_8985[(1)] = (1));

return statearr_8985;
});
var cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____1 = (function (state_8959){
while(true){
var ret_value__6626__auto__ = (function (){try{while(true){
var result__6627__auto__ = switch__6624__auto__.call(null,state_8959);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6627__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6627__auto__;
}
break;
}
}catch (e8986){if((e8986 instanceof Object)){
var ex__6628__auto__ = e8986;
var statearr_8987_9045 = state_8959;
(statearr_8987_9045[(5)] = ex__6628__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8959);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8986;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6626__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9046 = state_8959;
state_8959 = G__9046;
continue;
} else {
return ret_value__6626__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__ = function(state_8959){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____1.call(this,state_8959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__6625__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__6625__auto__;
})()
;})(switch__6624__auto__,c__6791__auto__,jobs,results,process,async))
})();
var state__6793__auto__ = (function (){var statearr_8988 = f__6792__auto__.call(null);
(statearr_8988[(6)] = c__6791__auto__);

return statearr_8988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6793__auto__);
});})(c__6791__auto__,jobs,results,process,async))
);

return c__6791__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__9048 = arguments.length;
switch (G__9048) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__9051 = arguments.length;
switch (G__9051) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__9054 = arguments.length;
switch (G__9054) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__6791__auto___9103 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6791__auto___9103,tc,fc){
return (function (){
var f__6792__auto__ = (function (){var switch__6624__auto__ = ((function (c__6791__auto___9103,tc,fc){
return (function (state_9080){
var state_val_9081 = (state_9080[(1)]);
if((state_val_9081 === (7))){
var inst_9076 = (state_9080[(2)]);
var state_9080__$1 = state_9080;
var statearr_9082_9104 = state_9080__$1;
(statearr_9082_9104[(2)] = inst_9076);

(statearr_9082_9104[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9081 === (1))){
var state_9080__$1 = state_9080;
var statearr_9083_9105 = state_9080__$1;
(statearr_9083_9105[(2)] = null);

(statearr_9083_9105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9081 === (4))){
var inst_9057 = (state_9080[(7)]);
var inst_9057__$1 = (state_9080[(2)]);
var inst_9058 = (inst_9057__$1 == null);
var state_9080__$1 = (function (){var statearr_9084 = state_9080;
(statearr_9084[(7)] = inst_9057__$1);

return statearr_9084;
})();
if(cljs.core.truth_(inst_9058)){
var statearr_9085_9106 = state_9080__$1;
(statearr_9085_9106[(1)] = (5));

} else {
var statearr_9086_9107 = state_9080__$1;
(statearr_9086_9107[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9081 === (13))){
var state_9080__$1 = state_9080;
var statearr_9087_9108 = state_9080__$1;
(statearr_9087_9108[(2)] = null);

(statearr_9087_9108[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9081 === (6))){
var inst_9057 = (state_9080[(7)]);
var inst_9063 = p.call(null,inst_9057);
var state_9080__$1 = state_9080;
if(cljs.core.truth_(inst_9063)){
var statearr_9088_9109 = state_9080__$1;
(statearr_9088_9109[(1)] = (9));

} else {
var statearr_9089_9110 = state_9080__$1;
(statearr_9089_9110[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9081 === (3))){
var inst_9078 = (state_9080[(2)]);
var state_9080__$1 = state_9080;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9080__$1,inst_9078);
} else {
if((state_val_9081 === (12))){
var state_9080__$1 = state_9080;
var statearr_9090_9111 = state_9080__$1;
(statearr_9090_9111[(2)] = null);

(statearr_9090_9111[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9081 === (2))){
var state_9080__$1 = state_9080;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9080__$1,(4),ch);
} else {
if((state_val_9081 === (11))){
var inst_9057 = (state_9080[(7)]);
var inst_9067 = (state_9080[(2)]);
var state_9080__$1 = state_9080;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9080__$1,(8),inst_9067,inst_9057);
} else {
if((state_val_9081 === (9))){
var state_9080__$1 = state_9080;
var statearr_9091_9112 = state_9080__$1;
(statearr_9091_9112[(2)] = tc);

(statearr_9091_9112[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9081 === (5))){
var inst_9060 = cljs.core.async.close_BANG_.call(null,tc);
var inst_9061 = cljs.core.async.close_BANG_.call(null,fc);
var state_9080__$1 = (function (){var statearr_9092 = state_9080;
(statearr_9092[(8)] = inst_9060);

return statearr_9092;
})();
var statearr_9093_9113 = state_9080__$1;
(statearr_9093_9113[(2)] = inst_9061);

(statearr_9093_9113[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9081 === (14))){
var inst_9074 = (state_9080[(2)]);
var state_9080__$1 = state_9080;
var statearr_9094_9114 = state_9080__$1;
(statearr_9094_9114[(2)] = inst_9074);

(statearr_9094_9114[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9081 === (10))){
var state_9080__$1 = state_9080;
var statearr_9095_9115 = state_9080__$1;
(statearr_9095_9115[(2)] = fc);

(statearr_9095_9115[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9081 === (8))){
var inst_9069 = (state_9080[(2)]);
var state_9080__$1 = state_9080;
if(cljs.core.truth_(inst_9069)){
var statearr_9096_9116 = state_9080__$1;
(statearr_9096_9116[(1)] = (12));

} else {
var statearr_9097_9117 = state_9080__$1;
(statearr_9097_9117[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6791__auto___9103,tc,fc))
;
return ((function (switch__6624__auto__,c__6791__auto___9103,tc,fc){
return (function() {
var cljs$core$async$state_machine__6625__auto__ = null;
var cljs$core$async$state_machine__6625__auto____0 = (function (){
var statearr_9098 = [null,null,null,null,null,null,null,null,null];
(statearr_9098[(0)] = cljs$core$async$state_machine__6625__auto__);

(statearr_9098[(1)] = (1));

return statearr_9098;
});
var cljs$core$async$state_machine__6625__auto____1 = (function (state_9080){
while(true){
var ret_value__6626__auto__ = (function (){try{while(true){
var result__6627__auto__ = switch__6624__auto__.call(null,state_9080);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6627__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6627__auto__;
}
break;
}
}catch (e9099){if((e9099 instanceof Object)){
var ex__6628__auto__ = e9099;
var statearr_9100_9118 = state_9080;
(statearr_9100_9118[(5)] = ex__6628__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9080);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9099;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6626__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9119 = state_9080;
state_9080 = G__9119;
continue;
} else {
return ret_value__6626__auto__;
}
break;
}
});
cljs$core$async$state_machine__6625__auto__ = function(state_9080){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6625__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6625__auto____1.call(this,state_9080);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6625__auto____0;
cljs$core$async$state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6625__auto____1;
return cljs$core$async$state_machine__6625__auto__;
})()
;})(switch__6624__auto__,c__6791__auto___9103,tc,fc))
})();
var state__6793__auto__ = (function (){var statearr_9101 = f__6792__auto__.call(null);
(statearr_9101[(6)] = c__6791__auto___9103);

return statearr_9101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6793__auto__);
});})(c__6791__auto___9103,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__6791__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6791__auto__){
return (function (){
var f__6792__auto__ = (function (){var switch__6624__auto__ = ((function (c__6791__auto__){
return (function (state_9140){
var state_val_9141 = (state_9140[(1)]);
if((state_val_9141 === (7))){
var inst_9136 = (state_9140[(2)]);
var state_9140__$1 = state_9140;
var statearr_9142_9160 = state_9140__$1;
(statearr_9142_9160[(2)] = inst_9136);

(statearr_9142_9160[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9141 === (1))){
var inst_9120 = init;
var state_9140__$1 = (function (){var statearr_9143 = state_9140;
(statearr_9143[(7)] = inst_9120);

return statearr_9143;
})();
var statearr_9144_9161 = state_9140__$1;
(statearr_9144_9161[(2)] = null);

(statearr_9144_9161[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9141 === (4))){
var inst_9123 = (state_9140[(8)]);
var inst_9123__$1 = (state_9140[(2)]);
var inst_9124 = (inst_9123__$1 == null);
var state_9140__$1 = (function (){var statearr_9145 = state_9140;
(statearr_9145[(8)] = inst_9123__$1);

return statearr_9145;
})();
if(cljs.core.truth_(inst_9124)){
var statearr_9146_9162 = state_9140__$1;
(statearr_9146_9162[(1)] = (5));

} else {
var statearr_9147_9163 = state_9140__$1;
(statearr_9147_9163[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9141 === (6))){
var inst_9120 = (state_9140[(7)]);
var inst_9127 = (state_9140[(9)]);
var inst_9123 = (state_9140[(8)]);
var inst_9127__$1 = f.call(null,inst_9120,inst_9123);
var inst_9128 = cljs.core.reduced_QMARK_.call(null,inst_9127__$1);
var state_9140__$1 = (function (){var statearr_9148 = state_9140;
(statearr_9148[(9)] = inst_9127__$1);

return statearr_9148;
})();
if(inst_9128){
var statearr_9149_9164 = state_9140__$1;
(statearr_9149_9164[(1)] = (8));

} else {
var statearr_9150_9165 = state_9140__$1;
(statearr_9150_9165[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9141 === (3))){
var inst_9138 = (state_9140[(2)]);
var state_9140__$1 = state_9140;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9140__$1,inst_9138);
} else {
if((state_val_9141 === (2))){
var state_9140__$1 = state_9140;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9140__$1,(4),ch);
} else {
if((state_val_9141 === (9))){
var inst_9127 = (state_9140[(9)]);
var inst_9120 = inst_9127;
var state_9140__$1 = (function (){var statearr_9151 = state_9140;
(statearr_9151[(7)] = inst_9120);

return statearr_9151;
})();
var statearr_9152_9166 = state_9140__$1;
(statearr_9152_9166[(2)] = null);

(statearr_9152_9166[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9141 === (5))){
var inst_9120 = (state_9140[(7)]);
var state_9140__$1 = state_9140;
var statearr_9153_9167 = state_9140__$1;
(statearr_9153_9167[(2)] = inst_9120);

(statearr_9153_9167[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9141 === (10))){
var inst_9134 = (state_9140[(2)]);
var state_9140__$1 = state_9140;
var statearr_9154_9168 = state_9140__$1;
(statearr_9154_9168[(2)] = inst_9134);

(statearr_9154_9168[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9141 === (8))){
var inst_9127 = (state_9140[(9)]);
var inst_9130 = cljs.core.deref.call(null,inst_9127);
var state_9140__$1 = state_9140;
var statearr_9155_9169 = state_9140__$1;
(statearr_9155_9169[(2)] = inst_9130);

(statearr_9155_9169[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__6791__auto__))
;
return ((function (switch__6624__auto__,c__6791__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__6625__auto__ = null;
var cljs$core$async$reduce_$_state_machine__6625__auto____0 = (function (){
var statearr_9156 = [null,null,null,null,null,null,null,null,null,null];
(statearr_9156[(0)] = cljs$core$async$reduce_$_state_machine__6625__auto__);

(statearr_9156[(1)] = (1));

return statearr_9156;
});
var cljs$core$async$reduce_$_state_machine__6625__auto____1 = (function (state_9140){
while(true){
var ret_value__6626__auto__ = (function (){try{while(true){
var result__6627__auto__ = switch__6624__auto__.call(null,state_9140);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6627__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6627__auto__;
}
break;
}
}catch (e9157){if((e9157 instanceof Object)){
var ex__6628__auto__ = e9157;
var statearr_9158_9170 = state_9140;
(statearr_9158_9170[(5)] = ex__6628__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9140);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9157;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6626__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9171 = state_9140;
state_9140 = G__9171;
continue;
} else {
return ret_value__6626__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__6625__auto__ = function(state_9140){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__6625__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__6625__auto____1.call(this,state_9140);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__6625__auto____0;
cljs$core$async$reduce_$_state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__6625__auto____1;
return cljs$core$async$reduce_$_state_machine__6625__auto__;
})()
;})(switch__6624__auto__,c__6791__auto__))
})();
var state__6793__auto__ = (function (){var statearr_9159 = f__6792__auto__.call(null);
(statearr_9159[(6)] = c__6791__auto__);

return statearr_9159;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6793__auto__);
});})(c__6791__auto__))
);

return c__6791__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__6791__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6791__auto__,f__$1){
return (function (){
var f__6792__auto__ = (function (){var switch__6624__auto__ = ((function (c__6791__auto__,f__$1){
return (function (state_9177){
var state_val_9178 = (state_9177[(1)]);
if((state_val_9178 === (1))){
var inst_9172 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_9177__$1 = state_9177;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9177__$1,(2),inst_9172);
} else {
if((state_val_9178 === (2))){
var inst_9174 = (state_9177[(2)]);
var inst_9175 = f__$1.call(null,inst_9174);
var state_9177__$1 = state_9177;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9177__$1,inst_9175);
} else {
return null;
}
}
});})(c__6791__auto__,f__$1))
;
return ((function (switch__6624__auto__,c__6791__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__6625__auto__ = null;
var cljs$core$async$transduce_$_state_machine__6625__auto____0 = (function (){
var statearr_9179 = [null,null,null,null,null,null,null];
(statearr_9179[(0)] = cljs$core$async$transduce_$_state_machine__6625__auto__);

(statearr_9179[(1)] = (1));

return statearr_9179;
});
var cljs$core$async$transduce_$_state_machine__6625__auto____1 = (function (state_9177){
while(true){
var ret_value__6626__auto__ = (function (){try{while(true){
var result__6627__auto__ = switch__6624__auto__.call(null,state_9177);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6627__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6627__auto__;
}
break;
}
}catch (e9180){if((e9180 instanceof Object)){
var ex__6628__auto__ = e9180;
var statearr_9181_9183 = state_9177;
(statearr_9181_9183[(5)] = ex__6628__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9177);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9180;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6626__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9184 = state_9177;
state_9177 = G__9184;
continue;
} else {
return ret_value__6626__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__6625__auto__ = function(state_9177){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__6625__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__6625__auto____1.call(this,state_9177);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__6625__auto____0;
cljs$core$async$transduce_$_state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__6625__auto____1;
return cljs$core$async$transduce_$_state_machine__6625__auto__;
})()
;})(switch__6624__auto__,c__6791__auto__,f__$1))
})();
var state__6793__auto__ = (function (){var statearr_9182 = f__6792__auto__.call(null);
(statearr_9182[(6)] = c__6791__auto__);

return statearr_9182;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6793__auto__);
});})(c__6791__auto__,f__$1))
);

return c__6791__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__9186 = arguments.length;
switch (G__9186) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__6791__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6791__auto__){
return (function (){
var f__6792__auto__ = (function (){var switch__6624__auto__ = ((function (c__6791__auto__){
return (function (state_9211){
var state_val_9212 = (state_9211[(1)]);
if((state_val_9212 === (7))){
var inst_9193 = (state_9211[(2)]);
var state_9211__$1 = state_9211;
var statearr_9213_9234 = state_9211__$1;
(statearr_9213_9234[(2)] = inst_9193);

(statearr_9213_9234[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9212 === (1))){
var inst_9187 = cljs.core.seq.call(null,coll);
var inst_9188 = inst_9187;
var state_9211__$1 = (function (){var statearr_9214 = state_9211;
(statearr_9214[(7)] = inst_9188);

return statearr_9214;
})();
var statearr_9215_9235 = state_9211__$1;
(statearr_9215_9235[(2)] = null);

(statearr_9215_9235[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9212 === (4))){
var inst_9188 = (state_9211[(7)]);
var inst_9191 = cljs.core.first.call(null,inst_9188);
var state_9211__$1 = state_9211;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9211__$1,(7),ch,inst_9191);
} else {
if((state_val_9212 === (13))){
var inst_9205 = (state_9211[(2)]);
var state_9211__$1 = state_9211;
var statearr_9216_9236 = state_9211__$1;
(statearr_9216_9236[(2)] = inst_9205);

(statearr_9216_9236[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9212 === (6))){
var inst_9196 = (state_9211[(2)]);
var state_9211__$1 = state_9211;
if(cljs.core.truth_(inst_9196)){
var statearr_9217_9237 = state_9211__$1;
(statearr_9217_9237[(1)] = (8));

} else {
var statearr_9218_9238 = state_9211__$1;
(statearr_9218_9238[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9212 === (3))){
var inst_9209 = (state_9211[(2)]);
var state_9211__$1 = state_9211;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9211__$1,inst_9209);
} else {
if((state_val_9212 === (12))){
var state_9211__$1 = state_9211;
var statearr_9219_9239 = state_9211__$1;
(statearr_9219_9239[(2)] = null);

(statearr_9219_9239[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9212 === (2))){
var inst_9188 = (state_9211[(7)]);
var state_9211__$1 = state_9211;
if(cljs.core.truth_(inst_9188)){
var statearr_9220_9240 = state_9211__$1;
(statearr_9220_9240[(1)] = (4));

} else {
var statearr_9221_9241 = state_9211__$1;
(statearr_9221_9241[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9212 === (11))){
var inst_9202 = cljs.core.async.close_BANG_.call(null,ch);
var state_9211__$1 = state_9211;
var statearr_9222_9242 = state_9211__$1;
(statearr_9222_9242[(2)] = inst_9202);

(statearr_9222_9242[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9212 === (9))){
var state_9211__$1 = state_9211;
if(cljs.core.truth_(close_QMARK_)){
var statearr_9223_9243 = state_9211__$1;
(statearr_9223_9243[(1)] = (11));

} else {
var statearr_9224_9244 = state_9211__$1;
(statearr_9224_9244[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9212 === (5))){
var inst_9188 = (state_9211[(7)]);
var state_9211__$1 = state_9211;
var statearr_9225_9245 = state_9211__$1;
(statearr_9225_9245[(2)] = inst_9188);

(statearr_9225_9245[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9212 === (10))){
var inst_9207 = (state_9211[(2)]);
var state_9211__$1 = state_9211;
var statearr_9226_9246 = state_9211__$1;
(statearr_9226_9246[(2)] = inst_9207);

(statearr_9226_9246[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9212 === (8))){
var inst_9188 = (state_9211[(7)]);
var inst_9198 = cljs.core.next.call(null,inst_9188);
var inst_9188__$1 = inst_9198;
var state_9211__$1 = (function (){var statearr_9227 = state_9211;
(statearr_9227[(7)] = inst_9188__$1);

return statearr_9227;
})();
var statearr_9228_9247 = state_9211__$1;
(statearr_9228_9247[(2)] = null);

(statearr_9228_9247[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6791__auto__))
;
return ((function (switch__6624__auto__,c__6791__auto__){
return (function() {
var cljs$core$async$state_machine__6625__auto__ = null;
var cljs$core$async$state_machine__6625__auto____0 = (function (){
var statearr_9229 = [null,null,null,null,null,null,null,null];
(statearr_9229[(0)] = cljs$core$async$state_machine__6625__auto__);

(statearr_9229[(1)] = (1));

return statearr_9229;
});
var cljs$core$async$state_machine__6625__auto____1 = (function (state_9211){
while(true){
var ret_value__6626__auto__ = (function (){try{while(true){
var result__6627__auto__ = switch__6624__auto__.call(null,state_9211);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6627__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6627__auto__;
}
break;
}
}catch (e9230){if((e9230 instanceof Object)){
var ex__6628__auto__ = e9230;
var statearr_9231_9248 = state_9211;
(statearr_9231_9248[(5)] = ex__6628__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9211);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9230;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6626__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9249 = state_9211;
state_9211 = G__9249;
continue;
} else {
return ret_value__6626__auto__;
}
break;
}
});
cljs$core$async$state_machine__6625__auto__ = function(state_9211){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6625__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6625__auto____1.call(this,state_9211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6625__auto____0;
cljs$core$async$state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6625__auto____1;
return cljs$core$async$state_machine__6625__auto__;
})()
;})(switch__6624__auto__,c__6791__auto__))
})();
var state__6793__auto__ = (function (){var statearr_9232 = f__6792__auto__.call(null);
(statearr_9232[(6)] = c__6791__auto__);

return statearr_9232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6793__auto__);
});})(c__6791__auto__))
);

return c__6791__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4433__auto__ = (((_ == null))?null:_);
var m__4434__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,_);
} else {
var m__4431__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4431__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m);
} else {
var m__4431__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async9250 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async9250 = (function (ch,cs,meta9251){
this.ch = ch;
this.cs = cs;
this.meta9251 = meta9251;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async9250.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_9252,meta9251__$1){
var self__ = this;
var _9252__$1 = this;
return (new cljs.core.async.t_cljs$core$async9250(self__.ch,self__.cs,meta9251__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async9250.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_9252){
var self__ = this;
var _9252__$1 = this;
return self__.meta9251;
});})(cs))
;

cljs.core.async.t_cljs$core$async9250.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async9250.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async9250.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async9250.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async9250.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async9250.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async9250.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta9251","meta9251",-502212053,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async9250.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async9250.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async9250";

cljs.core.async.t_cljs$core$async9250.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async9250");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async9250.
 */
cljs.core.async.__GT_t_cljs$core$async9250 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async9250(ch__$1,cs__$1,meta9251){
return (new cljs.core.async.t_cljs$core$async9250(ch__$1,cs__$1,meta9251));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async9250(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__6791__auto___9472 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6791__auto___9472,cs,m,dchan,dctr,done){
return (function (){
var f__6792__auto__ = (function (){var switch__6624__auto__ = ((function (c__6791__auto___9472,cs,m,dchan,dctr,done){
return (function (state_9387){
var state_val_9388 = (state_9387[(1)]);
if((state_val_9388 === (7))){
var inst_9383 = (state_9387[(2)]);
var state_9387__$1 = state_9387;
var statearr_9389_9473 = state_9387__$1;
(statearr_9389_9473[(2)] = inst_9383);

(statearr_9389_9473[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (20))){
var inst_9286 = (state_9387[(7)]);
var inst_9298 = cljs.core.first.call(null,inst_9286);
var inst_9299 = cljs.core.nth.call(null,inst_9298,(0),null);
var inst_9300 = cljs.core.nth.call(null,inst_9298,(1),null);
var state_9387__$1 = (function (){var statearr_9390 = state_9387;
(statearr_9390[(8)] = inst_9299);

return statearr_9390;
})();
if(cljs.core.truth_(inst_9300)){
var statearr_9391_9474 = state_9387__$1;
(statearr_9391_9474[(1)] = (22));

} else {
var statearr_9392_9475 = state_9387__$1;
(statearr_9392_9475[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (27))){
var inst_9328 = (state_9387[(9)]);
var inst_9255 = (state_9387[(10)]);
var inst_9335 = (state_9387[(11)]);
var inst_9330 = (state_9387[(12)]);
var inst_9335__$1 = cljs.core._nth.call(null,inst_9328,inst_9330);
var inst_9336 = cljs.core.async.put_BANG_.call(null,inst_9335__$1,inst_9255,done);
var state_9387__$1 = (function (){var statearr_9393 = state_9387;
(statearr_9393[(11)] = inst_9335__$1);

return statearr_9393;
})();
if(cljs.core.truth_(inst_9336)){
var statearr_9394_9476 = state_9387__$1;
(statearr_9394_9476[(1)] = (30));

} else {
var statearr_9395_9477 = state_9387__$1;
(statearr_9395_9477[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (1))){
var state_9387__$1 = state_9387;
var statearr_9396_9478 = state_9387__$1;
(statearr_9396_9478[(2)] = null);

(statearr_9396_9478[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (24))){
var inst_9286 = (state_9387[(7)]);
var inst_9305 = (state_9387[(2)]);
var inst_9306 = cljs.core.next.call(null,inst_9286);
var inst_9264 = inst_9306;
var inst_9265 = null;
var inst_9266 = (0);
var inst_9267 = (0);
var state_9387__$1 = (function (){var statearr_9397 = state_9387;
(statearr_9397[(13)] = inst_9305);

(statearr_9397[(14)] = inst_9267);

(statearr_9397[(15)] = inst_9264);

(statearr_9397[(16)] = inst_9265);

(statearr_9397[(17)] = inst_9266);

return statearr_9397;
})();
var statearr_9398_9479 = state_9387__$1;
(statearr_9398_9479[(2)] = null);

(statearr_9398_9479[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (39))){
var state_9387__$1 = state_9387;
var statearr_9402_9480 = state_9387__$1;
(statearr_9402_9480[(2)] = null);

(statearr_9402_9480[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (4))){
var inst_9255 = (state_9387[(10)]);
var inst_9255__$1 = (state_9387[(2)]);
var inst_9256 = (inst_9255__$1 == null);
var state_9387__$1 = (function (){var statearr_9403 = state_9387;
(statearr_9403[(10)] = inst_9255__$1);

return statearr_9403;
})();
if(cljs.core.truth_(inst_9256)){
var statearr_9404_9481 = state_9387__$1;
(statearr_9404_9481[(1)] = (5));

} else {
var statearr_9405_9482 = state_9387__$1;
(statearr_9405_9482[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (15))){
var inst_9267 = (state_9387[(14)]);
var inst_9264 = (state_9387[(15)]);
var inst_9265 = (state_9387[(16)]);
var inst_9266 = (state_9387[(17)]);
var inst_9282 = (state_9387[(2)]);
var inst_9283 = (inst_9267 + (1));
var tmp9399 = inst_9264;
var tmp9400 = inst_9265;
var tmp9401 = inst_9266;
var inst_9264__$1 = tmp9399;
var inst_9265__$1 = tmp9400;
var inst_9266__$1 = tmp9401;
var inst_9267__$1 = inst_9283;
var state_9387__$1 = (function (){var statearr_9406 = state_9387;
(statearr_9406[(14)] = inst_9267__$1);

(statearr_9406[(15)] = inst_9264__$1);

(statearr_9406[(18)] = inst_9282);

(statearr_9406[(16)] = inst_9265__$1);

(statearr_9406[(17)] = inst_9266__$1);

return statearr_9406;
})();
var statearr_9407_9483 = state_9387__$1;
(statearr_9407_9483[(2)] = null);

(statearr_9407_9483[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (21))){
var inst_9309 = (state_9387[(2)]);
var state_9387__$1 = state_9387;
var statearr_9411_9484 = state_9387__$1;
(statearr_9411_9484[(2)] = inst_9309);

(statearr_9411_9484[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (31))){
var inst_9335 = (state_9387[(11)]);
var inst_9339 = done.call(null,null);
var inst_9340 = cljs.core.async.untap_STAR_.call(null,m,inst_9335);
var state_9387__$1 = (function (){var statearr_9412 = state_9387;
(statearr_9412[(19)] = inst_9339);

return statearr_9412;
})();
var statearr_9413_9485 = state_9387__$1;
(statearr_9413_9485[(2)] = inst_9340);

(statearr_9413_9485[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (32))){
var inst_9328 = (state_9387[(9)]);
var inst_9329 = (state_9387[(20)]);
var inst_9327 = (state_9387[(21)]);
var inst_9330 = (state_9387[(12)]);
var inst_9342 = (state_9387[(2)]);
var inst_9343 = (inst_9330 + (1));
var tmp9408 = inst_9328;
var tmp9409 = inst_9329;
var tmp9410 = inst_9327;
var inst_9327__$1 = tmp9410;
var inst_9328__$1 = tmp9408;
var inst_9329__$1 = tmp9409;
var inst_9330__$1 = inst_9343;
var state_9387__$1 = (function (){var statearr_9414 = state_9387;
(statearr_9414[(9)] = inst_9328__$1);

(statearr_9414[(20)] = inst_9329__$1);

(statearr_9414[(21)] = inst_9327__$1);

(statearr_9414[(22)] = inst_9342);

(statearr_9414[(12)] = inst_9330__$1);

return statearr_9414;
})();
var statearr_9415_9486 = state_9387__$1;
(statearr_9415_9486[(2)] = null);

(statearr_9415_9486[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (40))){
var inst_9355 = (state_9387[(23)]);
var inst_9359 = done.call(null,null);
var inst_9360 = cljs.core.async.untap_STAR_.call(null,m,inst_9355);
var state_9387__$1 = (function (){var statearr_9416 = state_9387;
(statearr_9416[(24)] = inst_9359);

return statearr_9416;
})();
var statearr_9417_9487 = state_9387__$1;
(statearr_9417_9487[(2)] = inst_9360);

(statearr_9417_9487[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (33))){
var inst_9346 = (state_9387[(25)]);
var inst_9348 = cljs.core.chunked_seq_QMARK_.call(null,inst_9346);
var state_9387__$1 = state_9387;
if(inst_9348){
var statearr_9418_9488 = state_9387__$1;
(statearr_9418_9488[(1)] = (36));

} else {
var statearr_9419_9489 = state_9387__$1;
(statearr_9419_9489[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (13))){
var inst_9276 = (state_9387[(26)]);
var inst_9279 = cljs.core.async.close_BANG_.call(null,inst_9276);
var state_9387__$1 = state_9387;
var statearr_9420_9490 = state_9387__$1;
(statearr_9420_9490[(2)] = inst_9279);

(statearr_9420_9490[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (22))){
var inst_9299 = (state_9387[(8)]);
var inst_9302 = cljs.core.async.close_BANG_.call(null,inst_9299);
var state_9387__$1 = state_9387;
var statearr_9421_9491 = state_9387__$1;
(statearr_9421_9491[(2)] = inst_9302);

(statearr_9421_9491[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (36))){
var inst_9346 = (state_9387[(25)]);
var inst_9350 = cljs.core.chunk_first.call(null,inst_9346);
var inst_9351 = cljs.core.chunk_rest.call(null,inst_9346);
var inst_9352 = cljs.core.count.call(null,inst_9350);
var inst_9327 = inst_9351;
var inst_9328 = inst_9350;
var inst_9329 = inst_9352;
var inst_9330 = (0);
var state_9387__$1 = (function (){var statearr_9422 = state_9387;
(statearr_9422[(9)] = inst_9328);

(statearr_9422[(20)] = inst_9329);

(statearr_9422[(21)] = inst_9327);

(statearr_9422[(12)] = inst_9330);

return statearr_9422;
})();
var statearr_9423_9492 = state_9387__$1;
(statearr_9423_9492[(2)] = null);

(statearr_9423_9492[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (41))){
var inst_9346 = (state_9387[(25)]);
var inst_9362 = (state_9387[(2)]);
var inst_9363 = cljs.core.next.call(null,inst_9346);
var inst_9327 = inst_9363;
var inst_9328 = null;
var inst_9329 = (0);
var inst_9330 = (0);
var state_9387__$1 = (function (){var statearr_9424 = state_9387;
(statearr_9424[(9)] = inst_9328);

(statearr_9424[(27)] = inst_9362);

(statearr_9424[(20)] = inst_9329);

(statearr_9424[(21)] = inst_9327);

(statearr_9424[(12)] = inst_9330);

return statearr_9424;
})();
var statearr_9425_9493 = state_9387__$1;
(statearr_9425_9493[(2)] = null);

(statearr_9425_9493[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (43))){
var state_9387__$1 = state_9387;
var statearr_9426_9494 = state_9387__$1;
(statearr_9426_9494[(2)] = null);

(statearr_9426_9494[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (29))){
var inst_9371 = (state_9387[(2)]);
var state_9387__$1 = state_9387;
var statearr_9427_9495 = state_9387__$1;
(statearr_9427_9495[(2)] = inst_9371);

(statearr_9427_9495[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (44))){
var inst_9380 = (state_9387[(2)]);
var state_9387__$1 = (function (){var statearr_9428 = state_9387;
(statearr_9428[(28)] = inst_9380);

return statearr_9428;
})();
var statearr_9429_9496 = state_9387__$1;
(statearr_9429_9496[(2)] = null);

(statearr_9429_9496[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (6))){
var inst_9319 = (state_9387[(29)]);
var inst_9318 = cljs.core.deref.call(null,cs);
var inst_9319__$1 = cljs.core.keys.call(null,inst_9318);
var inst_9320 = cljs.core.count.call(null,inst_9319__$1);
var inst_9321 = cljs.core.reset_BANG_.call(null,dctr,inst_9320);
var inst_9326 = cljs.core.seq.call(null,inst_9319__$1);
var inst_9327 = inst_9326;
var inst_9328 = null;
var inst_9329 = (0);
var inst_9330 = (0);
var state_9387__$1 = (function (){var statearr_9430 = state_9387;
(statearr_9430[(9)] = inst_9328);

(statearr_9430[(30)] = inst_9321);

(statearr_9430[(29)] = inst_9319__$1);

(statearr_9430[(20)] = inst_9329);

(statearr_9430[(21)] = inst_9327);

(statearr_9430[(12)] = inst_9330);

return statearr_9430;
})();
var statearr_9431_9497 = state_9387__$1;
(statearr_9431_9497[(2)] = null);

(statearr_9431_9497[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (28))){
var inst_9327 = (state_9387[(21)]);
var inst_9346 = (state_9387[(25)]);
var inst_9346__$1 = cljs.core.seq.call(null,inst_9327);
var state_9387__$1 = (function (){var statearr_9432 = state_9387;
(statearr_9432[(25)] = inst_9346__$1);

return statearr_9432;
})();
if(inst_9346__$1){
var statearr_9433_9498 = state_9387__$1;
(statearr_9433_9498[(1)] = (33));

} else {
var statearr_9434_9499 = state_9387__$1;
(statearr_9434_9499[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (25))){
var inst_9329 = (state_9387[(20)]);
var inst_9330 = (state_9387[(12)]);
var inst_9332 = (inst_9330 < inst_9329);
var inst_9333 = inst_9332;
var state_9387__$1 = state_9387;
if(cljs.core.truth_(inst_9333)){
var statearr_9435_9500 = state_9387__$1;
(statearr_9435_9500[(1)] = (27));

} else {
var statearr_9436_9501 = state_9387__$1;
(statearr_9436_9501[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (34))){
var state_9387__$1 = state_9387;
var statearr_9437_9502 = state_9387__$1;
(statearr_9437_9502[(2)] = null);

(statearr_9437_9502[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (17))){
var state_9387__$1 = state_9387;
var statearr_9438_9503 = state_9387__$1;
(statearr_9438_9503[(2)] = null);

(statearr_9438_9503[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (3))){
var inst_9385 = (state_9387[(2)]);
var state_9387__$1 = state_9387;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9387__$1,inst_9385);
} else {
if((state_val_9388 === (12))){
var inst_9314 = (state_9387[(2)]);
var state_9387__$1 = state_9387;
var statearr_9439_9504 = state_9387__$1;
(statearr_9439_9504[(2)] = inst_9314);

(statearr_9439_9504[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (2))){
var state_9387__$1 = state_9387;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9387__$1,(4),ch);
} else {
if((state_val_9388 === (23))){
var state_9387__$1 = state_9387;
var statearr_9440_9505 = state_9387__$1;
(statearr_9440_9505[(2)] = null);

(statearr_9440_9505[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (35))){
var inst_9369 = (state_9387[(2)]);
var state_9387__$1 = state_9387;
var statearr_9441_9506 = state_9387__$1;
(statearr_9441_9506[(2)] = inst_9369);

(statearr_9441_9506[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (19))){
var inst_9286 = (state_9387[(7)]);
var inst_9290 = cljs.core.chunk_first.call(null,inst_9286);
var inst_9291 = cljs.core.chunk_rest.call(null,inst_9286);
var inst_9292 = cljs.core.count.call(null,inst_9290);
var inst_9264 = inst_9291;
var inst_9265 = inst_9290;
var inst_9266 = inst_9292;
var inst_9267 = (0);
var state_9387__$1 = (function (){var statearr_9442 = state_9387;
(statearr_9442[(14)] = inst_9267);

(statearr_9442[(15)] = inst_9264);

(statearr_9442[(16)] = inst_9265);

(statearr_9442[(17)] = inst_9266);

return statearr_9442;
})();
var statearr_9443_9507 = state_9387__$1;
(statearr_9443_9507[(2)] = null);

(statearr_9443_9507[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (11))){
var inst_9286 = (state_9387[(7)]);
var inst_9264 = (state_9387[(15)]);
var inst_9286__$1 = cljs.core.seq.call(null,inst_9264);
var state_9387__$1 = (function (){var statearr_9444 = state_9387;
(statearr_9444[(7)] = inst_9286__$1);

return statearr_9444;
})();
if(inst_9286__$1){
var statearr_9445_9508 = state_9387__$1;
(statearr_9445_9508[(1)] = (16));

} else {
var statearr_9446_9509 = state_9387__$1;
(statearr_9446_9509[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (9))){
var inst_9316 = (state_9387[(2)]);
var state_9387__$1 = state_9387;
var statearr_9447_9510 = state_9387__$1;
(statearr_9447_9510[(2)] = inst_9316);

(statearr_9447_9510[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (5))){
var inst_9262 = cljs.core.deref.call(null,cs);
var inst_9263 = cljs.core.seq.call(null,inst_9262);
var inst_9264 = inst_9263;
var inst_9265 = null;
var inst_9266 = (0);
var inst_9267 = (0);
var state_9387__$1 = (function (){var statearr_9448 = state_9387;
(statearr_9448[(14)] = inst_9267);

(statearr_9448[(15)] = inst_9264);

(statearr_9448[(16)] = inst_9265);

(statearr_9448[(17)] = inst_9266);

return statearr_9448;
})();
var statearr_9449_9511 = state_9387__$1;
(statearr_9449_9511[(2)] = null);

(statearr_9449_9511[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (14))){
var state_9387__$1 = state_9387;
var statearr_9450_9512 = state_9387__$1;
(statearr_9450_9512[(2)] = null);

(statearr_9450_9512[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (45))){
var inst_9377 = (state_9387[(2)]);
var state_9387__$1 = state_9387;
var statearr_9451_9513 = state_9387__$1;
(statearr_9451_9513[(2)] = inst_9377);

(statearr_9451_9513[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (26))){
var inst_9319 = (state_9387[(29)]);
var inst_9373 = (state_9387[(2)]);
var inst_9374 = cljs.core.seq.call(null,inst_9319);
var state_9387__$1 = (function (){var statearr_9452 = state_9387;
(statearr_9452[(31)] = inst_9373);

return statearr_9452;
})();
if(inst_9374){
var statearr_9453_9514 = state_9387__$1;
(statearr_9453_9514[(1)] = (42));

} else {
var statearr_9454_9515 = state_9387__$1;
(statearr_9454_9515[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (16))){
var inst_9286 = (state_9387[(7)]);
var inst_9288 = cljs.core.chunked_seq_QMARK_.call(null,inst_9286);
var state_9387__$1 = state_9387;
if(inst_9288){
var statearr_9455_9516 = state_9387__$1;
(statearr_9455_9516[(1)] = (19));

} else {
var statearr_9456_9517 = state_9387__$1;
(statearr_9456_9517[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (38))){
var inst_9366 = (state_9387[(2)]);
var state_9387__$1 = state_9387;
var statearr_9457_9518 = state_9387__$1;
(statearr_9457_9518[(2)] = inst_9366);

(statearr_9457_9518[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (30))){
var state_9387__$1 = state_9387;
var statearr_9458_9519 = state_9387__$1;
(statearr_9458_9519[(2)] = null);

(statearr_9458_9519[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (10))){
var inst_9267 = (state_9387[(14)]);
var inst_9265 = (state_9387[(16)]);
var inst_9275 = cljs.core._nth.call(null,inst_9265,inst_9267);
var inst_9276 = cljs.core.nth.call(null,inst_9275,(0),null);
var inst_9277 = cljs.core.nth.call(null,inst_9275,(1),null);
var state_9387__$1 = (function (){var statearr_9459 = state_9387;
(statearr_9459[(26)] = inst_9276);

return statearr_9459;
})();
if(cljs.core.truth_(inst_9277)){
var statearr_9460_9520 = state_9387__$1;
(statearr_9460_9520[(1)] = (13));

} else {
var statearr_9461_9521 = state_9387__$1;
(statearr_9461_9521[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (18))){
var inst_9312 = (state_9387[(2)]);
var state_9387__$1 = state_9387;
var statearr_9462_9522 = state_9387__$1;
(statearr_9462_9522[(2)] = inst_9312);

(statearr_9462_9522[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (42))){
var state_9387__$1 = state_9387;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9387__$1,(45),dchan);
} else {
if((state_val_9388 === (37))){
var inst_9255 = (state_9387[(10)]);
var inst_9355 = (state_9387[(23)]);
var inst_9346 = (state_9387[(25)]);
var inst_9355__$1 = cljs.core.first.call(null,inst_9346);
var inst_9356 = cljs.core.async.put_BANG_.call(null,inst_9355__$1,inst_9255,done);
var state_9387__$1 = (function (){var statearr_9463 = state_9387;
(statearr_9463[(23)] = inst_9355__$1);

return statearr_9463;
})();
if(cljs.core.truth_(inst_9356)){
var statearr_9464_9523 = state_9387__$1;
(statearr_9464_9523[(1)] = (39));

} else {
var statearr_9465_9524 = state_9387__$1;
(statearr_9465_9524[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9388 === (8))){
var inst_9267 = (state_9387[(14)]);
var inst_9266 = (state_9387[(17)]);
var inst_9269 = (inst_9267 < inst_9266);
var inst_9270 = inst_9269;
var state_9387__$1 = state_9387;
if(cljs.core.truth_(inst_9270)){
var statearr_9466_9525 = state_9387__$1;
(statearr_9466_9525[(1)] = (10));

} else {
var statearr_9467_9526 = state_9387__$1;
(statearr_9467_9526[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6791__auto___9472,cs,m,dchan,dctr,done))
;
return ((function (switch__6624__auto__,c__6791__auto___9472,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__6625__auto__ = null;
var cljs$core$async$mult_$_state_machine__6625__auto____0 = (function (){
var statearr_9468 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_9468[(0)] = cljs$core$async$mult_$_state_machine__6625__auto__);

(statearr_9468[(1)] = (1));

return statearr_9468;
});
var cljs$core$async$mult_$_state_machine__6625__auto____1 = (function (state_9387){
while(true){
var ret_value__6626__auto__ = (function (){try{while(true){
var result__6627__auto__ = switch__6624__auto__.call(null,state_9387);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6627__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6627__auto__;
}
break;
}
}catch (e9469){if((e9469 instanceof Object)){
var ex__6628__auto__ = e9469;
var statearr_9470_9527 = state_9387;
(statearr_9470_9527[(5)] = ex__6628__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9387);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9469;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6626__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9528 = state_9387;
state_9387 = G__9528;
continue;
} else {
return ret_value__6626__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__6625__auto__ = function(state_9387){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__6625__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__6625__auto____1.call(this,state_9387);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__6625__auto____0;
cljs$core$async$mult_$_state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__6625__auto____1;
return cljs$core$async$mult_$_state_machine__6625__auto__;
})()
;})(switch__6624__auto__,c__6791__auto___9472,cs,m,dchan,dctr,done))
})();
var state__6793__auto__ = (function (){var statearr_9471 = f__6792__auto__.call(null);
(statearr_9471[(6)] = c__6791__auto___9472);

return statearr_9471;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6793__auto__);
});})(c__6791__auto___9472,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__9530 = arguments.length;
switch (G__9530) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m);
} else {
var m__4431__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,state_map);
} else {
var m__4431__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,mode);
} else {
var m__4431__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___9542 = arguments.length;
var i__4731__auto___9543 = (0);
while(true){
if((i__4731__auto___9543 < len__4730__auto___9542)){
args__4736__auto__.push((arguments[i__4731__auto___9543]));

var G__9544 = (i__4731__auto___9543 + (1));
i__4731__auto___9543 = G__9544;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__9536){
var map__9537 = p__9536;
var map__9537__$1 = (((((!((map__9537 == null))))?(((((map__9537.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9537.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9537):map__9537);
var opts = map__9537__$1;
var statearr_9539_9545 = state;
(statearr_9539_9545[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts.call(null,((function (map__9537,map__9537__$1,opts){
return (function (val){
var statearr_9540_9546 = state;
(statearr_9540_9546[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__9537,map__9537__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_9541_9547 = state;
(statearr_9541_9547[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq9532){
var G__9533 = cljs.core.first.call(null,seq9532);
var seq9532__$1 = cljs.core.next.call(null,seq9532);
var G__9534 = cljs.core.first.call(null,seq9532__$1);
var seq9532__$2 = cljs.core.next.call(null,seq9532__$1);
var G__9535 = cljs.core.first.call(null,seq9532__$2);
var seq9532__$3 = cljs.core.next.call(null,seq9532__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__9533,G__9534,G__9535,seq9532__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async9548 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async9548 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta9549){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta9549 = meta9549;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async9548.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_9550,meta9549__$1){
var self__ = this;
var _9550__$1 = this;
return (new cljs.core.async.t_cljs$core$async9548(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta9549__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9548.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_9550){
var self__ = this;
var _9550__$1 = this;
return self__.meta9549;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9548.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async9548.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9548.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async9548.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9548.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9548.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9548.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9548.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9548.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta9549","meta9549",-179022068,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9548.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async9548.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async9548";

cljs.core.async.t_cljs$core$async9548.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async9548");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async9548.
 */
cljs.core.async.__GT_t_cljs$core$async9548 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async9548(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta9549){
return (new cljs.core.async.t_cljs$core$async9548(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta9549));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async9548(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__6791__auto___9712 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6791__auto___9712,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__6792__auto__ = (function (){var switch__6624__auto__ = ((function (c__6791__auto___9712,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_9652){
var state_val_9653 = (state_9652[(1)]);
if((state_val_9653 === (7))){
var inst_9567 = (state_9652[(2)]);
var state_9652__$1 = state_9652;
var statearr_9654_9713 = state_9652__$1;
(statearr_9654_9713[(2)] = inst_9567);

(statearr_9654_9713[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (20))){
var inst_9579 = (state_9652[(7)]);
var state_9652__$1 = state_9652;
var statearr_9655_9714 = state_9652__$1;
(statearr_9655_9714[(2)] = inst_9579);

(statearr_9655_9714[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (27))){
var state_9652__$1 = state_9652;
var statearr_9656_9715 = state_9652__$1;
(statearr_9656_9715[(2)] = null);

(statearr_9656_9715[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (1))){
var inst_9554 = (state_9652[(8)]);
var inst_9554__$1 = calc_state.call(null);
var inst_9556 = (inst_9554__$1 == null);
var inst_9557 = cljs.core.not.call(null,inst_9556);
var state_9652__$1 = (function (){var statearr_9657 = state_9652;
(statearr_9657[(8)] = inst_9554__$1);

return statearr_9657;
})();
if(inst_9557){
var statearr_9658_9716 = state_9652__$1;
(statearr_9658_9716[(1)] = (2));

} else {
var statearr_9659_9717 = state_9652__$1;
(statearr_9659_9717[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (24))){
var inst_9612 = (state_9652[(9)]);
var inst_9603 = (state_9652[(10)]);
var inst_9626 = (state_9652[(11)]);
var inst_9626__$1 = inst_9603.call(null,inst_9612);
var state_9652__$1 = (function (){var statearr_9660 = state_9652;
(statearr_9660[(11)] = inst_9626__$1);

return statearr_9660;
})();
if(cljs.core.truth_(inst_9626__$1)){
var statearr_9661_9718 = state_9652__$1;
(statearr_9661_9718[(1)] = (29));

} else {
var statearr_9662_9719 = state_9652__$1;
(statearr_9662_9719[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (4))){
var inst_9570 = (state_9652[(2)]);
var state_9652__$1 = state_9652;
if(cljs.core.truth_(inst_9570)){
var statearr_9663_9720 = state_9652__$1;
(statearr_9663_9720[(1)] = (8));

} else {
var statearr_9664_9721 = state_9652__$1;
(statearr_9664_9721[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (15))){
var inst_9597 = (state_9652[(2)]);
var state_9652__$1 = state_9652;
if(cljs.core.truth_(inst_9597)){
var statearr_9665_9722 = state_9652__$1;
(statearr_9665_9722[(1)] = (19));

} else {
var statearr_9666_9723 = state_9652__$1;
(statearr_9666_9723[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (21))){
var inst_9602 = (state_9652[(12)]);
var inst_9602__$1 = (state_9652[(2)]);
var inst_9603 = cljs.core.get.call(null,inst_9602__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_9604 = cljs.core.get.call(null,inst_9602__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_9605 = cljs.core.get.call(null,inst_9602__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_9652__$1 = (function (){var statearr_9667 = state_9652;
(statearr_9667[(10)] = inst_9603);

(statearr_9667[(12)] = inst_9602__$1);

(statearr_9667[(13)] = inst_9604);

return statearr_9667;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_9652__$1,(22),inst_9605);
} else {
if((state_val_9653 === (31))){
var inst_9634 = (state_9652[(2)]);
var state_9652__$1 = state_9652;
if(cljs.core.truth_(inst_9634)){
var statearr_9668_9724 = state_9652__$1;
(statearr_9668_9724[(1)] = (32));

} else {
var statearr_9669_9725 = state_9652__$1;
(statearr_9669_9725[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (32))){
var inst_9611 = (state_9652[(14)]);
var state_9652__$1 = state_9652;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9652__$1,(35),out,inst_9611);
} else {
if((state_val_9653 === (33))){
var inst_9602 = (state_9652[(12)]);
var inst_9579 = inst_9602;
var state_9652__$1 = (function (){var statearr_9670 = state_9652;
(statearr_9670[(7)] = inst_9579);

return statearr_9670;
})();
var statearr_9671_9726 = state_9652__$1;
(statearr_9671_9726[(2)] = null);

(statearr_9671_9726[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (13))){
var inst_9579 = (state_9652[(7)]);
var inst_9586 = inst_9579.cljs$lang$protocol_mask$partition0$;
var inst_9587 = (inst_9586 & (64));
var inst_9588 = inst_9579.cljs$core$ISeq$;
var inst_9589 = (cljs.core.PROTOCOL_SENTINEL === inst_9588);
var inst_9590 = ((inst_9587) || (inst_9589));
var state_9652__$1 = state_9652;
if(cljs.core.truth_(inst_9590)){
var statearr_9672_9727 = state_9652__$1;
(statearr_9672_9727[(1)] = (16));

} else {
var statearr_9673_9728 = state_9652__$1;
(statearr_9673_9728[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (22))){
var inst_9612 = (state_9652[(9)]);
var inst_9611 = (state_9652[(14)]);
var inst_9610 = (state_9652[(2)]);
var inst_9611__$1 = cljs.core.nth.call(null,inst_9610,(0),null);
var inst_9612__$1 = cljs.core.nth.call(null,inst_9610,(1),null);
var inst_9613 = (inst_9611__$1 == null);
var inst_9614 = cljs.core._EQ_.call(null,inst_9612__$1,change);
var inst_9615 = ((inst_9613) || (inst_9614));
var state_9652__$1 = (function (){var statearr_9674 = state_9652;
(statearr_9674[(9)] = inst_9612__$1);

(statearr_9674[(14)] = inst_9611__$1);

return statearr_9674;
})();
if(cljs.core.truth_(inst_9615)){
var statearr_9675_9729 = state_9652__$1;
(statearr_9675_9729[(1)] = (23));

} else {
var statearr_9676_9730 = state_9652__$1;
(statearr_9676_9730[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (36))){
var inst_9602 = (state_9652[(12)]);
var inst_9579 = inst_9602;
var state_9652__$1 = (function (){var statearr_9677 = state_9652;
(statearr_9677[(7)] = inst_9579);

return statearr_9677;
})();
var statearr_9678_9731 = state_9652__$1;
(statearr_9678_9731[(2)] = null);

(statearr_9678_9731[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (29))){
var inst_9626 = (state_9652[(11)]);
var state_9652__$1 = state_9652;
var statearr_9679_9732 = state_9652__$1;
(statearr_9679_9732[(2)] = inst_9626);

(statearr_9679_9732[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (6))){
var state_9652__$1 = state_9652;
var statearr_9680_9733 = state_9652__$1;
(statearr_9680_9733[(2)] = false);

(statearr_9680_9733[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (28))){
var inst_9622 = (state_9652[(2)]);
var inst_9623 = calc_state.call(null);
var inst_9579 = inst_9623;
var state_9652__$1 = (function (){var statearr_9681 = state_9652;
(statearr_9681[(15)] = inst_9622);

(statearr_9681[(7)] = inst_9579);

return statearr_9681;
})();
var statearr_9682_9734 = state_9652__$1;
(statearr_9682_9734[(2)] = null);

(statearr_9682_9734[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (25))){
var inst_9648 = (state_9652[(2)]);
var state_9652__$1 = state_9652;
var statearr_9683_9735 = state_9652__$1;
(statearr_9683_9735[(2)] = inst_9648);

(statearr_9683_9735[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (34))){
var inst_9646 = (state_9652[(2)]);
var state_9652__$1 = state_9652;
var statearr_9684_9736 = state_9652__$1;
(statearr_9684_9736[(2)] = inst_9646);

(statearr_9684_9736[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (17))){
var state_9652__$1 = state_9652;
var statearr_9685_9737 = state_9652__$1;
(statearr_9685_9737[(2)] = false);

(statearr_9685_9737[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (3))){
var state_9652__$1 = state_9652;
var statearr_9686_9738 = state_9652__$1;
(statearr_9686_9738[(2)] = false);

(statearr_9686_9738[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (12))){
var inst_9650 = (state_9652[(2)]);
var state_9652__$1 = state_9652;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9652__$1,inst_9650);
} else {
if((state_val_9653 === (2))){
var inst_9554 = (state_9652[(8)]);
var inst_9559 = inst_9554.cljs$lang$protocol_mask$partition0$;
var inst_9560 = (inst_9559 & (64));
var inst_9561 = inst_9554.cljs$core$ISeq$;
var inst_9562 = (cljs.core.PROTOCOL_SENTINEL === inst_9561);
var inst_9563 = ((inst_9560) || (inst_9562));
var state_9652__$1 = state_9652;
if(cljs.core.truth_(inst_9563)){
var statearr_9687_9739 = state_9652__$1;
(statearr_9687_9739[(1)] = (5));

} else {
var statearr_9688_9740 = state_9652__$1;
(statearr_9688_9740[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (23))){
var inst_9611 = (state_9652[(14)]);
var inst_9617 = (inst_9611 == null);
var state_9652__$1 = state_9652;
if(cljs.core.truth_(inst_9617)){
var statearr_9689_9741 = state_9652__$1;
(statearr_9689_9741[(1)] = (26));

} else {
var statearr_9690_9742 = state_9652__$1;
(statearr_9690_9742[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (35))){
var inst_9637 = (state_9652[(2)]);
var state_9652__$1 = state_9652;
if(cljs.core.truth_(inst_9637)){
var statearr_9691_9743 = state_9652__$1;
(statearr_9691_9743[(1)] = (36));

} else {
var statearr_9692_9744 = state_9652__$1;
(statearr_9692_9744[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (19))){
var inst_9579 = (state_9652[(7)]);
var inst_9599 = cljs.core.apply.call(null,cljs.core.hash_map,inst_9579);
var state_9652__$1 = state_9652;
var statearr_9693_9745 = state_9652__$1;
(statearr_9693_9745[(2)] = inst_9599);

(statearr_9693_9745[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (11))){
var inst_9579 = (state_9652[(7)]);
var inst_9583 = (inst_9579 == null);
var inst_9584 = cljs.core.not.call(null,inst_9583);
var state_9652__$1 = state_9652;
if(inst_9584){
var statearr_9694_9746 = state_9652__$1;
(statearr_9694_9746[(1)] = (13));

} else {
var statearr_9695_9747 = state_9652__$1;
(statearr_9695_9747[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (9))){
var inst_9554 = (state_9652[(8)]);
var state_9652__$1 = state_9652;
var statearr_9696_9748 = state_9652__$1;
(statearr_9696_9748[(2)] = inst_9554);

(statearr_9696_9748[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (5))){
var state_9652__$1 = state_9652;
var statearr_9697_9749 = state_9652__$1;
(statearr_9697_9749[(2)] = true);

(statearr_9697_9749[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (14))){
var state_9652__$1 = state_9652;
var statearr_9698_9750 = state_9652__$1;
(statearr_9698_9750[(2)] = false);

(statearr_9698_9750[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (26))){
var inst_9612 = (state_9652[(9)]);
var inst_9619 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_9612);
var state_9652__$1 = state_9652;
var statearr_9699_9751 = state_9652__$1;
(statearr_9699_9751[(2)] = inst_9619);

(statearr_9699_9751[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (16))){
var state_9652__$1 = state_9652;
var statearr_9700_9752 = state_9652__$1;
(statearr_9700_9752[(2)] = true);

(statearr_9700_9752[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (38))){
var inst_9642 = (state_9652[(2)]);
var state_9652__$1 = state_9652;
var statearr_9701_9753 = state_9652__$1;
(statearr_9701_9753[(2)] = inst_9642);

(statearr_9701_9753[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (30))){
var inst_9612 = (state_9652[(9)]);
var inst_9603 = (state_9652[(10)]);
var inst_9604 = (state_9652[(13)]);
var inst_9629 = cljs.core.empty_QMARK_.call(null,inst_9603);
var inst_9630 = inst_9604.call(null,inst_9612);
var inst_9631 = cljs.core.not.call(null,inst_9630);
var inst_9632 = ((inst_9629) && (inst_9631));
var state_9652__$1 = state_9652;
var statearr_9702_9754 = state_9652__$1;
(statearr_9702_9754[(2)] = inst_9632);

(statearr_9702_9754[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (10))){
var inst_9554 = (state_9652[(8)]);
var inst_9575 = (state_9652[(2)]);
var inst_9576 = cljs.core.get.call(null,inst_9575,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_9577 = cljs.core.get.call(null,inst_9575,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_9578 = cljs.core.get.call(null,inst_9575,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_9579 = inst_9554;
var state_9652__$1 = (function (){var statearr_9703 = state_9652;
(statearr_9703[(16)] = inst_9577);

(statearr_9703[(17)] = inst_9578);

(statearr_9703[(7)] = inst_9579);

(statearr_9703[(18)] = inst_9576);

return statearr_9703;
})();
var statearr_9704_9755 = state_9652__$1;
(statearr_9704_9755[(2)] = null);

(statearr_9704_9755[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (18))){
var inst_9594 = (state_9652[(2)]);
var state_9652__$1 = state_9652;
var statearr_9705_9756 = state_9652__$1;
(statearr_9705_9756[(2)] = inst_9594);

(statearr_9705_9756[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (37))){
var state_9652__$1 = state_9652;
var statearr_9706_9757 = state_9652__$1;
(statearr_9706_9757[(2)] = null);

(statearr_9706_9757[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9653 === (8))){
var inst_9554 = (state_9652[(8)]);
var inst_9572 = cljs.core.apply.call(null,cljs.core.hash_map,inst_9554);
var state_9652__$1 = state_9652;
var statearr_9707_9758 = state_9652__$1;
(statearr_9707_9758[(2)] = inst_9572);

(statearr_9707_9758[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6791__auto___9712,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__6624__auto__,c__6791__auto___9712,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__6625__auto__ = null;
var cljs$core$async$mix_$_state_machine__6625__auto____0 = (function (){
var statearr_9708 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_9708[(0)] = cljs$core$async$mix_$_state_machine__6625__auto__);

(statearr_9708[(1)] = (1));

return statearr_9708;
});
var cljs$core$async$mix_$_state_machine__6625__auto____1 = (function (state_9652){
while(true){
var ret_value__6626__auto__ = (function (){try{while(true){
var result__6627__auto__ = switch__6624__auto__.call(null,state_9652);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6627__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6627__auto__;
}
break;
}
}catch (e9709){if((e9709 instanceof Object)){
var ex__6628__auto__ = e9709;
var statearr_9710_9759 = state_9652;
(statearr_9710_9759[(5)] = ex__6628__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9652);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9709;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6626__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9760 = state_9652;
state_9652 = G__9760;
continue;
} else {
return ret_value__6626__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__6625__auto__ = function(state_9652){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__6625__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__6625__auto____1.call(this,state_9652);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__6625__auto____0;
cljs$core$async$mix_$_state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__6625__auto____1;
return cljs$core$async$mix_$_state_machine__6625__auto__;
})()
;})(switch__6624__auto__,c__6791__auto___9712,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__6793__auto__ = (function (){var statearr_9711 = f__6792__auto__.call(null);
(statearr_9711[(6)] = c__6791__auto___9712);

return statearr_9711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6793__auto__);
});})(c__6791__auto___9712,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4431__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v,ch);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__9762 = arguments.length;
switch (G__9762) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__9766 = arguments.length;
switch (G__9766) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4131__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4131__auto__,mults){
return (function (p1__9764_SHARP_){
if(cljs.core.truth_(p1__9764_SHARP_.call(null,topic))){
return p1__9764_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__9764_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4131__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async9767 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async9767 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta9768){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta9768 = meta9768;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async9767.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_9769,meta9768__$1){
var self__ = this;
var _9769__$1 = this;
return (new cljs.core.async.t_cljs$core$async9767(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta9768__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async9767.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_9769){
var self__ = this;
var _9769__$1 = this;
return self__.meta9768;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async9767.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async9767.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async9767.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async9767.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async9767.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async9767.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async9767.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async9767.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta9768","meta9768",1054477207,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async9767.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async9767.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async9767";

cljs.core.async.t_cljs$core$async9767.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async9767");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async9767.
 */
cljs.core.async.__GT_t_cljs$core$async9767 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async9767(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta9768){
return (new cljs.core.async.t_cljs$core$async9767(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta9768));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async9767(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__6791__auto___9887 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6791__auto___9887,mults,ensure_mult,p){
return (function (){
var f__6792__auto__ = (function (){var switch__6624__auto__ = ((function (c__6791__auto___9887,mults,ensure_mult,p){
return (function (state_9841){
var state_val_9842 = (state_9841[(1)]);
if((state_val_9842 === (7))){
var inst_9837 = (state_9841[(2)]);
var state_9841__$1 = state_9841;
var statearr_9843_9888 = state_9841__$1;
(statearr_9843_9888[(2)] = inst_9837);

(statearr_9843_9888[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9842 === (20))){
var state_9841__$1 = state_9841;
var statearr_9844_9889 = state_9841__$1;
(statearr_9844_9889[(2)] = null);

(statearr_9844_9889[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9842 === (1))){
var state_9841__$1 = state_9841;
var statearr_9845_9890 = state_9841__$1;
(statearr_9845_9890[(2)] = null);

(statearr_9845_9890[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9842 === (24))){
var inst_9820 = (state_9841[(7)]);
var inst_9829 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_9820);
var state_9841__$1 = state_9841;
var statearr_9846_9891 = state_9841__$1;
(statearr_9846_9891[(2)] = inst_9829);

(statearr_9846_9891[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9842 === (4))){
var inst_9772 = (state_9841[(8)]);
var inst_9772__$1 = (state_9841[(2)]);
var inst_9773 = (inst_9772__$1 == null);
var state_9841__$1 = (function (){var statearr_9847 = state_9841;
(statearr_9847[(8)] = inst_9772__$1);

return statearr_9847;
})();
if(cljs.core.truth_(inst_9773)){
var statearr_9848_9892 = state_9841__$1;
(statearr_9848_9892[(1)] = (5));

} else {
var statearr_9849_9893 = state_9841__$1;
(statearr_9849_9893[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9842 === (15))){
var inst_9814 = (state_9841[(2)]);
var state_9841__$1 = state_9841;
var statearr_9850_9894 = state_9841__$1;
(statearr_9850_9894[(2)] = inst_9814);

(statearr_9850_9894[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9842 === (21))){
var inst_9834 = (state_9841[(2)]);
var state_9841__$1 = (function (){var statearr_9851 = state_9841;
(statearr_9851[(9)] = inst_9834);

return statearr_9851;
})();
var statearr_9852_9895 = state_9841__$1;
(statearr_9852_9895[(2)] = null);

(statearr_9852_9895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9842 === (13))){
var inst_9796 = (state_9841[(10)]);
var inst_9798 = cljs.core.chunked_seq_QMARK_.call(null,inst_9796);
var state_9841__$1 = state_9841;
if(inst_9798){
var statearr_9853_9896 = state_9841__$1;
(statearr_9853_9896[(1)] = (16));

} else {
var statearr_9854_9897 = state_9841__$1;
(statearr_9854_9897[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9842 === (22))){
var inst_9826 = (state_9841[(2)]);
var state_9841__$1 = state_9841;
if(cljs.core.truth_(inst_9826)){
var statearr_9855_9898 = state_9841__$1;
(statearr_9855_9898[(1)] = (23));

} else {
var statearr_9856_9899 = state_9841__$1;
(statearr_9856_9899[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9842 === (6))){
var inst_9820 = (state_9841[(7)]);
var inst_9822 = (state_9841[(11)]);
var inst_9772 = (state_9841[(8)]);
var inst_9820__$1 = topic_fn.call(null,inst_9772);
var inst_9821 = cljs.core.deref.call(null,mults);
var inst_9822__$1 = cljs.core.get.call(null,inst_9821,inst_9820__$1);
var state_9841__$1 = (function (){var statearr_9857 = state_9841;
(statearr_9857[(7)] = inst_9820__$1);

(statearr_9857[(11)] = inst_9822__$1);

return statearr_9857;
})();
if(cljs.core.truth_(inst_9822__$1)){
var statearr_9858_9900 = state_9841__$1;
(statearr_9858_9900[(1)] = (19));

} else {
var statearr_9859_9901 = state_9841__$1;
(statearr_9859_9901[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9842 === (25))){
var inst_9831 = (state_9841[(2)]);
var state_9841__$1 = state_9841;
var statearr_9860_9902 = state_9841__$1;
(statearr_9860_9902[(2)] = inst_9831);

(statearr_9860_9902[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9842 === (17))){
var inst_9796 = (state_9841[(10)]);
var inst_9805 = cljs.core.first.call(null,inst_9796);
var inst_9806 = cljs.core.async.muxch_STAR_.call(null,inst_9805);
var inst_9807 = cljs.core.async.close_BANG_.call(null,inst_9806);
var inst_9808 = cljs.core.next.call(null,inst_9796);
var inst_9782 = inst_9808;
var inst_9783 = null;
var inst_9784 = (0);
var inst_9785 = (0);
var state_9841__$1 = (function (){var statearr_9861 = state_9841;
(statearr_9861[(12)] = inst_9783);

(statearr_9861[(13)] = inst_9807);

(statearr_9861[(14)] = inst_9784);

(statearr_9861[(15)] = inst_9782);

(statearr_9861[(16)] = inst_9785);

return statearr_9861;
})();
var statearr_9862_9903 = state_9841__$1;
(statearr_9862_9903[(2)] = null);

(statearr_9862_9903[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9842 === (3))){
var inst_9839 = (state_9841[(2)]);
var state_9841__$1 = state_9841;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9841__$1,inst_9839);
} else {
if((state_val_9842 === (12))){
var inst_9816 = (state_9841[(2)]);
var state_9841__$1 = state_9841;
var statearr_9863_9904 = state_9841__$1;
(statearr_9863_9904[(2)] = inst_9816);

(statearr_9863_9904[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9842 === (2))){
var state_9841__$1 = state_9841;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9841__$1,(4),ch);
} else {
if((state_val_9842 === (23))){
var state_9841__$1 = state_9841;
var statearr_9864_9905 = state_9841__$1;
(statearr_9864_9905[(2)] = null);

(statearr_9864_9905[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9842 === (19))){
var inst_9822 = (state_9841[(11)]);
var inst_9772 = (state_9841[(8)]);
var inst_9824 = cljs.core.async.muxch_STAR_.call(null,inst_9822);
var state_9841__$1 = state_9841;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9841__$1,(22),inst_9824,inst_9772);
} else {
if((state_val_9842 === (11))){
var inst_9796 = (state_9841[(10)]);
var inst_9782 = (state_9841[(15)]);
var inst_9796__$1 = cljs.core.seq.call(null,inst_9782);
var state_9841__$1 = (function (){var statearr_9865 = state_9841;
(statearr_9865[(10)] = inst_9796__$1);

return statearr_9865;
})();
if(inst_9796__$1){
var statearr_9866_9906 = state_9841__$1;
(statearr_9866_9906[(1)] = (13));

} else {
var statearr_9867_9907 = state_9841__$1;
(statearr_9867_9907[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9842 === (9))){
var inst_9818 = (state_9841[(2)]);
var state_9841__$1 = state_9841;
var statearr_9868_9908 = state_9841__$1;
(statearr_9868_9908[(2)] = inst_9818);

(statearr_9868_9908[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9842 === (5))){
var inst_9779 = cljs.core.deref.call(null,mults);
var inst_9780 = cljs.core.vals.call(null,inst_9779);
var inst_9781 = cljs.core.seq.call(null,inst_9780);
var inst_9782 = inst_9781;
var inst_9783 = null;
var inst_9784 = (0);
var inst_9785 = (0);
var state_9841__$1 = (function (){var statearr_9869 = state_9841;
(statearr_9869[(12)] = inst_9783);

(statearr_9869[(14)] = inst_9784);

(statearr_9869[(15)] = inst_9782);

(statearr_9869[(16)] = inst_9785);

return statearr_9869;
})();
var statearr_9870_9909 = state_9841__$1;
(statearr_9870_9909[(2)] = null);

(statearr_9870_9909[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9842 === (14))){
var state_9841__$1 = state_9841;
var statearr_9874_9910 = state_9841__$1;
(statearr_9874_9910[(2)] = null);

(statearr_9874_9910[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9842 === (16))){
var inst_9796 = (state_9841[(10)]);
var inst_9800 = cljs.core.chunk_first.call(null,inst_9796);
var inst_9801 = cljs.core.chunk_rest.call(null,inst_9796);
var inst_9802 = cljs.core.count.call(null,inst_9800);
var inst_9782 = inst_9801;
var inst_9783 = inst_9800;
var inst_9784 = inst_9802;
var inst_9785 = (0);
var state_9841__$1 = (function (){var statearr_9875 = state_9841;
(statearr_9875[(12)] = inst_9783);

(statearr_9875[(14)] = inst_9784);

(statearr_9875[(15)] = inst_9782);

(statearr_9875[(16)] = inst_9785);

return statearr_9875;
})();
var statearr_9876_9911 = state_9841__$1;
(statearr_9876_9911[(2)] = null);

(statearr_9876_9911[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9842 === (10))){
var inst_9783 = (state_9841[(12)]);
var inst_9784 = (state_9841[(14)]);
var inst_9782 = (state_9841[(15)]);
var inst_9785 = (state_9841[(16)]);
var inst_9790 = cljs.core._nth.call(null,inst_9783,inst_9785);
var inst_9791 = cljs.core.async.muxch_STAR_.call(null,inst_9790);
var inst_9792 = cljs.core.async.close_BANG_.call(null,inst_9791);
var inst_9793 = (inst_9785 + (1));
var tmp9871 = inst_9783;
var tmp9872 = inst_9784;
var tmp9873 = inst_9782;
var inst_9782__$1 = tmp9873;
var inst_9783__$1 = tmp9871;
var inst_9784__$1 = tmp9872;
var inst_9785__$1 = inst_9793;
var state_9841__$1 = (function (){var statearr_9877 = state_9841;
(statearr_9877[(12)] = inst_9783__$1);

(statearr_9877[(14)] = inst_9784__$1);

(statearr_9877[(17)] = inst_9792);

(statearr_9877[(15)] = inst_9782__$1);

(statearr_9877[(16)] = inst_9785__$1);

return statearr_9877;
})();
var statearr_9878_9912 = state_9841__$1;
(statearr_9878_9912[(2)] = null);

(statearr_9878_9912[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9842 === (18))){
var inst_9811 = (state_9841[(2)]);
var state_9841__$1 = state_9841;
var statearr_9879_9913 = state_9841__$1;
(statearr_9879_9913[(2)] = inst_9811);

(statearr_9879_9913[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9842 === (8))){
var inst_9784 = (state_9841[(14)]);
var inst_9785 = (state_9841[(16)]);
var inst_9787 = (inst_9785 < inst_9784);
var inst_9788 = inst_9787;
var state_9841__$1 = state_9841;
if(cljs.core.truth_(inst_9788)){
var statearr_9880_9914 = state_9841__$1;
(statearr_9880_9914[(1)] = (10));

} else {
var statearr_9881_9915 = state_9841__$1;
(statearr_9881_9915[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6791__auto___9887,mults,ensure_mult,p))
;
return ((function (switch__6624__auto__,c__6791__auto___9887,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__6625__auto__ = null;
var cljs$core$async$state_machine__6625__auto____0 = (function (){
var statearr_9882 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_9882[(0)] = cljs$core$async$state_machine__6625__auto__);

(statearr_9882[(1)] = (1));

return statearr_9882;
});
var cljs$core$async$state_machine__6625__auto____1 = (function (state_9841){
while(true){
var ret_value__6626__auto__ = (function (){try{while(true){
var result__6627__auto__ = switch__6624__auto__.call(null,state_9841);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6627__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6627__auto__;
}
break;
}
}catch (e9883){if((e9883 instanceof Object)){
var ex__6628__auto__ = e9883;
var statearr_9884_9916 = state_9841;
(statearr_9884_9916[(5)] = ex__6628__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9841);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9883;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6626__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9917 = state_9841;
state_9841 = G__9917;
continue;
} else {
return ret_value__6626__auto__;
}
break;
}
});
cljs$core$async$state_machine__6625__auto__ = function(state_9841){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6625__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6625__auto____1.call(this,state_9841);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6625__auto____0;
cljs$core$async$state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6625__auto____1;
return cljs$core$async$state_machine__6625__auto__;
})()
;})(switch__6624__auto__,c__6791__auto___9887,mults,ensure_mult,p))
})();
var state__6793__auto__ = (function (){var statearr_9885 = f__6792__auto__.call(null);
(statearr_9885[(6)] = c__6791__auto___9887);

return statearr_9885;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6793__auto__);
});})(c__6791__auto___9887,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__9919 = arguments.length;
switch (G__9919) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__9922 = arguments.length;
switch (G__9922) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__9925 = arguments.length;
switch (G__9925) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__6791__auto___9992 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6791__auto___9992,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__6792__auto__ = (function (){var switch__6624__auto__ = ((function (c__6791__auto___9992,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_9964){
var state_val_9965 = (state_9964[(1)]);
if((state_val_9965 === (7))){
var state_9964__$1 = state_9964;
var statearr_9966_9993 = state_9964__$1;
(statearr_9966_9993[(2)] = null);

(statearr_9966_9993[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9965 === (1))){
var state_9964__$1 = state_9964;
var statearr_9967_9994 = state_9964__$1;
(statearr_9967_9994[(2)] = null);

(statearr_9967_9994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9965 === (4))){
var inst_9928 = (state_9964[(7)]);
var inst_9930 = (inst_9928 < cnt);
var state_9964__$1 = state_9964;
if(cljs.core.truth_(inst_9930)){
var statearr_9968_9995 = state_9964__$1;
(statearr_9968_9995[(1)] = (6));

} else {
var statearr_9969_9996 = state_9964__$1;
(statearr_9969_9996[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9965 === (15))){
var inst_9960 = (state_9964[(2)]);
var state_9964__$1 = state_9964;
var statearr_9970_9997 = state_9964__$1;
(statearr_9970_9997[(2)] = inst_9960);

(statearr_9970_9997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9965 === (13))){
var inst_9953 = cljs.core.async.close_BANG_.call(null,out);
var state_9964__$1 = state_9964;
var statearr_9971_9998 = state_9964__$1;
(statearr_9971_9998[(2)] = inst_9953);

(statearr_9971_9998[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9965 === (6))){
var state_9964__$1 = state_9964;
var statearr_9972_9999 = state_9964__$1;
(statearr_9972_9999[(2)] = null);

(statearr_9972_9999[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9965 === (3))){
var inst_9962 = (state_9964[(2)]);
var state_9964__$1 = state_9964;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9964__$1,inst_9962);
} else {
if((state_val_9965 === (12))){
var inst_9950 = (state_9964[(8)]);
var inst_9950__$1 = (state_9964[(2)]);
var inst_9951 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_9950__$1);
var state_9964__$1 = (function (){var statearr_9973 = state_9964;
(statearr_9973[(8)] = inst_9950__$1);

return statearr_9973;
})();
if(cljs.core.truth_(inst_9951)){
var statearr_9974_10000 = state_9964__$1;
(statearr_9974_10000[(1)] = (13));

} else {
var statearr_9975_10001 = state_9964__$1;
(statearr_9975_10001[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9965 === (2))){
var inst_9927 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_9928 = (0);
var state_9964__$1 = (function (){var statearr_9976 = state_9964;
(statearr_9976[(7)] = inst_9928);

(statearr_9976[(9)] = inst_9927);

return statearr_9976;
})();
var statearr_9977_10002 = state_9964__$1;
(statearr_9977_10002[(2)] = null);

(statearr_9977_10002[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9965 === (11))){
var inst_9928 = (state_9964[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_9964,(10),Object,null,(9));
var inst_9937 = chs__$1.call(null,inst_9928);
var inst_9938 = done.call(null,inst_9928);
var inst_9939 = cljs.core.async.take_BANG_.call(null,inst_9937,inst_9938);
var state_9964__$1 = state_9964;
var statearr_9978_10003 = state_9964__$1;
(statearr_9978_10003[(2)] = inst_9939);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9964__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9965 === (9))){
var inst_9928 = (state_9964[(7)]);
var inst_9941 = (state_9964[(2)]);
var inst_9942 = (inst_9928 + (1));
var inst_9928__$1 = inst_9942;
var state_9964__$1 = (function (){var statearr_9979 = state_9964;
(statearr_9979[(7)] = inst_9928__$1);

(statearr_9979[(10)] = inst_9941);

return statearr_9979;
})();
var statearr_9980_10004 = state_9964__$1;
(statearr_9980_10004[(2)] = null);

(statearr_9980_10004[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9965 === (5))){
var inst_9948 = (state_9964[(2)]);
var state_9964__$1 = (function (){var statearr_9981 = state_9964;
(statearr_9981[(11)] = inst_9948);

return statearr_9981;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9964__$1,(12),dchan);
} else {
if((state_val_9965 === (14))){
var inst_9950 = (state_9964[(8)]);
var inst_9955 = cljs.core.apply.call(null,f,inst_9950);
var state_9964__$1 = state_9964;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9964__$1,(16),out,inst_9955);
} else {
if((state_val_9965 === (16))){
var inst_9957 = (state_9964[(2)]);
var state_9964__$1 = (function (){var statearr_9982 = state_9964;
(statearr_9982[(12)] = inst_9957);

return statearr_9982;
})();
var statearr_9983_10005 = state_9964__$1;
(statearr_9983_10005[(2)] = null);

(statearr_9983_10005[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9965 === (10))){
var inst_9932 = (state_9964[(2)]);
var inst_9933 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_9964__$1 = (function (){var statearr_9984 = state_9964;
(statearr_9984[(13)] = inst_9932);

return statearr_9984;
})();
var statearr_9985_10006 = state_9964__$1;
(statearr_9985_10006[(2)] = inst_9933);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9964__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9965 === (8))){
var inst_9946 = (state_9964[(2)]);
var state_9964__$1 = state_9964;
var statearr_9986_10007 = state_9964__$1;
(statearr_9986_10007[(2)] = inst_9946);

(statearr_9986_10007[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6791__auto___9992,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__6624__auto__,c__6791__auto___9992,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__6625__auto__ = null;
var cljs$core$async$state_machine__6625__auto____0 = (function (){
var statearr_9987 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_9987[(0)] = cljs$core$async$state_machine__6625__auto__);

(statearr_9987[(1)] = (1));

return statearr_9987;
});
var cljs$core$async$state_machine__6625__auto____1 = (function (state_9964){
while(true){
var ret_value__6626__auto__ = (function (){try{while(true){
var result__6627__auto__ = switch__6624__auto__.call(null,state_9964);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6627__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6627__auto__;
}
break;
}
}catch (e9988){if((e9988 instanceof Object)){
var ex__6628__auto__ = e9988;
var statearr_9989_10008 = state_9964;
(statearr_9989_10008[(5)] = ex__6628__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9964);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9988;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6626__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10009 = state_9964;
state_9964 = G__10009;
continue;
} else {
return ret_value__6626__auto__;
}
break;
}
});
cljs$core$async$state_machine__6625__auto__ = function(state_9964){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6625__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6625__auto____1.call(this,state_9964);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6625__auto____0;
cljs$core$async$state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6625__auto____1;
return cljs$core$async$state_machine__6625__auto__;
})()
;})(switch__6624__auto__,c__6791__auto___9992,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__6793__auto__ = (function (){var statearr_9990 = f__6792__auto__.call(null);
(statearr_9990[(6)] = c__6791__auto___9992);

return statearr_9990;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6793__auto__);
});})(c__6791__auto___9992,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__10012 = arguments.length;
switch (G__10012) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__6791__auto___10066 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6791__auto___10066,out){
return (function (){
var f__6792__auto__ = (function (){var switch__6624__auto__ = ((function (c__6791__auto___10066,out){
return (function (state_10044){
var state_val_10045 = (state_10044[(1)]);
if((state_val_10045 === (7))){
var inst_10024 = (state_10044[(7)]);
var inst_10023 = (state_10044[(8)]);
var inst_10023__$1 = (state_10044[(2)]);
var inst_10024__$1 = cljs.core.nth.call(null,inst_10023__$1,(0),null);
var inst_10025 = cljs.core.nth.call(null,inst_10023__$1,(1),null);
var inst_10026 = (inst_10024__$1 == null);
var state_10044__$1 = (function (){var statearr_10046 = state_10044;
(statearr_10046[(7)] = inst_10024__$1);

(statearr_10046[(8)] = inst_10023__$1);

(statearr_10046[(9)] = inst_10025);

return statearr_10046;
})();
if(cljs.core.truth_(inst_10026)){
var statearr_10047_10067 = state_10044__$1;
(statearr_10047_10067[(1)] = (8));

} else {
var statearr_10048_10068 = state_10044__$1;
(statearr_10048_10068[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10045 === (1))){
var inst_10013 = cljs.core.vec.call(null,chs);
var inst_10014 = inst_10013;
var state_10044__$1 = (function (){var statearr_10049 = state_10044;
(statearr_10049[(10)] = inst_10014);

return statearr_10049;
})();
var statearr_10050_10069 = state_10044__$1;
(statearr_10050_10069[(2)] = null);

(statearr_10050_10069[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10045 === (4))){
var inst_10014 = (state_10044[(10)]);
var state_10044__$1 = state_10044;
return cljs.core.async.ioc_alts_BANG_.call(null,state_10044__$1,(7),inst_10014);
} else {
if((state_val_10045 === (6))){
var inst_10040 = (state_10044[(2)]);
var state_10044__$1 = state_10044;
var statearr_10051_10070 = state_10044__$1;
(statearr_10051_10070[(2)] = inst_10040);

(statearr_10051_10070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10045 === (3))){
var inst_10042 = (state_10044[(2)]);
var state_10044__$1 = state_10044;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10044__$1,inst_10042);
} else {
if((state_val_10045 === (2))){
var inst_10014 = (state_10044[(10)]);
var inst_10016 = cljs.core.count.call(null,inst_10014);
var inst_10017 = (inst_10016 > (0));
var state_10044__$1 = state_10044;
if(cljs.core.truth_(inst_10017)){
var statearr_10053_10071 = state_10044__$1;
(statearr_10053_10071[(1)] = (4));

} else {
var statearr_10054_10072 = state_10044__$1;
(statearr_10054_10072[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10045 === (11))){
var inst_10014 = (state_10044[(10)]);
var inst_10033 = (state_10044[(2)]);
var tmp10052 = inst_10014;
var inst_10014__$1 = tmp10052;
var state_10044__$1 = (function (){var statearr_10055 = state_10044;
(statearr_10055[(11)] = inst_10033);

(statearr_10055[(10)] = inst_10014__$1);

return statearr_10055;
})();
var statearr_10056_10073 = state_10044__$1;
(statearr_10056_10073[(2)] = null);

(statearr_10056_10073[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10045 === (9))){
var inst_10024 = (state_10044[(7)]);
var state_10044__$1 = state_10044;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10044__$1,(11),out,inst_10024);
} else {
if((state_val_10045 === (5))){
var inst_10038 = cljs.core.async.close_BANG_.call(null,out);
var state_10044__$1 = state_10044;
var statearr_10057_10074 = state_10044__$1;
(statearr_10057_10074[(2)] = inst_10038);

(statearr_10057_10074[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10045 === (10))){
var inst_10036 = (state_10044[(2)]);
var state_10044__$1 = state_10044;
var statearr_10058_10075 = state_10044__$1;
(statearr_10058_10075[(2)] = inst_10036);

(statearr_10058_10075[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10045 === (8))){
var inst_10024 = (state_10044[(7)]);
var inst_10014 = (state_10044[(10)]);
var inst_10023 = (state_10044[(8)]);
var inst_10025 = (state_10044[(9)]);
var inst_10028 = (function (){var cs = inst_10014;
var vec__10019 = inst_10023;
var v = inst_10024;
var c = inst_10025;
return ((function (cs,vec__10019,v,c,inst_10024,inst_10014,inst_10023,inst_10025,state_val_10045,c__6791__auto___10066,out){
return (function (p1__10010_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__10010_SHARP_);
});
;})(cs,vec__10019,v,c,inst_10024,inst_10014,inst_10023,inst_10025,state_val_10045,c__6791__auto___10066,out))
})();
var inst_10029 = cljs.core.filterv.call(null,inst_10028,inst_10014);
var inst_10014__$1 = inst_10029;
var state_10044__$1 = (function (){var statearr_10059 = state_10044;
(statearr_10059[(10)] = inst_10014__$1);

return statearr_10059;
})();
var statearr_10060_10076 = state_10044__$1;
(statearr_10060_10076[(2)] = null);

(statearr_10060_10076[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__6791__auto___10066,out))
;
return ((function (switch__6624__auto__,c__6791__auto___10066,out){
return (function() {
var cljs$core$async$state_machine__6625__auto__ = null;
var cljs$core$async$state_machine__6625__auto____0 = (function (){
var statearr_10061 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_10061[(0)] = cljs$core$async$state_machine__6625__auto__);

(statearr_10061[(1)] = (1));

return statearr_10061;
});
var cljs$core$async$state_machine__6625__auto____1 = (function (state_10044){
while(true){
var ret_value__6626__auto__ = (function (){try{while(true){
var result__6627__auto__ = switch__6624__auto__.call(null,state_10044);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6627__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6627__auto__;
}
break;
}
}catch (e10062){if((e10062 instanceof Object)){
var ex__6628__auto__ = e10062;
var statearr_10063_10077 = state_10044;
(statearr_10063_10077[(5)] = ex__6628__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10044);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10062;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6626__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10078 = state_10044;
state_10044 = G__10078;
continue;
} else {
return ret_value__6626__auto__;
}
break;
}
});
cljs$core$async$state_machine__6625__auto__ = function(state_10044){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6625__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6625__auto____1.call(this,state_10044);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6625__auto____0;
cljs$core$async$state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6625__auto____1;
return cljs$core$async$state_machine__6625__auto__;
})()
;})(switch__6624__auto__,c__6791__auto___10066,out))
})();
var state__6793__auto__ = (function (){var statearr_10064 = f__6792__auto__.call(null);
(statearr_10064[(6)] = c__6791__auto___10066);

return statearr_10064;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6793__auto__);
});})(c__6791__auto___10066,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__10080 = arguments.length;
switch (G__10080) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__6791__auto___10125 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6791__auto___10125,out){
return (function (){
var f__6792__auto__ = (function (){var switch__6624__auto__ = ((function (c__6791__auto___10125,out){
return (function (state_10104){
var state_val_10105 = (state_10104[(1)]);
if((state_val_10105 === (7))){
var inst_10086 = (state_10104[(7)]);
var inst_10086__$1 = (state_10104[(2)]);
var inst_10087 = (inst_10086__$1 == null);
var inst_10088 = cljs.core.not.call(null,inst_10087);
var state_10104__$1 = (function (){var statearr_10106 = state_10104;
(statearr_10106[(7)] = inst_10086__$1);

return statearr_10106;
})();
if(inst_10088){
var statearr_10107_10126 = state_10104__$1;
(statearr_10107_10126[(1)] = (8));

} else {
var statearr_10108_10127 = state_10104__$1;
(statearr_10108_10127[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10105 === (1))){
var inst_10081 = (0);
var state_10104__$1 = (function (){var statearr_10109 = state_10104;
(statearr_10109[(8)] = inst_10081);

return statearr_10109;
})();
var statearr_10110_10128 = state_10104__$1;
(statearr_10110_10128[(2)] = null);

(statearr_10110_10128[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10105 === (4))){
var state_10104__$1 = state_10104;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10104__$1,(7),ch);
} else {
if((state_val_10105 === (6))){
var inst_10099 = (state_10104[(2)]);
var state_10104__$1 = state_10104;
var statearr_10111_10129 = state_10104__$1;
(statearr_10111_10129[(2)] = inst_10099);

(statearr_10111_10129[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10105 === (3))){
var inst_10101 = (state_10104[(2)]);
var inst_10102 = cljs.core.async.close_BANG_.call(null,out);
var state_10104__$1 = (function (){var statearr_10112 = state_10104;
(statearr_10112[(9)] = inst_10101);

return statearr_10112;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10104__$1,inst_10102);
} else {
if((state_val_10105 === (2))){
var inst_10081 = (state_10104[(8)]);
var inst_10083 = (inst_10081 < n);
var state_10104__$1 = state_10104;
if(cljs.core.truth_(inst_10083)){
var statearr_10113_10130 = state_10104__$1;
(statearr_10113_10130[(1)] = (4));

} else {
var statearr_10114_10131 = state_10104__$1;
(statearr_10114_10131[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10105 === (11))){
var inst_10081 = (state_10104[(8)]);
var inst_10091 = (state_10104[(2)]);
var inst_10092 = (inst_10081 + (1));
var inst_10081__$1 = inst_10092;
var state_10104__$1 = (function (){var statearr_10115 = state_10104;
(statearr_10115[(10)] = inst_10091);

(statearr_10115[(8)] = inst_10081__$1);

return statearr_10115;
})();
var statearr_10116_10132 = state_10104__$1;
(statearr_10116_10132[(2)] = null);

(statearr_10116_10132[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10105 === (9))){
var state_10104__$1 = state_10104;
var statearr_10117_10133 = state_10104__$1;
(statearr_10117_10133[(2)] = null);

(statearr_10117_10133[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10105 === (5))){
var state_10104__$1 = state_10104;
var statearr_10118_10134 = state_10104__$1;
(statearr_10118_10134[(2)] = null);

(statearr_10118_10134[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10105 === (10))){
var inst_10096 = (state_10104[(2)]);
var state_10104__$1 = state_10104;
var statearr_10119_10135 = state_10104__$1;
(statearr_10119_10135[(2)] = inst_10096);

(statearr_10119_10135[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10105 === (8))){
var inst_10086 = (state_10104[(7)]);
var state_10104__$1 = state_10104;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10104__$1,(11),out,inst_10086);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__6791__auto___10125,out))
;
return ((function (switch__6624__auto__,c__6791__auto___10125,out){
return (function() {
var cljs$core$async$state_machine__6625__auto__ = null;
var cljs$core$async$state_machine__6625__auto____0 = (function (){
var statearr_10120 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_10120[(0)] = cljs$core$async$state_machine__6625__auto__);

(statearr_10120[(1)] = (1));

return statearr_10120;
});
var cljs$core$async$state_machine__6625__auto____1 = (function (state_10104){
while(true){
var ret_value__6626__auto__ = (function (){try{while(true){
var result__6627__auto__ = switch__6624__auto__.call(null,state_10104);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6627__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6627__auto__;
}
break;
}
}catch (e10121){if((e10121 instanceof Object)){
var ex__6628__auto__ = e10121;
var statearr_10122_10136 = state_10104;
(statearr_10122_10136[(5)] = ex__6628__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10104);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10121;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6626__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10137 = state_10104;
state_10104 = G__10137;
continue;
} else {
return ret_value__6626__auto__;
}
break;
}
});
cljs$core$async$state_machine__6625__auto__ = function(state_10104){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6625__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6625__auto____1.call(this,state_10104);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6625__auto____0;
cljs$core$async$state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6625__auto____1;
return cljs$core$async$state_machine__6625__auto__;
})()
;})(switch__6624__auto__,c__6791__auto___10125,out))
})();
var state__6793__auto__ = (function (){var statearr_10123 = f__6792__auto__.call(null);
(statearr_10123[(6)] = c__6791__auto___10125);

return statearr_10123;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6793__auto__);
});})(c__6791__auto___10125,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async10139 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10139 = (function (f,ch,meta10140){
this.f = f;
this.ch = ch;
this.meta10140 = meta10140;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async10139.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10141,meta10140__$1){
var self__ = this;
var _10141__$1 = this;
return (new cljs.core.async.t_cljs$core$async10139(self__.f,self__.ch,meta10140__$1));
});

cljs.core.async.t_cljs$core$async10139.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10141){
var self__ = this;
var _10141__$1 = this;
return self__.meta10140;
});

cljs.core.async.t_cljs$core$async10139.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async10139.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async10139.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async10139.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async10139.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async10142 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10142 = (function (f,ch,meta10140,_,fn1,meta10143){
this.f = f;
this.ch = ch;
this.meta10140 = meta10140;
this._ = _;
this.fn1 = fn1;
this.meta10143 = meta10143;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async10142.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_10144,meta10143__$1){
var self__ = this;
var _10144__$1 = this;
return (new cljs.core.async.t_cljs$core$async10142(self__.f,self__.ch,self__.meta10140,self__._,self__.fn1,meta10143__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async10142.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_10144){
var self__ = this;
var _10144__$1 = this;
return self__.meta10143;
});})(___$1))
;

cljs.core.async.t_cljs$core$async10142.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async10142.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async10142.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async10142.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__10138_SHARP_){
return f1.call(null,(((p1__10138_SHARP_ == null))?null:self__.f.call(null,p1__10138_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async10142.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta10140","meta10140",737049540,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async10139","cljs.core.async/t_cljs$core$async10139",-251316203,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta10143","meta10143",535712283,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async10142.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async10142.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10142";

cljs.core.async.t_cljs$core$async10142.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async10142");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async10142.
 */
cljs.core.async.__GT_t_cljs$core$async10142 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async10142(f__$1,ch__$1,meta10140__$1,___$2,fn1__$1,meta10143){
return (new cljs.core.async.t_cljs$core$async10142(f__$1,ch__$1,meta10140__$1,___$2,fn1__$1,meta10143));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async10142(self__.f,self__.ch,self__.meta10140,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4120__auto__ = ret;
if(cljs.core.truth_(and__4120__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4120__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async10139.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async10139.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async10139.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta10140","meta10140",737049540,null)], null);
});

cljs.core.async.t_cljs$core$async10139.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async10139.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10139";

cljs.core.async.t_cljs$core$async10139.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async10139");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async10139.
 */
cljs.core.async.__GT_t_cljs$core$async10139 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async10139(f__$1,ch__$1,meta10140){
return (new cljs.core.async.t_cljs$core$async10139(f__$1,ch__$1,meta10140));
});

}

return (new cljs.core.async.t_cljs$core$async10139(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async10145 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10145 = (function (f,ch,meta10146){
this.f = f;
this.ch = ch;
this.meta10146 = meta10146;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async10145.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10147,meta10146__$1){
var self__ = this;
var _10147__$1 = this;
return (new cljs.core.async.t_cljs$core$async10145(self__.f,self__.ch,meta10146__$1));
});

cljs.core.async.t_cljs$core$async10145.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10147){
var self__ = this;
var _10147__$1 = this;
return self__.meta10146;
});

cljs.core.async.t_cljs$core$async10145.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async10145.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async10145.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async10145.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async10145.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async10145.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async10145.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta10146","meta10146",-1793661640,null)], null);
});

cljs.core.async.t_cljs$core$async10145.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async10145.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10145";

cljs.core.async.t_cljs$core$async10145.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async10145");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async10145.
 */
cljs.core.async.__GT_t_cljs$core$async10145 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async10145(f__$1,ch__$1,meta10146){
return (new cljs.core.async.t_cljs$core$async10145(f__$1,ch__$1,meta10146));
});

}

return (new cljs.core.async.t_cljs$core$async10145(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async10148 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10148 = (function (p,ch,meta10149){
this.p = p;
this.ch = ch;
this.meta10149 = meta10149;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async10148.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10150,meta10149__$1){
var self__ = this;
var _10150__$1 = this;
return (new cljs.core.async.t_cljs$core$async10148(self__.p,self__.ch,meta10149__$1));
});

cljs.core.async.t_cljs$core$async10148.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10150){
var self__ = this;
var _10150__$1 = this;
return self__.meta10149;
});

cljs.core.async.t_cljs$core$async10148.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async10148.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async10148.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async10148.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async10148.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async10148.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async10148.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async10148.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta10149","meta10149",-855804941,null)], null);
});

cljs.core.async.t_cljs$core$async10148.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async10148.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10148";

cljs.core.async.t_cljs$core$async10148.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async10148");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async10148.
 */
cljs.core.async.__GT_t_cljs$core$async10148 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async10148(p__$1,ch__$1,meta10149){
return (new cljs.core.async.t_cljs$core$async10148(p__$1,ch__$1,meta10149));
});

}

return (new cljs.core.async.t_cljs$core$async10148(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__10152 = arguments.length;
switch (G__10152) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__6791__auto___10192 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6791__auto___10192,out){
return (function (){
var f__6792__auto__ = (function (){var switch__6624__auto__ = ((function (c__6791__auto___10192,out){
return (function (state_10173){
var state_val_10174 = (state_10173[(1)]);
if((state_val_10174 === (7))){
var inst_10169 = (state_10173[(2)]);
var state_10173__$1 = state_10173;
var statearr_10175_10193 = state_10173__$1;
(statearr_10175_10193[(2)] = inst_10169);

(statearr_10175_10193[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10174 === (1))){
var state_10173__$1 = state_10173;
var statearr_10176_10194 = state_10173__$1;
(statearr_10176_10194[(2)] = null);

(statearr_10176_10194[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10174 === (4))){
var inst_10155 = (state_10173[(7)]);
var inst_10155__$1 = (state_10173[(2)]);
var inst_10156 = (inst_10155__$1 == null);
var state_10173__$1 = (function (){var statearr_10177 = state_10173;
(statearr_10177[(7)] = inst_10155__$1);

return statearr_10177;
})();
if(cljs.core.truth_(inst_10156)){
var statearr_10178_10195 = state_10173__$1;
(statearr_10178_10195[(1)] = (5));

} else {
var statearr_10179_10196 = state_10173__$1;
(statearr_10179_10196[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10174 === (6))){
var inst_10155 = (state_10173[(7)]);
var inst_10160 = p.call(null,inst_10155);
var state_10173__$1 = state_10173;
if(cljs.core.truth_(inst_10160)){
var statearr_10180_10197 = state_10173__$1;
(statearr_10180_10197[(1)] = (8));

} else {
var statearr_10181_10198 = state_10173__$1;
(statearr_10181_10198[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10174 === (3))){
var inst_10171 = (state_10173[(2)]);
var state_10173__$1 = state_10173;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10173__$1,inst_10171);
} else {
if((state_val_10174 === (2))){
var state_10173__$1 = state_10173;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10173__$1,(4),ch);
} else {
if((state_val_10174 === (11))){
var inst_10163 = (state_10173[(2)]);
var state_10173__$1 = state_10173;
var statearr_10182_10199 = state_10173__$1;
(statearr_10182_10199[(2)] = inst_10163);

(statearr_10182_10199[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10174 === (9))){
var state_10173__$1 = state_10173;
var statearr_10183_10200 = state_10173__$1;
(statearr_10183_10200[(2)] = null);

(statearr_10183_10200[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10174 === (5))){
var inst_10158 = cljs.core.async.close_BANG_.call(null,out);
var state_10173__$1 = state_10173;
var statearr_10184_10201 = state_10173__$1;
(statearr_10184_10201[(2)] = inst_10158);

(statearr_10184_10201[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10174 === (10))){
var inst_10166 = (state_10173[(2)]);
var state_10173__$1 = (function (){var statearr_10185 = state_10173;
(statearr_10185[(8)] = inst_10166);

return statearr_10185;
})();
var statearr_10186_10202 = state_10173__$1;
(statearr_10186_10202[(2)] = null);

(statearr_10186_10202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10174 === (8))){
var inst_10155 = (state_10173[(7)]);
var state_10173__$1 = state_10173;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10173__$1,(11),out,inst_10155);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__6791__auto___10192,out))
;
return ((function (switch__6624__auto__,c__6791__auto___10192,out){
return (function() {
var cljs$core$async$state_machine__6625__auto__ = null;
var cljs$core$async$state_machine__6625__auto____0 = (function (){
var statearr_10187 = [null,null,null,null,null,null,null,null,null];
(statearr_10187[(0)] = cljs$core$async$state_machine__6625__auto__);

(statearr_10187[(1)] = (1));

return statearr_10187;
});
var cljs$core$async$state_machine__6625__auto____1 = (function (state_10173){
while(true){
var ret_value__6626__auto__ = (function (){try{while(true){
var result__6627__auto__ = switch__6624__auto__.call(null,state_10173);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6627__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6627__auto__;
}
break;
}
}catch (e10188){if((e10188 instanceof Object)){
var ex__6628__auto__ = e10188;
var statearr_10189_10203 = state_10173;
(statearr_10189_10203[(5)] = ex__6628__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10173);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10188;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6626__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10204 = state_10173;
state_10173 = G__10204;
continue;
} else {
return ret_value__6626__auto__;
}
break;
}
});
cljs$core$async$state_machine__6625__auto__ = function(state_10173){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6625__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6625__auto____1.call(this,state_10173);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6625__auto____0;
cljs$core$async$state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6625__auto____1;
return cljs$core$async$state_machine__6625__auto__;
})()
;})(switch__6624__auto__,c__6791__auto___10192,out))
})();
var state__6793__auto__ = (function (){var statearr_10190 = f__6792__auto__.call(null);
(statearr_10190[(6)] = c__6791__auto___10192);

return statearr_10190;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6793__auto__);
});})(c__6791__auto___10192,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__10206 = arguments.length;
switch (G__10206) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__6791__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6791__auto__){
return (function (){
var f__6792__auto__ = (function (){var switch__6624__auto__ = ((function (c__6791__auto__){
return (function (state_10269){
var state_val_10270 = (state_10269[(1)]);
if((state_val_10270 === (7))){
var inst_10265 = (state_10269[(2)]);
var state_10269__$1 = state_10269;
var statearr_10271_10309 = state_10269__$1;
(statearr_10271_10309[(2)] = inst_10265);

(statearr_10271_10309[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10270 === (20))){
var inst_10235 = (state_10269[(7)]);
var inst_10246 = (state_10269[(2)]);
var inst_10247 = cljs.core.next.call(null,inst_10235);
var inst_10221 = inst_10247;
var inst_10222 = null;
var inst_10223 = (0);
var inst_10224 = (0);
var state_10269__$1 = (function (){var statearr_10272 = state_10269;
(statearr_10272[(8)] = inst_10221);

(statearr_10272[(9)] = inst_10222);

(statearr_10272[(10)] = inst_10246);

(statearr_10272[(11)] = inst_10224);

(statearr_10272[(12)] = inst_10223);

return statearr_10272;
})();
var statearr_10273_10310 = state_10269__$1;
(statearr_10273_10310[(2)] = null);

(statearr_10273_10310[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10270 === (1))){
var state_10269__$1 = state_10269;
var statearr_10274_10311 = state_10269__$1;
(statearr_10274_10311[(2)] = null);

(statearr_10274_10311[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10270 === (4))){
var inst_10210 = (state_10269[(13)]);
var inst_10210__$1 = (state_10269[(2)]);
var inst_10211 = (inst_10210__$1 == null);
var state_10269__$1 = (function (){var statearr_10275 = state_10269;
(statearr_10275[(13)] = inst_10210__$1);

return statearr_10275;
})();
if(cljs.core.truth_(inst_10211)){
var statearr_10276_10312 = state_10269__$1;
(statearr_10276_10312[(1)] = (5));

} else {
var statearr_10277_10313 = state_10269__$1;
(statearr_10277_10313[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10270 === (15))){
var state_10269__$1 = state_10269;
var statearr_10281_10314 = state_10269__$1;
(statearr_10281_10314[(2)] = null);

(statearr_10281_10314[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10270 === (21))){
var state_10269__$1 = state_10269;
var statearr_10282_10315 = state_10269__$1;
(statearr_10282_10315[(2)] = null);

(statearr_10282_10315[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10270 === (13))){
var inst_10221 = (state_10269[(8)]);
var inst_10222 = (state_10269[(9)]);
var inst_10224 = (state_10269[(11)]);
var inst_10223 = (state_10269[(12)]);
var inst_10231 = (state_10269[(2)]);
var inst_10232 = (inst_10224 + (1));
var tmp10278 = inst_10221;
var tmp10279 = inst_10222;
var tmp10280 = inst_10223;
var inst_10221__$1 = tmp10278;
var inst_10222__$1 = tmp10279;
var inst_10223__$1 = tmp10280;
var inst_10224__$1 = inst_10232;
var state_10269__$1 = (function (){var statearr_10283 = state_10269;
(statearr_10283[(8)] = inst_10221__$1);

(statearr_10283[(9)] = inst_10222__$1);

(statearr_10283[(14)] = inst_10231);

(statearr_10283[(11)] = inst_10224__$1);

(statearr_10283[(12)] = inst_10223__$1);

return statearr_10283;
})();
var statearr_10284_10316 = state_10269__$1;
(statearr_10284_10316[(2)] = null);

(statearr_10284_10316[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10270 === (22))){
var state_10269__$1 = state_10269;
var statearr_10285_10317 = state_10269__$1;
(statearr_10285_10317[(2)] = null);

(statearr_10285_10317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10270 === (6))){
var inst_10210 = (state_10269[(13)]);
var inst_10219 = f.call(null,inst_10210);
var inst_10220 = cljs.core.seq.call(null,inst_10219);
var inst_10221 = inst_10220;
var inst_10222 = null;
var inst_10223 = (0);
var inst_10224 = (0);
var state_10269__$1 = (function (){var statearr_10286 = state_10269;
(statearr_10286[(8)] = inst_10221);

(statearr_10286[(9)] = inst_10222);

(statearr_10286[(11)] = inst_10224);

(statearr_10286[(12)] = inst_10223);

return statearr_10286;
})();
var statearr_10287_10318 = state_10269__$1;
(statearr_10287_10318[(2)] = null);

(statearr_10287_10318[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10270 === (17))){
var inst_10235 = (state_10269[(7)]);
var inst_10239 = cljs.core.chunk_first.call(null,inst_10235);
var inst_10240 = cljs.core.chunk_rest.call(null,inst_10235);
var inst_10241 = cljs.core.count.call(null,inst_10239);
var inst_10221 = inst_10240;
var inst_10222 = inst_10239;
var inst_10223 = inst_10241;
var inst_10224 = (0);
var state_10269__$1 = (function (){var statearr_10288 = state_10269;
(statearr_10288[(8)] = inst_10221);

(statearr_10288[(9)] = inst_10222);

(statearr_10288[(11)] = inst_10224);

(statearr_10288[(12)] = inst_10223);

return statearr_10288;
})();
var statearr_10289_10319 = state_10269__$1;
(statearr_10289_10319[(2)] = null);

(statearr_10289_10319[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10270 === (3))){
var inst_10267 = (state_10269[(2)]);
var state_10269__$1 = state_10269;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10269__$1,inst_10267);
} else {
if((state_val_10270 === (12))){
var inst_10255 = (state_10269[(2)]);
var state_10269__$1 = state_10269;
var statearr_10290_10320 = state_10269__$1;
(statearr_10290_10320[(2)] = inst_10255);

(statearr_10290_10320[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10270 === (2))){
var state_10269__$1 = state_10269;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10269__$1,(4),in$);
} else {
if((state_val_10270 === (23))){
var inst_10263 = (state_10269[(2)]);
var state_10269__$1 = state_10269;
var statearr_10291_10321 = state_10269__$1;
(statearr_10291_10321[(2)] = inst_10263);

(statearr_10291_10321[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10270 === (19))){
var inst_10250 = (state_10269[(2)]);
var state_10269__$1 = state_10269;
var statearr_10292_10322 = state_10269__$1;
(statearr_10292_10322[(2)] = inst_10250);

(statearr_10292_10322[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10270 === (11))){
var inst_10221 = (state_10269[(8)]);
var inst_10235 = (state_10269[(7)]);
var inst_10235__$1 = cljs.core.seq.call(null,inst_10221);
var state_10269__$1 = (function (){var statearr_10293 = state_10269;
(statearr_10293[(7)] = inst_10235__$1);

return statearr_10293;
})();
if(inst_10235__$1){
var statearr_10294_10323 = state_10269__$1;
(statearr_10294_10323[(1)] = (14));

} else {
var statearr_10295_10324 = state_10269__$1;
(statearr_10295_10324[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10270 === (9))){
var inst_10257 = (state_10269[(2)]);
var inst_10258 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_10269__$1 = (function (){var statearr_10296 = state_10269;
(statearr_10296[(15)] = inst_10257);

return statearr_10296;
})();
if(cljs.core.truth_(inst_10258)){
var statearr_10297_10325 = state_10269__$1;
(statearr_10297_10325[(1)] = (21));

} else {
var statearr_10298_10326 = state_10269__$1;
(statearr_10298_10326[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10270 === (5))){
var inst_10213 = cljs.core.async.close_BANG_.call(null,out);
var state_10269__$1 = state_10269;
var statearr_10299_10327 = state_10269__$1;
(statearr_10299_10327[(2)] = inst_10213);

(statearr_10299_10327[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10270 === (14))){
var inst_10235 = (state_10269[(7)]);
var inst_10237 = cljs.core.chunked_seq_QMARK_.call(null,inst_10235);
var state_10269__$1 = state_10269;
if(inst_10237){
var statearr_10300_10328 = state_10269__$1;
(statearr_10300_10328[(1)] = (17));

} else {
var statearr_10301_10329 = state_10269__$1;
(statearr_10301_10329[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10270 === (16))){
var inst_10253 = (state_10269[(2)]);
var state_10269__$1 = state_10269;
var statearr_10302_10330 = state_10269__$1;
(statearr_10302_10330[(2)] = inst_10253);

(statearr_10302_10330[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10270 === (10))){
var inst_10222 = (state_10269[(9)]);
var inst_10224 = (state_10269[(11)]);
var inst_10229 = cljs.core._nth.call(null,inst_10222,inst_10224);
var state_10269__$1 = state_10269;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10269__$1,(13),out,inst_10229);
} else {
if((state_val_10270 === (18))){
var inst_10235 = (state_10269[(7)]);
var inst_10244 = cljs.core.first.call(null,inst_10235);
var state_10269__$1 = state_10269;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10269__$1,(20),out,inst_10244);
} else {
if((state_val_10270 === (8))){
var inst_10224 = (state_10269[(11)]);
var inst_10223 = (state_10269[(12)]);
var inst_10226 = (inst_10224 < inst_10223);
var inst_10227 = inst_10226;
var state_10269__$1 = state_10269;
if(cljs.core.truth_(inst_10227)){
var statearr_10303_10331 = state_10269__$1;
(statearr_10303_10331[(1)] = (10));

} else {
var statearr_10304_10332 = state_10269__$1;
(statearr_10304_10332[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6791__auto__))
;
return ((function (switch__6624__auto__,c__6791__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__6625__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__6625__auto____0 = (function (){
var statearr_10305 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_10305[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__6625__auto__);

(statearr_10305[(1)] = (1));

return statearr_10305;
});
var cljs$core$async$mapcat_STAR__$_state_machine__6625__auto____1 = (function (state_10269){
while(true){
var ret_value__6626__auto__ = (function (){try{while(true){
var result__6627__auto__ = switch__6624__auto__.call(null,state_10269);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6627__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6627__auto__;
}
break;
}
}catch (e10306){if((e10306 instanceof Object)){
var ex__6628__auto__ = e10306;
var statearr_10307_10333 = state_10269;
(statearr_10307_10333[(5)] = ex__6628__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10269);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10306;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6626__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10334 = state_10269;
state_10269 = G__10334;
continue;
} else {
return ret_value__6626__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__6625__auto__ = function(state_10269){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__6625__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__6625__auto____1.call(this,state_10269);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__6625__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__6625__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__6625__auto__;
})()
;})(switch__6624__auto__,c__6791__auto__))
})();
var state__6793__auto__ = (function (){var statearr_10308 = f__6792__auto__.call(null);
(statearr_10308[(6)] = c__6791__auto__);

return statearr_10308;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6793__auto__);
});})(c__6791__auto__))
);

return c__6791__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__10336 = arguments.length;
switch (G__10336) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__10339 = arguments.length;
switch (G__10339) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__10342 = arguments.length;
switch (G__10342) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__6791__auto___10389 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6791__auto___10389,out){
return (function (){
var f__6792__auto__ = (function (){var switch__6624__auto__ = ((function (c__6791__auto___10389,out){
return (function (state_10366){
var state_val_10367 = (state_10366[(1)]);
if((state_val_10367 === (7))){
var inst_10361 = (state_10366[(2)]);
var state_10366__$1 = state_10366;
var statearr_10368_10390 = state_10366__$1;
(statearr_10368_10390[(2)] = inst_10361);

(statearr_10368_10390[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10367 === (1))){
var inst_10343 = null;
var state_10366__$1 = (function (){var statearr_10369 = state_10366;
(statearr_10369[(7)] = inst_10343);

return statearr_10369;
})();
var statearr_10370_10391 = state_10366__$1;
(statearr_10370_10391[(2)] = null);

(statearr_10370_10391[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10367 === (4))){
var inst_10346 = (state_10366[(8)]);
var inst_10346__$1 = (state_10366[(2)]);
var inst_10347 = (inst_10346__$1 == null);
var inst_10348 = cljs.core.not.call(null,inst_10347);
var state_10366__$1 = (function (){var statearr_10371 = state_10366;
(statearr_10371[(8)] = inst_10346__$1);

return statearr_10371;
})();
if(inst_10348){
var statearr_10372_10392 = state_10366__$1;
(statearr_10372_10392[(1)] = (5));

} else {
var statearr_10373_10393 = state_10366__$1;
(statearr_10373_10393[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10367 === (6))){
var state_10366__$1 = state_10366;
var statearr_10374_10394 = state_10366__$1;
(statearr_10374_10394[(2)] = null);

(statearr_10374_10394[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10367 === (3))){
var inst_10363 = (state_10366[(2)]);
var inst_10364 = cljs.core.async.close_BANG_.call(null,out);
var state_10366__$1 = (function (){var statearr_10375 = state_10366;
(statearr_10375[(9)] = inst_10363);

return statearr_10375;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10366__$1,inst_10364);
} else {
if((state_val_10367 === (2))){
var state_10366__$1 = state_10366;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10366__$1,(4),ch);
} else {
if((state_val_10367 === (11))){
var inst_10346 = (state_10366[(8)]);
var inst_10355 = (state_10366[(2)]);
var inst_10343 = inst_10346;
var state_10366__$1 = (function (){var statearr_10376 = state_10366;
(statearr_10376[(10)] = inst_10355);

(statearr_10376[(7)] = inst_10343);

return statearr_10376;
})();
var statearr_10377_10395 = state_10366__$1;
(statearr_10377_10395[(2)] = null);

(statearr_10377_10395[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10367 === (9))){
var inst_10346 = (state_10366[(8)]);
var state_10366__$1 = state_10366;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10366__$1,(11),out,inst_10346);
} else {
if((state_val_10367 === (5))){
var inst_10346 = (state_10366[(8)]);
var inst_10343 = (state_10366[(7)]);
var inst_10350 = cljs.core._EQ_.call(null,inst_10346,inst_10343);
var state_10366__$1 = state_10366;
if(inst_10350){
var statearr_10379_10396 = state_10366__$1;
(statearr_10379_10396[(1)] = (8));

} else {
var statearr_10380_10397 = state_10366__$1;
(statearr_10380_10397[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10367 === (10))){
var inst_10358 = (state_10366[(2)]);
var state_10366__$1 = state_10366;
var statearr_10381_10398 = state_10366__$1;
(statearr_10381_10398[(2)] = inst_10358);

(statearr_10381_10398[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10367 === (8))){
var inst_10343 = (state_10366[(7)]);
var tmp10378 = inst_10343;
var inst_10343__$1 = tmp10378;
var state_10366__$1 = (function (){var statearr_10382 = state_10366;
(statearr_10382[(7)] = inst_10343__$1);

return statearr_10382;
})();
var statearr_10383_10399 = state_10366__$1;
(statearr_10383_10399[(2)] = null);

(statearr_10383_10399[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__6791__auto___10389,out))
;
return ((function (switch__6624__auto__,c__6791__auto___10389,out){
return (function() {
var cljs$core$async$state_machine__6625__auto__ = null;
var cljs$core$async$state_machine__6625__auto____0 = (function (){
var statearr_10384 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_10384[(0)] = cljs$core$async$state_machine__6625__auto__);

(statearr_10384[(1)] = (1));

return statearr_10384;
});
var cljs$core$async$state_machine__6625__auto____1 = (function (state_10366){
while(true){
var ret_value__6626__auto__ = (function (){try{while(true){
var result__6627__auto__ = switch__6624__auto__.call(null,state_10366);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6627__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6627__auto__;
}
break;
}
}catch (e10385){if((e10385 instanceof Object)){
var ex__6628__auto__ = e10385;
var statearr_10386_10400 = state_10366;
(statearr_10386_10400[(5)] = ex__6628__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10366);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10385;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6626__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10401 = state_10366;
state_10366 = G__10401;
continue;
} else {
return ret_value__6626__auto__;
}
break;
}
});
cljs$core$async$state_machine__6625__auto__ = function(state_10366){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6625__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6625__auto____1.call(this,state_10366);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6625__auto____0;
cljs$core$async$state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6625__auto____1;
return cljs$core$async$state_machine__6625__auto__;
})()
;})(switch__6624__auto__,c__6791__auto___10389,out))
})();
var state__6793__auto__ = (function (){var statearr_10387 = f__6792__auto__.call(null);
(statearr_10387[(6)] = c__6791__auto___10389);

return statearr_10387;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6793__auto__);
});})(c__6791__auto___10389,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__10403 = arguments.length;
switch (G__10403) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__6791__auto___10469 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6791__auto___10469,out){
return (function (){
var f__6792__auto__ = (function (){var switch__6624__auto__ = ((function (c__6791__auto___10469,out){
return (function (state_10441){
var state_val_10442 = (state_10441[(1)]);
if((state_val_10442 === (7))){
var inst_10437 = (state_10441[(2)]);
var state_10441__$1 = state_10441;
var statearr_10443_10470 = state_10441__$1;
(statearr_10443_10470[(2)] = inst_10437);

(statearr_10443_10470[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10442 === (1))){
var inst_10404 = (new Array(n));
var inst_10405 = inst_10404;
var inst_10406 = (0);
var state_10441__$1 = (function (){var statearr_10444 = state_10441;
(statearr_10444[(7)] = inst_10406);

(statearr_10444[(8)] = inst_10405);

return statearr_10444;
})();
var statearr_10445_10471 = state_10441__$1;
(statearr_10445_10471[(2)] = null);

(statearr_10445_10471[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10442 === (4))){
var inst_10409 = (state_10441[(9)]);
var inst_10409__$1 = (state_10441[(2)]);
var inst_10410 = (inst_10409__$1 == null);
var inst_10411 = cljs.core.not.call(null,inst_10410);
var state_10441__$1 = (function (){var statearr_10446 = state_10441;
(statearr_10446[(9)] = inst_10409__$1);

return statearr_10446;
})();
if(inst_10411){
var statearr_10447_10472 = state_10441__$1;
(statearr_10447_10472[(1)] = (5));

} else {
var statearr_10448_10473 = state_10441__$1;
(statearr_10448_10473[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10442 === (15))){
var inst_10431 = (state_10441[(2)]);
var state_10441__$1 = state_10441;
var statearr_10449_10474 = state_10441__$1;
(statearr_10449_10474[(2)] = inst_10431);

(statearr_10449_10474[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10442 === (13))){
var state_10441__$1 = state_10441;
var statearr_10450_10475 = state_10441__$1;
(statearr_10450_10475[(2)] = null);

(statearr_10450_10475[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10442 === (6))){
var inst_10406 = (state_10441[(7)]);
var inst_10427 = (inst_10406 > (0));
var state_10441__$1 = state_10441;
if(cljs.core.truth_(inst_10427)){
var statearr_10451_10476 = state_10441__$1;
(statearr_10451_10476[(1)] = (12));

} else {
var statearr_10452_10477 = state_10441__$1;
(statearr_10452_10477[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10442 === (3))){
var inst_10439 = (state_10441[(2)]);
var state_10441__$1 = state_10441;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10441__$1,inst_10439);
} else {
if((state_val_10442 === (12))){
var inst_10405 = (state_10441[(8)]);
var inst_10429 = cljs.core.vec.call(null,inst_10405);
var state_10441__$1 = state_10441;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10441__$1,(15),out,inst_10429);
} else {
if((state_val_10442 === (2))){
var state_10441__$1 = state_10441;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10441__$1,(4),ch);
} else {
if((state_val_10442 === (11))){
var inst_10421 = (state_10441[(2)]);
var inst_10422 = (new Array(n));
var inst_10405 = inst_10422;
var inst_10406 = (0);
var state_10441__$1 = (function (){var statearr_10453 = state_10441;
(statearr_10453[(7)] = inst_10406);

(statearr_10453[(8)] = inst_10405);

(statearr_10453[(10)] = inst_10421);

return statearr_10453;
})();
var statearr_10454_10478 = state_10441__$1;
(statearr_10454_10478[(2)] = null);

(statearr_10454_10478[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10442 === (9))){
var inst_10405 = (state_10441[(8)]);
var inst_10419 = cljs.core.vec.call(null,inst_10405);
var state_10441__$1 = state_10441;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10441__$1,(11),out,inst_10419);
} else {
if((state_val_10442 === (5))){
var inst_10406 = (state_10441[(7)]);
var inst_10405 = (state_10441[(8)]);
var inst_10414 = (state_10441[(11)]);
var inst_10409 = (state_10441[(9)]);
var inst_10413 = (inst_10405[inst_10406] = inst_10409);
var inst_10414__$1 = (inst_10406 + (1));
var inst_10415 = (inst_10414__$1 < n);
var state_10441__$1 = (function (){var statearr_10455 = state_10441;
(statearr_10455[(12)] = inst_10413);

(statearr_10455[(11)] = inst_10414__$1);

return statearr_10455;
})();
if(cljs.core.truth_(inst_10415)){
var statearr_10456_10479 = state_10441__$1;
(statearr_10456_10479[(1)] = (8));

} else {
var statearr_10457_10480 = state_10441__$1;
(statearr_10457_10480[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10442 === (14))){
var inst_10434 = (state_10441[(2)]);
var inst_10435 = cljs.core.async.close_BANG_.call(null,out);
var state_10441__$1 = (function (){var statearr_10459 = state_10441;
(statearr_10459[(13)] = inst_10434);

return statearr_10459;
})();
var statearr_10460_10481 = state_10441__$1;
(statearr_10460_10481[(2)] = inst_10435);

(statearr_10460_10481[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10442 === (10))){
var inst_10425 = (state_10441[(2)]);
var state_10441__$1 = state_10441;
var statearr_10461_10482 = state_10441__$1;
(statearr_10461_10482[(2)] = inst_10425);

(statearr_10461_10482[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10442 === (8))){
var inst_10405 = (state_10441[(8)]);
var inst_10414 = (state_10441[(11)]);
var tmp10458 = inst_10405;
var inst_10405__$1 = tmp10458;
var inst_10406 = inst_10414;
var state_10441__$1 = (function (){var statearr_10462 = state_10441;
(statearr_10462[(7)] = inst_10406);

(statearr_10462[(8)] = inst_10405__$1);

return statearr_10462;
})();
var statearr_10463_10483 = state_10441__$1;
(statearr_10463_10483[(2)] = null);

(statearr_10463_10483[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6791__auto___10469,out))
;
return ((function (switch__6624__auto__,c__6791__auto___10469,out){
return (function() {
var cljs$core$async$state_machine__6625__auto__ = null;
var cljs$core$async$state_machine__6625__auto____0 = (function (){
var statearr_10464 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_10464[(0)] = cljs$core$async$state_machine__6625__auto__);

(statearr_10464[(1)] = (1));

return statearr_10464;
});
var cljs$core$async$state_machine__6625__auto____1 = (function (state_10441){
while(true){
var ret_value__6626__auto__ = (function (){try{while(true){
var result__6627__auto__ = switch__6624__auto__.call(null,state_10441);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6627__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6627__auto__;
}
break;
}
}catch (e10465){if((e10465 instanceof Object)){
var ex__6628__auto__ = e10465;
var statearr_10466_10484 = state_10441;
(statearr_10466_10484[(5)] = ex__6628__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10441);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10465;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6626__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10485 = state_10441;
state_10441 = G__10485;
continue;
} else {
return ret_value__6626__auto__;
}
break;
}
});
cljs$core$async$state_machine__6625__auto__ = function(state_10441){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6625__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6625__auto____1.call(this,state_10441);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6625__auto____0;
cljs$core$async$state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6625__auto____1;
return cljs$core$async$state_machine__6625__auto__;
})()
;})(switch__6624__auto__,c__6791__auto___10469,out))
})();
var state__6793__auto__ = (function (){var statearr_10467 = f__6792__auto__.call(null);
(statearr_10467[(6)] = c__6791__auto___10469);

return statearr_10467;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6793__auto__);
});})(c__6791__auto___10469,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__10487 = arguments.length;
switch (G__10487) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__6791__auto___10557 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6791__auto___10557,out){
return (function (){
var f__6792__auto__ = (function (){var switch__6624__auto__ = ((function (c__6791__auto___10557,out){
return (function (state_10529){
var state_val_10530 = (state_10529[(1)]);
if((state_val_10530 === (7))){
var inst_10525 = (state_10529[(2)]);
var state_10529__$1 = state_10529;
var statearr_10531_10558 = state_10529__$1;
(statearr_10531_10558[(2)] = inst_10525);

(statearr_10531_10558[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10530 === (1))){
var inst_10488 = [];
var inst_10489 = inst_10488;
var inst_10490 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_10529__$1 = (function (){var statearr_10532 = state_10529;
(statearr_10532[(7)] = inst_10489);

(statearr_10532[(8)] = inst_10490);

return statearr_10532;
})();
var statearr_10533_10559 = state_10529__$1;
(statearr_10533_10559[(2)] = null);

(statearr_10533_10559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10530 === (4))){
var inst_10493 = (state_10529[(9)]);
var inst_10493__$1 = (state_10529[(2)]);
var inst_10494 = (inst_10493__$1 == null);
var inst_10495 = cljs.core.not.call(null,inst_10494);
var state_10529__$1 = (function (){var statearr_10534 = state_10529;
(statearr_10534[(9)] = inst_10493__$1);

return statearr_10534;
})();
if(inst_10495){
var statearr_10535_10560 = state_10529__$1;
(statearr_10535_10560[(1)] = (5));

} else {
var statearr_10536_10561 = state_10529__$1;
(statearr_10536_10561[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10530 === (15))){
var inst_10519 = (state_10529[(2)]);
var state_10529__$1 = state_10529;
var statearr_10537_10562 = state_10529__$1;
(statearr_10537_10562[(2)] = inst_10519);

(statearr_10537_10562[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10530 === (13))){
var state_10529__$1 = state_10529;
var statearr_10538_10563 = state_10529__$1;
(statearr_10538_10563[(2)] = null);

(statearr_10538_10563[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10530 === (6))){
var inst_10489 = (state_10529[(7)]);
var inst_10514 = inst_10489.length;
var inst_10515 = (inst_10514 > (0));
var state_10529__$1 = state_10529;
if(cljs.core.truth_(inst_10515)){
var statearr_10539_10564 = state_10529__$1;
(statearr_10539_10564[(1)] = (12));

} else {
var statearr_10540_10565 = state_10529__$1;
(statearr_10540_10565[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10530 === (3))){
var inst_10527 = (state_10529[(2)]);
var state_10529__$1 = state_10529;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10529__$1,inst_10527);
} else {
if((state_val_10530 === (12))){
var inst_10489 = (state_10529[(7)]);
var inst_10517 = cljs.core.vec.call(null,inst_10489);
var state_10529__$1 = state_10529;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10529__$1,(15),out,inst_10517);
} else {
if((state_val_10530 === (2))){
var state_10529__$1 = state_10529;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10529__$1,(4),ch);
} else {
if((state_val_10530 === (11))){
var inst_10497 = (state_10529[(10)]);
var inst_10493 = (state_10529[(9)]);
var inst_10507 = (state_10529[(2)]);
var inst_10508 = [];
var inst_10509 = inst_10508.push(inst_10493);
var inst_10489 = inst_10508;
var inst_10490 = inst_10497;
var state_10529__$1 = (function (){var statearr_10541 = state_10529;
(statearr_10541[(11)] = inst_10509);

(statearr_10541[(12)] = inst_10507);

(statearr_10541[(7)] = inst_10489);

(statearr_10541[(8)] = inst_10490);

return statearr_10541;
})();
var statearr_10542_10566 = state_10529__$1;
(statearr_10542_10566[(2)] = null);

(statearr_10542_10566[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10530 === (9))){
var inst_10489 = (state_10529[(7)]);
var inst_10505 = cljs.core.vec.call(null,inst_10489);
var state_10529__$1 = state_10529;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10529__$1,(11),out,inst_10505);
} else {
if((state_val_10530 === (5))){
var inst_10497 = (state_10529[(10)]);
var inst_10493 = (state_10529[(9)]);
var inst_10490 = (state_10529[(8)]);
var inst_10497__$1 = f.call(null,inst_10493);
var inst_10498 = cljs.core._EQ_.call(null,inst_10497__$1,inst_10490);
var inst_10499 = cljs.core.keyword_identical_QMARK_.call(null,inst_10490,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_10500 = ((inst_10498) || (inst_10499));
var state_10529__$1 = (function (){var statearr_10543 = state_10529;
(statearr_10543[(10)] = inst_10497__$1);

return statearr_10543;
})();
if(cljs.core.truth_(inst_10500)){
var statearr_10544_10567 = state_10529__$1;
(statearr_10544_10567[(1)] = (8));

} else {
var statearr_10545_10568 = state_10529__$1;
(statearr_10545_10568[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10530 === (14))){
var inst_10522 = (state_10529[(2)]);
var inst_10523 = cljs.core.async.close_BANG_.call(null,out);
var state_10529__$1 = (function (){var statearr_10547 = state_10529;
(statearr_10547[(13)] = inst_10522);

return statearr_10547;
})();
var statearr_10548_10569 = state_10529__$1;
(statearr_10548_10569[(2)] = inst_10523);

(statearr_10548_10569[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10530 === (10))){
var inst_10512 = (state_10529[(2)]);
var state_10529__$1 = state_10529;
var statearr_10549_10570 = state_10529__$1;
(statearr_10549_10570[(2)] = inst_10512);

(statearr_10549_10570[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10530 === (8))){
var inst_10497 = (state_10529[(10)]);
var inst_10489 = (state_10529[(7)]);
var inst_10493 = (state_10529[(9)]);
var inst_10502 = inst_10489.push(inst_10493);
var tmp10546 = inst_10489;
var inst_10489__$1 = tmp10546;
var inst_10490 = inst_10497;
var state_10529__$1 = (function (){var statearr_10550 = state_10529;
(statearr_10550[(7)] = inst_10489__$1);

(statearr_10550[(8)] = inst_10490);

(statearr_10550[(14)] = inst_10502);

return statearr_10550;
})();
var statearr_10551_10571 = state_10529__$1;
(statearr_10551_10571[(2)] = null);

(statearr_10551_10571[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6791__auto___10557,out))
;
return ((function (switch__6624__auto__,c__6791__auto___10557,out){
return (function() {
var cljs$core$async$state_machine__6625__auto__ = null;
var cljs$core$async$state_machine__6625__auto____0 = (function (){
var statearr_10552 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_10552[(0)] = cljs$core$async$state_machine__6625__auto__);

(statearr_10552[(1)] = (1));

return statearr_10552;
});
var cljs$core$async$state_machine__6625__auto____1 = (function (state_10529){
while(true){
var ret_value__6626__auto__ = (function (){try{while(true){
var result__6627__auto__ = switch__6624__auto__.call(null,state_10529);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6627__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6627__auto__;
}
break;
}
}catch (e10553){if((e10553 instanceof Object)){
var ex__6628__auto__ = e10553;
var statearr_10554_10572 = state_10529;
(statearr_10554_10572[(5)] = ex__6628__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10529);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10553;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6626__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10573 = state_10529;
state_10529 = G__10573;
continue;
} else {
return ret_value__6626__auto__;
}
break;
}
});
cljs$core$async$state_machine__6625__auto__ = function(state_10529){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6625__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6625__auto____1.call(this,state_10529);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6625__auto____0;
cljs$core$async$state_machine__6625__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6625__auto____1;
return cljs$core$async$state_machine__6625__auto__;
})()
;})(switch__6624__auto__,c__6791__auto___10557,out))
})();
var state__6793__auto__ = (function (){var statearr_10555 = f__6792__auto__.call(null);
(statearr_10555[(6)] = c__6791__auto___10557);

return statearr_10555;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6793__auto__);
});})(c__6791__auto___10557,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map
