// Compiled by ClojureScript 1.10.520 {}
goog.provide('imcljs.save');
goog.require('cljs.core');
goog.require('imcljs.internal.io');
goog.require('imcljs.fetch');
goog.require('imcljs.internal.utils');
goog.require('cljs.core.async');
/**
 * Creates a list using a plain text string of identifiers
 */
imcljs.save.im_list = (function imcljs$save$im_list(var_args){
var args__4736__auto__ = [];
var len__4730__auto___19106 = arguments.length;
var i__4731__auto___19107 = (0);
while(true){
if((i__4731__auto___19107 < len__4730__auto___19106)){
args__4736__auto__.push((arguments[i__4731__auto___19107]));

var G__19108 = (i__4731__auto___19107 + (1));
i__4731__auto___19107 = G__19108;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((4) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((4)),(0),null)):null);
return imcljs.save.im_list.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4737__auto__);
});

imcljs.save.im_list.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,type,identifiers,p__19102){
var vec__19103 = p__19102;
var options = cljs.core.nth.call(null,vec__19103,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post-body","post-body",-1481559189),["/lists?name=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"&type=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join(''),service,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"body","body",-2049205669),identifiers,new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","text/plain"], null)], null));
});

imcljs.save.im_list.cljs$lang$maxFixedArity = (4);

/** @this {Function} */
imcljs.save.im_list.cljs$lang$applyTo = (function (seq19097){
var G__19098 = cljs.core.first.call(null,seq19097);
var seq19097__$1 = cljs.core.next.call(null,seq19097);
var G__19099 = cljs.core.first.call(null,seq19097__$1);
var seq19097__$2 = cljs.core.next.call(null,seq19097__$1);
var G__19100 = cljs.core.first.call(null,seq19097__$2);
var seq19097__$3 = cljs.core.next.call(null,seq19097__$2);
var G__19101 = cljs.core.first.call(null,seq19097__$3);
var seq19097__$4 = cljs.core.next.call(null,seq19097__$3);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19098,G__19099,G__19100,G__19101,seq19097__$4);
});

/**
 * Update an existing list. Currently, only updating the description by specifying
 *   `:newDescription` in the `options` map is supported.
 */
imcljs.save.im_list_update = (function imcljs$save$im_list_update(var_args){
var args__4736__auto__ = [];
var len__4730__auto___19116 = arguments.length;
var i__4731__auto___19117 = (0);
while(true){
if((i__4731__auto___19117 < len__4730__auto___19116)){
args__4736__auto__.push((arguments[i__4731__auto___19117]));

var G__19118 = (i__4731__auto___19117 + (1));
i__4731__auto___19117 = G__19118;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.im_list_update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.im_list_update.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,p__19112){
var vec__19113 = p__19112;
var options = cljs.core.nth.call(null,vec__19113,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"put","put",1299772570),"/lists",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_update.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.im_list_update.cljs$lang$applyTo = (function (seq19109){
var G__19110 = cljs.core.first.call(null,seq19109);
var seq19109__$1 = cljs.core.next.call(null,seq19109);
var G__19111 = cljs.core.first.call(null,seq19109__$1);
var seq19109__$2 = cljs.core.next.call(null,seq19109__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19110,G__19111,seq19109__$2);
});

/**
 * Delete one or name lists.
 */
imcljs.save.im_list_delete = (function imcljs$save$im_list_delete(var_args){
var args__4736__auto__ = [];
var len__4730__auto___19126 = arguments.length;
var i__4731__auto___19127 = (0);
while(true){
if((i__4731__auto___19127 < len__4730__auto___19126)){
args__4736__auto__.push((arguments[i__4731__auto___19127]));

var G__19128 = (i__4731__auto___19127 + (1));
i__4731__auto___19127 = G__19128;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.im_list_delete.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.im_list_delete.cljs$core$IFn$_invoke$arity$variadic = (function (service,names,p__19122){
var vec__19123 = p__19122;
var options = cljs.core.nth.call(null,vec__19123,(0),null);
if(cljs.core.coll_QMARK_.call(null,names)){
return imcljs.internal.utils._LT__LT__BANG_.call(null,cljs.core.map.call(null,((function (vec__19123,options){
return (function (name){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/lists",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});})(vec__19123,options))
,names));
} else {
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/lists",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),names,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
}
});

imcljs.save.im_list_delete.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.im_list_delete.cljs$lang$applyTo = (function (seq19119){
var G__19120 = cljs.core.first.call(null,seq19119);
var seq19119__$1 = cljs.core.next.call(null,seq19119);
var G__19121 = cljs.core.first.call(null,seq19119__$1);
var seq19119__$2 = cljs.core.next.call(null,seq19119__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19120,G__19121,seq19119__$2);
});

imcljs.save.im_list_rename = (function imcljs$save$im_list_rename(var_args){
var args__4736__auto__ = [];
var len__4730__auto___19137 = arguments.length;
var i__4731__auto___19138 = (0);
while(true){
if((i__4731__auto___19138 < len__4730__auto___19137)){
args__4736__auto__.push((arguments[i__4731__auto___19138]));

var G__19139 = (i__4731__auto___19138 + (1));
i__4731__auto___19138 = G__19139;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_rename.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_rename.cljs$core$IFn$_invoke$arity$variadic = (function (service,old_name,new_name,p__19133){
var vec__19134 = p__19133;
var options = cljs.core.nth.call(null,vec__19134,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/lists/rename",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"oldname","oldname",-234488026),old_name,new cljs.core.Keyword(null,"newname","newname",389205813),new_name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_rename.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_rename.cljs$lang$applyTo = (function (seq19129){
var G__19130 = cljs.core.first.call(null,seq19129);
var seq19129__$1 = cljs.core.next.call(null,seq19129);
var G__19131 = cljs.core.first.call(null,seq19129__$1);
var seq19129__$2 = cljs.core.next.call(null,seq19129__$1);
var G__19132 = cljs.core.first.call(null,seq19129__$2);
var seq19129__$3 = cljs.core.next.call(null,seq19129__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19130,G__19131,G__19132,seq19129__$3);
});

imcljs.save.im_list_union = (function imcljs$save$im_list_union(var_args){
var args__4736__auto__ = [];
var len__4730__auto___19148 = arguments.length;
var i__4731__auto___19149 = (0);
while(true){
if((i__4731__auto___19149 < len__4730__auto___19148)){
args__4736__auto__.push((arguments[i__4731__auto___19149]));

var G__19150 = (i__4731__auto___19149 + (1));
i__4731__auto___19149 = G__19150;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_union.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_union.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,lists,p__19144){
var vec__19145 = p__19144;
var options = cljs.core.nth.call(null,vec__19145,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/lists/union",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"lists","lists",-884730684),lists,new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_union.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_union.cljs$lang$applyTo = (function (seq19140){
var G__19141 = cljs.core.first.call(null,seq19140);
var seq19140__$1 = cljs.core.next.call(null,seq19140);
var G__19142 = cljs.core.first.call(null,seq19140__$1);
var seq19140__$2 = cljs.core.next.call(null,seq19140__$1);
var G__19143 = cljs.core.first.call(null,seq19140__$2);
var seq19140__$3 = cljs.core.next.call(null,seq19140__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19141,G__19142,G__19143,seq19140__$3);
});

imcljs.save.im_list_intersect = (function imcljs$save$im_list_intersect(var_args){
var args__4736__auto__ = [];
var len__4730__auto___19159 = arguments.length;
var i__4731__auto___19160 = (0);
while(true){
if((i__4731__auto___19160 < len__4730__auto___19159)){
args__4736__auto__.push((arguments[i__4731__auto___19160]));

var G__19161 = (i__4731__auto___19160 + (1));
i__4731__auto___19160 = G__19161;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_intersect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_intersect.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,lists,p__19155){
var vec__19156 = p__19155;
var options = cljs.core.nth.call(null,vec__19156,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/lists/intersect",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"lists","lists",-884730684),lists,new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_intersect.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_intersect.cljs$lang$applyTo = (function (seq19151){
var G__19152 = cljs.core.first.call(null,seq19151);
var seq19151__$1 = cljs.core.next.call(null,seq19151);
var G__19153 = cljs.core.first.call(null,seq19151__$1);
var seq19151__$2 = cljs.core.next.call(null,seq19151__$1);
var G__19154 = cljs.core.first.call(null,seq19151__$2);
var seq19151__$3 = cljs.core.next.call(null,seq19151__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19152,G__19153,G__19154,seq19151__$3);
});

imcljs.save.im_list_difference = (function imcljs$save$im_list_difference(var_args){
var args__4736__auto__ = [];
var len__4730__auto___19170 = arguments.length;
var i__4731__auto___19171 = (0);
while(true){
if((i__4731__auto___19171 < len__4730__auto___19170)){
args__4736__auto__.push((arguments[i__4731__auto___19171]));

var G__19172 = (i__4731__auto___19171 + (1));
i__4731__auto___19171 = G__19172;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_difference.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_difference.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,lists,p__19166){
var vec__19167 = p__19166;
var options = cljs.core.nth.call(null,vec__19167,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/lists/diff",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"lists","lists",-884730684),lists,new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_difference.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_difference.cljs$lang$applyTo = (function (seq19162){
var G__19163 = cljs.core.first.call(null,seq19162);
var seq19162__$1 = cljs.core.next.call(null,seq19162);
var G__19164 = cljs.core.first.call(null,seq19162__$1);
var seq19162__$2 = cljs.core.next.call(null,seq19162__$1);
var G__19165 = cljs.core.first.call(null,seq19162__$2);
var seq19162__$3 = cljs.core.next.call(null,seq19162__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19163,G__19164,G__19165,seq19162__$3);
});

imcljs.save.im_list_subtraction = (function imcljs$save$im_list_subtraction(var_args){
var args__4736__auto__ = [];
var len__4730__auto___19182 = arguments.length;
var i__4731__auto___19183 = (0);
while(true){
if((i__4731__auto___19183 < len__4730__auto___19182)){
args__4736__auto__.push((arguments[i__4731__auto___19183]));

var G__19184 = (i__4731__auto___19183 + (1));
i__4731__auto___19183 = G__19184;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((4) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((4)),(0),null)):null);
return imcljs.save.im_list_subtraction.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4737__auto__);
});

imcljs.save.im_list_subtraction.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,source_lists,subtract_lists,p__19178){
var vec__19179 = p__19178;
var options = cljs.core.nth.call(null,vec__19179,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/lists/subtract",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"references","references",882562509),source_lists,new cljs.core.Keyword(null,"subtract","subtract",2136988635),subtract_lists,new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_subtraction.cljs$lang$maxFixedArity = (4);

/** @this {Function} */
imcljs.save.im_list_subtraction.cljs$lang$applyTo = (function (seq19173){
var G__19174 = cljs.core.first.call(null,seq19173);
var seq19173__$1 = cljs.core.next.call(null,seq19173);
var G__19175 = cljs.core.first.call(null,seq19173__$1);
var seq19173__$2 = cljs.core.next.call(null,seq19173__$1);
var G__19176 = cljs.core.first.call(null,seq19173__$2);
var seq19173__$3 = cljs.core.next.call(null,seq19173__$2);
var G__19177 = cljs.core.first.call(null,seq19173__$3);
var seq19173__$4 = cljs.core.next.call(null,seq19173__$3);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19174,G__19175,G__19176,G__19177,seq19173__$4);
});

imcljs.save.im_list_from_query = (function imcljs$save$im_list_from_query(var_args){
var args__4736__auto__ = [];
var len__4730__auto___19193 = arguments.length;
var i__4731__auto___19194 = (0);
while(true){
if((i__4731__auto___19194 < len__4730__auto___19193)){
args__4736__auto__.push((arguments[i__4731__auto___19194]));

var G__19195 = (i__4731__auto___19194 + (1));
i__4731__auto___19194 = G__19195;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_from_query.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_from_query.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,query,p__19189){
var vec__19190 = p__19189;
var options = cljs.core.nth.call(null,vec__19190,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/tolist",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_from_query.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_from_query.cljs$lang$applyTo = (function (seq19185){
var G__19186 = cljs.core.first.call(null,seq19185);
var seq19185__$1 = cljs.core.next.call(null,seq19185);
var G__19187 = cljs.core.first.call(null,seq19185__$1);
var seq19185__$2 = cljs.core.next.call(null,seq19185__$1);
var G__19188 = cljs.core.first.call(null,seq19185__$2);
var seq19185__$3 = cljs.core.next.call(null,seq19185__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19186,G__19187,G__19188,seq19185__$3);
});

imcljs.save.im_list_add_tag = (function imcljs$save$im_list_add_tag(var_args){
var args__4736__auto__ = [];
var len__4730__auto___19204 = arguments.length;
var i__4731__auto___19205 = (0);
while(true){
if((i__4731__auto___19205 < len__4730__auto___19204)){
args__4736__auto__.push((arguments[i__4731__auto___19205]));

var G__19206 = (i__4731__auto___19205 + (1));
i__4731__auto___19205 = G__19206;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_add_tag.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_add_tag.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,tags,p__19200){
var vec__19201 = p__19200;
var options = cljs.core.nth.call(null,vec__19201,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/list/tags",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"tags","tags",1771418977),((cljs.core.coll_QMARK_.call(null,tags))?cljs.core.interpose.call(null,";",tags):tags),new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_add_tag.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_add_tag.cljs$lang$applyTo = (function (seq19196){
var G__19197 = cljs.core.first.call(null,seq19196);
var seq19196__$1 = cljs.core.next.call(null,seq19196);
var G__19198 = cljs.core.first.call(null,seq19196__$1);
var seq19196__$2 = cljs.core.next.call(null,seq19196__$1);
var G__19199 = cljs.core.first.call(null,seq19196__$2);
var seq19196__$3 = cljs.core.next.call(null,seq19196__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19197,G__19198,G__19199,seq19196__$3);
});

imcljs.save.im_list_remove_tag = (function imcljs$save$im_list_remove_tag(var_args){
var args__4736__auto__ = [];
var len__4730__auto___19215 = arguments.length;
var i__4731__auto___19216 = (0);
while(true){
if((i__4731__auto___19216 < len__4730__auto___19215)){
args__4736__auto__.push((arguments[i__4731__auto___19216]));

var G__19217 = (i__4731__auto___19216 + (1));
i__4731__auto___19216 = G__19217;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_remove_tag.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_remove_tag.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,tags,p__19211){
var vec__19212 = p__19211;
var options = cljs.core.nth.call(null,vec__19212,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/list/tags",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"tags","tags",1771418977),((cljs.core.coll_QMARK_.call(null,tags))?cljs.core.interpose.call(null,";",tags):tags),new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_remove_tag.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_remove_tag.cljs$lang$applyTo = (function (seq19207){
var G__19208 = cljs.core.first.call(null,seq19207);
var seq19207__$1 = cljs.core.next.call(null,seq19207);
var G__19209 = cljs.core.first.call(null,seq19207__$1);
var seq19207__$2 = cljs.core.next.call(null,seq19207__$1);
var G__19210 = cljs.core.first.call(null,seq19207__$2);
var seq19207__$3 = cljs.core.next.call(null,seq19207__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19208,G__19209,G__19210,seq19207__$3);
});

/**
 * Copy a list by name
 */
imcljs.save.im_list_copy = (function imcljs$save$im_list_copy(var_args){
var args__4736__auto__ = [];
var len__4730__auto___19240 = arguments.length;
var i__4731__auto___19241 = (0);
while(true){
if((i__4731__auto___19241 < len__4730__auto___19240)){
args__4736__auto__.push((arguments[i__4731__auto___19241]));

var G__19242 = (i__4731__auto___19241 + (1));
i__4731__auto___19241 = G__19242;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_copy.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_copy.cljs$core$IFn$_invoke$arity$variadic = (function (service,old_name,new_name,p__19222){
var vec__19223 = p__19222;
var options = cljs.core.nth.call(null,vec__19223,(0),null);
var c__2324__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2324__auto__,vec__19223,options){
return (function (){
var f__2325__auto__ = (function (){var switch__2301__auto__ = ((function (c__2324__auto__,vec__19223,options){
return (function (state_19234){
var state_val_19235 = (state_19234[(1)]);
if((state_val_19235 === (1))){
var inst_19226 = imcljs.fetch.one_list.call(null,service,old_name);
var state_19234__$1 = state_19234;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19234__$1,(2),inst_19226);
} else {
if((state_val_19235 === (2))){
var inst_19228 = (state_19234[(2)]);
var inst_19229 = imcljs.internal.utils.copy_list_query.call(null,inst_19228);
var inst_19230 = imcljs.save.im_list_from_query.call(null,service,new_name,inst_19229);
var state_19234__$1 = state_19234;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19234__$1,(3),inst_19230);
} else {
if((state_val_19235 === (3))){
var inst_19232 = (state_19234[(2)]);
var state_19234__$1 = state_19234;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19234__$1,inst_19232);
} else {
return null;
}
}
}
});})(c__2324__auto__,vec__19223,options))
;
return ((function (switch__2301__auto__,c__2324__auto__,vec__19223,options){
return (function() {
var imcljs$save$state_machine__2302__auto__ = null;
var imcljs$save$state_machine__2302__auto____0 = (function (){
var statearr_19236 = [null,null,null,null,null,null,null];
(statearr_19236[(0)] = imcljs$save$state_machine__2302__auto__);

(statearr_19236[(1)] = (1));

return statearr_19236;
});
var imcljs$save$state_machine__2302__auto____1 = (function (state_19234){
while(true){
var ret_value__2303__auto__ = (function (){try{while(true){
var result__2304__auto__ = switch__2301__auto__.call(null,state_19234);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2304__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2304__auto__;
}
break;
}
}catch (e19237){if((e19237 instanceof Object)){
var ex__2305__auto__ = e19237;
var statearr_19238_19243 = state_19234;
(statearr_19238_19243[(5)] = ex__2305__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19234);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19237;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2303__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19244 = state_19234;
state_19234 = G__19244;
continue;
} else {
return ret_value__2303__auto__;
}
break;
}
});
imcljs$save$state_machine__2302__auto__ = function(state_19234){
switch(arguments.length){
case 0:
return imcljs$save$state_machine__2302__auto____0.call(this);
case 1:
return imcljs$save$state_machine__2302__auto____1.call(this,state_19234);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
imcljs$save$state_machine__2302__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$save$state_machine__2302__auto____0;
imcljs$save$state_machine__2302__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$save$state_machine__2302__auto____1;
return imcljs$save$state_machine__2302__auto__;
})()
;})(switch__2301__auto__,c__2324__auto__,vec__19223,options))
})();
var state__2326__auto__ = (function (){var statearr_19239 = f__2325__auto__.call(null);
(statearr_19239[(6)] = c__2324__auto__);

return statearr_19239;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2326__auto__);
});})(c__2324__auto__,vec__19223,options))
);

return c__2324__auto__;
});

imcljs.save.im_list_copy.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_copy.cljs$lang$applyTo = (function (seq19218){
var G__19219 = cljs.core.first.call(null,seq19218);
var seq19218__$1 = cljs.core.next.call(null,seq19218);
var G__19220 = cljs.core.first.call(null,seq19218__$1);
var seq19218__$2 = cljs.core.next.call(null,seq19218__$1);
var G__19221 = cljs.core.first.call(null,seq19218__$2);
var seq19218__$3 = cljs.core.next.call(null,seq19218__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19219,G__19220,G__19221,seq19218__$3);
});

/**
 * Set the preferences for the authenticated user by passing a map.
 *   Note that none of the values can be an empty string. For that you'll have to
 *   use `delete-preference` instead.
 */
imcljs.save.preferences = (function imcljs$save$preferences(var_args){
var args__4736__auto__ = [];
var len__4730__auto___19252 = arguments.length;
var i__4731__auto___19253 = (0);
while(true){
if((i__4731__auto___19253 < len__4730__auto___19252)){
args__4736__auto__.push((arguments[i__4731__auto___19253]));

var G__19254 = (i__4731__auto___19253 + (1));
i__4731__auto___19253 = G__19254;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.preferences.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.preferences.cljs$core$IFn$_invoke$arity$variadic = (function (service,preferences,p__19248){
var vec__19249 = p__19248;
var options = cljs.core.nth.call(null,vec__19249,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/user/preferences",service,cljs.core.merge.call(null,preferences,options),new cljs.core.Keyword(null,"preferences","preferences",-484312211));
});

imcljs.save.preferences.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.preferences.cljs$lang$applyTo = (function (seq19245){
var G__19246 = cljs.core.first.call(null,seq19245);
var seq19245__$1 = cljs.core.next.call(null,seq19245);
var G__19247 = cljs.core.first.call(null,seq19245__$1);
var seq19245__$2 = cljs.core.next.call(null,seq19245__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19246,G__19247,seq19245__$2);
});

/**
 * Delete a single stored preference by key for the authenticated user.
 */
imcljs.save.delete_preference = (function imcljs$save$delete_preference(var_args){
var args__4736__auto__ = [];
var len__4730__auto___19262 = arguments.length;
var i__4731__auto___19263 = (0);
while(true){
if((i__4731__auto___19263 < len__4730__auto___19262)){
args__4736__auto__.push((arguments[i__4731__auto___19263]));

var G__19264 = (i__4731__auto___19263 + (1));
i__4731__auto___19263 = G__19264;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.delete_preference.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.delete_preference.cljs$core$IFn$_invoke$arity$variadic = (function (service,preference,p__19258){
var vec__19259 = p__19258;
var options = cljs.core.nth.call(null,vec__19259,(0),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),preference], null),options);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/user/preferences",service,params,new cljs.core.Keyword(null,"preferences","preferences",-484312211));
});

imcljs.save.delete_preference.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.delete_preference.cljs$lang$applyTo = (function (seq19255){
var G__19256 = cljs.core.first.call(null,seq19255);
var seq19255__$1 = cljs.core.next.call(null,seq19255);
var G__19257 = cljs.core.first.call(null,seq19255__$1);
var seq19255__$2 = cljs.core.next.call(null,seq19255__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19256,G__19257,seq19255__$2);
});

/**
 * Upload a query to be saved into the user's profile.
 *   As of InterMine 4.1.2, the webservice returns an invalid JSON response, hence
 *   why we use `:format 'text'` and no xform.
 */
imcljs.save.query = (function imcljs$save$query(var_args){
var args__4736__auto__ = [];
var len__4730__auto___19272 = arguments.length;
var i__4731__auto___19273 = (0);
while(true){
if((i__4731__auto___19273 < len__4730__auto___19272)){
args__4736__auto__.push((arguments[i__4731__auto___19273]));

var G__19274 = (i__4731__auto___19273 + (1));
i__4731__auto___19273 = G__19274;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.query.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.query.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__19268){
var vec__19269 = p__19268;
var options = cljs.core.nth.call(null,vec__19269,(0),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"text"], null),options);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/user/queries",service,params);
});

imcljs.save.query.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.query.cljs$lang$applyTo = (function (seq19265){
var G__19266 = cljs.core.first.call(null,seq19265);
var seq19265__$1 = cljs.core.next.call(null,seq19265);
var G__19267 = cljs.core.first.call(null,seq19265__$1);
var seq19265__$2 = cljs.core.next.call(null,seq19265__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19266,G__19267,seq19265__$2);
});

/**
 * Delete a query that has previously been saved into the user's profile.
 */
imcljs.save.delete_query = (function imcljs$save$delete_query(var_args){
var args__4736__auto__ = [];
var len__4730__auto___19282 = arguments.length;
var i__4731__auto___19283 = (0);
while(true){
if((i__4731__auto___19283 < len__4730__auto___19282)){
args__4736__auto__.push((arguments[i__4731__auto___19283]));

var G__19284 = (i__4731__auto___19283 + (1));
i__4731__auto___19283 = G__19284;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.delete_query.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.delete_query.cljs$core$IFn$_invoke$arity$variadic = (function (service,title,p__19278){
var vec__19279 = p__19278;
var options = cljs.core.nth.call(null,vec__19279,(0),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),title], null),options);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/user/queries",service,params);
});

imcljs.save.delete_query.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.delete_query.cljs$lang$applyTo = (function (seq19275){
var G__19276 = cljs.core.first.call(null,seq19275);
var seq19275__$1 = cljs.core.next.call(null,seq19275);
var G__19277 = cljs.core.first.call(null,seq19275__$1);
var seq19275__$2 = cljs.core.next.call(null,seq19275__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19276,G__19277,seq19275__$2);
});

/**
 * Add a new key to the BlueGenes-specific config for a mine.
 *   Requires that you are authenticated as an admin.
 */
imcljs.save.bluegenes_properties = (function imcljs$save$bluegenes_properties(var_args){
var args__4736__auto__ = [];
var len__4730__auto___19293 = arguments.length;
var i__4731__auto___19294 = (0);
while(true){
if((i__4731__auto___19294 < len__4730__auto___19293)){
args__4736__auto__.push((arguments[i__4731__auto___19294]));

var G__19295 = (i__4731__auto___19294 + (1));
i__4731__auto___19294 = G__19295;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.bluegenes_properties.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.bluegenes_properties.cljs$core$IFn$_invoke$arity$variadic = (function (service,key,value,p__19289){
var vec__19290 = p__19289;
var options = cljs.core.nth.call(null,vec__19290,(0),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),key,new cljs.core.Keyword(null,"value","value",305978217),value], null),options);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/bluegenes-properties",service,params);
});

imcljs.save.bluegenes_properties.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.bluegenes_properties.cljs$lang$applyTo = (function (seq19285){
var G__19286 = cljs.core.first.call(null,seq19285);
var seq19285__$1 = cljs.core.next.call(null,seq19285);
var G__19287 = cljs.core.first.call(null,seq19285__$1);
var seq19285__$2 = cljs.core.next.call(null,seq19285__$1);
var G__19288 = cljs.core.first.call(null,seq19285__$2);
var seq19285__$3 = cljs.core.next.call(null,seq19285__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19286,G__19287,G__19288,seq19285__$3);
});

/**
 * Update an existing key in the BlueGenes-specific config for a mine.
 *   Requires that you are authenticated as an admin.
 */
imcljs.save.update_bluegenes_properties = (function imcljs$save$update_bluegenes_properties(var_args){
var args__4736__auto__ = [];
var len__4730__auto___19304 = arguments.length;
var i__4731__auto___19305 = (0);
while(true){
if((i__4731__auto___19305 < len__4730__auto___19304)){
args__4736__auto__.push((arguments[i__4731__auto___19305]));

var G__19306 = (i__4731__auto___19305 + (1));
i__4731__auto___19305 = G__19306;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.update_bluegenes_properties.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.update_bluegenes_properties.cljs$core$IFn$_invoke$arity$variadic = (function (service,key,value,p__19300){
var vec__19301 = p__19300;
var options = cljs.core.nth.call(null,vec__19301,(0),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),key,new cljs.core.Keyword(null,"value","value",305978217),value], null),options);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"put","put",1299772570),"/bluegenes-properties",service,params);
});

imcljs.save.update_bluegenes_properties.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.update_bluegenes_properties.cljs$lang$applyTo = (function (seq19296){
var G__19297 = cljs.core.first.call(null,seq19296);
var seq19296__$1 = cljs.core.next.call(null,seq19296);
var G__19298 = cljs.core.first.call(null,seq19296__$1);
var seq19296__$2 = cljs.core.next.call(null,seq19296__$1);
var G__19299 = cljs.core.first.call(null,seq19296__$2);
var seq19296__$3 = cljs.core.next.call(null,seq19296__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19297,G__19298,G__19299,seq19296__$3);
});

/**
 * Delete an existing key in the BlueGenes-specific config for a mine.
 *   Requires that you are authenticated as an admin.
 */
imcljs.save.delete_bluegenes_properties = (function imcljs$save$delete_bluegenes_properties(var_args){
var args__4736__auto__ = [];
var len__4730__auto___19314 = arguments.length;
var i__4731__auto___19315 = (0);
while(true){
if((i__4731__auto___19315 < len__4730__auto___19314)){
args__4736__auto__.push((arguments[i__4731__auto___19315]));

var G__19316 = (i__4731__auto___19315 + (1));
i__4731__auto___19315 = G__19316;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.delete_bluegenes_properties.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.delete_bluegenes_properties.cljs$core$IFn$_invoke$arity$variadic = (function (service,key,p__19310){
var vec__19311 = p__19310;
var options = cljs.core.nth.call(null,vec__19311,(0),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),key], null),options);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/bluegenes-properties",service,params);
});

imcljs.save.delete_bluegenes_properties.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.delete_bluegenes_properties.cljs$lang$applyTo = (function (seq19307){
var G__19308 = cljs.core.first.call(null,seq19307);
var seq19307__$1 = cljs.core.next.call(null,seq19307);
var G__19309 = cljs.core.first.call(null,seq19307__$1);
var seq19307__$2 = cljs.core.next.call(null,seq19307__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19308,G__19309,seq19307__$2);
});


//# sourceMappingURL=save.js.map
