// Compiled by ClojureScript 1.10.520 {}
goog.provide('imcljs.auth');
goog.require('cljs.core');
goog.require('imcljs.internal.io');
goog.require('cljs.core.async');
/**
 * Given a username and a password return an API token
 */
imcljs.auth.basic_auth = (function imcljs$auth$basic_auth(service,username,password){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"raw","raw",1604651272),new cljs.core.Keyword(null,"get","get",1683182755),"/user/tokens?type=api",service,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222),false,new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"password","password",417022471),password], null)], null),cljs.core.comp.call(null,new cljs.core.Keyword(null,"token","token",-1211463215),cljs.core.first,new cljs.core.Keyword(null,"tokens","tokens",-818939304)));
});
/**
 * Login the user using their username and password. Returns their new API token.
 *   If :token is present in `service`, it will get added to the Authorization header
 *   so that the anonymously saved lists gets merged into the users account.
 */
imcljs.auth.login = (function imcljs$auth$login(service,username,password){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/login",service,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"password","password",417022471),password], null));
});
/**
 * Logout the authenticated user, invalidating the token provided in their
 *   Authorization header.
 */
imcljs.auth.logout = (function imcljs$auth$logout(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/logout",service,cljs.core.PersistentArrayMap.EMPTY);
});
/**
 * Given a token return user information
 */
imcljs.auth.who_am_i_QMARK_ = (function imcljs$auth$who_am_i_QMARK_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___2721 = arguments.length;
var i__4731__auto___2722 = (0);
while(true){
if((i__4731__auto___2722 < len__4730__auto___2721)){
args__4736__auto__.push((arguments[i__4731__auto___2722]));

var G__2723 = (i__4731__auto___2722 + (1));
i__4731__auto___2722 = G__2723;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.auth.who_am_i_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.auth.who_am_i_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (service,token,p__2717){
var vec__2718 = p__2717;
var options = cljs.core.nth.call(null,vec__2718,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/user/whoami",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"token","token",-1211463215),token], null),options),new cljs.core.Keyword(null,"user","user",1532431356));
});

imcljs.auth.who_am_i_QMARK_.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.auth.who_am_i_QMARK_.cljs$lang$applyTo = (function (seq2714){
var G__2715 = cljs.core.first.call(null,seq2714);
var seq2714__$1 = cljs.core.next.call(null,seq2714);
var G__2716 = cljs.core.first.call(null,seq2714__$1);
var seq2714__$2 = cljs.core.next.call(null,seq2714__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2715,G__2716,seq2714__$2);
});

/**
 * Changes the password of an authenticated user.
 */
imcljs.auth.change_password = (function imcljs$auth$change_password(service,old_password,new_password){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/user",service,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"oldPassword","oldPassword",1953853561),old_password,new cljs.core.Keyword(null,"newPassword","newPassword",98419003),new_password], null));
});
/**
 * Register a new user account.
 */
imcljs.auth.register = (function imcljs$auth$register(var_args){
var args__4736__auto__ = [];
var len__4730__auto___2732 = arguments.length;
var i__4731__auto___2733 = (0);
while(true){
if((i__4731__auto___2733 < len__4730__auto___2732)){
args__4736__auto__.push((arguments[i__4731__auto___2733]));

var G__2734 = (i__4731__auto___2733 + (1));
i__4731__auto___2733 = G__2734;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.auth.register.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.auth.register.cljs$core$IFn$_invoke$arity$variadic = (function (service,username,password,p__2728){
var vec__2729 = p__2728;
var options = cljs.core.nth.call(null,vec__2729,(0),null);
var params = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),username,new cljs.core.Keyword(null,"password","password",417022471),password], null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/users",service,cljs.core.merge.call(null,params,options),new cljs.core.Keyword(null,"user","user",1532431356));
});

imcljs.auth.register.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.auth.register.cljs$lang$applyTo = (function (seq2724){
var G__2725 = cljs.core.first.call(null,seq2724);
var seq2724__$1 = cljs.core.next.call(null,seq2724);
var G__2726 = cljs.core.first.call(null,seq2724__$1);
var seq2724__$2 = cljs.core.next.call(null,seq2724__$1);
var G__2727 = cljs.core.first.call(null,seq2724__$2);
var seq2724__$3 = cljs.core.next.call(null,seq2724__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2725,G__2726,G__2727,seq2724__$3);
});

/**
 * Creates a deregistration token which is to be passed to `delete-account`.
 */
imcljs.auth.deregistration = (function imcljs$auth$deregistration(var_args){
var args__4736__auto__ = [];
var len__4730__auto___2741 = arguments.length;
var i__4731__auto___2742 = (0);
while(true){
if((i__4731__auto___2742 < len__4730__auto___2741)){
args__4736__auto__.push((arguments[i__4731__auto___2742]));

var G__2743 = (i__4731__auto___2742 + (1));
i__4731__auto___2742 = G__2743;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.auth.deregistration.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.auth.deregistration.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__2737){
var vec__2738 = p__2737;
var options = cljs.core.nth.call(null,vec__2738,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/user/deregistration",service,options,new cljs.core.Keyword(null,"token","token",-1211463215));
});

imcljs.auth.deregistration.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.auth.deregistration.cljs$lang$applyTo = (function (seq2735){
var G__2736 = cljs.core.first.call(null,seq2735);
var seq2735__$1 = cljs.core.next.call(null,seq2735);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2736,seq2735__$1);
});

/**
 * Takes a `deregistration` token to delete the authenticated user.
 */
imcljs.auth.delete_account = (function imcljs$auth$delete_account(var_args){
var args__4736__auto__ = [];
var len__4730__auto___2751 = arguments.length;
var i__4731__auto___2752 = (0);
while(true){
if((i__4731__auto___2752 < len__4730__auto___2751)){
args__4736__auto__.push((arguments[i__4731__auto___2752]));

var G__2753 = (i__4731__auto___2752 + (1));
i__4731__auto___2752 = G__2753;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.auth.delete_account.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.auth.delete_account.cljs$core$IFn$_invoke$arity$variadic = (function (service,deregistration_token,p__2747){
var vec__2748 = p__2747;
var options = cljs.core.nth.call(null,vec__2748,(0),null);
var params = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"deregistrationToken","deregistrationToken",987569265),deregistration_token], null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/user",service,cljs.core.merge.call(null,params,options));
});

imcljs.auth.delete_account.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.auth.delete_account.cljs$lang$applyTo = (function (seq2744){
var G__2745 = cljs.core.first.call(null,seq2744);
var seq2744__$1 = cljs.core.next.call(null,seq2744);
var G__2746 = cljs.core.first.call(null,seq2744__$1);
var seq2744__$2 = cljs.core.next.call(null,seq2744__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2745,G__2746,seq2744__$2);
});

/**
 * Create a new token. See web service documentation for more info.
 */
imcljs.auth.create_token = (function imcljs$auth$create_token(var_args){
var args__4736__auto__ = [];
var len__4730__auto___2761 = arguments.length;
var i__4731__auto___2762 = (0);
while(true){
if((i__4731__auto___2762 < len__4730__auto___2761)){
args__4736__auto__.push((arguments[i__4731__auto___2762]));

var G__2763 = (i__4731__auto___2762 + (1));
i__4731__auto___2762 = G__2763;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.auth.create_token.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.auth.create_token.cljs$core$IFn$_invoke$arity$variadic = (function (service,type,p__2757){
var vec__2758 = p__2757;
var options = cljs.core.nth.call(null,vec__2758,(0),null);
var params = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),type], null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/user/tokens",service,cljs.core.merge.call(null,params,options),new cljs.core.Keyword(null,"token","token",-1211463215));
});

imcljs.auth.create_token.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.auth.create_token.cljs$lang$applyTo = (function (seq2754){
var G__2755 = cljs.core.first.call(null,seq2754);
var seq2754__$1 = cljs.core.next.call(null,seq2754);
var G__2756 = cljs.core.first.call(null,seq2754__$1);
var seq2754__$2 = cljs.core.next.call(null,seq2754__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2755,G__2756,seq2754__$2);
});

/**
 * Commence authentication for logging in using OAuth 2.0 with specified
 *   provider.  Will return a URL to redirect to the external login page.
 *   Remember to append a `redirect_uri` parameter to the URL before redirecting.
 *   This should be an endpoint which will be redirected to after signing in at
 *   the third-party, passing parameters required for the `oauth2callback`.
 *   Note that the redirect URL might be checked against a whitelist.
 */
imcljs.auth.oauth2authenticator = (function imcljs$auth$oauth2authenticator(var_args){
var args__4736__auto__ = [];
var len__4730__auto___2771 = arguments.length;
var i__4731__auto___2772 = (0);
while(true){
if((i__4731__auto___2772 < len__4730__auto___2771)){
args__4736__auto__.push((arguments[i__4731__auto___2772]));

var G__2773 = (i__4731__auto___2772 + (1));
i__4731__auto___2772 = G__2773;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.auth.oauth2authenticator.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.auth.oauth2authenticator.cljs$core$IFn$_invoke$arity$variadic = (function (service,provider,p__2767){
var vec__2768 = p__2767;
var options = cljs.core.nth.call(null,vec__2768,(0),null);
var params = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"provider","provider",-302056900),provider], null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/oauth2authenticator",service,cljs.core.merge.call(null,params,options),new cljs.core.Keyword(null,"link","link",-1769163468));
});

imcljs.auth.oauth2authenticator.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.auth.oauth2authenticator.cljs$lang$applyTo = (function (seq2764){
var G__2765 = cljs.core.first.call(null,seq2764);
var seq2764__$1 = cljs.core.next.call(null,seq2764);
var G__2766 = cljs.core.first.call(null,seq2764__$1);
var seq2764__$2 = cljs.core.next.call(null,seq2764__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2765,G__2766,seq2764__$2);
});

/**
 * Complete authentication for logging in using OAuth 2.0. Requires parameters
 *   state and code, which are received when redirecting back from the external
 *   login service in `oauth2authenticator`, in addition to provider which should
 *   be identical to the one passed to `oauth2authenticator`.
 */
imcljs.auth.oauth2callback = (function imcljs$auth$oauth2callback(var_args){
var args__4736__auto__ = [];
var len__4730__auto___2780 = arguments.length;
var i__4731__auto___2781 = (0);
while(true){
if((i__4731__auto___2781 < len__4730__auto___2780)){
args__4736__auto__.push((arguments[i__4731__auto___2781]));

var G__2782 = (i__4731__auto___2781 + (1));
i__4731__auto___2781 = G__2782;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.auth.oauth2callback.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.auth.oauth2callback.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__2776){
var vec__2777 = p__2776;
var options = cljs.core.nth.call(null,vec__2777,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/oauth2callback",service,options);
});

imcljs.auth.oauth2callback.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.auth.oauth2callback.cljs$lang$applyTo = (function (seq2774){
var G__2775 = cljs.core.first.call(null,seq2774);
var seq2774__$1 = cljs.core.next.call(null,seq2774);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2775,seq2774__$1);
});

/**
 * Sends a password reset email to the user containing a specified redirectUrl
 *   with a token appended as a query string.
 */
imcljs.auth.request_password_reset = (function imcljs$auth$request_password_reset(var_args){
var args__4736__auto__ = [];
var len__4730__auto___2791 = arguments.length;
var i__4731__auto___2792 = (0);
while(true){
if((i__4731__auto___2792 < len__4730__auto___2791)){
args__4736__auto__.push((arguments[i__4731__auto___2792]));

var G__2793 = (i__4731__auto___2792 + (1));
i__4731__auto___2792 = G__2793;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.auth.request_password_reset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.auth.request_password_reset.cljs$core$IFn$_invoke$arity$variadic = (function (service,email,redirectUrl,p__2787){
var vec__2788 = p__2787;
var options = cljs.core.nth.call(null,vec__2788,(0),null);
var params = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"email","email",1415816706),email,new cljs.core.Keyword(null,"redirectUrl","redirectUrl",-823646950),redirectUrl], null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/user/requestpswreset",service,cljs.core.merge.call(null,params,options));
});

imcljs.auth.request_password_reset.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.auth.request_password_reset.cljs$lang$applyTo = (function (seq2783){
var G__2784 = cljs.core.first.call(null,seq2783);
var seq2783__$1 = cljs.core.next.call(null,seq2783);
var G__2785 = cljs.core.first.call(null,seq2783__$1);
var seq2783__$2 = cljs.core.next.call(null,seq2783__$1);
var G__2786 = cljs.core.first.call(null,seq2783__$2);
var seq2783__$3 = cljs.core.next.call(null,seq2783__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2784,G__2785,G__2786,seq2783__$3);
});

/**
 * Reset the user's password using the token received from
 *   `request-password-reset` and newPassword.
 */
imcljs.auth.password_reset = (function imcljs$auth$password_reset(var_args){
var args__4736__auto__ = [];
var len__4730__auto___2802 = arguments.length;
var i__4731__auto___2803 = (0);
while(true){
if((i__4731__auto___2803 < len__4730__auto___2802)){
args__4736__auto__.push((arguments[i__4731__auto___2803]));

var G__2804 = (i__4731__auto___2803 + (1));
i__4731__auto___2803 = G__2804;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.auth.password_reset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.auth.password_reset.cljs$core$IFn$_invoke$arity$variadic = (function (service,newPassword,pswResetToken,p__2798){
var vec__2799 = p__2798;
var options = cljs.core.nth.call(null,vec__2799,(0),null);
var params = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"newPassword","newPassword",98419003),newPassword,new cljs.core.Keyword(null,"pswResetToken","pswResetToken",1467882569),pswResetToken], null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"put","put",1299772570),"/user/pswreset",service,cljs.core.merge.call(null,params,options));
});

imcljs.auth.password_reset.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.auth.password_reset.cljs$lang$applyTo = (function (seq2794){
var G__2795 = cljs.core.first.call(null,seq2794);
var seq2794__$1 = cljs.core.next.call(null,seq2794);
var G__2796 = cljs.core.first.call(null,seq2794__$1);
var seq2794__$2 = cljs.core.next.call(null,seq2794__$1);
var G__2797 = cljs.core.first.call(null,seq2794__$2);
var seq2794__$3 = cljs.core.next.call(null,seq2794__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2795,G__2796,G__2797,seq2794__$3);
});


//# sourceMappingURL=auth.js.map
