// Compiled by ClojureScript 1.10.520 {}
goog.provide('imcljs.fetch');
goog.require('cljs.core');
goog.require('imcljs.internal.io');
goog.require('imcljs.query');
goog.require('clojure.string');
goog.require('cljs.core.async');
/**
 * Returns quicksearch results.
 */
imcljs.fetch.quicksearch = (function imcljs$fetch$quicksearch(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3118 = arguments.length;
var i__4731__auto___3119 = (0);
while(true){
if((i__4731__auto___3119 < len__4730__auto___3118)){
args__4736__auto__.push((arguments[i__4731__auto___3119]));

var G__3120 = (i__4731__auto___3119 + (1));
i__4731__auto___3119 = G__3120;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.quicksearch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.quicksearch.cljs$core$IFn$_invoke$arity$variadic = (function (service,search_term,p__3114){
var vec__3115 = p__3114;
var options = cljs.core.nth.call(null,vec__3115,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/search",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"q","q",689001697),search_term], null),options));
});

imcljs.fetch.quicksearch.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.quicksearch.cljs$lang$applyTo = (function (seq3111){
var G__3112 = cljs.core.first.call(null,seq3111);
var seq3111__$1 = cljs.core.next.call(null,seq3111);
var G__3113 = cljs.core.first.call(null,seq3111__$1);
var seq3111__$2 = cljs.core.next.call(null,seq3111__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3112,G__3113,seq3111__$2);
});

imcljs.fetch.table_rows = (function imcljs$fetch$table_rows(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3128 = arguments.length;
var i__4731__auto___3129 = (0);
while(true){
if((i__4731__auto___3129 < len__4730__auto___3128)){
args__4736__auto__.push((arguments[i__4731__auto___3129]));

var G__3130 = (i__4731__auto___3129 + (1));
i__4731__auto___3129 = G__3130;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.table_rows.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.table_rows.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__3124){
var vec__3125 = p__3124;
var options = cljs.core.nth.call(null,vec__3125,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results/tablerows",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query","query",-1288509510),query], null),options));
});

imcljs.fetch.table_rows.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.table_rows.cljs$lang$applyTo = (function (seq3121){
var G__3122 = cljs.core.first.call(null,seq3121);
var seq3121__$1 = cljs.core.next.call(null,seq3121);
var G__3123 = cljs.core.first.call(null,seq3121__$1);
var seq3121__$2 = cljs.core.next.call(null,seq3121__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3122,G__3123,seq3121__$2);
});

imcljs.fetch.fasta = (function imcljs$fetch$fasta(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3138 = arguments.length;
var i__4731__auto___3139 = (0);
while(true){
if((i__4731__auto___3139 < len__4730__auto___3138)){
args__4736__auto__.push((arguments[i__4731__auto___3139]));

var G__3140 = (i__4731__auto___3139 + (1));
i__4731__auto___3139 = G__3140;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.fasta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.fasta.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__3134){
var vec__3135 = p__3134;
var options = cljs.core.nth.call(null,vec__3135,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results/fasta",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query","query",-1288509510),query], null),options));
});

imcljs.fetch.fasta.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.fasta.cljs$lang$applyTo = (function (seq3131){
var G__3132 = cljs.core.first.call(null,seq3131);
var seq3131__$1 = cljs.core.next.call(null,seq3131);
var G__3133 = cljs.core.first.call(null,seq3131__$1);
var seq3131__$2 = cljs.core.next.call(null,seq3131__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3132,G__3133,seq3131__$2);
});

imcljs.fetch.fetch_custom_format = (function imcljs$fetch$fetch_custom_format(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3148 = arguments.length;
var i__4731__auto___3149 = (0);
while(true){
if((i__4731__auto___3149 < len__4730__auto___3148)){
args__4736__auto__.push((arguments[i__4731__auto___3149]));

var G__3150 = (i__4731__auto___3149 + (1));
i__4731__auto___3149 = G__3150;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.fetch_custom_format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.fetch_custom_format.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__3144){
var vec__3145 = p__3144;
var options = cljs.core.nth.call(null,vec__3145,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query","query",-1288509510),query], null),options));
});

imcljs.fetch.fetch_custom_format.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.fetch_custom_format.cljs$lang$applyTo = (function (seq3141){
var G__3142 = cljs.core.first.call(null,seq3141);
var seq3141__$1 = cljs.core.next.call(null,seq3141);
var G__3143 = cljs.core.first.call(null,seq3141__$1);
var seq3141__$2 = cljs.core.next.call(null,seq3141__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3142,G__3143,seq3141__$2);
});

imcljs.fetch.records = (function imcljs$fetch$records(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3158 = arguments.length;
var i__4731__auto___3159 = (0);
while(true){
if((i__4731__auto___3159 < len__4730__auto___3158)){
args__4736__auto__.push((arguments[i__4731__auto___3159]));

var G__3160 = (i__4731__auto___3159 + (1));
i__4731__auto___3159 = G__3160;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.records.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.records.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__3154){
var vec__3155 = p__3154;
var options = cljs.core.nth.call(null,vec__3155,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"jsonobjects"], null),options));
});

imcljs.fetch.records.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.records.cljs$lang$applyTo = (function (seq3151){
var G__3152 = cljs.core.first.call(null,seq3151);
var seq3151__$1 = cljs.core.next.call(null,seq3151);
var G__3153 = cljs.core.first.call(null,seq3151__$1);
var seq3151__$2 = cljs.core.next.call(null,seq3151__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3152,G__3153,seq3151__$2);
});

imcljs.fetch.rows = (function imcljs$fetch$rows(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3168 = arguments.length;
var i__4731__auto___3169 = (0);
while(true){
if((i__4731__auto___3169 < len__4730__auto___3168)){
args__4736__auto__.push((arguments[i__4731__auto___3169]));

var G__3170 = (i__4731__auto___3169 + (1));
i__4731__auto___3169 = G__3170;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.rows.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.rows.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__3164){
var vec__3165 = p__3164;
var options = cljs.core.nth.call(null,vec__3165,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.fetch.rows.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.rows.cljs$lang$applyTo = (function (seq3161){
var G__3162 = cljs.core.first.call(null,seq3161);
var seq3161__$1 = cljs.core.next.call(null,seq3161);
var G__3163 = cljs.core.first.call(null,seq3161__$1);
var seq3161__$2 = cljs.core.next.call(null,seq3161__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3162,G__3163,seq3161__$2);
});

imcljs.fetch.row_count = (function imcljs$fetch$row_count(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3178 = arguments.length;
var i__4731__auto___3179 = (0);
while(true){
if((i__4731__auto___3179 < len__4730__auto___3178)){
args__4736__auto__.push((arguments[i__4731__auto___3179]));

var G__3180 = (i__4731__auto___3179 + (1));
i__4731__auto___3179 = G__3180;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.row_count.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.row_count.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__3174){
var vec__3175 = p__3174;
var options = cljs.core.nth.call(null,vec__3175,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"count"], null),options));
});

imcljs.fetch.row_count.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.row_count.cljs$lang$applyTo = (function (seq3171){
var G__3172 = cljs.core.first.call(null,seq3171);
var seq3171__$1 = cljs.core.next.call(null,seq3171);
var G__3173 = cljs.core.first.call(null,seq3171__$1);
var seq3171__$2 = cljs.core.next.call(null,seq3171__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3172,G__3173,seq3171__$2);
});

imcljs.fetch.possible_values = (function imcljs$fetch$possible_values(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3188 = arguments.length;
var i__4731__auto___3189 = (0);
while(true){
if((i__4731__auto___3189 < len__4730__auto___3188)){
args__4736__auto__.push((arguments[i__4731__auto___3189]));

var G__3190 = (i__4731__auto___3189 + (1));
i__4731__auto___3189 = G__3190;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.possible_values.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.possible_values.cljs$core$IFn$_invoke$arity$variadic = (function (service,path,p__3184){
var vec__3185 = p__3184;
var options = cljs.core.nth.call(null,vec__3185,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/path/values",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),path,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.fetch.possible_values.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.possible_values.cljs$lang$applyTo = (function (seq3181){
var G__3182 = cljs.core.first.call(null,seq3181);
var seq3181__$1 = cljs.core.next.call(null,seq3181);
var G__3183 = cljs.core.first.call(null,seq3181__$1);
var seq3181__$2 = cljs.core.next.call(null,seq3181__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3182,G__3183,seq3181__$2);
});

/**
 * Fetches unique values for a path within a query. Providing a limit shortcircuits the request
 *   and returns false if the unique values exceed the limit. This is primarily for the column
 *   summary in im-tables-3, where we don't want to summarize columns with more than limit=1000
 *   values, so we avoid sending the massive request here instead.
 */
imcljs.fetch.unique_values = (function imcljs$fetch$unique_values(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3284 = arguments.length;
var i__4731__auto___3285 = (0);
while(true){
if((i__4731__auto___3285 < len__4730__auto___3284)){
args__4736__auto__.push((arguments[i__4731__auto___3285]));

var G__3286 = (i__4731__auto___3285 + (1));
i__4731__auto___3285 = G__3286;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.fetch.unique_values.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.fetch.unique_values.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,path,p__3196){
var vec__3197 = p__3196;
var limit = cljs.core.nth.call(null,vec__3197,(0),null);
var return_chan = cljs.core.async.chan.call(null);
var rows_size = ((function (return_chan,vec__3197,limit){
return (function (p1__3191_SHARP_){
return imcljs.fetch.rows.call(null,service,query,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"summaryPath","summaryPath",599411983),path,new cljs.core.Keyword(null,"size","size",1098693007),p1__3191_SHARP_,new cljs.core.Keyword(null,"format","format",-1306924766),"jsonrows"], null));
});})(return_chan,vec__3197,limit))
;
var c__2324__auto___3287 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2324__auto___3287,return_chan,rows_size,vec__3197,limit){
return (function (){
var f__2325__auto__ = (function (){var switch__2301__auto__ = ((function (c__2324__auto___3287,return_chan,rows_size,vec__3197,limit){
return (function (state_3252){
var state_val_3253 = (state_3252[(1)]);
if((state_val_3253 === (7))){
var state_3252__$1 = state_3252;
var statearr_3254_3288 = state_3252__$1;
(statearr_3254_3288[(2)] = false);

(statearr_3254_3288[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3253 === (20))){
var inst_3237 = (state_3252[(2)]);
var state_3252__$1 = state_3252;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3252__$1,(19),return_chan,inst_3237);
} else {
if((state_val_3253 === (1))){
var inst_3201 = rows_size.call(null,(1));
var state_3252__$1 = state_3252;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3252__$1,(2),inst_3201);
} else {
if((state_val_3253 === (24))){
var inst_3243 = (state_3252[(2)]);
var state_3252__$1 = state_3252;
var statearr_3255_3289 = state_3252__$1;
(statearr_3255_3289[(2)] = inst_3243);

(statearr_3255_3289[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3253 === (4))){
var state_3252__$1 = state_3252;
var statearr_3256_3290 = state_3252__$1;
(statearr_3256_3290[(2)] = false);

(statearr_3256_3290[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3253 === (15))){
var inst_3229 = (state_3252[(2)]);
var state_3252__$1 = state_3252;
var statearr_3257_3291 = state_3252__$1;
(statearr_3257_3291[(2)] = inst_3229);

(statearr_3257_3291[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3253 === (21))){
var state_3252__$1 = state_3252;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3252__$1,(24),return_chan,false);
} else {
if((state_val_3253 === (13))){
var inst_3225 = (state_3252[(7)]);
var inst_3231 = cljs.core.not.call(null,limit);
var inst_3232 = (inst_3225 <= limit);
var inst_3233 = ((inst_3231) || (inst_3232));
var state_3252__$1 = state_3252;
if(cljs.core.truth_(inst_3233)){
var statearr_3258_3292 = state_3252__$1;
(statearr_3258_3292[(1)] = (16));

} else {
var statearr_3259_3293 = state_3252__$1;
(statearr_3259_3293[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3253 === (22))){
var state_3252__$1 = state_3252;
var statearr_3260_3294 = state_3252__$1;
(statearr_3260_3294[(2)] = null);

(statearr_3260_3294[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3253 === (6))){
var state_3252__$1 = state_3252;
var statearr_3261_3295 = state_3252__$1;
(statearr_3261_3295[(2)] = true);

(statearr_3261_3295[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3253 === (17))){
var state_3252__$1 = state_3252;
var statearr_3262_3296 = state_3252__$1;
(statearr_3262_3296[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3253 === (3))){
var inst_3203 = (state_3252[(8)]);
var inst_3208 = inst_3203.cljs$lang$protocol_mask$partition0$;
var inst_3209 = (inst_3208 & (64));
var inst_3210 = inst_3203.cljs$core$ISeq$;
var inst_3211 = (cljs.core.PROTOCOL_SENTINEL === inst_3210);
var inst_3212 = ((inst_3209) || (inst_3211));
var state_3252__$1 = state_3252;
if(cljs.core.truth_(inst_3212)){
var statearr_3264_3297 = state_3252__$1;
(statearr_3264_3297[(1)] = (6));

} else {
var statearr_3265_3298 = state_3252__$1;
(statearr_3265_3298[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3253 === (12))){
var inst_3224 = (state_3252[(9)]);
var state_3252__$1 = state_3252;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3252__$1,(15),return_chan,inst_3224);
} else {
if((state_val_3253 === (2))){
var inst_3203 = (state_3252[(8)]);
var inst_3203__$1 = (state_3252[(2)]);
var inst_3205 = (inst_3203__$1 == null);
var inst_3206 = cljs.core.not.call(null,inst_3205);
var state_3252__$1 = (function (){var statearr_3266 = state_3252;
(statearr_3266[(8)] = inst_3203__$1);

return statearr_3266;
})();
if(inst_3206){
var statearr_3267_3299 = state_3252__$1;
(statearr_3267_3299[(1)] = (3));

} else {
var statearr_3268_3300 = state_3252__$1;
(statearr_3268_3300[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3253 === (23))){
var inst_3246 = (state_3252[(2)]);
var state_3252__$1 = state_3252;
var statearr_3269_3301 = state_3252__$1;
(statearr_3269_3301[(2)] = inst_3246);

(statearr_3269_3301[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3253 === (19))){
var inst_3239 = (state_3252[(2)]);
var state_3252__$1 = state_3252;
var statearr_3270_3302 = state_3252__$1;
(statearr_3270_3302[(2)] = inst_3239);

(statearr_3270_3302[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3253 === (11))){
var inst_3225 = (state_3252[(7)]);
var inst_3224 = (state_3252[(9)]);
var inst_3224__$1 = (state_3252[(2)]);
var inst_3225__$1 = cljs.core.get.call(null,inst_3224__$1,new cljs.core.Keyword(null,"uniqueValues","uniqueValues",1661070646));
var inst_3226 = cljs.core._EQ_.call(null,inst_3225__$1,(1));
var state_3252__$1 = (function (){var statearr_3271 = state_3252;
(statearr_3271[(7)] = inst_3225__$1);

(statearr_3271[(9)] = inst_3224__$1);

return statearr_3271;
})();
if(inst_3226){
var statearr_3272_3303 = state_3252__$1;
(statearr_3272_3303[(1)] = (12));

} else {
var statearr_3273_3304 = state_3252__$1;
(statearr_3273_3304[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3253 === (9))){
var inst_3203 = (state_3252[(8)]);
var inst_3221 = cljs.core.apply.call(null,cljs.core.hash_map,inst_3203);
var state_3252__$1 = state_3252;
var statearr_3274_3305 = state_3252__$1;
(statearr_3274_3305[(2)] = inst_3221);

(statearr_3274_3305[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3253 === (5))){
var inst_3219 = (state_3252[(2)]);
var state_3252__$1 = state_3252;
if(cljs.core.truth_(inst_3219)){
var statearr_3275_3306 = state_3252__$1;
(statearr_3275_3306[(1)] = (9));

} else {
var statearr_3276_3307 = state_3252__$1;
(statearr_3276_3307[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3253 === (14))){
var inst_3250 = (state_3252[(2)]);
var state_3252__$1 = state_3252;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3252__$1,inst_3250);
} else {
if((state_val_3253 === (16))){
var inst_3235 = rows_size.call(null,limit);
var state_3252__$1 = state_3252;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3252__$1,(20),inst_3235);
} else {
if((state_val_3253 === (10))){
var inst_3203 = (state_3252[(8)]);
var state_3252__$1 = state_3252;
var statearr_3277_3308 = state_3252__$1;
(statearr_3277_3308[(2)] = inst_3203);

(statearr_3277_3308[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3253 === (18))){
var inst_3248 = (state_3252[(2)]);
var state_3252__$1 = state_3252;
var statearr_3278_3309 = state_3252__$1;
(statearr_3278_3309[(2)] = inst_3248);

(statearr_3278_3309[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3253 === (8))){
var inst_3216 = (state_3252[(2)]);
var state_3252__$1 = state_3252;
var statearr_3279_3310 = state_3252__$1;
(statearr_3279_3310[(2)] = inst_3216);

(statearr_3279_3310[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2324__auto___3287,return_chan,rows_size,vec__3197,limit))
;
return ((function (switch__2301__auto__,c__2324__auto___3287,return_chan,rows_size,vec__3197,limit){
return (function() {
var imcljs$fetch$state_machine__2302__auto__ = null;
var imcljs$fetch$state_machine__2302__auto____0 = (function (){
var statearr_3280 = [null,null,null,null,null,null,null,null,null,null];
(statearr_3280[(0)] = imcljs$fetch$state_machine__2302__auto__);

(statearr_3280[(1)] = (1));

return statearr_3280;
});
var imcljs$fetch$state_machine__2302__auto____1 = (function (state_3252){
while(true){
var ret_value__2303__auto__ = (function (){try{while(true){
var result__2304__auto__ = switch__2301__auto__.call(null,state_3252);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2304__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2304__auto__;
}
break;
}
}catch (e3281){if((e3281 instanceof Object)){
var ex__2305__auto__ = e3281;
var statearr_3282_3311 = state_3252;
(statearr_3282_3311[(5)] = ex__2305__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3252);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3281;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2303__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3312 = state_3252;
state_3252 = G__3312;
continue;
} else {
return ret_value__2303__auto__;
}
break;
}
});
imcljs$fetch$state_machine__2302__auto__ = function(state_3252){
switch(arguments.length){
case 0:
return imcljs$fetch$state_machine__2302__auto____0.call(this);
case 1:
return imcljs$fetch$state_machine__2302__auto____1.call(this,state_3252);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
imcljs$fetch$state_machine__2302__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$fetch$state_machine__2302__auto____0;
imcljs$fetch$state_machine__2302__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$fetch$state_machine__2302__auto____1;
return imcljs$fetch$state_machine__2302__auto__;
})()
;})(switch__2301__auto__,c__2324__auto___3287,return_chan,rows_size,vec__3197,limit))
})();
var state__2326__auto__ = (function (){var statearr_3283 = f__2325__auto__.call(null);
(statearr_3283[(6)] = c__2324__auto___3287);

return statearr_3283;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2326__auto__);
});})(c__2324__auto___3287,return_chan,rows_size,vec__3197,limit))
);


return return_chan;
});

imcljs.fetch.unique_values.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.fetch.unique_values.cljs$lang$applyTo = (function (seq3192){
var G__3193 = cljs.core.first.call(null,seq3192);
var seq3192__$1 = cljs.core.next.call(null,seq3192);
var G__3194 = cljs.core.first.call(null,seq3192__$1);
var seq3192__$2 = cljs.core.next.call(null,seq3192__$1);
var G__3195 = cljs.core.first.call(null,seq3192__$2);
var seq3192__$3 = cljs.core.next.call(null,seq3192__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3193,G__3194,G__3195,seq3192__$3);
});

/**
 * Fetches queries saved under the user. Use the `:filter` option to only
 *   return queries with the specified title, with optional `*` wildcards.
 */
imcljs.fetch.saved_queries = (function imcljs$fetch$saved_queries(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3319 = arguments.length;
var i__4731__auto___3320 = (0);
while(true){
if((i__4731__auto___3320 < len__4730__auto___3319)){
args__4736__auto__.push((arguments[i__4731__auto___3320]));

var G__3321 = (i__4731__auto___3320 + (1));
i__4731__auto___3320 = G__3321;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.saved_queries.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.saved_queries.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__3315){
var vec__3316 = p__3315;
var options = cljs.core.nth.call(null,vec__3316,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/user/queries",service,options,new cljs.core.Keyword(null,"queries","queries",1446291995));
});

imcljs.fetch.saved_queries.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.saved_queries.cljs$lang$applyTo = (function (seq3313){
var G__3314 = cljs.core.first.call(null,seq3313);
var seq3313__$1 = cljs.core.next.call(null,seq3313);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3314,seq3313__$1);
});

imcljs.fetch.lists = (function imcljs$fetch$lists(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3328 = arguments.length;
var i__4731__auto___3329 = (0);
while(true){
if((i__4731__auto___3329 < len__4730__auto___3328)){
args__4736__auto__.push((arguments[i__4731__auto___3329]));

var G__3330 = (i__4731__auto___3329 + (1));
i__4731__auto___3329 = G__3330;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.lists.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.lists.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__3324){
var vec__3325 = p__3324;
var options = cljs.core.nth.call(null,vec__3325,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/lists",service,options,new cljs.core.Keyword(null,"lists","lists",-884730684));
});

imcljs.fetch.lists.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.lists.cljs$lang$applyTo = (function (seq3322){
var G__3323 = cljs.core.first.call(null,seq3322);
var seq3322__$1 = cljs.core.next.call(null,seq3322);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3323,seq3322__$1);
});

imcljs.fetch.one_list = (function imcljs$fetch$one_list(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3338 = arguments.length;
var i__4731__auto___3339 = (0);
while(true){
if((i__4731__auto___3339 < len__4730__auto___3338)){
args__4736__auto__.push((arguments[i__4731__auto___3339]));

var G__3340 = (i__4731__auto___3339 + (1));
i__4731__auto___3339 = G__3340;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.one_list.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.one_list.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,p__3334){
var vec__3335 = p__3334;
var options = cljs.core.nth.call(null,vec__3335,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/lists",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),name], null),options),cljs.core.comp.call(null,cljs.core.first,new cljs.core.Keyword(null,"lists","lists",-884730684)));
});

imcljs.fetch.one_list.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.one_list.cljs$lang$applyTo = (function (seq3331){
var G__3332 = cljs.core.first.call(null,seq3331);
var seq3331__$1 = cljs.core.next.call(null,seq3331);
var G__3333 = cljs.core.first.call(null,seq3331__$1);
var seq3331__$2 = cljs.core.next.call(null,seq3331__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3332,G__3333,seq3331__$2);
});

/**
 * Find lists on the server containing an object.
 *   As a minimum, specify either :id or both of :publicId and :type.
 */
imcljs.fetch.lists_containing = (function imcljs$fetch$lists_containing(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3347 = arguments.length;
var i__4731__auto___3348 = (0);
while(true){
if((i__4731__auto___3348 < len__4730__auto___3347)){
args__4736__auto__.push((arguments[i__4731__auto___3348]));

var G__3349 = (i__4731__auto___3348 + (1));
i__4731__auto___3348 = G__3349;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.lists_containing.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.lists_containing.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__3343){
var vec__3344 = p__3343;
var options = cljs.core.nth.call(null,vec__3344,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/listswithobject",service,options,new cljs.core.Keyword(null,"lists","lists",-884730684));
});

imcljs.fetch.lists_containing.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.lists_containing.cljs$lang$applyTo = (function (seq3341){
var G__3342 = cljs.core.first.call(null,seq3341);
var seq3341__$1 = cljs.core.next.call(null,seq3341);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3342,seq3341__$1);
});

imcljs.fetch.external_links = (function imcljs$fetch$external_links(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3357 = arguments.length;
var i__4731__auto___3358 = (0);
while(true){
if((i__4731__auto___3358 < len__4730__auto___3357)){
args__4736__auto__.push((arguments[i__4731__auto___3358]));

var G__3359 = (i__4731__auto___3358 + (1));
i__4731__auto___3358 = G__3359;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.external_links.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.external_links.cljs$core$IFn$_invoke$arity$variadic = (function (service,object_id,p__3353){
var vec__3354 = p__3353;
var options = cljs.core.nth.call(null,vec__3354,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/elinks",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),object_id], null),options),new cljs.core.Keyword(null,"links","links",-654507394));
});

imcljs.fetch.external_links.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.external_links.cljs$lang$applyTo = (function (seq3350){
var G__3351 = cljs.core.first.call(null,seq3350);
var seq3350__$1 = cljs.core.next.call(null,seq3350);
var G__3352 = cljs.core.first.call(null,seq3350__$1);
var seq3350__$2 = cljs.core.next.call(null,seq3350__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3351,G__3352,seq3350__$2);
});

imcljs.fetch.model = (function imcljs$fetch$model(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3366 = arguments.length;
var i__4731__auto___3367 = (0);
while(true){
if((i__4731__auto___3367 < len__4730__auto___3366)){
args__4736__auto__.push((arguments[i__4731__auto___3367]));

var G__3368 = (i__4731__auto___3367 + (1));
i__4731__auto___3367 = G__3368;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.model.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.model.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__3362){
var vec__3363 = p__3362;
var options = cljs.core.nth.call(null,vec__3363,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/model",service,options,new cljs.core.Keyword(null,"model","model",331153215));
});

imcljs.fetch.model.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.model.cljs$lang$applyTo = (function (seq3360){
var G__3361 = cljs.core.first.call(null,seq3360);
var seq3360__$1 = cljs.core.next.call(null,seq3360);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3361,seq3360__$1);
});

imcljs.fetch.class_keys = (function imcljs$fetch$class_keys(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3375 = arguments.length;
var i__4731__auto___3376 = (0);
while(true){
if((i__4731__auto___3376 < len__4730__auto___3375)){
args__4736__auto__.push((arguments[i__4731__auto___3376]));

var G__3377 = (i__4731__auto___3376 + (1));
i__4731__auto___3376 = G__3377;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.class_keys.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.class_keys.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__3371){
var vec__3372 = p__3371;
var options = cljs.core.nth.call(null,vec__3372,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/classkeys",service,options,new cljs.core.Keyword(null,"classes","classes",2037804510));
});

imcljs.fetch.class_keys.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.class_keys.cljs$lang$applyTo = (function (seq3369){
var G__3370 = cljs.core.first.call(null,seq3369);
var seq3369__$1 = cljs.core.next.call(null,seq3369);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3370,seq3369__$1);
});

imcljs.fetch.summary_fields = (function imcljs$fetch$summary_fields(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3384 = arguments.length;
var i__4731__auto___3385 = (0);
while(true){
if((i__4731__auto___3385 < len__4730__auto___3384)){
args__4736__auto__.push((arguments[i__4731__auto___3385]));

var G__3386 = (i__4731__auto___3385 + (1));
i__4731__auto___3385 = G__3386;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.summary_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.summary_fields.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__3380){
var vec__3381 = p__3380;
var options = cljs.core.nth.call(null,vec__3381,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/summaryfields",service,options,new cljs.core.Keyword(null,"classes","classes",2037804510));
});

imcljs.fetch.summary_fields.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.summary_fields.cljs$lang$applyTo = (function (seq3378){
var G__3379 = cljs.core.first.call(null,seq3378);
var seq3378__$1 = cljs.core.next.call(null,seq3378);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3379,seq3378__$1);
});

imcljs.fetch.templates = (function imcljs$fetch$templates(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3393 = arguments.length;
var i__4731__auto___3394 = (0);
while(true){
if((i__4731__auto___3394 < len__4730__auto___3393)){
args__4736__auto__.push((arguments[i__4731__auto___3394]));

var G__3395 = (i__4731__auto___3394 + (1));
i__4731__auto___3394 = G__3395;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.templates.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.templates.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__3389){
var vec__3390 = p__3389;
var options = cljs.core.nth.call(null,vec__3390,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/templates",service,options,new cljs.core.Keyword(null,"templates","templates",-1237401733));
});

imcljs.fetch.templates.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.templates.cljs$lang$applyTo = (function (seq3387){
var G__3388 = cljs.core.first.call(null,seq3387);
var seq3387__$1 = cljs.core.next.call(null,seq3387);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3388,seq3387__$1);
});

/**
 * Returns a temporary API token.
 */
imcljs.fetch.session = (function imcljs$fetch$session(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3402 = arguments.length;
var i__4731__auto___3403 = (0);
while(true){
if((i__4731__auto___3403 < len__4730__auto___3402)){
args__4736__auto__.push((arguments[i__4731__auto___3403]));

var G__3404 = (i__4731__auto___3403 + (1));
i__4731__auto___3403 = G__3404;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.session.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.session.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__3398){
var vec__3399 = p__3398;
var options = cljs.core.nth.call(null,vec__3399,(0),null);
var token_free_service = cljs.core.dissoc.call(null,service,new cljs.core.Keyword(null,"token","token",-1211463215));
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/session",token_free_service,options,new cljs.core.Keyword(null,"token","token",-1211463215));
});

imcljs.fetch.session.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.session.cljs$lang$applyTo = (function (seq3396){
var G__3397 = cljs.core.first.call(null,seq3396);
var seq3396__$1 = cljs.core.next.call(null,seq3396);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3397,seq3396__$1);
});

/**
 * Returns list of widgets available for a given mine
 */
imcljs.fetch.widgets = (function imcljs$fetch$widgets(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3411 = arguments.length;
var i__4731__auto___3412 = (0);
while(true){
if((i__4731__auto___3412 < len__4730__auto___3411)){
args__4736__auto__.push((arguments[i__4731__auto___3412]));

var G__3413 = (i__4731__auto___3412 + (1));
i__4731__auto___3412 = G__3413;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.widgets.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.widgets.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__3407){
var vec__3408 = p__3407;
var options = cljs.core.nth.call(null,vec__3408,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/widgets",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),new cljs.core.Keyword(null,"widgets","widgets",-159098978));
});

imcljs.fetch.widgets.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.widgets.cljs$lang$applyTo = (function (seq3405){
var G__3406 = cljs.core.first.call(null,seq3405);
var seq3405__$1 = cljs.core.next.call(null,seq3405);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3406,seq3405__$1);
});

/**
 * Returns enrichment results
 */
imcljs.fetch.enrichment = (function imcljs$fetch$enrichment(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3420 = arguments.length;
var i__4731__auto___3421 = (0);
while(true){
if((i__4731__auto___3421 < len__4730__auto___3420)){
args__4736__auto__.push((arguments[i__4731__auto___3421]));

var G__3422 = (i__4731__auto___3421 + (1));
i__4731__auto___3421 = G__3422;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.enrichment.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.enrichment.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__3416){
var vec__3417 = p__3416;
var options = cljs.core.nth.call(null,vec__3417,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/list/enrichment",service,cljs.core.merge.call(null,imcljs.internal.defaults.default_enrichment,options));
});

imcljs.fetch.enrichment.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.enrichment.cljs$lang$applyTo = (function (seq3414){
var G__3415 = cljs.core.first.call(null,seq3414);
var seq3414__$1 = cljs.core.next.call(null,seq3414);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3415,seq3414__$1);
});

/**
 * Returns data to produce a graph for a list.
 *   Can be passed either a list name or a vector of object IDs.
 *   Note that `:type` has to be specified in `options` if passing object IDs.
 */
imcljs.fetch.chart_widget = (function imcljs$fetch$chart_widget(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3431 = arguments.length;
var i__4731__auto___3432 = (0);
while(true){
if((i__4731__auto___3432 < len__4730__auto___3431)){
args__4736__auto__.push((arguments[i__4731__auto___3432]));

var G__3433 = (i__4731__auto___3432 + (1));
i__4731__auto___3432 = G__3433;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.fetch.chart_widget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.fetch.chart_widget.cljs$core$IFn$_invoke$arity$variadic = (function (service,list_PLUS_ids,widget_name,p__3427){
var vec__3428 = p__3427;
var options = cljs.core.nth.call(null,vec__3428,(0),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"widget","widget",-853968943),widget_name], null),((cljs.core.sequential_QMARK_.call(null,list_PLUS_ids))?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ids","ids",-998535796),clojure.string.join.call(null,",",list_PLUS_ids)], null):new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"list","list",765357683),list_PLUS_ids], null)));
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/list/chart",service,cljs.core.merge.call(null,params,options));
});

imcljs.fetch.chart_widget.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.fetch.chart_widget.cljs$lang$applyTo = (function (seq3423){
var G__3424 = cljs.core.first.call(null,seq3423);
var seq3423__$1 = cljs.core.next.call(null,seq3423);
var G__3425 = cljs.core.first.call(null,seq3423__$1);
var seq3423__$2 = cljs.core.next.call(null,seq3423__$1);
var G__3426 = cljs.core.first.call(null,seq3423__$2);
var seq3423__$3 = cljs.core.next.call(null,seq3423__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3424,G__3425,G__3426,seq3423__$3);
});

/**
 * Returns data for displaying by a table widget.
 *   Can be passed either a list name or a vector of object IDs.
 *   Note that `:type` has to be specified in `options` if passing object IDs.
 */
imcljs.fetch.table_widget = (function imcljs$fetch$table_widget(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3442 = arguments.length;
var i__4731__auto___3443 = (0);
while(true){
if((i__4731__auto___3443 < len__4730__auto___3442)){
args__4736__auto__.push((arguments[i__4731__auto___3443]));

var G__3444 = (i__4731__auto___3443 + (1));
i__4731__auto___3443 = G__3444;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.fetch.table_widget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.fetch.table_widget.cljs$core$IFn$_invoke$arity$variadic = (function (service,list_PLUS_ids,widget_name,p__3438){
var vec__3439 = p__3438;
var options = cljs.core.nth.call(null,vec__3439,(0),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"widget","widget",-853968943),widget_name], null),((cljs.core.sequential_QMARK_.call(null,list_PLUS_ids))?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ids","ids",-998535796),clojure.string.join.call(null,",",list_PLUS_ids)], null):new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"list","list",765357683),list_PLUS_ids], null)));
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/list/table",service,cljs.core.merge.call(null,params,options));
});

imcljs.fetch.table_widget.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.fetch.table_widget.cljs$lang$applyTo = (function (seq3434){
var G__3435 = cljs.core.first.call(null,seq3434);
var seq3434__$1 = cljs.core.next.call(null,seq3434);
var G__3436 = cljs.core.first.call(null,seq3434__$1);
var seq3434__$2 = cljs.core.next.call(null,seq3434__$1);
var G__3437 = cljs.core.first.call(null,seq3434__$2);
var seq3434__$3 = cljs.core.next.call(null,seq3434__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3435,G__3436,G__3437,seq3434__$3);
});

/**
 * Returns the version of the InterMine WebService being run, e.g. '27'
 */
imcljs.fetch.version_web_service = (function imcljs$fetch$version_web_service(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/version",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"text"], null));
});
imcljs.fetch.version_release = (function imcljs$fetch$version_release(service){

return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/version/release",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"text"], null));
});
/**
 * Returns the version of InterMine being run, e.g. '1.6.6'
 */
imcljs.fetch.version_intermine = (function imcljs$fetch$version_intermine(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/version/intermine",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"text"], null));
});
/**
 * Returns the default configs for a given mine. These are important as they're
 * used to initialise most bluegenes page sections! 
 */
imcljs.fetch.web_properties = (function imcljs$fetch$web_properties(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/web-properties",service,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"web-properties","web-properties",-1421911737));
});
/**
 * Returns the branding details for a given mine.
 *   Used to make things more personal!
 */
imcljs.fetch.branding = (function imcljs$fetch$branding(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/branding",service,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"properties","properties",685819552));
});
/**
 * Returns the BlueGenes-specific configs for a given mine. These are created
 *   and maintained by BlueGenes, similarly to a key-value store.
 */
imcljs.fetch.bluegenes_properties = (function imcljs$fetch$bluegenes_properties(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3451 = arguments.length;
var i__4731__auto___3452 = (0);
while(true){
if((i__4731__auto___3452 < len__4730__auto___3451)){
args__4736__auto__.push((arguments[i__4731__auto___3452]));

var G__3453 = (i__4731__auto___3452 + (1));
i__4731__auto___3452 = G__3453;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.bluegenes_properties.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.bluegenes_properties.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__3447){
var vec__3448 = p__3447;
var options = cljs.core.nth.call(null,vec__3448,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/bluegenes-properties",service,options,new cljs.core.Keyword(null,"bluegenes-properties","bluegenes-properties",-1287321694));
});

imcljs.fetch.bluegenes_properties.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.bluegenes_properties.cljs$lang$applyTo = (function (seq3445){
var G__3446 = cljs.core.first.call(null,seq3445);
var seq3445__$1 = cljs.core.next.call(null,seq3445);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3446,seq3445__$1);
});

/**
 * Internal function to return whether options is a list resolution job.
 */
imcljs.fetch.list_resolution_job_QMARK_ = (function imcljs$fetch$list_resolution_job_QMARK_(options){
var and__4120__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(options);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"identifiers","identifiers",-2057597722).cljs$core$IFn$_invoke$arity$1(options));
} else {
return and__4120__auto__;
}
});
/**
 * Internal function to select the correct id resolution endpoint based on options.
 */
imcljs.fetch.id_resolution_endpoint = (function imcljs$fetch$id_resolution_endpoint(options){
if(cljs.core.truth_(imcljs.fetch.list_resolution_job_QMARK_.call(null,options))){
return "/listresolver";
} else {
return "/ids";
}
});
/**
 * Fetches the results of an id resolution job
 */
imcljs.fetch.fetch_id_resolution_job_results = (function imcljs$fetch$fetch_id_resolution_job_results(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3461 = arguments.length;
var i__4731__auto___3462 = (0);
while(true){
if((i__4731__auto___3462 < len__4730__auto___3461)){
args__4736__auto__.push((arguments[i__4731__auto___3462]));

var G__3463 = (i__4731__auto___3462 + (1));
i__4731__auto___3462 = G__3463;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.fetch_id_resolution_job_results.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.fetch_id_resolution_job_results.cljs$core$IFn$_invoke$arity$variadic = (function (service,uid,p__3457){
var vec__3458 = p__3457;
var options = cljs.core.nth.call(null,vec__3458,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),[imcljs.fetch.id_resolution_endpoint.call(null,options),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(uid),"/results"].join(''),service,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"results","results",-1134170113));
});

imcljs.fetch.fetch_id_resolution_job_results.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.fetch_id_resolution_job_results.cljs$lang$applyTo = (function (seq3454){
var G__3455 = cljs.core.first.call(null,seq3454);
var seq3454__$1 = cljs.core.next.call(null,seq3454);
var G__3456 = cljs.core.first.call(null,seq3454__$1);
var seq3454__$2 = cljs.core.next.call(null,seq3454__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3455,G__3456,seq3454__$2);
});

/**
 * Fetches the status of an id resolution job
 */
imcljs.fetch.fetch_id_resolution_job_status = (function imcljs$fetch$fetch_id_resolution_job_status(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3471 = arguments.length;
var i__4731__auto___3472 = (0);
while(true){
if((i__4731__auto___3472 < len__4730__auto___3471)){
args__4736__auto__.push((arguments[i__4731__auto___3472]));

var G__3473 = (i__4731__auto___3472 + (1));
i__4731__auto___3472 = G__3473;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.fetch_id_resolution_job_status.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.fetch_id_resolution_job_status.cljs$core$IFn$_invoke$arity$variadic = (function (service,uid,p__3467){
var vec__3468 = p__3467;
var options = cljs.core.nth.call(null,vec__3468,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),[imcljs.fetch.id_resolution_endpoint.call(null,options),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(uid),"/status"].join(''),service,cljs.core.PersistentArrayMap.EMPTY);
});

imcljs.fetch.fetch_id_resolution_job_status.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.fetch_id_resolution_job_status.cljs$lang$applyTo = (function (seq3464){
var G__3465 = cljs.core.first.call(null,seq3464);
var seq3464__$1 = cljs.core.next.call(null,seq3464);
var G__3466 = cljs.core.first.call(null,seq3464__$1);
var seq3464__$2 = cljs.core.next.call(null,seq3464__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3465,G__3466,seq3464__$2);
});

/**
 * Starts an id resolution job
 */
imcljs.fetch.fetch_id_resolution_job = (function imcljs$fetch$fetch_id_resolution_job(service,p__3474){
var map__3475 = p__3474;
var map__3475__$1 = (((((!((map__3475 == null))))?(((((map__3475.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3475.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3475):map__3475);
var options = map__3475__$1;
var identifiers = cljs.core.get.call(null,map__3475__$1,new cljs.core.Keyword(null,"identifiers","identifiers",-2057597722));
var type = cljs.core.get.call(null,map__3475__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var case_sensitive = cljs.core.get.call(null,map__3475__$1,new cljs.core.Keyword(null,"case-sensitive","case-sensitive",-1005239404));
var wild_cards = cljs.core.get.call(null,map__3475__$1,new cljs.core.Keyword(null,"wild-cards","wild-cards",681119344));
var extra = cljs.core.get.call(null,map__3475__$1,new cljs.core.Keyword(null,"extra","extra",1612569067));
var name = cljs.core.get.call(null,map__3475__$1,new cljs.core.Keyword(null,"name","name",1843675177));
return imcljs.internal.io.restful.call(null,(cljs.core.truth_(imcljs.fetch.list_resolution_job_QMARK_.call(null,options))?new cljs.core.Keyword(null,"post","post",269697687):new cljs.core.Keyword(null,"post-body","post-body",-1481559189)),imcljs.fetch.id_resolution_endpoint.call(null,options),service,(cljs.core.truth_(imcljs.fetch.list_resolution_job_QMARK_.call(null,options))?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),name], null):new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"body","body",-2049205669),(function (){var G__3477 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"identifiers","identifiers",-2057597722),identifiers], null);
var G__3477__$1 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__3477,new cljs.core.Keyword(null,"type","type",1174270348),type):G__3477);
var G__3477__$2 = (cljs.core.truth_(case_sensitive)?cljs.core.assoc.call(null,G__3477__$1,new cljs.core.Keyword(null,"caseSensitive","caseSensitive",-586669673),true):G__3477__$1);
var G__3477__$3 = (cljs.core.truth_(wild_cards)?cljs.core.assoc.call(null,G__3477__$2,new cljs.core.Keyword(null,"wildCards","wildCards",-2054689560),true):G__3477__$2);
if(cljs.core.truth_(extra)){
return cljs.core.assoc.call(null,G__3477__$3,new cljs.core.Keyword(null,"extra","extra",1612569067),extra);
} else {
return G__3477__$3;
}
})(),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null)], null)));
});
/**
 * Resolves identifiers. Automatically handles polling.
 *   Will use listresolver endpoint if name instead of identifiers is specified.
 */
imcljs.fetch.resolve_identifiers = (function imcljs$fetch$resolve_identifiers(service,p__3478){
var map__3479 = p__3478;
var map__3479__$1 = (((((!((map__3479 == null))))?(((((map__3479.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3479.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3479):map__3479);
var options = map__3479__$1;
var timeout_ms = cljs.core.get.call(null,map__3479__$1,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406));
var return_chan = cljs.core.async.chan.call(null,(1));
var c__2324__auto___3632 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2324__auto___3632,return_chan,map__3479,map__3479__$1,options,timeout_ms){
return (function (){
var f__2325__auto__ = (function (){var switch__2301__auto__ = ((function (c__2324__auto___3632,return_chan,map__3479,map__3479__$1,options,timeout_ms){
return (function (state_3574){
var state_val_3575 = (state_3574[(1)]);
if((state_val_3575 === (7))){
var state_3574__$1 = state_3574;
var statearr_3576_3633 = state_3574__$1;
(statearr_3576_3633[(2)] = false);

(statearr_3576_3633[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (20))){
var inst_3531 = (state_3574[(2)]);
var state_3574__$1 = state_3574;
if(cljs.core.truth_(inst_3531)){
var statearr_3577_3634 = state_3574__$1;
(statearr_3577_3634[(1)] = (24));

} else {
var statearr_3578_3635 = state_3574__$1;
(statearr_3578_3635[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (27))){
var inst_3565 = (state_3574[(2)]);
var state_3574__$1 = state_3574;
var statearr_3579_3636 = state_3574__$1;
(statearr_3579_3636[(2)] = inst_3565);

(statearr_3579_3636[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (1))){
var inst_3482 = imcljs.fetch.fetch_id_resolution_job.call(null,service,options);
var state_3574__$1 = state_3574;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3574__$1,(2),inst_3482);
} else {
if((state_val_3575 === (24))){
var inst_3515 = (state_3574[(7)]);
var inst_3533 = cljs.core.apply.call(null,cljs.core.hash_map,inst_3515);
var state_3574__$1 = state_3574;
var statearr_3580_3637 = state_3574__$1;
(statearr_3580_3637[(2)] = inst_3533);

(statearr_3580_3637[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (39))){
var inst_3536 = (state_3574[(8)]);
var state_3574__$1 = state_3574;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3574__$1,(40),return_chan,inst_3536);
} else {
if((state_val_3575 === (4))){
var state_3574__$1 = state_3574;
var statearr_3581_3638 = state_3574__$1;
(statearr_3581_3638[(2)] = false);

(statearr_3581_3638[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (15))){
var inst_3506 = (state_3574[(9)]);
var inst_3513 = imcljs.fetch.fetch_id_resolution_job_status.call(null,service,inst_3506,options);
var state_3574__$1 = state_3574;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3574__$1,(17),inst_3513);
} else {
if((state_val_3575 === (21))){
var state_3574__$1 = state_3574;
var statearr_3582_3639 = state_3574__$1;
(statearr_3582_3639[(2)] = true);

(statearr_3582_3639[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (31))){
var inst_3509 = (state_3574[(10)]);
var inst_3544 = cljs.core.async.timeout.call(null,inst_3509);
var state_3574__$1 = state_3574;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3574__$1,(32),inst_3544);
} else {
if((state_val_3575 === (32))){
var inst_3546 = (state_3574[(2)]);
var state_3574__$1 = (function (){var statearr_3583 = state_3574;
(statearr_3583[(11)] = inst_3546);

return statearr_3583;
})();
if(cljs.core.truth_(timeout_ms)){
var statearr_3584_3640 = state_3574__$1;
(statearr_3584_3640[(1)] = (33));

} else {
var statearr_3585_3641 = state_3574__$1;
(statearr_3585_3641[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (40))){
var inst_3562 = (state_3574[(2)]);
var state_3574__$1 = state_3574;
var statearr_3586_3642 = state_3574__$1;
(statearr_3586_3642[(2)] = inst_3562);

(statearr_3586_3642[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (33))){
var state_3574__$1 = state_3574;
var statearr_3587_3643 = state_3574__$1;
(statearr_3587_3643[(2)] = timeout_ms);

(statearr_3587_3643[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (13))){
var inst_3505 = (state_3574[(12)]);
var state_3574__$1 = state_3574;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3574__$1,(41),return_chan,inst_3505);
} else {
if((state_val_3575 === (22))){
var state_3574__$1 = state_3574;
var statearr_3588_3644 = state_3574__$1;
(statearr_3588_3644[(2)] = false);

(statearr_3588_3644[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (36))){
var inst_3509 = (state_3574[(10)]);
var inst_3510 = (state_3574[(13)]);
var inst_3553 = (inst_3509 * 1.5);
var inst_3554 = (((1000) < inst_3553) ? (1000) : inst_3553);
var inst_3555 = (inst_3510 + inst_3509);
var inst_3509__$1 = inst_3554;
var inst_3510__$1 = inst_3555;
var state_3574__$1 = (function (){var statearr_3589 = state_3574;
(statearr_3589[(10)] = inst_3509__$1);

(statearr_3589[(13)] = inst_3510__$1);

return statearr_3589;
})();
var statearr_3590_3645 = state_3574__$1;
(statearr_3590_3645[(2)] = null);

(statearr_3590_3645[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (41))){
var inst_3570 = (state_3574[(2)]);
var state_3574__$1 = state_3574;
var statearr_3591_3646 = state_3574__$1;
(statearr_3591_3646[(2)] = inst_3570);

(statearr_3591_3646[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (29))){
var inst_3540 = (state_3574[(2)]);
var state_3574__$1 = state_3574;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3574__$1,(30),return_chan,inst_3540);
} else {
if((state_val_3575 === (6))){
var state_3574__$1 = state_3574;
var statearr_3592_3647 = state_3574__$1;
(statearr_3592_3647[(2)] = true);

(statearr_3592_3647[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (28))){
var inst_3506 = (state_3574[(9)]);
var inst_3538 = imcljs.fetch.fetch_id_resolution_job_results.call(null,service,inst_3506,options);
var state_3574__$1 = state_3574;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3574__$1,(29),inst_3538);
} else {
if((state_val_3575 === (25))){
var inst_3515 = (state_3574[(7)]);
var state_3574__$1 = state_3574;
var statearr_3593_3648 = state_3574__$1;
(statearr_3593_3648[(2)] = inst_3515);

(statearr_3593_3648[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (34))){
var state_3574__$1 = state_3574;
var statearr_3594_3649 = state_3574__$1;
(statearr_3594_3649[(2)] = (30000));

(statearr_3594_3649[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (17))){
var inst_3515 = (state_3574[(7)]);
var inst_3515__$1 = (state_3574[(2)]);
var inst_3517 = (inst_3515__$1 == null);
var inst_3518 = cljs.core.not.call(null,inst_3517);
var state_3574__$1 = (function (){var statearr_3595 = state_3574;
(statearr_3595[(7)] = inst_3515__$1);

return statearr_3595;
})();
if(inst_3518){
var statearr_3596_3650 = state_3574__$1;
(statearr_3596_3650[(1)] = (18));

} else {
var statearr_3597_3651 = state_3574__$1;
(statearr_3597_3651[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (3))){
var inst_3484 = (state_3574[(14)]);
var inst_3489 = inst_3484.cljs$lang$protocol_mask$partition0$;
var inst_3490 = (inst_3489 & (64));
var inst_3491 = inst_3484.cljs$core$ISeq$;
var inst_3492 = (cljs.core.PROTOCOL_SENTINEL === inst_3491);
var inst_3493 = ((inst_3490) || (inst_3492));
var state_3574__$1 = state_3574;
if(cljs.core.truth_(inst_3493)){
var statearr_3598_3652 = state_3574__$1;
(statearr_3598_3652[(1)] = (6));

} else {
var statearr_3599_3653 = state_3574__$1;
(statearr_3599_3653[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (12))){
var inst_3509 = (100);
var inst_3510 = (0);
var state_3574__$1 = (function (){var statearr_3600 = state_3574;
(statearr_3600[(10)] = inst_3509);

(statearr_3600[(13)] = inst_3510);

return statearr_3600;
})();
var statearr_3601_3654 = state_3574__$1;
(statearr_3601_3654[(2)] = null);

(statearr_3601_3654[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (2))){
var inst_3484 = (state_3574[(14)]);
var inst_3484__$1 = (state_3574[(2)]);
var inst_3486 = (inst_3484__$1 == null);
var inst_3487 = cljs.core.not.call(null,inst_3486);
var state_3574__$1 = (function (){var statearr_3602 = state_3574;
(statearr_3602[(14)] = inst_3484__$1);

return statearr_3602;
})();
if(inst_3487){
var statearr_3603_3655 = state_3574__$1;
(statearr_3603_3655[(1)] = (3));

} else {
var statearr_3604_3656 = state_3574__$1;
(statearr_3604_3656[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (23))){
var inst_3528 = (state_3574[(2)]);
var state_3574__$1 = state_3574;
var statearr_3605_3657 = state_3574__$1;
(statearr_3605_3657[(2)] = inst_3528);

(statearr_3605_3657[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (35))){
var inst_3510 = (state_3574[(13)]);
var inst_3550 = (state_3574[(2)]);
var inst_3551 = (inst_3510 < inst_3550);
var state_3574__$1 = state_3574;
if(cljs.core.truth_(inst_3551)){
var statearr_3606_3658 = state_3574__$1;
(statearr_3606_3658[(1)] = (36));

} else {
var statearr_3607_3659 = state_3574__$1;
(statearr_3607_3659[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (19))){
var state_3574__$1 = state_3574;
var statearr_3608_3660 = state_3574__$1;
(statearr_3608_3660[(2)] = false);

(statearr_3608_3660[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (11))){
var inst_3505 = (state_3574[(12)]);
var inst_3506 = (state_3574[(9)]);
var inst_3505__$1 = (state_3574[(2)]);
var inst_3506__$1 = cljs.core.get.call(null,inst_3505__$1,new cljs.core.Keyword(null,"uid","uid",-1447769400));
var inst_3507 = cljs.core.not_empty.call(null,inst_3506__$1);
var state_3574__$1 = (function (){var statearr_3609 = state_3574;
(statearr_3609[(12)] = inst_3505__$1);

(statearr_3609[(9)] = inst_3506__$1);

return statearr_3609;
})();
if(cljs.core.truth_(inst_3507)){
var statearr_3610_3661 = state_3574__$1;
(statearr_3610_3661[(1)] = (12));

} else {
var statearr_3611_3662 = state_3574__$1;
(statearr_3611_3662[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (9))){
var inst_3484 = (state_3574[(14)]);
var inst_3502 = cljs.core.apply.call(null,cljs.core.hash_map,inst_3484);
var state_3574__$1 = state_3574;
var statearr_3612_3663 = state_3574__$1;
(statearr_3612_3663[(2)] = inst_3502);

(statearr_3612_3663[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (5))){
var inst_3500 = (state_3574[(2)]);
var state_3574__$1 = state_3574;
if(cljs.core.truth_(inst_3500)){
var statearr_3613_3664 = state_3574__$1;
(statearr_3613_3664[(1)] = (9));

} else {
var statearr_3614_3665 = state_3574__$1;
(statearr_3614_3665[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (14))){
var inst_3572 = (state_3574[(2)]);
var state_3574__$1 = state_3574;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3574__$1,inst_3572);
} else {
if((state_val_3575 === (26))){
var inst_3536 = (state_3574[(8)]);
var inst_3536__$1 = (state_3574[(2)]);
var inst_3537 = cljs.core.get.call(null,inst_3536__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var state_3574__$1 = (function (){var statearr_3615 = state_3574;
(statearr_3615[(8)] = inst_3536__$1);

return statearr_3615;
})();
var G__3616_3666 = inst_3537;
switch (G__3616_3666) {
case "SUCCESS":
var statearr_3617_3668 = state_3574__$1;
(statearr_3617_3668[(1)] = (28));


break;
case "RUNNING":
var statearr_3618_3669 = state_3574__$1;
(statearr_3618_3669[(1)] = (31));


break;
default:
var statearr_3619_3670 = state_3574__$1;
(statearr_3619_3670[(1)] = (39));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (16))){
var inst_3567 = (state_3574[(2)]);
var state_3574__$1 = state_3574;
var statearr_3620_3671 = state_3574__$1;
(statearr_3620_3671[(2)] = inst_3567);

(statearr_3620_3671[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (38))){
var inst_3559 = (state_3574[(2)]);
var state_3574__$1 = state_3574;
var statearr_3621_3672 = state_3574__$1;
(statearr_3621_3672[(2)] = inst_3559);

(statearr_3621_3672[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (30))){
var inst_3542 = (state_3574[(2)]);
var state_3574__$1 = state_3574;
var statearr_3622_3673 = state_3574__$1;
(statearr_3622_3673[(2)] = inst_3542);

(statearr_3622_3673[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (10))){
var inst_3484 = (state_3574[(14)]);
var state_3574__$1 = state_3574;
var statearr_3623_3674 = state_3574__$1;
(statearr_3623_3674[(2)] = inst_3484);

(statearr_3623_3674[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (18))){
var inst_3515 = (state_3574[(7)]);
var inst_3520 = inst_3515.cljs$lang$protocol_mask$partition0$;
var inst_3521 = (inst_3520 & (64));
var inst_3522 = inst_3515.cljs$core$ISeq$;
var inst_3523 = (cljs.core.PROTOCOL_SENTINEL === inst_3522);
var inst_3524 = ((inst_3521) || (inst_3523));
var state_3574__$1 = state_3574;
if(cljs.core.truth_(inst_3524)){
var statearr_3624_3675 = state_3574__$1;
(statearr_3624_3675[(1)] = (21));

} else {
var statearr_3625_3676 = state_3574__$1;
(statearr_3625_3676[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (37))){
var state_3574__$1 = state_3574;
var statearr_3626_3677 = state_3574__$1;
(statearr_3626_3677[(2)] = null);

(statearr_3626_3677[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3575 === (8))){
var inst_3497 = (state_3574[(2)]);
var state_3574__$1 = state_3574;
var statearr_3627_3678 = state_3574__$1;
(statearr_3627_3678[(2)] = inst_3497);

(statearr_3627_3678[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2324__auto___3632,return_chan,map__3479,map__3479__$1,options,timeout_ms))
;
return ((function (switch__2301__auto__,c__2324__auto___3632,return_chan,map__3479,map__3479__$1,options,timeout_ms){
return (function() {
var imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto__ = null;
var imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto____0 = (function (){
var statearr_3628 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_3628[(0)] = imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto__);

(statearr_3628[(1)] = (1));

return statearr_3628;
});
var imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto____1 = (function (state_3574){
while(true){
var ret_value__2303__auto__ = (function (){try{while(true){
var result__2304__auto__ = switch__2301__auto__.call(null,state_3574);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2304__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2304__auto__;
}
break;
}
}catch (e3629){if((e3629 instanceof Object)){
var ex__2305__auto__ = e3629;
var statearr_3630_3679 = state_3574;
(statearr_3630_3679[(5)] = ex__2305__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3574);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3629;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2303__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3680 = state_3574;
state_3574 = G__3680;
continue;
} else {
return ret_value__2303__auto__;
}
break;
}
});
imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto__ = function(state_3574){
switch(arguments.length){
case 0:
return imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto____0.call(this);
case 1:
return imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto____1.call(this,state_3574);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto____0;
imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto____1;
return imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto__;
})()
;})(switch__2301__auto__,c__2324__auto___3632,return_chan,map__3479,map__3479__$1,options,timeout_ms))
})();
var state__2326__auto__ = (function (){var statearr_3631 = f__2325__auto__.call(null);
(statearr_3631[(6)] = c__2324__auto___3632);

return statearr_3631;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2326__auto__);
});})(c__2324__auto___3632,return_chan,map__3479,map__3479__$1,options,timeout_ms))
);


return return_chan;
});
/**
 * Returns generated code to run the query in a given language
 */
imcljs.fetch.code = (function imcljs$fetch$code(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3690 = arguments.length;
var i__4731__auto___3691 = (0);
while(true){
if((i__4731__auto___3691 < len__4730__auto___3690)){
args__4736__auto__.push((arguments[i__4731__auto___3691]));

var G__3692 = (i__4731__auto___3691 + (1));
i__4731__auto___3691 = G__3692;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.code.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.code.cljs$core$IFn$_invoke$arity$variadic = (function (service,model,p__3684){
var vec__3685 = p__3684;
var map__3688 = cljs.core.nth.call(null,vec__3685,(0),null);
var map__3688__$1 = (((((!((map__3688 == null))))?(((((map__3688.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3688.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3688):map__3688);
var options = map__3688__$1;
var lang = cljs.core.get.call(null,map__3688__$1,new cljs.core.Keyword(null,"lang","lang",-1819677104));
var query = cljs.core.get.call(null,map__3688__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/query/code",service,cljs.core.update.call(null,cljs.core.merge.call(null,options,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null)),new cljs.core.Keyword(null,"query","query",-1288509510),cljs.core.partial.call(null,imcljs.query.__GT_xml,model)),new cljs.core.Keyword(null,"code","code",1586293142));
});

imcljs.fetch.code.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.code.cljs$lang$applyTo = (function (seq3681){
var G__3682 = cljs.core.first.call(null,seq3681);
var seq3681__$1 = cljs.core.next.call(null,seq3681);
var G__3683 = cljs.core.first.call(null,seq3681__$1);
var seq3681__$2 = cljs.core.next.call(null,seq3681__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3682,G__3683,seq3681__$2);
});

/**
 * Returns list of InterMines from the InterMine registry. dev-mines? needs to
 * be set to true if you want to return non-prod mines, or otherwise set to false
 */
imcljs.fetch.registry = (function imcljs$fetch$registry(dev_mines_QMARK_){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"raw","raw",1604651272),new cljs.core.Keyword(null,"get","get",1683182755),"/instances",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"root","root",-448657453),"https://registry.intermine.org/service"], null),(cljs.core.truth_(dev_mines_QMARK_)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query-params","query-params",900640534),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mines","mines",-1960796490),"all"], null)], null):null),new cljs.core.Keyword(null,"instances","instances",-335364781));
});
/**
 * Returns a map of preferences set for the authenticated user.
 */
imcljs.fetch.preferences = (function imcljs$fetch$preferences(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3699 = arguments.length;
var i__4731__auto___3700 = (0);
while(true){
if((i__4731__auto___3700 < len__4730__auto___3699)){
args__4736__auto__.push((arguments[i__4731__auto___3700]));

var G__3701 = (i__4731__auto___3700 + (1));
i__4731__auto___3700 = G__3701;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.preferences.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.preferences.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__3695){
var vec__3696 = p__3695;
var options = cljs.core.nth.call(null,vec__3696,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/user/preferences",service,options,new cljs.core.Keyword(null,"preferences","preferences",-484312211));
});

imcljs.fetch.preferences.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.preferences.cljs$lang$applyTo = (function (seq3693){
var G__3694 = cljs.core.first.call(null,seq3693);
var seq3693__$1 = cljs.core.next.call(null,seq3693);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3694,seq3693__$1);
});

/**
 * Returns a permanent URL to access a data object even when its ID has changed.
 */
imcljs.fetch.permanent_url = (function imcljs$fetch$permanent_url(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3709 = arguments.length;
var i__4731__auto___3710 = (0);
while(true){
if((i__4731__auto___3710 < len__4730__auto___3709)){
args__4736__auto__.push((arguments[i__4731__auto___3710]));

var G__3711 = (i__4731__auto___3710 + (1));
i__4731__auto___3710 = G__3711;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.permanent_url.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.permanent_url.cljs$core$IFn$_invoke$arity$variadic = (function (service,id,p__3705){
var vec__3706 = p__3705;
var options = cljs.core.nth.call(null,vec__3706,(0),null);
var params = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),id], null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/permanent-url",service,cljs.core.merge.call(null,params,options),new cljs.core.Keyword(null,"url","url",276297046));
});

imcljs.fetch.permanent_url.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.permanent_url.cljs$lang$applyTo = (function (seq3702){
var G__3703 = cljs.core.first.call(null,seq3702);
var seq3702__$1 = cljs.core.next.call(null,seq3702);
var G__3704 = cljs.core.first.call(null,seq3702__$1);
var seq3702__$2 = cljs.core.next.call(null,seq3702__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3703,G__3704,seq3702__$2);
});

/**
 * Returns the JSON semantic markup for a page. See web service documentation
 *   for supported pages and their required parameters.
 */
imcljs.fetch.semantic_markup = (function imcljs$fetch$semantic_markup(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3719 = arguments.length;
var i__4731__auto___3720 = (0);
while(true){
if((i__4731__auto___3720 < len__4730__auto___3719)){
args__4736__auto__.push((arguments[i__4731__auto___3720]));

var G__3721 = (i__4731__auto___3720 + (1));
i__4731__auto___3720 = G__3721;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.semantic_markup.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.semantic_markup.cljs$core$IFn$_invoke$arity$variadic = (function (service,page,p__3715){
var vec__3716 = p__3715;
var options = cljs.core.nth.call(null,vec__3716,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),["/semantic-markup/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(page)].join(''),service,options,new cljs.core.Keyword(null,"semantic-markups","semantic-markups",758011526));
});

imcljs.fetch.semantic_markup.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.semantic_markup.cljs$lang$applyTo = (function (seq3712){
var G__3713 = cljs.core.first.call(null,seq3712);
var seq3712__$1 = cljs.core.next.call(null,seq3712);
var G__3714 = cljs.core.first.call(null,seq3712__$1);
var seq3712__$2 = cljs.core.next.call(null,seq3712__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3713,G__3714,seq3712__$2);
});

/**
 * Responds with the representation of an entity in the specified format.
 *   LUI needs to be a string similar to `gene:FBgn0030596`.
 */
imcljs.fetch.entity_representation = (function imcljs$fetch$entity_representation(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3730 = arguments.length;
var i__4731__auto___3731 = (0);
while(true){
if((i__4731__auto___3731 < len__4730__auto___3730)){
args__4736__auto__.push((arguments[i__4731__auto___3731]));

var G__3732 = (i__4731__auto___3731 + (1));
i__4731__auto___3731 = G__3732;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.fetch.entity_representation.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.fetch.entity_representation.cljs$core$IFn$_invoke$arity$variadic = (function (service,lui,format,p__3726){
var vec__3727 = p__3726;
var options = cljs.core.nth.call(null,vec__3727,(0),null);
var params = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lui","lui",930491324),lui,new cljs.core.Keyword(null,"format","format",-1306924766),format], null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/entity-representation",service,cljs.core.merge.call(null,params,options));
});

imcljs.fetch.entity_representation.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.fetch.entity_representation.cljs$lang$applyTo = (function (seq3722){
var G__3723 = cljs.core.first.call(null,seq3722);
var seq3722__$1 = cljs.core.next.call(null,seq3722);
var G__3724 = cljs.core.first.call(null,seq3722__$1);
var seq3722__$2 = cljs.core.next.call(null,seq3722__$1);
var G__3725 = cljs.core.first.call(null,seq3722__$2);
var seq3722__$3 = cljs.core.next.call(null,seq3722__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3723,G__3724,G__3725,seq3722__$3);
});

/**
 * Returns the precomputed status of a named template, or all templates owned
 *   by the superuser. Use parameter `name` for a single template.
 */
imcljs.fetch.precompute = (function imcljs$fetch$precompute(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3739 = arguments.length;
var i__4731__auto___3740 = (0);
while(true){
if((i__4731__auto___3740 < len__4730__auto___3739)){
args__4736__auto__.push((arguments[i__4731__auto___3740]));

var G__3741 = (i__4731__auto___3740 + (1));
i__4731__auto___3740 = G__3741;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.precompute.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.precompute.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__3735){
var vec__3736 = p__3735;
var options = cljs.core.nth.call(null,vec__3736,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/template/precompute",service,options,new cljs.core.Keyword(null,"templates","templates",-1237401733));
});

imcljs.fetch.precompute.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.precompute.cljs$lang$applyTo = (function (seq3733){
var G__3734 = cljs.core.first.call(null,seq3733);
var seq3733__$1 = cljs.core.next.call(null,seq3733);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3734,seq3733__$1);
});

/**
 * Returns the summarise status of a named template, or all templates owned
 *   by the superuser. Use parameter `name` for a single template.
 */
imcljs.fetch.summarise = (function imcljs$fetch$summarise(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3748 = arguments.length;
var i__4731__auto___3749 = (0);
while(true){
if((i__4731__auto___3749 < len__4730__auto___3748)){
args__4736__auto__.push((arguments[i__4731__auto___3749]));

var G__3750 = (i__4731__auto___3749 + (1));
i__4731__auto___3749 = G__3750;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.summarise.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.summarise.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__3744){
var vec__3745 = p__3744;
var options = cljs.core.nth.call(null,vec__3745,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/template/summarise",service,options,new cljs.core.Keyword(null,"templates","templates",-1237401733));
});

imcljs.fetch.summarise.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.summarise.cljs$lang$applyTo = (function (seq3742){
var G__3743 = cljs.core.first.call(null,seq3742);
var seq3742__$1 = cljs.core.next.call(null,seq3742);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3743,seq3742__$1);
});

/**
 * Get the tags for a named template, or all the tags associated with the
 *   authenticating user. Use parameter `name` for a single template.
 */
imcljs.fetch.template_tags = (function imcljs$fetch$template_tags(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3757 = arguments.length;
var i__4731__auto___3758 = (0);
while(true){
if((i__4731__auto___3758 < len__4730__auto___3757)){
args__4736__auto__.push((arguments[i__4731__auto___3758]));

var G__3759 = (i__4731__auto___3758 + (1));
i__4731__auto___3758 = G__3759;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.template_tags.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.template_tags.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__3753){
var vec__3754 = p__3753;
var options = cljs.core.nth.call(null,vec__3754,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/template/tags",service,options,new cljs.core.Keyword(null,"tags","tags",1771418977));
});

imcljs.fetch.template_tags.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.template_tags.cljs$lang$applyTo = (function (seq3751){
var G__3752 = cljs.core.first.call(null,seq3751);
var seq3751__$1 = cljs.core.next.call(null,seq3751);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3752,seq3751__$1);
});


//# sourceMappingURL=fetch.js.map
