/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.plugins;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.XmlUtil;
import org.jboss.plugins.RegisterOptions;
import org.w3c.dom.Document;

public class RegisterExtension {
    final Log log;

    public RegisterExtension(Log log) {
        this.log = log;
    }

    public void register(RegisterOptions options, File destFile, String moduleId) throws Exception {
        try {
            this.log.info((CharSequence)("Register extension module=" + moduleId));
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document srcDoc = dBuilder.parse(options.getServerConfig());
            Document subsystemDoc = null;
            Document socketBindingDoc = null;
            if (RegisterExtension.isStandaloneXml(srcDoc)) {
                options.profiles(null);
            }
            if (options.getSubsystem().isFile() && options.getSubsystem().canRead()) {
                subsystemDoc = dBuilder.parse(options.getSubsystem());
                this.log.info((CharSequence)("Configuring subsystem from file " + options.getSubsystem()));
            } else {
                this.log.info((CharSequence)("Subsystem file [" + options.getSubsystem() + "] does not exist, subsystem will not be configured"));
            }
            if (options.getSocketBinding().isFile() && options.getSocketBinding().canRead()) {
                socketBindingDoc = dBuilder.parse(options.getSocketBinding());
                this.log.info((CharSequence)("Configuring socket-binding from file " + options.getSocketBinding()));
            } else {
                this.log.info((CharSequence)("Socket-binding file [" + options.getSocketBinding() + "] does not exist, socket-binding will not be configured"));
            }
            TransformerFactory f = TransformerFactory.newInstance();
            InputStream stylesheet = this.createStylesheet(RegisterExtension.getNameSpace(srcDoc), moduleId, subsystemDoc, options.getProfiles(), socketBindingDoc, options.getSocketBindingGroups());
            Transformer t = f.newTransformer(new StreamSource(stylesheet));
            StreamSource s = new StreamSource(options.getServerConfig());
            StreamResult r = new StreamResult(destFile);
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("method", "xml");
            t.transform(s, r);
            this.formatXmlDocument(destFile);
            this.log.info((CharSequence)("New serverConfig file written to [" + destFile.getAbsolutePath() + "]"));
        }
        catch (TransformerConfigurationException e) {
            throw new Exception(e.toString());
        }
        catch (TransformerException e) {
            throw new Exception(e.toString());
        }
    }

    private InputStream createStylesheet(String namespace, String module, Document subsystem, String[] profileNames, Document socketBinding, String[] socketBindingGroups) throws IOException {
        String ignoreNs = "s";
        String subns = "";
        boolean isSubsystem = subsystem != null;
        boolean isSocketBinding = socketBinding != null;
        StringBuilder sheet = new StringBuilder("<?xml version=\"1.0\" ?>");
        sheet.append("<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:s=\"" + namespace + "\"");
        if (isSubsystem) {
            subns = RegisterExtension.getNameSpace(subsystem);
            sheet.append(" xmlns:sub=\"" + subns + "\"");
            ignoreNs = String.valueOf(ignoreNs) + " sub";
        }
        sheet.append(" exclude-result-prefixes=\"" + ignoreNs + "\" version=\"1.0\">");
        sheet.append("<xsl:variable name=\"extension\"><extension module=\"" + module + "\" /></xsl:variable>");
        sheet.append("<xsl:template match=\"s:extensions\"><xsl:copy><xsl:apply-templates select=\"*[not(@module='" + module + "')]\" /><xsl:copy-of select=\"$extension\" /></xsl:copy>" + "</xsl:template>");
        if (isSubsystem) {
            String profileSelector = RegisterExtension.createXPathNameAttributeSelector(profileNames);
            sheet.append("<xsl:variable name=\"subsystem\">" + this.doc2string(subsystem) + "</xsl:variable>");
            sheet.append("<xsl:template match=\"s:profile" + profileSelector + "\"><xsl:copy>" + "<xsl:apply-templates select=\"@*\" />" + "<xsl:apply-templates select=\"*[not(namespace-uri() ='" + subns + "')]\" />" + "<xsl:copy-of select=\"$subsystem\" /></xsl:copy>" + "</xsl:template>");
        }
        if (isSocketBinding) {
            String sbgSelector = RegisterExtension.createXPathNameAttributeSelector(socketBindingGroups);
            String bindingName = socketBinding.getDocumentElement().getAttribute("name");
            sheet.append("<xsl:variable name=\"socketBinding\">" + this.doc2string(socketBinding) + "</xsl:variable>");
            sheet.append("<xsl:template match=\"s:socket-binding-group" + sbgSelector + "\"><xsl:copy>" + "<xsl:apply-templates select=\"@*\" />" + "<xsl:apply-templates select=\"*[not(@name='" + bindingName + "')]\" />" + "<xsl:copy-of select=\"$socketBinding\" /></xsl:copy>" + "</xsl:template>");
        }
        sheet.append("<xsl:template match=\"@*|node()\"><xsl:copy><xsl:apply-templates select=\"@*|node()\" /></xsl:copy></xsl:template>");
        sheet.append("</xsl:stylesheet>");
        this.log.debug((CharSequence)("XSL :" + sheet));
        return new ByteArrayInputStream(IOUtil.toByteArray((String)sheet.toString()));
    }

    private static String createXPathNameAttributeSelector(String[] names) {
        if (names == null || names.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder("[");
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            sb.append("@name='" + name + "' or ");
            ++n2;
        }
        sb.delete(sb.length() - 4, sb.length());
        sb.append("]");
        return sb.toString();
    }

    private static boolean isStandaloneXml(Document doc) {
        return "server".equals(doc.getDocumentElement().getNodeName());
    }

    private static String getNameSpace(Document doc) {
        if (doc == null) {
            return null;
        }
        return doc.getDocumentElement().getAttribute("xmlns");
    }

    private void formatXmlDocument(File file) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(IOUtil.toByteArray((InputStream)new FileInputStream(file)));
            XmlUtil.prettyFormat((InputStream)is, (OutputStream)new FileOutputStream(file), (int)4, (String)System.getProperty("line.separator"));
            IOUtil.close((InputStream)is);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error formatting file " + file.getAbsolutePath(), ex);
        }
    }

    private String doc2string(Document doc) {
        if (doc == null) {
            return null;
        }
        try {
            StringWriter sw = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(doc), new StreamResult(sw));
            return sw.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException("Error converting to String", ex);
        }
    }
}

