/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import org.jinterop.dcom.common.IJIAuthInfo;
import org.jinterop.dcom.common.IJIUnreferenced;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JICallBuilder;
import org.jinterop.dcom.core.JIComCustomMarshallerUnMarshaller;
import org.jinterop.dcom.core.JIComOxidRuntime;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIObjectId;
import org.jinterop.dcom.core.JIOxid;
import org.jinterop.dcom.core.JIRemUnknownServer;
import org.jinterop.dcom.core.JIStdObjRef;
import org.jinterop.dcom.core.JIStruct;
import rpc.core.UUID;

public final class JISession {
    private static Random randomGen = new Random(Double.doubleToRawLongBits(Math.random()));
    private int sessionIdentifier = -1;
    private String username = null;
    private String password = null;
    private String domain = null;
    private String targetServer = null;
    private static Map mapOfObjects = Collections.synchronizedMap(new HashMap());
    private static Object mutex = new Object();
    private IJIAuthInfo authInfo = null;
    private JIComServer stub = null;
    private JIRemUnknownServer stub2 = null;
    private static int oxidResolverPort = -1;
    private static byte[] localhost;
    private static String localhostStr;
    private static String localhostStr2;
    private static Map mapOfSessionIdsVsSessions;
    private static ArrayList listOfSessions;
    private List listOfDeferencedIpids = new ArrayList();
    private static Timer releaseRefsTimer;
    private Map mapOfUnreferencedHandlers = new HashMap();
    private int timeout = 0;
    private boolean useSessionSecurity = false;
    private boolean useNTLMv2 = false;
    private boolean isSSO = false;
    private ArrayList links = new ArrayList();
    private static final Map mapOfOxidsVsJISessions;
    private static final Map<String, JIComCustomMarshallerUnMarshaller> mapOfCustomCLSIDs;
    private boolean sessionInDestroy = false;
    private Map mapOfIPIDsVsRefcounts = new HashMap();
    private Map mapOfIPIDsVsWeakReferences = new HashMap();
    static ReferenceQueue referenceQueueOfCOMObjects;
    static Thread cleanUpThread;
    private static Map mapOfIPIDSvsCount;

    static {
        byte[] byArray = new byte[4];
        byArray[0] = 127;
        byArray[3] = 1;
        localhost = byArray;
        localhostStr = "127.0.0.1";
        localhostStr2 = "LOCALHOST";
        mapOfSessionIdsVsSessions = new HashMap();
        listOfSessions = new ArrayList();
        releaseRefsTimer = new Timer(true);
        mapOfOxidsVsJISessions = new HashMap();
        mapOfCustomCLSIDs = new HashMap<String, JIComCustomMarshallerUnMarshaller>();
        referenceQueueOfCOMObjects = new ReferenceQueue();
        cleanUpThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (true) {
                        Reference r;
                        if ((r = referenceQueueOfCOMObjects.remove()) == null) {
                            continue;
                        }
                        IPID_SessionID_Holder holder = null;
                        Map map = mapOfObjects;
                        synchronized (map) {
                            holder = (IPID_SessionID_Holder)mapOfObjects.remove(r);
                            if (holder == null) {
                                continue;
                            }
                        }
                        JISession session = null;
                        Object object = mutex;
                        synchronized (object) {
                            session = (JISession)mapOfSessionIdsVsSessions.get(holder.sessionID);
                        }
                        if (holder.isOnlySessionIDPresent) {
                            try {
                                JISession.destroySession(session);
                            }
                            catch (Exception e) {
                                if (!JISystem.getLogger().isLoggable(Level.FINEST)) continue;
                                JISystem.getLogger().finest("exception from destroy session in clean up thread: " + e.getMessage());
                            }
                            continue;
                        }
                        if (session == null) continue;
                        try {
                            String IPID = holder.IPID;
                            int weakRefsRemaining = session.removeWeakReference(IPID);
                            JIComOxidRuntime.delIPIDReference(IPID, new JIObjectId(holder.oid, false), session);
                            if (weakRefsRemaining > 0) continue;
                            if (JISystem.getLogger().isLoggable(Level.FINEST)) {
                                JISystem.getLogger().finest("Adding Dereferenced IPID " + IPID + " session " + session.getSessionIdentifier());
                            }
                            session.addDereferencedIpids(IPID);
                            holder = null;
                            IJIUnreferenced unreferenced = session.getUnreferencedHandler(IPID);
                            if (unreferenced != null) {
                                unreferenced.unReferenced();
                            }
                            session.unregisterUnreferencedHandler(IPID);
                        }
                        catch (Exception e) {
                            if (!JISystem.getLogger().isLoggable(Level.INFO)) continue;
                            JISystem.getLogger().info("exception from removing a IPID from session in clean up thread: " + e.getMessage());
                        }
                    }
                }
                catch (Exception e) {
                    JISystem.getLogger().throwing("JISession", "CleanupThread:run()", e);
                    return;
                }
            }
        }, "jI_GarbageCollector");
        JISystem.internal_initLogger();
        try {
            InetAddress localhostAddr = InetAddress.getLocalHost();
            localhost = localhostAddr.getAddress();
            localhostStr = localhostAddr.getHostAddress();
            localhostStr2 = localhostAddr.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        System.setProperty("jcifs.smb.client.domain", "JIDomain");
        cleanUpThread.setDaemon(true);
        cleanUpThread.start();
        JIComOxidRuntime.startResolver();
        JIComOxidRuntime.startResolverTimer();
        oxidResolverPort = JIComOxidRuntime.getOxidResolverPort();
        releaseRefsTimer.scheduleAtFixedRate((TimerTask)new Release_References_TimerTask(), 0L, 120000L);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < listOfSessions.size()) {
                    JISession session = (JISession)listOfSessions.get(i);
                    try {
                        JISession.destroySession(session);
                    }
                    catch (JIException e) {
                        JISystem.getLogger().throwing("JISession", "addShutDownHook Thread:run()", e);
                    }
                    ++i;
                }
                JISystem.internal_writeProgIdsToFile();
                JIComOxidRuntime.stopResolver();
                releaseRefsTimer.cancel();
                mapOfSessionIdsVsSessions.clear();
                mapOfObjects.clear();
                listOfSessions.clear();
            }
        }, "jI_ShutdownHook"));
        mapOfIPIDSvsCount = Collections.synchronizedMap(new HashMap());
    }

    private static String getLocalHost(String destination) {
        InetAddress intendedDestination;
        DatagramSocket sock;
        try {
            sock = new DatagramSocket();
            intendedDestination = InetAddress.getByName(destination);
        }
        catch (Exception e) {
            return "127.0.0.1";
        }
        sock.connect(intendedDestination, sock.getLocalPort());
        return sock.getLocalAddress().getHostAddress();
    }

    public static void setReleaseRefTimerFrequency(int timeInMilliSec) {
        releaseRefsTimer.cancel();
        releaseRefsTimer = new Timer(true);
        releaseRefsTimer.scheduleAtFixedRate((TimerTask)new Release_References_TimerTask(), 0L, (long)timeInMilliSec);
    }

    void setTargetServer(String targetServer) {
        if (targetServer.equalsIgnoreCase("127.0.0.1")) {
            this.targetServer = JISession.getLocalhostAddressAsIPString();
        } else {
            this.targetServer = targetServer;
            if (localhostStr.equalsIgnoreCase("127.0.0.1") || localhostStr.equalsIgnoreCase("0.0.0.0")) {
                localhostStr = JISession.getLocalHost(targetServer);
            }
        }
    }

    static byte[] getLocalhostAddressAsIPbytes() {
        return localhost;
    }

    static String getLocalhostAddressAsIPString() {
        return localhostStr;
    }

    static String getLocalhostCanonicalAddressAsString() {
        return localhostStr2;
    }

    String getTargetServer() {
        return this.targetServer;
    }

    private JISession() {
    }

    static int getOxidResolverPort() {
        return oxidResolverPort;
    }

    public IJIAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JISession createSession(IJIAuthInfo authInfo) {
        if (authInfo == null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4112));
        }
        JISession session = new JISession();
        session.authInfo = authInfo;
        session.sessionIdentifier = authInfo.getUserName().hashCode() ^ authInfo.getPassword().hashCode() ^ authInfo.getDomain().hashCode() ^ new Object().hashCode() ^ (int)Runtime.getRuntime().freeMemory() ^ randomGen.nextInt();
        Object object = mutex;
        synchronized (object) {
            mapOfSessionIdsVsSessions.put(new Integer(session.sessionIdentifier), session);
            listOfSessions.add(session);
        }
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().info("Created Session: " + session.sessionIdentifier);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JISession createSession(String domain, String username, String password) {
        if (username == null || password == null || domain == null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4112));
        }
        JISession session = new JISession();
        session.username = username;
        session.password = password;
        session.domain = domain;
        session.sessionIdentifier = username.hashCode() ^ password.hashCode() ^ domain.hashCode() ^ new Object().hashCode() ^ (int)Runtime.getRuntime().freeMemory() ^ randomGen.nextInt();
        Object object = mutex;
        synchronized (object) {
            mapOfSessionIdsVsSessions.put(new Integer(session.sessionIdentifier), session);
            listOfSessions.add(session);
        }
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().info("Created Session: " + session.sessionIdentifier);
        }
        return session;
    }

    public static JISession createSession(JISession session) {
        JISession newSession = JISession.createSession(session.getDomain(), session.getUserName(), session.getPassword());
        newSession.authInfo = session.authInfo;
        return newSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JISession createSession() {
        if (!System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4178));
        }
        JISession session = new JISession();
        session.sessionIdentifier = new Object().hashCode() ^ (int)Runtime.getRuntime().freeMemory() ^ randomGen.nextInt();
        session.isSSO = true;
        Object object = mutex;
        synchronized (object) {
            mapOfSessionIdsVsSessions.put(new Integer(session.sessionIdentifier), session);
            listOfSessions.add(session);
        }
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().info("Created Session for SSO: " + session.sessionIdentifier);
        }
        return session;
    }

    public boolean isSSOEnabled() {
        return this.isSSO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void destroySession(JISession session) throws JIException {
        if (session == null) {
            return;
        }
        if (session.stub == null) {
            var1_1 = JISession.mutex;
            synchronized (var1_1) {
                JISession.mapOfSessionIdsVsSessions.remove(new Integer(session.getSessionIdentifier()));
                JISession.listOfSessions.remove(session);
            }
            JISession.postDestroy(session);
            return;
        }
        list = new ArrayList<JIStruct>();
        listOfFreeIPIDs = new ArrayList<String>();
        var3_4 = JISession.mutex;
        synchronized (var3_4) {
            if (!session.sessionInDestroy) ** break block34
            // MONITOREXIT @DISABLED, blocks:[1, 2, 12] lbl25 : MonitorExitStatement: MONITOREXIT : var3_4
            var9_5 = JISession.mutex;
        }
        synchronized (var9_5) {
            JISession.mapOfSessionIdsVsSessions.remove(new Integer(session.getSessionIdentifier()));
            JISession.listOfSessions.remove(session);
            if (session.stub.getServerInterfacePointer() != null) {
                JISession.mapOfOxidsVsJISessions.remove(new JIOxid(session.stub.getServerInterfacePointer().getOXID()));
            }
        }
        session.stub.closeStub();
        session.stub2.closeStub();
        return;
        {
            try {
                session.sessionInDestroy = true;
                j = 0;
                while (j < session.listOfDeferencedIpids.size()) {
                    list.add(session.prepareForReleaseRef((String)session.listOfDeferencedIpids.get(j)));
                    ++j;
                }
                listOfFreeIPIDs.addAll(session.listOfDeferencedIpids);
                session.listOfDeferencedIpids.clear();
                // MONITOREXIT @DISABLED, blocks:[4, 5, 12] lbl56 : MonitorExitStatement: MONITOREXIT : var3_4
                {
                    catch (Throwable v2) {
                        throw v2;
                    }
                }
                var3_4 = JISession.mapOfObjects;
                synchronized (var3_4) {
                    iterator = JISession.mapOfObjects.entrySet().iterator();
                    while (iterator.hasNext()) {
                        entry = iterator.next();
                        holder = (IPID_SessionID_Holder)entry.getValue();
                        if (session.getSessionIdentifier() != holder.sessionID.intValue() || (ipid = holder.IPID) == null) continue;
                        list.add(session.prepareForReleaseRef(ipid));
                        listOfFreeIPIDs.add(ipid);
                        iterator.remove();
                    }
                }
                if (session.stub.getServerInterfacePointer() != null && !listOfFreeIPIDs.contains(session.stub.getServerInterfacePointer().getIPID())) {
                    list.add(session.prepareForReleaseRef(session.stub.getServerInterfacePointer().getIPID()));
                    listOfFreeIPIDs.add(session.stub.getServerInterfacePointer().getIPID());
                }
                listOfFreeIPIDs.clear();
                if (list.size() > 0) {
                    array = new JIArray(list.toArray(new JIStruct[list.size()]), true);
                    try {
                        session.stub.closeStub();
                        session.releaseRefs(array, true);
                    }
                    catch (JIException e) {
                        JISystem.getLogger().throwing("JISession", "destroySession", e);
                    }
                }
                JIComOxidRuntime.clearIPIDsforSession(session);
                if (JISystem.getLogger().isLoggable(Level.INFO)) {
                    JISystem.getLogger().info("Destroyed Session: " + session.sessionIdentifier);
                }
            }
            catch (Throwable var8_14) {
                var9_6 = JISession.mutex;
                synchronized (var9_6) {
                    JISession.mapOfSessionIdsVsSessions.remove(new Integer(session.getSessionIdentifier()));
                    JISession.listOfSessions.remove(session);
                    if (session.stub.getServerInterfacePointer() != null) {
                        JISession.mapOfOxidsVsJISessions.remove(new JIOxid(session.stub.getServerInterfacePointer().getOXID()));
                    }
                }
                session.stub.closeStub();
                session.stub2.closeStub();
                throw var8_14;
            }
        }
        var9_7 = JISession.mutex;
        synchronized (var9_7) {
            JISession.mapOfSessionIdsVsSessions.remove(new Integer(session.getSessionIdentifier()));
            JISession.listOfSessions.remove(session);
            if (session.stub.getServerInterfacePointer() != null) {
                JISession.mapOfOxidsVsJISessions.remove(new JIOxid(session.stub.getServerInterfacePointer().getOXID()));
            }
        }
        session.stub.closeStub();
        session.stub2.closeStub();
        JISession.postDestroy(session);
        session.stub = null;
        session.stub2 = null;
    }

    private static void postDestroy(JISession session) throws JIException {
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().info("About to destroy links for Session: " + session.getSessionIdentifier() + " , size of which is " + session.links.size());
        }
        int i = 0;
        while (i < session.links.size()) {
            JISession.destroySession((JISession)session.links.get(i));
            ++i;
        }
        session.links.clear();
        JIComOxidRuntime.destroySessionOIDs(session.getSessionIdentifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStub(JIComServer stub) {
        this.stub = stub;
        Object object = mutex;
        synchronized (object) {
            mapOfOxidsVsJISessions.put(new JIOxid(stub.getServerInterfacePointer().getOXID()), this);
        }
    }

    void setStub2(JIRemUnknownServer stub) {
        this.stub2 = stub;
    }

    JIComServer getStub() {
        return this.stub;
    }

    JIRemUnknownServer getStub2() {
        return this.stub2;
    }

    void addToSession(IJIComObject comObject, byte[] oid) {
        if (this.sessionInDestroy) {
            return;
        }
        this.addWeakReference(comObject, oid);
        this.addToSession(comObject.getIpid(), oid, ((JIStdObjRef)comObject.internal_getInterfacePointer().getObjectReference(1)).getFlags() == 4096);
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().info(" for IID: " + comObject.getInterfaceIdentifier() + " session: " + this.getSessionIdentifier());
        }
        int refcount = ((JIStdObjRef)comObject.internal_getInterfacePointer().getObjectReference(1)).getPublicRefs();
        this.updateReferenceForIPID(comObject.getIpid(), refcount);
    }

    void addRef_ReleaseRef(String IPID, JICallBuilder obj, int refcount) throws JIException {
        this.updateReferenceForIPID(IPID, refcount);
        this.getStub2().addRef_ReleaseRef(obj);
    }

    private void updateReferenceForIPID(String ipid, int refcount) {
        int newCount;
        Integer value = (Integer)this.mapOfIPIDsVsRefcounts.get(ipid);
        if (value == null) {
            if (refcount < 0) {
                if (JISystem.getLogger().isLoggable(Level.INFO)) {
                    JISystem.getLogger().info("[updateReferenceForIPID] Released IPID not found: " + ipid);
                }
                return;
            }
            value = new Integer(0);
        }
        if ((newCount = value + refcount) > 0) {
            this.mapOfIPIDsVsRefcounts.put(ipid, new Integer(newCount));
        } else {
            this.mapOfIPIDsVsRefcounts.remove(ipid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWeakReference(IJIComObject comObject, byte[] oid) {
        IPID_SessionID_Holder holder = new IPID_SessionID_Holder(comObject.getIpid(), this.getSessionIdentifier(), false, oid);
        Map map = mapOfObjects;
        synchronized (map) {
            mapOfObjects.put(new WeakReference<IJIComObject>(comObject, referenceQueueOfCOMObjects), holder);
        }
        map = this.mapOfIPIDsVsWeakReferences;
        synchronized (map) {
            Integer count = (Integer)this.mapOfIPIDsVsWeakReferences.get(comObject.getIpid());
            if (count == null) {
                count = new Integer(0);
            }
            this.mapOfIPIDsVsWeakReferences.put(comObject.getIpid(), new Integer(count + 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int removeWeakReference(String ipid) {
        if (JISystem.getLogger().isLoggable(Level.FINEST)) {
            JISystem.getLogger().finest("Dumping mapOfIPIDsVsWeakReferences " + this.mapOfIPIDsVsWeakReferences.toString());
        }
        int weakRefsRemaining = 0;
        Map map = this.mapOfIPIDsVsWeakReferences;
        synchronized (map) {
            Integer count = (Integer)this.mapOfIPIDsVsWeakReferences.get(ipid);
            if (count == null) {
                weakRefsRemaining = 0;
            } else {
                weakRefsRemaining = count - 1;
                if (weakRefsRemaining > 0) {
                    this.mapOfIPIDsVsWeakReferences.put(ipid, new Integer(weakRefsRemaining));
                } else {
                    this.mapOfIPIDsVsWeakReferences.remove(ipid);
                }
            }
        }
        return weakRefsRemaining;
    }

    static void debug_addIpids(String ipid, int num) {
    }

    static void debug_delIpids(String ipid, int num) {
    }

    private void addToSession(String IPID, byte[] oid, boolean dontping) {
        JIObjectId joid = new JIObjectId(oid, dontping);
        JIComOxidRuntime.addUpdateOXIDs(this, IPID, joid);
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().info("[addToSession] Adding IPID: " + IPID + " to session: " + this.getSessionIdentifier());
        }
    }

    void releaseRef(String IPID) throws JIException {
        this.releaseRef(IPID, 5);
    }

    void releaseRef(String IPID, int numinstances) throws JIException {
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().info("releaseRef:Reclaiming from Session: " + this.getSessionIdentifier() + " , the IPID: " + IPID + ", numinstances is " + numinstances);
        }
        JICallBuilder obj = new JICallBuilder(true);
        obj.setParentIpid(IPID);
        obj.setOpnum(2);
        obj.addInParamAsShort((short)1, 0);
        JIArray array = new JIArray(new UUID[]{new UUID(IPID)}, true);
        obj.addInParamAsArray(array, 0);
        obj.addInParamAsInt(numinstances, 0);
        obj.addInParamAsInt(0, 0);
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().warning("releaseRef: Releasing numinstances " + numinstances + " references of IPID: " + IPID + " session: " + this.getSessionIdentifier());
            JISession.debug_delIpids(IPID, numinstances);
        }
        this.addRef_ReleaseRef(IPID, obj, -5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDereferencedIpids(String IPID) {
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().info("addDereferencedIpids for session : " + this.getSessionIdentifier() + " , IPID is: " + IPID);
        }
        Object object = mutex;
        synchronized (object) {
            if (!this.listOfDeferencedIpids.contains(IPID)) {
                this.listOfDeferencedIpids.add(IPID);
            }
        }
    }

    private void releaseRefs(JIArray arrayOfStructs, boolean fromDestroy) throws JIException {
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().info("In releaseRefs for session : " + this.getSessionIdentifier() + " , array length is: " + (short)((Object[])arrayOfStructs.getArrayInstance()).length);
        }
        JICallBuilder obj = new JICallBuilder(true);
        obj.setOpnum(2);
        obj.addInParamAsShort((short)((Object[])arrayOfStructs.getArrayInstance()).length, 0);
        obj.addInParamAsArray(arrayOfStructs, 0);
        obj.fromDestroySession = fromDestroy;
        this.stub.addRef_ReleaseRef(obj);
    }

    private JIStruct prepareForReleaseRef(String IPID) throws JIException {
        Integer refcount = (Integer)this.mapOfIPIDsVsRefcounts.get(IPID);
        int releaseCount = 10;
        if (refcount != null) {
            releaseCount = refcount;
        }
        return this.prepareForReleaseRef(IPID, releaseCount);
    }

    private JIStruct prepareForReleaseRef(String IPID, int refcount) throws JIException {
        JIStruct remInterface = new JIStruct();
        remInterface.addMember(new UUID(IPID));
        remInterface.addMember(new Integer(refcount));
        remInterface.addMember(new Integer(0));
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().warning("prepareForReleaseRef: Releasing " + refcount + "references of IPID: " + IPID + " session: " + this.getSessionIdentifier());
            JISession.debug_delIpids(IPID, refcount);
        }
        this.updateReferenceForIPID(IPID, -1 * refcount);
        return remInterface;
    }

    public String getUserName() {
        return this.authInfo == null ? this.username : this.authInfo.getUserName();
    }

    String getPassword() {
        return this.authInfo == null ? this.password : this.authInfo.getPassword();
    }

    public String getDomain() {
        return this.authInfo == null ? this.domain : this.authInfo.getDomain();
    }

    public int getSessionIdentifier() {
        return this.sessionIdentifier;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof JISession)) {
            return false;
        }
        JISession temp = (JISession)obj;
        return temp.sessionIdentifier == this.sessionIdentifier;
    }

    public int hashCode() {
        return this.sessionIdentifier;
    }

    protected void finalize() {
        block2: {
            try {
                JISession.destroySession(this);
            }
            catch (JIException e) {
                if (!JISystem.getLogger().isLoggable(Level.FINEST)) break block2;
                JISystem.getLogger().finest("Exception in finalize when destroying session " + e.getMessage());
            }
        }
    }

    synchronized IJIUnreferenced getUnreferencedHandler(String ipid) {
        return (IJIUnreferenced)this.mapOfUnreferencedHandlers.get(ipid);
    }

    synchronized void registerUnreferencedHandler(String ipid, IJIUnreferenced unreferenced) {
        this.mapOfUnreferencedHandlers.put(ipid, unreferenced);
    }

    synchronized void unregisterUnreferencedHandler(String ipid) {
        this.mapOfUnreferencedHandlers.remove(ipid);
    }

    public void setGlobalSocketTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getGlobalSocketTimeout() {
        return this.timeout;
    }

    public void useSessionSecurity(boolean enable) {
        this.useSessionSecurity = enable;
    }

    public void useNTLMv2(boolean enable) {
        this.useNTLMv2 = enable;
    }

    public boolean isSessionSecurityEnabled() {
        return !this.isSSO & this.useSessionSecurity;
    }

    public boolean isNTLMv2Enabled() {
        return !this.isSSO & this.useNTLMv2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void linkTwoSessions(JISession src, JISession target) {
        if (src.sessionInDestroy || target.sessionInDestroy) {
            return;
        }
        if (src.equals(target)) {
            return;
        }
        Object object = mutex;
        synchronized (object) {
            if (!src.links.contains(target)) {
                src.links.add(target);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unLinkSession(JISession src, JISession tobeunlinked) {
        if (src.sessionInDestroy) {
            return;
        }
        if (src.equals(tobeunlinked)) {
            return;
        }
        Object object = mutex;
        synchronized (object) {
            src.links.remove(tobeunlinked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JISession resolveSessionForOxid(JIOxid oxid) {
        Object object = mutex;
        synchronized (object) {
            return (JISession)mapOfOxidsVsJISessions.get(oxid);
        }
    }

    boolean isSessionInDestroy() {
        return this.sessionInDestroy;
    }

    public void registerCustomMarshallerUnMarshallerTemplate(String CLSID, JIComCustomMarshallerUnMarshaller customClass) {
        mapOfCustomCLSIDs.put(CLSID.toLowerCase(), customClass);
    }

    JIComCustomMarshallerUnMarshaller getCustomMarshallerUnMarshallerTemplate(String CLSID) {
        return mapOfCustomCLSIDs.get(CLSID.toLowerCase());
    }

    private static class IPID_SessionID_Holder {
        public final String IPID;
        public final Integer sessionID;
        public final boolean isOnlySessionIDPresent;
        public final byte[] oid;

        private IPID_SessionID_Holder(String IPID, int sessionID, boolean isOnlySessionId, byte[] oid) {
            this.IPID = IPID;
            this.isOnlySessionIDPresent = isOnlySessionId;
            this.sessionID = new Integer(sessionID);
            this.oid = oid;
        }
    }

    private static class Release_References_TimerTask
    extends TimerTask {
        private Release_References_TimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                List listOfSessionsClone = null;
                Object object = mutex;
                synchronized (object) {
                    listOfSessionsClone = (List)listOfSessions.clone();
                }
                int i = 0;
                while (i < listOfSessionsClone.size()) {
                    JISession session = (JISession)listOfSessionsClone.get(i);
                    if (JISystem.getLogger().isLoggable(Level.INFO)) {
                        JISystem.getLogger().info("Release_References_TimerTask:[RUN] Ipid Vs Count Map size " + session.mapOfIPIDsVsRefcounts.size() + " listOfDeferencedIpids size " + session.listOfDeferencedIpids.size());
                        JISystem.getLogger().info("Release_References_TimerTask:[RUN] Session:  " + session.getSessionIdentifier() + " , listOfDeferencedIpids: " + session.listOfDeferencedIpids);
                    }
                    ArrayList<JIStruct> listToKill = new ArrayList<JIStruct>();
                    List dereferencedIpids = null;
                    Object object2 = mutex;
                    synchronized (object2) {
                        dereferencedIpids = (List)((ArrayList)session.listOfDeferencedIpids).clone();
                    }
                    int j22 = 0;
                    while (j22 < dereferencedIpids.size()) {
                        block20: {
                            try {
                                String ipid = (String)dereferencedIpids.get(j22);
                                listToKill.add(session.prepareForReleaseRef(ipid));
                            }
                            catch (JIException e) {
                                if (!JISystem.getLogger().isLoggable(Level.INFO)) break block20;
                                JISystem.getLogger().info("Release_References_TimerTask:[RUN] Exception preparing for release " + e);
                            }
                        }
                        ++j22;
                    }
                    Object j22 = mutex;
                    synchronized (j22) {
                        session.listOfDeferencedIpids.removeAll(dereferencedIpids);
                    }
                    dereferencedIpids.clear();
                    if (JISystem.getLogger().isLoggable(Level.INFO)) {
                        JISystem.getLogger().info("Release_References_TimerTask:[RUN] Ipid Vs Count Map size after preparing release " + session.mapOfIPIDsVsRefcounts.size());
                    }
                    if (listToKill.size() > 0) {
                        JIArray array = new JIArray(listToKill.toArray(new JIStruct[listToKill.size()]), true);
                        try {
                            session.releaseRefs(array, false);
                        }
                        catch (JIException e) {
                            JISystem.getLogger().logp(Level.SEVERE, "JISession", "Release_References_TimerTask:run()", "Exception in internal GC", e);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                JISystem.getLogger().logp(Level.SEVERE, "JISession", "Release_References_TimerTask:run()", "Exception in internal GC", e);
            }
        }
    }
}

