/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.Serializable;
import ndr.NdrException;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.JIMarshalUnMarshalHelper;
import org.jinterop.dcom.core.JIObjectId;
import org.jinterop.dcom.core.JIOxid;
import rpc.core.UUID;

final class JIStdObjRef
implements Serializable {
    private static final long serialVersionUID = 7714589108476632990L;
    private int flags = 0;
    private int publicRefs = -1;
    private byte[] oxid = null;
    private byte[] oid = null;
    private String ipidOfthisObjectRef = null;

    private JIStdObjRef() {
    }

    JIStdObjRef(String ipid, JIOxid oxid, JIObjectId oid) {
        this.ipidOfthisObjectRef = ipid;
        this.oxid = oxid.getOXID();
        this.oid = oid.getOID();
        this.publicRefs = 5;
    }

    JIStdObjRef(String ipid) {
        this.ipidOfthisObjectRef = ipid;
        this.flags = 0;
        this.oxid = new byte[8];
        this.oid = new byte[8];
        this.publicRefs = 0;
    }

    static JIStdObjRef decode(NetworkDataRepresentation ndr) {
        JIStdObjRef objRef = new JIStdObjRef();
        objRef.flags = ndr.readUnsignedLong();
        objRef.publicRefs = ndr.readUnsignedLong();
        objRef.oxid = JIMarshalUnMarshalHelper.readOctetArrayLE(ndr, 8);
        objRef.oid = JIMarshalUnMarshalHelper.readOctetArrayLE(ndr, 8);
        try {
            UUID ipid2 = new UUID();
            ipid2.decode(ndr, ndr.getBuffer());
            objRef.ipidOfthisObjectRef = ipid2.toString();
        }
        catch (NdrException e) {
            JISystem.getLogger().throwing("JIStdObjRef", "decode", e);
        }
        return objRef;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getPublicRefs() {
        return this.publicRefs;
    }

    public byte[] getOxid() {
        return this.oxid;
    }

    public byte[] getObjectId() {
        return this.oid;
    }

    public String getIpid() {
        return this.ipidOfthisObjectRef;
    }

    public void encode(NetworkDataRepresentation ndr) {
        ndr.writeUnsignedLong(this.flags);
        ndr.writeUnsignedLong(this.publicRefs);
        JIMarshalUnMarshalHelper.writeOctetArrayLE(ndr, this.oxid);
        JIMarshalUnMarshalHelper.writeOctetArrayLE(ndr, this.oid);
        try {
            UUID ipid = new UUID(this.ipidOfthisObjectRef);
            ipid.encode(ndr, ndr.getBuffer());
        }
        catch (NdrException e) {
            JISystem.getLogger().throwing("JIStdObjRef", "encode", e);
        }
    }

    public String toString() {
        String retVal = "IPID: " + this.ipidOfthisObjectRef;
        return retVal;
    }
}

