/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.test;

import java.net.UnknownHostException;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JICallBuilder;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIProgId;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.JIObjectFactory;
import org.jinterop.dcom.impls.automation.IJIDispatch;

public class MSOutLookExpressContacts {
    JISession session = null;
    JIComServer comServer = null;

    MSOutLookExpressContacts(String[] args) throws UnknownHostException, JIException {
        this.session = JISession.createSession(args[1], args[2], args[3]);
        this.comServer = new JIComServer(JIProgId.valueOf("Outlook.Application"), args[0], this.session);
    }

    void doStuff() throws JIException {
        IJIComObject unknown = this.comServer.createInstance();
        IJIComObject application = unknown.queryInterface("00063001-0000-0000-C000-000000000046");
        JICallBuilder callObject = new JICallBuilder(!application.isDispatchSupported());
        callObject.setOpnum(12);
        callObject.addInParamAsString("MAPI", 1);
        callObject.addOutParamAsType(IJIComObject.class, 0);
        Object[] res = application.call(callObject);
        IJIComObject namespace = JIObjectFactory.narrowObject((IJIComObject)res[0]);
        callObject = new JICallBuilder();
        callObject.setOpnum(16);
        callObject.addOutParamAsType(IJIComObject.class, 0);
        res = namespace.call(callObject);
        if (res[0] == null) {
            System.out.println("user cancelled request");
            return;
        }
        IJIComObject folder = JIObjectFactory.narrowObject((IJIComObject)res[0]);
        callObject = new JICallBuilder();
        callObject.setOpnum(4);
        callObject.addOutParamAsType(Integer.class, 0);
        res = folder.call(callObject);
        if ((Integer)res[0] != 2) {
            System.out.println("Invalid folder selected, this is not a \"contact\" folder , please reselect..");
            return;
        }
        callObject.reInit();
        callObject.setOpnum(10);
        callObject.addOutParamAsType(IJIComObject.class, 0);
        res = folder.call(callObject);
        if (res[0] == null) {
            System.out.println("Unable to get Contact Items.");
            return;
        }
        IJIComObject items = JIObjectFactory.narrowObject((IJIComObject)res[0]);
        callObject = new JICallBuilder();
        callObject.setOpnum(12);
        callObject.addOutParamAsType(IJIComObject.class, 0);
        res = items.call(callObject);
        while (res[0] != null) {
            String details = null;
            IJIDispatch contactItem = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)res[0]);
            JIVariant res2 = contactItem.get("FullName");
            details = res2.getObjectAsString().getString();
            res2 = contactItem.get("Email1Address");
            details = String.valueOf(details) + "<" + res2.getObjectAsString().getString() + ">";
            System.out.println(details);
            callObject = new JICallBuilder();
            callObject.setOpnum(14);
            callObject.addOutParamAsType(IJIComObject.class, 0);
            res = items.call(callObject);
        }
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Please provide address domain username password");
            return;
        }
        JISystem.setAutoRegisteration(true);
        try {
            MSOutLookExpressContacts outlookMessages = new MSOutLookExpressContacts(args);
            outlookMessages.doStuff();
            JISession.destroySession(outlookMessages.session);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (JIException e) {
            e.printStackTrace();
        }
    }
}

