/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Properties;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import ndr.NdrBuffer;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.transport.JIComEndpoint;
import org.jinterop.dcom.transport.niosupport.ChannelListener;
import org.jinterop.dcom.transport.niosupport.ChannelWrapper;
import org.jinterop.dcom.transport.niosupport.ChannelWrapperFactory;
import org.jinterop.dcom.transport.niosupport.SelectorManager;
import rpc.Endpoint;
import rpc.ProviderException;
import rpc.RpcException;
import rpc.Transport;
import rpc.core.PresentationSyntax;

final class JIComTransport
implements Transport {
    public static final String PROTOCOL = "ncacn_ip_tcp";
    private static final String LOCALHOST;
    private static final long DEFAULT_READ_READY_HANDOFF_TIMEOUT_SECS = 30L;
    private static Object HANDOFF;
    private Properties properties;
    private String host;
    private int port;
    private boolean attached;
    private ChannelWrapper channelWrapper;
    private final SelectorManager selectorManager;
    private final SynchronousQueue<Object> readReadyHandoff = new SynchronousQueue();
    private long readReadyHandoffTimeoutSecs = 30L;

    static {
        HANDOFF = new Object();
        String localhost = null;
        try {
            localhost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        LOCALHOST = localhost;
    }

    public JIComTransport(String address, SelectorManager selectorManager, Properties properties) throws ProviderException {
        this.selectorManager = selectorManager;
        this.properties = properties;
        this.parse(address);
    }

    private void parse(String address) throws ProviderException {
        if (address == null) {
            throw new ProviderException("Null address.");
        }
        if (!address.startsWith("ncacn_ip_tcp:")) {
            throw new ProviderException("Not an ncacn_ip_tcp address.");
        }
        int index = (address = address.substring(13)).indexOf(91);
        if (index == -1) {
            throw new ProviderException("No port specifier present.");
        }
        String server = address.substring(0, index);
        if ((index = (address = address.substring(index + 1)).indexOf(93)) == -1) {
            throw new ProviderException("Port specifier not terminated.");
        }
        address = address.substring(0, index);
        if ("".equals(server)) {
            server = LOCALHOST;
        }
        try {
            this.port = Integer.parseInt(address);
        }
        catch (Exception ex) {
            throw new ProviderException("Invalid port specifier.");
        }
        this.host = server;
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Endpoint attach(PresentationSyntax syntax) throws IOException {
        if (this.attached) {
            throw new RpcException("Transport already attached.");
        }
        try {
            if (JISystem.getLogger().isLoggable(Level.FINEST)) {
                JISystem.getLogger().finest("Opening socket on " + new InetSocketAddress(InetAddress.getByName(this.host), this.port));
            }
            SocketChannel channel = SocketChannel.open();
            channel.connect(new InetSocketAddress(InetAddress.getByName(this.host), this.port));
            this.channelWrapper = ChannelWrapperFactory.createChannelWrapper(this.selectorManager, channel, new ChannelListener(){

                @Override
                public void readReady() {
                    try {
                        if (!JIComTransport.this.readReadyHandoff.offer(HANDOFF, JIComTransport.this.readReadyHandoffTimeoutSecs, TimeUnit.SECONDS) && JISystem.getLogger().isLoggable(Level.FINE)) {
                            JISystem.getLogger().fine("Timeout while awaiting read ready handoff to " + JIComTransport.this);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            });
            channel.configureBlocking(false);
            this.attached = true;
            channel.socket().setKeepAlive(true);
            return new JIComEndpoint(this, syntax);
        }
        catch (IOException ex) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
    }

    public void close() throws IOException {
        try {
            if (this.channelWrapper != null) {
                if (JISystem.getLogger().isLoggable(Level.FINEST)) {
                    JISystem.getLogger().finest("Closing " + this.channelWrapper);
                }
                this.channelWrapper.close();
            }
        }
        finally {
            this.attached = false;
            this.channelWrapper = null;
        }
    }

    public void send(NdrBuffer buffer) throws IOException {
        if (!this.attached) {
            throw new RpcException("Transport not attached.");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer.getBuffer(), 0, buffer.getLength());
        this.channelWrapper.writeAll(byteBuffer);
    }

    public void receive(NdrBuffer buffer) throws IOException {
        if (!this.attached) {
            throw new RpcException("Transport not attached.");
        }
        int timeoutMillis = this.getCurentTimeoutMillis();
        this.channelWrapper.registerForRead();
        try {
            Object handoffResult = timeoutMillis == 0 ? this.readReadyHandoff.take() : this.readReadyHandoff.poll(timeoutMillis, TimeUnit.MILLISECONDS);
            if (handoffResult == null) {
                throw new SocketTimeoutException();
            }
            ByteBuffer wrapped = ByteBuffer.wrap(buffer.getBuffer());
            buffer.length = this.channelWrapper.read(wrapped);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while reading");
        }
    }

    private int getCurentTimeoutMillis() {
        int timeout = 0;
        try {
            timeout = Integer.parseInt(this.properties.getProperty("rpc.socketTimeout", "0"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return timeout;
    }

    public String toString() {
        return "Transport to " + this.host + ":" + this.port;
    }
}

