/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.behaviors;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.HiddenImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Intercepted<T>
extends HiddenImplementation {
    private final Map<Class, Object> pres = new HashMap<Class, Object>();
    private final Map<Class, Object> posts = new HashMap<Class, Object>();
    private Controller controller = new ControllerWrapper(new InterceptorThreadLocal());

    public Intercepted(ComponentAdapter delegate) {
        super(delegate);
    }

    public void addPreInvocation(Class type, Object interceptor) {
        this.pres.put(type, interceptor);
    }

    public void addPostInvocation(Class type, Object interceptor) {
        this.posts.put(type, interceptor);
    }

    @Override
    protected Object invokeMethod(Object componentInstance, Method method, Object[] args, PicoContainer container) throws Throwable {
        try {
            this.controller.clear();
            this.controller.instance(componentInstance);
            Object pre = this.pres.get(method.getDeclaringClass());
            if (pre != null) {
                Object rv = method.invoke(pre, args);
                if (this.controller.isVetoed()) {
                    return rv;
                }
            }
            Object result = method.invoke(componentInstance, args);
            this.controller.setOriginalRetVal(result);
            Object post = this.posts.get(method.getDeclaringClass());
            if (post != null) {
                Object rv = method.invoke(post, args);
                if (this.controller.isOverridden()) {
                    return rv;
                }
            }
            return result;
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    public Controller getController() {
        return this.controller;
    }

    @Override
    public String getDescriptor() {
        return "Intercepted";
    }

    public class ControllerWrapper
    implements Controller {
        private final ThreadLocal threadLocal;

        public ControllerWrapper(ThreadLocal threadLocal) {
            this.threadLocal = threadLocal;
        }

        public void veto() {
            ((Controller)this.threadLocal.get()).veto();
        }

        public void clear() {
            ((Controller)this.threadLocal.get()).clear();
        }

        public boolean isVetoed() {
            return ((Controller)this.threadLocal.get()).isVetoed();
        }

        public void setOriginalRetVal(Object retVal) {
            ((Controller)this.threadLocal.get()).setOriginalRetVal(retVal);
        }

        public Object getOriginalRetVal() {
            return ((Controller)this.threadLocal.get()).getOriginalRetVal();
        }

        public boolean isOverridden() {
            return ((Controller)this.threadLocal.get()).isOverridden();
        }

        public void instance(Object instance) {
            ((Controller)this.threadLocal.get()).instance(instance);
        }

        public void override() {
            ((Controller)this.threadLocal.get()).override();
        }
    }

    public static class ControllerImpl
    implements Controller {
        private boolean vetoed;
        private Object retVal;
        private boolean overridden;
        private Object instance;

        public void veto() {
            this.vetoed = true;
        }

        public void clear() {
            this.vetoed = false;
            this.overridden = false;
            this.retVal = null;
            this.instance = null;
        }

        public boolean isVetoed() {
            return this.vetoed;
        }

        public void setOriginalRetVal(Object retVal) {
            this.retVal = retVal;
        }

        public Object getOriginalRetVal() {
            return this.retVal;
        }

        public boolean isOverridden() {
            return this.overridden;
        }

        public void instance(Object instance) {
            this.instance = instance;
        }

        public void override() {
            this.overridden = true;
        }
    }

    public static interface Controller {
        public void veto();

        public void clear();

        public boolean isVetoed();

        public void setOriginalRetVal(Object var1);

        public boolean isOverridden();

        public void instance(Object var1);

        public Object getOriginalRetVal();

        public void override();
    }

    public static class InterceptorThreadLocal
    extends ThreadLocal
    implements Serializable {
        protected Object initialValue() {
            return new ControllerImpl();
        }
    }
}

