/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.containers;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.containers.AbstractDelegatingPicoContainer;
import org.picocontainer.containers.EmptyPicoContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLinePicoContainer
extends AbstractDelegatingPicoContainer {
    public CommandLinePicoContainer(String separator, String[] arguments) {
        this(separator, arguments, null);
    }

    public CommandLinePicoContainer(String separator, String[] arguments, PicoContainer parent) {
        super(new DefaultPicoContainer(parent));
        for (String argument : arguments) {
            this.processArgument(argument, separator);
        }
    }

    public CommandLinePicoContainer(String separator, StringReader argumentsProps) throws IOException {
        this(separator, argumentsProps, new String[0]);
    }

    public CommandLinePicoContainer(String separator, StringReader argumentProperties, String[] arguments) throws IOException {
        this(separator, argumentProperties, arguments, null);
    }

    public CommandLinePicoContainer(String separator, StringReader argumentProperties, String[] arguments, PicoContainer parent) throws IOException {
        super(new DefaultPicoContainer(parent));
        LineNumberReader lnr = new LineNumberReader(argumentProperties);
        String line = lnr.readLine();
        while (line != null) {
            this.processArgument(line, separator);
            line = lnr.readLine();
        }
        for (String argument : arguments) {
            this.processArgument(argument, separator);
        }
    }

    public CommandLinePicoContainer(String[] arguments) {
        this("=", arguments);
    }

    public CommandLinePicoContainer(String[] arguments, PicoContainer parent) {
        this("=", arguments, parent);
    }

    private void addConfig(String key, Object val) {
        if (this.getDelegate().getComponent(key) != null) {
            this.getDelegate().removeComponent(key);
        }
        this.getDelegate().addConfig(key, val);
    }

    @Override
    public <T> T getComponent(Class<T> componentType) {
        return null;
    }

    @Override
    public <T> List<ComponentAdapter<T>> getComponentAdapters(Class<T> componentType) {
        return null;
    }

    @Override
    public PicoContainer getParent() {
        return new EmptyPicoContainer();
    }

    private void processArgument(String argument, String separator) {
        String[] kvs = argument.split(separator);
        if (kvs.length == 2) {
            this.addConfig(kvs[0], kvs[1]);
        } else if (kvs.length == 1) {
            this.addConfig(kvs[0], "true");
        } else if (kvs.length > 2) {
            throw new PicoCompositionException("Argument name'" + separator + "'value pair '" + argument + "' has too many '" + separator + "' characters");
        }
    }

    @Override
    public MutablePicoContainer getDelegate() {
        return (MutablePicoContainer)super.getDelegate();
    }

    public void setName(String s) {
        ((DefaultPicoContainer)this.getDelegate()).setName(s);
    }
}

