/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.injectors;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.injectors.AbstractInjector;
import org.picocontainer.injectors.ParameterNameBinding;
import org.picocontainer.injectors.SingleMemberInjector;
import org.picocontainer.lifecycle.NullLifecycleStrategy;
import org.picocontainer.monitors.NullComponentMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorInjector<T>
extends SingleMemberInjector<T> {
    private transient List<Constructor<T>> sortedMatchingConstructors;
    private transient AbstractInjector.ThreadLocalCyclicDependencyGuard<T> instantiationGuard;
    private boolean rememberChosenConstructor = true;
    private transient Constructor<T> chosenConstructor;

    public ConstructorInjector(Object componentKey, Class<?> componentImplementation, Parameter ... parameters) {
        this(componentKey, (Class)componentImplementation, parameters, (ComponentMonitor)new NullComponentMonitor(), (LifecycleStrategy)new NullLifecycleStrategy(), false);
    }

    public ConstructorInjector(Object componentKey, Class componentImplementation, Parameter[] parameters, ComponentMonitor monitor, LifecycleStrategy lifecycleStrategy, boolean useNames) throws AbstractInjector.NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters, monitor, lifecycleStrategy, useNames);
    }

    public ConstructorInjector(Object componentKey, Class componentImplementation, Parameter[] parameters, ComponentMonitor monitor, LifecycleStrategy lifecycleStrategy, boolean useNames, boolean rememberChosenCtor) throws AbstractInjector.NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters, monitor, lifecycleStrategy, useNames);
        this.rememberChosenConstructor = rememberChosenCtor;
    }

    protected Constructor<T> getGreediestSatisfiableConstructor(PicoContainer container) throws PicoCompositionException {
        HashSet<Constructor<T>> conflicts = new HashSet<Constructor<T>>();
        HashSet<List<Type>> unsatisfiableDependencyTypes = new HashSet<List<Type>>();
        if (this.sortedMatchingConstructors == null) {
            this.sortedMatchingConstructors = this.getSortedMatchingConstructors();
        }
        Constructor<T> greediestConstructor = null;
        int lastSatisfiableConstructorSize = -1;
        Type unsatisfiedDependencyType = null;
        for (Constructor<T> sortedMatchingConstructor : this.sortedMatchingConstructors) {
            boolean failedDependency = false;
            Type[] parameterTypes = sortedMatchingConstructor.getGenericParameterTypes();
            Annotation[] bindings = this.getBindings(sortedMatchingConstructor.getParameterAnnotations());
            Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(parameterTypes);
            for (int j = 0; j < currentParameters.length; ++j) {
                Type boxed = this.box(parameterTypes[j]);
                boolean un = this.useNames();
                if (currentParameters[j].isResolvable(container, this, boxed, new ParameterNameBinding(this.getParanamer(), this.getComponentImplementation(), sortedMatchingConstructor, j), un, bindings[j])) continue;
                unsatisfiableDependencyTypes.add(Arrays.asList(parameterTypes));
                unsatisfiedDependencyType = this.box(parameterTypes[j]);
                failedDependency = true;
                break;
            }
            if (greediestConstructor != null && parameterTypes.length != lastSatisfiableConstructorSize) {
                if (conflicts.isEmpty()) {
                    return greediestConstructor;
                }
                conflicts.add(sortedMatchingConstructor);
                continue;
            }
            if (!failedDependency && lastSatisfiableConstructorSize == parameterTypes.length) {
                conflicts.add(sortedMatchingConstructor);
                conflicts.add(greediestConstructor);
                continue;
            }
            if (failedDependency) continue;
            greediestConstructor = sortedMatchingConstructor;
            lastSatisfiableConstructorSize = parameterTypes.length;
        }
        if (!conflicts.isEmpty()) {
            throw new PicoCompositionException(conflicts.size() + " satisfiable constructors is too many for '" + this.getComponentImplementation() + "'. Constructor List:" + ((Object)conflicts).toString().replace(this.getComponentImplementation().getName(), "<init>").replace("public <i", "<i"));
        }
        if (greediestConstructor == null && !unsatisfiableDependencyTypes.isEmpty()) {
            throw new AbstractInjector.UnsatisfiableDependenciesException(this, unsatisfiedDependencyType, unsatisfiableDependencyTypes, container);
        }
        if (greediestConstructor == null) {
            HashSet<Constructor<T>> nonMatching = new HashSet<Constructor<T>>();
            for (Constructor<T> constructor : this.getConstructors()) {
                nonMatching.add(constructor);
            }
            throw new PicoCompositionException("Either the specified parameters do not match any of the following constructors: " + ((Object)nonMatching).toString() + "; OR the constructors were not accessible for '" + this.getComponentImplementation().getName() + "'");
        }
        return greediestConstructor;
    }

    @Override
    public T getComponentInstance(final PicoContainer container, Type into) throws PicoCompositionException {
        if (this.instantiationGuard == null) {
            this.instantiationGuard = new AbstractInjector.ThreadLocalCyclicDependencyGuard<T>(){

                @Override
                public T run() {
                    Constructor ctor = null;
                    try {
                        if (ConstructorInjector.this.chosenConstructor == null) {
                            ctor = ConstructorInjector.this.getGreediestSatisfiableConstructor(this.guardedContainer);
                        }
                        if (ConstructorInjector.this.rememberChosenConstructor) {
                            if (ConstructorInjector.this.chosenConstructor == null) {
                                ConstructorInjector.this.chosenConstructor = ctor;
                            } else {
                                ctor = ConstructorInjector.this.chosenConstructor;
                            }
                        }
                    }
                    catch (AbstractInjector.AmbiguousComponentResolutionException e) {
                        e.setComponent(ConstructorInjector.this.getComponentImplementation());
                        throw e;
                    }
                    ComponentMonitor componentMonitor = ConstructorInjector.this.currentMonitor();
                    try {
                        Object[] parameters = ConstructorInjector.this.getMemberArguments(this.guardedContainer, ctor);
                        ctor = componentMonitor.instantiating(container, ConstructorInjector.this, ctor);
                        if (ctor == null) {
                            throw new NullPointerException("Component Monitor " + componentMonitor + " returned a null constructor from method 'instantiating' after passing in " + ctor);
                        }
                        long startTime = System.currentTimeMillis();
                        Object inst = ConstructorInjector.this.instantiate(ctor, parameters);
                        componentMonitor.instantiated(container, ConstructorInjector.this, ctor, inst, parameters, System.currentTimeMillis() - startTime);
                        return inst;
                    }
                    catch (InvocationTargetException e) {
                        componentMonitor.instantiationFailed(container, ConstructorInjector.this, ctor, e);
                        if (e.getTargetException() instanceof RuntimeException) {
                            throw (RuntimeException)e.getTargetException();
                        }
                        if (e.getTargetException() instanceof Error) {
                            throw (Error)e.getTargetException();
                        }
                        throw new PicoCompositionException(e.getTargetException());
                    }
                    catch (InstantiationException e) {
                        return ConstructorInjector.this.caughtInstantiationException(componentMonitor, ctor, e, container);
                    }
                    catch (IllegalAccessException e) {
                        return ConstructorInjector.this.caughtIllegalAccessException(componentMonitor, ctor, e, container);
                    }
                }
            };
        }
        this.instantiationGuard.setGuardedContainer(container);
        return this.instantiationGuard.observe(this.getComponentImplementation());
    }

    protected T instantiate(Constructor<T> constructor, Object[] parameters) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        T inst = this.newInstance(constructor, parameters);
        return inst;
    }

    @Override
    public void decorateComponentInstance(PicoContainer container, Type into, T instance) {
    }

    protected Object[] getMemberArguments(PicoContainer container, Constructor ctor) {
        return super.getMemberArguments(container, ctor, ctor.getGenericParameterTypes(), this.getBindings(ctor.getParameterAnnotations()));
    }

    private List<Constructor<T>> getSortedMatchingConstructors() {
        Constructor<T>[] allConstructors;
        ArrayList<Constructor<T>> matchingConstructors = new ArrayList<Constructor<T>>();
        for (Constructor<T> constructor : allConstructors = this.getConstructors()) {
            if (this.parameters != null && constructor.getParameterTypes().length != this.parameters.length || (constructor.getModifiers() & 1) == 0) continue;
            matchingConstructors.add(constructor);
        }
        if (this.parameters == null) {
            Collections.sort(matchingConstructors, new Comparator<Constructor>(){

                @Override
                public int compare(Constructor arg0, Constructor arg1) {
                    return arg1.getParameterTypes().length - arg0.getParameterTypes().length;
                }
            });
        }
        return matchingConstructors;
    }

    private Constructor<T>[] getConstructors() {
        return AccessController.doPrivileged(new PrivilegedAction<Constructor<T>[]>(){

            @Override
            public Constructor<T>[] run() {
                return ConstructorInjector.this.getComponentImplementation().getDeclaredConstructors();
            }
        });
    }

    @Override
    public void verify(final PicoContainer container) throws PicoCompositionException {
        if (this.verifyingGuard == null) {
            this.verifyingGuard = new AbstractInjector.ThreadLocalCyclicDependencyGuard(){

                public Object run() {
                    Constructor constructor = ConstructorInjector.this.getGreediestSatisfiableConstructor(this.guardedContainer);
                    Type[] parameterTypes = constructor.getParameterTypes();
                    Parameter[] currentParameters = ConstructorInjector.this.parameters != null ? ConstructorInjector.this.parameters : ConstructorInjector.this.createDefaultParameters(parameterTypes);
                    for (int i = 0; i < currentParameters.length; ++i) {
                        currentParameters[i].verify(container, ConstructorInjector.this, ConstructorInjector.this.box(parameterTypes[i]), new ParameterNameBinding(ConstructorInjector.this.getParanamer(), ConstructorInjector.this.getComponentImplementation(), constructor, i), ConstructorInjector.this.useNames(), ConstructorInjector.this.getBindings(constructor.getParameterAnnotations())[i]);
                    }
                    return null;
                }
            };
        }
        this.verifyingGuard.setGuardedContainer(container);
        this.verifyingGuard.observe(this.getComponentImplementation());
    }

    @Override
    public String getDescriptor() {
        return "ConstructorInjector-";
    }
}

