/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.injectors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.injectors.AbstractInjector;
import org.picocontainer.injectors.ParameterNameBinding;
import org.picocontainer.injectors.SingleMemberInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInjector<T>
extends SingleMemberInjector<T> {
    private transient AbstractInjector.ThreadLocalCyclicDependencyGuard instantiationGuard;
    private final String methodName;

    public MethodInjector(Object componentKey, Class componentImplementation, Parameter[] parameters, ComponentMonitor monitor, LifecycleStrategy lifecycleStrategy, String methodName, boolean useNames) throws AbstractInjector.NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters, monitor, lifecycleStrategy, useNames);
        this.methodName = methodName;
    }

    protected Method getInjectorMethod() {
        Method[] methods = new Method[]{};
        try {
            methods = super.getComponentImplementation().getMethods();
        }
        catch (AbstractInjector.AmbiguousComponentResolutionException e) {
            e.setComponent(this.getComponentImplementation());
            throw e;
        }
        for (Method method : methods) {
            if (!method.getName().equals(this.methodName)) continue;
            return method;
        }
        return null;
    }

    @Override
    public T getComponentInstance(final PicoContainer container, Type into) throws PicoCompositionException {
        if (this.instantiationGuard == null) {
            this.instantiationGuard = new AbstractInjector.ThreadLocalCyclicDependencyGuard(){

                public Object run() {
                    Method method = MethodInjector.this.getInjectorMethod();
                    Object inst = null;
                    ComponentMonitor componentMonitor = MethodInjector.this.currentMonitor();
                    try {
                        componentMonitor.instantiating(container, MethodInjector.this, null);
                        long startTime = System.currentTimeMillis();
                        Object[] parameters = null;
                        inst = MethodInjector.this.getComponentImplementation().newInstance();
                        if (method != null) {
                            parameters = MethodInjector.this.getMemberArguments(this.guardedContainer, method);
                            MethodInjector.this.invokeMethod(method, parameters, inst, container);
                        }
                        componentMonitor.instantiated(container, MethodInjector.this, null, inst, parameters, System.currentTimeMillis() - startTime);
                        return inst;
                    }
                    catch (InstantiationException e) {
                        return MethodInjector.this.caughtInstantiationException(componentMonitor, null, e, container);
                    }
                    catch (IllegalAccessException e) {
                        return MethodInjector.this.caughtIllegalAccessException(componentMonitor, method, inst, e);
                    }
                }
            };
        }
        this.instantiationGuard.setGuardedContainer(container);
        return this.instantiationGuard.observe(this.getComponentImplementation());
    }

    protected Object[] getMemberArguments(PicoContainer container, Method method) {
        return super.getMemberArguments(container, method, method.getParameterTypes(), this.getBindings(method.getParameterAnnotations()));
    }

    @Override
    public void decorateComponentInstance(final PicoContainer container, Type into, final T instance) {
        if (this.instantiationGuard == null) {
            this.instantiationGuard = new AbstractInjector.ThreadLocalCyclicDependencyGuard(){

                public Object run() {
                    Method method = MethodInjector.this.getInjectorMethod();
                    Object inst = null;
                    Object[] parameters = null;
                    parameters = MethodInjector.this.getMemberArguments(this.guardedContainer, method);
                    return MethodInjector.this.invokeMethod(method, parameters, instance, container);
                }
            };
        }
        this.instantiationGuard.setGuardedContainer(container);
        this.instantiationGuard.observe(this.getComponentImplementation());
    }

    private Object invokeMethod(Method method, Object[] parameters, T instance, PicoContainer container) {
        try {
            return method.invoke(instance, parameters);
        }
        catch (IllegalAccessException e) {
            return this.caughtIllegalAccessException(this.currentMonitor(), method, instance, e);
        }
        catch (InvocationTargetException e) {
            this.currentMonitor().instantiationFailed(container, this, null, e);
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            return null;
        }
    }

    @Override
    public void verify(final PicoContainer container) throws PicoCompositionException {
        if (this.verifyingGuard == null) {
            this.verifyingGuard = new AbstractInjector.ThreadLocalCyclicDependencyGuard(){

                public Object run() {
                    Method method = MethodInjector.this.getInjectorMethod();
                    Type[] parameterTypes = method.getParameterTypes();
                    Parameter[] currentParameters = MethodInjector.this.parameters != null ? MethodInjector.this.parameters : MethodInjector.this.createDefaultParameters(parameterTypes);
                    for (int i = 0; i < currentParameters.length; ++i) {
                        currentParameters[i].verify(container, MethodInjector.this, parameterTypes[i], new ParameterNameBinding(MethodInjector.this.getParanamer(), MethodInjector.this.getComponentImplementation(), method, i), MethodInjector.this.useNames(), MethodInjector.this.getBindings(method.getParameterAnnotations())[i]);
                    }
                    return null;
                }
            };
        }
        this.verifyingGuard.setGuardedContainer(container);
        this.verifyingGuard.observe(this.getComponentImplementation());
    }

    @Override
    public String getDescriptor() {
        return "MethodInjector-";
    }

    public static class ByReflectionMethod
    extends MethodInjector {
        private final Method injectionMethod;

        public ByReflectionMethod(Object componentKey, Class componentImplementation, Parameter[] parameters, ComponentMonitor monitor, LifecycleStrategy lifecycleStrategy, Method injectionMethod, boolean useNames) throws AbstractInjector.NotConcreteRegistrationException {
            super(componentKey, componentImplementation, parameters, monitor, lifecycleStrategy, null, useNames);
            this.injectionMethod = injectionMethod;
        }

        protected Method getInjectorMethod() {
            if (this.injectionMethod.getDeclaringClass().isAssignableFrom(super.getComponentImplementation())) {
                return this.injectionMethod;
            }
            return null;
        }
    }
}

