/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.lifecycle;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.PicoLifecycleException;
import org.picocontainer.lifecycle.AbstractMonitoringLifecycleStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaEE5LifecycleStrategy
extends AbstractMonitoringLifecycleStrategy {
    public JavaEE5LifecycleStrategy(ComponentMonitor monitor) {
        super(monitor);
    }

    @Override
    public void start(Object component) {
        this.doLifecycleMethod(component, PostConstruct.class);
    }

    @Override
    public void stop(Object component) {
    }

    @Override
    public void dispose(Object component) {
        this.doLifecycleMethod(component, PreDestroy.class);
    }

    private void doLifecycleMethod(Object component, Class<? extends Annotation> annotation) {
        Method[] methods = component.getClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.isAnnotationPresent(annotation)) continue;
            try {
                long str = System.currentTimeMillis();
                this.currentMonitor().invoking(null, null, method, component);
                method.invoke(component, new Object[0]);
                this.currentMonitor().invoked(null, null, method, component, System.currentTimeMillis() - str);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new PicoLifecycleException(method, component, e);
            }
            catch (InvocationTargetException e) {
                throw new PicoLifecycleException(method, component, e);
            }
        }
    }

    @Override
    public boolean hasLifecycle(Class<?> type) {
        Method[] methods = type.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.isAnnotationPresent(PreDestroy.class) && !method.isAnnotationPresent(PostConstruct.class)) continue;
            return true;
        }
        return false;
    }
}

