/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.battle.peer;

import java.awt.geom.Line2D;
import java.util.List;
import net.sf.robocode.battle.peer.RobotPeer;
import net.sf.robocode.peer.BulletStatus;
import robocode.BattleRules;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.control.snapshot.BulletState;
import robocode.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BulletPeer {
    private static final int EXPLOSION_LENGTH = 17;
    private static final int RADIUS = 3;
    protected final RobotPeer owner;
    private final BattleRules battleRules;
    private final int bulletId;
    protected RobotPeer victim;
    protected BulletState state;
    private double heading;
    protected double x;
    protected double y;
    private double lastX;
    private double lastY;
    protected double power;
    private double deltaX;
    private double deltaY;
    private final Line2D.Double boundingLine = new Line2D.Double();
    protected int frame;
    private final int color;
    protected int explosionImageIndex;

    public BulletPeer(RobotPeer owner, BattleRules battleRules, int bulletId) {
        this.owner = owner;
        this.battleRules = battleRules;
        this.bulletId = bulletId;
        this.state = BulletState.FIRED;
        this.color = owner.getBulletColor();
    }

    private void checkBulletCollision(List<BulletPeer> bullets) {
        for (BulletPeer b : bullets) {
            if (b == null || b == this || !b.isActive() || !this.intersect(b.boundingLine)) continue;
            this.state = BulletState.HIT_BULLET;
            b.setState(this.state);
            this.frame = 0;
            this.x = this.lastX;
            this.y = this.lastY;
            this.owner.addEvent((Event)new BulletHitBulletEvent(this.createBullet(), b.createBullet()));
            b.owner.addEvent((Event)new BulletHitBulletEvent(b.createBullet(), this.createBullet()));
            break;
        }
    }

    private Bullet createBullet() {
        return new Bullet(this.heading, this.x, this.y, this.power, this.owner == null ? null : this.owner.getName(), this.victim == null ? null : this.victim.getName(), this.isActive(), this.bulletId);
    }

    private BulletStatus createStatus() {
        return new BulletStatus(this.bulletId, this.x, this.y, this.victim == null ? null : this.victim.getName(), this.isActive());
    }

    private boolean intersect(Line2D.Double line) {
        double x1 = line.x1;
        double x2 = line.x2;
        double x3 = this.boundingLine.x1;
        double x4 = this.boundingLine.x2;
        double y1 = line.y1;
        double y2 = line.y2;
        double y3 = this.boundingLine.y1;
        double y4 = this.boundingLine.y2;
        double dx13 = x1 - x3;
        double dx21 = x2 - x1;
        double dx43 = x4 - x3;
        double dy13 = y1 - y3;
        double dy21 = y2 - y1;
        double dy43 = y4 - y3;
        double dn = dy43 * dx21 - dx43 * dy21;
        double ua = (dx43 * dy13 - dy43 * dx13) / dn;
        double ub = (dx21 * dy13 - dy21 * dx13) / dn;
        return ua >= 0.0 && ua <= 1.0 && ub >= 0.0 && ub <= 1.0;
    }

    private void checkRobotCollision(List<RobotPeer> robots) {
        for (int i = 0; i < robots.size(); ++i) {
            double newY;
            double newX;
            boolean teamFire;
            RobotPeer robotPeer = robots.get(i);
            if (robotPeer == null || robotPeer == this.owner || robotPeer.isDead() || !robotPeer.getBoundingBox().intersectsLine(this.boundingLine)) continue;
            double damage = Rules.getBulletDamage((double)this.power);
            double score = damage;
            if (score > robotPeer.getEnergy()) {
                score = robotPeer.getEnergy();
            }
            robotPeer.updateEnergy(-damage);
            boolean bl = teamFire = this.owner.getTeamPeer() != null && this.owner.getTeamPeer() == robotPeer.getTeamPeer();
            if (!teamFire) {
                this.owner.getRobotStatistics().scoreBulletDamage(i, score);
            }
            if (robotPeer.getEnergy() <= 0.0 && robotPeer.isAlive()) {
                double bonus;
                robotPeer.kill();
                if (!teamFire && (bonus = this.owner.getRobotStatistics().scoreBulletKill(i)) > 0.0) {
                    this.owner.println("SYSTEM: Bonus for killing " + robotPeer.getName() + ": " + (int)(bonus + 0.5));
                }
            }
            this.owner.updateEnergy(Rules.getBulletHitBonus((double)this.power));
            HitByBulletEvent event = new HitByBulletEvent(Utils.normalRelativeAngle((double)(this.heading + Math.PI - robotPeer.getBodyHeading())), this.createBullet());
            robotPeer.addEvent((Event)event);
            this.state = BulletState.HIT_VICTIM;
            BulletHitEvent bhe = new BulletHitEvent(robotPeer.getName(), robotPeer.getEnergy(), this.createBullet());
            this.owner.addEvent((Event)bhe);
            this.frame = 0;
            this.victim = robotPeer;
            if (robotPeer.getBoundingBox().contains(this.lastX, this.lastY)) {
                newX = this.lastX;
                newY = this.lastY;
                this.setX(newX);
                this.setY(newY);
            } else {
                newX = this.x;
                newY = this.y;
            }
            this.deltaX = newX - robotPeer.getX();
            this.deltaY = newY - robotPeer.getY();
            break;
        }
    }

    private void checkWallCollision() {
        if (this.x - 3.0 <= 0.0 || this.y - 3.0 <= 0.0 || this.x + 3.0 >= (double)this.battleRules.getBattlefieldWidth() || this.y + 3.0 >= (double)this.battleRules.getBattlefieldHeight()) {
            this.state = BulletState.HIT_WALL;
            this.owner.addEvent((Event)new BulletMissedEvent(this.createBullet()));
        }
    }

    public int getBulletId() {
        return this.bulletId;
    }

    public int getFrame() {
        return this.frame;
    }

    public double getHeading() {
        return this.heading;
    }

    public RobotPeer getOwner() {
        return this.owner;
    }

    public double getPower() {
        return this.power;
    }

    public double getVelocity() {
        return Rules.getBulletSpeed((double)this.power);
    }

    public RobotPeer getVictim() {
        return this.victim;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getPaintX() {
        return this.state == BulletState.HIT_VICTIM && this.victim != null ? this.victim.getX() + this.deltaX : this.x;
    }

    public double getPaintY() {
        return this.state == BulletState.HIT_VICTIM && this.victim != null ? this.victim.getY() + this.deltaY : this.y;
    }

    public boolean isActive() {
        return this.state.getValue() <= BulletState.MOVING.getValue();
    }

    public BulletState getState() {
        return this.state;
    }

    public int getColor() {
        return this.color;
    }

    public void setHeading(double newHeading) {
        this.heading = newHeading;
    }

    public void setPower(double newPower) {
        this.power = newPower;
    }

    public void setVictim(RobotPeer newVictim) {
        this.victim = newVictim;
    }

    public void setX(double newX) {
        this.x = this.lastX = newX;
    }

    public void setY(double newY) {
        this.y = this.lastY = newY;
    }

    public void setState(BulletState newState) {
        this.state = newState;
    }

    public void update(List<RobotPeer> robots, List<BulletPeer> bullets) {
        if (this.isActive()) {
            this.updateMovement();
            if (bullets != null) {
                this.checkBulletCollision(bullets);
            }
            if (this.isActive()) {
                this.checkRobotCollision(robots);
            }
            if (this.isActive()) {
                this.checkWallCollision();
            }
        } else if (this.state == BulletState.HIT_VICTIM || this.state == BulletState.HIT_BULLET) {
            ++this.frame;
        }
        this.updateBulletState();
        this.owner.addBulletStatus(this.createStatus());
    }

    protected void updateBulletState() {
        switch (this.state) {
            case FIRED: {
                this.state = BulletState.MOVING;
                break;
            }
            case HIT_BULLET: 
            case HIT_VICTIM: 
            case EXPLODED: {
                if (this.frame < this.getExplosionLength()) break;
                this.state = BulletState.INACTIVE;
                break;
            }
            case HIT_WALL: {
                this.state = BulletState.INACTIVE;
            }
        }
    }

    private void updateMovement() {
        this.lastX = this.x;
        this.lastY = this.y;
        double v = this.getVelocity();
        this.x += v * Math.sin(this.heading);
        this.y += v * Math.cos(this.heading);
        this.boundingLine.setLine(this.lastX, this.lastY, this.x, this.y);
    }

    public void nextFrame() {
        ++this.frame;
    }

    public int getExplosionImageIndex() {
        return this.explosionImageIndex;
    }

    protected int getExplosionLength() {
        return 17;
    }

    public String toString() {
        return this.getOwner().getName() + " V" + this.getVelocity() + " *" + (int)this.power + " X" + (int)this.x + " Y" + (int)this.y + " H" + this.heading + " " + this.state.toString();
    }
}

