/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.battle.peer;

import net.sf.robocode.battle.peer.ContestantStatistics;
import net.sf.robocode.battle.peer.RobotPeer;
import robocode.BattleResults;

public class RobotStatistics
implements ContestantStatistics {
    private final RobotPeer robotPeer;
    private int rank;
    private final int robots;
    private boolean isActive;
    private boolean isInRound;
    private double survivalScore;
    private double lastSurvivorBonus;
    private double bulletDamageScore;
    private double bulletKillBonus;
    private double rammingDamageScore;
    private double rammingKillBonus;
    private double[] robotDamage;
    private double totalScore;
    private double totalSurvivalScore;
    private double totalLastSurvivorBonus;
    private double totalBulletDamageScore;
    private double totalBulletKillBonus;
    private double totalRammingDamageScore;
    private double totalRammingKillBonus;
    private int totalFirsts;
    private int totalSeconds;
    private int totalThirds;

    public RobotStatistics(RobotPeer robotPeer, int robots) {
        this.robotPeer = robotPeer;
        this.robots = robots;
    }

    public RobotStatistics(RobotPeer robotPeer, int robots, BattleResults results) {
        this(robotPeer, robots);
        this.totalScore = results.getScore();
        this.totalSurvivalScore = results.getSurvival();
        this.totalLastSurvivorBonus = results.getLastSurvivorBonus();
        this.totalBulletDamageScore = results.getBulletDamage();
        this.totalBulletKillBonus = results.getBulletDamageBonus();
        this.totalRammingDamageScore = results.getRamDamage();
        this.totalRammingKillBonus = results.getRamDamageBonus();
        this.totalFirsts = results.getFirsts();
        this.totalSeconds = results.getSeconds();
        this.totalThirds = results.getThirds();
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public void initialize() {
        this.resetScores();
        this.robotDamage = null;
        this.isActive = true;
        this.isInRound = true;
    }

    public void resetScores() {
        this.survivalScore = 0.0;
        this.lastSurvivorBonus = 0.0;
        this.bulletDamageScore = 0.0;
        this.bulletKillBonus = 0.0;
        this.rammingDamageScore = 0.0;
        this.rammingKillBonus = 0.0;
    }

    public void generateTotals() {
        this.totalSurvivalScore += this.survivalScore;
        this.totalLastSurvivorBonus += this.lastSurvivorBonus;
        this.totalBulletDamageScore += this.bulletDamageScore;
        this.totalBulletKillBonus += this.bulletKillBonus;
        this.totalRammingDamageScore += this.rammingDamageScore;
        this.totalRammingKillBonus += this.rammingKillBonus;
        this.totalScore = this.totalBulletDamageScore + this.totalRammingDamageScore + this.totalSurvivalScore + this.totalRammingKillBonus + this.totalBulletKillBonus + this.totalLastSurvivorBonus;
        this.isInRound = false;
    }

    public double getTotalScore() {
        return this.totalScore;
    }

    public double getTotalSurvivalScore() {
        return this.totalSurvivalScore;
    }

    public double getTotalLastSurvivorBonus() {
        return this.totalLastSurvivorBonus;
    }

    public double getTotalBulletDamageScore() {
        return this.totalBulletDamageScore;
    }

    public double getTotalBulletKillBonus() {
        return this.totalBulletKillBonus;
    }

    public double getTotalRammingDamageScore() {
        return this.totalRammingDamageScore;
    }

    public double getTotalRammingKillBonus() {
        return this.totalRammingKillBonus;
    }

    public int getTotalFirsts() {
        return this.totalFirsts;
    }

    public int getTotalSeconds() {
        return this.totalSeconds;
    }

    public int getTotalThirds() {
        return this.totalThirds;
    }

    public double getCurrentScore() {
        return this.bulletDamageScore + this.rammingDamageScore + this.survivalScore + this.rammingKillBonus + this.bulletKillBonus + this.lastSurvivorBonus;
    }

    public double getCurrentSurvivalScore() {
        return this.survivalScore;
    }

    public double getCurrentSurvivalBonus() {
        return this.lastSurvivorBonus;
    }

    public double getCurrentBulletDamageScore() {
        return this.bulletDamageScore;
    }

    public double getCurrentBulletKillBonus() {
        return this.bulletKillBonus;
    }

    public double getCurrentRammingDamageScore() {
        return this.rammingDamageScore;
    }

    public double getCurrentRammingKillBonus() {
        return this.rammingKillBonus;
    }

    public void scoreSurvival() {
        if (this.isActive) {
            this.survivalScore += 50.0;
        }
    }

    public void scoreLastSurvivor() {
        if (this.isActive) {
            int enemyCount = this.robots - 1;
            if (this.robotPeer.getTeamPeer() != null) {
                enemyCount -= this.robotPeer.getTeamPeer().size() - 1;
            }
            this.lastSurvivorBonus += (double)(10 * enemyCount);
            if (this.robotPeer.getTeamPeer() == null || this.robotPeer.isTeamLeader()) {
                ++this.totalFirsts;
            }
        }
    }

    public void scoreBulletDamage(int robot, double damage) {
        if (this.isActive) {
            double[] dArray = this.getRobotDamage();
            int n = robot;
            dArray[n] = dArray[n] + damage;
            this.bulletDamageScore += damage;
        }
    }

    public double scoreBulletKill(int robot) {
        if (this.isActive) {
            double bonus = 0.0;
            if (this.robotPeer.getTeamPeer() == null) {
                bonus = this.getRobotDamage()[robot] * 0.2;
            } else {
                for (RobotPeer teammate : this.robotPeer.getTeamPeer()) {
                    bonus += teammate.getRobotStatistics().getRobotDamage()[robot] * 0.2;
                }
            }
            this.bulletKillBonus += bonus;
            return bonus;
        }
        return 0.0;
    }

    public void scoreRammingDamage(int robot) {
        if (this.isActive) {
            double[] dArray = this.getRobotDamage();
            int n = robot;
            dArray[n] = dArray[n] + 0.6;
            this.rammingDamageScore += 1.2;
        }
    }

    public double scoreRammingKill(int robot) {
        if (this.isActive) {
            double bonus = 0.0;
            if (this.robotPeer.getTeamPeer() == null) {
                bonus = this.getRobotDamage()[robot] * 0.3;
            } else {
                for (RobotPeer teammate : this.robotPeer.getTeamPeer()) {
                    bonus += teammate.getRobotStatistics().getRobotDamage()[robot] * 0.3;
                }
            }
            this.rammingKillBonus += bonus;
            return bonus;
        }
        return 0.0;
    }

    public void scoreRobotDeath(int enemiesRemaining) {
        switch (enemiesRemaining) {
            case 0: {
                if (this.robotPeer.isWinner()) break;
                ++this.totalFirsts;
                break;
            }
            case 1: {
                ++this.totalSeconds;
                break;
            }
            case 2: {
                ++this.totalThirds;
            }
        }
    }

    public void scoreFirsts() {
        if (this.isActive) {
            ++this.totalFirsts;
        }
    }

    public void setInactive() {
        this.resetScores();
        this.isActive = false;
    }

    public BattleResults getFinalResults() {
        return new BattleResults(this.robotPeer.getTeamName(), this.rank, this.totalScore, this.totalSurvivalScore, this.totalLastSurvivorBonus, this.totalBulletDamageScore, this.totalBulletKillBonus, this.totalRammingDamageScore, this.totalRammingKillBonus, this.totalFirsts, this.totalSeconds, this.totalThirds);
    }

    private double[] getRobotDamage() {
        if (this.robotDamage == null) {
            this.robotDamage = new double[this.robots];
        }
        return this.robotDamage;
    }

    public void cleanup() {
    }

    public boolean isInRound() {
        return this.isInRound;
    }
}

