/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.battle;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sf.robocode.battle.Command;
import net.sf.robocode.battle.IBattle;
import net.sf.robocode.battle.IBattleManager;
import net.sf.robocode.battle.events.BattleEventDispatcher;
import net.sf.robocode.io.Logger;
import net.sf.robocode.io.URLJarCollector;
import net.sf.robocode.settings.ISettingsManager;
import robocode.BattleRules;
import robocode.control.events.BattlePausedEvent;
import robocode.control.events.BattleResumedEvent;

public abstract class BaseBattle
implements IBattle,
Runnable {
    private static final int TURNS_DISPLAYED_AFTER_ENDING = 30;
    private static final int MAX_TPS = 10000;
    private Thread battleThread;
    IBattleManager battleManager;
    protected final BattleEventDispatcher eventDispatcher;
    private final ISettingsManager properties;
    protected BattleRules battleRules;
    private int roundNum;
    protected int currentTime;
    private int endTimer;
    private int tps;
    private long turnStartTime;
    private long measuredTurnStartTime;
    private int measuredTurnCounter;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    protected boolean isAborted;
    boolean isPaused;
    private int stepCount = 0;
    private boolean runBackward;
    private boolean roundOver;
    private final Queue<Command> pendingCommands = new ConcurrentLinkedQueue<Command>();

    protected BaseBattle(ISettingsManager properties, IBattleManager battleManager, BattleEventDispatcher eventDispatcher) {
        this.properties = properties;
        this.eventDispatcher = eventDispatcher;
        this.battleManager = battleManager;
    }

    protected int getEndTimer() {
        return this.endTimer;
    }

    protected boolean isPaused() {
        return this.isPaused;
    }

    public void setBattleThread(Thread newBattleThread) {
        this.battleThread = newBattleThread;
    }

    public void setRoundNum(int roundNum) {
        this.roundNum = roundNum;
    }

    public int getRoundNum() {
        return this.roundNum;
    }

    public int getNumRounds() {
        return this.battleRules.getNumRounds();
    }

    public Thread getBattleThread() {
        return this.battleThread;
    }

    public int getTime() {
        return this.currentTime;
    }

    public boolean isLastRound() {
        return this.roundNum + 1 == this.getNumRounds();
    }

    public int getTPS() {
        return this.tps;
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    public boolean isAborted() {
        return this.isAborted;
    }

    public void cleanup() {
        this.battleRules = null;
        if (this.pendingCommands != null) {
            this.pendingCommands.clear();
        }
        URLJarCollector.enableGc((boolean)true);
        URLJarCollector.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTillStarted() {
        AtomicBoolean atomicBoolean = this.isRunning;
        synchronized (atomicBoolean) {
            while (!this.isRunning.get()) {
                try {
                    this.isRunning.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTillOver() {
        AtomicBoolean atomicBoolean = this.isRunning;
        synchronized (atomicBoolean) {
            while (this.isRunning.get()) {
                try {
                    this.isRunning.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    public void run() {
        try {
            this.initializeBattle();
            while (!this.isAborted && this.roundNum < this.getNumRounds()) {
                try {
                    this.preloadRound();
                    this.initializeRound();
                    this.runRound();
                    this.finalizeRound();
                    this.cleanupRound();
                }
                catch (Exception e) {
                    Logger.logError((String)"Exception running a battle round: ", (Throwable)e);
                    this.isAborted = true;
                }
                ++this.roundNum;
            }
            this.finalizeBattle();
            this.cleanup();
        }
        catch (Throwable e) {
            Logger.logError((String)"Exception running a battle: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeBattle() {
        URLJarCollector.enableGc((boolean)false);
        this.roundNum = 0;
        AtomicBoolean atomicBoolean = this.isRunning;
        synchronized (atomicBoolean) {
            this.isRunning.set(true);
            this.isRunning.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalizeBattle() {
        AtomicBoolean atomicBoolean = this.isRunning;
        synchronized (atomicBoolean) {
            this.isRunning.set(false);
            this.isRunning.notifyAll();
        }
    }

    protected void preloadRound() {
        Logger.logMessage((String)"----------------------");
        Logger.logMessage((String)("Round " + (this.roundNum + 1) + " initializing.."), (boolean)false);
    }

    protected void initializeRound() {
        Logger.logMessage((String)"");
        Logger.logMessage((String)"Let the games begin!");
        this.roundOver = false;
        this.endTimer = 0;
        this.currentTime = 0;
    }

    private void runRound() {
        while (!this.roundOver) {
            this.processCommand();
            if (this.shouldPause() && !this.shouldStep()) {
                this.shortSleep();
                continue;
            }
            this.initializeTurn();
            this.runTurn();
            this.roundOver = this.isRoundOver();
            this.finalizeTurn();
        }
    }

    protected boolean isRoundOver() {
        return this.endTimer > 150;
    }

    protected void finalizeRound() {
    }

    protected void cleanupRound() {
        Logger.logMessage((String)("Round " + (this.roundNum + 1) + " cleaning up."));
    }

    protected void initializeTurn() {
        this.turnStartTime = System.nanoTime();
    }

    protected void runTurn() {
        if (this.runBackward) {
            --this.currentTime;
            if (this.currentTime == 0 && !this.isPaused) {
                this.pauseImpl();
            }
        } else {
            ++this.currentTime;
        }
    }

    protected void shutdownTurn() {
        ++this.endTimer;
    }

    protected void finalizeTurn() {
        this.synchronizeTPS();
        this.calculateTPS();
    }

    private void synchronizeTPS() {
        if (this.battleManager.isManagedTPS()) {
            int desiredTPS;
            long delay = 0L;
            if (!this.isAborted() && this.endTimer < 30 && (desiredTPS = this.properties.getOptionsBattleDesiredTPS()) < 10000) {
                long deltaTime = System.nanoTime() - this.turnStartTime;
                delay = Math.max((long)(1000000000 / desiredTPS) - deltaTime, 0L);
            }
            if (delay > 500000L) {
                try {
                    Thread.sleep(delay / 1000000L, (int)(delay % 1000000L));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private void calculateTPS() {
        long deltaTime;
        if (this.measuredTurnCounter++ == 0) {
            this.measuredTurnStartTime = this.turnStartTime;
        }
        if ((deltaTime = System.nanoTime() - this.measuredTurnStartTime) / 500000000L >= 1L) {
            this.tps = (int)((long)this.measuredTurnCounter * 1000000000L / deltaTime);
            this.measuredTurnCounter = 0;
        }
    }

    private boolean shouldPause() {
        return this.isPaused && !this.isAborted;
    }

    private boolean shouldStep() {
        if (this.stepCount > 0) {
            --this.stepCount;
            return true;
        }
        return false;
    }

    protected void sendCommand(Command command) {
        this.pendingCommands.add(command);
    }

    private void processCommand() {
        Command command = this.pendingCommands.poll();
        while (command != null) {
            try {
                command.execute();
            }
            catch (Exception e) {
                Logger.logError((Throwable)e);
            }
            command = this.pendingCommands.poll();
        }
    }

    public void stop(boolean waitTillEnd) {
        this.sendCommand(new AbortCommand());
        if (waitTillEnd) {
            this.waitTillOver();
        }
    }

    public void pause() {
        this.sendCommand(new PauseCommand());
    }

    public void resume() {
        this.sendCommand(new ResumeCommand());
    }

    public void step() {
        this.sendCommand(new StepCommand());
    }

    public void stepBack() {
        this.sendCommand(new StepBackCommand());
    }

    private void pauseImpl() {
        this.isPaused = true;
        this.stepCount = 0;
        this.eventDispatcher.onBattlePaused(new BattlePausedEvent());
    }

    private void shortSleep() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void printSystemThreads() {
        Thread[] systemThreads = new Thread[256];
        this.battleThread.getThreadGroup().enumerate(systemThreads, false);
        Logger.logMessage((String)"Threads: ------------------------");
        for (Thread thread : systemThreads) {
            if (thread == null) continue;
            Logger.logError((String)thread.getName());
        }
    }

    protected class RobotCommand
    extends Command {
        protected final int robotIndex;

        protected RobotCommand(int robotIndex) {
            this.robotIndex = robotIndex;
        }
    }

    private class AbortCommand
    extends Command {
        private AbortCommand() {
        }

        public void execute() {
            BaseBattle.this.isAborted = true;
        }
    }

    public class StepBackCommand
    extends Command {
        public void execute() {
            BaseBattle.this.runBackward = true;
            if (BaseBattle.this.isPaused) {
                BaseBattle.this.stepCount++;
            }
        }
    }

    private class StepCommand
    extends Command {
        private StepCommand() {
        }

        public void execute() {
            BaseBattle.this.runBackward = false;
            if (BaseBattle.this.isPaused) {
                BaseBattle.this.stepCount++;
            }
        }
    }

    private class ResumeCommand
    extends Command {
        private ResumeCommand() {
        }

        public void execute() {
            BaseBattle.this.isPaused = false;
            BaseBattle.this.stepCount = 0;
            BaseBattle.this.eventDispatcher.onBattleResumed(new BattleResumedEvent());
        }
    }

    private class PauseCommand
    extends Command {
        private PauseCommand() {
        }

        public void execute() {
            BaseBattle.this.pauseImpl();
        }
    }
}

