/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.battle.snapshot;

import java.io.IOException;
import java.io.Serializable;
import java.util.Dictionary;
import net.sf.robocode.battle.peer.BulletPeer;
import net.sf.robocode.battle.peer.ExplosionPeer;
import net.sf.robocode.serialization.IXmlSerializable;
import net.sf.robocode.serialization.XmlReader;
import net.sf.robocode.serialization.XmlWriter;
import robocode.control.snapshot.BulletState;
import robocode.control.snapshot.IBulletSnapshot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BulletSnapshot
implements Serializable,
IXmlSerializable,
IBulletSnapshot {
    private static final long serialVersionUID = 1L;
    private BulletState state;
    private double power;
    private double x;
    private double y;
    private double paintX;
    private double paintY;
    private int color = -1;
    private int frame;
    private boolean isExplosion;
    private int explosionImageIndex;
    private int bulletId;

    public BulletSnapshot() {
    }

    public BulletSnapshot(BulletPeer bullet) {
        this.state = bullet.getState();
        this.power = bullet.getPower();
        this.x = bullet.getX();
        this.y = bullet.getY();
        this.paintX = bullet.getPaintX();
        this.paintY = bullet.getPaintY();
        this.color = bullet.getColor();
        this.frame = bullet.getFrame();
        this.isExplosion = bullet instanceof ExplosionPeer;
        this.explosionImageIndex = bullet.getExplosionImageIndex();
        this.bulletId = bullet.getBulletId();
    }

    public int getBulletId() {
        return this.bulletId;
    }

    public BulletState getState() {
        return this.state;
    }

    public double getPower() {
        return this.power;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getPaintX() {
        return this.paintX;
    }

    public double getPaintY() {
        return this.paintY;
    }

    public int getColor() {
        return this.color;
    }

    public int getFrame() {
        return this.frame;
    }

    public boolean isExplosion() {
        return this.isExplosion;
    }

    public int getExplosionImageIndex() {
        return this.explosionImageIndex;
    }

    public void writeXml(XmlWriter writer, Dictionary<String, Object> options) throws IOException {
        writer.startElement("bullet");
        writer.writeAttribute("state", this.state.toString());
        writer.writeAttribute("power", this.power);
        writer.writeAttribute("x", this.paintX);
        writer.writeAttribute("y", this.paintY);
        if (this.color != -1) {
            writer.writeAttribute("color", Integer.toHexString(this.color).toUpperCase());
        }
        if (this.frame != 0) {
            writer.writeAttribute("frame", (long)this.frame);
        }
        if (this.isExplosion) {
            writer.writeAttribute("isExplosion", true);
            writer.writeAttribute("explosion", (long)this.explosionImageIndex);
        }
        writer.writeAttribute("ver", 1L);
        writer.endElement();
    }

    public XmlReader.Element readXml(XmlReader reader) {
        return reader.expect("bullet", new XmlReader.Element(){

            public IXmlSerializable read(XmlReader reader) {
                final BulletSnapshot snapshot = new BulletSnapshot();
                reader.expect("state", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.state = BulletState.valueOf((String)value);
                    }
                });
                reader.expect("power", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.power = Double.parseDouble(value);
                    }
                });
                reader.expect("x", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.x = Double.parseDouble(value);
                        snapshot.paintX = snapshot.x;
                    }
                });
                reader.expect("y", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.y = Double.parseDouble(value);
                        snapshot.paintY = snapshot.y;
                    }
                });
                reader.expect("color", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.color = Long.valueOf(value.toUpperCase(), 16).intValue();
                    }
                });
                reader.expect("isExplosion", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.isExplosion = Boolean.parseBoolean(value);
                    }
                });
                reader.expect("explosion", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.explosionImageIndex = Integer.parseInt(value);
                    }
                });
                reader.expect("frame", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.frame = Integer.parseInt(value);
                    }
                });
                return snapshot;
            }
        });
    }
}

