/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.battle.snapshot;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import net.sf.robocode.battle.Battle;
import net.sf.robocode.battle.peer.BulletPeer;
import net.sf.robocode.battle.peer.RobotPeer;
import net.sf.robocode.battle.snapshot.BulletSnapshot;
import net.sf.robocode.battle.snapshot.RobotSnapshot;
import net.sf.robocode.battle.snapshot.ScoreSnapshot;
import net.sf.robocode.serialization.IXmlSerializable;
import net.sf.robocode.serialization.XmlReader;
import net.sf.robocode.serialization.XmlWriter;
import robocode.control.snapshot.IBulletSnapshot;
import robocode.control.snapshot.IRobotSnapshot;
import robocode.control.snapshot.IScoreSnapshot;
import robocode.control.snapshot.ITurnSnapshot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TurnSnapshot
implements Serializable,
IXmlSerializable,
ITurnSnapshot {
    private static final long serialVersionUID = 1L;
    private List<IRobotSnapshot> robots;
    private List<IBulletSnapshot> bullets;
    private int tps;
    private int round;
    private int turn;

    public TurnSnapshot() {
    }

    public TurnSnapshot(Battle battle, List<RobotPeer> battleRobots, List<BulletPeer> battleBullets, boolean readoutText) {
        this.robots = new ArrayList<IRobotSnapshot>();
        this.bullets = new ArrayList<IBulletSnapshot>();
        for (RobotPeer robotPeer : battleRobots) {
            this.robots.add(new RobotSnapshot(robotPeer, readoutText));
        }
        for (BulletPeer bulletPeer : battleBullets) {
            this.bullets.add(new BulletSnapshot(bulletPeer));
        }
        this.tps = battle.getTPS();
        this.turn = battle.getTime();
        this.round = battle.getRoundNum();
    }

    public String toString() {
        return this.round + "/" + this.turn + " (" + this.robots.size() + ")";
    }

    public IRobotSnapshot[] getRobots() {
        return this.robots.toArray(new IRobotSnapshot[this.robots.size()]);
    }

    public IBulletSnapshot[] getBullets() {
        return this.bullets.toArray(new IBulletSnapshot[this.bullets.size()]);
    }

    public int getTPS() {
        return this.tps;
    }

    public int getRound() {
        return this.round;
    }

    public int getTurn() {
        return this.turn;
    }

    public IScoreSnapshot[] getSortedTeamScores() {
        ArrayList<IScoreSnapshot> copy = new ArrayList<IScoreSnapshot>(Arrays.asList(this.getIndexedTeamScores()));
        Collections.sort(copy);
        Collections.reverse(copy);
        return copy.toArray(new IScoreSnapshot[copy.size()]);
    }

    public IScoreSnapshot[] getIndexedTeamScores() {
        ArrayList<IScoreSnapshot> results = new ArrayList<IScoreSnapshot>();
        for (int i = 0; i < this.robots.size(); ++i) {
            results.add(null);
        }
        for (IRobotSnapshot robot : this.robots) {
            IScoreSnapshot snapshot = (IScoreSnapshot)results.get(robot.getContestantIndex());
            if (snapshot == null) {
                results.set(robot.getContestantIndex(), robot.getScoreSnapshot());
                continue;
            }
            ScoreSnapshot sum = new ScoreSnapshot(robot.getTeamName(), snapshot, robot.getScoreSnapshot());
            results.set(robot.getContestantIndex(), sum);
        }
        ArrayList<IScoreSnapshot> scores = new ArrayList<IScoreSnapshot>();
        for (IScoreSnapshot scoreSnapshot : results) {
            if (scoreSnapshot == null) continue;
            scores.add(scoreSnapshot);
        }
        return scores.toArray(new IScoreSnapshot[scores.size()]);
    }

    public void writeXml(XmlWriter writer, Dictionary<String, Object> options) throws IOException {
        writer.startElement("turn");
        writer.writeAttribute("round", (long)this.round);
        writer.writeAttribute("turn", (long)this.turn);
        writer.writeAttribute("ver", 1L);
        writer.startElement("robots");
        for (IRobotSnapshot r : this.robots) {
            ((RobotSnapshot)r).writeXml(writer, options);
        }
        writer.endElement();
        writer.startElement("bullets");
        for (IBulletSnapshot b : this.bullets) {
            ((BulletSnapshot)b).writeXml(writer, options);
        }
        writer.endElement();
        writer.endElement();
    }

    public XmlReader.Element readXml(XmlReader reader) {
        return reader.expect("turn", new XmlReader.Element(){

            public IXmlSerializable read(XmlReader reader) {
                final TurnSnapshot snapshot = new TurnSnapshot();
                reader.expect("turn", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.turn = Integer.parseInt(value);
                    }
                });
                reader.expect("round", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.round = Integer.parseInt(value);
                    }
                });
                reader.expect("robots", (XmlReader.Element)new XmlReader.ListElement(){

                    public IXmlSerializable read(XmlReader reader) {
                        snapshot.robots = new ArrayList();
                        return new RobotSnapshot();
                    }

                    public void add(IXmlSerializable child) {
                        snapshot.robots.add((RobotSnapshot)child);
                    }

                    public void close() {
                    }
                });
                reader.expect("bullets", (XmlReader.Element)new XmlReader.ListElement(){

                    public IXmlSerializable read(XmlReader reader) {
                        snapshot.bullets = new ArrayList();
                        return new BulletSnapshot();
                    }

                    public void add(IXmlSerializable child) {
                        snapshot.bullets.add((BulletSnapshot)child);
                    }

                    public void close() {
                    }
                });
                return snapshot;
            }
        });
    }
}

