/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.recording;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.sf.robocode.battle.events.BattleEventDispatcher;
import net.sf.robocode.battle.snapshot.TurnSnapshot;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.recording.BattleRecordFormat;
import net.sf.robocode.recording.BattleRecordInfo;
import net.sf.robocode.recording.BattleRecorder;
import net.sf.robocode.recording.IRecordManager;
import net.sf.robocode.serialization.IXmlSerializable;
import net.sf.robocode.serialization.XmlReader;
import net.sf.robocode.serialization.XmlWriter;
import robocode.BattleResults;
import robocode.BattleRules;
import robocode.control.snapshot.ITurnSnapshot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordManager
implements IRecordManager {
    private File tempFile;
    private BattleRecorder recorder = new BattleRecorder(this);
    public BattleRecordInfo recordInfo;
    private FileOutputStream fileWriteStream;
    private BufferedOutputStream bufferedWriteStream;
    private ObjectOutputStream objectWriteStream;
    private FileInputStream fileReadStream;
    private BufferedInputStream bufferedReadStream;
    private ObjectInputStream objectReadStream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.cleanup();
        }
        finally {
            super.finalize();
        }
    }

    private void cleanup() {
        this.cleanupStreams();
        if (this.tempFile != null && this.tempFile.exists()) {
            this.tempFile.delete();
            this.tempFile = null;
        }
        this.recordInfo = null;
    }

    public void cleanupStreams() {
        FileUtil.cleanupStream((Object)this.objectWriteStream);
        this.objectWriteStream = null;
        FileUtil.cleanupStream((Object)this.bufferedWriteStream);
        this.bufferedWriteStream = null;
        FileUtil.cleanupStream((Object)this.fileWriteStream);
        this.fileWriteStream = null;
        FileUtil.cleanupStream((Object)this.objectReadStream);
        this.objectReadStream = null;
        FileUtil.cleanupStream((Object)this.bufferedReadStream);
        this.bufferedReadStream = null;
        FileUtil.cleanupStream((Object)this.fileReadStream);
        this.fileReadStream = null;
    }

    public void attachRecorder(BattleEventDispatcher battleEventDispatcher) {
        this.recorder.attachRecorder(battleEventDispatcher);
    }

    public void detachRecorder() {
        this.recorder.detachRecorder();
    }

    private void createTempFile() {
        try {
            if (this.tempFile == null) {
                this.tempFile = File.createTempFile("robocode-battle-records", ".tmp");
                this.tempFile.deleteOnExit();
            } else {
                this.tempFile.delete();
                this.tempFile.createNewFile();
            }
        }
        catch (IOException e) {
            Logger.logError((Throwable)e);
            throw new Error("Temp file creation failed", e);
        }
    }

    public void prepareInputStream() {
        try {
            this.fileReadStream = new FileInputStream(this.tempFile);
            this.bufferedReadStream = new BufferedInputStream(this.fileReadStream);
            this.objectReadStream = new ObjectInputStream(this.bufferedReadStream);
        }
        catch (FileNotFoundException e) {
            Logger.logError((Throwable)e);
            this.fileReadStream = null;
            this.bufferedReadStream = null;
            this.objectReadStream = null;
        }
        catch (IOException e) {
            Logger.logError((Throwable)e);
            this.fileReadStream = null;
            this.bufferedReadStream = null;
            this.objectReadStream = null;
        }
    }

    public ITurnSnapshot readSnapshot(int currentTime) {
        if (this.objectReadStream == null) {
            return null;
        }
        try {
            return (ITurnSnapshot)this.objectReadStream.readObject();
        }
        catch (EOFException e) {
            Logger.logError((Throwable)e);
            return null;
        }
        catch (Exception e) {
            Logger.logError((Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void loadRecord(String recordFilename, BattleRecordFormat format) {
        block20: {
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            ZipInputStream zis = null;
            ObjectInputStream ois = null;
            FileOutputStream fos = null;
            BufferedOutputStream bos = null;
            ObjectOutputStream oos = null;
            try {
                this.createTempFile();
                fis = new FileInputStream(recordFilename);
                bis = new BufferedInputStream(fis, 0x100000);
                if (format == BattleRecordFormat.BINARY) {
                    ois = new ObjectInputStream(bis);
                } else if (format == BattleRecordFormat.BINARY_ZIP) {
                    zis = new ZipInputStream(bis);
                    zis.getNextEntry();
                    ois = new ObjectInputStream(zis);
                }
                if (format == BattleRecordFormat.BINARY || format == BattleRecordFormat.BINARY_ZIP) {
                    this.recordInfo = (BattleRecordInfo)ois.readObject();
                    if (this.recordInfo.turnsInRounds != null) {
                        fos = new FileOutputStream(this.tempFile);
                        bos = new BufferedOutputStream(fos, 0x100000);
                        oos = new ObjectOutputStream(bos);
                        for (int i = 0; i < this.recordInfo.turnsInRounds.length; ++i) {
                            for (int j = this.recordInfo.turnsInRounds[i] - 1; j >= 0; --j) {
                                try {
                                    ITurnSnapshot turn = (ITurnSnapshot)ois.readObject();
                                    oos.writeObject(turn);
                                    continue;
                                }
                                catch (ClassNotFoundException e) {
                                    Logger.logError((Throwable)e);
                                }
                            }
                        }
                    }
                } else {
                    RecordRoot root = new RecordRoot();
                    fos = new FileOutputStream(this.tempFile);
                    bos = new BufferedOutputStream(fos, 0x100000);
                    root.oos = new ObjectOutputStream(bos);
                    XmlReader.deserialize((InputStream)bis, (IXmlSerializable)root);
                    if (root.lastException != null) {
                        Logger.logError((Throwable)root.lastException);
                    }
                    this.recordInfo = root.recordInfo;
                }
                FileUtil.cleanupStream(oos);
            }
            catch (IOException e) {
                Logger.logError((Throwable)e);
                this.createTempFile();
                this.recordInfo = null;
                break block20;
            }
            catch (ClassNotFoundException e) {
                if (e.getMessage().contains("robocode.recording.BattleRecordInfo")) {
                    Logger.logMessage((String)"Sorry, backward compatibility with record from version 1.6 is not provided.");
                } else {
                    Logger.logError((Throwable)e);
                }
                this.createTempFile();
                this.recordInfo = null;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                FileUtil.cleanupStream(oos);
                FileUtil.cleanupStream(bos);
                FileUtil.cleanupStream(fos);
                FileUtil.cleanupStream((Object)ois);
                FileUtil.cleanupStream((Object)zis);
                FileUtil.cleanupStream((Object)bis);
                FileUtil.cleanupStream((Object)fis);
                break block20;
            }
            finally {
                FileUtil.cleanupStream(oos);
                FileUtil.cleanupStream(bos);
                FileUtil.cleanupStream(fos);
                FileUtil.cleanupStream(ois);
                FileUtil.cleanupStream(zis);
                FileUtil.cleanupStream((Object)bis);
                FileUtil.cleanupStream((Object)fis);
            }
            FileUtil.cleanupStream(bos);
            FileUtil.cleanupStream((Object)fos);
            FileUtil.cleanupStream((Object)ois);
            FileUtil.cleanupStream((Object)zis);
            FileUtil.cleanupStream((Object)bis);
            FileUtil.cleanupStream((Object)fis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRecord(String recordFilename, BattleRecordFormat format) {
        ObjectInputStream ois;
        BufferedInputStream bis;
        FileInputStream fis;
        OutputStreamWriter osw;
        ObjectOutputStream oos;
        ZipOutputStream zos;
        BufferedOutputStream bos;
        FileOutputStream fos;
        block21: {
            fos = null;
            bos = null;
            zos = null;
            oos = null;
            osw = null;
            XmlWriter xwr = null;
            fis = null;
            bis = null;
            ois = null;
            try {
                fos = new FileOutputStream(recordFilename);
                bos = new BufferedOutputStream(fos, 0x100000);
                if (format == BattleRecordFormat.BINARY) {
                    oos = new ObjectOutputStream(bos);
                } else if (format == BattleRecordFormat.BINARY_ZIP) {
                    zos = new ZipOutputStream(bos);
                    zos.putNextEntry(new ZipEntry("robocode.br"));
                    oos = new ObjectOutputStream(zos);
                } else if (format == BattleRecordFormat.XML) {
                    Charset utf8 = Charset.forName("UTF-8");
                    osw = new OutputStreamWriter((OutputStream)bos, utf8);
                    xwr = new XmlWriter((Writer)osw, true);
                }
                if (format == BattleRecordFormat.BINARY || format == BattleRecordFormat.BINARY_ZIP) {
                    oos.writeObject(this.recordInfo);
                } else if (format == BattleRecordFormat.XML) {
                    Hashtable<String, Object> xmlOptions = new Hashtable<String, Object>();
                    xwr.startDocument();
                    xwr.startElement("record");
                    xwr.writeAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                    xwr.writeAttribute("xsi:noNamespaceSchemaLocation", "battleRecord.xsd");
                    this.recordInfo.writeXml(xwr, xmlOptions);
                    xwr.startElement("turns");
                }
                if (this.recordInfo.turnsInRounds == null) break block21;
                fis = new FileInputStream(this.tempFile);
                bis = new BufferedInputStream(fis, 0x100000);
                ois = new ObjectInputStream(bis);
                for (int i = 0; i < this.recordInfo.turnsInRounds.length; ++i) {
                    if (this.recordInfo.turnsInRounds[i] <= 0) continue;
                    for (int j = 0; j <= this.recordInfo.turnsInRounds[i] - 1; ++j) {
                        try {
                            TurnSnapshot turn = (TurnSnapshot)ois.readObject();
                            if (j != turn.getTurn()) {
                                throw new Error("Something rotten");
                            }
                            if (format == BattleRecordFormat.BINARY || format == BattleRecordFormat.BINARY_ZIP) {
                                oos.writeObject(turn);
                                continue;
                            }
                            if (format != BattleRecordFormat.XML) continue;
                            turn.writeXml(xwr, null);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            Logger.logError((Throwable)e);
                        }
                    }
                    if (format == BattleRecordFormat.BINARY || format == BattleRecordFormat.BINARY_ZIP) {
                        oos.flush();
                    } else if (format == BattleRecordFormat.XML) {
                        osw.flush();
                    }
                    bos.flush();
                    fos.flush();
                }
                if (format != BattleRecordFormat.XML) break block21;
                xwr.endElement();
                xwr.endElement();
                osw.flush();
            }
            catch (IOException e) {
                try {
                    Logger.logError((Throwable)e);
                    this.recorder = new BattleRecorder(this);
                    this.createTempFile();
                }
                catch (Throwable throwable) {
                    FileUtil.cleanupStream(ois);
                    FileUtil.cleanupStream(bis);
                    FileUtil.cleanupStream(fis);
                    FileUtil.cleanupStream(oos);
                    FileUtil.cleanupStream(zos);
                    FileUtil.cleanupStream((Object)bos);
                    FileUtil.cleanupStream((Object)fos);
                    FileUtil.cleanupStream(osw);
                    throw throwable;
                }
                FileUtil.cleanupStream(ois);
                FileUtil.cleanupStream(bis);
                FileUtil.cleanupStream(fis);
                FileUtil.cleanupStream((Object)oos);
                FileUtil.cleanupStream((Object)zos);
                FileUtil.cleanupStream((Object)bos);
                FileUtil.cleanupStream((Object)fos);
                FileUtil.cleanupStream((Object)osw);
            }
        }
        FileUtil.cleanupStream(ois);
        FileUtil.cleanupStream(bis);
        FileUtil.cleanupStream((Object)fis);
        FileUtil.cleanupStream((Object)oos);
        FileUtil.cleanupStream((Object)zos);
        FileUtil.cleanupStream((Object)bos);
        FileUtil.cleanupStream((Object)fos);
        FileUtil.cleanupStream((Object)osw);
    }

    public boolean hasRecord() {
        return this.recordInfo != null;
    }

    public void createRecordInfo(BattleRules rules, int numRobots) {
        try {
            this.createTempFile();
            this.fileWriteStream = new FileOutputStream(this.tempFile);
            this.bufferedWriteStream = new BufferedOutputStream(this.fileWriteStream, 0x100000);
            this.objectWriteStream = new ObjectOutputStream(this.bufferedWriteStream);
        }
        catch (IOException e) {
            Logger.logError((Throwable)e);
        }
        this.recordInfo = new BattleRecordInfo();
        this.recordInfo.robotCount = numRobots;
        this.recordInfo.battleRules = rules;
        this.recordInfo.turnsInRounds = new Integer[rules.getNumRounds()];
        for (int i = 0; i < rules.getNumRounds(); ++i) {
            this.recordInfo.turnsInRounds[i] = 0;
        }
    }

    public void updateRecordInfoResults(List<BattleResults> results) {
        this.recordInfo.results = results;
    }

    public void writeTurn(ITurnSnapshot turn, int round, int time) {
        try {
            if (time != this.recordInfo.turnsInRounds[round]) {
                throw new Error("Something rotten");
            }
            Integer[] integerArray = this.recordInfo.turnsInRounds;
            int n = round;
            Integer n2 = integerArray[n];
            Integer n3 = integerArray[n] = Integer.valueOf(integerArray[n] + 1);
            this.recordInfo.roundsCount = round + 1;
            this.objectWriteStream.writeObject(turn);
        }
        catch (IOException e) {
            Logger.logError((Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RecordRoot
    implements IXmlSerializable {
        public ObjectOutputStream oos;
        public IOException lastException;
        public final RecordRoot me = this;
        public BattleRecordInfo recordInfo;

        public void writeXml(XmlWriter writer, Dictionary<String, Object> options) throws IOException {
        }

        public XmlReader.Element readXml(XmlReader reader) {
            return reader.expect("record", new XmlReader.Element(){

                public IXmlSerializable read(XmlReader reader) {
                    final XmlReader.Element element = new BattleRecordInfo().readXml(reader);
                    reader.expect("recordInfo", new XmlReader.Element(){

                        public IXmlSerializable read(XmlReader reader) {
                            RecordRoot.this.recordInfo = (BattleRecordInfo)element.read(reader);
                            return RecordRoot.this.recordInfo;
                        }
                    });
                    reader.expect("turns", (XmlReader.Element)new XmlReader.ListElement(){

                        public IXmlSerializable read(XmlReader reader) {
                            return new TurnSnapshot();
                        }

                        public void add(IXmlSerializable child) {
                            try {
                                RecordRoot.this.me.oos.writeObject(child);
                            }
                            catch (IOException e) {
                                RecordRoot.this.me.lastException = e;
                            }
                        }

                        public void close() {
                        }
                    });
                    return RecordRoot.this.me;
                }
            });
        }
    }
}

