/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.cachecleaner;

import java.io.File;
import java.io.IOException;
import net.sf.robocode.core.Container;
import net.sf.robocode.io.Logger;
import net.sf.robocode.repository.IRepositoryManager;

public final class CacheCleaner {
    private CacheCleaner() {
    }

    public static void main(String[] args) {
        CacheCleaner.clean();
    }

    public static void clean() {
        CacheCleaner.deleteFile("roborumble/temp");
        CacheCleaner.deleteFile("robots/.robotcache");
        CacheCleaner.deleteFile("robots/robot.database");
        Logger.logMessage((String)"Creating roborumble/temp... ", (boolean)false);
        if (new File("roborumble/temp").mkdir()) {
            Logger.logMessage((String)"done.");
        } else {
            Logger.logMessage((String)"failed.");
        }
        System.out.print("Rebuilding robot database... ");
        IRepositoryManager repositoryManager = Container.getComponent(IRepositoryManager.class);
        repositoryManager.clearRobotList();
        repositoryManager.loadRobotRepository();
        Logger.logMessage((String)"done.");
    }

    private static void deleteFile(String filename) {
        System.out.print("Deleting " + filename + "... ");
        try {
            CacheCleaner.recursivelyDelete(new File(filename));
            Logger.logMessage((String)"done.");
        }
        catch (IOException ex) {
            Logger.logMessage((String)"failed.");
        }
    }

    private static void recursivelyDelete(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files;
                for (File f : files = file.listFiles()) {
                    CacheCleaner.recursivelyDelete(f);
                }
            }
            if (!file.delete()) {
                throw new IOException("Delete failed.");
            }
        }
    }
}

