/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.core;

import java.awt.Toolkit;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import net.sf.robocode.core.ContainerBase;
import net.sf.robocode.core.EngineClassLoader;
import net.sf.robocode.io.Logger;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentFactory;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.Caching;
import org.picocontainer.behaviors.OptInCaching;
import org.picocontainer.classname.DefaultClassLoadingPicoContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Container
extends ContainerBase {
    public static final boolean isSecutityOn = !System.getProperty("NOSECURITY", "false").equals("true");
    private static final String classPath = System.getProperties().getProperty("robocode.class.path", null);
    public static final MutablePicoContainer cache;
    public static final MutablePicoContainer factory;
    public static final ClassLoader systemLoader;
    public static final ClassLoader engineLoader;
    private static Set<String> known;

    public static void init() {
    }

    private static void loadFromPath(String path) {
        try {
            File pathf = new File(path).getCanonicalFile();
            path = pathf.toString();
            String test = path.toLowerCase();
            if (pathf.isDirectory()) {
                String name = Container.getModuleName(path);
                if (name != null) {
                    Container.loadModule(name, engineLoader);
                }
            } else if (test.contains(File.separator + "robocode.") && test.endsWith(".jar")) {
                int i = test.lastIndexOf("robocode.jar");
                if (i > 0) {
                    File dir = new File(path.substring(0, i));
                    Logger.logMessage((String)("Loading plugins from " + dir.toString()));
                    Container.loadJars(dir);
                } else {
                    String name = Container.getModuleName(path);
                    if (name != null) {
                        Container.loadModule(name, engineLoader);
                    }
                }
            }
        }
        catch (IOException e) {
            Logger.logError((Throwable)e);
        }
    }

    private static void loadJars(File pathf) {
        File[] files;
        for (File file : files = pathf.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().startsWith("robocode") && name.toLowerCase().endsWith(".jar");
            }
        })) {
            Container.loadModule(Container.getModuleName(file.toString()), engineLoader);
        }
    }

    private static boolean loadModule(String module, ClassLoader loader) {
        try {
            if (known.contains(module)) {
                return false;
            }
            Class<?> modClass = loader.loadClass(module + ".Module");
            modClass.newInstance();
            Logger.logMessage((String)("Loaded " + module));
            known.add(module);
            return true;
        }
        catch (ClassNotFoundException ignore) {
        }
        catch (IllegalAccessException e) {
            Logger.logError((Throwable)e);
        }
        catch (InstantiationException e) {
            Logger.logError((Throwable)e);
        }
        return false;
    }

    private static String getModuleName(String path) {
        String test = path.toLowerCase();
        if (test.endsWith("robocode.jar") || test.contains("robocode.api")) {
            return null;
        }
        int i = test.lastIndexOf("robocode.");
        if (i > 0) {
            String name = path.substring(i);
            if ((i = name.indexOf(File.separator)) > 0) {
                return "net.sf." + name.substring(0, i);
            }
            i = name.indexOf("-");
            if (i > 0) {
                return "net.sf." + name.substring(0, i);
            }
            return "net.sf." + name;
        }
        return null;
    }

    protected <T> T getBaseComponent(Class<T> tClass) {
        return (T)cache.getComponent(tClass);
    }

    public static <T> T getComponent(Class<T> tClass) {
        return (T)cache.getComponent(tClass);
    }

    public static <T> T createComponent(Class<T> tClass) {
        return (T)factory.as(new Properties[]{Characteristics.NO_CACHE}).getComponent(tClass);
    }

    static {
        known = new HashSet<String>();
        instance = new Container();
        systemLoader = Container.class.getClassLoader();
        engineLoader = isSecutityOn ? new EngineClassLoader(systemLoader) : systemLoader;
        Thread currentThread = Thread.currentThread();
        currentThread.setContextClassLoader(engineLoader);
        currentThread.setName("Application Thread");
        Toolkit.getDefaultToolkit();
        cache = new DefaultClassLoadingPicoContainer(engineLoader, (ComponentFactory)new Caching(), null);
        factory = new DefaultClassLoadingPicoContainer(engineLoader, (ComponentFactory)new OptInCaching(), (PicoContainer)cache);
        Container.loadModule("net.sf.robocode.api", systemLoader);
        for (String path : classPath.split(File.pathSeparator)) {
            Container.loadFromPath(path);
        }
        if (known.size() < 2) {
            Logger.logError((String)("Main modules not loaded, something went wrong. We have only " + known.size()));
            Logger.logError((String)("ClassPath : " + classPath));
            throw new Error("Main modules not loaded");
        }
    }
}

