/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.robocode.core.Container;
import net.sf.robocode.core.RobocodeMainBase;
import net.sf.robocode.io.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineClassLoader
extends URLClassLoader {
    private static final boolean isSecutityOn = !System.getProperty("NOSECURITY", "false").equals("true");
    private static Set<String> exclusions = new HashSet<String>();

    public EngineClassLoader(ClassLoader parent) {
        super(EngineClassLoader.initRobotClassLoader(), parent);
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith("java.lang")) {
            return super.loadClass(name, resolve);
        }
        if (isSecutityOn && this.isEngineClass(name)) {
            return this.loadEngineClass(name, resolve);
        }
        return super.loadClass(name, resolve);
    }

    private Class<?> loadEngineClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(name);
        if (result == null) {
            result = this.findClass(name);
        }
        if (resolve) {
            this.resolveClass(result);
        }
        return result;
    }

    private boolean isEngineClass(String name) {
        if (name.startsWith("net.sf.robocode") || name.startsWith("robocode.control")) {
            if (exclusions.contains(name)) {
                return false;
            }
            final String path = name.replace('.', '/').concat(".class");
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return EngineClassLoader.this.findResource(path) != null;
                }
            });
        }
        return false;
    }

    private static URL[] initRobotClassLoader() {
        ArrayList<String> urls = new ArrayList<String>();
        String classPath = System.getProperty("robocode.class.path", null);
        for (String path : classPath.split(File.pathSeparator)) {
            String test = path.toLowerCase();
            if (!test.contains("robocode") || test.contains("robocode.jar") || test.contains("robocode.api")) continue;
            urls.add(path);
        }
        return EngineClassLoader.convertUrls(urls);
    }

    private static URL[] convertUrls(List<String> surls) {
        URL[] urls = new URL[surls.size()];
        for (int i = 0; i < surls.size(); ++i) {
            String url = surls.get(i);
            File f = new File(url);
            try {
                urls[i] = f.getCanonicalFile().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                Logger.logError((Throwable)e);
                continue;
            }
            catch (IOException e) {
                Logger.logError((Throwable)e);
            }
        }
        return urls;
    }

    static {
        exclusions.add(EngineClassLoader.class.getName());
        exclusions.add(Container.class.getName());
        exclusions.add(RobocodeMainBase.class.getName());
    }
}

