/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import net.sf.robocode.io.Logger;

public class FileUtil {
    private static File cwd;

    public static File getCwd() {
        return cwd;
    }

    public static void setCwd(File cwd) throws IOException {
        FileUtil.cwd = cwd.getCanonicalFile();
    }

    public static String getFileType(File file) {
        return FileUtil.getFileType(file.getName());
    }

    public static String getFileType(String fileName) {
        int lastdot = fileName.lastIndexOf(46);
        return lastdot < 0 ? "" : fileName.substring(lastdot);
    }

    public static String quoteFileName(String filename) {
        if (filename.startsWith("\"") && filename.endsWith("\"")) {
            return filename;
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("windows") && filename.startsWith("file://")) {
            filename = filename.substring(7);
        }
        if (filename.matches(".*\\s+?.*")) {
            return '\"' + filename + '\"';
        }
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File srcFile, File destFile) throws IOException {
        if (srcFile.equals(destFile)) {
            throw new IOException("You cannot copy a file onto itself");
        }
        byte[] buf = new byte[4096];
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(srcFile);
            out = new FileOutputStream(destFile);
            while (in.available() > 0) {
                out.write(buf, 0, in.read(buf, 0, buf.length));
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    try {
                        if (file.getCanonicalFile().getParentFile().equals(dir.getCanonicalFile())) {
                            FileUtil.deleteDir(file);
                            if (!file.exists() || file.delete()) continue;
                            Logger.logError((String)("Can't delete: " + file));
                            continue;
                        }
                        Logger.logMessage((String)("Warning: " + file + " may be a symlink.  Ignoring."));
                    }
                    catch (IOException e) {
                        Logger.logMessage((String)("Warning: Cannot determine canonical file for " + file + " - ignoring."));
                    }
                    continue;
                }
                if (!file.exists() || file.delete()) continue;
                Logger.logError((String)("Can't delete: " + file));
            }
            return dir.delete();
        }
        return false;
    }

    public static File createDir(File dir) {
        if (dir != null && !dir.exists() && !dir.mkdir()) {
            Logger.logError((String)("Can't create" + dir));
        }
        return dir;
    }

    public static String getClassName(String fileName) {
        int lastdot = fileName.lastIndexOf(46);
        if (lastdot < 0) {
            return fileName;
        }
        if (fileName.length() - 1 == lastdot) {
            return fileName.substring(0, fileName.length() - 1);
        }
        return fileName.substring(0, lastdot);
    }

    public static File getRobotsDir() {
        try {
            String robotPath = System.getProperty("ROBOTPATH");
            File file = robotPath != null ? new File(robotPath).getCanonicalFile() : new File(cwd, "/robots").getCanonicalFile();
            return FileUtil.createDir(file);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public static File getBattlesDir() {
        return FileUtil.createDir(new File(cwd, "/battles"));
    }

    public static File getConfigDir() {
        return FileUtil.createDir(new File(cwd, "/config"));
    }

    public static File getRobocodeConfigFile() {
        return new File(FileUtil.getConfigDir(), "robocode.properties");
    }

    public static File getWindowConfigFile() {
        return new File(FileUtil.getConfigDir(), "window.properties");
    }

    public static File getCompilerConfigFile() {
        return new File(FileUtil.getConfigDir(), "compiler.properties");
    }

    public static void cleanupStream(Object stream) {
        if (stream instanceof Flushable) {
            try {
                ((Flushable)stream).flush();
            }
            catch (IOException e) {
                Logger.logError((Throwable)e);
            }
        }
        if (stream instanceof Closeable) {
            try {
                ((Closeable)stream).close();
            }
            catch (IOException e) {
                Logger.logError((Throwable)e);
            }
        }
    }

    static {
        try {
            String wd = System.getProperty("WORKINGDIRECTORY", "");
            FileUtil.setCwd(new File(wd));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

