/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.peer;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.sf.robocode.peer.BulletStatus;
import net.sf.robocode.peer.ExecCommands;
import net.sf.robocode.peer.TeamMessage;
import net.sf.robocode.serialization.ISerializableHelper;
import net.sf.robocode.serialization.RbSerializer;
import robocode.Event;
import robocode.RobotStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecResults
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ExecCommands commands;
    private RobotStatus status;
    private List<Event> events;
    private List<TeamMessage> teamMessages;
    private List<BulletStatus> bulletUpdates;
    private boolean halt;
    private boolean shouldWait;
    private boolean paintEnabled;

    public ExecResults(ExecCommands commands, RobotStatus status, List<Event> events, List<TeamMessage> teamMessages, List<BulletStatus> bulletUpdates, boolean halt, boolean shouldWait, boolean paintEnabled) {
        this.commands = commands;
        this.status = status;
        this.events = events;
        this.teamMessages = teamMessages;
        this.bulletUpdates = bulletUpdates;
        this.halt = halt;
        this.shouldWait = shouldWait;
        this.paintEnabled = paintEnabled;
    }

    public static long getSerialVersionUID() {
        return 1L;
    }

    public ExecCommands getCommands() {
        return this.commands;
    }

    public void setCommands(ExecCommands commands) {
        this.commands = commands;
    }

    public RobotStatus getStatus() {
        return this.status;
    }

    public void setStatus(RobotStatus status) {
        this.status = status;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public void setEvents(List<Event> events) {
        this.events = events;
    }

    public List<TeamMessage> getTeamMessages() {
        return this.teamMessages;
    }

    public void setTeamMessages(List<TeamMessage> teamMessages) {
        this.teamMessages = teamMessages;
    }

    public List<BulletStatus> getBulletUpdates() {
        return this.bulletUpdates;
    }

    public void setBulletUpdates(List<BulletStatus> bulletUpdates) {
        this.bulletUpdates = bulletUpdates;
    }

    public boolean isHalt() {
        return this.halt;
    }

    public void setHalt(boolean halt) {
        this.halt = halt;
    }

    public boolean isShouldWait() {
        return this.shouldWait;
    }

    public void setShouldWait(boolean shouldWait) {
        this.shouldWait = shouldWait;
    }

    public boolean isPaintEnabled() {
        return this.paintEnabled;
    }

    public void setPaintEnabled(boolean paintEnabled) {
        this.paintEnabled = paintEnabled;
    }

    private ExecResults() {
    }

    static ISerializableHelper createHiddenSerializer() {
        return new SerializableHelper();
    }

    private static class SerializableHelper
    implements ISerializableHelper {
        private SerializableHelper() {
        }

        public int sizeOf(RbSerializer serializer, Object object) {
            ExecResults obj = (ExecResults)object;
            int size = 4;
            size += serializer.sizeOf((byte)1, (Object)obj.commands);
            size += serializer.sizeOf((byte)6, (Object)obj.status);
            for (Event event : obj.events) {
                size += serializer.sizeOf(event);
            }
            ++size;
            for (TeamMessage m : obj.teamMessages) {
                size += serializer.sizeOf((byte)3, (Object)m);
            }
            ++size;
            for (BulletStatus b : obj.bulletUpdates) {
                size += serializer.sizeOf((byte)7, (Object)b);
            }
            return ++size;
        }

        public void serialize(RbSerializer serializer, ByteBuffer buffer, Object object) {
            ExecResults obj = (ExecResults)object;
            serializer.serialize(buffer, obj.halt);
            serializer.serialize(buffer, obj.shouldWait);
            serializer.serialize(buffer, obj.paintEnabled);
            serializer.serialize(buffer, (byte)1, (Object)obj.commands);
            serializer.serialize(buffer, (byte)6, (Object)obj.status);
            for (Event event : obj.events) {
                serializer.serialize(buffer, event);
            }
            buffer.put((byte)-128);
            for (TeamMessage message : obj.teamMessages) {
                serializer.serialize(buffer, (byte)3, (Object)message);
            }
            buffer.put((byte)-128);
            for (BulletStatus bulletStatus : obj.bulletUpdates) {
                serializer.serialize(buffer, (byte)7, (Object)bulletStatus);
            }
            buffer.put((byte)-128);
        }

        public Object deserialize(RbSerializer serializer, ByteBuffer buffer) {
            ExecResults res = new ExecResults();
            res.halt = serializer.deserializeBoolean(buffer);
            res.shouldWait = serializer.deserializeBoolean(buffer);
            res.paintEnabled = serializer.deserializeBoolean(buffer);
            res.commands = (ExecCommands)serializer.deserializeAny(buffer);
            res.status = (RobotStatus)serializer.deserializeAny(buffer);
            Object item = serializer.deserializeAny(buffer);
            res.events = new ArrayList();
            res.teamMessages = new ArrayList();
            res.bulletUpdates = new ArrayList();
            while (item != null) {
                if (item instanceof Event) {
                    res.events.add((Event)item);
                }
                item = serializer.deserializeAny(buffer);
            }
            item = serializer.deserializeAny(buffer);
            while (item != null) {
                if (item instanceof TeamMessage) {
                    res.teamMessages.add((TeamMessage)item);
                }
                item = serializer.deserializeAny(buffer);
            }
            item = serializer.deserializeAny(buffer);
            while (item != null) {
                if (item instanceof BulletStatus) {
                    res.bulletUpdates.add((BulletStatus)item);
                }
                item = serializer.deserializeAny(buffer);
            }
            return res;
        }
    }
}

