/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.robotpaint;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.robocode.robotpaint.IGraphicsProxy;
import net.sf.robocode.serialization.ObjectCloner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Graphics2DProxy
extends Graphics2D
implements Serializable,
IGraphicsProxy {
    private static final long serialVersionUID = 1L;
    private List<QueuedCall> queuedCalls = Collections.synchronizedList(new LinkedList());
    private transient AffineTransform transform;
    private transient Composite composite;
    private transient Paint paint;
    private transient Stroke stroke;
    private transient RenderingHints renderingHints;
    private transient Color background;
    private transient Shape clip;
    private transient Color color;
    private transient Font font;
    private transient boolean isInitialized;
    private transient boolean isPaintingEnabled;

    @Override
    public Graphics create() {
        Graphics2DProxy gfxProxyCopy = new Graphics2DProxy();
        gfxProxyCopy.queuedCalls = Collections.synchronizedList(new LinkedList<QueuedCall>(this.queuedCalls));
        gfxProxyCopy.transform = this.copyOf(this.transform);
        gfxProxyCopy.composite = this.copyOf(this.composite);
        gfxProxyCopy.paint = this.copyOf(this.paint);
        gfxProxyCopy.stroke = this.copyOf(this.stroke);
        gfxProxyCopy.renderingHints = this.copyOf(this.renderingHints);
        gfxProxyCopy.background = ObjectCloner.deepCopy(this.background);
        gfxProxyCopy.clip = this.copyOf(this.clip);
        gfxProxyCopy.color = ObjectCloner.deepCopy(this.color);
        gfxProxyCopy.font = this.copyOf(this.font);
        gfxProxyCopy.isInitialized = this.isInitialized;
        return gfxProxyCopy;
    }

    public static Graphics createFromCalls(List<QueuedCall> queuedCalls) {
        Graphics2DProxy gfxProxyCopy = new Graphics2DProxy();
        gfxProxyCopy.queuedCalls = Collections.synchronizedList(new LinkedList<QueuedCall>(queuedCalls));
        return gfxProxyCopy;
    }

    @Override
    public void setPaintingEnabled(boolean value) {
        this.isPaintingEnabled = value;
    }

    @Override
    public Graphics create(int x, int y, int width, int height) {
        Graphics g = this.create();
        g.translate(x, y);
        g.setClip(0, 0, width, height);
        return g;
    }

    @Override
    public void translate(int x, int y) {
        this.transform.translate(x, y);
        if (this.isPaintingEnabled) {
            this.queueCall(Method.TRANSLATE_INT, x, y);
        }
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color c) {
        this.color = c;
        if (this.isPaintingEnabled) {
            this.queueCall(Method.SET_COLOR, this.copyOf(c));
        }
    }

    @Override
    public void setPaintMode() {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.SET_PAINT_MODE, new Object[0]);
        }
    }

    @Override
    public void setXORMode(Color c1) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.SET_XOR_MODE, this.copyOf(c1));
        }
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
        if (this.isPaintingEnabled) {
            this.queueCall(Method.SET_FONT, this.copyOf(font));
        }
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return new FontMetricsByFont(f);
    }

    @Override
    public Rectangle getClipBounds() {
        return this.clip.getBounds();
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        Area clipArea = new Area(this.clip);
        Area clipRectArea = new Area(new Rectangle(x, y, width, height));
        clipArea.intersect(clipRectArea);
        this.clip = clipArea;
        if (this.isPaintingEnabled) {
            this.queueCall(Method.CLIP_RECT, x, y, width, height);
        }
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.clip = new Rectangle(x, y, width, height);
        if (this.isPaintingEnabled) {
            this.queueCall(Method.SET_CLIP, x, y, width, height);
        }
    }

    @Override
    public Shape getClip() {
        return this.clip;
    }

    @Override
    public void setClip(Shape clip) {
        this.clip = clip;
        if (this.isPaintingEnabled) {
            this.queueCall(Method.SET_CLIP_SHAPE, this.copyOf(clip));
        }
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.COPY_AREA, x, y, width, height, dx, dy);
        }
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW_LINE, x1, y1, x2, y2);
        }
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.FILL_RECT, x, y, width, height);
        }
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW_RECT, x, y, width, height);
        }
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.CLEAR_RECT, x, y, width, height);
        }
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW_ROUND_RECT, x, y, width, height, arcWidth, arcHeight);
        }
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.FILL_ROUND_RECT, x, y, width, height, arcWidth, arcHeight);
        }
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW_3D_RECT, x, y, width, height, raised);
        }
    }

    @Override
    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.FILL_3D_RECT, x, y, width, height, raised);
        }
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW_OVAL, x, y, width, height);
        }
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.FILL_OVAL, x, y, width, height);
        }
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW_ARC, x, y, width, height, startAngle, arcAngle);
        }
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.FILL_ARC, x, y, width, height, startAngle, arcAngle);
        }
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int npoints) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW_POLYLINE, this.copyOf(xPoints), this.copyOf(yPoints), npoints);
        }
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int npoints) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW_POLYGON, this.copyOf(xPoints), this.copyOf(yPoints), npoints);
        }
    }

    @Override
    public void drawPolygon(Polygon p) {
        if (this.isPaintingEnabled) {
            this.drawPolygon(p.xpoints, p.ypoints, p.npoints);
        }
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int npoints) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.FILL_POLYGON, this.copyOf(xPoints), this.copyOf(yPoints), npoints);
        }
    }

    @Override
    public void fillPolygon(Polygon p) {
        if (this.isPaintingEnabled) {
            this.fillPolygon(p.xpoints, p.ypoints, p.npoints);
        }
    }

    @Override
    public void drawString(String str, int x, int y) {
        if (str == null) {
            throw new NullPointerException("str is null");
        }
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW_STRING_INT, str, x, y);
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW_STRING_ACI_INT, this.copyOf(iterator), x, y);
        }
    }

    @Override
    public void drawChars(char[] data, int offset, int length, int x, int y) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW_CHARS, this.copyOf(data), offset, length, x, y);
        }
    }

    @Override
    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW_BYTES, this.copyOf(data), offset, length, x, y);
        }
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW_IMAGE_1, this.copyOf(img), x, y, this.copyOf(observer));
        }
        return false;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW_IMAGE_2, this.copyOf(img), x, y, width, height, this.copyOf(observer));
        }
        return false;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW_IMAGE_3, this.copyOf(img), x, y, this.copyOf(bgcolor), this.copyOf(observer));
        }
        return false;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW_IMAGE_4, this.copyOf(img), x, y, width, height, this.copyOf(bgcolor), this.copyOf(observer));
        }
        return false;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW_IMAGE_5, this.copyOf(img), dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this.copyOf(observer));
        }
        return false;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW_IMAGE_6, this.copyOf(img), dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this.copyOf(bgcolor), this.copyOf(observer));
        }
        return false;
    }

    @Override
    public void dispose() {
    }

    @Override
    @Deprecated
    public Rectangle getClipRect() {
        return this.getClipBounds();
    }

    @Override
    public boolean hitClip(int x, int y, int width, int height) {
        return this.clip != null && this.clip.intersects(x, y, width, height);
    }

    @Override
    public Rectangle getClipBounds(Rectangle r) {
        Rectangle bounds = this.clip.getBounds();
        r.setBounds(bounds);
        return bounds;
    }

    @Override
    public void draw(Shape s) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW, this.copyOf(s));
        }
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW_IMAGE_7, this.copyOf(img), this.copyOf(xform), this.copyOf(obs));
        }
        return false;
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW_IMAGE_8, this.copyOf(img), ObjectCloner.deepCopy(op), x, y);
        }
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW_RENDERED_IMAGE, ObjectCloner.deepCopy(img), this.copyOf(xform));
        }
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW_RENDERABLE_IMGAGE, ObjectCloner.deepCopy(img), this.copyOf(xform));
        }
    }

    @Override
    public void drawString(String str, float x, float y) {
        if (str == null) {
            throw new NullPointerException("str is null");
        }
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW_STRING_FLOAT, str, Float.valueOf(x), Float.valueOf(y));
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW_STRING_ACI_FLOAT, this.copyOf(iterator), Float.valueOf(x), Float.valueOf(y));
        }
    }

    @Override
    public void drawGlyphVector(GlyphVector gv, float x, float y) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.DRAW_GLYPH_VECTOR, ObjectCloner.deepCopy(gv), Float.valueOf(x), Float.valueOf(y));
        }
    }

    @Override
    public void fill(Shape s) {
        if (this.isPaintingEnabled) {
            this.queueCall(Method.FILL, this.copyOf(s));
        }
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        if (onStroke && this.getStroke() != null) {
            s = this.getStroke().createStrokedShape(s);
        }
        if (this.getTransform() != null) {
            s = this.getTransform().createTransformedShape(s);
        }
        Area area = new Area(s);
        if (this.getClip() != null) {
            area.intersect(new Area(this.getClip()));
        }
        return area.intersects(rect);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    @Override
    public void setComposite(Composite comp) {
        this.composite = comp;
        if (this.isPaintingEnabled) {
            this.queueCall(Method.SET_COMPOSITE, this.copyOf(comp));
        }
    }

    @Override
    public void setPaint(Paint paint) {
        this.paint = paint;
        if (this.isPaintingEnabled) {
            this.queueCall(Method.SET_PAINT, this.copyOf(paint));
        }
    }

    @Override
    public void setStroke(Stroke s) {
        this.stroke = s;
        if (this.isPaintingEnabled) {
            this.queueCall(Method.SET_STROKE, this.copyOf(s));
        }
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.renderingHints.put(hintKey, hintValue);
        if (this.isPaintingEnabled) {
            this.queueCall(Method.SET_RENDERING_HINT, ObjectCloner.deepCopy(hintKey), ObjectCloner.deepCopy(hintValue));
        }
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.renderingHints.get(hintKey);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.renderingHints.clear();
        this.renderingHints.putAll(hints);
        if (this.isPaintingEnabled) {
            this.queueCall(Method.SET_RENDERING_HINTS, ObjectCloner.deepCopy(hints));
        }
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.renderingHints.putAll(hints);
        if (this.isPaintingEnabled) {
            this.queueCall(Method.ADD_RENDERING_HINTS, ObjectCloner.deepCopy(hints));
        }
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    @Override
    public void translate(double tx, double ty) {
        this.transform.translate(tx, ty);
        if (this.isPaintingEnabled) {
            this.queueCall(Method.TRANSLATE_DOUBLE, tx, ty);
        }
    }

    @Override
    public void rotate(double theta) {
        this.transform.rotate(theta);
        if (this.isPaintingEnabled) {
            this.queueCall(Method.ROTATE, theta);
        }
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.transform.rotate(theta, x, y);
        if (this.isPaintingEnabled) {
            this.queueCall(Method.ROTATE_XY, theta, x, y);
        }
    }

    @Override
    public void scale(double sx, double sy) {
        this.transform.scale(sx, sy);
        if (this.isPaintingEnabled) {
            this.queueCall(Method.SCALE, sx, sy);
        }
    }

    @Override
    public void shear(double shx, double shy) {
        this.transform.shear(shx, shy);
        if (this.isPaintingEnabled) {
            this.queueCall(Method.SHEAR, shx, shy);
        }
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.transform.concatenate(Tx);
        if (this.isPaintingEnabled) {
            this.queueCall(Method.TRANSFORM, this.copyOf(Tx));
        }
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.transform = Tx;
        if (this.isPaintingEnabled) {
            this.queueCall(Method.SET_TRANSFORM, this.copyOf(Tx));
        }
    }

    @Override
    public AffineTransform getTransform() {
        return this.copyOf(this.transform);
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
        if (this.isPaintingEnabled) {
            this.queueCall(Method.SET_BACKGROUND, this.copyOf(color));
        }
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public void clip(Shape s) {
        if (s == null) {
            this.clip = null;
        } else {
            Area shapeArea = new Area(s);
            Area clipArea = new Area(this.clip);
            shapeArea.transform(this.transform);
            clipArea.intersect(shapeArea);
            this.clip = clipArea;
        }
        if (this.isPaintingEnabled) {
            this.queueCall(Method.CLIP, this.copyOf(s));
        }
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        RenderingHints hints = this.getRenderingHints();
        boolean isAntiAliased = hints.get(RenderingHints.KEY_TEXT_ANTIALIASING).equals(RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        boolean usesFractionalMetrics = hints.get(RenderingHints.KEY_FRACTIONALMETRICS).equals(RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        return new FontRenderContext(null, isAntiAliased, usesFractionalMetrics);
    }

    private byte[] copyOf(byte[] array) {
        if (array == null) {
            return null;
        }
        byte[] copy = new byte[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    private char[] copyOf(char[] array) {
        if (array == null) {
            return null;
        }
        char[] copy = new char[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    private int[] copyOf(int[] array) {
        if (array == null) {
            return null;
        }
        int[] copy = new int[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    private Font copyOf(Font f) {
        return (Font)ObjectCloner.deepCopy(f);
    }

    private Shape copyOf(Shape s) {
        return s != null ? new GeneralPath(s) : null;
    }

    private AttributedCharacterIterator copyOf(AttributedCharacterIterator it) {
        return it != null ? (AttributedCharacterIterator)it.clone() : null;
    }

    private Image copyOf(Image img) {
        return (Image)ObjectCloner.deepCopy(img);
    }

    private ImageObserver copyOf(ImageObserver obs) {
        return (ImageObserver)ObjectCloner.deepCopy(obs);
    }

    private AffineTransform copyOf(AffineTransform tx) {
        return tx != null ? (AffineTransform)tx.clone() : null;
    }

    private Composite copyOf(Composite c) {
        if (c == null) {
            return null;
        }
        if (c instanceof AlphaComposite) {
            AlphaComposite ac = (AlphaComposite)c;
            return AlphaComposite.getInstance(ac.getRule(), ac.getAlpha());
        }
        throw new UnsupportedOperationException("The Composite type '" + c.getClass().getName() + "' is not supported");
    }

    private Paint copyOf(Paint p) {
        return (Paint)ObjectCloner.deepCopy(p);
    }

    private Integer copyOf(Color c) {
        return c.getRGB();
    }

    private Stroke copyOf(Stroke s) {
        if (s == null) {
            return null;
        }
        if (s instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)s;
            return new BasicStroke(bs.getLineWidth(), bs.getEndCap(), bs.getLineJoin(), bs.getMiterLimit(), bs.getDashArray(), bs.getDashPhase());
        }
        throw new UnsupportedOperationException("The Stroke type '" + s.getClass().getName() + "' is not supported");
    }

    private RenderingHints copyOf(RenderingHints hints) {
        return hints != null ? (RenderingHints)hints.clone() : null;
    }

    private void queueCall(Method method, Object ... args) {
        this.queuedCalls.add(new QueuedCall(method, args));
    }

    @Override
    public void processTo(Graphics2D g, Object graphicsCalls) {
        List gc = (List)graphicsCalls;
        for (QueuedCall call : gc) {
            try {
                this.processQueuedCall(call, this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.processTo(g);
    }

    @Override
    public void processTo(Graphics2D g) {
        if (!this.isInitialized) {
            this.initialize(g);
        }
        for (QueuedCall call : this.queuedCalls) {
            try {
                this.processQueuedCall(call, g);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void clearQueue() {
        this.queuedCalls.clear();
    }

    @Override
    public Object readoutQueuedCalls() {
        List<QueuedCall> now = this.queuedCalls;
        return now.size() == 0 ? null : new ArrayList<QueuedCall>(now);
    }

    private void initialize(Graphics2D g) {
        this.transform = g.getTransform();
        this.transform = this.transform == null ? new AffineTransform() : new AffineTransform(this.transform);
        this.color = ObjectCloner.deepCopy(g.getColor());
        this.font = this.copyOf(g.getFont());
        this.clip = this.copyOf(g.getClip());
        this.composite = this.copyOf(g.getComposite());
        this.paint = this.copyOf(g.getPaint());
        this.stroke = this.copyOf(g.getStroke());
        this.renderingHints = this.copyOf(g.getRenderingHints());
        this.background = ObjectCloner.deepCopy(g.getBackground());
        this.isInitialized = true;
    }

    private void processQueuedCall(QueuedCall call, Graphics2D g) {
        switch (call.method) {
            case TRANSLATE_INT: {
                this.processTranslate_int(call, g);
                break;
            }
            case SET_COLOR: {
                this.processSetColor(call, g);
                break;
            }
            case SET_PAINT_MODE: {
                this.processSetPaintMode(g);
                break;
            }
            case SET_XOR_MODE: {
                this.processSetXORMode(call, g);
                break;
            }
            case SET_FONT: {
                this.processSetFont(call, g);
                break;
            }
            case CLIP_RECT: {
                this.processClipRect(call, g);
                break;
            }
            case SET_CLIP: {
                this.processSetClip(call, g);
                break;
            }
            case SET_CLIP_SHAPE: {
                this.processSetClip_Shape(call, g);
                break;
            }
            case COPY_AREA: {
                this.processCopyArea(call, g);
                break;
            }
            case DRAW_LINE: {
                this.processDrawLine(call, g);
                break;
            }
            case FILL_RECT: {
                this.processFillRect(call, g);
                break;
            }
            case DRAW_RECT: {
                this.processDrawRect(call, g);
                break;
            }
            case CLEAR_RECT: {
                this.processClearRect(call, g);
                break;
            }
            case DRAW_ROUND_RECT: {
                this.processDrawRoundRect(call, g);
                break;
            }
            case FILL_ROUND_RECT: {
                this.processFillRoundRect(call, g);
                break;
            }
            case DRAW_3D_RECT: {
                this.processDraw3DRect(call, g);
                break;
            }
            case FILL_3D_RECT: {
                this.processFill3DRect(call, g);
                break;
            }
            case DRAW_OVAL: {
                this.processDrawOval(call, g);
                break;
            }
            case FILL_OVAL: {
                this.processFillOval(call, g);
                break;
            }
            case DRAW_ARC: {
                this.processDrawArc(call, g);
                break;
            }
            case FILL_ARC: {
                this.processFillArc(call, g);
                break;
            }
            case DRAW_POLYLINE: {
                this.processDrawPolyline(call, g);
                break;
            }
            case DRAW_POLYGON: {
                this.processDrawPolygon(call, g);
                break;
            }
            case FILL_POLYGON: {
                this.processFillPolygon(call, g);
                break;
            }
            case DRAW_STRING_INT: {
                this.processDrawString_int(call, g);
                break;
            }
            case DRAW_STRING_ACI_INT: {
                this.processDrawString_ACIterator_int(call, g);
                break;
            }
            case DRAW_CHARS: {
                this.processDrawChars(call, g);
                break;
            }
            case DRAW_BYTES: {
                this.processDrawBytes(call, g);
                break;
            }
            case DRAW_IMAGE_1: {
                this.processDrawImage1(call, g);
                break;
            }
            case DRAW_IMAGE_2: {
                this.processDrawImage2(call, g);
                break;
            }
            case DRAW_IMAGE_3: {
                this.processDrawImage3(call, g);
                break;
            }
            case DRAW_IMAGE_4: {
                this.processDrawImage4(call, g);
                break;
            }
            case DRAW_IMAGE_5: {
                this.processDrawImage5(call, g);
                break;
            }
            case DRAW_IMAGE_6: {
                this.processDrawImage6(call, g);
                break;
            }
            case DRAW: {
                this.processDraw(call, g);
                break;
            }
            case DRAW_IMAGE_7: {
                this.processDrawImage7(call, g);
                break;
            }
            case DRAW_IMAGE_8: {
                this.processDrawImage8(call, g);
                break;
            }
            case DRAW_RENDERED_IMAGE: {
                this.processDrawRenderedImage(call, g);
                break;
            }
            case DRAW_RENDERABLE_IMGAGE: {
                this.processDrawRenderableImage(call, g);
                break;
            }
            case DRAW_STRING_FLOAT: {
                this.processDrawString_float(call, g);
                break;
            }
            case DRAW_STRING_ACI_FLOAT: {
                this.processDrawString_ACIterator_float(call, g);
                break;
            }
            case DRAW_GLYPH_VECTOR: {
                this.processDrawGlyphVector(call, g);
                break;
            }
            case FILL: {
                this.processFill(call, g);
                break;
            }
            case SET_COMPOSITE: {
                this.processSetComposite(call, g);
                break;
            }
            case SET_PAINT: {
                this.processSetPaint(call, g);
                break;
            }
            case SET_STROKE: {
                this.processSetStroke(call, g);
                break;
            }
            case SET_RENDERING_HINT: {
                this.processSetRenderingHint(call, g);
                break;
            }
            case SET_RENDERING_HINTS: {
                this.processSetRenderingHints(call, g);
                break;
            }
            case ADD_RENDERING_HINTS: {
                this.processAddRenderingHints(call, g);
                break;
            }
            case TRANSLATE_DOUBLE: {
                this.processTranslate_double(call, g);
                break;
            }
            case ROTATE: {
                this.processRotate(call, g);
                break;
            }
            case ROTATE_XY: {
                this.processRotate_xy(call, g);
                break;
            }
            case SCALE: {
                this.processScale(call, g);
                break;
            }
            case SHEAR: {
                this.processShear(call, g);
                break;
            }
            case TRANSFORM: {
                this.processTransform(call, g);
                break;
            }
            case SET_TRANSFORM: {
                this.processSetTransform(call, g);
                break;
            }
            case SET_BACKGROUND: {
                this.processSetBackground(call, g);
                break;
            }
            case CLIP: {
                this.processClip(call, g);
            }
        }
    }

    private void processTranslate_int(QueuedCall call, Graphics2D g) {
        g.translate((Integer)call.args[0], (Integer)call.args[1]);
    }

    private void processSetColor(QueuedCall call, Graphics2D g) {
        g.setColor(new Color((Integer)call.args[0], true));
    }

    private void processSetPaintMode(Graphics2D g) {
        g.setPaintMode();
    }

    private void processSetXORMode(QueuedCall call, Graphics2D g) {
        g.setXORMode(new Color((Integer)call.args[0], true));
    }

    private void processSetFont(QueuedCall call, Graphics2D g) {
        g.setFont((Font)call.args[0]);
    }

    private void processClipRect(QueuedCall call, Graphics2D g) {
        g.clipRect((Integer)call.args[0], (Integer)call.args[1], (Integer)call.args[2], (Integer)call.args[3]);
    }

    private void processSetClip(QueuedCall call, Graphics2D g) {
        g.setClip((Integer)call.args[0], (Integer)call.args[1], (Integer)call.args[2], (Integer)call.args[3]);
    }

    private void processSetClip_Shape(QueuedCall call, Graphics2D g) {
        g.setClip((Shape)call.args[0]);
    }

    private void processCopyArea(QueuedCall call, Graphics2D g) {
        g.copyArea((Integer)call.args[0], (Integer)call.args[1], (Integer)call.args[2], (Integer)call.args[3], (Integer)call.args[4], (Integer)call.args[5]);
    }

    private void processDrawLine(QueuedCall call, Graphics2D g) {
        g.drawLine((Integer)call.args[0], (Integer)call.args[1], (Integer)call.args[2], (Integer)call.args[3]);
    }

    private void processFillRect(QueuedCall call, Graphics2D g) {
        g.fillRect((Integer)call.args[0], (Integer)call.args[1], (Integer)call.args[2], (Integer)call.args[3]);
    }

    private void processDrawRect(QueuedCall call, Graphics2D g) {
        g.drawRect((Integer)call.args[0], (Integer)call.args[1], (Integer)call.args[2], (Integer)call.args[3]);
    }

    private void processClearRect(QueuedCall call, Graphics2D g) {
        g.clearRect((Integer)call.args[0], (Integer)call.args[1], (Integer)call.args[2], (Integer)call.args[3]);
    }

    private void processDrawRoundRect(QueuedCall call, Graphics2D g) {
        g.drawRoundRect((Integer)call.args[0], (Integer)call.args[1], (Integer)call.args[2], (Integer)call.args[3], (Integer)call.args[4], (Integer)call.args[5]);
    }

    private void processFillRoundRect(QueuedCall call, Graphics2D g) {
        g.fillRoundRect((Integer)call.args[0], (Integer)call.args[1], (Integer)call.args[2], (Integer)call.args[3], (Integer)call.args[4], (Integer)call.args[5]);
    }

    private void processDraw3DRect(QueuedCall call, Graphics2D g) {
        g.draw3DRect((Integer)call.args[0], (Integer)call.args[1], (Integer)call.args[2], (Integer)call.args[3], (Boolean)call.args[4]);
    }

    private void processFill3DRect(QueuedCall call, Graphics2D g) {
        g.fill3DRect((Integer)call.args[0], (Integer)call.args[1], (Integer)call.args[2], (Integer)call.args[3], (Boolean)call.args[4]);
    }

    private void processDrawOval(QueuedCall call, Graphics2D g) {
        g.drawOval((Integer)call.args[0], (Integer)call.args[1], (Integer)call.args[2], (Integer)call.args[3]);
    }

    private void processFillOval(QueuedCall call, Graphics2D g) {
        g.fillOval((Integer)call.args[0], (Integer)call.args[1], (Integer)call.args[2], (Integer)call.args[3]);
    }

    private void processDrawArc(QueuedCall call, Graphics2D g) {
        g.drawArc((Integer)call.args[0], (Integer)call.args[1], (Integer)call.args[2], (Integer)call.args[3], (Integer)call.args[4], (Integer)call.args[5]);
    }

    private void processFillArc(QueuedCall call, Graphics2D g) {
        g.fillArc((Integer)call.args[0], (Integer)call.args[1], (Integer)call.args[2], (Integer)call.args[3], (Integer)call.args[4], (Integer)call.args[5]);
    }

    private void processDrawPolyline(QueuedCall call, Graphics2D g) {
        g.drawPolyline((int[])call.args[0], (int[])call.args[1], (Integer)call.args[2]);
    }

    private void processDrawPolygon(QueuedCall call, Graphics2D g) {
        g.drawPolygon((int[])call.args[0], (int[])call.args[1], (Integer)call.args[2]);
    }

    private void processFillPolygon(QueuedCall call, Graphics2D g) {
        g.fillPolygon((int[])call.args[0], (int[])call.args[1], (Integer)call.args[2]);
    }

    private void processDrawString_int(QueuedCall call, Graphics2D g) {
        g.drawString((String)call.args[0], (int)((Integer)call.args[1]), (int)((Integer)call.args[2]));
    }

    private void processDrawString_ACIterator_int(QueuedCall call, Graphics2D g) {
        g.drawString((AttributedCharacterIterator)call.args[0], (int)((Integer)call.args[1]), (int)((Integer)call.args[2]));
    }

    private void processDrawChars(QueuedCall call, Graphics2D g) {
        g.drawChars((char[])call.args[0], (Integer)call.args[1], (Integer)call.args[2], (Integer)call.args[3], (Integer)call.args[4]);
    }

    private void processDrawBytes(QueuedCall call, Graphics2D g) {
        g.drawBytes((byte[])call.args[0], (Integer)call.args[1], (Integer)call.args[2], (Integer)call.args[3], (Integer)call.args[4]);
    }

    private void processDrawImage1(QueuedCall call, Graphics2D g) {
        g.drawImage((Image)call.args[0], (Integer)call.args[1], (int)((Integer)call.args[2]), (ImageObserver)call.args[3]);
    }

    private void processDrawImage2(QueuedCall call, Graphics2D g) {
        g.drawImage((Image)call.args[0], (Integer)call.args[1], (Integer)call.args[2], (Integer)call.args[3], (Integer)call.args[4], (ImageObserver)call.args[5]);
    }

    private void processDrawImage3(QueuedCall call, Graphics2D g) {
        g.drawImage((Image)call.args[0], (Integer)call.args[1], (Integer)call.args[2], new Color((Integer)call.args[3], true), (ImageObserver)call.args[4]);
    }

    private void processDrawImage4(QueuedCall call, Graphics2D g) {
        g.drawImage((Image)call.args[0], (Integer)call.args[1], (Integer)call.args[2], (Integer)call.args[3], (Integer)call.args[4], new Color((Integer)call.args[5], true), (ImageObserver)call.args[6]);
    }

    private void processDrawImage5(QueuedCall call, Graphics2D g) {
        g.drawImage((Image)call.args[0], (Integer)call.args[1], (Integer)call.args[2], (Integer)call.args[3], (Integer)call.args[4], (Integer)call.args[4], (Integer)call.args[5], (Integer)call.args[6], (Integer)call.args[7], (ImageObserver)call.args[8]);
    }

    private void processDrawImage6(QueuedCall call, Graphics2D g) {
        g.drawImage((Image)call.args[0], (Integer)call.args[1], (Integer)call.args[2], (Integer)call.args[3], (Integer)call.args[4], (Integer)call.args[4], (Integer)call.args[5], (Integer)call.args[6], (Integer)call.args[7], new Color((Integer)call.args[8], true), (ImageObserver)call.args[9]);
    }

    private void processDraw(QueuedCall call, Graphics2D g) {
        g.draw((Shape)call.args[0]);
    }

    private void processDrawImage7(QueuedCall call, Graphics2D g) {
        g.drawImage((Image)call.args[0], (AffineTransform)call.args[1], (ImageObserver)call.args[2]);
    }

    private void processDrawImage8(QueuedCall call, Graphics2D g) {
        g.drawImage((BufferedImage)call.args[0], (BufferedImageOp)call.args[1], (int)((Integer)call.args[2]), (Integer)call.args[3]);
    }

    private void processDrawRenderedImage(QueuedCall call, Graphics2D g) {
        g.drawRenderedImage((RenderedImage)call.args[0], (AffineTransform)call.args[1]);
    }

    private void processDrawRenderableImage(QueuedCall call, Graphics2D g) {
        g.drawRenderableImage((RenderableImage)call.args[0], (AffineTransform)call.args[1]);
    }

    private void processDrawString_float(QueuedCall call, Graphics2D g) {
        g.drawString((String)call.args[0], ((Float)call.args[1]).floatValue(), ((Float)call.args[2]).floatValue());
    }

    private void processDrawString_ACIterator_float(QueuedCall call, Graphics2D g) {
        g.drawString((AttributedCharacterIterator)call.args[0], ((Float)call.args[1]).floatValue(), ((Float)call.args[2]).floatValue());
    }

    private void processDrawGlyphVector(QueuedCall call, Graphics2D g) {
        g.drawGlyphVector((GlyphVector)call.args[0], ((Float)call.args[1]).floatValue(), ((Float)call.args[2]).floatValue());
    }

    private void processFill(QueuedCall call, Graphics2D g) {
        g.fill((Shape)call.args[0]);
    }

    private void processSetComposite(QueuedCall call, Graphics2D g) {
        g.setComposite((Composite)call.args[0]);
    }

    private void processSetPaint(QueuedCall call, Graphics2D g) {
        g.setPaint((Paint)call.args[0]);
    }

    private void processSetStroke(QueuedCall call, Graphics2D g) {
        g.setStroke((Stroke)call.args[0]);
    }

    private void processSetRenderingHint(QueuedCall call, Graphics2D g) {
        g.setRenderingHint((RenderingHints.Key)call.args[0], call.args[1]);
    }

    private void processSetRenderingHints(QueuedCall call, Graphics2D g) {
        g.setRenderingHints((Map)call.args[0]);
    }

    private void processAddRenderingHints(QueuedCall call, Graphics2D g) {
        g.addRenderingHints((Map)call.args[0]);
    }

    private void processTranslate_double(QueuedCall call, Graphics2D g) {
        g.translate((Double)call.args[0], (Double)call.args[1]);
    }

    private void processRotate(QueuedCall call, Graphics2D g) {
        g.rotate((Double)call.args[0]);
    }

    private void processRotate_xy(QueuedCall call, Graphics2D g) {
        g.rotate((Double)call.args[0], (Double)call.args[1], (Double)call.args[2]);
    }

    private void processScale(QueuedCall call, Graphics2D g) {
        g.scale((Double)call.args[0], (Double)call.args[1]);
    }

    private void processShear(QueuedCall call, Graphics2D g) {
        g.shear((Double)call.args[0], (Double)call.args[1]);
    }

    private void processTransform(QueuedCall call, Graphics2D g) {
        g.transform((AffineTransform)call.args[0]);
    }

    private void processSetTransform(QueuedCall call, Graphics2D g) {
        g.setTransform((AffineTransform)call.args[0]);
    }

    private void processSetBackground(QueuedCall call, Graphics2D g) {
        g.setBackground(new Color((Integer)call.args[0], true));
    }

    private void processClip(QueuedCall call, Graphics2D g) {
        g.clip((Shape)call.args[0]);
    }

    private class FontMetricsByFont
    extends FontMetrics {
        private static final long serialVersionUID = 1L;

        FontMetricsByFont(Font font) {
            super(font);
        }
    }

    public class QueuedCall
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Method method;
        public final Object[] args;

        public QueuedCall(Method method, Object ... args) {
            this.method = method;
            this.args = args;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Method {
        TRANSLATE_INT,
        SET_COLOR,
        SET_PAINT_MODE,
        SET_XOR_MODE,
        SET_FONT,
        CLIP_RECT,
        SET_CLIP,
        SET_CLIP_SHAPE,
        COPY_AREA,
        DRAW_LINE,
        FILL_RECT,
        DRAW_RECT,
        CLEAR_RECT,
        DRAW_ROUND_RECT,
        FILL_ROUND_RECT,
        DRAW_3D_RECT,
        FILL_3D_RECT,
        DRAW_OVAL,
        FILL_OVAL,
        DRAW_ARC,
        FILL_ARC,
        DRAW_POLYLINE,
        DRAW_POLYGON,
        FILL_POLYGON,
        DRAW_STRING_INT,
        DRAW_STRING_ACI_INT,
        DRAW_CHARS,
        DRAW_BYTES,
        DRAW_IMAGE_1,
        DRAW_IMAGE_2,
        DRAW_IMAGE_3,
        DRAW_IMAGE_4,
        DRAW_IMAGE_5,
        DRAW_IMAGE_6,
        DRAW,
        DRAW_IMAGE_7,
        DRAW_IMAGE_8,
        DRAW_RENDERED_IMAGE,
        DRAW_RENDERABLE_IMGAGE,
        DRAW_STRING_FLOAT,
        DRAW_STRING_ACI_FLOAT,
        DRAW_GLYPH_VECTOR,
        FILL,
        SET_COMPOSITE,
        SET_PAINT,
        SET_STROKE,
        SET_RENDERING_HINT,
        SET_RENDERING_HINTS,
        ADD_RENDERING_HINTS,
        TRANSLATE_DOUBLE,
        ROTATE,
        ROTATE_XY,
        SCALE,
        SHEAR,
        TRANSFORM,
        SET_TRANSFORM,
        SET_BACKGROUND,
        CLIP;

    }
}

