/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.battle.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sf.robocode.io.Logger;
import robocode.control.events.BattleCompletedEvent;
import robocode.control.events.BattleErrorEvent;
import robocode.control.events.BattleFinishedEvent;
import robocode.control.events.BattleMessageEvent;
import robocode.control.events.BattlePausedEvent;
import robocode.control.events.BattleResumedEvent;
import robocode.control.events.BattleStartedEvent;
import robocode.control.events.IBattleListener;
import robocode.control.events.RoundEndedEvent;
import robocode.control.events.RoundStartedEvent;
import robocode.control.events.TurnEndedEvent;
import robocode.control.events.TurnStartedEvent;

public class BattleEventDispatcher
implements IBattleListener {
    private final List<IBattleListener> listeners = new CopyOnWriteArrayList<IBattleListener>();

    public void addListener(IBattleListener listener) {
        assert (listener != null);
        this.listeners.add(listener);
    }

    public void removeListener(IBattleListener listener) {
        assert (listener != null);
        this.listeners.remove(listener);
    }

    public void onBattleStarted(BattleStartedEvent event) {
        for (IBattleListener listener : this.listeners) {
            try {
                listener.onBattleStarted(event);
            }
            catch (Throwable ex) {
                Logger.logError((String)("onBattleStarted " + listener.getClass()), (Throwable)ex);
            }
        }
    }

    public void onBattleCompleted(BattleCompletedEvent event) {
        for (IBattleListener listener : this.listeners) {
            try {
                listener.onBattleCompleted(event);
            }
            catch (Throwable ex) {
                Logger.logError((String)("onBattleCompleted " + listener.getClass()), (Throwable)ex);
            }
        }
    }

    public void onBattleFinished(BattleFinishedEvent event) {
        for (IBattleListener listener : this.listeners) {
            try {
                listener.onBattleFinished(event);
            }
            catch (Throwable ex) {
                Logger.logError((String)("onBattleFinished " + listener.getClass()), (Throwable)ex);
            }
        }
    }

    public void onBattlePaused(BattlePausedEvent event) {
        for (IBattleListener listener : this.listeners) {
            try {
                listener.onBattlePaused(event);
            }
            catch (Throwable ex) {
                Logger.logError((String)("onBattlePaused " + listener.getClass()), (Throwable)ex);
            }
        }
    }

    public void onBattleResumed(BattleResumedEvent event) {
        for (IBattleListener listener : this.listeners) {
            try {
                listener.onBattleResumed(event);
            }
            catch (Throwable ex) {
                Logger.logError((String)("onBattleResumed " + listener.getClass()), (Throwable)ex);
            }
        }
    }

    public void onRoundStarted(RoundStartedEvent event) {
        for (IBattleListener listener : this.listeners) {
            try {
                listener.onRoundStarted(event);
            }
            catch (Throwable ex) {
                Logger.logError((String)("onRoundStarted " + listener.getClass()), (Throwable)ex);
            }
        }
    }

    public void onRoundEnded(RoundEndedEvent event) {
        for (IBattleListener listener : this.listeners) {
            try {
                listener.onRoundEnded(event);
            }
            catch (Throwable ex) {
                Logger.logError((String)("onRoundEnded " + listener.getClass()), (Throwable)ex);
            }
        }
    }

    public void onTurnStarted(TurnStartedEvent event) {
        for (IBattleListener listener : this.listeners) {
            try {
                listener.onTurnStarted(event);
            }
            catch (Throwable ex) {
                Logger.logError((String)("onTurnStarted " + listener.getClass()), (Throwable)ex);
            }
        }
    }

    public void onTurnEnded(TurnEndedEvent event) {
        for (IBattleListener listener : this.listeners) {
            try {
                listener.onTurnEnded(event);
            }
            catch (Throwable ex) {
                Logger.logError((String)("onTurnEnded " + listener.getClass()), (Throwable)ex);
            }
        }
    }

    public void onBattleMessage(BattleMessageEvent event) {
        for (IBattleListener listener : this.listeners) {
            try {
                listener.onBattleMessage(event);
            }
            catch (Throwable ex) {
                Logger.logError((String)("onBattleMessage " + listener.getClass()), (Throwable)ex);
            }
        }
    }

    public void onBattleError(BattleErrorEvent event) {
        for (IBattleListener listener : this.listeners) {
            try {
                listener.onBattleError(event);
            }
            catch (Throwable ex) {
                Logger.logError((String)("onBattleError " + listener.getClass()), (Throwable)ex);
            }
        }
    }
}

