/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.core;

import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import net.sf.robocode.battle.BattleResultsTableModel;
import net.sf.robocode.battle.IBattleManager;
import net.sf.robocode.core.Container;
import net.sf.robocode.core.RobocodeMainBase;
import net.sf.robocode.host.ICpuManager;
import net.sf.robocode.host.IHostManager;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.recording.BattleRecordFormat;
import net.sf.robocode.recording.IRecordManager;
import net.sf.robocode.repository.IRepositoryManager;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.sound.ISoundManager;
import net.sf.robocode.ui.IWindowManager;
import net.sf.robocode.version.IVersionManager;
import robocode.control.events.BattleAdaptor;
import robocode.control.events.BattleCompletedEvent;
import robocode.control.events.BattleErrorEvent;
import robocode.control.events.BattleMessageEvent;
import robocode.control.events.BattleStartedEvent;
import robocode.control.events.IBattleListener;

public final class RobocodeMain
extends RobocodeMainBase {
    private final Setup setup;
    private final BattleObserver battleObserver = new BattleObserver();
    private final ISettingsManager properties;
    private final IHostManager hostManager;
    private final IWindowManager windowManager;
    private final ISoundManager soundManager;
    private final IBattleManager battleManager;
    private final IRecordManager recordManager;
    private final IVersionManager versionManager;

    public RobocodeMain(ISettingsManager properties, IHostManager hostManager, IWindowManager windowManager, ISoundManager soundManager, IBattleManager battleManager, IRecordManager recordManager, IVersionManager versionManager) {
        this.setup = new Setup();
        this.properties = properties;
        this.hostManager = hostManager;
        this.windowManager = windowManager;
        this.soundManager = soundManager;
        this.battleManager = battleManager;
        this.recordManager = recordManager;
        this.versionManager = versionManager;
    }

    public RobocodeMain(ISettingsManager properties, IHostManager hostManager, IBattleManager battleManager, IRecordManager recordManager, IVersionManager versionManager) {
        this.setup = new Setup();
        this.properties = properties;
        this.hostManager = hostManager;
        this.windowManager = null;
        this.soundManager = null;
        this.battleManager = battleManager;
        this.recordManager = recordManager;
        this.versionManager = versionManager;
    }

    public void run() {
        try {
            boolean enableCLIRecording;
            this.hostManager.initSecurity();
            if (this.windowManager.isGUIEnabled()) {
                this.windowManager.setLookAndFeel();
            }
            this.properties.setOptionsBattleDesiredTPS(this.setup.tps);
            this.battleManager.addListener((IBattleListener)this.battleObserver);
            if (this.windowManager.isGUIEnabled()) {
                if (!this.setup.minimize && this.setup.battleFilename == null && this.soundManager != null) {
                    this.soundManager.playThemeMusic();
                    this.windowManager.showSplashScreen();
                }
                this.windowManager.showRobocodeFrame(true, this.setup.minimize);
                if (this.setup.battleFilename == null && this.versionManager.isLastRunVersionChanged()) {
                    this.properties.saveProperties();
                    this.windowManager.runIntroBattle();
                }
            }
            boolean bl = enableCLIRecording = this.setup.recordFilename != null || this.setup.recordXmlFilename != null;
            if (this.setup.battleFilename != null) {
                if (this.setup.replayFilename != null) {
                    System.err.println("You cannot run both a battle and replay a battle record in the same time.");
                    System.exit(8);
                }
                this.setup.exitOnComplete = true;
                this.battleManager.setBattleFilename(this.setup.battleFilename);
                if (new File(this.battleManager.getBattleFilename()).exists()) {
                    this.battleManager.startNewBattle(this.battleManager.loadBattleProperties(), false, enableCLIRecording);
                } else {
                    System.err.println("The specified battle file '" + this.setup.battleFilename + "' was not found");
                    System.exit(8);
                }
            } else if (this.setup.replayFilename != null) {
                this.setup.exitOnComplete = true;
                this.recordManager.loadRecord(this.setup.replayFilename, BattleRecordFormat.BINARY_ZIP);
                if (new File(this.setup.replayFilename).exists()) {
                    this.battleManager.replay();
                } else {
                    System.err.println("The specified battle record file '" + this.setup.replayFilename + "' was not found");
                    System.exit(8);
                }
            }
        }
        catch (Throwable e) {
            Logger.logError((Throwable)e);
        }
    }

    public void loadSetup(String[] args) {
        String nosecMessage = "Robocode is running without a security manager.\nRobots have full access to your system.\nYou should only run robots which you trust!";
        String exMessage = "Robocode is running in experimental mode.\nRobots have access to their IRobotPeer interfaces.\nYou should only run robots which you trust!";
        if (System.getProperty("NOSECURITY", "false").equals("true")) {
            Logger.logMessage((String)"Robocode is running without a security manager.\nRobots have full access to your system.\nYou should only run robots which you trust!");
        }
        if (System.getProperty("EXPERIMENTAL", "false").equals("true")) {
            Logger.logMessage((String)"Robocode is running in experimental mode.\nRobots have access to their IRobotPeer interfaces.\nYou should only run robots which you trust!");
        }
        if (this.windowManager != null) {
            if (System.getProperty("NOSECURITY", "false").equals("true")) {
                this.windowManager.messageWarning("Robocode is running without a security manager.\nRobots have full access to your system.\nYou should only run robots which you trust!");
            }
            if (System.getProperty("EXPERIMENTAL", "false").equals("true")) {
                this.windowManager.messageWarning("Robocode is running in experimental mode.\nRobots have access to their IRobotPeer interfaces.\nYou should only run robots which you trust!");
            }
        }
        this.setup.tps = this.properties.getOptionsBattleDesiredTPS();
        System.setProperty("java.awt.headless", "false");
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-cwd") && i < args.length + 1) {
                this.changeDirectory(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equals("-battle") && i < args.length + 1) {
                this.setup.battleFilename = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-record") && i < args.length + 1) {
                this.setup.recordFilename = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-recordXML") && i < args.length + 1) {
                this.setup.recordXmlFilename = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-replay") && i < args.length + 1) {
                this.setup.replayFilename = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-results") && i < args.length + 1) {
                this.setup.resultsFilename = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-tps") && i < args.length + 1) {
                this.setup.tps = Integer.parseInt(args[i + 1]);
                if (this.setup.tps < 1) {
                    Logger.logError((String)"tps must be > 0");
                    System.exit(8);
                }
                ++i;
                continue;
            }
            if (args[i].equals("-minimize")) {
                this.setup.minimize = true;
                continue;
            }
            if (args[i].equals("-nodisplay")) {
                if (this.windowManager != null) {
                    this.windowManager.setEnableGUI(false);
                }
                if (this.soundManager != null) {
                    this.soundManager.setEnableSound(false);
                }
                this.setup.tps = 10000;
                continue;
            }
            if (args[i].equals("-nosound")) {
                if (this.soundManager == null) continue;
                this.soundManager.setEnableSound(false);
                continue;
            }
            if (args[i].equals("-?") || args[i].equals("-help")) {
                this.printUsage();
                System.exit(0);
                continue;
            }
            Logger.logError((String)("Not understood: " + args[i]));
            this.printUsage();
            System.exit(8);
        }
        File robotsDir = FileUtil.getRobotsDir();
        if (robotsDir == null) {
            System.err.println("No valid robot directory is specified");
            System.exit(8);
        } else if (!robotsDir.exists() || !robotsDir.isDirectory()) {
            System.err.println('\'' + robotsDir.getAbsolutePath() + "' is not a valid robot directory");
            System.exit(8);
        }
        Toolkit.getDefaultToolkit();
    }

    private void changeDirectory(String robocodeDir) {
        try {
            FileUtil.setCwd((File)new File(robocodeDir));
        }
        catch (IOException e) {
            System.err.println(robocodeDir + " is not a valid directory to start Robocode in.");
            System.exit(8);
        }
    }

    private void printUsage() {
        System.out.print("Usage: robocode [-?] [-help] [-cwd path] [-battle filename [-results filename]\n                [-record filename] [-recordXML filename] [-replay filename]\n                [-tps tps] [-minimize] [-nodisplay] [-nosound]\n\nwhere options include:\n  -? or -help                Prints out the command line usage of Robocode\n  -cwd <path>                Change the current working directory\n  -battle <battle file>      Run the battle specified in a battle file\n  -results <results file>    Save results to the specified text file\n  -record <bin record file>  Record the battle into the specified file as binary\n  -recordXML <xml rec file>  Record the battle into the specified file as XML\n  -replay <record file>      Replay the specified battle record\n  -tps <tps>                 Set the TPS > 0 (Turns Per Second)\n  -minimize                  Run minimized when Robocode starts\n  -nodisplay                 Run with the display / GUI disabled\n  -nosound                   Run with sound disabled\n\nJava Properties include:\n  -DWORKINGDIRECTORY=<path>  Set the working directory\n  -DROBOTPATH=<path>         Set the robots directory (default is 'robots')\n  -DBATTLEPATH=<path>        Set the battles directory (default is 'battles')\n  -DNOSECURITY=true|false    Enable/disable Robocode's security manager\n  -Ddebug=true|false         Enable/disable debugging used for preventing\n                             robot timeouts and skipped turns, and allows an\n                             an unlimited painting buffer when debugging robots\n  -DEXPERIMENTAL=true|false  Enable/disable access to peer in robot interfaces\n  -DPARALLEL=true|false      Enable/disable parallel processing of robots turns\n  -DRANDOMSEED=<long number> Set seed for deterministic behavior of random\n                             numbers\n");
    }

    private void printResultsData(BattleCompletedEvent event) {
        if (this.setup.resultsFilename == null && (!this.setup.exitOnComplete || this.windowManager.isGUIEnabled())) {
            return;
        }
        PrintStream out = null;
        FileOutputStream fos = null;
        if (this.setup.resultsFilename == null) {
            out = Logger.realOut;
        } else {
            File f = new File(this.setup.resultsFilename);
            try {
                fos = new FileOutputStream(f);
                out = new PrintStream(fos);
            }
            catch (IOException e) {
                Logger.logError((Throwable)e);
            }
        }
        BattleResultsTableModel resultsTable = new BattleResultsTableModel(event.getSortedResults(), event.getBattleRules().getNumRounds());
        if (out != null) {
            resultsTable.print(out);
            out.close();
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public void cleanup() {
        IWindowManager windowManager = Container.getComponent(IWindowManager.class);
        if (windowManager != null) {
            windowManager.cleanup();
        }
        Container.getComponent(IBattleManager.class).cleanup();
        Container.getComponent(IHostManager.class).cleanup();
    }

    public void initForRobocodeEngine(IBattleListener listener) {
        IWindowManager windowManager = Container.getComponent(IWindowManager.class);
        if (windowManager != null) {
            windowManager.setSlave(true);
            windowManager.setEnableGUI(false);
        }
        Container.getComponent(IHostManager.class).initSecurity();
        if (listener != null) {
            Container.getComponent(IBattleManager.class).addListener(listener);
        }
        Container.getComponent(ICpuManager.class).getCpuConstant();
        Container.getComponent(IRepositoryManager.class).reload(this.versionManager.isLastRunVersionChanged());
    }

    private class BattleObserver
    extends BattleAdaptor {
        boolean isReplay;

        private BattleObserver() {
        }

        public void onBattleStarted(BattleStartedEvent event) {
            this.isReplay = event.isReplay();
        }

        public void onBattleCompleted(BattleCompletedEvent event) {
            if (!this.isReplay) {
                RobocodeMain.this.printResultsData(event);
            }
            if (((RobocodeMain)RobocodeMain.this).setup.recordFilename != null) {
                RobocodeMain.this.recordManager.saveRecord(((RobocodeMain)RobocodeMain.this).setup.recordFilename, BattleRecordFormat.BINARY_ZIP);
            }
            if (((RobocodeMain)RobocodeMain.this).setup.recordXmlFilename != null) {
                RobocodeMain.this.recordManager.saveRecord(((RobocodeMain)RobocodeMain.this).setup.recordXmlFilename, BattleRecordFormat.XML);
            }
        }

        public void onBattleMessage(BattleMessageEvent event) {
            Logger.realOut.println(event.getMessage());
        }

        public void onBattleError(BattleErrorEvent event) {
            Logger.realErr.println(event.getError());
        }
    }

    private class Setup {
        boolean minimize;
        boolean exitOnComplete;
        String battleFilename;
        String recordFilename;
        String recordXmlFilename;
        String replayFilename;
        String resultsFilename;
        int tps;

        private Setup() {
        }
    }
}

