/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.io;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarFile;
import net.sf.robocode.io.Logger;

public class URLJarCollector {
    static Object factory;
    static HashMap<?, ?> fileCache;
    static HashMap<?, ?> urlCache;
    static Field jarFileURL;
    static boolean sunJVM;
    static boolean enabled;
    static Set<URL> urlToClean;

    public static synchronized URLConnection openConnection(URL url) throws IOException {
        URLConnection urlConnection = url.openConnection();
        if (sunJVM) {
            URLJarCollector.registerConnection(urlConnection);
            urlConnection.setUseCaches(true);
        } else {
            urlConnection.setUseCaches(false);
        }
        return urlConnection;
    }

    public static synchronized void enableGc(boolean enabled) {
        URLJarCollector.enabled = enabled;
    }

    public static synchronized void gc() {
        if (sunJVM) {
            if (enabled) {
                for (URL url : urlToClean) {
                    URLJarCollector.closeJarURLConnection(url);
                }
                urlToClean.clear();
            } else {
                Iterator<?> it = fileCache.keySet().iterator();
                while (it.hasNext()) {
                    Object urlJarFile = it.next();
                    JarFile jarFile = (JarFile)fileCache.get(urlJarFile);
                    String filename = jarFile.getName();
                    if (!(filename = filename.substring(filename.lastIndexOf(File.separatorChar) + 1).toLowerCase()).startsWith("jar_cache")) continue;
                    it.remove();
                    urlCache.remove(jarFile);
                }
            }
        }
    }

    private static void registerConnection(URLConnection conn) {
        String cl;
        if (conn != null && (cl = conn.getClass().getName()).equals("sun.net.www.protocol.jar.JarURLConnection")) {
            try {
                URL url = (URL)jarFileURL.get(conn);
                if (!urlToClean.contains(url)) {
                    urlToClean.add(url);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static void closeJarURLConnection(URL url) {
        JarFile jarFile;
        if (url != null && (jarFile = (JarFile)fileCache.get(url)) != null) {
            fileCache.remove(url);
            urlCache.remove(jarFile);
            try {
                jarFile.close();
            }
            catch (IOException e) {
                Logger.logError((Throwable)e);
            }
        }
    }

    public static void dump() {
        if (sunJVM) {
            for (Object u : fileCache.keySet()) {
                JarFile o = (JarFile)fileCache.get(u);
                Logger.logMessage((String)("remain " + u.toString() + " " + o.getName()));
            }
            Logger.logMessage((String)("count " + fileCache.size()));
        }
    }

    static {
        urlToClean = new HashSet<URL>();
        try {
            Class<?> jarConn = ClassLoader.getSystemClassLoader().loadClass("sun.net.www.protocol.jar.JarURLConnection");
            Field factoryF = jarConn.getDeclaredField("factory");
            factoryF.setAccessible(true);
            factory = factoryF.get(null);
            Class<?> jarFactory = ClassLoader.getSystemClassLoader().loadClass("sun.net.www.protocol.jar.JarFileFactory");
            Field fileCacheF = jarFactory.getDeclaredField("fileCache");
            fileCacheF.setAccessible(true);
            fileCache = (HashMap)fileCacheF.get(null);
            Field urlCacheF = jarFactory.getDeclaredField("urlCache");
            urlCacheF.setAccessible(true);
            urlCache = (HashMap)urlCacheF.get(null);
            Class<?> jarURLConnection = ClassLoader.getSystemClassLoader().loadClass("sun.net.www.protocol.jar.JarURLConnection");
            jarFileURL = jarURLConnection.getDeclaredField("jarFileURL");
            jarFileURL.setAccessible(true);
            sunJVM = true;
        }
        catch (ClassNotFoundException ignore) {
            Logger.logError((Throwable)ignore);
        }
        catch (NoSuchFieldException ignore) {
            Logger.logError((Throwable)ignore);
        }
        catch (IllegalAccessException ignore) {
            Logger.logError((Throwable)ignore);
        }
    }
}

