/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.settings;

import java.awt.RenderingHints;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.settings.ISettingsListener;
import net.sf.robocode.settings.ISettingsManager;

public class SettingsManager
implements ISettingsManager {
    private static final String DEFAULT_FILE_GUNSHOT_SFX = "/net/sf/robocode/sound/sounds/zap.wav";
    private static final String DEFAULT_FILE_ROBOT_COLLISION_SFX = "/net/sf/robocode/sound/sounds/13831_adcbicycle_22.wav";
    private static final String DEFAULT_FILE_WALL_COLLISION_SFX = "/net/sf/robocode/sound/sounds/13831_adcbicycle_22.wav";
    private static final String DEFAULT_FILE_ROBOT_DEATH_SFX = "/net/sf/robocode/sound/sounds/explode.wav";
    private static final String DEFAULT_FILE_BULLET_HITS_ROBOT_SFX = "/net/sf/robocode/sound/sounds/shellhit.wav";
    private static final String DEFAULT_FILE_BULLET_HITS_BULLET_SFX = "/net/sf/robocode/sound/sounds/shellhit.wav";
    private boolean optionsViewRobotEnergy = true;
    private boolean optionsViewRobotNames = true;
    private boolean optionsViewScanArcs = false;
    private boolean optionsViewExplosions = true;
    private boolean optionsViewGround = true;
    private boolean optionsViewExplosionDebris = true;
    private boolean optionsViewTPS = true;
    private boolean optionsViewFPS = true;
    private int optionsRenderingAntialiasing = 0;
    private int optionsRenderingTextAntialiasing = 0;
    private int optionsRenderingMethod = 0;
    private int optionsRenderingNoBuffers = 2;
    private int optionsBattleDesiredTPS = 30;
    private boolean optionsRenderingBufferImages = true;
    private boolean optionsRenderingForceBulletColor = false;
    private boolean optionsSoundEnableSound = false;
    private boolean optionsSoundEnableGunshot = true;
    private boolean optionsSoundEnableBulletHit = true;
    private boolean optionsSoundEnableRobotDeath = true;
    private boolean optionsSoundEnableWallCollision = true;
    private boolean optionsSoundEnableRobotCollision = true;
    private String optionsSoundMixer = "DirectAudioDevice";
    private boolean optionsSoundEnableMixerVolume = true;
    private boolean optionsSoundEnableMixerPan = true;
    private String optionsDevelopmentPath = "";
    private boolean optionsCommonShowResults = true;
    private boolean optionsCommonAppendWhenSavingResults = true;
    private boolean optionsCommonDontHideRankings = true;
    private boolean optionsCommonEnableReplayRecording = false;
    private boolean optionsTeamShowTeamRobots = false;
    private String fileThemeMusic = "";
    private String fileBackgroundMusic = "";
    private String fileEndOfBattleMusic = "";
    private String fileGunshotSfx = "/net/sf/robocode/sound/sounds/zap.wav";
    private String fileRobotCollisionSfx = "/net/sf/robocode/sound/sounds/13831_adcbicycle_22.wav";
    private String fileWallCollisionSfx = "/net/sf/robocode/sound/sounds/13831_adcbicycle_22.wav";
    private String fileRobotDeathSfx = "/net/sf/robocode/sound/sounds/explode.wav";
    private String fileBulletHitsRobotSfx = "/net/sf/robocode/sound/sounds/shellhit.wav";
    private String fileBulletHitsBulletSfx = "/net/sf/robocode/sound/sounds/shellhit.wav";
    private String lastRunVersion = "";
    private Date versionChecked;
    private long robotFilesystemQuota = 200000L;
    private long consoleQuota = 8192L;
    private long cpuConstant = -1L;
    private int numberOfRounds = 10;
    private final Properties props = new SortedProperties();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy H:mm:ss");
    private final RenderingHints renderingHints = new RenderingHints(new HashMap());
    private final List<ISettingsListener> listeners = new ArrayList<ISettingsListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsManager() {
        FileInputStream in = null;
        try {
            in = new FileInputStream(FileUtil.getRobocodeConfigFile());
            this.load(in);
        }
        catch (FileNotFoundException e) {
            Logger.logError((String)("No " + FileUtil.getRobocodeConfigFile().getName() + ", using defaults."));
        }
        catch (IOException e) {
            Logger.logError((String)("IO Exception reading " + FileUtil.getRobocodeConfigFile().getName() + ": " + e));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProperties() {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(FileUtil.getRobocodeConfigFile());
            this.store(out, "Robocode Properties");
        }
        catch (IOException e) {
            Logger.logError((Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean getOptionsViewRobotNames() {
        return this.optionsViewRobotNames;
    }

    public void setOptionsViewRobotNames(boolean optionsViewRobotNames) {
        this.optionsViewRobotNames = optionsViewRobotNames;
        this.props.setProperty("robocode.options.view.robotNames", "" + optionsViewRobotNames);
    }

    public boolean getOptionsViewScanArcs() {
        return this.optionsViewScanArcs;
    }

    public void setOptionsViewScanArcs(boolean optionsViewScanArcs) {
        this.optionsViewScanArcs = optionsViewScanArcs;
        this.props.setProperty("robocode.options.view.scanArcs", "" + optionsViewScanArcs);
    }

    public boolean getOptionsViewRobotEnergy() {
        return this.optionsViewRobotEnergy;
    }

    public void setOptionsViewRobotEnergy(boolean optionsViewRobotEnergy) {
        this.optionsViewRobotEnergy = optionsViewRobotEnergy;
        this.props.setProperty("robocode.options.view.robotEnergy", "" + optionsViewRobotEnergy);
    }

    public boolean getOptionsViewGround() {
        return this.optionsViewGround;
    }

    public void setOptionsViewGround(boolean optionsViewGround) {
        this.optionsViewGround = optionsViewGround;
        this.props.setProperty("robocode.options.view.ground", "" + optionsViewGround);
    }

    public boolean getOptionsViewTPS() {
        return this.optionsViewTPS;
    }

    public void setOptionsViewTPS(boolean optionsViewTPS) {
        this.optionsViewTPS = optionsViewTPS;
        this.props.setProperty("robocode.options.view.TPS", "" + optionsViewTPS);
    }

    public boolean getOptionsViewFPS() {
        return this.optionsViewFPS;
    }

    public void setOptionsViewFPS(boolean optionsViewFPS) {
        this.optionsViewFPS = optionsViewFPS;
        this.props.setProperty("robocode.options.view.FPS", "" + optionsViewFPS);
    }

    public boolean getOptionsViewExplosions() {
        return this.optionsViewExplosions;
    }

    public void setOptionsViewExplosions(boolean optionsViewExplosions) {
        this.optionsViewExplosions = optionsViewExplosions;
        this.props.setProperty("robocode.options.view.explosions", "" + optionsViewExplosions);
    }

    public boolean getOptionsViewExplosionDebris() {
        return this.optionsViewExplosionDebris;
    }

    public void setOptionsViewExplosionDebris(boolean optionsViewExplosionDebris) {
        this.optionsViewExplosionDebris = optionsViewExplosionDebris;
        this.props.setProperty("robocode.options.view.explosionDebris", "" + optionsViewExplosionDebris);
    }

    public int getOptionsRenderingAntialiasing() {
        return this.optionsRenderingAntialiasing;
    }

    public void setOptionsRenderingAntialiasing(int optionsRenderingAntialiasing) {
        Object value;
        this.optionsRenderingAntialiasing = optionsRenderingAntialiasing;
        this.props.setProperty("robocode.options.rendering.antialiasing", "" + optionsRenderingAntialiasing);
        switch (optionsRenderingAntialiasing) {
            case 1: {
                value = RenderingHints.VALUE_ANTIALIAS_ON;
                break;
            }
            case 2: {
                value = RenderingHints.VALUE_ANTIALIAS_OFF;
                break;
            }
            default: {
                value = RenderingHints.VALUE_ANTIALIAS_DEFAULT;
            }
        }
        this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, value);
    }

    public int getOptionsRenderingTextAntialiasing() {
        return this.optionsRenderingTextAntialiasing;
    }

    public void setOptionsRenderingTextAntialiasing(int optionsRenderingTextAntialiasing) {
        Object value;
        this.optionsRenderingTextAntialiasing = optionsRenderingTextAntialiasing;
        this.props.setProperty("robocode.options.rendering.text.antialiasing", "" + optionsRenderingTextAntialiasing);
        switch (optionsRenderingTextAntialiasing) {
            case 1: {
                value = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
                break;
            }
            case 2: {
                value = RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
                break;
            }
            default: {
                value = RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
            }
        }
        this.renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, value);
    }

    public int getOptionsRenderingMethod() {
        return this.optionsRenderingMethod;
    }

    public void setOptionsRenderingMethod(int optionsRenderingMethod) {
        Object value;
        this.optionsRenderingMethod = optionsRenderingMethod;
        this.props.setProperty("robocode.options.rendering.method", "" + optionsRenderingMethod);
        switch (optionsRenderingMethod) {
            case 1: {
                value = RenderingHints.VALUE_RENDER_QUALITY;
                break;
            }
            case 2: {
                value = RenderingHints.VALUE_RENDER_SPEED;
                break;
            }
            default: {
                value = RenderingHints.VALUE_RENDER_DEFAULT;
            }
        }
        this.renderingHints.put(RenderingHints.KEY_RENDERING, value);
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public int getOptionsRenderingNoBuffers() {
        return this.optionsRenderingNoBuffers;
    }

    public void setOptionsRenderingNoBuffers(int optionsRenderingNoBuffers) {
        this.optionsRenderingNoBuffers = optionsRenderingNoBuffers;
        this.props.setProperty("robocode.options.rendering.noBuffers", "" + optionsRenderingNoBuffers);
    }

    public boolean getOptionsRenderingBufferImages() {
        return this.optionsRenderingBufferImages;
    }

    public void setOptionsRenderingBufferImages(boolean optionsRenderingBufferImages) {
        this.optionsRenderingBufferImages = optionsRenderingBufferImages;
        this.props.setProperty("robocode.options.rendering.bufferImages", "" + optionsRenderingBufferImages);
    }

    public boolean getOptionsRenderingForceBulletColor() {
        return this.optionsRenderingForceBulletColor;
    }

    public void setOptionsRenderingForceBulletColor(boolean optionsRenderingForceBulletColor) {
        this.optionsRenderingForceBulletColor = optionsRenderingForceBulletColor;
        this.props.setProperty("robocode.options.rendering.forceBulletColor", "" + optionsRenderingForceBulletColor);
    }

    public int getOptionsBattleDesiredTPS() {
        return this.optionsBattleDesiredTPS;
    }

    public void setOptionsBattleDesiredTPS(int optionsBattleDesiredTPS) {
        this.optionsBattleDesiredTPS = optionsBattleDesiredTPS;
        this.props.setProperty("robocode.options.battle.desiredTPS", "" + optionsBattleDesiredTPS);
    }

    public boolean getOptionsSoundEnableSound() {
        return this.optionsSoundEnableSound;
    }

    public void setOptionsSoundEnableSound(boolean optionsSoundEnableSound) {
        this.optionsSoundEnableSound = optionsSoundEnableSound;
        this.props.setProperty("robocode.options.sound.enableSound", "" + optionsSoundEnableSound);
    }

    public boolean getOptionsSoundEnableGunshot() {
        return this.optionsSoundEnableGunshot;
    }

    public void setOptionsSoundEnableGunshot(boolean optionsSoundEnableGunshot) {
        this.optionsSoundEnableGunshot = optionsSoundEnableGunshot;
        this.props.setProperty("robocode.options.sound.enableGunshot", "" + optionsSoundEnableGunshot);
    }

    public boolean getOptionsSoundEnableBulletHit() {
        return this.optionsSoundEnableBulletHit;
    }

    public void setOptionsSoundEnableBulletHit(boolean optionsSoundEnableBulletHit) {
        this.optionsSoundEnableBulletHit = optionsSoundEnableBulletHit;
        this.props.setProperty("robocode.options.sound.enableBulletHit", "" + optionsSoundEnableBulletHit);
    }

    public boolean getOptionsSoundEnableRobotDeath() {
        return this.optionsSoundEnableRobotDeath;
    }

    public void setOptionsSoundEnableRobotDeath(boolean optionsSoundEnableRobotDeath) {
        this.optionsSoundEnableRobotDeath = optionsSoundEnableRobotDeath;
        this.props.setProperty("robocode.options.sound.enableRobotDeath", "" + optionsSoundEnableRobotDeath);
    }

    public boolean getOptionsSoundEnableWallCollision() {
        return this.optionsSoundEnableWallCollision;
    }

    public void setOptionsSoundEnableWallCollision(boolean optionsSoundEnableWallCollision) {
        this.optionsSoundEnableWallCollision = optionsSoundEnableWallCollision;
        this.props.setProperty("robocode.options.sound.enableWallCollision", "" + optionsSoundEnableWallCollision);
    }

    public boolean getOptionsSoundEnableRobotCollision() {
        return this.optionsSoundEnableRobotCollision;
    }

    public void setOptionsSoundEnableRobotCollision(boolean optionsSoundEnableRobotCollision) {
        this.optionsSoundEnableRobotCollision = optionsSoundEnableRobotCollision;
        this.props.setProperty("robocode.options.sound.enableRobotCollision", "" + optionsSoundEnableRobotCollision);
    }

    public boolean getOptionsSoundEnableMixerVolume() {
        return this.optionsSoundEnableMixerVolume;
    }

    public void setOptionsSoundMixer(String optionsSoundMixer) {
        this.optionsSoundMixer = optionsSoundMixer;
        this.props.setProperty("robocode.options.sound.mixer", optionsSoundMixer);
    }

    public String getOptionsSoundMixer() {
        return this.optionsSoundMixer;
    }

    public void setOptionsSoundEnableMixerVolume(boolean optionsSoundEnableMixerVolume) {
        this.optionsSoundEnableMixerVolume = optionsSoundEnableMixerVolume;
        this.props.setProperty("robocode.options.sound.enableMixerVolume", "" + optionsSoundEnableMixerVolume);
    }

    public boolean getOptionsSoundEnableMixerPan() {
        return this.optionsSoundEnableMixerPan;
    }

    public void setOptionsSoundEnableMixerPan(boolean optionsSoundEnableMixerPan) {
        this.optionsSoundEnableMixerPan = optionsSoundEnableMixerPan;
        this.props.setProperty("robocode.options.sound.enableMixerPan", "" + optionsSoundEnableMixerPan);
    }

    public boolean getOptionsTeamShowTeamRobots() {
        return this.optionsTeamShowTeamRobots;
    }

    public void setOptionsTeamShowTeamRobots(boolean optionsTeamShowTeamRobots) {
        this.optionsTeamShowTeamRobots = optionsTeamShowTeamRobots;
        this.props.setProperty("robocode.options.team.showTeamRobots", "" + optionsTeamShowTeamRobots);
    }

    public String getFileThemeMusic() {
        return this.fileThemeMusic;
    }

    public String getFileBackgroundMusic() {
        return this.fileBackgroundMusic;
    }

    public String getFileEndOfBattleMusic() {
        return this.fileEndOfBattleMusic;
    }

    public String getFileGunshotSfx() {
        return this.fileGunshotSfx;
    }

    public String getBulletHitsRobotSfx() {
        return this.fileBulletHitsRobotSfx;
    }

    public String getBulletHitsBulletSfx() {
        return this.fileBulletHitsBulletSfx;
    }

    public String getRobotDeathSfx() {
        return this.fileRobotDeathSfx;
    }

    public String getRobotCollisionSfx() {
        return this.fileRobotCollisionSfx;
    }

    public String getWallCollisionSfx() {
        return this.fileWallCollisionSfx;
    }

    public Date getVersionChecked() {
        return this.versionChecked != null ? (Date)this.versionChecked.clone() : null;
    }

    public void setVersionChecked(Date versionChecked) {
        this.versionChecked = versionChecked != null ? (Date)versionChecked.clone() : null;
        this.props.setProperty("robocode.versionchecked", this.dateFormat.format(new Date()));
    }

    public long getRobotFilesystemQuota() {
        return this.robotFilesystemQuota;
    }

    public void setRobotFilesystemQuota(long robotFilesystemQuota) {
        this.robotFilesystemQuota = robotFilesystemQuota;
        this.props.setProperty("robocode.robot.filesystem.quota", "" + robotFilesystemQuota);
    }

    public long getConsoleQuota() {
        return this.consoleQuota;
    }

    public void setConsoleQuota(long consoleQuota) {
        this.consoleQuota = consoleQuota;
        this.props.setProperty("robocode.console.quota", "" + consoleQuota);
    }

    public long getCpuConstant() {
        return this.cpuConstant;
    }

    public void setCpuConstant(long cpuConstant) {
        this.cpuConstant = cpuConstant;
        this.props.setProperty("robocode.cpu.constant", "" + cpuConstant);
    }

    public String getOptionsDevelopmentPath() {
        return this.optionsDevelopmentPath;
    }

    public void setOptionsDevelopmentPath(String optionsDevelopmentPath) {
        this.optionsDevelopmentPath = optionsDevelopmentPath;
        this.props.setProperty("robocode.options.development.path", optionsDevelopmentPath);
    }

    public boolean getOptionsCommonShowResults() {
        return this.optionsCommonShowResults;
    }

    public void setOptionsCommonAppendWhenSavingResults(boolean enable) {
        this.optionsCommonAppendWhenSavingResults = enable;
        this.props.setProperty("robocode.options.common.appendWhenSavingResults", "" + enable);
    }

    public boolean getOptionsCommonAppendWhenSavingResults() {
        return this.optionsCommonAppendWhenSavingResults;
    }

    public void setOptionsCommonShowResults(boolean enable) {
        this.optionsCommonShowResults = enable;
        this.props.setProperty("robocode.options.common.showResults", "" + enable);
    }

    public boolean getOptionsCommonDontHideRankings() {
        return this.optionsCommonDontHideRankings;
    }

    public void setOptionsCommonDontHideRankings(boolean enable) {
        this.optionsCommonDontHideRankings = enable;
        this.props.setProperty("robocode.options.common.dontHideRankings", "" + enable);
    }

    public boolean getOptionsCommonEnableReplayRecording() {
        return this.optionsCommonEnableReplayRecording;
    }

    public void setOptionsCommonEnableReplayRecording(boolean enable) {
        this.optionsCommonEnableReplayRecording = enable;
        this.props.setProperty("robocode.options.common.enableReplayRecording", "" + enable);
    }

    public int getNumberOfRounds() {
        return this.numberOfRounds;
    }

    public void setNumberOfRounds(int numberOfRounds) {
        this.numberOfRounds = Math.max(1, numberOfRounds);
        this.props.setProperty("robocode.numberOfBattles", "" + this.numberOfRounds);
    }

    public void store(FileOutputStream out, String desc) throws IOException {
        this.props.store(out, desc);
    }

    public void load(FileInputStream in) throws IOException {
        this.props.load(in);
        this.optionsViewRobotNames = Boolean.valueOf(this.props.getProperty("robocode.options.view.robotNames", "true"));
        this.optionsViewScanArcs = Boolean.valueOf(this.props.getProperty("robocode.options.view.scanArcs", "false"));
        this.optionsViewRobotEnergy = Boolean.valueOf(this.props.getProperty("robocode.options.view.robotEnergy", "true"));
        this.optionsViewGround = Boolean.valueOf(this.props.getProperty("robocode.options.view.ground", "true"));
        this.optionsViewTPS = Boolean.valueOf(this.props.getProperty("robocode.options.view.TPS", "true"));
        this.optionsViewFPS = Boolean.valueOf(this.props.getProperty("robocode.options.view.FPS", "true"));
        this.optionsViewExplosions = Boolean.valueOf(this.props.getProperty("robocode.options.view.explosions", "true"));
        this.optionsViewExplosionDebris = Boolean.valueOf(this.props.getProperty("robocode.options.view.explosionDebris", "true"));
        this.optionsBattleDesiredTPS = Integer.parseInt(this.props.getProperty("robocode.options.battle.desiredTPS", "30"));
        this.setOptionsRenderingAntialiasing(Integer.parseInt(this.props.getProperty("robocode.options.rendering.antialiasing", "0")));
        this.setOptionsRenderingTextAntialiasing(Integer.parseInt(this.props.getProperty("robocode.options.rendering.text.antialiasing", "0")));
        this.setOptionsRenderingMethod(Integer.parseInt(this.props.getProperty("robocode.options.rendering.method", "0")));
        this.optionsRenderingNoBuffers = Integer.parseInt(this.props.getProperty("robocode.options.rendering.noBuffers", "2"));
        this.optionsRenderingBufferImages = Boolean.valueOf(this.props.getProperty("robocode.options.rendering.bufferImages", "true"));
        this.optionsRenderingForceBulletColor = Boolean.valueOf(this.props.getProperty("robocode.options.rendering.forceBulletColor", "false"));
        this.optionsSoundEnableSound = Boolean.valueOf(this.props.getProperty("robocode.options.sound.enableSound", "false"));
        this.optionsSoundEnableGunshot = Boolean.valueOf(this.props.getProperty("robocode.options.sound.enableGunshot", "true"));
        this.optionsSoundEnableBulletHit = Boolean.valueOf(this.props.getProperty("robocode.options.sound.enableBulletHit", "true"));
        this.optionsSoundEnableRobotDeath = Boolean.valueOf(this.props.getProperty("robocode.options.sound.enableRobotDeath", "true"));
        this.optionsSoundEnableRobotCollision = Boolean.valueOf(this.props.getProperty("robocode.options.sound.enableRobotCollision", "true"));
        this.optionsSoundEnableWallCollision = Boolean.valueOf(this.props.getProperty("robocode.options.sound.enableWallCollision", "true"));
        this.optionsSoundMixer = this.props.getProperty("robocode.options.sound.mixer", "DirectAudioDevice");
        this.optionsSoundEnableMixerVolume = Boolean.valueOf(this.props.getProperty("robocode.options.sound.enableMixerVolume", "true"));
        this.optionsSoundEnableMixerPan = Boolean.valueOf(this.props.getProperty("robocode.options.sound.enableMixerPan", "true"));
        this.optionsDevelopmentPath = this.props.getProperty("robocode.options.development.path", "");
        this.optionsCommonShowResults = Boolean.valueOf(this.props.getProperty("robocode.options.common.showResults", "true"));
        this.optionsCommonAppendWhenSavingResults = Boolean.valueOf(this.props.getProperty("robocode.options.common.appendWhenSavingResults", "true"));
        this.optionsCommonDontHideRankings = Boolean.valueOf(this.props.getProperty("robocode.options.common.dontHideRankings", "true"));
        this.optionsCommonEnableReplayRecording = Boolean.valueOf(this.props.getProperty("robocode.options.common.enableReplayRecording", "false"));
        this.optionsTeamShowTeamRobots = Boolean.valueOf(this.props.getProperty("robocode.options.team.showTeamRobots", "false"));
        this.fileThemeMusic = this.props.getProperty("robocode.file.music.theme");
        this.fileBackgroundMusic = this.props.getProperty("robocode.file.music.background");
        this.fileEndOfBattleMusic = this.props.getProperty("robocode.file.music.endOfBattle");
        this.fileGunshotSfx = this.props.getProperty("robocode.file.sfx.gunshot", DEFAULT_FILE_GUNSHOT_SFX);
        this.fileRobotCollisionSfx = this.props.getProperty("robocode.file.sfx.robotCollision", "/net/sf/robocode/sound/sounds/13831_adcbicycle_22.wav");
        this.fileWallCollisionSfx = this.props.getProperty("robocode.file.sfx.wallCollision", "/net/sf/robocode/sound/sounds/13831_adcbicycle_22.wav");
        this.fileRobotDeathSfx = this.props.getProperty("robocode.file.sfx.robotDeath", DEFAULT_FILE_ROBOT_DEATH_SFX);
        this.fileBulletHitsRobotSfx = this.props.getProperty("robocode.file.sfx.bulletHitsRobot", "/net/sf/robocode/sound/sounds/shellhit.wav");
        this.fileBulletHitsBulletSfx = this.props.getProperty("robocode.file.sfx.bulletHitsBullet", "/net/sf/robocode/sound/sounds/shellhit.wav");
        this.lastRunVersion = this.props.getProperty("robocode.version.lastrun", "");
        this.props.remove("robocode.cpu.constant.1000");
        try {
            this.versionChecked = this.dateFormat.parse(this.props.getProperty("robocode.versionchecked"));
        }
        catch (Exception e) {
            Logger.logMessage((String)"Initializing version check date.");
            this.setVersionChecked(new Date());
        }
        this.robotFilesystemQuota = Long.parseLong(this.props.getProperty("robocode.robot.filesystem.quota", "200000"));
        this.consoleQuota = Long.parseLong(this.props.getProperty("robocode.console.quota", "8192"));
        this.cpuConstant = Long.parseLong(this.props.getProperty("robocode.cpu.constant", "-1"));
        this.numberOfRounds = Integer.parseInt(this.props.getProperty("robocode.numberOfBattles", "10"));
    }

    public String getLastRunVersion() {
        return this.lastRunVersion;
    }

    public void setLastRunVersion(String lastRunVersion) {
        this.lastRunVersion = lastRunVersion;
        this.props.setProperty("robocode.version.lastrun", "" + lastRunVersion);
    }

    public void addPropertyListener(ISettingsListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyListener(ISettingsListener propertyListener) {
        this.listeners.remove(propertyListener);
    }

    private void notifyPropertyChanged(String name) {
        for (ISettingsListener listener : this.listeners) {
            try {
                listener.settingChanged(name);
            }
            catch (Exception e) {
                Logger.logError((Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SortedProperties
    extends Properties {
        private static final long serialVersionUID = 1L;

        private SortedProperties() {
        }

        @Override
        public Enumeration<Object> keys() {
            Enumeration<Object> keysEnum = super.keys();
            Vector<String> keyList = new Vector<String>();
            while (keysEnum.hasMoreElements()) {
                keyList.add((String)keysEnum.nextElement());
            }
            Collections.sort(keyList);
            return keyList.elements();
        }

        @Override
        public synchronized Object setProperty(String key, String value) {
            String old = super.getProperty(key, null);
            boolean notify = old == null && value != null || old != null && !old.equals(value);
            Object res = super.setProperty(key, value);
            if (notify) {
                SettingsManager.this.notifyPropertyChanged(key);
            }
            return res;
        }
    }
}

